image {
  aa 4 25 0.00005
%  aa 4 1 0.001
  show-aa true
  output cornell-box05.png
}

lightserver {
  shadows true
  direct-samples 8
  max-depth 9
  gi true 500000 100 0.2 0.05 315
  caustics true 0.72
}

camera {
  type pinhole
  eye    0 -205 50
  target 0 0 50
  up     0 0 1
  fov    45
%  resolution 640 480
  resolution 1024 768
}

shader {
  name Grey
  type diffuse
  diff 0.698039 0.698039 0.698039
}

shader {
  name Blue
  type diffuse
  diff 0.25098 0.25098 0.8
}

shader {
  name Red
  type diffuse
  diff 0.8 0.25098 0.25098
}

shader {
  name Water
  type glass
  ior 1.333
  color 0.84 0.94 0.99
}

shader {
  name Yellow
  type diffuse
  diff 1 0.909804 0.301961
}

shader {
  name DarkBlue
  type diffuse
  diff 0.270588 0.254902 0.478431
}

object {
  shader Grey
  type mesh
  name Floor	
  4 2
  v -59.999 -59.999 0.001    0 0 1    0 0
  v 60.001 -59.999 0.001    0 0 1    1 0
  v -59.999 60.001 0.001    0 0 1    0 1
  v 60.001 60.001 0.001    0 0 1    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Grey
  type mesh
  name BackWall	
  4 2
  v -60 60 0    0 -1 -7.62939e-008    0 0
  v 60 60 0    0 -1 -7.62939e-008    1 0
  v -60 60 100    0 -1 -7.62939e-008    0 1
  v 60 60 100    0 -1 -7.62939e-008    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Blue
  type mesh
  name RightWall
  4 2
  v 60 60 1.78814e-006    -1 1.58946e-007 -3.8147e-008    0 0
  v 60 -60 -1.78814e-006    -1 1.58946e-007 -3.8147e-008    1 0
  v 60 60 100    -1 1.58946e-007 -3.8147e-008    0 1
  v 60 -60 100    -1 1.58946e-007 -3.8147e-008    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Red
  type mesh
  name LeftWall
  4 2
  v -60 -60 0    1 3.17891e-008 -3.8147e-008    0 0
  v -60 60 0    1 3.17891e-008 -3.8147e-008    1 0
  v -60 -60 100    1 3.17891e-008 -3.8147e-008    0 1
  v -60 60 100    1 3.17891e-008 -3.8147e-008    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Grey
  type mesh
  name Ceiling
  4 2
  v -60 60 100    0 1.27157e-007 -1    0 0
  v 60 60 100    0 1.27157e-007 -1    1 0
  v -60 -60 100    0 1.27157e-007 -1    0 1
  v 60 -60 100    0 1.27157e-007 -1    1 1
  t 2 0 3
  t 1 3 0
}

light {
  type mesh
  name Light
  emit 960 960 960
  4 2
  v -2.5 2.5 99.99    0 0 -1    0 0
  v 2.5 2.5 99.99    0 0 -1    1 0
  v -2.5 -2.5 99.99    0 0 -1    0 1
  v 2.5 -2.5 99.99    0 0 -1    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Water
  type mesh
  name Water
  4225 8192
  v -60 -60 30.6855    0.206273 -0.131995 0.969551    0 0
  v -58.125 -60 30.2865    0.0374459 -0.198399 0.979406    0.015625 0
  v -56.25 -60 30.1857    -0.0835831 -0.319347 0.943944    0.03125 0
  v -54.375 -60 30.4895    -0.0758647 -0.228362 0.970616    0.046875 0
  v -52.5 -60 30.829    0.043568 0.0581497 0.997357    0.0625 0
  v -50.625 -60 30.8131    0.020731 0.227069 0.973658    0.078125 0
  v -48.75 -60 30.6871    -0.0906782 0.0662084 0.993677    0.09375 0
  v -46.875 -60 30.7061    -0.118929 -0.136266 0.983508    0.109375 0
  v -45 -60 31.0808    -0.0652999 -0.00712724 0.99784    0.125 0
  v -43.125 -60 31.3651    0.0518971 0.190993 0.980219    0.140625 0
  v -41.25 -60 31.0694    0.230084 0.139525 0.963117    0.15625 0
  v -39.375 -60 30.4089    0.0634495 -0.0108293 0.997926    0.171875 0
  v -37.5 -60 30.3825    -0.173289 -0.104764 0.979283    0.1875 0
  v -35.625 -60 30.9583    -0.123643 0.00189553 0.992325    0.203125 0
  v -33.75 -60 31.2157    0.0145369 0.130414 0.991353    0.21875 0
  v -31.875 -60 31.0372    0.112889 0.099199 0.988643    0.234375 0
  v -30 -60 30.7361    0.0107599 0.0516471 0.998607    0.25 0
  v -28.125 -60 30.8565    -0.15936 0.0667451 0.984962    0.265625 0
  v -26.25 -60 31.296    -0.148278 0.136158 0.979528    0.28125 0
  v -24.375 -60 31.621    0.0271942 0.215096 0.976214    0.296875 0
  v -22.5 -60 31.3759    0.10209 0.11701 0.98787    0.3125 0
  v -20.625 -60 30.9311    0.136893 -0.121819 0.983067    0.328125 0
  v -18.75 -60 30.6274    0.146163 -0.147445 0.978211    0.34375 0
  v -16.875 -60 30.5381    0.0781338 0.0289536 0.996522    0.359375 0
  v -15 -60 30.505    -0.144928 0.110415 0.983262    0.375 0
  v -13.125 -60 30.8874    -0.166788 0.0674956 0.98368    0.390625 0
  v -11.25 -60 31.1561    0.0279361 0.0439457 0.998643    0.40625 0
  v -9.375 -60 30.9089    0.0843354 0.00676852 0.996414    0.421875 0
  v -7.5 -60 30.7591    -0.102097 0.0213037 0.994546    0.4375 0
  v -5.625 -60 31.2412    -0.122835 0.135882 0.983081    0.453125 0
  v -3.75 -60 31.4549    0.0363787 0.183291 0.982385    0.46875 0
  v -1.875 -60 31.1813    0.185186 0.141057 0.972527    0.484375 0
  v -1.23138e-023 -60 30.7921    0.0605359 0.107816 0.992326    0.5 0
  v 1.875 -60 30.6918    -0.0286297 -0.0322886 0.999068    0.515625 0
  v 3.75 -60 30.6663    0.0323338 -0.0839485 0.995945    0.53125 0
  v 5.625 -60 30.7533    -0.110607 0.0678847 0.991543    0.546875 0
  v 7.5 -60 31.1244    -0.159585 0.115 0.980463    0.5625 0
  v 9.375 -60 31.3362    -0.00358357 0.11694 0.993133    0.578125 0
  v 11.25 -60 31.3647    -0.0280414 0.215041 0.976202    0.59375 0
  v 13.125 -60 31.471    0.0909813 0.159791 0.982949    0.609375 0
  v 15 -60 30.9119    0.262806 -0.080176 0.961512    0.625 0
  v 16.875 -60 30.2026    0.0892544 -0.187625 0.978177    0.640625 0
  v 18.75 -60 30.4048    -0.127723 -0.017038 0.991664    0.65625 0
  v 20.625 -60 30.9265    -0.1372 0.144777 0.979906    0.671875 0
  v 22.5 -60 31.0131    -0.0652906 0.040693 0.997036    0.6875 0
  v 24.375 -60 30.958    0.0313476 -0.0922931 0.995238    0.703125 0
  v 26.25 -60 30.9155    0.129926 -0.0390588 0.990754    0.71875 0
  v 28.125 -60 30.6769    0.162956 0.0959705 0.981955    0.734375 0
  v 30 -60 30.4907    -0.0600357 0.152108 0.986539    0.75 0
  v 31.875 -60 30.5946    -0.108918 -0.0694703 0.99162    0.765625 0
  v 33.75 -60 30.5432    0.0675728 -0.287133 0.955504    0.78125 0
  v 35.625 -60 30.3472    0.0838582 -0.231262 0.969271    0.796875 0
  v 37.5 -60 30.4068    0.0635354 -0.0773008 0.994981    0.8125 0
  v 39.375 -60 30.2339    0.0381802 -0.0583067 0.997568    0.828125 0
  v 41.25 -60 30.1926    -0.19816 -0.0671593 0.977866    0.84375 0
  v 43.125 -60 30.8048    -0.310954 -0.0338075 0.949824    0.859375 0
  v 45 -60 31.4914    0.0482444 0.0395569 0.998052    0.875 0
  v 46.875 -60 31.0907    0.206787 0.104118 0.97283    0.890625 0
  v 48.75 -60 30.7489    -0.0164877 0.156005 0.987619    0.90625 0
  v 50.625 -60 30.9973    -0.0622755 0.149774 0.986757    0.921875 0
  v 52.5 -60 30.9721    0.148792 0.0761211 0.985934    0.9375 0
  v 54.375 -60 30.5057    0.0376793 0.0613085 0.997407    0.953125 0
  v 56.25 -60 30.6871    -0.154654 0.11115 0.981696    0.96875 0
  v 58.125 -60 31.0683    -0.086849 0.094518 0.991728    0.984375 0
  v 60 -60 31.0219    0.0247042 0.0210999 0.999472    1 0
  v -60 -58.125 30.9406    0.121121 -0.183129 0.975599    0 0.015625
  v -58.125 -58.125 30.5419    0.0489052 -0.214965 0.975396    0.015625 0.015625
  v -56.25 -58.125 30.822    -0.0626792 -0.187729 0.980219    0.03125 0.015625
  v -54.375 -58.125 31.1197    -0.00058477 -0.085998 0.996295    0.046875 0.015625
  v -52.5 -58.125 30.9086    0.148907 0.042454 0.987939    0.0625 0.015625
  v -50.625 -58.125 30.3255    0.0904311 0.165937 0.981981    0.078125 0.015625
  v -48.75 -58.125 30.3489    -0.157415 0.177129 0.971517    0.09375 0.015625
  v -46.875 -58.125 30.9943    -0.175879 0.063263 0.982377    0.109375 0.015625
  v -45 -58.125 31.2835    0.00675377 0.0630445 0.997988    0.125 0.015625
  v -43.125 -58.125 30.9966    0.091141 0.193238 0.97691    0.140625 0.015625
  v -41.25 -58.125 30.7102    0.136424 0.184285 0.973359    0.15625 0.015625
  v -39.375 -58.125 30.3168    0.0173056 0.0277056 0.999466    0.171875 0.015625
  v -37.5 -58.125 30.6215    -0.168073 -0.10859 0.979775    0.1875 0.015625
  v -35.625 -58.125 31.0803    -0.0881276 -0.105815 0.990473    0.203125 0.015625
  v -33.75 -58.125 30.9628    0.0476058 -0.00412888 0.998858    0.21875 0.015625
  v -31.875 -58.125 30.8031    0.103062 0.0555765 0.993121    0.234375 0.015625
  v -30 -58.125 30.6402    0.0438726 0.0812793 0.995725    0.25 0.015625
  v -28.125 -58.125 30.7573    -0.117713 0.113419 0.986549    0.265625 0.015625
  v -26.25 -58.125 31.112    -0.123917 0.140652 0.982274    0.28125 0.015625
  v -24.375 -58.125 31.2041    0.0169793 0.188785 0.981872    0.296875 0.015625
  v -22.5 -58.125 30.9702    0.0270519 0.200658 0.979288    0.3125 0.015625
  v -20.625 -58.125 31.077    0.00767271 0.068208 0.997642    0.328125 0.015625
  v -18.75 -58.125 31.036    0.140349 -0.0838311 0.986547    0.34375 0.015625
  v -16.875 -58.125 30.5792    0.193528 -0.0429651 0.980153    0.359375 0.015625
  v -15 -58.125 30.2592    -0.0291959 0.121996 0.992101    0.375 0.015625
  v -13.125 -58.125 30.7472    -0.192735 0.197402 0.96119    0.390625 0.015625
  v -11.25 -58.125 31.0504    -0.0572641 0.160381 0.985393    0.40625 0.015625
  v -9.375 -58.125 30.8728    0.0553303 0.072364 0.995842    0.421875 0.015625
  v -7.5 -58.125 30.7931    -0.0254724 0.0301621 0.99922    0.4375 0.015625
  v -5.625 -58.125 31.0482    -0.0742857 0.10891 0.991272    0.453125 0.015625
  v -3.75 -58.125 31.0625    0.0159441 0.193206 0.981029    0.46875 0.015625
  v -1.875 -58.125 30.916    0.152907 0.1827 0.971205    0.484375 0.015625
  v -1.23138e-023 -58.125 30.5067    0.06721 0.173895 0.982468    0.5 0.015625
  v 1.875 -58.125 30.6479    -0.100495 0.123806 0.987205    0.515625 0.015625
  v 3.75 -58.125 30.9366    0.0100141 0.0229539 0.999686    0.53125 0.015625
  v 5.625 -58.125 30.6897    0.00278474 0.0539497 0.99854    0.546875 0.015625
  v 7.5 -58.125 30.8632    -0.147884 0.143125 0.978594    0.5625 0.015625
  v 9.375 -58.125 31.1975    -0.0298316 0.132849 0.990687    0.578125 0.015625
  v 11.25 -58.125 30.9778    0.0328539 0.147357 0.988538    0.59375 0.015625
  v 13.125 -58.125 31.0051    -0.00168112 0.182733 0.983161    0.609375 0.015625
  v 15 -58.125 30.9329    0.113739 0.0695312 0.991075    0.625 0.015625
  v 16.875 -58.125 30.6474    0.116194 -0.0959715 0.988579    0.640625 0.015625
  v 18.75 -58.125 30.602    -0.00843337 -0.0970527 0.995244    0.65625 0.015625
  v 20.625 -58.125 30.6146    -0.0958576 0.0237542 0.995112    0.671875 0.015625
  v 22.5 -58.125 30.8039    -0.125214 0.0596491 0.990335    0.6875 0.015625
  v 24.375 -58.125 31.1443    -0.0290754 -0.00380001 0.99957    0.703125 0.015625
  v 26.25 -58.125 31.0646    0.12824 -0.0334504 0.991179    0.71875 0.015625
  v 28.125 -58.125 30.6019    0.223693 -0.0212846 0.974427    0.734375 0.015625
  v 30 -58.125 30.09    0.000423325 0.0436978 0.999045    0.75 0.015625
  v 31.875 -58.125 30.5211    -0.228882 0.0320035 0.972928    0.765625 0.015625
  v 33.75 -58.125 31.0918    -0.0757163 -0.12275 0.989545    0.78125 0.015625
  v 35.625 -58.125 30.9407    0.115874 -0.239781 0.963887    0.796875 0.015625
  v 37.5 -58.125 30.5772    0.111552 -0.218985 0.969331    0.8125 0.015625
  v 39.375 -58.125 30.3302    0.0641404 -0.182707 0.981073    0.828125 0.015625
  v 41.25 -58.125 30.3287    -0.129135 -0.154557 0.979508    0.84375 0.015625
  v 43.125 -58.125 30.9185    -0.269594 -0.0953198 0.958245    0.859375 0.015625
  v 45 -58.125 31.4627    -0.0142287 -0.0280435 0.999505    0.875 0.015625
  v 46.875 -58.125 30.9273    0.238184 0.000831419 0.97122    0.890625 0.015625
  v 48.75 -58.125 30.4738    0.0707692 0.0305875 0.997024    0.90625 0.015625
  v 50.625 -58.125 30.6589    -0.0783545 0.0845916 0.99333    0.921875 0.015625
  v 52.5 -58.125 30.7934    0.0643013 0.0759457 0.995037    0.9375 0.015625
  v 54.375 -58.125 30.43    0.0734929 0.00906908 0.997254    0.953125 0.015625
  v 56.25 -58.125 30.4932    -0.11091 -0.00487291 0.993818    0.96875 0.015625
  v 58.125 -58.125 30.8186    -0.0963462 0.0572704 0.993699    0.984375 0.015625
  v 60 -58.125 30.9824    -0.0493579 0.098611 0.993901    1 0.015625
  v -60 -56.25 31.1089    -0.0907949 -0.0488165 0.994672    0 0.03125
  v -58.125 -56.25 31.1925    0.0385574 -0.138444 0.989619    0.015625 0.03125
  v -56.25 -56.25 31.2529    0.0719409 -0.0562212 0.995823    0.03125 0.03125
  v -54.375 -56.25 30.9101    0.110946 0.0645961 0.991725    0.046875 0.03125
  v -52.5 -56.25 30.4474    0.196333 0.0488976 0.979317    0.0625 0.03125
  v -50.625 -56.25 29.975    0.139725 0.0286066 0.989777    0.078125 0.03125
  v -48.75 -56.25 30.0492    -0.163623 0.086484 0.982725    0.09375 0.03125
  v -46.875 -56.25 30.7092    -0.207521 0.119688 0.970881    0.109375 0.03125
  v -45 -56.25 30.8672    0.071736 0.14437 0.98692    0.125 0.03125
  v -43.125 -56.25 30.394    0.161235 0.194306 0.9676    0.140625 0.03125
  v -41.25 -56.25 30.2026    0.0304249 0.20264 0.978781    0.15625 0.03125
  v -39.375 -56.25 30.2828    -0.153502 0.0901945 0.984023    0.171875 0.03125
  v -37.5 -56.25 30.9164    -0.265314 -0.0518444 0.962767    0.1875 0.03125
  v -35.625 -56.25 31.3569    -0.0698731 -0.129473 0.989118    0.203125 0.03125
  v -33.75 -56.25 31.1302    0.119326 -0.127447 0.984641    0.21875 0.03125
  v -31.875 -56.25 30.8943    0.15018 -0.0849563 0.985002    0.234375 0.03125
  v -30 -56.25 30.5491    0.114488 -0.0253517 0.993101    0.25 0.03125
  v -28.125 -56.25 30.4453    -0.0570058 0.0632919 0.996366    0.265625 0.03125
  v -26.25 -56.25 30.73    -0.122722 0.0963056 0.987757    0.28125 0.03125
  v -24.375 -56.25 30.8218    0.0327391 0.0619023 0.997545    0.296875 0.03125
  v -22.5 -56.25 30.5851    0.0439362 0.0814369 0.99571    0.3125 0.03125
  v -20.625 -56.25 30.7692    -0.108628 0.120123 0.986798    0.328125 0.03125
  v -18.75 -56.25 30.9925    0.00667485 0.0111 0.999916    0.34375 0.03125
  v -16.875 -56.25 30.6752    0.236628 -0.122823 0.963806    0.359375 0.03125
  v -15 -56.25 30.0813    0.157281 -0.0588593 0.985798    0.375 0.03125
  v -13.125 -56.25 30.1465    -0.109178 0.143233 0.983648    0.390625 0.03125
  v -11.25 -56.25 30.4402    -0.128515 0.205087 0.97027    0.40625 0.03125
  v -9.375 -56.25 30.5862    -0.061171 0.110553 0.991986    0.421875 0.03125
  v -7.5 -56.25 30.7236    -0.0343959 0.0227483 0.999149    0.4375 0.03125
  v -5.625 -56.25 30.8139    -0.00389857 0.0359173 0.999347    0.453125 0.03125
  v -3.75 -56.25 30.644    0.0473024 0.0446359 0.997883    0.46875 0.03125
  v -1.875 -56.25 30.5115    0.149651 0.0368869 0.988051    0.484375 0.03125
  v -1.23138e-023 -56.25 30.1209    0.0896607 0.0779045 0.992921    0.5 0.03125
  v 1.875 -56.25 30.2638    -0.157767 0.105208 0.981856    0.515625 0.03125
  v 3.75 -56.25 30.6587    -0.0727321 0.0273849 0.996976    0.53125 0.03125
  v 5.625 -56.25 30.4887    0.0881344 0.00496571 0.996096    0.546875 0.03125
  v 7.5 -56.25 30.5142    -0.0900525 0.122332 0.988395    0.5625 0.03125
  v 9.375 -56.25 30.831    -0.0967716 0.125667 0.987341    0.578125 0.03125
  v 11.25 -56.25 30.7367    0.0577693 0.0483884 0.997157    0.59375 0.03125
  v 13.125 -56.25 30.7205    0.0386399 0.119117 0.992128    0.609375 0.03125
  v 15 -56.25 30.7243    -0.00373626 0.170662 0.985322    0.625 0.03125
  v 16.875 -56.25 30.6983    0.00424659 0.0634985 0.997973    0.640625 0.03125
  v 18.75 -56.25 30.7082    0.000191119 -0.0285489 0.999592    0.65625 0.03125
  v 20.625 -56.25 30.6671    -0.0414276 -0.0512888 0.997824    0.671875 0.03125
  v 22.5 -56.25 30.8412    -0.0976646 -0.0230395 0.994953    0.6875 0.03125
  v 24.375 -56.25 31.1198    -0.0403034 0.0409741 0.998347    0.703125 0.03125
  v 26.25 -56.25 30.9895    0.0750592 0.0191047 0.996996    0.71875 0.03125
  v 28.125 -56.25 30.648    0.163352 -0.123915 0.978755    0.734375 0.03125
  v 30 -56.25 30.2475    0.0623579 -0.194577 0.978903    0.75 0.03125
  v 31.875 -56.25 30.585    -0.193187 -0.0700253 0.97866    0.765625 0.03125
  v 33.75 -56.25 31.1387    -0.153267 0.0496565 0.986936    0.78125 0.03125
  v 35.625 -56.25 31.2242    0.00475965 0.00728056 0.999962    0.796875 0.03125
  v 37.5 -56.25 31.0883    0.0479261 -0.156254 0.986553    0.8125 0.03125
  v 39.375 -56.25 30.9398    0.0591341 -0.282651 0.957398    0.828125 0.03125
  v 41.25 -56.25 30.873    -0.0363218 -0.239629 0.970185    0.84375 0.03125
  v 43.125 -56.25 31.2546    -0.139867 -0.0452197 0.989137    0.859375 0.03125
  v 45 -56.25 31.5456    0.0155172 0.099646 0.994902    0.875 0.03125
  v 46.875 -56.25 31.0192    0.199205 0.0359421 0.979299    0.890625 0.03125
  v 48.75 -56.25 30.6364    0.081857 -0.0618637 0.994722    0.90625 0.03125
  v 50.625 -56.25 30.6981    -0.0101311 -0.0447164 0.998948    0.921875 0.03125
  v 52.5 -56.25 30.7008    0.0501604 0.0220865 0.998497    0.9375 0.03125
  v 54.375 -56.25 30.4516    0.0122659 0.00185671 0.999923    0.953125 0.03125
  v 56.25 -56.25 30.6742    -0.116837 -0.0379072 0.992427    0.96875 0.03125
  v 58.125 -56.25 30.9757    -0.00176638 -0.0222913 0.99975    0.984375 0.03125
  v 60 -56.25 30.7116    0.0646009 0.0482718 0.996743    1 0.03125
  v -60 -54.375 31.0292    -0.0961725 0.101875 0.990138    0 0.046875
  v -58.125 -54.375 31.3778    0.0359829 0.117637 0.992405    0.015625 0.046875
  v -56.25 -54.375 31.0306    0.164238 0.166509 0.972266    0.03125 0.046875
  v -54.375 -54.375 30.4953    0.0631635 0.133571 0.989024    0.046875 0.046875
  v -52.5 -54.375 30.5384    0.0559197 -0.0621821 0.996497    0.0625 0.046875
  v -50.625 -54.375 30.3553    0.134752 -0.20255 0.969956    0.078125 0.046875
  v -48.75 -54.375 30.1129    -0.0671078 -0.16784 0.983527    0.09375 0.046875
  v -46.875 -54.375 30.5331    -0.18372 -0.0963529 0.978245    0.109375 0.046875
  v -45 -54.375 30.6978    0.0754781 -0.106071 0.99149    0.125 0.046875
  v -43.125 -54.375 30.1997    0.208567 -0.105338 0.972319    0.140625 0.046875
  v -41.25 -54.375 29.9374    0.0595802 -0.0300448 0.997771    0.15625 0.046875
  v -39.375 -54.375 30.0858    -0.211957 0.0506212 0.975967    0.171875 0.046875
  v -37.5 -54.375 30.8571    -0.342322 0.0547511 0.937986    0.1875 0.046875
  v -35.625 -54.375 31.5145    -0.11488 0.0308985 0.992899    0.203125 0.046875
  v -33.75 -54.375 31.4415    0.125934 0.0256833 0.991706    0.21875 0.046875
  v -31.875 -54.375 31.1187    0.14839 0.0111849 0.988866    0.234375 0.046875
  v -30 -54.375 30.722    0.133693 -0.0675652 0.988717    0.25 0.046875
  v -28.125 -54.375 30.4814    0.0148362 -0.0892351 0.9959    0.265625 0.046875
  v -26.25 -54.375 30.6521    -0.123204 -0.0302432 0.99192    0.28125 0.046875
  v -24.375 -54.375 30.9458    -0.00534063 -0.0280435 0.999592    0.296875 0.046875
  v -22.5 -54.375 30.7734    0.121915 -0.0108898 0.992481    0.3125 0.046875
  v -20.625 -54.375 30.6139    -0.0584068 0.113983 0.991764    0.328125 0.046875
  v -18.75 -54.375 30.9309    -0.135965 0.127615 0.98246    0.34375 0.046875
  v -16.875 -54.375 31.0767    0.0730926 -0.0611356 0.99545    0.359375 0.046875
  v -15 -54.375 30.5827    0.225451 -0.245861 0.942722    0.375 0.046875
  v -13.125 -54.375 30.1206    0.0714599 -0.19572 0.978053    0.390625 0.046875
  v -11.25 -54.375 30.1905    -0.0893419 -0.0478469 0.994851    0.40625 0.046875
  v -9.375 -54.375 30.5005    -0.132581 0.0197185 0.990976    0.421875 0.046875
  v -7.5 -54.375 30.805    -0.0607919 0.0146594 0.998043    0.4375 0.046875
  v -5.625 -54.375 30.8176    0.00402889 0.0312275 0.999504    0.453125 0.046875
  v -3.75 -54.375 30.7668    -0.00177006 0.00772615 0.999969    0.46875 0.046875
  v -1.875 -54.375 30.8236    0.113951 -0.0792049 0.990324    0.484375 0.046875
  v -1.23138e-023 -54.375 30.3036    0.141231 -0.133419 0.980945    0.5 0.046875
  v 1.875 -54.375 30.1762    -0.155259 -0.115808 0.981062    0.515625 0.046875
  v 3.75 -54.375 30.78    -0.171234 -0.164445 0.97141    0.53125 0.046875
  v 5.625 -54.375 30.8701    0.143518 -0.219473 0.965005    0.546875 0.046875
  v 7.5 -54.375 30.3957    0.0576935 -0.0814155 0.995009    0.5625 0.046875
  v 9.375 -54.375 30.5692    -0.139691 0.0413072 0.989333    0.578125 0.046875
  v 11.25 -54.375 30.9013    0.023273 0.00804828 0.999697    0.59375 0.046875
  v 13.125 -54.375 30.6889    0.157505 0.0410632 0.986664    0.609375 0.046875
  v 15 -54.375 30.2429    0.00416675 0.111742 0.993729    0.625 0.046875
  v 16.875 -54.375 30.4063    -0.10565 0.0485903 0.993216    0.640625 0.046875
  v 18.75 -54.375 30.6787    -0.0548946 -0.00607694 0.998474    0.65625 0.046875
  v 20.625 -54.375 30.7843    -0.0484442 0.00578285 0.998809    0.671875 0.046875
  v 22.5 -54.375 30.9742    -0.0409304 0.0351161 0.998545    0.6875 0.046875
  v 24.375 -54.375 30.9856    0.0179522 0.100827 0.994742    0.703125 0.046875
  v 26.25 -54.375 30.8082    -0.029089 0.0997511 0.994587    0.71875 0.046875
  v 28.125 -54.375 30.9779    -0.0366471 -0.062192 0.997391    0.734375 0.046875
  v 30 -54.375 31.0367    0.0761363 -0.193226 0.978196    0.75 0.046875
  v 31.875 -54.375 30.9342    0.0131392 -0.0775113 0.996905    0.765625 0.046875
  v 33.75 -54.375 30.9515    -0.0220401 0.119402 0.992601    0.78125 0.046875
  v 35.625 -54.375 30.8785    -0.0631505 0.193797 0.979007    0.796875 0.046875
  v 37.5 -54.375 31.0791    -0.138479 0.0979808 0.985507    0.8125 0.046875
  v 39.375 -54.375 31.4549    -0.0352346 -0.0445913 0.998384    0.828125 0.046875
  v 41.25 -54.375 31.4357    0.0970401 -0.0423759 0.994378    0.84375 0.046875
  v 43.125 -54.375 31.2239    0.0827146 0.116334 0.98976    0.859375 0.046875
  v 45 -54.375 30.902    0.0485554 0.211317 0.976211    0.875 0.046875
  v 46.875 -54.375 30.6455    0.05054 0.0943526 0.994255    0.890625 0.046875
  v 48.75 -54.375 30.6999    -0.0155239 -0.0524857 0.998501    0.90625 0.046875
  v 50.625 -54.375 30.8537    0.0345895 -0.0892206 0.995411    0.921875 0.046875
  v 52.5 -54.375 30.6531    0.0972262 -0.0257902 0.994928    0.9375 0.046875
  v 54.375 -54.375 30.4437    -0.0020227 0.0098947 0.999949    0.953125 0.046875
  v 56.25 -54.375 30.7185    -0.120406 0.0249298 0.992412    0.96875 0.046875
  v 58.125 -54.375 30.9333    -0.00521115 0.00507644 0.999974    0.984375 0.046875
  v 60 -54.375 30.5528    0.179088 -0.0166449 0.983692    1 0.046875
  v -60 -52.5 31.0181    0.166163 -0.0568655 0.984457    0 0.0625
  v -58.125 -52.5 30.8774    0.137605 0.119774 0.983219    0.015625 0.0625
  v -56.25 -52.5 30.355    0.156695 0.188196 0.969551    0.03125 0.0625
  v -54.375 -52.5 30.1446    -0.0868442 0.107823 0.99037    0.046875 0.0625
  v -52.5 -52.5 30.7554    -0.133515 -0.044277 0.990057    0.0625 0.0625
  v -50.625 -52.5 30.8588    0.0697785 -0.129428 0.989131    0.078125 0.0625
  v -48.75 -52.5 30.6145    -0.0168346 -0.127593 0.991684    0.09375 0.0625
  v -46.875 -52.5 30.9583    -0.187271 -0.108002 0.976353    0.109375 0.0625
  v -45 -52.5 31.2528    0.00111887 -0.186309 0.98249    0.125 0.0625
  v -43.125 -52.5 30.8653    0.205272 -0.278783 0.93816    0.140625 0.0625
  v -41.25 -52.5 30.4379    0.176089 -0.262659 0.948685    0.15625 0.0625
  v -39.375 -52.5 30.1736    -0.100422 -0.135757 0.98564    0.171875 0.0625
  v -37.5 -52.5 30.7554    -0.310537 -0.0203844 0.950343    0.1875 0.0625
  v -35.625 -52.5 31.3745    -0.0742721 0.0422677 0.996342    0.203125 0.0625
  v -33.75 -52.5 31.1127    0.172181 0.127892 0.976728    0.21875 0.0625
  v -31.875 -52.5 30.6934    0.0869395 0.169027 0.981769    0.234375 0.0625
  v -30 -52.5 30.6789    -0.00235562 0.0626517 0.998033    0.25 0.0625
  v -28.125 -52.5 30.7693    0.00392155 -0.0417727 0.999119    0.265625 0.0625
  v -26.25 -52.5 30.8424    -0.0483919 0.0102087 0.998776    0.28125 0.0625
  v -24.375 -52.5 31.0272    0.0196591 0.100708 0.994722    0.296875 0.0625
  v -22.5 -52.5 30.7554    0.181498 0.133687 0.974262    0.3125 0.0625
  v -20.625 -52.5 30.2682    0.0402609 0.178257 0.98316    0.328125 0.0625
  v -18.75 -52.5 30.4387    -0.17622 0.189938 0.965852    0.34375 0.0625
  v -16.875 -52.5 30.8572    -0.143632 0.111856 0.983289    0.359375 0.0625
  v -15 -52.5 31.0065    0.0595259 -0.0690934 0.995833    0.375 0.0625
  v -13.125 -52.5 30.8116    0.123657 -0.169393 0.97776    0.390625 0.0625
  v -11.25 -52.5 30.6677    0.0564926 -0.107345 0.992616    0.40625 0.0625
  v -9.375 -52.5 30.6226    -0.054531 0.0223763 0.998261    0.421875 0.0625
  v -7.5 -52.5 30.7554    -0.0281797 0.0847501 0.996004    0.4375 0.0625
  v -5.625 -52.5 30.6735    0.0406415 0.128529 0.990873    0.453125 0.0625
  v -3.75 -52.5 30.6141    -0.0380509 0.154556 0.987251    0.46875 0.0625
  v -1.875 -52.5 30.7923    0.00763866 0.0969988 0.995255    0.484375 0.0625
  v -1.23138e-023 -52.5 30.5307    0.0712348 -0.0164542 0.997324    0.5 0.0625
  v 1.875 -52.5 30.5772    -0.177494 -0.0738663 0.981346    0.515625 0.0625
  v 3.75 -52.5 31.3295    -0.238255 -0.0946253 0.966582    0.53125 0.0625
  v 5.625 -52.5 31.547    0.124297 -0.168412 0.977849    0.546875 0.0625
  v 7.5 -52.5 30.7554    0.195796 -0.184274 0.963175    0.5625 0.0625
  v 9.375 -52.5 30.648    -0.0383144 -0.0893038 0.995267    0.578125 0.0625
  v 11.25 -52.5 30.9111    0.0325159 0.00585309 0.999454    0.59375 0.0625
  v 13.125 -52.5 30.5072    0.194864 0.0317621 0.980316    0.609375 0.0625
  v 15 -52.5 30.0312    -0.00476437 0.026272 0.999644    0.625 0.0625
  v 16.875 -52.5 30.5483    -0.178935 0.000526871 0.983861    0.640625 0.0625
  v 18.75 -52.5 30.901    -0.0406879 -0.00197181 0.99917    0.65625 0.0625
  v 20.625 -52.5 30.7579    0.022897 0.0559714 0.99817    0.671875 0.0625
  v 22.5 -52.5 30.7554    0.0100681 0.119879 0.992737    0.6875 0.0625
  v 24.375 -52.5 30.6396    0.0575687 0.148676 0.987209    0.703125 0.0625
  v 26.25 -52.5 30.4891    -0.0613045 0.173418 0.982938    0.71875 0.0625
  v 28.125 -52.5 30.9776    -0.166862 0.162912 0.972428    0.734375 0.0625
  v 30 -52.5 31.2666    0.039348 0.0973061 0.994476    0.75 0.0625
  v 31.875 -52.5 30.8548    0.152795 0.0982581 0.983361    0.765625 0.0625
  v 33.75 -52.5 30.5421    0.0605533 0.124079 0.990423    0.78125 0.0625
  v 35.625 -52.5 30.3609    -0.0817125 0.072603 0.994008    0.796875 0.0625
  v 37.5 -52.5 30.7554    -0.190046 0.0585191 0.98003    0.8125 0.0625
  v 39.375 -52.5 31.339    -0.0582075 0.133059 0.989397    0.828125 0.0625
  v 41.25 -52.5 31.1703    0.153496 0.174471 0.972625    0.84375 0.0625
  v 43.125 -52.5 30.5893    0.138685 0.149663 0.978962    0.859375 0.0625
  v 45 -52.5 30.3214    -0.0291363 0.0567387 0.997964    0.875 0.0625
  v 46.875 -52.5 30.6485    -0.118968 -0.0824327 0.98947    0.890625 0.0625
  v 48.75 -52.5 30.9837    -0.0839838 -0.160533 0.983451    0.90625 0.0625
  v 50.625 -52.5 31.1209    0.0744286 -0.135576 0.987967    0.921875 0.0625
  v 52.5 -52.5 30.7554    0.160673 -0.0647748 0.98488    0.9375 0.0625
  v 54.375 -52.5 30.4716    0.0276809 -0.031292 0.999127    0.953125 0.0625
  v 56.25 -52.5 30.6143    -0.0904216 -0.00463927 0.995893    0.96875 0.0625
  v 58.125 -52.5 30.778    -0.0630899 0.0263047 0.997661    0.984375 0.0625
  v 60 -52.5 30.8538    0.039052 -0.0247805 0.99893    1 0.0625
  v -60 -50.625 31.4808    0.352895 -0.158034 0.92222    0 0.078125
  v -58.125 -50.625 30.7805    0.296902 -0.0639141 0.952767    0.015625 0.078125
  v -56.25 -50.625 30.1684    0.157555 0.0256953 0.987176    0.03125 0.078125
  v -54.375 -50.625 30.1441    -0.169698 0.00132434 0.985495    0.046875 0.078125
  v -52.5 -50.625 30.8946    -0.198585 -0.0454824 0.979028    0.0625 0.078125
  v -50.625 -50.625 30.9777    0.075544 -0.0408767 0.996304    0.078125 0.078125
  v -48.75 -50.625 30.6407    0.03953 0.0194068 0.99903    0.09375 0.078125
  v -46.875 -50.625 30.872    -0.174141 0.100883 0.97954    0.109375 0.078125
  v -45 -50.625 31.3347    -0.116922 0.100293 0.988064    0.125 0.078125
  v -43.125 -50.625 31.3239    0.104037 -0.0254009 0.994249    0.140625 0.078125
  v -41.25 -50.625 30.9858    0.201401 -0.122609 0.971805    0.15625 0.078125
  v -39.375 -50.625 30.5352    0.00979551 -0.114984 0.993319    0.171875 0.078125
  v -37.5 -50.625 30.9091    -0.257836 -0.0600853 0.964319    0.1875 0.078125
  v -35.625 -50.625 31.4179    -0.0325824 -0.0698258 0.997027    0.203125 0.078125
  v -33.75 -50.625 30.9336    0.25733 -0.0441707 0.965314    0.21875 0.078125
  v -31.875 -50.625 30.3743    0.0928123 0.0225832 0.995427    0.234375 0.078125
  v -30 -50.625 30.5537    -0.0906653 0.0258156 0.995547    0.25 0.078125
  v -28.125 -50.625 30.8193    -0.0022769 0.0155115 0.999877    0.265625 0.078125
  v -26.25 -50.625 30.6855    0.0454962 0.0627784 0.99699    0.28125 0.078125
  v -24.375 -50.625 30.5474    0.0816686 0.0985705 0.991773    0.296875 0.078125
  v -22.5 -50.625 30.1897    0.195586 0.0988395 0.975693    0.3125 0.078125
  v -20.625 -50.625 29.7725    0.026753 0.0954864 0.995071    0.328125 0.078125
  v -18.75 -50.625 30.0927    -0.228074 0.0478826 0.972466    0.34375 0.078125
  v -16.875 -50.625 30.6617    -0.221654 -0.00669862 0.975102    0.359375 0.078125
  v -15 -50.625 31.0353    -0.0207152 -0.00955415 0.99974    0.375 0.078125
  v -13.125 -50.625 30.9273    0.126401 0.0271022 0.991609    0.390625 0.078125
  v -11.25 -50.625 30.6318    0.146922 0.067016 0.986875    0.40625 0.078125
  v -9.375 -50.625 30.3021    0.00229113 0.0963077 0.995349    0.421875 0.078125
  v -7.5 -50.625 30.4287    -0.0216147 0.0582266 0.998069    0.4375 0.078125
  v -5.625 -50.625 30.3412    0.0746038 0.0390018 0.99645    0.453125 0.078125
  v -3.75 -50.625 30.1482    -0.0394754 0.0515817 0.997888    0.46875 0.078125
  v -1.875 -50.625 30.4004    -0.0654356 0.0266594 0.997501    0.484375 0.078125
  v -1.23138e-023 -50.625 30.4262    0.015509 0.00523873 0.999866    0.5 0.078125
  v 1.875 -50.625 30.5561    -0.162098 0.0547722 0.985253    0.515625 0.078125
  v 3.75 -50.625 31.1903    -0.226992 0.136631 0.964265    0.53125 0.078125
  v 5.625 -50.625 31.4635    0.014927 0.131899 0.991151    0.546875 0.078125
  v 7.5 -50.625 31.0127    0.141573 -0.0320093 0.98941    0.5625 0.078125
  v 9.375 -50.625 30.9186    0.0436523 -0.117949 0.99206    0.578125 0.078125
  v 11.25 -50.625 30.8644    0.0916694 -0.064047 0.993728    0.59375 0.078125
  v 13.125 -50.625 30.4355    0.17144 -0.0547182 0.983674    0.609375 0.078125
  v 15 -50.625 30.1659    0.0137356 -0.0732885 0.997216    0.625 0.078125
  v 16.875 -50.625 30.5857    -0.139133 0.0166608 0.990134    0.640625 0.078125
  v 18.75 -50.625 30.7411    -0.0228114 0.0754839 0.996886    0.65625 0.078125
  v 20.625 -50.625 30.5142    0.060764 0.0468342 0.997053    0.671875 0.078125
  v 22.5 -50.625 30.4401    0.0207463 0.0329346 0.999242    0.6875 0.078125
  v 24.375 -50.625 30.3727    0.0499599 0.00192384 0.998749    0.703125 0.078125
  v 26.25 -50.625 30.2383    0.0113325 0.0150197 0.999823    0.71875 0.078125
  v 28.125 -50.625 30.47    -0.132227 0.1331 0.982243    0.734375 0.078125
  v 30 -50.625 30.6868    -0.0167736 0.15685 0.98748    0.75 0.078125
  v 31.875 -50.625 30.4169    0.139424 0.091463 0.986    0.765625 0.078125
  v 33.75 -50.625 30.2133    -0.0158951 0.0648323 0.99777    0.78125 0.078125
  v 35.625 -50.625 30.4986    -0.178483 -0.0235492 0.983661    0.796875 0.078125
  v 37.5 -50.625 31.0934    -0.109975 -0.0417136 0.993059    0.8125 0.078125
  v 39.375 -50.625 31.1364    0.0662849 0.0989515 0.992882    0.828125 0.078125
  v 41.25 -50.625 30.6079    0.122425 0.123273 0.984792    0.84375 0.078125
  v 43.125 -50.625 30.3308    0.0159105 -0.0162256 0.999742    0.859375 0.078125
  v 45 -50.625 30.6283    -0.120883 -0.101179 0.987497    0.875 0.078125
  v 46.875 -50.625 31.1649    -0.198302 -0.0879655 0.976186    0.890625 0.078125
  v 48.75 -50.625 31.4661    -0.0845463 -0.111053 0.990212    0.90625 0.078125
  v 50.625 -50.625 31.4303    0.146865 -0.0975995 0.98433    0.921875 0.078125
  v 52.5 -50.625 30.8637    0.222191 -0.0275295 0.974614    0.9375 0.078125
  v 54.375 -50.625 30.5254    0.0283843 -0.000239775 0.999597    0.953125 0.078125
  v 56.25 -50.625 30.7012    -0.0743993 -0.0150154 0.997115    0.96875 0.078125
  v 58.125 -50.625 30.8359    -0.0109698 0.0298519 0.999494    0.984375 0.078125
  v 60 -50.625 30.8548    -0.0202172 0.0644694 0.997715    1 0.078125
  v -60 -48.75 31.7582    0.34501 0.0186831 0.938413    0 0.09375
  v -58.125 -48.75 31.0064    0.376227 -0.0321678 0.925969    0.015625 0.09375
  v -56.25 -48.75 30.2315    0.204259 0.0194248 0.978724    0.03125 0.09375
  v -54.375 -48.75 30.1922    -0.182001 0.0634608 0.981248    0.046875 0.09375
  v -52.5 -48.75 30.9805    -0.238049 0.0455897 0.970182    0.0625 0.09375
  v -50.625 -48.75 31.0473    0.0617804 -0.0451889 0.997066    0.078125 0.09375
  v -48.75 -48.75 30.5847    0.10657 -0.101338 0.989128    0.09375 0.09375
  v -46.875 -48.75 30.593    -0.0572446 -0.0160357 0.998231    0.109375 0.09375
  v -45 -48.75 30.8686    -0.10019 0.13658 0.98555    0.125 0.09375
  v -43.125 -48.75 31.0177    -0.0020759 0.174119 0.984722    0.140625 0.09375
  v -41.25 -48.75 30.9121    0.127335 0.102244 0.986576    0.15625 0.09375
  v -39.375 -48.75 30.5813    0.0247221 0.0486105 0.998512    0.171875 0.09375
  v -37.5 -48.75 30.8668    -0.252281 0.0550984 0.966084    0.1875 0.09375
  v -35.625 -48.75 31.5343    -0.089508 0.0270416 0.995619    0.203125 0.09375
  v -33.75 -48.75 31.2492    0.258842 -0.0345904 0.9653    0.21875 0.09375
  v -31.875 -48.75 30.5873    0.125343 -0.0443207 0.991123    0.234375 0.09375
  v -30 -48.75 30.6835    -0.0838574 -0.0518293 0.995129    0.25 0.09375
  v -28.125 -48.75 30.8343    0.0338075 -0.0491715 0.998218    0.265625 0.09375
  v -26.25 -48.75 30.5054    0.0621377 -0.0287392 0.997654    0.28125 0.09375
  v -24.375 -48.75 30.4625    0.0336601 -0.0832358 0.995961    0.296875 0.09375
  v -22.5 -48.75 30.3414    0.181012 -0.146182 0.972556    0.3125 0.09375
  v -20.625 -48.75 29.9091    0.0567933 -0.0941111 0.99394    0.328125 0.09375
  v -18.75 -48.75 30.2591    -0.261242 -0.0164456 0.965133    0.34375 0.09375
  v -16.875 -48.75 30.9683    -0.255801 -0.0491121 0.965481    0.359375 0.09375
  v -15 -48.75 31.2316    0.0215576 -0.0997569 0.994778    0.375 0.09375
  v -13.125 -48.75 30.7843    0.200546 -0.0618999 0.977727    0.390625 0.09375
  v -11.25 -48.75 30.3453    0.175707 -0.0098998 0.984393    0.40625 0.09375
  v -9.375 -48.75 30.0625    -0.0400738 -0.0140568 0.999098    0.421875 0.09375
  v -7.5 -48.75 30.4916    -0.0955585 -0.0873312 0.991586    0.4375 0.09375
  v -5.625 -48.75 30.5247    0.0628744 -0.128227 0.98975    0.453125 0.09375
  v -3.75 -48.75 30.3253    -0.0478968 -0.118321 0.99182    0.46875 0.09375
  v -1.875 -48.75 30.7181    -0.102481 -0.146484 0.98389    0.484375 0.09375
  v -1.23138e-023 -48.75 30.7262    0.0518754 -0.179201 0.982444    0.5 0.09375
  v 1.875 -48.75 30.4984    -0.0388849 -0.10737 0.993458    0.515625 0.09375
  v 3.75 -48.75 30.8133    -0.110685 0.0385074 0.993109    0.53125 0.09375
  v 5.625 -48.75 30.9237    -0.0314541 0.151638 0.987935    0.546875 0.09375
  v 7.5 -48.75 30.8873    -0.0173357 0.0950378 0.995323    0.5625 0.09375
  v 9.375 -48.75 31.1108    4.73535e-005 0.00343896 0.999994    0.578125 0.09375
  v 11.25 -48.75 31.0198    0.106789 -0.00989128 0.994233    0.59375 0.09375
  v 13.125 -48.75 30.6728    0.111327 -0.0621177 0.991841    0.609375 0.09375
  v 15 -48.75 30.5093    0.0320925 -0.162343 0.986212    0.625 0.09375
  v 16.875 -48.75 30.5295    -0.0151436 -0.125448 0.991985    0.640625 0.09375
  v 18.75 -48.75 30.4576    -0.00929815 -0.0328398 0.999417    0.65625 0.09375
  v 20.625 -48.75 30.5091    0.00197413 -0.0452493 0.998974    0.671875 0.09375
  v 22.5 -48.75 30.5667    -0.0238253 -0.0869218 0.99593    0.6875 0.09375
  v 24.375 -48.75 30.6182    -0.00278284 -0.142929 0.989729    0.703125 0.09375
  v 26.25 -48.75 30.5745    0.0720375 -0.182346 0.980592    0.71875 0.09375
  v 28.125 -48.75 30.4012    -0.021936 -0.099858 0.99476    0.734375 0.09375
  v 30 -48.75 30.5425    -0.0535282 -0.0454726 0.99753    0.75 0.09375
  v 31.875 -48.75 30.554    0.0946825 -0.0893857 0.991486    0.765625 0.09375
  v 33.75 -48.75 30.3175    0.0154102 -0.0470674 0.998773    0.78125 0.09375
  v 35.625 -48.75 30.6425    -0.179623 0.0575232 0.982052    0.796875 0.09375
  v 37.5 -48.75 31.1283    -0.0439425 0.117671 0.99208    0.8125 0.09375
  v 39.375 -48.75 30.7278    0.121476 0.138081 0.982943    0.828125 0.09375
  v 41.25 -48.75 30.3613    -0.00926703 0.0462767 0.998886    0.84375 0.09375
  v 43.125 -48.75 30.7323    -0.11144 -0.106561 0.988041    0.859375 0.09375
  v 45 -48.75 31.0774    -0.0495853 -0.0962757 0.994119    0.875 0.09375
  v 46.875 -48.75 31.0683    -0.121015 0.0643652 0.990562    0.890625 0.09375
  v 48.75 -48.75 31.356    -0.122046 0.0961101 0.98786    0.90625 0.09375
  v 50.625 -48.75 31.4608    0.140155 0.027447 0.989749    0.921875 0.09375
  v 52.5 -48.75 30.8165    0.263899 0.0110204 0.964487    0.9375 0.09375
  v 54.375 -48.75 30.4185    0.0315825 0.0426797 0.998589    0.953125 0.09375
  v 56.25 -48.75 30.7015    -0.080075 0.0483822 0.995614    0.96875 0.09375
  v 58.125 -48.75 30.7773    0.0606741 0.0534457 0.996726    0.984375 0.09375
  v 60 -48.75 30.4247    0.120772 0.104906 0.987121    1 0.09375
  v -60 -46.875 31.4754    0.243669 0.272258 0.93086    0 0.109375
  v -58.125 -46.875 30.9078    0.330045 0.152512 0.931563    0.015625 0.109375
  v -56.25 -46.875 30.0896    0.227666 0.071536 0.971108    0.03125 0.109375
  v -54.375 -46.875 29.9156    -0.14653 0.0631586 0.987188    0.046875 0.109375
  v -52.5 -46.875 30.6257    -0.302489 0.0595417 0.951291    0.0625 0.109375
  v -50.625 -46.875 30.998    -0.0765314 -0.0415669 0.9962    0.078125 0.109375
  v -48.75 -46.875 30.9828    0.0624639 -0.138321 0.988416    0.09375 0.109375
  v -46.875 -46.875 31.0036    0.04904 -0.116349 0.991997    0.109375 0.109375
  v -45 -46.875 30.8481    0.0324324 -0.0289007 0.999056    0.125 0.109375
  v -43.125 -46.875 30.6944    0.0233378 0.0344845 0.999133    0.140625 0.109375
  v -41.25 -46.875 30.6453    0.0877125 0.0489636 0.994942    0.15625 0.109375
  v -39.375 -46.875 30.403    0.0422503 0.0765802 0.996168    0.171875 0.109375
  v -37.5 -46.875 30.658    -0.20993 0.171953 0.962477    0.1875 0.109375
  v -35.625 -46.875 31.3418    -0.131146 0.21958 0.96674    0.203125 0.109375
  v -33.75 -46.875 31.1359    0.210706 0.159498 0.96445    0.21875 0.109375
  v -31.875 -46.875 30.4747    0.100414 0.107785 0.98909    0.234375 0.109375
  v -30 -46.875 30.6799    -0.152243 0.0218024 0.988103    0.25 0.109375
  v -28.125 -46.875 30.9551    0.00200407 -0.0983619 0.995149    0.265625 0.109375
  v -26.25 -46.875 30.6581    0.0592024 -0.118301 0.991211    0.28125 0.109375
  v -24.375 -46.875 30.8315    -0.0578395 -0.118527 0.991265    0.296875 0.109375
  v -22.5 -46.875 30.9178    0.143872 -0.200503 0.969072    0.3125 0.109375
  v -20.625 -46.875 30.2653    0.205146 -0.168654 0.964091    0.328125 0.109375
  v -18.75 -46.875 30.1908    -0.155021 0.0266109 0.987553    0.34375 0.109375
  v -16.875 -46.875 30.8219    -0.304057 0.109633 0.946325    0.359375 0.109375
  v -15 -46.875 31.3133    -0.0816873 0.00925782 0.996615    0.375 0.109375
  v -13.125 -46.875 31.0538    0.179257 -0.13994 0.973799    0.390625 0.109375
  v -11.25 -46.875 30.6184    0.199092 -0.171262 0.9649    0.40625 0.109375
  v -9.375 -46.875 30.3471    -0.0420737 -0.124791 0.991291    0.421875 0.109375
  v -7.5 -46.875 30.8564    -0.171937 -0.136762 0.975568    0.4375 0.109375
  v -5.625 -46.875 30.9025    0.0626749 -0.218993 0.973711    0.453125 0.109375
  v -3.75 -46.875 30.6036    0.0219281 -0.163491 0.986301    0.46875 0.109375
  v -1.875 -46.875 30.967    -0.135688 -0.0587239 0.98901    0.484375 0.109375
  v -1.23138e-023 -46.875 31.09    -0.00801993 -0.12092 0.99263    0.5 0.109375
  v 1.875 -46.875 30.9063    0.0383949 -0.182942 0.982374    0.515625 0.109375
  v 3.75 -46.875 31.0378    0.0122129 -0.105118 0.994385    0.53125 0.109375
  v 5.625 -46.875 30.8325    0.0291211 -0.0285229 0.999169    0.546875 0.109375
  v 7.5 -46.875 30.7768    -0.0246932 0.00972525 0.999648    0.5625 0.109375
  v 9.375 -46.875 31.0379    0.0054866 0.0943801 0.995521    0.578125 0.109375
  v 11.25 -46.875 30.8679    0.090541 0.136706 0.986465    0.59375 0.109375
  v 13.125 -46.875 30.5848    0.0184877 0.0756594 0.996962    0.609375 0.109375
  v 15 -46.875 30.7629    -0.0609457 -0.0132028 0.998054    0.625 0.109375
  v 16.875 -46.875 30.952    -0.0125369 -0.0742422 0.997161    0.640625 0.109375
  v 18.75 -46.875 30.8101    0.022151 -0.117816 0.992788    0.65625 0.109375
  v 20.625 -46.875 30.8009    0.0165472 -0.108524 0.993956    0.671875 0.109375
  v 22.5 -46.875 30.7874    -0.0147009 -0.0381087 0.999165    0.6875 0.109375
  v 24.375 -46.875 30.9129    -0.0466448 -6.61026e-005 0.998911    0.703125 0.109375
  v 26.25 -46.875 30.9957    0.0532704 -0.0285763 0.998171    0.71875 0.109375
  v 28.125 -46.875 30.7354    0.0569901 -0.0187008 0.9982    0.734375 0.109375
  v 30 -46.875 30.811    -0.059699 0.0184245 0.998046    0.75 0.109375
  v 31.875 -46.875 30.8922    0.0526355 -0.0381489 0.997885    0.765625 0.109375
  v 33.75 -46.875 30.5328    0.127565 -0.068956 0.98943    0.78125 0.109375
  v 35.625 -46.875 30.3925    -0.0378212 0.045943 0.998228    0.796875 0.109375
  v 37.5 -46.875 30.5548    -0.0462511 0.117578 0.991986    0.8125 0.109375
  v 39.375 -46.875 30.3049    0.0361897 0.0207735 0.999129    0.828125 0.109375
  v 41.25 -46.875 30.401    -0.1209 -0.0787383 0.989537    0.84375 0.109375
  v 43.125 -46.875 31.0299    -0.16274 -0.104745 0.981093    0.859375 0.109375
  v 45 -46.875 31.1429    0.0476549 -0.0829653 0.995412    0.875 0.109375
  v 46.875 -46.875 30.7407    0.0180361 0.0141007 0.999738    0.890625 0.109375
  v 48.75 -46.875 31.0273    -0.151297 0.0973123 0.983687    0.90625 0.109375
  v 50.625 -46.875 31.3352    0.0357761 0.0357712 0.998719    0.921875 0.109375
  v 52.5 -46.875 30.8082    0.234098 -0.100557 0.966999    0.9375 0.109375
  v 54.375 -46.875 30.3719    0.0880528 -0.120596 0.988789    0.953125 0.109375
  v 56.25 -46.875 30.5751    -0.0298191 -0.00634801 0.999535    0.96875 0.109375
  v 58.125 -46.875 30.589    0.0509805 0.069717 0.996263    0.984375 0.109375
  v 60 -46.875 30.3139    0.158204 0.0522702 0.986022    1 0.109375
  v -60 -45 30.6711    0.0796109 0.167272 0.982691    0 0.125
  v -58.125 -45 30.3382    0.202637 0.0931705 0.974811    0.015625 0.125
  v -56.25 -45 29.8693    0.148387 -0.0252434 0.988607    0.03125 0.125
  v -54.375 -45 29.9057    -0.158706 -0.0561338 0.985729    0.046875 0.125
  v -52.5 -45 30.6228    -0.343209 -0.0463246 0.938116    0.0625 0.125
  v -50.625 -45 31.2687    -0.14199 -0.0780789 0.986784    0.078125 0.125
  v -48.75 -45 31.3625    0.0900209 -0.0375765 0.995231    0.09375 0.125
  v -46.875 -45 31.0868    0.116157 0.0663034 0.991015    0.109375 0.125
  v -45 -45 30.7922    0.0404282 0.0700913 0.996721    0.125 0.125
  v -43.125 -45 30.7699    0.00293308 -0.0191658 0.999812    0.140625 0.125
  v -41.25 -45 30.766    0.0575361 -0.0963782 0.99368    0.15625 0.125
  v -39.375 -45 30.4612    0.135293 -0.124556 0.982945    0.171875 0.125
  v -37.5 -45 30.2935    -0.0504772 0.0160888 0.998596    0.1875 0.125
  v -35.625 -45 30.6231    -0.121664 0.148473 0.981404    0.203125 0.125
  v -33.75 -45 30.584    0.132227 0.103757 0.985774    0.21875 0.125
  v -31.875 -45 30.1225    0.0788679 0.0696966 0.994446    0.234375 0.125
  v -30 -45 30.4926    -0.242191 0.119264 0.96287    0.25 0.125
  v -28.125 -45 31.1947    -0.117619 0.05536 0.991514    0.265625 0.125
  v -26.25 -45 31.0583    0.0962084 -0.0121587 0.995287    0.28125 0.125
  v -24.375 -45 30.9537    -0.0561273 0.0459371 0.997366    0.296875 0.125
  v -22.5 -45 31.1315    0.0326552 -0.0188638 0.999289    0.3125 0.125
  v -20.625 -45 30.6627    0.259521 -0.168607 0.950905    0.328125 0.125
  v -18.75 -45 30.1086    0.0258517 -0.121971 0.992197    0.34375 0.125
  v -16.875 -45 30.4468    -0.238491 0.0398512 0.970327    0.359375 0.125
  v -15 -45 31.1146    -0.189512 0.145679 0.971011    0.375 0.125
  v -13.125 -45 31.3239    0.0308095 0.0706529 0.997025    0.390625 0.125
  v -11.25 -45 31.0827    0.194576 -0.0497731 0.979624    0.40625 0.125
  v -9.375 -45 30.6071    0.0281079 -0.0483447 0.998435    0.421875 0.125
  v -7.5 -45 30.9088    -0.245379 -0.0271021 0.969048    0.4375 0.125
  v -5.625 -45 31.3601    -0.0189127 -0.156159 0.987551    0.453125 0.125
  v -3.75 -45 31.1007    0.167145 -0.153916 0.973844    0.46875 0.125
  v -1.875 -45 30.9124    -0.0300561 0.0558729 0.997985    0.484375 0.125
  v -1.23138e-023 -45 31.0971    -0.104742 0.116513 0.987651    0.5 0.125
  v 1.875 -45 31.2941    0.0275602 0.0423214 0.998724    0.515625 0.125
  v 3.75 -45 31.182    0.0734511 0.069947 0.994843    0.53125 0.125
  v 5.625 -45 30.8805    0.0244167 0.0552372 0.998175    0.546875 0.125
  v 7.5 -45 30.962    0.0199875 -0.00616722 0.999781    0.5625 0.125
  v 9.375 -45 30.8691    0.103381 0.0371669 0.993947    0.578125 0.125
  v 11.25 -45 30.3871    0.0761086 0.0575722 0.995436    0.59375 0.125
  v 13.125 -45 30.3528    -0.0468744 -0.00924554 0.998858    0.609375 0.125
  v 15 -45 30.6987    -0.0721358 0.00258327 0.997392    0.625 0.125
  v 16.875 -45 30.8136    -0.0563043 0.0585153 0.996697    0.640625 0.125
  v 18.75 -45 30.8389    -0.0368806 -0.00250773 0.999317    0.65625 0.125
  v 20.625 -45 30.9595    0.045385 -0.051153 0.997659    0.671875 0.125
  v 22.5 -45 30.7664    0.0808969 0.0144503 0.996618    0.6875 0.125
  v 24.375 -45 30.6518    -0.0137265 0.0951129 0.995372    0.703125 0.125
  v 26.25 -45 30.7089    0.0294612 0.0975164 0.994798    0.71875 0.125
  v 28.125 -45 30.5034    0.104361 0.093389 0.990145    0.734375 0.125
  v 30 -45 30.4023    -0.0553011 0.14727 0.987549    0.75 0.125
  v 31.875 -45 30.6217    -0.0622975 0.0896447 0.994024    0.765625 0.125
  v 33.75 -45 30.5661    0.0901924 -0.0477109 0.994781    0.78125 0.125
  v 35.625 -45 30.347    0.0337034 -0.0798239 0.996239    0.796875 0.125
  v 37.5 -45 30.4094    -0.0964868 -0.0692429 0.992923    0.8125 0.125
  v 39.375 -45 30.6295    -0.0644181 -0.1405 0.987983    0.828125 0.125
  v 41.25 -45 30.9214    -0.10348 -0.117538 0.987662    0.84375 0.125
  v 43.125 -45 31.241    -0.127912 -0.00714046 0.99176    0.859375 0.125
  v 45 -45 31.2833    0.0446156 -0.00433705 0.998995    0.875 0.125
  v 46.875 -45 30.9692    0.108433 -0.0293341 0.993671    0.890625 0.125
  v 48.75 -45 31.0004    -0.0767551 0.0798262 0.993849    0.90625 0.125
  v 50.625 -45 31.2544    -0.0738409 0.124585 0.989457    0.921875 0.125
  v 52.5 -45 31.1588    0.0598319 -0.0456028 0.997166    0.9375 0.125
  v 54.375 -45 30.9969    0.1029 -0.22074 0.96989    0.953125 0.125
  v 56.25 -45 30.8357    0.136761 -0.162715 0.977149    0.96875 0.125
  v 58.125 -45 30.4468    0.118214 0.00950098 0.992943    0.984375 0.125
  v 60 -45 30.3143    0.0953594 0.0515196 0.994109    1 0.125
  v -60 -43.125 30.3109    -0.132991 -0.0526911 0.989716    0 0.140625
  v -58.125 -43.125 30.5086    0.043619 -0.10691 0.993311    0.015625 0.140625
  v -56.25 -43.125 30.3251    0.114513 -0.172835 0.978271    0.03125 0.140625
  v -54.375 -43.125 30.263    -0.105226 -0.102315 0.989171    0.046875 0.140625
  v -52.5 -43.125 30.8018    -0.326725 -0.0124577 0.945037    0.0625 0.140625
  v -50.625 -43.125 31.4825    -0.139666 -0.0336074 0.989628    0.078125 0.140625
  v -48.75 -43.125 31.2876    0.192057 -0.0315726 0.980876    0.09375 0.140625
  v -46.875 -43.125 30.6189    0.209205 0.0701312 0.975354    0.109375 0.140625
  v -45 -43.125 30.4138    -0.0130174 0.138669 0.990253    0.125 0.140625
  v -43.125 -43.125 30.7512    -0.117394 0.0807092 0.9898    0.140625 0.140625
  v -41.25 -43.125 30.9244    -0.0758213 -0.0560826 0.995543    0.15625 0.140625
  v -39.375 -43.125 30.9293    0.0966504 -0.23075 0.968201    0.171875 0.140625
  v -37.5 -43.125 30.5624    0.0927563 -0.248312 0.964229    0.1875 0.140625
  v -35.625 -43.125 30.562    -0.0528654 -0.125253 0.990715    0.203125 0.140625
  v -33.75 -43.125 30.7298    0.0598066 -0.0869881 0.994412    0.21875 0.140625
  v -31.875 -43.125 30.4215    0.140719 -0.0970013 0.985286    0.234375 0.140625
  v -30 -43.125 30.3337    -0.1194 0.045536 0.991801    0.25 0.140625
  v -28.125 -43.125 30.8399    -0.14433 0.17511 0.973912    0.265625 0.140625
  v -26.25 -43.125 30.8271    0.0712145 0.143084 0.987145    0.28125 0.140625
  v -24.375 -43.125 30.5169    -0.0320878 0.1052 0.993933    0.296875 0.140625
  v -22.5 -43.125 30.8296    -0.112979 0.0568443 0.99197    0.3125 0.140625
  v -20.625 -43.125 30.9363    0.10796 -0.096514 0.989459    0.328125 0.140625
  v -18.75 -43.125 30.5556    0.0793415 -0.190535 0.978469    0.34375 0.140625
  v -16.875 -43.125 30.7292    -0.0680643 -0.121652 0.990236    0.359375 0.140625
  v -15 -43.125 30.8819    -0.0605242 0.0667779 0.995931    0.375 0.140625
  v -13.125 -43.125 30.8686    -0.0142071 0.184059 0.982812    0.390625 0.140625
  v -11.25 -43.125 30.8473    0.100568 0.135114 0.985713    0.40625 0.140625
  v -9.375 -43.125 30.4733    0.0204688 0.0403537 0.998976    0.421875 0.140625
  v -7.5 -43.125 30.751    -0.273253 0.0247862 0.961623    0.4375 0.140625
  v -5.625 -43.125 31.6142    -0.110312 0.0054799 0.993882    0.453125 0.140625
  v -3.75 -43.125 31.4056    0.24647 -0.00865165 0.969112    0.46875 0.140625
  v -1.875 -43.125 30.6439    0.139731 0.0725285 0.98753    0.484375 0.140625
  v -1.23138e-023 -43.125 30.6236    -0.0879525 0.142159 0.985929    0.5 0.140625
  v 1.875 -43.125 30.9343    0.0154953 0.159394 0.987093    0.515625 0.140625
  v 3.75 -43.125 30.63    0.102573 0.197957 0.974829    0.53125 0.140625
  v 5.625 -43.125 30.4903    -0.0427117 0.199224 0.979023    0.546875 0.140625
  v 7.5 -43.125 30.864    -0.0535993 0.122387 0.991034    0.5625 0.140625
  v 9.375 -43.125 30.7167    0.0753359 0.0290998 0.996734    0.578125 0.140625
  v 11.25 -43.125 30.4219    0.00174856 -0.0782337 0.996934    0.59375 0.140625
  v 13.125 -43.125 30.754    -0.111489 -0.174395 0.978344    0.609375 0.140625
  v 15 -43.125 30.9434    -0.00574775 -0.20909 0.97788    0.625 0.140625
  v 16.875 -43.125 30.6596    0.000469147 -0.151392 0.988474    0.640625 0.140625
  v 18.75 -43.125 30.8266    -0.081328 -0.111377 0.990445    0.65625 0.140625
  v 20.625 -43.125 31.0934    0.0420264 -0.105511 0.99353    0.671875 0.140625
  v 22.5 -43.125 30.7303    0.142331 -0.091024 0.985625    0.6875 0.140625
  v 24.375 -43.125 30.4444    0.0183282 -0.0759201 0.996945    0.703125 0.140625
  v 26.25 -43.125 30.5902    0.00744072 -0.0773979 0.996973    0.71875 0.140625
  v 28.125 -43.125 30.4703    0.134405 -0.073376 0.988206    0.734375 0.140625
  v 30 -43.125 30.1571    -0.0117283 -0.00870948 0.999893    0.75 0.140625
  v 31.875 -43.125 30.4797    -0.152199 0.0130518 0.988264    0.765625 0.140625
  v 33.75 -43.125 30.7792    -0.0112729 -0.0474807 0.998809    0.78125 0.140625
  v 35.625 -43.125 30.6656    0.0263788 -0.0779393 0.996609    0.796875 0.140625
  v 37.5 -43.125 30.7384    -0.103403 -0.0633244 0.992622    0.8125 0.140625
  v 39.375 -43.125 31.1104    -0.0615862 -0.0526605 0.996712    0.828125 0.140625
  v 41.25 -43.125 31.0675    0.0156072 0.013989 0.99978    0.84375 0.140625
  v 43.125 -43.125 30.9348    -0.0331892 0.122411 0.991924    0.859375 0.140625
  v 45 -43.125 31.0564    0.00130422 0.160767 0.986992    0.875 0.140625
  v 46.875 -43.125 30.9804    0.109455 0.123222 0.986324    0.890625 0.140625
  v 48.75 -43.125 30.7156    0.0378243 0.151248 0.987772    0.90625 0.140625
  v 50.625 -43.125 30.7314    -0.084235 0.21097 0.973856    0.921875 0.140625
  v 52.5 -43.125 30.9563    -0.136041 0.159399 0.977796    0.9375 0.140625
  v 54.375 -43.125 31.3104    -0.0357912 -0.0058652 0.999342    0.953125 0.140625
  v 56.25 -43.125 31.1872    0.209275 -0.101253 0.972601    0.96875 0.140625
  v 58.125 -43.125 30.4837    0.243415 -0.048747 0.968697    0.984375 0.140625
  v 60 -43.125 30.1651    0.135334 0.0226075 0.990542    1 0.140625
  v -60 -41.25 30.5604    -0.102299 -0.0666124 0.992521    0 0.15625
  v -58.125 -41.25 30.9209    -0.0480125 -0.0615438 0.996949    0.015625 0.15625
  v -56.25 -41.25 30.7344    0.123585 -0.129108 0.983899    0.03125 0.15625
  v -54.375 -41.25 30.3639    0.0290588 -0.099747 0.994588    0.046875 0.15625
  v -52.5 -41.25 30.5937    -0.254265 0.0386915 0.96636    0.0625 0.15625
  v -50.625 -41.25 31.3318    -0.208794 0.0765657 0.974958    0.078125 0.15625
  v -48.75 -41.25 31.3685    0.15465 -0.0173526 0.987817    0.09375 0.15625
  v -46.875 -41.25 30.7546    0.276976 -0.0631052 0.958802    0.109375 0.15625
  v -45 -41.25 30.3464    0.0493543 -0.00302079 0.998777    0.125 0.15625
  v -43.125 -41.25 30.5235    -0.161909 0.0450007 0.985779    0.140625 0.15625
  v -41.25 -41.25 30.8679    -0.216558 -0.00236097 0.976267    0.15625 0.15625
  v -39.375 -41.25 31.3809    -0.0604386 -0.127782 0.989959    0.171875 0.15625
  v -37.5 -41.25 31.2674    0.11811 -0.195558 0.973554    0.1875 0.15625
  v -35.625 -41.25 31.0711    0.0757823 -0.13038 0.988564    0.203125 0.15625
  v -33.75 -41.25 31.0012    0.0899113 -0.0330611 0.995401    0.21875 0.15625
  v -31.875 -41.25 30.6363    0.156117 -0.0402877 0.986917    0.234375 0.15625
  v -30 -41.25 30.2743    0.0210978 -0.051919 0.998428    0.25 0.15625
  v -28.125 -41.25 30.4455    -0.0699969 0.0285353 0.997139    0.265625 0.15625
  v -26.25 -41.25 30.4619    -0.00762499 0.0567692 0.998358    0.28125 0.15625
  v -24.375 -41.25 30.433    -0.0887126 -0.0189213 0.995878    0.296875 0.15625
  v -22.5 -41.25 30.9043    -0.183452 -0.0711937 0.980447    0.3125 0.15625
  v -20.625 -41.25 31.1718    0.00733813 -0.119267 0.992835    0.328125 0.15625
  v -18.75 -41.25 30.9455    0.106218 -0.108578 0.988397    0.34375 0.15625
  v -16.875 -41.25 30.9777    0.0407251 -0.00869662 0.999133    0.359375 0.15625
  v -15 -41.25 30.7628    0.0549926 0.0470037 0.99738    0.375 0.15625
  v -13.125 -41.25 30.5301    0.0404763 0.0603496 0.997356    0.390625 0.15625
  v -11.25 -41.25 30.556    0.0268958 0.0795363 0.996469    0.40625 0.15625
  v -9.375 -41.25 30.4386    -0.0609521 0.0250955 0.997825    0.421875 0.15625
  v -7.5 -41.25 30.8663    -0.235835 0.00503523 0.97178    0.4375 0.15625
  v -5.625 -41.25 31.5394    -0.0744164 0.103326 0.99186    0.453125 0.15625
  v -3.75 -41.25 31.1307    0.223704 0.117809 0.967511    0.46875 0.15625
  v -1.875 -41.25 30.4189    0.127676 -0.00230183 0.991813    0.484375 0.15625
  v -1.23138e-023 -41.25 30.5056    -0.055099 -0.0713581 0.995928    0.5 0.15625
  v 1.875 -41.25 30.7515    0.0427422 -0.00970255 0.999039    0.515625 0.15625
  v 3.75 -41.25 30.3678    0.142243 0.0361159 0.989173    0.53125 0.15625
  v 5.625 -41.25 30.1856    -0.0300477 0.0633225 0.997541    0.546875 0.15625
  v 7.5 -41.25 30.5128    -0.119896 0.0919804 0.988516    0.5625 0.15625
  v 9.375 -41.25 30.6047    -0.043141 0.0356886 0.998431    0.578125 0.15625
  v 11.25 -41.25 30.7265    -0.0694328 -0.0443395 0.996601    0.59375 0.15625
  v 13.125 -41.25 31.1166    -0.16487 -0.0277471 0.985925    0.609375 0.15625
  v 15 -41.25 31.3903    -0.0706995 -0.0714824 0.994933    0.625 0.15625
  v 16.875 -41.25 31.2909    0.0199003 -0.16562 0.985989    0.640625 0.15625
  v 18.75 -41.25 31.3968    -0.0304799 -0.148357 0.988464    0.65625 0.15625
  v 20.625 -41.25 31.4271    0.0541334 -0.110184 0.992436    0.671875 0.15625
  v 22.5 -41.25 31.0093    0.113654 -0.15933 0.980661    0.6875 0.15625
  v 24.375 -41.25 30.8728    0.026579 -0.203124 0.978792    0.703125 0.15625
  v 26.25 -41.25 31.0625    0.0373175 -0.136377 0.989954    0.71875 0.15625
  v 28.125 -41.25 30.8672    0.171593 -0.0556826 0.983593    0.734375 0.15625
  v 30 -41.25 30.4002    0.0513646 -0.011291 0.998616    0.75 0.15625
  v 31.875 -41.25 30.6161    -0.135804 0.0224419 0.990481    0.765625 0.15625
  v 33.75 -41.25 30.8858    -0.0473825 0.0185874 0.998704    0.78125 0.15625
  v 35.625 -41.25 30.7016    0.0365 -0.0169786 0.999189    0.796875 0.15625
  v 37.5 -41.25 30.7023    -0.0445346 0.0119296 0.998937    0.8125 0.15625
  v 39.375 -41.25 30.9285    -0.0391226 0.0752329 0.996398    0.828125 0.15625
  v 41.25 -41.25 30.754    0.0340067 0.054125 0.997955    0.84375 0.15625
  v 43.125 -41.25 30.6384    0.0138805 0.00369377 0.999897    0.859375 0.15625
  v 45 -41.25 30.7225    0.0327539 0.0361571 0.998809    0.875 0.15625
  v 46.875 -41.25 30.5736    0.087919 0.0768985 0.993155    0.890625 0.15625
  v 48.75 -41.25 30.3198    0.0474137 0.0456868 0.99783    0.90625 0.15625
  v 50.625 -41.25 30.3542    -0.0682923 0.0233783 0.997391    0.921875 0.15625
  v 52.5 -41.25 30.598    -0.184715 0.0376165 0.982072    0.9375 0.15625
  v 54.375 -41.25 31.1132    -0.140893 0.0389798 0.989257    0.953125 0.15625
  v 56.25 -41.25 31.2221    0.155129 -0.00324229 0.987889    0.96875 0.15625
  v 58.125 -41.25 30.5695    0.276659 -0.0409975 0.960093    0.984375 0.15625
  v 60 -41.25 30.15    0.201379 -0.029347 0.979074    1 0.15625
  v -60 -39.375 30.8735    0.0829442 -0.0671313 0.99429    0 0.171875
  v -58.125 -39.375 30.7351    -0.0197859 -0.00882864 0.999765    0.015625 0.171875
  v -56.25 -39.375 30.7379    0.0357545 -0.034428 0.998767    0.03125 0.171875
  v -54.375 -39.375 30.6165    0.0666808 -0.107026 0.992018    0.046875 0.171875
  v -52.5 -39.375 30.6149    -0.127319 -0.0353857 0.99123    0.0625 0.171875
  v -50.625 -39.375 31.1353    -0.197526 0.0975932 0.975428    0.078125 0.171875
  v -48.75 -39.375 31.3783    0.0677197 0.113192 0.991263    0.09375 0.171875
  v -46.875 -39.375 30.9306    0.250731 0.0404624 0.967211    0.109375 0.171875
  v -45 -39.375 30.3847    0.0810964 -0.0125572 0.996627    0.125 0.171875
  v -43.125 -39.375 30.483    -0.151416 -0.0273957 0.98809    0.140625 0.171875
  v -41.25 -39.375 30.9562    -0.229394 0.00750501 0.973305    0.15625 0.171875
  v -39.375 -39.375 31.5777    -0.0985857 0.0890469 0.991136    0.171875 0.171875
  v -37.5 -39.375 31.4781    0.105775 0.106615 0.988658    0.1875 0.171875
  v -35.625 -39.375 31.091    0.129173 0.0531274 0.990198    0.203125 0.171875
  v -33.75 -39.375 30.7629    0.129981 0.0131767 0.991429    0.21875 0.171875
  v -31.875 -39.375 30.4444    0.0902957 -0.0121494 0.995841    0.234375 0.171875
  v -30 -39.375 30.4217    -0.0119059 -0.0721153 0.997325    0.25 0.171875
  v -28.125 -39.375 30.6442    -0.0209624 -0.0746898 0.996986    0.265625 0.171875
  v -26.25 -39.375 30.5694    -0.00357786 -0.0188243 0.999816    0.28125 0.171875
  v -24.375 -39.375 30.692    -0.119384 0.0125947 0.992768    0.296875 0.171875
  v -22.5 -39.375 31.1378    -0.216455 0.0200692 0.976086    0.3125 0.171875
  v -20.625 -39.375 31.4568    -0.0264335 -0.0363416 0.99899    0.328125 0.171875
  v -18.75 -39.375 31.1827    0.201678 -0.0523888 0.97805    0.34375 0.171875
  v -16.875 -39.375 30.7331    0.143992 0.0717636 0.986973    0.359375 0.171875
  v -15 -39.375 30.4645    0.0109579 0.0958845 0.995332    0.375 0.171875
  v -13.125 -39.375 30.5852    0.0131674 -0.00321667 0.999908    0.390625 0.171875
  v -11.25 -39.375 30.5555    0.0398386 -0.00191198 0.999204    0.40625 0.171875
  v -9.375 -39.375 30.4566    -0.0849057 0.026328 0.996041    0.421875 0.171875
  v -7.5 -39.375 30.9094    -0.182157 0.0370975 0.982569    0.4375 0.171875
  v -5.625 -39.375 31.184    -0.00188853 0.0945377 0.99552    0.453125 0.171875
  v -3.75 -39.375 30.7068    0.131564 0.0640412 0.989237    0.46875 0.171875
  v -1.875 -39.375 30.5289    -0.0379001 -0.0894721 0.995268    0.484375 0.171875
  v -1.23138e-023 -39.375 31.0261    -0.0519081 -0.170486 0.983992    0.5 0.171875
  v 1.875 -39.375 31.0019    0.12517 -0.0854751 0.988446    0.515625 0.171875
  v 3.75 -39.375 30.4663    0.15257 -0.050191 0.987017    0.53125 0.171875
  v 5.625 -39.375 30.2809    -0.00831287 -0.0875968 0.996121    0.546875 0.171875
  v 7.5 -39.375 30.4738    -0.0977722 -0.0687405 0.992832    0.5625 0.171875
  v 9.375 -39.375 30.6329    -0.077543 -0.041037 0.996144    0.578125 0.171875
  v 11.25 -39.375 30.8391    -0.0378764 -0.00965526 0.999236    0.59375 0.171875
  v 13.125 -39.375 30.8988    -0.0732957 0.120181 0.990043    0.609375 0.171875
  v 15 -39.375 31.1224    -0.122829 0.220046 0.967726    0.625 0.171875
  v 16.875 -39.375 31.3877    -0.0420043 0.180471 0.982683    0.640625 0.171875
  v 18.75 -39.375 31.4223    0.00558806 0.167457 0.985863    0.65625 0.171875
  v 20.625 -39.375 31.3364    0.0217788 0.173218 0.984643    0.671875 0.171875
  v 22.5 -39.375 31.2246    -0.0143962 0.0625602 0.997937    0.6875 0.171875
  v 24.375 -39.375 31.3824    0.0112288 -0.0812047 0.996634    0.703125 0.171875
  v 26.25 -39.375 31.2502    0.163852 -0.0562689 0.984879    0.71875 0.171875
  v 28.125 -39.375 30.6796    0.233866 0.0415148 0.971382    0.734375 0.171875
  v 30 -39.375 30.1517    0.0554316 0.0296874 0.998021    0.75 0.171875
  v 31.875 -39.375 30.3655    -0.117085 -0.000144288 0.993122    0.765625 0.171875
  v 33.75 -39.375 30.6144    -0.0774625 0.0231066 0.996727    0.78125 0.171875
  v 35.625 -39.375 30.6832    -0.00453078 0.00697883 0.999965    0.796875 0.171875
  v 37.5 -39.375 30.7517    0.0122503 0.0103983 0.999871    0.8125 0.171875
  v 39.375 -39.375 30.7293    -0.00749259 0.0865822 0.996217    0.828125 0.171875
  v 41.25 -39.375 30.7017    -0.0602235 0.0669106 0.99594    0.84375 0.171875
  v 43.125 -39.375 30.9413    -0.0569086 -0.0584792 0.996665    0.859375 0.171875
  v 45 -39.375 30.9799    0.0760514 -0.115115 0.990437    0.875 0.171875
  v 46.875 -39.375 30.6156    0.104779 -0.0859186 0.990777    0.890625 0.171875
  v 48.75 -39.375 30.4998    0.0143443 -0.0824088 0.996495    0.90625 0.171875
  v 50.625 -39.375 30.6623    -0.069354 -0.072381 0.994963    0.921875 0.171875
  v 52.5 -39.375 30.8616    -0.151716 -0.0404556 0.987596    0.9375 0.171875
  v 54.375 -39.375 31.242    -0.116479 -0.00280117 0.993189    0.953125 0.171875
  v 56.25 -39.375 31.264    0.13885 0.0200222 0.990111    0.96875 0.171875
  v 58.125 -39.375 30.6566    0.258752 0.00631374 0.965923    0.984375 0.171875
  v 60 -39.375 30.2487    0.214447 -0.0232347 0.976459    1 0.171875
  v -60 -37.5 30.9349    0.0760957 0.0187091 0.996925    0 0.1875
  v -58.125 -37.5 30.7427    0.0140938 0.000185549 0.999901    0.015625 0.1875
  v -56.25 -37.5 30.8801    -0.0145535 0.00519241 0.999881    0.03125 0.1875
  v -54.375 -37.5 30.9004    0.0402053 -0.0060102 0.999173    0.046875 0.1875
  v -52.5 -37.5 30.7554    -0.0209048 0.00103522 0.999781    0.0625 0.1875
  v -50.625 -37.5 30.9512    -0.0618919 0.109827 0.992022    0.078125 0.1875
  v -48.75 -37.5 30.9943    0.0765344 0.226707 0.970951    0.09375 0.1875
  v -46.875 -37.5 30.5793    0.146978 0.191483 0.970429    0.109375 0.1875
  v -45 -37.5 30.2599    -0.00545019 0.0461375 0.99892    0.125 0.1875
  v -43.125 -37.5 30.62    -0.142373 -0.0102789 0.98976    0.140625 0.1875
  v -41.25 -37.5 31.0371    -0.118514 0.0852269 0.989288    0.15625 0.1875
  v -39.375 -37.5 31.1757    0.0103303 0.21473 0.976619    0.171875 0.1875
  v -37.5 -37.5 30.7554    0.084106 0.239965 0.967131    0.1875 0.1875
  v -35.625 -37.5 30.6391    -0.0106874 0.149531 0.988699    0.203125 0.1875
  v -33.75 -37.5 30.798    0.00909522 -0.0240528 0.999669    0.21875 0.1875
  v -31.875 -37.5 30.6824    0.0633442 -0.125339 0.99009    0.234375 0.1875
  v -30 -37.5 30.7026    0.0223902 -0.0619369 0.997829    0.25 0.1875
  v -28.125 -37.5 30.7953    0.033009 0.0636217 0.997428    0.265625 0.1875
  v -26.25 -37.5 30.5664    0.0594202 0.113907 0.991713    0.28125 0.1875
  v -24.375 -37.5 30.4955    -0.082144 0.13319 0.98768    0.296875 0.1875
  v -22.5 -37.5 30.7554    -0.232013 0.124231 0.964747    0.3125 0.1875
  v -20.625 -37.5 31.2541    -0.128257 0.0366067 0.991065    0.328125 0.1875
  v -18.75 -37.5 31.1991    0.189375 -0.0830065 0.97839    0.34375 0.1875
  v -16.875 -37.5 30.5391    0.224165 -0.0806661 0.971207    0.359375 0.1875
  v -15 -37.5 30.2934    -0.020468 -0.035438 0.999162    0.375 0.1875
  v -13.125 -37.5 30.6811    -0.0551815 -0.0585518 0.996758    0.390625 0.1875
  v -11.25 -37.5 30.5845    0.0937005 -0.0577625 0.993923    0.40625 0.1875
  v -9.375 -37.5 30.3661    -0.0165709 0.039282 0.999091    0.421875 0.1875
  v -7.5 -37.5 30.7554    -0.158098 0.137686 0.977777    0.4375 0.1875
  v -5.625 -37.5 30.9636    -0.0433038 0.118491 0.99201    0.453125 0.1875
  v -3.75 -37.5 30.7331    0.00574045 -0.0294903 0.999549    0.46875 0.1875
  v -1.875 -37.5 30.9374    -0.126529 -0.139749 0.98207    0.484375 0.1875
  v -1.23138e-023 -37.5 31.4337    0.0133901 -0.0972785 0.995167    0.5 0.1875
  v 1.875 -37.5 31    0.221415 0.0341127 0.974583    0.515625 0.1875
  v 3.75 -37.5 30.4251    0.106562 0.0489731 0.993099    0.53125 0.1875
  v 5.625 -37.5 30.4911    -0.0677394 -0.0367366 0.997027    0.546875 0.1875
  v 7.5 -37.5 30.7554    -0.0814598 -0.0734495 0.993967    0.5625 0.1875
  v 9.375 -37.5 30.8328    -0.0545323 -0.0730084 0.995839    0.578125 0.1875
  v 11.25 -37.5 30.8863    0.0288529 -0.0678942 0.997275    0.59375 0.1875
  v 13.125 -37.5 30.6586    0.0709708 -0.00569974 0.997462    0.609375 0.1875
  v 15 -37.5 30.5435    -0.0287123 0.103163 0.99425    0.625 0.1875
  v 16.875 -37.5 30.719    -0.0373188 0.19012 0.981051    0.640625 0.1875
  v 18.75 -37.5 30.7064    0.0190601 0.229166 0.973201    0.65625 0.1875
  v 20.625 -37.5 30.6337    -0.00880511 0.235308 0.971881    0.671875 0.1875
  v 22.5 -37.5 30.7554    -0.130264 0.211576 0.968642    0.6875 0.1875
  v 24.375 -37.5 31.2563    -0.0992236 0.141211 0.984994    0.703125 0.1875
  v 26.25 -37.5 31.2089    0.17464 0.0500923 0.983357    0.71875 0.1875
  v 28.125 -37.5 30.5175    0.21214 -0.0218292 0.976995    0.734375 0.1875
  v 30 -37.5 30.1888    -0.0245595 -0.138454 0.990064    0.75 0.1875
  v 31.875 -37.5 30.6371    -0.13 -0.209089 0.969217    0.765625 0.1875
  v 33.75 -37.5 30.8223    -0.0301226 -0.179161 0.983358    0.78125 0.1875
  v 35.625 -37.5 30.795    0.028228 -0.104944 0.994077    0.796875 0.1875
  v 37.5 -37.5 30.7554    0.0658919 -0.0356437 0.99719    0.8125 0.1875
  v 39.375 -37.5 30.5234    0.0524241 0.0167238 0.998485    0.828125 0.1875
  v 41.25 -37.5 30.4833    -0.0907095 0.0498768 0.994628    0.84375 0.1875
  v 43.125 -37.5 30.9238    -0.158813 0.037121 0.986611    0.859375 0.1875
  v 45 -37.5 31.1237    0.0175292 -0.0494841 0.998621    0.875 0.1875
  v 46.875 -37.5 30.8187    0.124668 -0.104451 0.986685    0.890625 0.1875
  v 48.75 -37.5 30.7316    0.075792 -0.0329093 0.99658    0.90625 0.1875
  v 50.625 -37.5 30.7284    0.00805382 0.119492 0.992803    0.921875 0.1875
  v 52.5 -37.5 30.7554    -0.100379 0.22041 0.970228    0.9375 0.1875
  v 54.375 -37.5 31.083    -0.109533 0.23909 0.9648    0.953125 0.1875
  v 56.25 -37.5 31.0999    0.109456 0.188166 0.976019    0.96875 0.1875
  v 58.125 -37.5 30.5389    0.215902 0.101885 0.971085    0.984375 0.1875
  v 60 -37.5 30.1969    0.19031 0.047386 0.98058    1 0.1875
  v -60 -35.625 30.7781    0.0610044 0.0673247 0.995864    0 0.203125
  v -58.125 -35.625 30.7328    0.00523045 0.0766952 0.997041    0.015625 0.203125
  v -56.25 -35.625 30.8213    0.0142236 0.080625 0.996643    0.03125 0.203125
  v -54.375 -35.625 30.6665    0.0238387 0.0941582 0.995272    0.046875 0.203125
  v -52.5 -35.625 30.5834    -0.0260984 0.0333035 0.999104    0.0625 0.203125
  v -50.625 -35.625 30.7187    0.0394778 0.00698172 0.999196    0.078125 0.203125
  v -48.75 -35.625 30.4293    0.146406 0.0680062 0.986884    0.09375 0.203125
  v -46.875 -35.625 30.0187    0.0279607 0.0561635 0.99803    0.109375 0.203125
  v -45 -35.625 30.2325    -0.114973 -0.0524017 0.991986    0.125 0.203125
  v -43.125 -35.625 30.7531    -0.063759 -0.0100448 0.997915    0.140625 0.203125
  v -41.25 -35.625 30.7301    0.0338819 0.166916 0.985389    0.15625 0.203125
  v -39.375 -35.625 30.498    0.0094685 0.211812 0.977265    0.171875 0.203125
  v -37.5 -35.625 30.3297    0.0185011 0.0734792 0.997125    0.1875 0.203125
  v -35.625 -35.625 30.5186    -0.087326 0.0494709 0.994951    0.203125 0.203125
  v -33.75 -35.625 30.928    -0.142002 0.0442929 0.988875    0.21875 0.203125
  v -31.875 -35.625 31.0675    0.00863776 -0.0945261 0.995485    0.234375 0.203125
  v -30 -35.625 30.8519    0.168267 -0.126452 0.977597    0.25 0.203125
  v -28.125 -35.625 30.3886    0.172165 0.0299213 0.984614    0.265625 0.203125
  v -26.25 -35.625 30.0558    0.0790381 0.120256 0.989591    0.28125 0.203125
  v -24.375 -35.625 30.055    -0.129624 0.0994117 0.986567    0.296875 0.203125
  v -22.5 -35.625 30.5019    -0.289313 0.0215326 0.956992    0.3125 0.203125
  v -20.625 -35.625 31.2678    -0.220017 -0.0179713 0.97533    0.328125 0.203125
  v -18.75 -35.625 31.5343    0.0885358 -0.0582435 0.994369    0.34375 0.203125
  v -16.875 -35.625 31.0194    0.229576 -0.119594 0.965915    0.359375 0.203125
  v -15 -35.625 30.6627    0.0265801 -0.12742 0.991493    0.375 0.203125
  v -13.125 -35.625 30.8843    -0.0733323 -0.104091 0.991861    0.390625 0.203125
  v -11.25 -35.625 30.8153    0.111359 -0.145478 0.983074    0.40625 0.203125
  v -9.375 -35.625 30.408    0.135364 -0.106386 0.985068    0.421875 0.203125
  v -7.5 -35.625 30.37    -0.0302876 0.0978478 0.99474    0.4375 0.203125
  v -5.625 -35.625 30.5445    -0.128136 0.210975 0.969057    0.453125 0.203125
  v -3.75 -35.625 30.8132    -0.170506 0.0813905 0.981989    0.46875 0.203125
  v -1.875 -35.625 31.2791    -0.176276 -0.0720908 0.981697    0.484375 0.203125
  v -1.23138e-023 -35.625 31.515    0.115015 -0.0828436 0.989903    0.5 0.203125
  v 1.875 -35.625 30.72    0.30529 0.0026759 0.952256    0.515625 0.203125
  v 3.75 -35.625 30.1857    0.0607405 0.0259445 0.997816    0.53125 0.203125
  v 5.625 -35.625 30.4948    -0.119142 -0.000844855 0.992877    0.546875 0.203125
  v 7.5 -35.625 30.7858    -0.0753937 0.0211913 0.996929    0.5625 0.203125
  v 9.375 -35.625 30.8339    -0.0751635 0.0397804 0.996377    0.578125 0.203125
  v 11.25 -35.625 31.0293    0.00438146 -0.00416959 0.999982    0.59375 0.203125
  v 13.125 -35.625 30.8443    0.0768444 -0.0572442 0.995398    0.609375 0.203125
  v 15 -35.625 30.6694    0.0387531 -0.0992318 0.994309    0.625 0.203125
  v 16.875 -35.625 30.6622    0.0396701 -0.0558175 0.997653    0.640625 0.203125
  v 18.75 -35.625 30.5113    0.0393227 0.00275917 0.999223    0.65625 0.203125
  v 20.625 -35.625 30.4303    -0.00321566 -0.00512476 0.999982    0.671875 0.203125
  v 22.5 -35.625 30.5154    -0.0931107 0.0340768 0.995072    0.6875 0.203125
  v 24.375 -35.625 30.9049    -0.12667 0.136052 0.98257    0.703125 0.203125
  v 26.25 -35.625 31.004    0.0763575 0.117409 0.990144    0.71875 0.203125
  v 28.125 -35.625 30.5714    0.0830989 -0.00537812 0.996527    0.734375 0.203125
  v 30 -35.625 30.7034    -0.125185 -0.111159 0.985887    0.75 0.203125
  v 31.875 -35.625 31.3132    -0.140116 -0.109616 0.984049    0.765625 0.203125
  v 33.75 -35.625 31.3458    0.010594 -0.105433 0.99437    0.78125 0.203125
  v 35.625 -35.625 31.1216    0.108526 -0.114401 0.987489    0.796875 0.203125
  v 37.5 -35.625 30.863    0.1156 -0.0673882 0.991007    0.8125 0.203125
  v 39.375 -35.625 30.5914    0.0548118 -0.071919 0.995903    0.828125 0.203125
  v 41.25 -35.625 30.5662    -0.0399039 -0.0887209 0.995257    0.84375 0.203125
  v 43.125 -35.625 30.8333    -0.149671 -7.97115e-005 0.988736    0.859375 0.203125
  v 45 -35.625 31.1304    -0.0726914 0.0147927 0.997245    0.875 0.203125
  v 46.875 -35.625 31.0968    0.108773 -0.0613433 0.992172    0.890625 0.203125
  v 48.75 -35.625 30.8188    0.193914 -0.0555886 0.979442    0.90625 0.203125
  v 50.625 -35.625 30.2467    0.174102 0.0327033 0.984185    0.921875 0.203125
  v 52.5 -35.625 29.9371    0.0147903 0.152567 0.988182    0.9375 0.203125
  v 54.375 -35.625 30.2012    -0.119678 0.253659 0.959862    0.953125 0.203125
  v 56.25 -35.625 30.4145    -0.0211997 0.207637 0.977976    0.96875 0.203125
  v 58.125 -35.625 30.1986    0.0837274 0.0273129 0.996114    0.984375 0.203125
  v 60 -35.625 30.0947    0.0976308 -0.0200464 0.995021    1 0.203125
  v -60 -33.75 30.7712    0.102418 -0.0877388 0.990865    0 0.21875
  v -58.125 -33.75 30.5166    0.0380026 -0.0504195 0.998005    0.015625 0.21875
  v -56.25 -33.75 30.5635    0.035635 -0.0143815 0.999261    0.03125 0.21875
  v -54.375 -33.75 30.3961    -0.00920451 0.00315019 0.999953    0.046875 0.21875
  v -52.5 -33.75 30.5837    -0.127169 -0.0613095 0.989984    0.0625 0.21875
  v -50.625 -33.75 30.9214    0.00108941 -0.162632 0.986686    0.078125 0.21875
  v -48.75 -33.75 30.5831    0.156097 -0.204952 0.966245    0.09375 0.21875
  v -46.875 -33.75 30.2713    -0.013204 -0.214173 0.976707    0.109375 0.21875
  v -45 -33.75 30.7532    -0.109708 -0.19223 0.975198    0.125 0.21875
  v -43.125 -33.75 30.921    0.103235 -0.0754252 0.991793    0.140625 0.21875
  v -41.25 -33.75 30.2705    0.184923 0.0828858 0.979251    0.15625 0.21875
  v -39.375 -33.75 29.9755    -0.0936883 0.120935 0.988229    0.171875 0.21875
  v -37.5 -33.75 30.5602    -0.119897 -0.0362267 0.992125    0.1875 0.21875
  v -35.625 -33.75 30.7133    -0.00961327 -0.0695538 0.997532    0.203125 0.21875
  v -33.75 -33.75 30.6333    -0.125996 0.036824 0.991347    0.21875 0.21875
  v -31.875 -33.75 31.0015    -0.144713 -0.00160311 0.989472    0.234375 0.21875
  v -30 -33.75 31.1624    0.136369 -0.148429 0.979475    0.25 0.21875
  v -28.125 -33.75 30.5422    0.270469 -0.164743 0.948528    0.265625 0.21875
  v -26.25 -33.75 30.0709    0.137663 -0.0913598 0.986257    0.28125 0.21875
  v -24.375 -33.75 30.0609    -0.160426 -0.0166603 0.986907    0.296875 0.21875
  v -22.5 -33.75 30.744    -0.323058 -0.0140693 0.946275    0.3125 0.21875
  v -20.625 -33.75 31.4894    -0.171701 0.0304928 0.984677    0.328125 0.21875
  v -18.75 -33.75 31.5157    0.0969293 0.124352 0.987493    0.34375 0.21875
  v -16.875 -33.75 31.0367    0.191885 0.133478 0.972298    0.359375 0.21875
  v -15 -33.75 30.75    0.0245303 0.0971797 0.994965    0.375 0.21875
  v -13.125 -33.75 30.9495    -0.111334 0.0661058 0.991582    0.390625 0.21875
  v -11.25 -33.75 31.0939    -0.00848924 -0.0572512 0.998324    0.40625 0.21875
  v -9.375 -33.75 30.8568    0.174575 -0.2186 0.960072    0.421875 0.21875
  v -7.5 -33.75 30.3977    0.190239 -0.161173 0.968418    0.4375 0.21875
  v -5.625 -33.75 30.093    -0.0301688 0.0526962 0.998155    0.453125 0.21875
  v -3.75 -33.75 30.489    -0.272667 0.143142 0.951401    0.46875 0.21875
  v -1.875 -33.75 31.2395    -0.291996 0.0713693 0.953753    0.484375 0.21875
  v -1.23138e-023 -33.75 31.6549    0.0837193 -0.0470166 0.99538    0.5 0.21875
  v 1.875 -33.75 30.8712    0.328101 -0.105178 0.938769    0.515625 0.21875
  v 3.75 -33.75 30.3402    0.0646089 -0.107421 0.992112    0.53125 0.21875
  v 5.625 -33.75 30.6421    -0.0963279 -0.0862608 0.991605    0.546875 0.21875
  v 7.5 -33.75 30.73    -0.00946436 -0.027818 0.999568    0.5625 0.21875
  v 9.375 -33.75 30.6422    -0.0546498 0.0408785 0.997668    0.578125 0.21875
  v 11.25 -33.75 30.9289    -0.0314923 0.0599738 0.997703    0.59375 0.21875
  v 13.125 -33.75 30.8052    0.0202629 0.0502584 0.998531    0.609375 0.21875
  v 15 -33.75 30.8823    -0.00193483 0.01222 0.999923    0.625 0.21875
  v 16.875 -33.75 30.9224    0.0778865 -0.00248992 0.996959    0.640625 0.21875
  v 18.75 -33.75 30.6118    0.0512812 0.019104 0.998501    0.65625 0.21875
  v 20.625 -33.75 30.6452    -0.0279259 -0.00472182 0.999599    0.671875 0.21875
  v 22.5 -33.75 30.7461    -0.0292635 -0.028596 0.999163    0.6875 0.21875
  v 24.375 -33.75 30.7361    -0.0540273 0.00234376 0.998537    0.703125 0.21875
  v 26.25 -33.75 30.7235    0.0244272 -0.00437812 0.999692    0.71875 0.21875
  v 28.125 -33.75 30.5618    0.00825263 -0.0408805 0.99913    0.734375 0.21875
  v 30 -33.75 30.8768    -0.106059 -0.00813003 0.994327    0.75 0.21875
  v 31.875 -33.75 31.1713    -0.0751104 0.114468 0.990583    0.765625 0.21875
  v 33.75 -33.75 31.0824    -0.0222639 0.159616 0.986928    0.78125 0.21875
  v 35.625 -33.75 31.1632    0.0650614 0.0846638 0.994283    0.796875 0.21875
  v 37.5 -33.75 30.9194    0.128399 0.0506078 0.99043    0.8125 0.21875
  v 39.375 -33.75 30.705    0.0119311 0.0558523 0.998368    0.828125 0.21875
  v 41.25 -33.75 30.91    -0.0293383 0.0255847 0.999242    0.84375 0.21875
  v 43.125 -33.75 30.9186    -0.0548702 0.0714397 0.995935    0.859375 0.21875
  v 45 -33.75 31.0564    -0.07543 0.135692 0.987875    0.875 0.21875
  v 46.875 -33.75 31.1539    0.0511122 0.112018 0.992391    0.890625 0.21875
  v 48.75 -33.75 30.8427    0.139478 0.0150818 0.99011    0.90625 0.21875
  v 50.625 -33.75 30.3857    0.151901 -0.155237 0.976129    0.921875 0.21875
  v 52.5 -33.75 30.1532    0.099551 -0.236972 0.966402    0.9375 0.21875
  v 54.375 -33.75 30.0654    -0.0339418 -0.157959 0.986862    0.953125 0.21875
  v 56.25 -33.75 30.196    -0.111437 -0.103385 0.988379    0.96875 0.21875
  v 58.125 -33.75 30.4285    -0.0896018 -0.197956 0.976107    0.984375 0.21875
  v 60 -33.75 30.6653    -0.0631892 -0.263739 0.962522    1 0.21875
  v -60 -31.875 30.9347    -0.0131008 0.0570244 0.998287    0 0.234375
  v -58.125 -31.875 30.861    0.0241237 -0.0523905 0.998335    0.015625 0.234375
  v -56.25 -31.875 30.8913    0.0442221 -0.0844748 0.995444    0.03125 0.234375
  v -54.375 -31.875 30.64    -0.00619872 -0.101444 0.994822    0.046875 0.234375
  v -52.5 -31.875 30.8592    -0.16374 -0.0938302 0.982031    0.0625 0.234375
  v -50.625 -31.875 31.3509    -0.0753347 -0.0882126 0.993249    0.078125 0.234375
  v -48.75 -31.875 31.1917    0.09089 -0.16071 0.982808    0.09375 0.234375
  v -46.875 -31.875 30.9645    0.0310794 -0.211802 0.976818    0.109375 0.234375
  v -45 -31.875 31.2012    -0.0124396 -0.118569 0.992868    0.125 0.234375
  v -43.125 -31.875 30.9622    0.164741 -0.0716196 0.983733    0.140625 0.234375
  v -41.25 -31.875 30.1837    0.235934 -0.139888 0.961648    0.15625 0.234375
  v -39.375 -31.875 29.9529    -0.0587459 -0.0899328 0.994214    0.171875 0.234375
  v -37.5 -31.875 30.7261    -0.170191 0.0515258 0.984063    0.1875 0.234375
  v -35.625 -31.875 30.8171    0.00888269 0.093457 0.995584    0.203125 0.234375
  v -33.75 -31.875 30.5916    -0.0851045 0.0703518 0.993885    0.21875 0.234375
  v -31.875 -31.875 31.052    -0.226892 0.0432265 0.97296    0.234375 0.234375
  v -30 -31.875 31.5061    0.0310008 -0.0121376 0.999446    0.25 0.234375
  v -28.125 -31.875 31.0247    0.261668 -0.0785226 0.961958    0.265625 0.234375
  v -26.25 -31.875 30.4562    0.178867 -0.147921 0.97269    0.28125 0.234375
  v -24.375 -31.875 30.1624    -0.065726 -0.13937 0.988057    0.296875 0.234375
  v -22.5 -31.875 30.7006    -0.247382 -0.000518271 0.968918    0.3125 0.234375
  v -20.625 -31.875 31.2483    -0.0960167 0.125952 0.987379    0.328125 0.234375
  v -18.75 -31.875 30.9754    0.148149 0.143188 0.978544    0.34375 0.234375
  v -16.875 -31.875 30.4723    0.157021 0.098935 0.982627    0.359375 0.234375
  v -15 -31.875 30.2955    -0.00341642 0.0592032 0.99824    0.375 0.234375
  v -13.125 -31.875 30.5508    -0.149199 0.0641904 0.986721    0.390625 0.234375
  v -11.25 -31.875 30.909    -0.184067 0.018847 0.982733    0.40625 0.234375
  v -9.375 -31.875 31.2544    0.00794561 -0.158874 0.987267    0.421875 0.234375
  v -7.5 -31.875 30.998    0.235649 -0.279453 0.930793    0.4375 0.234375
  v -5.625 -31.875 30.3123    0.148649 -0.251472 0.956381    0.453125 0.234375
  v -3.75 -31.875 30.3117    -0.174745 -0.0989107 0.979633    0.46875 0.234375
  v -1.875 -31.875 31.0016    -0.331547 0.0347144 0.9428    0.484375 0.234375
  v -1.23138e-023 -31.875 31.6721    -0.0405624 0.000526967 0.999177    0.5 0.234375
  v 1.875 -31.875 31.1406    0.284133 -0.121458 0.951061    0.515625 0.234375
  v 3.75 -31.875 30.6176    0.0865005 -0.14612 0.985478    0.53125 0.234375
  v 5.625 -31.875 30.8451    -0.0846566 -0.127559 0.988211    0.546875 0.234375
  v 7.5 -31.875 30.8538    0.0201208 -0.155944 0.987561    0.5625 0.234375
  v 9.375 -31.875 30.6714    0.00785951 -0.153242 0.988157    0.578125 0.234375
  v 11.25 -31.875 30.8466    -0.00111335 -0.0856857 0.996322    0.59375 0.234375
  v 13.125 -31.875 30.6853    0.0661625 -0.0032703 0.997803    0.609375 0.234375
  v 15 -31.875 30.7344    0.0251987 0.114663 0.993085    0.625 0.234375
  v 16.875 -31.875 30.6956    0.0805006 0.179734 0.980416    0.640625 0.234375
  v 18.75 -31.875 30.3571    0.047223 0.165059 0.985153    0.65625 0.234375
  v 20.625 -31.875 30.4779    -0.0514653 0.144512 0.988164    0.671875 0.234375
  v 22.5 -31.875 30.6045    -0.0733612 0.117847 0.990318    0.6875 0.234375
  v 24.375 -31.875 30.6676    -0.120508 0.00984852 0.992664    0.703125 0.234375
  v 26.25 -31.875 30.9388    -0.0429344 -0.133537 0.990113    0.71875 0.234375
  v 28.125 -31.875 30.9115    0.0279701 -0.172288 0.98465    0.734375 0.234375
  v 30 -31.875 30.9389    0.0262184 -0.0814112 0.996336    0.75 0.234375
  v 31.875 -31.875 30.7939    0.0517482 0.0733353 0.995964    0.765625 0.234375
  v 33.75 -31.875 30.6433    -0.0402625 0.134044 0.990157    0.78125 0.234375
  v 35.625 -31.875 30.884    -0.0179532 0.0715404 0.997276    0.796875 0.234375
  v 37.5 -31.875 30.698    0.153639 0.0386042 0.987373    0.8125 0.234375
  v 39.375 -31.875 30.4146    0.0447585 0.11462 0.992401    0.828125 0.234375
  v 41.25 -31.875 30.5721    -0.0522311 0.137533 0.989119    0.84375 0.234375
  v 43.125 -31.875 30.4994    -0.0103067 0.0969719 0.995234    0.859375 0.234375
  v 45 -31.875 30.5576    -0.0393464 0.10974 0.993181    0.875 0.234375
  v 46.875 -31.875 30.6471    -0.000519023 0.122796 0.992432    0.890625 0.234375
  v 48.75 -31.875 30.5264    0.00148382 0.0870547 0.996202    0.90625 0.234375
  v 50.625 -31.875 30.7496    -0.0578263 -0.028869 0.997909    0.921875 0.234375
  v 52.5 -31.875 30.9417    0.0117548 -0.195671 0.980599    0.9375 0.234375
  v 54.375 -31.875 30.7329    0.0337311 -0.264857 0.963698    0.953125 0.234375
  v 56.25 -31.875 30.7639    -0.0961072 -0.235183 0.967188    0.96875 0.234375
  v 58.125 -31.875 31.0974    -0.170216 -0.238366 0.956142    0.984375 0.234375
  v 60 -31.875 31.4237    -0.149192 -0.301947 0.941578    1 0.234375
  v -60 -30 30.5387    -0.130218 0.149608 0.980133    0 0.25
  v -58.125 -30 30.7652    -0.0482324 0.106046 0.993191    0.015625 0.25
  v -56.25 -30 30.8307    0.0125605 0.0769442 0.996956    0.03125 0.25
  v -54.375 -30 30.7242    -0.0383786 0.0451059 0.998245    0.046875 0.25
  v -52.5 -30 31.0242    -0.120098 0.0408942 0.99192    0.0625 0.25
  v -50.625 -30 31.2993    -0.0521705 0.126452 0.9906    0.078125 0.25
  v -48.75 -30 31.1737    -0.00205471 0.127152 0.991881    0.09375 0.25
  v -46.875 -30 31.2306    0.0363637 0.0353425 0.998713    0.109375 0.25
  v -45 -30 31.1575    0.0600789 0.0647003 0.996095    0.125 0.25
  v -43.125 -30 30.8472    0.0383352 0.0110549 0.999204    0.140625 0.25
  v -41.25 -30 30.7496    0.0893562 -0.249766 0.964174    0.15625 0.25
  v -39.375 -30 30.6198    0.113234 -0.303484 0.946084    0.171875 0.25
  v -37.5 -30 30.5572    0.0647325 -0.0170682 0.997757    0.1875 0.25
  v -35.625 -30 30.2493    0.0254779 0.18288 0.982805    0.203125 0.25
  v -33.75 -30 30.2659    -0.149475 0.132546 0.979841    0.21875 0.25
  v -31.875 -30 30.8738    -0.24967 0.0654789 0.966115    0.234375 0.25
  v -30 -30 31.301    0.00858953 0.0675963 0.997676    0.25 0.25
  v -28.125 -30 30.8323    0.198868 0.0515812 0.978668    0.265625 0.25
  v -26.25 -30 30.4828    0.0626471 -0.0398725 0.997239    0.28125 0.25
  v -24.375 -30 30.5823    -0.0357831 -0.139917 0.989516    0.296875 0.25
  v -22.5 -30 30.863    -0.0714423 -0.0339867 0.996866    0.3125 0.25
  v -20.625 -30 30.9027    -0.0420963 0.120111 0.991868    0.328125 0.25
  v -18.75 -30 30.7574    0.0673722 0.0577448 0.996055    0.34375 0.25
  v -16.875 -30 30.5704    0.0642573 -0.0813363 0.994613    0.359375 0.25
  v -15 -30 30.5858    -0.0127504 -0.142135 0.989765    0.375 0.25
  v -13.125 -30 30.7464    -0.100567 -0.0862553 0.991184    0.390625 0.25
  v -11.25 -30 31.0215    -0.195076 0.011196 0.980724    0.40625 0.25
  v -9.375 -30 31.5847    -0.107435 0.051182 0.992894    0.421875 0.25
  v -7.5 -30 31.5462    0.136159 -0.0161404 0.990555    0.4375 0.25
  v -5.625 -30 31.0101    0.160163 -0.143344 0.976627    0.453125 0.25
  v -3.75 -30 30.8787    -0.0159268 -0.153362 0.988042    0.46875 0.25
  v -1.875 -30 31.1377    -0.205182 0.0152451 0.978605    0.484375 0.25
  v -1.23138e-023 -30 31.6292    -0.103867 0.119734 0.987358    0.5 0.25
  v 1.875 -30 31.4203    0.203574 0.0429654 0.978116    0.515625 0.25
  v 3.75 -30 30.9423    0.114656 0.0140518 0.993306    0.53125 0.25
  v 5.625 -30 31.0412    -0.103342 0.0391735 0.993874    0.546875 0.25
  v 7.5 -30 31.2317    -0.0648774 -0.0349402 0.997281    0.5625 0.25
  v 9.375 -30 31.2567    0.0139407 -0.126144 0.991914    0.578125 0.25
  v 11.25 -30 31.2673    0.0688119 -0.100782 0.992526    0.59375 0.25
  v 13.125 -30 30.9603    0.156653 -0.0695744 0.9852    0.609375 0.25
  v 15 -30 30.5537    0.141928 -0.0393334 0.989095    0.625 0.25
  v 16.875 -30 30.1635    0.116648 -0.00574191 0.993157    0.640625 0.25
  v 18.75 -30 29.9466    0.0182205 -0.0181254 0.99967    0.65625 0.25
  v 20.625 -30 30.1475    -0.0494586 -0.0230981 0.998509    0.671875 0.25
  v 22.5 -30 30.2059    -0.0971915 0.0246006 0.994962    0.6875 0.25
  v 24.375 -30 30.5667    -0.223633 0.050419 0.973369    0.703125 0.25
  v 26.25 -30 31.3117    -0.139172 0.0261515 0.989923    0.71875 0.25
  v 28.125 -30 31.3266    0.0150443 -0.0199686 0.999687    0.734375 0.25
  v 30 -30 31.1662    0.101835 -0.0681587 0.992464    0.75 0.25
  v 31.875 -30 30.7883    0.164445 -0.0450239 0.985358    0.765625 0.25
  v 33.75 -30 30.5087    -0.0275251 0.0297689 0.999178    0.78125 0.25
  v 35.625 -30 30.8769    -0.0968954 0.0251701 0.994976    0.796875 0.25
  v 37.5 -30 30.8928    0.17035 -0.0264566 0.985028    0.8125 0.25
  v 39.375 -30 30.3146    0.124276 0.0149392 0.992135    0.828125 0.25
  v 41.25 -30 30.2726    -0.0974137 0.0207598 0.995027    0.84375 0.25
  v 43.125 -30 30.4956    -0.064815 -0.0769164 0.994929    0.859375 0.25
  v 45 -30 30.6321    -0.0159089 -0.0916182 0.995667    0.875 0.25
  v 46.875 -30 30.6469    -0.00442772 -0.0521634 0.998629    0.890625 0.25
  v 48.75 -30 30.6194    0.0262555 -0.0313829 0.999162    0.90625 0.25
  v 50.625 -30 30.7023    -0.0966988 0.0569398 0.993684    0.921875 0.25
  v 52.5 -30 30.962    -0.106323 0.0524695 0.992946    0.9375 0.25
  v 54.375 -30 31.0622    0.00495001 -0.0260586 0.999648    0.953125 0.25
  v 56.25 -30 31.1045    -0.0657853 -0.0117477 0.997765    0.96875 0.25
  v 58.125 -30 31.3625    -0.18964 0.0258147 0.981514    0.984375 0.25
  v 60 -30 31.81    -0.211877 -0.0442511 0.976294    1 0.25
  v -60 -28.125 30.2726    -0.164804 -0.103935 0.980835    0 0.265625
  v -58.125 -28.125 30.5671    -0.0730698 -0.0540114 0.995863    0.015625 0.265625
  v -56.25 -28.125 30.6079    0.0323598 -0.0149913 0.999364    0.03125 0.265625
  v -54.375 -28.125 30.5172    -0.0451758 0.0364176 0.998315    0.046875 0.265625
  v -52.5 -28.125 30.8207    -0.0800242 0.0521585 0.995427    0.0625 0.265625
  v -50.625 -28.125 30.8169    0.0279505 0.0957457 0.995013    0.078125 0.265625
  v -48.75 -28.125 30.6207    -0.0438322 0.127695 0.990844    0.09375 0.265625
  v -46.875 -28.125 30.9526    -0.0204734 0.0841999 0.996239    0.109375 0.265625
  v -45 -28.125 30.7999    0.0879096 0.0919701 0.991874    0.125 0.265625
  v -43.125 -28.125 30.6482    -0.109104 0.105434 0.988423    0.140625 0.265625
  v -41.25 -28.125 31.3054    -0.171737 -0.0594353 0.983348    0.15625 0.265625
  v -39.375 -28.125 31.4528    0.150807 -0.246941 0.957224    0.171875 0.265625
  v -37.5 -28.125 30.6601    0.311003 -0.202869 0.928505    0.1875 0.265625
  v -35.625 -28.125 29.9196    0.113358 -0.0699771 0.991087    0.203125 0.265625
  v -33.75 -28.125 30.1221    -0.210009 -0.0211672 0.97747    0.21875 0.265625
  v -31.875 -28.125 30.8593    -0.274308 -0.0315166 0.961125    0.234375 0.265625
  v -30 -28.125 31.2438    0.004292 -0.0494733 0.998766    0.25 0.265625
  v -28.125 -28.125 30.772    0.175711 -0.0648466 0.982304    0.265625 0.265625
  v -26.25 -28.125 30.5966    0.0133028 -0.0395302 0.99913    0.28125 0.265625
  v -24.375 -28.125 30.9427    -0.031287 0.00825256 0.999476    0.296875 0.265625
  v -22.5 -28.125 30.878    0.0775702 0.0863141 0.993244    0.3125 0.265625
  v -20.625 -28.125 30.5177    0.0183253 0.181618 0.983198    0.328125 0.265625
  v -18.75 -28.125 30.68    -0.0630413 0.163202 0.984577    0.34375 0.265625
  v -16.875 -28.125 30.8534    -0.0464541 0.066343 0.996715    0.359375 0.265625
  v -15 -28.125 30.9634    -0.00988381 0.0145868 0.999845    0.375 0.265625
  v -13.125 -28.125 30.9319    -0.00411828 0.0537055 0.998548    0.390625 0.265625
  v -11.25 -28.125 30.9484    -0.0712534 0.14505 0.986855    0.40625 0.265625
  v -9.375 -28.125 31.1677    -0.0514118 0.245005 0.968158    0.421875 0.265625
  v -7.5 -28.125 31.0103    0.0623058 0.273564 0.959834    0.4375 0.265625
  v -5.625 -28.125 30.8534    0.0459025 0.210259 0.976568    0.453125 0.265625
  v -3.75 -28.125 30.9741    0.00766344 0.140437 0.99006    0.46875 0.265625
  v -1.875 -28.125 30.9037    -0.0665744 0.165373 0.983982    0.484375 0.265625
  v -1.23138e-023 -28.125 31.0889    -0.0701214 0.229382 0.970807    0.5 0.265625
  v 1.875 -28.125 31.0749    0.135858 0.221905 0.965557    0.515625 0.265625
  v 3.75 -28.125 30.6275    0.12501 0.201598 0.971458    0.53125 0.265625
  v 5.625 -28.125 30.5894    -0.0960669 0.218191 0.971166    0.546875 0.265625
  v 7.5 -28.125 30.9566    -0.148345 0.204878 0.967481    0.5625 0.265625
  v 9.375 -28.125 31.2501    -0.0391765 0.158536 0.986576    0.578125 0.265625
  v 11.25 -28.125 31.1981    0.092043 0.136566 0.986346    0.59375 0.265625
  v 13.125 -28.125 30.8374    0.109908 0.0981296 0.989086    0.609375 0.265625
  v 15 -28.125 30.6333    0.0596943 -0.0349535 0.997605    0.625 0.265625
  v 16.875 -28.125 30.5497    0.0585451 -0.181058 0.981728    0.640625 0.265625
  v 18.75 -28.125 30.4808    -0.00406184 -0.239226 0.970955    0.65625 0.265625
  v 20.625 -28.125 30.6423    -0.014615 -0.222186 0.974895    0.671875 0.265625
  v 22.5 -28.125 30.5608    -0.00767092 -0.15866 0.987304    0.6875 0.265625
  v 24.375 -28.125 30.6987    -0.122187 -0.0428138 0.991583    0.703125 0.265625
  v 26.25 -28.125 31.0495    -0.0822293 0.0994385 0.99164    0.71875 0.265625
  v 28.125 -28.125 30.8963    -0.0266888 0.15242 0.987955    0.734375 0.265625
  v 30 -28.125 31.048    0.0109274 0.0815343 0.996611    0.75 0.265625
  v 31.875 -28.125 30.9368    0.171267 0.00361297 0.985218    0.765625 0.265625
  v 33.75 -28.125 30.5144    0.0482339 0.0483919 0.997663    0.78125 0.265625
  v 35.625 -28.125 30.8047    -0.097677 0.134679 0.986063    0.796875 0.265625
  v 37.5 -28.125 30.8993    0.136127 0.128203 0.982361    0.8125 0.265625
  v 39.375 -28.125 30.2206    0.11741 0.0764482 0.990137    0.828125 0.265625
  v 41.25 -28.125 30.3032    -0.172838 0.00377979 0.984943    0.84375 0.265625
  v 43.125 -28.125 30.9062    -0.138447 -0.0810977 0.987044    0.859375 0.265625
  v 45 -28.125 30.9974    0.0296902 -0.0804416 0.996317    0.875 0.265625
  v 46.875 -28.125 30.814    0.0267553 -0.0317723 0.999137    0.890625 0.265625
  v 48.75 -28.125 30.7995    0.0581043 -0.0558988 0.996744    0.90625 0.265625
  v 50.625 -28.125 30.5108    -0.0169569 -0.0480733 0.9987    0.921875 0.265625
  v 52.5 -28.125 30.699    -0.124717 -0.0143253 0.992089    0.9375 0.265625
  v 54.375 -28.125 30.9951    -0.00229391 6.16418e-005 0.999997    0.953125 0.265625
  v 56.25 -28.125 30.8601    0.0101649 0.0799634 0.996746    0.96875 0.265625
  v 58.125 -28.125 30.974    -0.127173 0.182807 0.974889    0.984375 0.265625
  v 60 -28.125 31.4072    -0.221446 0.228665 0.947984    1 0.265625
  v -60 -26.25 30.6772    -0.141016 -0.159106 0.977139    0 0.28125
  v -58.125 -26.25 31.0336    -0.0559517 -0.136986 0.988992    0.015625 0.28125
  v -56.25 -26.25 30.9643    0.0944261 -0.100221 0.990474    0.03125 0.28125
  v -54.375 -26.25 30.6284    0.00208783 -0.0670475 0.997748    0.046875 0.28125
  v -52.5 -26.25 30.8226    -0.0709462 -0.0593127 0.995715    0.0625 0.28125
  v -50.625 -26.25 30.8343    0.0508271 -0.061897 0.996788    0.078125 0.28125
  v -48.75 -26.25 30.6503    -0.0412467 -0.0560448 0.997576    0.09375 0.28125
  v -46.875 -26.25 31.0037    -0.0694806 -0.0791822 0.994436    0.109375 0.28125
  v -45 -26.25 30.8362    0.151884 -0.0916867 0.984137    0.125 0.28125
  v -43.125 -26.25 30.5211    -0.0205302 0.0523543 0.998418    0.140625 0.28125
  v -41.25 -26.25 31.1167    -0.276104 0.19065 0.942029    0.15625 0.28125
  v -39.375 -26.25 31.5881    -0.0492789 0.0689336 0.996403    0.171875 0.28125
  v -37.5 -26.25 31.1432    0.281833 -0.184494 0.941558    0.1875 0.28125
  v -35.625 -26.25 30.4376    0.200877 -0.253582 0.946227    0.203125 0.28125
  v -33.75 -26.25 30.4694    -0.121092 -0.119587 0.985411    0.21875 0.28125
  v -31.875 -26.25 31.0389    -0.236667 0.0466371 0.970471    0.234375 0.28125
  v -30 -26.25 31.4207    -0.042094 0.0813959 0.995793    0.25 0.28125
  v -28.125 -26.25 31.1081    0.154369 -0.00183582 0.988012    0.265625 0.28125
  v -26.25 -26.25 30.8493    0.107208 -0.0114772 0.99417    0.28125 0.28125
  v -24.375 -26.25 30.7132    0.0555566 0.0800274 0.995243    0.296875 0.28125
  v -22.5 -26.25 30.4022    0.123886 0.102136 0.987026    0.3125 0.28125
  v -20.625 -26.25 30.0809    0.0664091 0.0922973 0.993514    0.328125 0.28125
  v -18.75 -26.25 30.2253    -0.0895184 0.129237 0.987565    0.34375 0.28125
  v -16.875 -26.25 30.4254    -0.100369 0.120094 0.987676    0.359375 0.28125
  v -15 -26.25 30.5708    -0.0188983 0.0887313 0.995876    0.375 0.28125
  v -13.125 -26.25 30.5088    0.0551581 0.109345 0.992472    0.390625 0.28125
  v -11.25 -26.25 30.4222    0.0171226 0.185502 0.982495    0.40625 0.28125
  v -9.375 -26.25 30.488    -0.0427358 0.223539 0.973758    0.421875 0.28125
  v -7.5 -26.25 30.4054    0.0263975 0.137978 0.990083    0.4375 0.28125
  v -5.625 -26.25 30.3426    0.0267603 0.101982 0.994426    0.453125 0.28125
  v -3.75 -26.25 30.4142    -0.0217751 0.130923 0.991153    0.46875 0.28125
  v -1.875 -26.25 30.36    -0.0777033 0.0870959 0.993165    0.484375 0.28125
  v -1.23138e-023 -26.25 30.6365    -0.0433576 0.0475779 0.997926    0.5 0.28125
  v 1.875 -26.25 30.6277    0.129744 0.083368 0.988037    0.515625 0.28125
  v 3.75 -26.25 30.1659    0.111808 0.0871457 0.989901    0.53125 0.28125
  v 5.625 -26.25 30.1518    -0.0862402 0.0701635 0.993801    0.546875 0.28125
  v 7.5 -26.25 30.52    -0.125829 0.104163 0.986568    0.5625 0.28125
  v 9.375 -26.25 30.7367    -0.0545479 0.165082 0.98477    0.578125 0.28125
  v 11.25 -26.25 30.6809    0.0529506 0.134897 0.989444    0.59375 0.28125
  v 13.125 -26.25 30.4369    0.0452123 0.0848756 0.995365    0.609375 0.28125
  v 15 -26.25 30.6238    -0.071945 0.0719514 0.99481    0.625 0.28125
  v 16.875 -26.25 30.9306    -0.0686781 8.78785e-005 0.997639    0.640625 0.28125
  v 18.75 -26.25 30.949    -0.0184328 -0.0825519 0.996416    0.65625 0.28125
  v 20.625 -26.25 31.0261    0.0346996 -0.0645677 0.99731    0.671875 0.28125
  v 22.5 -26.25 30.8388    0.0615838 -0.0149917 0.997989    0.6875 0.28125
  v 24.375 -26.25 30.7532    -0.0368016 0.00436316 0.999313    0.703125 0.28125
  v 26.25 -26.25 30.8068    -0.0252854 -0.00266194 0.999677    0.71875 0.28125
  v 28.125 -26.25 30.6427    -0.0287495 -0.0238002 0.999303    0.734375 0.28125
  v 30 -26.25 30.9372    -0.0287382 -0.00864644 0.99955    0.75 0.28125
  v 31.875 -26.25 30.8977    0.158662 0.0251295 0.987013    0.765625 0.28125
  v 33.75 -26.25 30.3749    0.135964 0.0590773 0.988951    0.78125 0.28125
  v 35.625 -26.25 30.3731    -0.0264822 0.126941 0.991557    0.796875 0.28125
  v 37.5 -26.25 30.3487    0.0950292 0.134592 0.986334    0.8125 0.28125
  v 39.375 -26.25 29.889    0.0292987 0.0580928 0.997881    0.828125 0.28125
  v 41.25 -26.25 30.2708    -0.24511 -0.0207447 0.969273    0.84375 0.28125
  v 43.125 -26.25 30.9639    -0.169779 -0.0583158 0.983755    0.859375 0.28125
  v 45 -26.25 30.9576    0.0632169 -0.0592609 0.996239    0.875 0.28125
  v 46.875 -26.25 30.6716    0.0443261 -0.0450603 0.998    0.890625 0.28125
  v 48.75 -26.25 30.7481    -0.000664509 -0.0518991 0.998652    0.90625 0.28125
  v 50.625 -26.25 30.7209    -0.0336509 -0.0798331 0.99624    0.921875 0.28125
  v 52.5 -26.25 31.0295    -0.126763 -0.0948145 0.987391    0.9375 0.28125
  v 54.375 -26.25 31.2159    0.0430273 -0.103191 0.99373    0.953125 0.28125
  v 56.25 -26.25 30.8192    0.145398 -0.0155039 0.989252    0.96875 0.28125
  v 58.125 -26.25 30.7069    0.00499582 0.145512 0.989344    0.984375 0.28125
  v 60 -26.25 30.8394    -0.118264 0.242242 0.962981    1 0.28125
  v -60 -24.375 31.0619    0.0193564 -0.0228171 0.999552    0 0.296875
  v -58.125 -24.375 31.1623    0.0169754 0.0392641 0.999085    0.015625 0.296875
  v -56.25 -24.375 30.944    0.117725 0.0969315 0.988304    0.03125 0.296875
  v -54.375 -24.375 30.6392    -0.0173591 0.0813108 0.996538    0.046875 0.296875
  v -52.5 -24.375 30.9822    -0.105079 0.0264664 0.994112    0.0625 0.296875
  v -50.625 -24.375 31.0704    0.0455998 -0.00656592 0.998938    0.078125 0.296875
  v -48.75 -24.375 30.8429    -0.0329598 -0.00336903 0.999451    0.09375 0.296875
  v -46.875 -24.375 31.1759    -0.151082 -0.0401035 0.987707    0.109375 0.296875
  v -45 -24.375 31.2601    0.152016 -0.169048 0.973814    0.125 0.296875
  v -43.125 -24.375 30.6192    0.212434 -0.101418 0.971898    0.140625 0.296875
  v -41.25 -24.375 30.5065    -0.106176 0.189284 0.976165    0.15625 0.296875
  v -39.375 -24.375 31.0141    -0.224875 0.320965 0.920007    0.171875 0.296875
  v -37.5 -24.375 31.3931    0.0105604 0.122897 0.992363    0.1875 0.296875
  v -35.625 -24.375 31.0795    0.185249 -0.128811 0.974213    0.203125 0.296875
  v -33.75 -24.375 30.7047    0.0765127 -0.129808 0.988583    0.21875 0.296875
  v -31.875 -24.375 30.7097    -0.064581 0.0525237 0.996529    0.234375 0.296875
  v -30 -24.375 30.8345    -0.0552442 0.169744 0.983939    0.25 0.296875
  v -28.125 -24.375 30.7984    0.0623595 0.113877 0.991536    0.265625 0.296875
  v -26.25 -24.375 30.6502    0.103509 0.0390506 0.993862    0.28125 0.296875
  v -24.375 -24.375 30.4015    0.0537213 0.00436324 0.998546    0.296875 0.296875
  v -22.5 -24.375 30.3245    0.0492029 -0.0856063 0.995113    0.3125 0.296875
  v -20.625 -24.375 30.2394    0.0630818 -0.168395 0.983699    0.328125 0.296875
  v -18.75 -24.375 30.1882    -0.0463297 -0.140892 0.98894    0.34375 0.296875
  v -16.875 -24.375 30.357    -0.113828 -0.107794 0.987635    0.359375 0.296875
  v -15 -24.375 30.6353    -0.0322696 -0.103256 0.994131    0.375 0.296875
  v -13.125 -24.375 30.5747    0.104562 -0.0774184 0.9915    0.390625 0.296875
  v -11.25 -24.375 30.279    0.111313 -0.0113412 0.993721    0.40625 0.296875
  v -9.375 -24.375 30.1131    -0.0814172 0.0395628 0.995895    0.421875 0.296875
  v -7.5 -24.375 30.4265    -0.0970767 -0.0698912 0.99282    0.4375 0.296875
  v -5.625 -24.375 30.567    0.0332937 -0.154962 0.987359    0.453125 0.296875
  v -3.75 -24.375 30.4021    -0.00930079 -0.120834 0.992629    0.46875 0.296875
  v -1.875 -24.375 30.4941    -0.144717 -0.140938 0.979384    0.484375 0.296875
  v -1.23138e-023 -24.375 31.0061    -0.0332298 -0.181253 0.982875    0.5 0.296875
  v 1.875 -24.375 30.7823    0.184277 -0.115759 0.976034    0.515625 0.296875
  v 3.75 -24.375 30.2437    0.105367 -0.0721264 0.991814    0.53125 0.296875
  v 5.625 -24.375 30.346    -0.0922094 -0.0802405 0.992501    0.546875 0.296875
  v 7.5 -24.375 30.6567    -0.0474886 -0.0520204 0.997516    0.5625 0.296875
  v 9.375 -24.375 30.5664    -0.0122365 0.0330805 0.999378    0.578125 0.296875
  v 11.25 -24.375 30.5813    -0.0263199 0.0208546 0.999436    0.59375 0.296875
  v 13.125 -24.375 30.6264    0.0294496 -0.0664425 0.997356    0.609375 0.296875
  v 15 -24.375 30.5795    -0.0125952 -0.0383544 0.999185    0.625 0.296875
  v 16.875 -24.375 30.6162    -0.100423 0.0285653 0.994535    0.640625 0.296875
  v 18.75 -24.375 30.8254    -0.0644356 -0.0080657 0.997889    0.65625 0.296875
  v 20.625 -24.375 30.9095    0.0712432 -0.0267096 0.997101    0.671875 0.296875
  v 22.5 -24.375 30.5778    0.112459 0.029137 0.993229    0.6875 0.296875
  v 24.375 -24.375 30.5096    -0.0519347 0.096392 0.993988    0.703125 0.296875
  v 26.25 -24.375 30.8536    -0.114564 0.0720286 0.990801    0.71875 0.296875
  v 28.125 -24.375 31.0091    -0.0884394 -0.0431811 0.995145    0.734375 0.296875
  v 30 -24.375 31.2301    0.0196325 -0.0970194 0.995089    0.75 0.296875
  v 31.875 -24.375 30.8921    0.213297 -0.050629 0.975675    0.765625 0.296875
  v 33.75 -24.375 30.2895    0.159116 -0.0337595 0.986683    0.78125 0.296875
  v 35.625 -24.375 30.1925    -0.0177903 -0.0560694 0.998268    0.796875 0.296875
  v 37.5 -24.375 30.2615    0.0609523 -0.0843017 0.994574    0.8125 0.296875
  v 39.375 -24.375 30.0392    -0.00422609 -0.0734894 0.997287    0.828125 0.296875
  v 41.25 -24.375 30.5022    -0.262573 -0.0172333 0.964758    0.84375 0.296875
  v 43.125 -24.375 31.1471    -0.175114 0.014629 0.984439    0.859375 0.296875
  v 45 -24.375 31.1692    0.0544276 0.00922158 0.998475    0.875 0.296875
  v 46.875 -24.375 30.9428    0.036851 -0.00955793 0.999275    0.890625 0.296875
  v 48.75 -24.375 31.0429    -0.00335242 -0.0217208 0.999758    0.90625 0.296875
  v 50.625 -24.375 30.9664    -0.00291482 -0.00421639 0.999987    0.921875 0.296875
  v 52.5 -24.375 31.0737    -0.135796 0.0335169 0.99017    0.9375 0.296875
  v 54.375 -24.375 31.3397    0.00588247 -0.0302395 0.999525    0.953125 0.296875
  v 56.25 -24.375 30.9687    0.240249 -0.084973 0.966985    0.96875 0.296875
  v 58.125 -24.375 30.455    0.144838 -0.00498844 0.989443    0.984375 0.296875
  v 60 -24.375 30.2498    0.050487 0.110399 0.992604    1 0.296875
  v -60 -22.5 31.1389    0.130688 -0.0375813 0.990711    0 0.3125
  v -58.125 -22.5 30.8306    0.12801 0.00856026 0.991736    0.015625 0.3125
  v -56.25 -22.5 30.5161    0.139223 0.0639573 0.988194    0.03125 0.3125
  v -54.375 -22.5 30.2882    -0.044275 0.0806059 0.995762    0.046875 0.3125
  v -52.5 -22.5 30.7554    -0.15473 0.0667728 0.985698    0.0625 0.3125
  v -50.625 -22.5 30.8918    0.0244747 0.0228103 0.99944    0.078125 0.3125
  v -48.75 -22.5 30.6418    -0.0118852 0.0193162 0.999743    0.09375 0.3125
  v -46.875 -22.5 30.9927    -0.22793 0.0524389 0.972264    0.109375 0.3125
  v -45 -22.5 31.5369    0.0145959 -0.0471391 0.998782    0.125 0.3125
  v -43.125 -22.5 31.0096    0.322872 -0.131689 0.937236    0.140625 0.3125
  v -41.25 -22.5 30.3215    0.193494 0.0252622 0.980776    0.15625 0.3125
  v -39.375 -22.5 30.2454    -0.128855 0.281713 0.950807    0.171875 0.3125
  v -37.5 -22.5 30.7554    -0.197049 0.326391 0.924468    0.1875 0.3125
  v -35.625 -22.5 30.9918    -0.0414764 0.129458 0.990717    0.203125 0.3125
  v -33.75 -22.5 30.8974    0.0659283 -0.106632 0.99211    0.21875 0.3125
  v -31.875 -22.5 30.7149    0.052307 -0.157914 0.986067    0.234375 0.3125
  v -30 -22.5 30.6392    -0.00259223 -0.0875613 0.996156    0.25 0.3125
  v -28.125 -22.5 30.7229    0.00146464 -0.051745 0.998659    0.265625 0.3125
  v -26.25 -22.5 30.6948    0.0603591 -0.0622053 0.996237    0.28125 0.3125
  v -24.375 -22.5 30.5745    0.000220208 -0.0700935 0.99754    0.296875 0.3125
  v -22.5 -22.5 30.7554    -0.0646771 -0.133429 0.988946    0.3125 0.3125
  v -20.625 -22.5 30.8369    0.0148149 -0.228065 0.973533    0.328125 0.3125
  v -18.75 -22.5 30.7099    0.00242823 -0.236384 0.971657    0.34375 0.3125
  v -16.875 -22.5 30.8576    -0.0761919 -0.181021 0.980524    0.359375 0.3125
  v -15 -22.5 31.0602    0.0014753 -0.129133 0.991626    0.375 0.3125
  v -13.125 -22.5 30.845    0.146659 -0.0937762 0.984732    0.390625 0.3125
  v -11.25 -22.5 30.4248    0.158126 -0.0782223 0.984316    0.40625 0.3125
  v -9.375 -22.5 30.1726    -0.0639812 -0.0396237 0.997164    0.421875 0.3125
  v -7.5 -22.5 30.7554    -0.177434 0.00284186 0.984129    0.4375 0.3125
  v -5.625 -22.5 31.0388    0.00012372 -0.00514818 0.999987    0.453125 0.3125
  v -3.75 -22.5 30.7666    0.0121287 -0.0198303 0.99973    0.46875 0.3125
  v -1.875 -22.5 30.9463    -0.177264 -0.028008 0.983765    0.484375 0.3125
  v -1.23138e-023 -22.5 31.4892    -0.0307011 -0.0479796 0.998376    0.5 0.3125
  v 1.875 -22.5 31.026    0.24985 -0.0451468 0.967231    0.515625 0.3125
  v 3.75 -22.5 30.4117    0.139898 -0.00858577 0.990129    0.53125 0.3125
  v 5.625 -22.5 30.5185    -0.0726655 0.0458192 0.996303    0.546875 0.3125
  v 7.5 -22.5 30.7554    -0.00509594 0.0880956 0.996099    0.5625 0.3125
  v 9.375 -22.5 30.4905    0.033165 0.112675 0.993078    0.578125 0.3125
  v 11.25 -22.5 30.5638    -0.0668188 0.12163 0.990324    0.59375 0.3125
  v 13.125 -22.5 30.7966    -0.0472875 0.074634 0.996089    0.609375 0.3125
  v 15 -22.5 30.7103    -0.0132841 -0.0252139 0.999594    0.625 0.3125
  v 16.875 -22.5 30.6858    -0.0893362 -0.0901488 0.991913    0.640625 0.3125
  v 18.75 -22.5 31.0294    -0.101407 -0.0995232 0.989854    0.65625 0.3125
  v 20.625 -22.5 31.1528    0.0704613 -0.103378 0.992143    0.671875 0.3125
  v 22.5 -22.5 30.7554    0.195375 -0.0796994 0.977485    0.6875 0.3125
  v 24.375 -22.5 30.4651    0.0764775 0.0602027 0.995252    0.703125 0.3125
  v 26.25 -22.5 30.5956    -0.104757 0.2292 0.967726    0.71875 0.3125
  v 28.125 -22.5 30.85    -0.191511 0.216806 0.957245    0.734375 0.3125
  v 30 -22.5 31.2617    -0.0705312 0.0624343 0.995554    0.75 0.3125
  v 31.875 -22.5 30.9793    0.20062 -0.0915414 0.975383    0.765625 0.3125
  v 33.75 -22.5 30.4185    0.13197 -0.145512 0.980515    0.78125 0.3125
  v 35.625 -22.5 30.4932    -0.0638967 -0.162052 0.984711    0.796875 0.3125
  v 37.5 -22.5 30.7554    0.0536157 -0.181172 0.981989    0.8125 0.3125
  v 39.375 -22.5 30.3882    0.0990708 -0.126963 0.986948    0.828125 0.3125
  v 41.25 -22.5 30.4209    -0.161591 0.0171844 0.986708    0.84375 0.3125
  v 43.125 -22.5 30.8941    -0.133232 0.11253 0.984676    0.859375 0.3125
  v 45 -22.5 30.9231    0.056186 0.158927 0.98569    0.875 0.3125
  v 46.875 -22.5 30.7222    0.0180672 0.169878 0.985299    0.890625 0.3125
  v 48.75 -22.5 30.8418    -0.0259653 0.135014 0.990503    0.90625 0.3125
  v 50.625 -22.5 30.7564    0.0108258 0.0865763 0.996186    0.921875 0.3125
  v 52.5 -22.5 30.7554    -0.129365 0.0914961 0.987367    0.9375 0.3125
  v 54.375 -22.5 31.2511    -0.0971279 0.0759231 0.992372    0.953125 0.3125
  v 56.25 -22.5 31.1988    0.183628 -0.024798 0.982683    0.96875 0.3125
  v 58.125 -22.5 30.5622    0.150003 -0.108002 0.982769    0.984375 0.3125
  v 60 -22.5 30.4514    0.0749763 -0.142358 0.986971    1 0.3125
  v -60 -20.625 31.1171    0.00928643 0.0431188 0.999027    0 0.328125
  v -58.125 -20.625 30.9901    0.123653 -0.0472032 0.991202    0.015625 0.328125
  v -56.25 -20.625 30.6824    0.143998 -0.0892836 0.985542    0.03125 0.328125
  v -54.375 -20.625 30.4009    -0.0109586 -0.0963031 0.995292    0.046875 0.328125
  v -52.5 -20.625 30.7363    -0.167108 -0.0602063 0.984099    0.0625 0.328125
  v -50.625 -20.625 30.9637    -0.0232302 -0.0892165 0.995741    0.078125 0.328125
  v -48.75 -20.625 30.8248    0.0354388 -0.0997267 0.994383    0.09375 0.328125
  v -46.875 -20.625 30.9878    -0.168102 0.013742 0.985674    0.109375 0.328125
  v -45 -20.625 31.5079    -0.0755683 0.0763533 0.994213    0.125 0.328125
  v -43.125 -20.625 31.2268    0.289202 0.00204233 0.957266    0.140625 0.328125
  v -41.25 -20.625 30.4132    0.335249 -0.0264552 0.941758    0.15625 0.328125
  v -39.375 -20.625 29.7887    0.0437795 0.0361173 0.998388    0.171875 0.328125
  v -37.5 -20.625 30.0029    -0.197832 0.122019 0.972612    0.1875 0.328125
  v -35.625 -20.625 30.5501    -0.227905 0.16368 0.959827    0.203125 0.328125
  v -33.75 -20.625 31.0868    -0.148931 0.0563011 0.987244    0.21875 0.328125
  v -31.875 -20.625 31.2617    -0.00190827 -0.106044 0.99436    0.234375 0.328125
  v -30 -20.625 31.1731    0.0710284 -0.136055 0.988152    0.25 0.328125
  v -28.125 -20.625 31.0561    0.0398795 -0.0631793 0.997205    0.265625 0.328125
  v -26.25 -20.625 30.9648    0.0790216 -0.0337491 0.996301    0.28125 0.328125
  v -24.375 -20.625 30.727    0.0158479 -0.0168511 0.999732    0.296875 0.328125
  v -22.5 -20.625 30.8511    -0.130133 -0.0220304 0.991252    0.3125 0.328125
  v -20.625 -20.625 31.135    -0.0559254 -0.0873601 0.994606    0.328125 0.328125
  v -18.75 -20.625 31.1345    0.0450613 -0.0965636 0.994306    0.34375 0.328125
  v -16.875 -20.625 31.1125    -0.0111956 -0.0217864 0.9997    0.359375 0.328125
  v -15 -20.625 31.1196    0.0280481 0.0050078 0.999594    0.375 0.328125
  v -13.125 -20.625 30.8583    0.140573 -0.0297844 0.989622    0.390625 0.328125
  v -11.25 -20.625 30.5095    0.121222 -0.0921178 0.988342    0.40625 0.328125
  v -9.375 -20.625 30.3376    0.0241345 -0.115053 0.993066    0.421875 0.328125
  v -7.5 -20.625 30.5989    -0.0597287 0.0530886 0.996802    0.4375 0.328125
  v -5.625 -20.625 30.5991    -0.00405549 0.180559 0.983556    0.453125 0.328125
  v -3.75 -20.625 30.4346    -0.0077655 0.136382 0.990626    0.46875 0.328125
  v -1.875 -20.625 30.6416    -0.172242 0.120703 0.977632    0.484375 0.328125
  v -1.23138e-023 -20.625 31.1503    -0.0741577 0.129423 0.988813    0.5 0.328125
  v 1.875 -20.625 30.8537    0.211626 0.0471545 0.976212    0.515625 0.328125
  v 3.75 -20.625 30.3161    0.162876 -0.0233078 0.986371    0.53125 0.328125
  v 5.625 -20.625 30.2381    0.00718706 0.00849569 0.999938    0.546875 0.328125
  v 7.5 -20.625 30.272    0.0176838 0.0734799 0.99714    0.5625 0.328125
  v 9.375 -20.625 30.071    0.0302569 0.0594609 0.997772    0.578125 0.328125
  v 11.25 -20.625 30.1672    -0.0386549 0.0660705 0.997066    0.59375 0.328125
  v 13.125 -20.625 30.3029    -0.0735078 0.145322 0.98665    0.609375 0.328125
  v 15 -20.625 30.5079    -0.138555 0.151389 0.978715    0.625 0.328125
  v 16.875 -20.625 30.9362    -0.160648 0.0510583 0.98569    0.640625 0.328125
  v 18.75 -20.625 31.284    -0.0877316 0.024705 0.995838    0.65625 0.328125
  v 20.625 -20.625 31.2974    0.0662641 0.0450038 0.996787    0.671875 0.328125
  v 22.5 -20.625 30.9485    0.212221 -0.00283923 0.977218    0.6875 0.328125
  v 24.375 -20.625 30.4014    0.226093 -0.0282745 0.973695    0.703125 0.328125
  v 26.25 -20.625 29.9277    0.0449217 0.063267 0.996985    0.71875 0.328125
  v 28.125 -20.625 30.0302    -0.213464 0.164029 0.963082    0.734375 0.328125
  v 30 -20.625 30.847    -0.252693 0.17118 0.952284    0.75 0.328125
  v 31.875 -20.625 31.1812    0.0182127 0.00999684 0.999784    0.765625 0.328125
  v 33.75 -20.625 30.8776    0.101968 -0.136145 0.985427    0.78125 0.328125
  v 35.625 -20.625 30.9037    -0.0358921 -0.118081 0.992355    0.796875 0.328125
  v 37.5 -20.625 31.0596    0.0640774 -0.076088 0.99504    0.8125 0.328125
  v 39.375 -20.625 30.5718    0.171136 -0.0815931 0.981863    0.828125 0.328125
  v 41.25 -20.625 30.3234    -0.0623519 -0.0465481 0.996968    0.84375 0.328125
  v 43.125 -20.625 30.7032    -0.0843448 -0.0147379 0.996328    0.859375 0.328125
  v 45 -20.625 30.6074    0.0983751 0.00993562 0.9951    0.875 0.328125
  v 46.875 -20.625 30.2817    0.0270898 0.0388786 0.998877    0.890625 0.328125
  v 48.75 -20.625 30.4655    -0.0675627 0.0499294 0.996465    0.90625 0.328125
  v 50.625 -20.625 30.5947    -0.0430014 0.0326548 0.998541    0.921875 0.328125
  v 52.5 -20.625 30.7215    -0.10483 0.0252364 0.99417    0.9375 0.328125
  v 54.375 -20.625 31.1185    -0.0965604 0.0842374 0.991756    0.953125 0.328125
  v 56.25 -20.625 31.0918    0.0820934 0.0768686 0.993656    0.96875 0.328125
  v 58.125 -20.625 30.7053    0.043795 -0.038695 0.998291    0.984375 0.328125
  v 60 -20.625 30.9614    -0.0715074 -0.142898 0.987151    1 0.328125
  v -60 -18.75 30.8394    -0.0712319 0.189118 0.979367    0 0.34375
  v -58.125 -18.75 31.0442    0.0322967 0.143409 0.989136    0.015625 0.34375
  v -56.25 -18.75 30.8153    0.0959299 0.082376 0.991974    0.03125 0.34375
  v -54.375 -18.75 30.663    -0.0139987 0.0292849 0.999473    0.046875 0.34375
  v -52.5 -18.75 30.9098    -0.15429 0.0345494 0.987421    0.0625 0.34375
  v -50.625 -18.75 31.2303    -0.0624361 0.0325591 0.997518    0.078125 0.34375
  v -48.75 -18.75 31.1791    0.0804872 0.0150468 0.996642    0.09375 0.34375
  v -46.875 -18.75 30.9753    -0.0449959 0.0734758 0.996281    0.109375 0.34375
  v -45 -18.75 31.1917    -0.0658546 0.122508 0.99028    0.125 0.34375
  v -43.125 -18.75 31.0573    0.217189 0.0700712 0.973611    0.140625 0.34375
  v -41.25 -18.75 30.3307    0.269948 -0.0271389 0.962492    0.15625 0.34375
  v -39.375 -18.75 29.8745    0.018554 -0.158581 0.987172    0.171875 0.34375
  v -37.5 -18.75 30.2451    -0.120291 -0.202453 0.971876    0.1875 0.34375
  v -35.625 -18.75 30.5273    -0.116644 -0.0472052 0.992051    0.203125 0.34375
  v -33.75 -18.75 30.8103    -0.187218 0.140294 0.972248    0.21875 0.34375
  v -31.875 -18.75 31.2064    -0.104941 0.130231 0.985915    0.234375 0.34375
  v -30 -18.75 31.2282    0.0795487 0.0530182 0.99542    0.25 0.34375
  v -28.125 -18.75 30.9086    0.0967311 0.0608597 0.993448    0.265625 0.34375
  v -26.25 -18.75 30.7918    0.076817 0.075144 0.99421    0.28125 0.34375
  v -24.375 -18.75 30.5853    0.00915835 0.0545469 0.998469    0.296875 0.34375
  v -22.5 -18.75 30.751    -0.164388 0.0379129 0.985667    0.3125 0.34375
  v -20.625 -18.75 31.2385    -0.09711 0.0123197 0.995197    0.328125 0.34375
  v -18.75 -18.75 31.2254    0.100141 0.0229073 0.99471    0.34375 0.34375
  v -16.875 -18.75 30.8852    0.0558298 0.0945834 0.99395    0.359375 0.34375
  v -15 -18.75 30.8932    -0.0108594 0.103456 0.994575    0.375 0.34375
  v -13.125 -18.75 30.8819    0.0560023 0.0226968 0.998173    0.390625 0.34375
  v -11.25 -18.75 30.7168    0.0160924 -0.0815743 0.996537    0.40625 0.34375
  v -9.375 -18.75 30.7933    0.0555803 -0.185669 0.981039    0.421875 0.34375
  v -7.5 -18.75 30.5877    0.127408 -0.12009 0.984554    0.4375 0.34375
  v -5.625 -18.75 30.1656    0.0351919 -0.00989294 0.999332    0.453125 0.34375
  v -3.75 -18.75 30.2631    -0.0766215 -0.0468953 0.995957    0.46875 0.34375
  v -1.875 -18.75 30.5337    -0.146446 -0.0664779 0.986982    0.484375 0.34375
  v -1.23138e-023 -18.75 30.9154    -0.0748423 0.000241603 0.997195    0.5 0.34375
  v 1.875 -18.75 30.8265    0.115832 -0.00888778 0.993229    0.515625 0.34375
  v 3.75 -18.75 30.5117    0.0948222 -0.102749 0.990178    0.53125 0.34375
  v 5.625 -18.75 30.4685    0.0335481 -0.170296 0.984822    0.546875 0.34375
  v 7.5 -18.75 30.3698    0.0365271 -0.166511 0.985363    0.5625 0.34375
  v 9.375 -18.75 30.2707    -0.00216633 -0.183935 0.982936    0.578125 0.34375
  v 11.25 -18.75 30.3969    -0.000613876 -0.202655 0.97925    0.59375 0.34375
  v 13.125 -18.75 30.2969    0.0417942 -0.138748 0.989446    0.609375 0.34375
  v 15 -18.75 30.2278    -0.101042 -0.0186916 0.994707    0.625 0.34375
  v 16.875 -18.75 30.6508    -0.189773 0.0406275 0.980987    0.640625 0.34375
  v 18.75 -18.75 30.9643    -0.0696802 0.0514043 0.996244    0.65625 0.34375
  v 20.625 -18.75 30.8957    0.0583048 0.0562812 0.996711    0.671875 0.34375
  v 22.5 -18.75 30.6885    0.116936 0.00484856 0.993128    0.6875 0.34375
  v 24.375 -18.75 30.4285    0.146387 -0.114842 0.982539    0.703125 0.34375
  v 26.25 -18.75 30.1397    0.0643943 -0.21317 0.974891    0.71875 0.34375
  v 28.125 -18.75 30.2453    -0.0939915 -0.176549 0.979794    0.734375 0.34375
  v 30 -18.75 30.7057    -0.187905 0.0373811 0.981476    0.75 0.34375
  v 31.875 -18.75 31.0361    -0.0972144 0.158179 0.982613    0.765625 0.34375
  v 33.75 -18.75 31.0596    0.0338535 0.086492 0.995677    0.78125 0.34375
  v 35.625 -18.75 30.99    0.0157681 0.0576278 0.998214    0.796875 0.34375
  v 37.5 -18.75 30.9598    0.0719441 0.0860327 0.993691    0.8125 0.34375
  v 39.375 -18.75 30.6221    0.127328 0.0503607 0.990581    0.828125 0.34375
  v 41.25 -18.75 30.4902    -0.0663193 -0.00350258 0.997792    0.84375 0.34375
  v 43.125 -18.75 30.9094    -0.0986182 -0.0357136 0.994484    0.859375 0.34375
  v 45 -18.75 30.8364    0.0868011 -0.0808252 0.992941    0.875 0.34375
  v 46.875 -18.75 30.5332    0.0370224 -0.11447 0.992737    0.890625 0.34375
  v 48.75 -18.75 30.7072    -0.0364247 -0.0964438 0.994672    0.90625 0.34375
  v 50.625 -18.75 30.7259    -0.0186545 -0.0337177 0.999257    0.921875 0.34375
  v 52.5 -18.75 30.7847    -0.0597015 0.012954 0.998132    0.9375 0.34375
  v 54.375 -18.75 30.9329    -0.0376996 0.0557679 0.997732    0.953125 0.34375
  v 56.25 -18.75 30.8082    0.0276382 0.0629381 0.997635    0.96875 0.34375
  v 58.125 -18.75 30.7506    -0.0449869 0.000252245 0.998988    0.984375 0.34375
  v 60 -18.75 31.1284    -0.176816 -0.033924 0.983659    1 0.34375
  v -60 -16.875 30.5349    0.0712361 0.190096 0.979178    0 0.359375
  v -58.125 -16.875 30.5365    0.0139204 0.251198 0.967836    0.015625 0.359375
  v -56.25 -16.875 30.3466    0.0331712 0.205774 0.978037    0.03125 0.359375
  v -54.375 -16.875 30.3301    -0.0417196 0.141859 0.989007    0.046875 0.359375
  v -52.5 -16.875 30.5841    -0.10993 0.175038 0.978405    0.0625 0.359375
  v -50.625 -16.875 30.8722    -0.0736119 0.22742 0.971011    0.078125 0.359375
  v -48.75 -16.875 30.8143    0.0396397 0.166717 0.985208    0.09375 0.359375
  v -46.875 -16.875 30.5519    -0.0384817 0.0700676 0.9968    0.109375 0.359375
  v -45 -16.875 30.8691    -0.0970643 0.0162893 0.995145    0.125 0.359375
  v -43.125 -16.875 30.949    0.110905 -0.0572786 0.992179    0.140625 0.359375
  v -41.25 -16.875 30.4022    0.14228 -0.180066 0.97331    0.15625 0.359375
  v -39.375 -16.875 30.3808    -0.0871314 -0.280506 0.955889    0.171875 0.359375
  v -37.5 -16.875 30.9907    -0.0750507 -0.292635 0.953274    0.1875 0.359375
  v -35.625 -16.875 30.8531    0.121466 -0.171604 0.977649    0.203125 0.359375
  v -33.75 -16.875 30.4983    0.00269404 0.0751012 0.997172    0.21875 0.359375
  v -31.875 -16.875 30.776    -0.138993 0.216102 0.966427    0.234375 0.359375
  v -30 -16.875 30.9761    0.0019557 0.168028 0.98578    0.25 0.359375
  v -28.125 -16.875 30.7565    0.110177 0.111658 0.98762    0.265625 0.359375
  v -26.25 -16.875 30.648    0.0626494 0.130023 0.98953    0.28125 0.359375
  v -24.375 -16.875 30.5162    -0.0128224 0.115528 0.993221    0.296875 0.359375
  v -22.5 -16.875 30.7304    -0.160562 0.112628 0.980579    0.3125 0.359375
  v -20.625 -16.875 31.1897    -0.119044 0.10688 0.98712    0.328125 0.359375
  v -18.75 -16.875 31.0746    0.109137 0.04571 0.992975    0.34375 0.359375
  v -16.875 -16.875 30.6365    0.109645 0.0332153 0.993416    0.359375 0.359375
  v -15 -16.875 30.6849    -0.0439772 0.0653639 0.996892    0.375 0.359375
  v -13.125 -16.875 30.8075    -0.043887 0.00617053 0.999017    0.390625 0.359375
  v -11.25 -16.875 30.7891    -0.0745063 -0.0891696 0.993226    0.40625 0.359375
  v -9.375 -16.875 31.134    -0.0263048 -0.167841 0.985463    0.421875 0.359375
  v -7.5 -16.875 30.9213    0.166206 -0.222353 0.960695    0.4375 0.359375
  v -5.625 -16.875 30.4454    0.0797532 -0.205335 0.975437    0.453125 0.359375
  v -3.75 -16.875 30.6936    -0.129769 -0.172524 0.97642    0.46875 0.359375
  v -1.875 -16.875 30.9951    -0.122408 -0.195629 0.973009    0.484375 0.359375
  v -1.23138e-023 -16.875 31.1532    0.0103344 -0.163455 0.986497    0.5 0.359375
  v 1.875 -16.875 30.9222    0.111163 -0.0910626 0.989621    0.515625 0.359375
  v 3.75 -16.875 30.7114    0.0397579 -0.0648073 0.997105    0.53125 0.359375
  v 5.625 -16.875 30.8746    -0.00751106 -0.0614324 0.998083    0.546875 0.359375
  v 7.5 -16.875 30.8531    0.0262078 -0.0696646 0.997226    0.5625 0.359375
  v 9.375 -16.875 30.7961    -0.053052 -0.111625 0.992333    0.578125 0.359375
  v 11.25 -16.875 30.9749    -0.0360981 -0.202714 0.978572    0.59375 0.359375
  v 13.125 -16.875 30.8291    0.0797379 -0.281891 0.956127    0.609375 0.359375
  v 15 -16.875 30.5463    0.00887258 -0.274019 0.961683    0.625 0.359375
  v 16.875 -16.875 30.7881    -0.124375 -0.166421 0.978179    0.640625 0.359375
  v 18.75 -16.875 31.0663    -0.0524957 -0.0789844 0.995493    0.65625 0.359375
  v 20.625 -16.875 31.0253    0.0403302 -0.0596569 0.997404    0.671875 0.359375
  v 22.5 -16.875 30.9049    0.0492517 -0.0895092 0.994767    0.6875 0.359375
  v 24.375 -16.875 30.8599    0.0531571 -0.12496 0.990737    0.703125 0.359375
  v 26.25 -16.875 30.8241    0.0229543 -0.139399 0.98997    0.71875 0.359375
  v 28.125 -16.875 30.9246    0.0128881 -0.126843 0.991839    0.734375 0.359375
  v 30 -16.875 30.7599    0.0522092 -0.0194152 0.998447    0.75 0.359375
  v 31.875 -16.875 30.5556    0.0155734 0.169277 0.985445    0.765625 0.359375
  v 33.75 -16.875 30.6303    -0.0205106 0.254951 0.966736    0.78125 0.359375
  v 35.625 -16.875 30.6437    -0.00906985 0.219452 0.975581    0.796875 0.359375
  v 37.5 -16.875 30.6391    0.0486568 0.163045 0.985418    0.8125 0.359375
  v 39.375 -16.875 30.3972    0.0644495 0.0927524 0.993601    0.828125 0.359375
  v 41.25 -16.875 30.3685    -0.0811041 0.0534825 0.99527    0.84375 0.359375
  v 43.125 -16.875 30.808    -0.128159 0.0757111 0.988859    0.859375 0.359375
  v 45 -16.875 30.8666    0.00264798 0.0209545 0.999777    0.875 0.359375
  v 46.875 -16.875 30.7274    1.4021e-005 -0.0904543 0.995901    0.890625 0.359375
  v 48.75 -16.875 30.8846    0.0167576 -0.102122 0.994631    0.90625 0.359375
  v 50.625 -16.875 30.729    0.0820088 0.00529427 0.996617    0.921875 0.359375
  v 52.5 -16.875 30.6553    -0.01281 0.131498 0.991234    0.9375 0.359375
  v 54.375 -16.875 30.7875    -0.0519696 0.154003 0.986703    0.953125 0.359375
  v 56.25 -16.875 30.7758    -0.0262494 0.0803198 0.996424    0.96875 0.359375
  v 58.125 -16.875 30.855    -0.092301 -0.00763492 0.995702    0.984375 0.359375
  v 60 -16.875 31.1093    -0.155451 -0.0316816 0.987335    1 0.359375
  v -60 -15 30.3449    0.200711 -0.141958 0.969311    0 0.375
  v -58.125 -15 29.9331    0.056978 -0.0334139 0.997816    0.015625 0.375
  v -56.25 -15 29.9451    -0.0471231 -0.0499921 0.997637    0.03125 0.375
  v -54.375 -15 30.2021    -0.0572109 -0.0777096 0.995333    0.046875 0.375
  v -52.5 -15 30.3541    0.00188924 0.00464386 0.999987    0.0625 0.375
  v -50.625 -15 30.2938    -0.0368254 0.140691 0.989368    0.078125 0.375
  v -48.75 -15 30.3711    -0.109736 0.105622 0.988333    0.09375 0.375
  v -46.875 -15 30.6155    -0.144395 -0.0547536 0.988004    0.109375 0.375
  v -45 -15 31.157    -0.110639 -0.070091 0.991386    0.125 0.375
  v -43.125 -15 31.2488    0.0186859 -0.0386867 0.999077    0.140625 0.375
  v -41.25 -15 31.025    0.0381306 -0.120634 0.991964    0.15625 0.375
  v -39.375 -15 31.2272    -0.0825912 -0.132788 0.987697    0.171875 0.375
  v -37.5 -15 31.567    -0.0337534 -0.0555215 0.997887    0.1875 0.375
  v -35.625 -15 31.174    0.211706 -0.0949026 0.972715    0.203125 0.375
  v -33.75 -15 30.4569    0.204522 -0.0985563 0.973888    0.21875 0.375
  v -31.875 -15 30.3051    -0.0603973 0.0395773 0.997389    0.234375 0.375
  v -30 -15 30.5734    -0.0709854 0.0748926 0.994662    0.25 0.375
  v -28.125 -15 30.5747    0.106936 0.0335848 0.993699    0.265625 0.375
  v -26.25 -15 30.2948    0.0795838 0.0619469 0.994901    0.28125 0.375
  v -24.375 -15 30.1799    -0.0217969 0.0515561 0.998432    0.296875 0.375
  v -22.5 -15 30.3709    -0.112905 0.0764806 0.990658    0.3125 0.375
  v -20.625 -15 30.711    -0.149341 0.157591 0.976147    0.328125 0.375
  v -18.75 -15 30.9171    -0.00958096 0.101579 0.994781    0.34375 0.375
  v -16.875 -15 30.7882    0.113556 3.75734e-005 0.993532    0.359375 0.375
  v -15 -15 30.6523    -0.0208385 0.0367433 0.999107    0.375 0.375
  v -13.125 -15 30.7985    -0.132015 0.0276533 0.990862    0.390625 0.375
  v -11.25 -15 31.0972    -0.114478 -0.0314778 0.992927    0.40625 0.375
  v -9.375 -15 31.4667    -0.0770261 0.010536 0.996973    0.421875 0.375
  v -7.5 -15 31.4229    0.106234 -0.0260331 0.994    0.4375 0.375
  v -5.625 -15 31.0481    0.136234 -0.0818621 0.987289    0.453125 0.375
  v -3.75 -15 30.9776    -0.0945663 -0.0215049 0.995286    0.46875 0.375
  v -1.875 -15 31.2762    -0.15297 -0.0196625 0.988035    0.484375 0.375
  v -1.23138e-023 -15 31.5029    0.0404296 -0.0583893 0.997475    0.5 0.375
  v 1.875 -15 31.1523    0.158735 -0.0387702 0.98656    0.515625 0.375
  v 3.75 -15 30.8591    0.0775604 -0.0181951 0.996822    0.53125 0.375
  v 5.625 -15 30.8169    0.0334788 0.0162997 0.999306    0.546875 0.375
  v 7.5 -15 30.6602    0.0631733 0.0784188 0.994917    0.5625 0.375
  v 9.375 -15 30.6193    -0.0909902 0.146281 0.98505    0.578125 0.375
  v 11.25 -15 31.0784    -0.169676 0.104769 0.979915    0.59375 0.375
  v 13.125 -15 31.2931    -0.0509596 -0.0405006 0.997879    0.609375 0.375
  v 15 -15 31.3036    0.0350249 -0.141224 0.989358    0.625 0.375
  v 16.875 -15 31.3373    0.00563366 -0.067794 0.997683    0.640625 0.375
  v 18.75 -15 31.3001    0.0259612 0.0402662 0.998852    0.65625 0.375
  v 20.625 -15 31.1104    0.0375652 0.0646621 0.9972    0.671875 0.375
  v 22.5 -15 31.0466    0.013497 0.0217006 0.999673    0.6875 0.375
  v 24.375 -15 31.0268    0.0509319 -0.0213115 0.998475    0.703125 0.375
  v 26.25 -15 30.8407    0.0750711 0.00103401 0.997178    0.71875 0.375
  v 28.125 -15 30.7318    0.0079751 0.0378379 0.999252    0.734375 0.375
  v 30 -15 30.6146    0.0949616 -0.0391393 0.994711    0.75 0.375
  v 31.875 -15 30.3102    0.156743 -0.0394784 0.98685    0.765625 0.375
  v 33.75 -15 30.0783    0.0262559 0.0712587 0.997112    0.78125 0.375
  v 35.625 -15 30.1178    -0.0627691 0.085173 0.994387    0.796875 0.375
  v 37.5 -15 30.2776    -0.0265099 0.0242348 0.999355    0.8125 0.375
  v 39.375 -15 30.2454    -0.00706772 -0.0368476 0.999296    0.828125 0.375
  v 41.25 -15 30.3881    -0.0615479 -0.0528935 0.996702    0.84375 0.375
  v 43.125 -15 30.6299    -0.071193 0.0421557 0.996571    0.859375 0.375
  v 45 -15 30.6864    -0.0751506 0.103775 0.991758    0.875 0.375
  v 46.875 -15 30.8923    -0.115202 0.0101476 0.99329    0.890625 0.375
  v 48.75 -15 31.1598    0.00891786 -0.108402 0.994067    0.90625 0.375
  v 50.625 -15 30.7876    0.213576 -0.121612 0.969328    0.921875 0.375
  v 52.5 -15 30.2919    0.127949 0.0157536 0.991656    0.9375 0.375
  v 54.375 -15 30.2635    -0.057706 0.137145 0.988869    0.953125 0.375
  v 56.25 -15 30.4713    -0.121969 0.109948 0.986425    0.96875 0.375
  v 58.125 -15 30.762    -0.172669 0.0343844 0.98438    0.984375 0.375
  v 60 -15 31.2038    -0.197898 -0.00553388 0.980207    1 0.375
  v -60 -13.125 30.8229    0.107303 -0.318916 0.941689    0 0.390625
  v -58.125 -13.125 30.4818    0.0577169 -0.349185 0.935275    0.015625 0.390625
  v -56.25 -13.125 30.6401    -0.0443684 -0.33886 0.93979    0.03125 0.390625
  v -54.375 -13.125 30.8293    0.0120153 -0.258363 0.965973    0.046875 0.390625
  v -52.5 -13.125 30.6744    0.154202 -0.131408 0.979262    0.0625 0.390625
  v -50.625 -13.125 30.2028    0.078087 0.0254403 0.996622    0.078125 0.390625
  v -48.75 -13.125 30.3104    -0.192207 0.0977095 0.976478    0.09375 0.390625
  v -46.875 -13.125 30.9916    -0.212993 0.0469264 0.975926    0.109375 0.390625
  v -45 -13.125 31.3441    -0.0231946 0.0798037 0.996541    0.125 0.390625
  v -43.125 -13.125 31.0344    0.0444179 0.167558 0.984861    0.140625 0.390625
  v -41.25 -13.125 31.0073    -0.00087943 0.160648 0.987011    0.15625 0.390625
  v -39.375 -13.125 31.138    0.000409 0.184137 0.982901    0.171875 0.390625
  v -37.5 -13.125 31.0306    -0.0150451 0.266452 0.963731    0.1875 0.390625
  v -35.625 -13.125 30.9509    0.0359682 0.157229 0.986907    0.203125 0.390625
  v -33.75 -13.125 30.8197    0.152325 -0.079287 0.985145    0.21875 0.390625
  v -31.875 -13.125 30.5046    0.0251934 -0.125835 0.991731    0.234375 0.390625
  v -30 -13.125 30.6872    -0.0822944 -0.0943235 0.992134    0.25 0.390625
  v -28.125 -13.125 30.7556    0.0829109 -0.132305 0.987735    0.265625 0.390625
  v -26.25 -13.125 30.3178    0.0827202 -0.163565 0.983058    0.28125 0.390625
  v -24.375 -13.125 30.3142    -0.0528942 -0.209543 0.976368    0.296875 0.390625
  v -22.5 -13.125 30.5387    -0.0397907 -0.219268 0.974853    0.3125 0.390625
  v -20.625 -13.125 30.5497    -0.0407953 -0.091991 0.994924    0.328125 0.390625
  v -18.75 -13.125 30.7271    -0.0554672 0.0334122 0.997901    0.34375 0.390625
  v -16.875 -13.125 30.8035    0.090917 0.0362067 0.9952    0.359375 0.390625
  v -15 -13.125 30.4789    0.0407949 0.0821833 0.995782    0.375 0.390625
  v -13.125 -13.125 30.6444    -0.15121 0.141027 0.97839    0.390625 0.390625
  v -11.25 -13.125 31.1396    -0.0871902 0.160839 0.983122    0.40625 0.390625
  v -9.375 -13.125 31.1277    0.00284268 0.252399 0.967619    0.421875 0.390625
  v -7.5 -13.125 31.0094    0.0345783 0.273016 0.961388    0.4375 0.390625
  v -5.625 -13.125 30.8503    0.0719773 0.145132 0.986791    0.453125 0.390625
  v -3.75 -13.125 30.6521    -0.0590879 0.0612672 0.996371    0.46875 0.390625
  v -1.875 -13.125 31.0135    -0.170824 0.0699271 0.982817    0.484375 0.390625
  v -1.23138e-023 -13.125 31.4051    0.0286604 0.0989173 0.994683    0.5 0.390625
  v 1.875 -13.125 31.0313    0.168134 0.123712 0.97797    0.515625 0.390625
  v 3.75 -13.125 30.7386    0.0431793 0.0854517 0.995406    0.53125 0.390625
  v 5.625 -13.125 30.7402    0.0129254 -0.0184199 0.999747    0.546875 0.390625
  v 7.5 -13.125 30.5979    0.13548 -0.0606819 0.98892    0.5625 0.390625
  v 9.375 -13.125 30.2997    0.0262087 0.0639988 0.997606    0.578125 0.390625
  v 11.25 -13.125 30.5833    -0.180232 0.2166 0.959479    0.59375 0.390625
  v 13.125 -13.125 31.02    -0.15581 0.234161 0.959631    0.609375 0.390625
  v 15 -13.125 31.286    -0.000457659 0.174584 0.984642    0.625 0.390625
  v 16.875 -13.125 31.074    0.0928144 0.161259 0.982538    0.640625 0.390625
  v 18.75 -13.125 30.7832    0.0675958 0.174959 0.982253    0.65625 0.390625
  v 20.625 -13.125 30.6644    0.00738506 0.153256 0.988159    0.671875 0.390625
  v 22.5 -13.125 30.7891    -0.06618 0.107813 0.991966    0.6875 0.390625
  v 24.375 -13.125 30.9258    -0.0218309 0.00680209 0.999739    0.703125 0.390625
  v 26.25 -13.125 30.808    0.0919431 -0.0831392 0.992287    0.71875 0.390625
  v 28.125 -13.125 30.5859    -0.0158383 -0.0724357 0.997247    0.734375 0.390625
  v 30 -13.125 30.8497    -0.0202898 -0.12371 0.992111    0.75 0.390625
  v 31.875 -13.125 30.7785    0.170539 -0.198772 0.965094    0.765625 0.390625
  v 33.75 -13.125 30.2572    0.103944 -0.170834 0.979802    0.78125 0.390625
  v 35.625 -13.125 30.2755    -0.0910664 -0.150023 0.98448    0.796875 0.390625
  v 37.5 -13.125 30.5713    -0.0663003 -0.175117 0.982313    0.8125 0.390625
  v 39.375 -13.125 30.6211    -0.00338969 -0.148625 0.988888    0.828125 0.390625
  v 41.25 -13.125 30.7221    -0.0118923 -0.0835979 0.996429    0.84375 0.390625
  v 43.125 -13.125 30.6768    0.057785 -0.0055986 0.998313    0.859375 0.390625
  v 45 -13.125 30.4516    -0.0222974 0.10634 0.99408    0.875 0.390625
  v 46.875 -13.125 30.7228    -0.210039 0.127928 0.969287    0.890625 0.390625
  v 48.75 -13.125 31.2298    -0.143585 -0.000538692 0.989638    0.90625 0.390625
  v 50.625 -13.125 31.1665    0.171618 -0.190109 0.966647    0.921875 0.390625
  v 52.5 -13.125 30.5641    0.231336 -0.236769 0.943623    0.9375 0.390625
  v 54.375 -13.125 30.2198    0.0236272 -0.168952 0.985341    0.953125 0.390625
  v 56.25 -13.125 30.3887    -0.140829 -0.10976 0.983931    0.96875 0.390625
  v 58.125 -13.125 30.7963    -0.168288 -0.059235 0.983957    0.984375 0.390625
  v 60 -13.125 31.2325    -0.227511 0.00510705 0.973762    1 0.390625
  v -60 -11.25 31.3604    -0.059786 -0.138995 0.988487    0 0.40625
  v -58.125 -11.25 31.391    0.00111702 -0.259115 0.965846    0.015625 0.40625
  v -56.25 -11.25 31.4774    0.0222518 -0.272744 0.961829    0.03125 0.40625
  v -54.375 -11.25 31.2912    0.150712 -0.188943 0.970354    0.046875 0.40625
  v -52.5 -11.25 30.8315    0.280457 -0.0574289 0.958147    0.0625 0.40625
  v -50.625 -11.25 30.1386    0.190018 0.041014 0.980924    0.078125 0.40625
  v -48.75 -11.25 30.0255    -0.135598 0.112498 0.984356    0.09375 0.40625
  v -46.875 -11.25 30.6369    -0.188183 0.1776 0.965943    0.109375 0.40625
  v -45 -11.25 30.8024    0.00670445 0.217396 0.97606    0.125 0.40625
  v -43.125 -11.25 30.4368    0.0398455 0.152194 0.987547    0.140625 0.40625
  v -41.25 -11.25 30.5049    -0.0121255 0.081925 0.996565    0.15625 0.40625
  v -39.375 -11.25 30.5366    0.0760063 0.125376 0.989193    0.171875 0.40625
  v -37.5 -11.25 30.2679    0.00769341 0.212353 0.977163    0.1875 0.40625
  v -35.625 -11.25 30.4915    -0.134468 0.200969 0.970325    0.203125 0.40625
  v -33.75 -11.25 30.9106    -0.0207675 0.0900103 0.995724    0.21875 0.40625
  v -31.875 -11.25 30.7475    0.0474085 0.030499 0.99841    0.234375 0.40625
  v -30 -11.25 30.8698    -0.0998668 0.0520181 0.99364    0.25 0.40625
  v -28.125 -11.25 31.0333    -0.0230857 -0.0449038 0.998725    0.265625 0.40625
  v -26.25 -11.25 30.8048    0.0186049 -0.186584 0.982263    0.28125 0.40625
  v -24.375 -11.25 31.0195    -0.101161 -0.229082 0.968136    0.296875 0.40625
  v -22.5 -11.25 31.3205    -0.0360623 -0.252213 0.966999    0.3125 0.40625
  v -20.625 -11.25 31.1055    0.104871 -0.262346 0.959258    0.328125 0.40625
  v -18.75 -11.25 30.836    0.0660552 -0.158329 0.985174    0.34375 0.40625
  v -16.875 -11.25 30.749    0.109639 -0.0730625 0.991283    0.359375 0.40625
  v -15 -11.25 30.3378    0.127703 -0.0304549 0.991345    0.375 0.40625
  v -13.125 -11.25 30.3292    -0.0422003 0.102711 0.993816    0.390625 0.40625
  v -11.25 -11.25 30.6171    -0.0214636 0.243553 0.96965    0.40625 0.40625
  v -9.375 -11.25 30.3518    0.0568591 0.274523 0.959898    0.421875 0.40625
  v -7.5 -11.25 30.199    -0.0449255 0.217651 0.974992    0.4375 0.40625
  v -5.625 -11.25 30.4071    -0.113207 0.0898015 0.989505    0.453125 0.40625
  v -3.75 -11.25 30.6828    -0.127434 -0.0432322 0.990904    0.46875 0.40625
  v -1.875 -11.25 31.1068    -0.132874 -0.0523125 0.989751    0.484375 0.40625
  v -1.23138e-023 -11.25 31.2614    0.101201 0.0175421 0.994711    0.5 0.40625
  v 1.875 -11.25 30.6545    0.219736 0.111257 0.969195    0.515625 0.40625
  v 3.75 -11.25 30.4037    -0.0212194 0.175558 0.98424    0.53125 0.40625
  v 5.625 -11.25 30.7966    -0.132071 0.107017 0.985446    0.546875 0.40625
  v 7.5 -11.25 30.9729    0.0917587 -0.0403534 0.994963    0.5625 0.40625
  v 9.375 -11.25 30.4578    0.179959 -0.069305 0.98123    0.578125 0.40625
  v 11.25 -11.25 30.2409    -0.015951 0.0819765 0.996507    0.59375 0.40625
  v 13.125 -11.25 30.4646    -0.112543 0.233033 0.965935    0.609375 0.40625
  v 15 -11.25 30.6782    -0.0717054 0.25263 0.964902    0.625 0.40625
  v 16.875 -11.25 30.5699    0.0135681 0.11316 0.993484    0.640625 0.40625
  v 18.75 -11.25 30.4775    0.0237475 -0.0232533 0.999447    0.65625 0.40625
  v 20.625 -11.25 30.559    0.0234218 -0.0147767 0.999616    0.671875 0.40625
  v 22.5 -11.25 30.6479    -0.0931467 0.086869 0.991856    0.6875 0.40625
  v 24.375 -11.25 30.9401    -0.135965 0.0696866 0.98826    0.703125 0.40625
  v 26.25 -11.25 31.1667    0.0244635 -0.0227554 0.999442    0.71875 0.40625
  v 28.125 -11.25 30.9898    0.0026347 -0.0387959 0.999244    0.734375 0.40625
  v 30 -11.25 31.1983    -0.0748031 -0.0435879 0.996245    0.75 0.40625
  v 31.875 -11.25 31.1631    0.143389 -0.0971453 0.984887    0.765625 0.40625
  v 33.75 -11.25 30.6405    0.147659 -0.090707 0.98487    0.78125 0.40625
  v 35.625 -11.25 30.6562    -0.116869 -0.0699907 0.990678    0.796875 0.40625
  v 37.5 -11.25 31.0401    -0.0732259 -0.11292 0.990902    0.8125 0.40625
  v 39.375 -11.25 30.9497    0.0904693 -0.0890679 0.991908    0.828125 0.40625
  v 41.25 -11.25 30.716    0.0487016 0.00219557 0.998811    0.84375 0.40625
  v 43.125 -11.25 30.5988    0.107424 0.00401238 0.994205    0.859375 0.40625
  v 45 -11.25 30.2439    0.0614808 0.0197645 0.997913    0.875 0.40625
  v 46.875 -11.25 30.3534    -0.227432 0.0656661 0.971578    0.890625 0.40625
  v 48.75 -11.25 31.0512    -0.295251 0.0185932 0.955239    0.90625 0.40625
  v 50.625 -11.25 31.5477    0.0137232 -0.106041 0.994267    0.921875 0.40625
  v 52.5 -11.25 31.2149    0.189627 -0.194366 0.962426    0.9375 0.40625
  v 54.375 -11.25 30.8379    0.0609642 -0.248297 0.966764    0.953125 0.40625
  v 56.25 -11.25 30.938    -0.0663503 -0.216097 0.974115    0.96875 0.40625
  v 58.125 -11.25 31.1907    -0.0300139 -0.087165 0.995742    0.984375 0.40625
  v 60 -11.25 31.14    -0.0590834 0.0154887 0.998133    1 0.40625
  v -60 -9.375 31.3679    -0.0605778 0.201229 0.977669    0 0.421875
  v -58.125 -9.375 31.6447    -0.0751427 0.157755 0.984615    0.015625 0.421875
  v -56.25 -9.375 31.7129    -0.00657306 0.0880279 0.996096    0.03125 0.421875
  v -54.375 -9.375 31.5095    0.204524 -0.0015906 0.97886    0.046875 0.421875
  v -52.5 -9.375 30.8552    0.351207 -0.00900731 0.936255    0.0625 0.421875
  v -50.625 -9.375 29.9838    0.20498 -0.0213269 0.978534    0.078125 0.421875
  v -48.75 -9.375 29.8456    -0.095388 -0.0720497 0.992829    0.09375 0.421875
  v -46.875 -9.375 30.3366    -0.113562 -0.0341546 0.992944    0.109375 0.421875
  v -45 -9.375 30.3305    -0.0100557 0.0468281 0.998852    0.125 0.421875
  v -43.125 -9.375 30.3031    -0.0979648 -0.0247526 0.994882    0.140625 0.421875
  v -41.25 -9.375 30.7405    -0.0825837 -0.172948 0.981463    0.15625 0.421875
  v -39.375 -9.375 30.7056    0.140177 -0.204757 0.968723    0.171875 0.421875
  v -37.5 -9.375 30.1812    0.101677 -0.130886 0.98617    0.1875 0.421875
  v -35.625 -9.375 30.2883    -0.111522 -0.0364081 0.993095    0.203125 0.421875
  v -33.75 -9.375 30.6439    -0.0627174 0.0307466 0.997558    0.21875 0.421875
  v -31.875 -9.375 30.5241    0.0985499 0.0657937 0.992955    0.234375 0.421875
  v -30 -9.375 30.3893    -0.0835751 0.162894 0.983098    0.25 0.421875
  v -28.125 -9.375 30.772    -0.180843 0.133288 0.974438    0.265625 0.421875
  v -26.25 -9.375 31.093    -0.0688779 0.0156998 0.997502    0.28125 0.421875
  v -24.375 -9.375 31.3359    -0.0722163 0.0510335 0.996082    0.296875 0.421875
  v -22.5 -9.375 31.4806    -0.080566 0.106986 0.990991    0.3125 0.421875
  v -20.625 -9.375 31.5058    0.0701097 0.0228962 0.997276    0.328125 0.421875
  v -18.75 -9.375 31.2344    0.13164 -0.0302119 0.990837    0.34375 0.421875
  v -16.875 -9.375 31.0032    0.0942621 -0.0507116 0.994255    0.359375 0.421875
  v -15 -9.375 30.6651    0.147331 -0.159287 0.976177    0.375 0.421875
  v -13.125 -9.375 30.3675    0.131845 -0.143269 0.980862    0.390625 0.421875
  v -11.25 -9.375 30.1339    0.0788868 -0.00523886 0.99687    0.40625 0.421875
  v -9.375 -9.375 29.8484    -7.15432e-005 -0.00500515 0.999987    0.421875 0.421875
  v -7.5 -9.375 30.0317    -0.130097 -0.0887317 0.987523    0.4375 0.421875
  v -5.625 -9.375 30.5488    -0.178015 -0.0746653 0.981191    0.453125 0.421875
  v -3.75 -9.375 31.0284    -0.150523 -0.00384942 0.988599    0.46875 0.421875
  v -1.875 -9.375 31.2839    -0.11586 0.0212855 0.993037    0.484375 0.421875
  v -1.23138e-023 -9.375 31.285    0.124332 -0.0405337 0.991412    0.5 0.421875
  v 1.875 -9.375 30.5979    0.298234 -0.0742975 0.951597    0.515625 0.421875
  v 3.75 -9.375 30.1272    0.0584159 0.0155302 0.998172    0.53125 0.421875
  v 5.625 -9.375 30.3875    -0.180437 0.100733 0.978415    0.546875 0.421875
  v 7.5 -9.375 30.7707    -0.0515557 0.0427244 0.997756    0.5625 0.421875
  v 9.375 -9.375 30.5274    0.143484 -0.112132 0.98328    0.578125 0.421875
  v 11.25 -9.375 30.2143    0.111593 -0.15686 0.981296    0.59375 0.421875
  v 13.125 -9.375 30.1089    0.0352956 -0.0316807 0.998875    0.609375 0.421875
  v 15 -9.375 30.1186    -0.114181 0.112072 0.987118    0.625 0.421875
  v 16.875 -9.375 30.4929    -0.202349 0.0245108 0.979007    0.640625 0.421875
  v 18.75 -9.375 30.9506    -0.095582 -0.18609 0.977872    0.65625 0.421875
  v 20.625 -9.375 30.9946    0.13365 -0.227523 0.964557    0.671875 0.421875
  v 22.5 -9.375 30.4878    0.0511179 -0.060853 0.996837    0.6875 0.421875
  v 24.375 -9.375 30.6608    -0.143041 0.0589924 0.987957    0.703125 0.421875
  v 26.25 -9.375 31.0383    -0.00579062 0.0796628 0.996805    0.71875 0.421875
  v 28.125 -9.375 30.7777    0.0434678 0.119362 0.991899    0.734375 0.421875
  v 30 -9.375 30.906    -0.105945 0.167358 0.980187    0.75 0.421875
  v 31.875 -9.375 31.1454    0.0807624 0.118161 0.989705    0.765625 0.421875
  v 33.75 -9.375 30.6739    0.179055 0.083764 0.980267    0.78125 0.421875
  v 35.625 -9.375 30.4947    -0.113823 0.113526 0.986994    0.796875 0.421875
  v 37.5 -9.375 31.017    -0.130814 0.0693009 0.988982    0.8125 0.421875
  v 39.375 -9.375 30.9793    0.113692 1.17874e-005 0.993516    0.828125 0.421875
  v 41.25 -9.375 30.5488    0.0675058 -0.0136403 0.997626    0.84375 0.421875
  v 43.125 -9.375 30.5969    0.0601666 -0.0595873 0.996408    0.859375 0.421875
  v 45 -9.375 30.3654    0.076435 -0.0934892 0.992682    0.875 0.421875
  v 46.875 -9.375 30.3802    -0.207704 -0.0627625 0.976176    0.890625 0.421875
  v 48.75 -9.375 31.187    -0.306989 -0.0233397 0.951427    0.90625 0.421875
  v 50.625 -9.375 31.7769    -0.0133623 0.0500048 0.99866    0.921875 0.421875
  v 52.5 -9.375 31.3696    0.147615 0.101546 0.983818    0.9375 0.421875
  v 54.375 -9.375 31.1552    0.0227237 0.0605454 0.997907    0.953125 0.421875
  v 56.25 -9.375 31.3233    0.00479585 0.0404665 0.999169    0.96875 0.421875
  v 58.125 -9.375 31.2169    0.106097 0.115781 0.987592    0.984375 0.421875
  v 60 -9.375 30.7506    0.169007 0.151072 0.973968    1 0.421875
  v -60 -7.5 31.0022    0.112532 0.115149 0.986954    0 0.4375
  v -58.125 -7.5 30.8068    -0.0337121 0.208588 0.977422    0.015625 0.4375
  v -56.25 -7.5 30.9518    -0.106184 0.216377 0.970518    0.03125 0.4375
  v -54.375 -7.5 31.2309    0.0963843 0.129502 0.986884    0.046875 0.4375
  v -52.5 -7.5 30.7554    0.295965 0.0351884 0.95455    0.0625 0.4375
  v -50.625 -7.5 30.0262    0.0930709 -0.0944144 0.991173    0.078125 0.4375
  v -48.75 -7.5 30.2883    -0.170898 -0.248528 0.953429    0.09375 0.4375
  v -46.875 -7.5 30.8153    -0.0371347 -0.281467 0.958852    0.109375 0.4375
  v -45 -7.5 30.5479    0.0929037 -0.140818 0.985667    0.125 0.4375
  v -43.125 -7.5 30.5651    -0.154087 -0.000460825 0.988057    0.140625 0.4375
  v -41.25 -7.5 31.2559    -0.21342 -0.0391251 0.976177    0.15625 0.4375
  v -39.375 -7.5 31.3387    0.085842 -0.199632 0.976104    0.171875 0.4375
  v -37.5 -7.5 30.7554    0.163752 -0.289817 0.942969    0.1875 0.4375
  v -35.625 -7.5 30.6717    -0.0189375 -0.246279 0.969014    0.203125 0.4375
  v -33.75 -7.5 30.7879    -0.0247621 -0.194361 0.980617    0.21875 0.4375
  v -31.875 -7.5 30.6192    0.14161 -0.205223 0.968416    0.234375 0.4375
  v -30 -7.5 30.1696    0.0237934 -0.145502 0.989072    0.25 0.4375
  v -28.125 -7.5 30.5232    -0.204428 -0.0360748 0.978217    0.265625 0.4375
  v -26.25 -7.5 31.0472    -0.0647964 0.00730865 0.997872    0.28125 0.4375
  v -24.375 -7.5 30.9304    0.0568434 0.109437 0.992367    0.296875 0.4375
  v -22.5 -7.5 30.7554    -0.031667 0.234034 0.971713    0.3125 0.4375
  v -20.625 -7.5 31.0365    -0.02322 0.264459 0.964117    0.328125 0.4375
  v -18.75 -7.5 30.9501    0.0745462 0.199931 0.97697    0.34375 0.4375
  v -16.875 -7.5 30.7298    0.000609405 0.122939 0.992414    0.359375 0.4375
  v -15 -7.5 30.8843    0.00806506 -0.000203072 0.999967    0.375 0.4375
  v -13.125 -7.5 30.8621    0.129421 -0.108266 0.985661    0.390625 0.4375
  v -11.25 -7.5 30.4062    0.0914242 -0.173224 0.98063    0.40625 0.4375
  v -9.375 -7.5 30.2722    -0.0789138 -0.265427 0.960896    0.421875 0.4375
  v -7.5 -7.5 30.7554    -0.114251 -0.291329 0.949776    0.4375 0.4375
  v -5.625 -7.5 31.0072    -0.0053212 -0.140961 0.990001    0.453125 0.4375
  v -3.75 -7.5 30.8577    -0.0086622 0.0814624 0.996639    0.46875 0.4375
  v -1.875 -7.5 30.8348    -0.130402 0.170525 0.976687    0.484375 0.4375
  v -1.23138e-023 -7.5 31.2253    -0.0288991 0.0756449 0.996716    0.5 0.4375
  v 1.875 -7.5 30.9716    0.231048 -0.11261 0.966404    0.515625 0.4375
  v 3.75 -7.5 30.3599    0.141617 -0.183735 0.972721    0.53125 0.4375
  v 5.625 -7.5 30.3578    -0.114242 -0.119696 0.986216    0.546875 0.4375
  v 7.5 -7.5 30.7554    -0.151034 -0.0881337 0.984592    0.5625 0.4375
  v 9.375 -7.5 30.8858    -0.0114116 -0.196009 0.980536    0.578125 0.4375
  v 11.25 -7.5 30.8659    0.0933224 -0.294926 0.950952    0.59375 0.4375
  v 13.125 -7.5 30.6357    0.195389 -0.247243 0.949049    0.609375 0.4375
  v 15 -7.5 30.1893    0.0409208 -0.0367754 0.998485    0.625 0.4375
  v 16.875 -7.5 30.5191    -0.268349 0.125018 0.955175    0.640625 0.4375
  v 18.75 -7.5 31.3259    -0.24744 0.0855494 0.965119    0.65625 0.4375
  v 20.625 -7.5 31.5175    0.100135 -0.067597 0.992675    0.671875 0.4375
  v 22.5 -7.5 30.7554    0.161205 -0.166662 0.972747    0.6875 0.4375
  v 24.375 -7.5 30.7202    -0.0588573 -0.131723 0.989538    0.703125 0.4375
  v 26.25 -7.5 30.9602    0.0303993 -0.0590434 0.997792    0.71875 0.4375
  v 28.125 -7.5 30.5696    0.121857 0.000895191 0.992547    0.734375 0.4375
  v 30 -7.5 30.5191    -0.0632019 0.0884832 0.994071    0.75 0.4375
  v 31.875 -7.5 30.7927    0.0202565 0.0961979 0.995156    0.765625 0.4375
  v 33.75 -7.5 30.3563    0.154901 0.0110519 0.987868    0.78125 0.4375
  v 35.625 -7.5 30.1163    -0.0966493 -0.0195631 0.995126    0.796875 0.4375
  v 37.5 -7.5 30.7554    -0.182658 -0.00396872 0.983168    0.8125 0.4375
  v 39.375 -7.5 30.9152    0.0454202 -0.0232329 0.998698    0.828125 0.4375
  v 41.25 -7.5 30.6432    0.0225046 -0.0759148 0.99686    0.84375 0.4375
  v 43.125 -7.5 30.8688    0.00602949 -0.129677 0.991538    0.859375 0.4375
  v 45 -7.5 30.6712    0.105863 -0.124353 0.986575    0.875 0.4375
  v 46.875 -7.5 30.5891    -0.127928 -0.0102018 0.991731    0.890625 0.4375
  v 48.75 -7.5 31.3176    -0.211835 0.124095 0.969395    0.90625 0.4375
  v 50.625 -7.5 31.4911    0.089702 0.234371 0.968    0.921875 0.4375
  v 52.5 -7.5 30.7554    0.187734 0.304429 0.933852    0.9375 0.4375
  v 54.375 -7.5 30.6423    -0.0204135 0.325863 0.945196    0.953125 0.4375
  v 56.25 -7.5 30.8572    -0.00615168 0.277637 0.960666    0.96875 0.4375
  v 58.125 -7.5 30.5726    0.123033 0.225376 0.966472    0.984375 0.4375
  v 60 -7.5 30.2346    0.194037 0.215975 0.956925    1 0.4375
  v -60 -5.625 30.8834    0.0538572 0.0292251 0.998121    0 0.453125
  v -58.125 -5.625 30.6331    -0.0117361 -0.0236931 0.99965    0.015625 0.453125
  v -56.25 -5.625 30.8661    -0.12083 -0.0439569 0.991699    0.03125 0.453125
  v -54.375 -5.625 31.1733    0.0614457 -0.0151625 0.997995    0.046875 0.453125
  v -52.5 -5.625 30.6824    0.241504 0.0134446 0.970307    0.0625 0.453125
  v -50.625 -5.625 30.2442    -0.0295058 -0.0189754 0.999385    0.078125 0.453125
  v -48.75 -5.625 30.9415    -0.294405 -0.0910123 0.951337    0.09375 0.453125
  v -46.875 -5.625 31.557    -0.037769 -0.174724 0.983893    0.109375 0.453125
  v -45 -5.625 30.9882    0.272473 -0.189691 0.943279    0.125 0.453125
  v -43.125 -5.625 30.4024    0.0411016 0.00294004 0.999151    0.140625 0.453125
  v -41.25 -5.625 30.8266    -0.249451 0.206358 0.946145    0.15625 0.453125
  v -39.375 -5.625 31.3396    -0.130325 0.136543 0.982024    0.171875 0.453125
  v -37.5 -5.625 31.3292    0.0919224 -0.0656567 0.993599    0.1875 0.453125
  v -35.625 -5.625 31.2032    0.0317556 -0.081006 0.996208    0.203125 0.453125
  v -33.75 -5.625 31.247    -0.0552442 -0.0693674 0.99606    0.21875 0.453125
  v -31.875 -5.625 31.2755    0.0486185 -0.191863 0.980217    0.234375 0.453125
  v -30 -5.625 30.9692    0.105968 -0.277065 0.95499    0.25 0.453125
  v -28.125 -5.625 31.0068    -0.0663113 -0.160274 0.984843    0.265625 0.453125
  v -26.25 -5.625 31.2215    0.00115384 -0.0446397 0.999002    0.28125 0.453125
  v -24.375 -5.625 30.8405    0.140424 -0.0201208 0.989887    0.296875 0.453125
  v -22.5 -5.625 30.5422    0.0878094 0.0229213 0.995874    0.3125 0.453125
  v -20.625 -5.625 30.5743    -0.00239394 0.125346 0.99211    0.328125 0.453125
  v -18.75 -5.625 30.4431    -0.0146881 0.103594 0.994511    0.34375 0.453125
  v -16.875 -5.625 30.474    -0.0725002 -0.00309728 0.997364    0.359375 0.453125
  v -15 -5.625 30.8307    -0.0338229 -0.00656921 0.999406    0.375 0.453125
  v -13.125 -5.625 30.809    0.0602399 0.0398364 0.997389    0.390625 0.453125
  v -11.25 -5.625 30.5658    -0.0212174 -0.0295595 0.999338    0.40625 0.453125
  v -9.375 -5.625 30.9177    -0.170868 -0.127701 0.976983    0.421875 0.453125
  v -7.5 -5.625 31.4782    -0.0390962 -0.115215 0.992571    0.4375 0.453125
  v -5.625 -5.625 31.1744    0.170726 -0.0211678 0.985091    0.453125 0.453125
  v -3.75 -5.625 30.5177    0.108775 0.0289444 0.993645    0.46875 0.453125
  v -1.875 -5.625 30.4869    -0.0958279 0.0589344 0.993652    0.484375 0.453125
  v -1.23138e-023 -5.625 31.0179    -0.134963 0.113716 0.984304    0.5 0.453125
  v 1.875 -5.625 31.088    0.0541903 0.0256989 0.9982    0.515625 0.453125
  v 3.75 -5.625 30.7816    0.104092 -0.12387 0.986824    0.53125 0.453125
  v 5.625 -5.625 30.8052    -0.0451395 -0.119485 0.991809    0.546875 0.453125
  v 7.5 -5.625 31.0612    -0.162263 -0.050842 0.985437    0.5625 0.453125
  v 9.375 -5.625 31.3505    -0.099969 -0.0769513 0.99201    0.578125 0.453125
  v 11.25 -5.625 31.5019    0.0635033 -0.104509 0.992494    0.59375 0.453125
  v 13.125 -5.625 31.2018    0.26962 -0.11126 0.956518    0.609375 0.453125
  v 15 -5.625 30.2997    0.240327 -0.0907552 0.96644    0.625 0.453125
  v 16.875 -5.625 30.051    -0.0799834 0.0727222 0.99414    0.640625 0.453125
  v 18.75 -5.625 30.6117    -0.246262 0.27902 0.928172    0.65625 0.453125
  v 20.625 -5.625 31.0952    -0.114255 0.268267 0.956545    0.671875 0.453125
  v 22.5 -5.625 30.9839    0.0102464 0.00997268 0.999898    0.6875 0.453125
  v 24.375 -5.625 31.1447    -0.0280033 -0.123786 0.991914    0.703125 0.453125
  v 26.25 -5.625 31.2292    0.0798551 -0.0722625 0.994184    0.71875 0.453125
  v 28.125 -5.625 30.7974    0.176214 -0.0427948 0.983421    0.734375 0.453125
  v 30 -5.625 30.5516    0.00130866 -0.0080078 0.999967    0.75 0.453125
  v 31.875 -5.625 30.6979    -0.0439311 -0.0167927 0.998893    0.765625 0.453125
  v 33.75 -5.625 30.5457    0.0456347 -0.129408 0.990541    0.78125 0.453125
  v 35.625 -5.625 30.593    -0.0858077 -0.178824 0.980132    0.796875 0.453125
  v 37.5 -5.625 31.1185    -0.125566 -0.0873051 0.988236    0.8125 0.453125
  v 39.375 -5.625 31.1263    0.0458604 -0.0168808 0.998805    0.828125 0.453125
  v 41.25 -5.625 30.8747    -0.0112583 -0.0281346 0.999541    0.84375 0.453125
  v 43.125 -5.625 31.1391    -0.0594424 -0.0944442 0.993754    0.859375 0.453125
  v 45 -5.625 30.9648    0.170057 -0.161001 0.972193    0.875 0.453125
  v 46.875 -5.625 30.5421    0.0801277 -0.0186382 0.99661    0.890625 0.453125
  v 48.75 -5.625 30.7641    -0.0733465 0.206981 0.975592    0.90625 0.453125
  v 50.625 -5.625 30.6554    0.108576 0.240943 0.964447    0.921875 0.453125
  v 52.5 -5.625 30.0605    0.224791 0.160188 0.96115    0.9375 0.453125
  v 54.375 -5.625 29.8768    -0.0221096 0.204938 0.978525    0.953125 0.453125
  v 56.25 -5.625 30.1384    -0.12114 0.170345 0.97791    0.96875 0.453125
  v 58.125 -5.625 30.1914    0.0261543 0.0136423 0.999565    0.984375 0.453125
  v 60 -5.625 30.11    0.0890556 -0.00104258 0.996026    1 0.453125
  v -60 -3.75 30.6367    -0.0885748 0.14169 0.98594    0 0.46875
  v -58.125 -3.75 30.8342    -0.116129 0.0649301 0.99111    0.015625 0.46875
  v -56.25 -3.75 31.2031    -0.140368 -0.0281705 0.989699    0.03125 0.46875
  v -54.375 -3.75 31.3492    0.103326 -0.0548427 0.993134    0.046875 0.46875
  v -52.5 -3.75 30.7079    0.288687 -0.0121881 0.957346    0.0625 0.46875
  v -50.625 -3.75 30.2411    0.0119353 0.0809199 0.996649    0.078125 0.46875
  v -48.75 -3.75 30.8077    -0.293881 0.178554 0.939017    0.09375 0.46875
  v -46.875 -3.75 31.4027    -0.164694 0.158047 0.9736    0.109375 0.46875
  v -45 -3.75 31.2401    0.201199 -0.0640272 0.977456    0.125 0.46875
  v -43.125 -3.75 30.5579    0.233114 -0.156514 0.959771    0.140625 0.46875
  v -41.25 -3.75 30.3803    -0.0483154 0.0619249 0.996911    0.15625 0.46875
  v -39.375 -3.75 30.7902    -0.200171 0.272383 0.941137    0.171875 0.46875
  v -37.5 -3.75 31.2424    -0.026218 0.246625 0.968756    0.1875 0.46875
  v -35.625 -3.75 31.026    0.0697285 0.202781 0.976738    0.203125 0.46875
  v -33.75 -3.75 30.9163    -0.0858769 0.215405 0.972741    0.21875 0.46875
  v -31.875 -3.75 31.2831    -0.111327 0.147664 0.982752    0.234375 0.46875
  v -30 -3.75 31.4262    0.0827726 0.0338102 0.995995    0.25 0.46875
  v -28.125 -3.75 31.1474    0.0740139 0.0687342 0.994886    0.265625 0.46875
  v -26.25 -3.75 31.0533    0.0266002 0.136797 0.990242    0.28125 0.46875
  v -24.375 -3.75 30.8622    0.0852909 0.0740169 0.993603    0.296875 0.46875
  v -22.5 -3.75 30.7365    0.126245 -0.00180345 0.991997    0.3125 0.46875
  v -20.625 -3.75 30.4475    0.0517762 0.0337326 0.998089    0.328125 0.46875
  v -18.75 -3.75 30.3982    -0.108931 0.0179054 0.993888    0.34375 0.46875
  v -16.875 -3.75 30.8542    -0.168037 -0.10191 0.980499    0.359375 0.46875
  v -15 -3.75 31.1217    0.0279536 -0.166532 0.98564    0.375 0.46875
  v -13.125 -3.75 30.6747    0.125922 -0.090586 0.987896    0.390625 0.46875
  v -11.25 -3.75 30.5451    -0.0286118 0.00216001 0.999588    0.40625 0.46875
  v -9.375 -3.75 31.0284    -0.148718 0.11058 0.982677    0.421875 0.46875
  v -7.5 -3.75 31.3109    0.0176471 0.208267 0.977913    0.4375 0.46875
  v -5.625 -3.75 30.797    0.150693 0.194447 0.969269    0.453125 0.46875
  v -3.75 -3.75 30.4883    0.0275803 0.0521054 0.998261    0.46875 0.46875
  v -1.875 -3.75 30.7384    -0.061439 -0.0462692 0.997038    0.484375 0.46875
  v -1.23138e-023 -3.75 30.8692    -0.0561857 0.0353584 0.997794    0.5 0.46875
  v 1.875 -3.75 30.8444    -0.0424933 0.0885667 0.995163    0.515625 0.46875
  v 3.75 -3.75 30.9568    0.0171699 0.00187071 0.999851    0.53125 0.46875
  v 5.625 -3.75 30.9214    0.0244712 -0.0141316 0.999601    0.546875 0.46875
  v 7.5 -3.75 30.8804    -0.101404 0.0714675 0.992275    0.5625 0.46875
  v 9.375 -3.75 31.2456    -0.106682 0.117948 0.987273    0.578125 0.46875
  v 11.25 -3.75 31.3678    0.0712218 0.144924 0.986876    0.59375 0.46875
  v 13.125 -3.75 30.9584    0.196929 0.114039 0.973763    0.609375 0.46875
  v 15 -3.75 30.3667    0.169372 -0.0806692 0.982245    0.625 0.46875
  v 16.875 -3.75 30.2236    0.0639909 -0.194617 0.97879    0.640625 0.46875
  v 18.75 -3.75 30.2252    -0.0464319 -0.0389956 0.99816    0.65625 0.46875
  v 20.625 -3.75 30.3531    -0.179815 0.141287 0.973501    0.671875 0.46875
  v 22.5 -3.75 30.8211    -0.204792 0.0796957 0.975556    0.6875 0.46875
  v 24.375 -3.75 31.3307    -0.052938 -0.0213279 0.99837    0.703125 0.46875
  v 26.25 -3.75 31.1922    0.139994 0.0156376 0.990029    0.71875 0.46875
  v 28.125 -3.75 30.7304    0.190476 0.046813 0.980575    0.734375 0.46875
  v 30 -3.75 30.4561    0.00532881 0.0538642 0.998534    0.75 0.46875
  v 31.875 -3.75 30.6875    -0.118598 0.0301457 0.992485    0.765625 0.46875
  v 33.75 -3.75 30.9178    -0.036892 -0.02877 0.998905    0.78125 0.46875
  v 35.625 -3.75 31.0421    -0.0224608 -0.00183604 0.999746    0.796875 0.46875
  v 37.5 -3.75 31.1371    -0.00944025 0.116224 0.993178    0.8125 0.46875
  v 39.375 -3.75 30.9085    0.0629783 0.155204 0.985873    0.828125 0.46875
  v 41.25 -3.75 30.7188    -0.0544881 0.102021 0.993289    0.84375 0.46875
  v 43.125 -3.75 31.0938    -0.182398 0.025982 0.982882    0.859375 0.46875
  v 45 -3.75 31.3572    0.110799 -0.119889 0.986585    0.875 0.46875
  v 46.875 -3.75 30.7661    0.254242 -0.13757 0.957306    0.890625 0.46875
  v 48.75 -3.75 30.3325    0.0500521 -0.021889 0.998507    0.90625 0.46875
  v 50.625 -3.75 30.2641    0.00913384 -0.0434108 0.999016    0.921875 0.46875
  v 52.5 -3.75 30.2098    0.172739 -0.174954 0.969305    0.9375 0.46875
  v 54.375 -3.75 29.8283    0.0459996 -0.146476 0.988144    0.953125 0.46875
  v 56.25 -3.75 30.0334    -0.20478 -0.0889383 0.974759    0.96875 0.46875
  v 58.125 -3.75 30.5817    -0.108228 -0.182772 0.97718    0.984375 0.46875
  v 60 -3.75 30.6307    -0.00303948 -0.23593 0.971765    1 0.46875
  v -60 -1.875 30.3991    -0.0591644 -0.00597469 0.99823    0 0.484375
  v -58.125 -1.875 30.5097    -0.13831 0.05646 0.988778    0.015625 0.484375
  v -56.25 -1.875 30.9547    -0.190205 0.0867587 0.977903    0.03125 0.484375
  v -54.375 -1.875 31.2908    0.0622342 0.0569106 0.996438    0.046875 0.484375
  v -52.5 -1.875 30.7571    0.310159 0.00125244 0.950684    0.0625 0.484375
  v -50.625 -1.875 30.064    0.12618 0.0173848 0.991855    0.078125 0.484375
  v -48.75 -1.875 30.2053    -0.173957 0.142366 0.974408    0.09375 0.484375
  v -46.875 -1.875 30.7048    -0.238566 0.256205 0.93672    0.109375 0.484375
  v -45 -1.875 31.1952    -0.0834986 0.14708 0.985594    0.125 0.484375
  v -43.125 -1.875 31.0844    0.167871 -0.120434 0.978425    0.140625 0.484375
  v -41.25 -1.875 30.6202    0.214451 -0.133431 0.967578    0.15625 0.484375
  v -39.375 -1.875 30.3115    0.0133475 0.13547 0.990692    0.171875 0.484375
  v -37.5 -1.875 30.4769    -0.0734328 0.270261 0.959983    0.1875 0.484375
  v -35.625 -1.875 30.3524    0.0377079 0.192434 0.980585    0.203125 0.484375
  v -33.75 -1.875 30.3295    -0.0610798 0.196925 0.978514    0.21875 0.484375
  v -31.875 -1.875 30.7853    -0.156623 0.266092 0.951138    0.234375 0.484375
  v -30 -1.875 31.0234    0.0211682 0.247203 0.968733    0.25 0.484375
  v -28.125 -1.875 30.6496    0.130326 0.217619 0.967294    0.265625 0.484375
  v -26.25 -1.875 30.5121    0.0228996 0.252055 0.967442    0.28125 0.484375
  v -24.375 -1.875 30.5667    -0.00849274 0.221657 0.975088    0.296875 0.484375
  v -22.5 -1.875 30.6132    0.0404833 0.121432 0.991774    0.3125 0.484375
  v -20.625 -1.875 30.3063    0.0362239 -0.0069556 0.999319    0.328125 0.484375
  v -18.75 -1.875 30.3622    -0.121878 -0.0472915 0.991418    0.34375 0.484375
  v -16.875 -1.875 30.9428    -0.245431 0.00167845 0.969413    0.359375 0.484375
  v -15 -1.875 31.396    -0.0343038 -0.0389521 0.998652    0.375 0.484375
  v -13.125 -1.875 31.0664    0.184779 -0.0937859 0.978295    0.390625 0.484375
  v -11.25 -1.875 30.7909    0.111744 -0.0247778 0.993428    0.40625 0.484375
  v -9.375 -1.875 30.6757    0.0293914 0.139514 0.989784    0.421875 0.484375
  v -7.5 -1.875 30.502    0.0727257 0.253198 0.964677    0.4375 0.484375
  v -5.625 -1.875 30.1756    0.0257953 0.205542 0.978308    0.453125 0.484375
  v -3.75 -1.875 30.3748    -0.116919 0.0701248 0.990663    0.46875 0.484375
  v -1.875 -1.875 30.8108    -0.0879034 0.00604147 0.996111    0.484375 0.484375
  v -1.23138e-023 -1.875 30.7744    0.0125323 0.0130941 0.999836    0.5 0.484375
  v 1.875 -1.875 30.6809    -0.0449436 0.024583 0.998687    0.515625 0.484375
  v 3.75 -1.875 30.9174    -0.0378085 0.00871023 0.999247    0.53125 0.484375
  v 5.625 -1.875 30.8736    0.0720086 0.0265143 0.997052    0.546875 0.484375
  v 7.5 -1.875 30.7273    -0.00847116 0.118255 0.992947    0.5625 0.484375
  v 9.375 -1.875 30.9818    -0.0771446 0.188408 0.979056    0.578125 0.484375
  v 11.25 -1.875 30.9378    0.0730992 0.171168 0.982526    0.59375 0.484375
  v 13.125 -1.875 30.5256    0.0849762 0.105132 0.990821    0.609375 0.484375
  v 15 -1.875 30.5403    -0.0437164 -0.0276752 0.998661    0.625 0.484375
  v 16.875 -1.875 30.9154    -0.0077078 -0.160135 0.987065    0.640625 0.484375
  v 18.75 -1.875 30.7071    0.0834878 -0.210166 0.974095    0.65625 0.484375
  v 20.625 -1.875 30.4215    -0.064044 -0.165136 0.984189    0.671875 0.484375
  v 22.5 -1.875 30.849    -0.223307 -0.072118 0.972076    0.6875 0.484375
  v 24.375 -1.875 31.3875    -0.0542096 -0.00455909 0.998519    0.703125 0.484375
  v 26.25 -1.875 31.1046    0.190193 0.035886 0.981091    0.71875 0.484375
  v 28.125 -1.875 30.6123    0.200777 0.0567103 0.977994    0.734375 0.484375
  v 30 -1.875 30.3266    -0.011511 0.0496538 0.9987    0.75 0.484375
  v 31.875 -1.875 30.5973    -0.150434 0.0036026 0.988613    0.765625 0.484375
  v 33.75 -1.875 30.8724    -0.0104182 -0.00691075 0.999922    0.78125 0.484375
  v 35.625 -1.875 30.7297    0.108815 0.112553 0.987669    0.796875 0.484375
  v 37.5 -1.875 30.4987    0.067426 0.254763 0.96465    0.8125 0.484375
  v 39.375 -1.875 30.3496    -0.0203946 0.227542 0.973555    0.828125 0.484375
  v 41.25 -1.875 30.4627    -0.153784 0.0791421 0.98493    0.84375 0.484375
  v 43.125 -1.875 30.979    -0.243913 0.0121618 0.969721    0.859375 0.484375
  v 45 -1.875 31.5325    0.0208539 0.00640619 0.999762    0.875 0.484375
  v 46.875 -1.875 31.0559    0.250143 -0.0213234 0.967974    0.890625 0.484375
  v 48.75 -1.875 30.5342    0.0442427 -0.0816444 0.995679    0.90625 0.484375
  v 50.625 -1.875 30.746    -0.101566 -0.181938 0.978051    0.921875 0.484375
  v 52.5 -1.875 30.9992    0.0948036 -0.266041 0.959289    0.9375 0.484375
  v 54.375 -1.875 30.4476    0.117161 -0.276447 0.953861    0.953125 0.484375
  v 56.25 -1.875 30.4478    -0.163044 -0.229951 0.959447    0.96875 0.484375
  v 58.125 -1.875 31.0678    -0.141302 -0.189895 0.971583    0.984375 0.484375
  v 60 -1.875 31.0864    -0.0149974 -0.19273 0.981137    1 0.484375
  v -60 -6.81971e-007 30.5334    -0.0986402 -0.0582677 0.993416    0 0.5
  v -58.125 -6.81971e-007 30.6454    -0.0884483 -0.0776944 0.993046    0.015625 0.5
  v -56.25 -6.81971e-007 30.9194    -0.148036 -0.0128793 0.988898    0.03125 0.5
  v -54.375 -6.81971e-007 31.1799    0.0450304 0.0267164 0.998628    0.046875 0.5
  v -52.5 -6.81971e-007 30.7021    0.254896 -0.00736021 0.966941    0.0625 0.5
  v -50.625 -6.81971e-007 30.1224    0.122535 -0.093483 0.988052    0.078125 0.5
  v -48.75 -6.81971e-007 30.2014    -0.0544374 -0.0979233 0.993704    0.09375 0.5
  v -46.875 -6.81971e-007 30.3989    -0.0959796 0.0696965 0.99294    0.109375 0.5
  v -45 -6.81971e-007 30.7015    -0.198988 0.243366 0.949303    0.125 0.5
  v -43.125 -6.81971e-007 31.1202    -0.0695864 0.123761 0.989869    0.140625 0.5
  v -41.25 -6.81971e-007 30.9752    0.229879 -0.102485 0.967808    0.15625 0.5
  v -39.375 -6.81971e-007 30.17    0.212871 -0.130461 0.968331    0.171875 0.5
  v -37.5 -6.81971e-007 29.9199    -0.085849 -0.0653775 0.994161    0.1875 0.5
  v -35.625 -6.81971e-007 30.2682    -0.0512626 -0.148841 0.987531    0.203125 0.5
  v -33.75 -6.81971e-007 30.3364    0.0433573 -0.129664 0.99061    0.21875 0.5
  v -31.875 -6.81971e-007 30.3068    -0.0537913 0.0442796 0.99757    0.234375 0.5
  v -30 -6.81971e-007 30.4128    -0.0361767 0.0987096 0.994459    0.25 0.5
  v -28.125 -6.81971e-007 30.2978    0.11624 0.0186913 0.993045    0.265625 0.5
  v -26.25 -6.81971e-007 30.0815    0.0541523 0.0238356 0.998248    0.28125 0.5
  v -24.375 -6.81971e-007 30.0754    -0.0334761 0.0392437 0.998669    0.296875 0.5
  v -22.5 -6.81971e-007 30.1651    -0.0884515 0.0102728 0.996028    0.3125 0.5
  v -20.625 -6.81971e-007 30.3592    -0.0921805 -0.0991126 0.990797    0.328125 0.5
  v -18.75 -6.81971e-007 30.7447    -0.0732901 -0.120782 0.98997    0.34375 0.5
  v -16.875 -6.81971e-007 30.93    -0.152142 0.0339165 0.987777    0.359375 0.5
  v -15 -6.81971e-007 31.2602    -0.0777645 0.113029 0.990544    0.375 0.5
  v -13.125 -6.81971e-007 31.142    0.172639 0.0631275 0.98296    0.390625 0.5
  v -11.25 -6.81971e-007 30.6708    0.163317 0.04469 0.985561    0.40625 0.5
  v -9.375 -6.81971e-007 30.3146    0.102528 0.00236319 0.994727    0.421875 0.5
  v -7.5 -6.81971e-007 30.0887    0.0913076 -0.0209432 0.995602    0.4375 0.5
  v -5.625 -6.81971e-007 29.9746    -0.0451381 -0.0230975 0.998714    0.453125 0.5
  v -3.75 -6.81971e-007 30.4073    -0.172157 -0.0248734 0.984756    0.46875 0.5
  v -1.875 -6.81971e-007 30.7784    -0.0881559 0.00617517 0.996087    0.484375 0.5
  v -1.23138e-023 -6.81971e-007 30.737    0.00996456 0.016847 0.999808    0.5 0.5
  v 1.875 -6.81971e-007 30.7252    -0.0614794 -0.0109394 0.998048    0.515625 0.5
  v 3.75 -6.81971e-007 30.9736    -0.0627242 -0.0488845 0.996833    0.53125 0.5
  v 5.625 -6.81971e-007 30.9045    0.132259 -0.0653444 0.989059    0.546875 0.5
  v 7.5 -6.81971e-007 30.5015    0.130003 0.0341894 0.990924    0.5625 0.5
  v 9.375 -6.81971e-007 30.4336    -0.0496436 0.155737 0.98655    0.578125 0.5
  v 11.25 -6.81971e-007 30.5384    -0.0294488 0.105463 0.993987    0.59375 0.5
  v 13.125 -6.81971e-007 30.4846    -0.00398846 -0.0196116 0.9998    0.609375 0.5
  v 15 -6.81971e-007 30.7026    -0.0806887 -0.0354911 0.996107    0.625 0.5
  v 16.875 -6.81971e-007 30.9872    -0.0543646 0.0301196 0.998067    0.640625 0.5
  v 18.75 -6.81971e-007 30.8726    0.0222082 0.00491068 0.999741    0.65625 0.5
  v 20.625 -6.81971e-007 30.8864    -0.042991 -0.0625036 0.997118    0.671875 0.5
  v 22.5 -6.81971e-007 31.2021    -0.13265 -0.0233037 0.990889    0.6875 0.5
  v 24.375 -6.81971e-007 31.3905    -0.00555842 0.0403234 0.999171    0.703125 0.5
  v 26.25 -6.81971e-007 31.0099    0.213009 0.0263116 0.976696    0.71875 0.5
  v 28.125 -6.81971e-007 30.5069    0.218229 0.0313846 0.975393    0.734375 0.5
  v 30 -6.81971e-007 30.2093    -0.041632 0.0539067 0.997678    0.75 0.5
  v 31.875 -6.81971e-007 30.649    -0.224257 -0.00871351 0.974491    0.765625 0.5
  v 33.75 -6.81971e-007 31.0391    -0.0252018 -0.122952 0.992093    0.78125 0.5
  v 35.625 -6.81971e-007 30.6589    0.240878 -0.141768 0.960146    0.796875 0.5
  v 37.5 -6.81971e-007 30.0239    0.190999 -0.0135617 0.981497    0.8125 0.5
  v 39.375 -6.81971e-007 29.9083    -0.0861388 0.0982755 0.991424    0.828125 0.5
  v 41.25 -6.81971e-007 30.4504    -0.28483 0.0602245 0.956684    0.84375 0.5
  v 43.125 -6.81971e-007 31.1702    -0.249242 -0.0151934 0.968322    0.859375 0.5
  v 45 -6.81971e-007 31.4909    0.0630215 0.00280575 0.998008    0.875 0.5
  v 46.875 -6.81971e-007 30.8249    0.233674 0.0430284 0.971362    0.890625 0.5
  v 48.75 -6.81971e-007 30.5005    -0.0187876 0.0356186 0.999189    0.90625 0.5
  v 50.625 -6.81971e-007 31.0395    -0.167621 0.0235086 0.985571    0.921875 0.5
  v 52.5 -6.81971e-007 31.3448    0.0468663 0.0267765 0.998542    0.9375 0.5
  v 54.375 -6.81971e-007 30.845    0.107412 -0.00940041 0.99417    0.953125 0.5
  v 56.25 -6.81971e-007 30.9073    -0.131476 -0.0389724 0.990553    0.96875 0.5
  v 58.125 -6.81971e-007 31.3954    -0.120846 -0.0270742 0.992302    0.984375 0.5
  v 60 -6.81971e-007 31.255    0.0463163 -0.0688904 0.996549    1 0.5
  v -60 1.875 30.5187    -0.123835 0.114078 0.985724    0 0.515625
  v -58.125 1.875 30.8546    -0.0984258 0.0886732 0.991186    0.015625 0.515625
  v -56.25 1.875 30.9752    -0.11816 0.072064 0.990376    0.03125 0.515625
  v -54.375 1.875 31.1488    0.0383403 0.0272373 0.998893    0.046875 0.515625
  v -52.5 1.875 30.7203    0.20164 -0.0139184 0.979361    0.0625 0.515625
  v -50.625 1.875 30.3969    0.0331239 -0.0669238 0.997208    0.078125 0.515625
  v -48.75 1.875 30.6519    -0.0385287 -0.140135 0.989383    0.09375 0.515625
  v -46.875 1.875 30.5694    0.11183 -0.114103 0.987155    0.109375 0.515625
  v -45 1.875 30.1656    -0.0397597 0.0790967 0.996074    0.125 0.515625
  v -43.125 1.875 30.5953    -0.215488 0.185049 0.958813    0.140625 0.515625
  v -41.25 1.875 30.9951    -0.0103651 0.0336491 0.99938    0.15625 0.515625
  v -39.375 1.875 30.6189    0.1311 -0.216893 0.967352    0.171875 0.515625
  v -37.5 1.875 30.5085    -0.102651 -0.307334 0.946049    0.1875 0.515625
  v -35.625 1.875 31.1707    -0.097953 -0.315353 0.943905    0.203125 0.515625
  v -33.75 1.875 31.065    0.150586 -0.29738 0.942809    0.21875 0.515625
  v -31.875 1.875 30.4756    0.0893892 -0.217155 0.972036    0.234375 0.515625
  v -30 1.875 30.4931    -0.0532923 -0.160326 0.985624    0.25 0.515625
  v -28.125 1.875 30.6803    0.0540922 -0.18482 0.981283    0.265625 0.515625
  v -26.25 1.875 30.4004    0.0731072 -0.193265 0.978419    0.28125 0.515625
  v -24.375 1.875 30.3711    -0.0394971 -0.192186 0.980563    0.296875 0.515625
  v -22.5 1.875 30.5264    -0.114138 -0.188869 0.975347    0.3125 0.515625
  v -20.625 1.875 30.9145    -0.0949393 -0.143269 0.985119    0.328125 0.515625
  v -18.75 1.875 31.1177    0.0430377 -0.0284714 0.998668    0.34375 0.515625
  v -16.875 1.875 30.7489    -0.00239841 0.102319 0.994749    0.359375 0.515625
  v -15 1.875 30.8806    -0.0802199 0.130856 0.98815    0.375 0.515625
  v -13.125 1.875 30.8984    0.120813 0.0653071 0.990525    0.390625 0.515625
  v -11.25 1.875 30.4182    0.0883695 0.00919623 0.996045    0.40625 0.515625
  v -9.375 1.875 30.4753    -0.0244334 -0.119547 0.992528    0.421875 0.515625
  v -7.5 1.875 30.5895    0.0503291 -0.237352 0.970119    0.4375 0.515625
  v -5.625 1.875 30.4107    0.0133319 -0.221199 0.975138    0.453125 0.515625
  v -3.75 1.875 30.615    -0.0986072 -0.106946 0.989363    0.46875 0.515625
  v -1.875 1.875 30.7808    -0.0308362 -0.00601373 0.999506    0.484375 0.515625
  v -1.23138e-023 1.875 30.6953    0.0126628 0.0385184 0.999178    0.5 0.515625
  v 1.875 1.875 30.7261    -0.0876887 0.0392327 0.995375    0.515625 0.515625
  v 3.75 1.875 31.0444    -0.124748 0.00730084 0.992162    0.53125 0.515625
  v 5.625 1.875 31.1585    0.0994901 -0.0883322 0.99111    0.546875 0.515625
  v 7.5 1.875 30.6238    0.229837 -0.126171 0.965016    0.5625 0.515625
  v 9.375 1.875 30.2288    0.0272937 -0.038495 0.998886    0.578125 0.515625
  v 11.25 1.875 30.4746    -0.126302 -0.0012486 0.991991    0.59375 0.515625
  v 13.125 1.875 30.7487    -0.0843302 -0.0827044 0.993    0.609375 0.515625
  v 15 1.875 30.8707    -0.0082482 -0.107004 0.994224    0.625 0.515625
  v 16.875 1.875 30.7656    0.031452 -0.00821134 0.999472    0.640625 0.515625
  v 18.75 1.875 30.671    0.0157889 0.078849 0.996762    0.65625 0.515625
  v 20.625 1.875 30.8308    -0.036506 0.133822 0.990333    0.671875 0.515625
  v 22.5 1.875 30.9428    -0.0844179 0.181355 0.979788    0.6875 0.515625
  v 24.375 1.875 31.0199    -0.0435904 0.150271 0.987683    0.703125 0.515625
  v 26.25 1.875 30.9393    0.147666 0.0304225 0.988569    0.71875 0.515625
  v 28.125 1.875 30.5321    0.232939 -0.0177919 0.972328    0.734375 0.515625
  v 30 1.875 30.1035    -0.0166509 0.0233055 0.99959    0.75 0.515625
  v 31.875 1.875 30.5931    -0.288141 0.0472643 0.956421    0.765625 0.515625
  v 33.75 1.875 31.2623    -0.165696 -0.0250946 0.985858    0.78125 0.515625
  v 35.625 1.875 31.2361    0.178156 -0.18301 0.966834    0.796875 0.515625
  v 37.5 1.875 30.5521    0.291051 -0.249482 0.923606    0.8125 0.515625
  v 39.375 1.875 30.0641    0.0520882 -0.143453 0.988285    0.828125 0.515625
  v 41.25 1.875 30.359    -0.269718 0.0197492 0.962737    0.84375 0.515625
  v 43.125 1.875 31.1039    -0.288241 0.0482351 0.956342    0.859375 0.515625
  v 45 1.875 31.4275    0.0432034 -0.0244901 0.998766    0.875 0.515625
  v 46.875 1.875 30.8079    0.230315 -0.0955771 0.968411    0.890625 0.515625
  v 48.75 1.875 30.5397    0.0168223 -0.0897032 0.995826    0.90625 0.515625
  v 50.625 1.875 30.8554    -0.0906682 0.0118163 0.995811    0.921875 0.515625
  v 52.5 1.875 30.8823    0.0908798 0.130798 0.987235    0.9375 0.515625
  v 54.375 1.875 30.4665    0.0933209 0.193197 0.976712    0.953125 0.515625
  v 56.25 1.875 30.6447    -0.133465 0.220129 0.966297    0.96875 0.515625
  v 58.125 1.875 31.054    -0.168062 0.203444 0.964554    0.984375 0.515625
  v 60 1.875 31.1503    -0.00897726 0.118314 0.992936    1 0.515625
  v -60 3.75 30.3446    0.0735738 -0.0937002 0.992878    0 0.53125
  v -58.125 3.75 30.3846    -0.0335525 0.100877 0.994333    0.015625 0.53125
  v -56.25 3.75 30.4793    -0.155595 0.18046 0.971197    0.03125 0.53125
  v -54.375 3.75 30.9714    -0.058887 0.112913 0.991858    0.046875 0.53125
  v -52.5 3.75 30.7762    0.172175 0.0348217 0.984451    0.0625 0.53125
  v -50.625 3.75 30.4392    -0.00969648 0.0291336 0.999528    0.078125 0.53125
  v -48.75 3.75 30.7617    -0.122109 -0.0466181 0.991421    0.09375 0.53125
  v -46.875 3.75 30.776    0.110722 -0.169228 0.979338    0.109375 0.53125
  v -45 3.75 30.2632    0.144802 -0.150469 0.977953    0.125 0.53125
  v -43.125 3.75 30.3782    -0.140015 0.0525758 0.988753    0.140625 0.53125
  v -41.25 3.75 30.8288    -0.203682 0.10482 0.97341    0.15625 0.53125
  v -39.375 3.75 31.0513    -0.0811998 -0.0876143 0.99284    0.171875 0.53125
  v -37.5 3.75 31.2708    -0.0798294 -0.169652 0.982265    0.1875 0.53125
  v -35.625 3.75 31.6843    -0.0685422 -0.0479763 0.996494    0.203125 0.53125
  v -33.75 3.75 31.4376    0.120762 -0.0781952 0.989597    0.21875 0.53125
  v -31.875 3.75 30.9503    0.0872108 -0.224332 0.970603    0.234375 0.53125
  v -30 3.75 31.0318    -0.00776713 -0.259121 0.965814    0.25 0.53125
  v -28.125 3.75 31.1239    0.0724565 -0.168185 0.983089    0.265625 0.53125
  v -26.25 3.75 30.7946    0.101327 -0.0957577 0.990234    0.28125 0.53125
  v -24.375 3.75 30.7855    -0.051961 -0.0622871 0.996705    0.296875 0.53125
  v -22.5 3.75 30.9955    -0.0945882 -0.0795108 0.992336    0.3125 0.53125
  v -20.625 3.75 31.1385    0.0166784 -0.0543439 0.998383    0.328125 0.53125
  v -18.75 3.75 30.8529    0.178017 0.0551245 0.982482    0.34375 0.53125
  v -16.875 3.75 30.3026    0.0632318 0.152817 0.98623    0.359375 0.53125
  v -15 3.75 30.604    -0.14447 0.163239 0.975952    0.375 0.53125
  v -13.125 3.75 30.8943    0.0188125 0.0726695 0.997179    0.390625 0.53125
  v -11.25 3.75 30.5511    0.0127944 -0.0256392 0.999589    0.40625 0.53125
  v -9.375 3.75 30.8495    -0.147624 -0.114287 0.982418    0.421875 0.53125
  v -7.5 3.75 31.1427    -0.0273203 -0.218983 0.975346    0.4375 0.53125
  v -5.625 3.75 30.9062    0.0920357 -0.263201 0.960341    0.453125 0.53125
  v -3.75 3.75 30.8089    0.0440571 -0.152939 0.987253    0.46875 0.53125
  v -1.875 3.75 30.7641    0.053722 -0.00920788 0.998513    0.484375 0.53125
  v -1.23138e-023 3.75 30.5852    0.0312908 0.0464944 0.998428    0.5 0.53125
  v 1.875 3.75 30.5935    -0.0619177 0.0709182 0.995559    0.515625 0.53125
  v 3.75 3.75 30.905    -0.140626 0.140864 0.979991    0.53125 0.53125
  v 5.625 3.75 31.2094    -0.0401854 0.105424 0.993615    0.546875 0.53125
  v 7.5 3.75 30.958    0.172224 -0.0727693 0.982366    0.5625 0.53125
  v 9.375 3.75 30.5374    0.113763 -0.129395 0.985046    0.578125 0.53125
  v 11.25 3.75 30.5852    -0.112505 -0.0605213 0.991806    0.59375 0.53125
  v 13.125 3.75 30.8744    -0.141811 -0.0676503 0.987579    0.609375 0.53125
  v 15 3.75 31.0917    0.0177235 -0.079941 0.996642    0.625 0.53125
  v 16.875 3.75 30.9344    0.10923 -0.0176222 0.99386    0.640625 0.53125
  v 18.75 3.75 30.6983    0.0912419 0.022152 0.995582    0.65625 0.53125
  v 20.625 3.75 30.5075    0.0566597 0.0764901 0.995459    0.671875 0.53125
  v 22.5 3.75 30.3656    -0.0604219 0.145348 0.987534    0.6875 0.53125
  v 24.375 3.75 30.6461    -0.149044 0.118074 0.981756    0.703125 0.53125
  v 26.25 3.75 30.968    0.0439871 0.018714 0.998857    0.71875 0.53125
  v 28.125 3.75 30.639    0.211717 -0.0340137 0.976739    0.734375 0.53125
  v 30 3.75 30.1168    0.0254649 -0.0632389 0.997674    0.75 0.53125
  v 31.875 3.75 30.4898    -0.231052 -0.00373716 0.972934    0.765625 0.53125
  v 33.75 3.75 31.1299    -0.209365 0.115393 0.971005    0.78125 0.53125
  v 35.625 3.75 31.3843    -0.00123207 0.0665615 0.997782    0.796875 0.53125
  v 37.5 3.75 31.0503    0.211299 -0.154842 0.965079    0.8125 0.53125
  v 39.375 3.75 30.4767    0.179218 -0.255497 0.950054    0.828125 0.53125
  v 41.25 3.75 30.349    -0.115857 -0.128108 0.98497    0.84375 0.53125
  v 43.125 3.75 30.9068    -0.275875 0.0332775 0.960617    0.859375 0.53125
  v 45 3.75 31.4703    -0.0619662 0.0562771 0.99649    0.875 0.53125
  v 46.875 3.75 31.2066    0.146568 -0.0571436 0.987549    0.890625 0.53125
  v 48.75 3.75 30.9524    0.0473447 -0.141149 0.988856    0.90625 0.53125
  v 50.625 3.75 30.9895    0.0166606 -0.113136 0.99344    0.921875 0.53125
  v 52.5 3.75 30.8064    0.185346 -0.0394467 0.981881    0.9375 0.53125
  v 54.375 3.75 30.2256    0.18037 0.0364398 0.982924    0.953125 0.53125
  v 56.25 3.75 30.1139    -0.0694352 0.141911 0.987441    0.96875 0.53125
  v 58.125 3.75 30.4419    -0.195902 0.215618 0.956625    0.984375 0.53125
  v 60 3.75 30.9246    -0.178843 0.209554 0.961303    1 0.53125
  v -60 5.625 31.0025    0.276335 -0.311811 0.909072    0 0.546875
  v -58.125 5.625 30.4723    0.159857 -0.195578 0.967572    0.015625 0.546875
  v -56.25 5.625 30.2578    -0.0871617 -0.0383595 0.995455    0.03125 0.546875
  v -54.375 5.625 30.7802    -0.109011 0.0294186 0.993605    0.046875 0.546875
  v -52.5 5.625 30.7136    0.174748 0.0402122 0.983792    0.0625 0.546875
  v -50.625 5.625 30.2333    0.0102157 0.119595 0.99277    0.078125 0.546875
  v -48.75 5.625 30.7011    -0.244269 0.119379 0.962331    0.09375 0.546875
  v -46.875 5.625 31.1633    -0.080177 -0.0643843 0.994699    0.109375 0.546875
  v -45 5.625 30.9376    0.201994 -0.261711 0.943772    0.125 0.546875
  v -43.125 5.625 30.4183    0.0983769 -0.163181 0.981679    0.140625 0.546875
  v -41.25 5.625 30.469    -0.163719 0.0705751 0.983979    0.15625 0.546875
  v -39.375 5.625 31.0942    -0.198045 0.151463 0.96842    0.171875 0.546875
  v -37.5 5.625 31.493    -0.00981376 0.161937 0.986752    0.1875 0.546875
  v -35.625 5.625 31.2659    0.0256568 0.277967 0.960248    0.203125 0.546875
  v -33.75 5.625 31.0959    -0.0339469 0.24491 0.968951    0.21875 0.546875
  v -31.875 5.625 31.2819    -0.101556 0.0345578 0.994229    0.234375 0.546875
  v -30 5.625 31.6495    0.0231232 -0.0805035 0.996486    0.25 0.546875
  v -28.125 5.625 31.3669    0.187671 0.00470056 0.982221    0.265625 0.546875
  v -26.25 5.625 30.816    0.161102 0.0700533 0.984448    0.28125 0.546875
  v -24.375 5.625 30.6158    -0.0354686 0.0785356 0.99628    0.296875 0.546875
  v -22.5 5.625 30.8297    -0.128685 0.0466193 0.990589    0.3125 0.546875
  v -20.625 5.625 31.0402    0.00203275 -0.0220969 0.999754    0.328125 0.546875
  v -18.75 5.625 30.7563    0.221982 -0.0742807 0.972217    0.34375 0.546875
  v -16.875 5.625 30.1651    0.135803 -0.0572043 0.989083    0.359375 0.546875
  v -15 5.625 30.2882    -0.134037 0.0227013 0.990716    0.375 0.546875
  v -13.125 5.625 30.641    -0.0513754 0.0452317 0.997655    0.390625 0.546875
  v -11.25 5.625 30.5198    -0.0158973 0.0493199 0.998657    0.40625 0.546875
  v -9.375 5.625 30.9397    -0.195254 0.109212 0.974653    0.421875 0.546875
  v -7.5 5.625 31.3915    -0.153199 0.0799331 0.984957    0.4375 0.546875
  v -5.625 5.625 31.466    0.0522483 -0.0597176 0.996847    0.453125 0.546875
  v -3.75 5.625 31.2311    0.174687 -0.0856843 0.980889    0.46875 0.546875
  v -1.875 5.625 30.7944    0.154366 0.00662947 0.987991    0.484375 0.546875
  v -1.23138e-023 5.625 30.4679    0.0315038 0.0211812 0.999279    0.5 0.546875
  v 1.875 5.625 30.5411    -0.00654251 -0.00529419 0.999965    0.515625 0.546875
  v 3.75 5.625 30.5784    -0.023785 0.0984442 0.994858    0.53125 0.546875
  v 5.625 5.625 30.6447    -0.120268 0.196829 0.973033    0.546875 0.546875
  v 7.5 5.625 30.8983    -0.01138 0.0781387 0.996877    0.5625 0.546875
  v 9.375 5.625 30.7893    0.110266 -0.0485861 0.992714    0.578125 0.546875
  v 11.25 5.625 30.6144    -0.0734292 -0.0266179 0.996945    0.59375 0.546875
  v 13.125 5.625 30.9735    -0.187675 -0.0439652 0.981247    0.609375 0.546875
  v 15 5.625 31.3021    0.0475812 -0.0914628 0.994671    0.625 0.546875
  v 16.875 5.625 30.8511    0.183229 -0.0335895 0.982496    0.640625 0.546875
  v 18.75 5.625 30.5046    0.0827303 -0.00929161 0.996529    0.65625 0.546875
  v 20.625 5.625 30.4209    0.0568211 -0.0701843 0.995914    0.671875 0.546875
  v 22.5 5.625 30.2891    -0.0295702 -0.0853904 0.995909    0.6875 0.546875
  v 24.375 5.625 30.5962    -0.167638 -0.0377184 0.985127    0.703125 0.546875
  v 26.25 5.625 31.0233    0.0125512 -0.00103981 0.999921    0.71875 0.546875
  v 28.125 5.625 30.6276    0.178997 0.019136 0.983663    0.734375 0.546875
  v 30 5.625 30.293    -0.00722015 -0.0206742 0.99976    0.75 0.546875
  v 31.875 5.625 30.7188    -0.125244 -0.0180113 0.991962    0.765625 0.546875
  v 33.75 5.625 30.8923    -0.0625981 0.135771 0.988761    0.78125 0.546875
  v 35.625 5.625 30.8917    -0.0969715 0.237871 0.966444    0.796875 0.546875
  v 37.5 5.625 31.1005    -0.0366465 0.0912231 0.995156    0.8125 0.546875
  v 39.375 5.625 31.089    0.117316 -0.114866 0.986429    0.828125 0.546875
  v 41.25 5.625 30.8339    0.0277268 -0.124401 0.991845    0.84375 0.546875
  v 43.125 5.625 31.0091    -0.133266 0.00372672 0.991073    0.859375 0.546875
  v 45 5.625 31.269    -0.0491787 0.11367 0.992301    0.875 0.546875
  v 46.875 5.625 31.0791    0.0563583 0.107114 0.992648    0.890625 0.546875
  v 48.75 5.625 31.043    -0.0128628 0.0426749 0.999006    0.90625 0.546875
  v 50.625 5.625 31.1992    0.0295501 0.00671502 0.999541    0.921875 0.546875
  v 52.5 5.625 30.9898    0.198288 -0.012676 0.980062    0.9375 0.546875
  v 54.375 5.625 30.3309    0.198058 -0.0823152 0.976728    0.953125 0.546875
  v 56.25 5.625 30.0469    0.00557924 -0.124496 0.992204    0.96875 0.546875
  v 58.125 5.625 30.2406    -0.0911195 -0.0449637 0.994824    0.984375 0.546875
  v 60 5.625 30.5226    -0.180958 0.108305 0.977509    1 0.546875
  v -60 7.5 31.7001    0.245029 -0.157393 0.956655    0 0.5625
  v -58.125 7.5 31.0483    0.243706 -0.265612 0.932769    0.015625 0.5625
  v -56.25 7.5 30.5963    0.0414828 -0.240266 0.96982    0.03125 0.5625
  v -54.375 7.5 30.8918    -0.0363614 -0.111447 0.993105    0.046875 0.5625
  v -52.5 7.5 30.7554    0.221057 -0.0256671 0.974923    0.0625 0.5625
  v -50.625 7.5 30.0091    0.132597 0.0673514 0.988879    0.078125 0.5625
  v -48.75 7.5 30.264    -0.228708 0.206045 0.95144    0.09375 0.5625
  v -46.875 7.5 30.9506    -0.280986 0.206885 0.937148    0.109375 0.5625
  v -45 7.5 31.373    0.0142143 -0.00680951 0.999876    0.125 0.5625
  v -43.125 7.5 30.9487    0.214274 -0.158313 0.963859    0.140625 0.5625
  v -41.25 7.5 30.5821    0.0428452 -0.0765294 0.996146    0.15625 0.5625
  v -39.375 7.5 30.6989    -0.0857616 0.0794345 0.993144    0.171875 0.5625
  v -37.5 7.5 30.7554    0.0716599 0.172299 0.982435    0.1875 0.5625
  v -35.625 7.5 30.2666    0.0949598 0.226639 0.969339    0.203125 0.5625
  v -33.75 7.5 30.3471    -0.12987 0.265848 0.955227    0.21875 0.5625
  v -31.875 7.5 30.9961    -0.234574 0.249505 0.939533    0.234375 0.5625
  v -30 7.5 31.519    -0.0226165 0.192287 0.981078    0.25 0.5625
  v -28.125 7.5 30.9949    0.221699 0.100027 0.969971    0.265625 0.5625
  v -26.25 7.5 30.3946    0.123156 0.000619721 0.992387    0.28125 0.5625
  v -24.375 7.5 30.3669    -0.0681964 -0.0821131 0.994287    0.296875 0.5625
  v -22.5 7.5 30.7554    -0.153306 -0.0683458 0.985812    0.3125 0.5625
  v -20.625 7.5 31.1603    -0.0553336 -0.0127291 0.998387    0.328125 0.5625
  v -18.75 7.5 31.1337    0.159456 -0.0320257 0.986685    0.34375 0.5625
  v -16.875 7.5 30.583    0.13204 -0.126621 0.983124    0.359375 0.5625
  v -15 7.5 30.4825    -0.0821661 -0.18693 0.978931    0.375 0.5625
  v -13.125 7.5 30.7563    -0.0113432 -0.164575 0.986299    0.390625 0.5625
  v -11.25 7.5 30.5945    0.116227 -0.0341113 0.992637    0.40625 0.5625
  v -9.375 7.5 30.538    -0.05467 0.206459 0.976927    0.421875 0.5625
  v -7.5 7.5 30.7554    -0.203049 0.301696 0.931531    0.4375 0.5625
  v -5.625 7.5 31.1816    -0.100868 0.186532 0.977257    0.453125 0.5625
  v -3.75 7.5 31.1391    0.165031 0.0466891 0.985183    0.46875 0.5625
  v -1.875 7.5 30.5691    0.181792 0.0245421 0.983031    0.484375 0.5625
  v -1.23138e-023 7.5 30.371    -0.0373586 -0.0131384 0.999215    0.5 0.5625
  v 1.875 7.5 30.7    -0.0418551 -0.118145 0.992114    0.515625 0.5625
  v 3.75 7.5 30.5435    0.0797584 -0.14899 0.985617    0.53125 0.5625
  v 5.625 7.5 30.2994    -0.0617001 -0.073679 0.995371    0.546875 0.5625
  v 7.5 7.5 30.7554    -0.127507 -0.0414305 0.990972    0.5625 0.5625
  v 9.375 7.5 30.8578    0.0596285 -0.0963073 0.993564    0.578125 0.5625
  v 11.25 7.5 30.5901    -0.0217522 -0.077514 0.996754    0.59375 0.5625
  v 13.125 7.5 31.012    -0.213753 -0.00906164 0.976846    0.609375 0.5625
  v 15 7.5 31.5013    -0.0157176 -0.0459203 0.998821    0.625 0.5625
  v 16.875 7.5 30.968    0.190051 -0.152241 0.969899    0.640625 0.5625
  v 18.75 7.5 30.6168    0.0533803 -0.201975 0.977935    0.65625 0.5625
  v 20.625 7.5 30.7747    0.00585143 -0.217021 0.976149    0.671875 0.5625
  v 22.5 7.5 30.7554    -0.000866344 -0.198494 0.980102    0.6875 0.5625
  v 24.375 7.5 30.8853    -0.0907163 -0.138384 0.986215    0.703125 0.5625
  v 26.25 7.5 31.0532    0.0508876 -0.0931524 0.994351    0.71875 0.5625
  v 28.125 7.5 30.5187    0.192191 -0.0875481 0.977445    0.734375 0.5625
  v 30 7.5 30.2599    -0.010304 -0.0691641 0.997552    0.75 0.5625
  v 31.875 7.5 30.6805    -0.0727554 -0.0241141 0.997058    0.765625 0.5625
  v 33.75 7.5 30.54    0.0713509 0.0258825 0.997115    0.78125 0.5625
  v 35.625 7.5 30.283    -0.0574779 0.103292 0.992989    0.796875 0.5625
  v 37.5 7.5 30.7554    -0.170024 0.143397 0.974951    0.8125 0.5625
  v 39.375 7.5 31.1215    0.0122682 0.110804 0.993767    0.828125 0.5625
  v 41.25 7.5 30.8573    0.0800429 0.0918704 0.992549    0.84375 0.5625
  v 43.125 7.5 30.8245    -0.0648873 0.102232 0.992642    0.859375 0.5625
  v 45 7.5 30.9183    -0.0325153 0.0607672 0.997622    0.875 0.5625
  v 46.875 7.5 30.7889    0.0444165 0.0355553 0.99838    0.890625 0.5625
  v 48.75 7.5 30.8645    -0.0211495 0.0907715 0.995647    0.90625 0.5625
  v 50.625 7.5 31.0226    0.0200477 0.133042 0.990908    0.921875 0.5625
  v 52.5 7.5 30.7554    0.132203 0.092147 0.98693    0.9375 0.5625
  v 54.375 7.5 30.3723    0.066915 -0.0356644 0.997121    0.953125 0.5625
  v 56.25 7.5 30.5227    -0.0568094 -0.160927 0.98533    0.96875 0.5625
  v 58.125 7.5 30.7554    0.0114033 -0.191787 0.98137    0.984375 0.5625
  v 60 7.5 30.4947    0.0409388 -0.124987 0.991313    1 0.5625
  v -60 9.375 31.5939    0.0439042 0.154085 0.987082    0 0.578125
  v -58.125 9.375 31.4275    0.102949 -0.0264456 0.994335    0.015625 0.578125
  v -56.25 9.375 31.2061    0.0760028 -0.184289 0.979929    0.03125 0.578125
  v -54.375 9.375 31.2219    0.0992005 -0.132116 0.986258    0.046875 0.578125
  v -52.5 9.375 30.8026    0.253136 -0.0498194 0.966147    0.0625 0.578125
  v -50.625 9.375 30.0118    0.210954 -0.0919898 0.973158    0.078125 0.578125
  v -48.75 9.375 29.9092    -0.0751284 -0.0167189 0.997034    0.09375 0.578125
  v -46.875 9.375 30.2978    -0.277459 0.146021 0.949576    0.109375 0.578125
  v -45 9.375 31.0187    -0.173364 0.177614 0.96871    0.125 0.578125
  v -43.125 9.375 31.0852    0.130063 0.0674921 0.989206    0.140625 0.578125
  v -41.25 9.375 30.6816    0.0975925 0.00838942 0.995191    0.15625 0.578125
  v -39.375 9.375 30.6269    -0.0312896 -0.0202834 0.999305    0.171875 0.578125
  v -37.5 9.375 30.656    0.053478 -0.0726129 0.995925    0.1875 0.578125
  v -35.625 9.375 30.3033    0.130314 -0.140641 0.981447    0.203125 0.578125
  v -33.75 9.375 30.2327    -0.0129719 -0.0581033 0.998226    0.21875 0.578125
  v -31.875 9.375 30.4991    -0.134982 0.168347 0.976442    0.234375 0.578125
  v -30 9.375 30.8102    -0.118935 0.274826 0.95411    0.25 0.578125
  v -28.125 9.375 30.7221    0.0195847 0.0740864 0.99706    0.265625 0.578125
  v -26.25 9.375 30.6616    -0.0326199 -0.167996 0.985248    0.28125 0.578125
  v -24.375 9.375 31.0437    -0.0771526 -0.217383 0.973032    0.296875 0.578125
  v -22.5 9.375 31.3083    -0.0316559 -0.0868733 0.995716    0.3125 0.578125
  v -20.625 9.375 31.2563    0.0538653 0.0615823 0.996647    0.328125 0.578125
  v -18.75 9.375 30.9192    0.134282 0.105261 0.985337    0.34375 0.578125
  v -16.875 9.375 30.5153    0.0113656 0.0260247 0.999597    0.359375 0.578125
  v -15 9.375 30.8628    -0.160789 -0.0782468 0.983882    0.375 0.578125
  v -13.125 9.375 31.35    0.0236934 -0.105184 0.99417    0.390625 0.578125
  v -11.25 9.375 30.8883    0.283263 -0.0578328 0.957297    0.40625 0.578125
  v -9.375 9.375 30.082    0.138068 0.047361 0.98929    0.421875 0.578125
  v -7.5 9.375 29.9853    -0.193217 0.101071 0.975936    0.4375 0.578125
  v -5.625 9.375 30.727    -0.241399 0.070455 0.967865    0.453125 0.578125
  v -3.75 9.375 31.0781    0.0649295 0.00474076 0.997879    0.46875 0.578125
  v -1.875 9.375 30.6313    0.177983 -0.0232667 0.983758    0.484375 0.578125
  v -1.23138e-023 9.375 30.5047    -0.0868662 -0.00721088 0.996194    0.5 0.578125
  v 1.875 9.375 31.005    -0.158578 -0.0650151 0.985203    0.515625 0.578125
  v 3.75 9.375 31.0612    0.0297653 -0.185647 0.982166    0.53125 0.578125
  v 5.625 9.375 30.9085    0.0244978 -0.210615 0.977262    0.546875 0.578125
  v 7.5 9.375 31.1276    -0.107361 -0.115586 0.987478    0.5625 0.578125
  v 9.375 9.375 31.2178    0.021231 -0.124011 0.992054    0.578125 0.578125
  v 11.25 9.375 30.9778    0.0766858 -0.11893 0.989937    0.59375 0.578125
  v 13.125 9.375 31.097    -0.0785215 0.0659063 0.994732    0.609375 0.578125
  v 15 9.375 31.3807    -0.109949 0.188269 0.975944    0.625 0.578125
  v 16.875 9.375 31.3001    0.00827616 -0.00149119 0.999965    0.640625 0.578125
  v 18.75 9.375 31.3048    -0.00774193 -0.207395 0.978227    0.65625 0.578125
  v 20.625 9.375 31.4264    0.0649593 -0.209464 0.975656    0.671875 0.578125
  v 22.5 9.375 31.158    0.0939919 -0.081054 0.992268    0.6875 0.578125
  v 24.375 9.375 31.0767    -0.040093 0.0156174 0.999074    0.703125 0.578125
  v 26.25 9.375 31.2101    -0.00125278 -0.0150328 0.999886    0.71875 0.578125
  v 28.125 9.375 30.9146    0.134661 -0.156805 0.978406    0.734375 0.578125
  v 30 9.375 30.6768    0.0492771 -0.20874 0.976729    0.75 0.578125
  v 31.875 9.375 30.8096    -0.0230839 -0.123455 0.992082    0.765625 0.578125
  v 33.75 9.375 30.6624    0.0713578 -0.115894 0.990695    0.78125 0.578125
  v 35.625 9.375 30.4802    0.0223306 -0.126896 0.991665    0.796875 0.578125
  v 37.5 9.375 30.7211    -0.0873749 -0.00973045 0.996128    0.8125 0.578125
  v 39.375 9.375 30.8122    0.012402 0.0750834 0.9971    0.828125 0.578125
  v 41.25 9.375 30.4892    0.0943682 0.0581648 0.993837    0.84375 0.578125
  v 43.125 9.375 30.4301    -0.105126 0.0653867 0.992307    0.859375 0.578125
  v 45 9.375 30.8808    -0.126906 0.00949165 0.991869    0.875 0.578125
  v 46.875 9.375 31.0587    0.0648776 -0.0304372 0.997429    0.890625 0.578125
  v 48.75 9.375 30.8528    0.0818808 0.0575546 0.994979    0.90625 0.578125
  v 50.625 9.375 30.6628    0.021121 0.103658 0.994389    0.921875 0.578125
  v 52.5 9.375 30.4937    0.0314184 0.00760653 0.999477    0.9375 0.578125
  v 54.375 9.375 30.4924    -0.0280695 -0.0848181 0.996001    0.953125 0.578125
  v 56.25 9.375 30.8327    -0.0906039 -0.0713221 0.99333    0.96875 0.578125
  v 58.125 9.375 30.9913    -0.0116465 -0.0592862 0.998173    0.984375 0.578125
  v 60 9.375 30.7262    0.138254 -0.11898 0.983224    1 0.578125
  v -60 11.25 31.0777    0.00623629 0.252484 0.967581    0 0.59375
  v -58.125 11.25 31.1651    -0.0761967 0.234154 0.969209    0.015625 0.59375
  v -56.25 11.25 31.4017    -0.0467236 0.072496 0.996274    0.03125 0.59375
  v -54.375 11.25 31.3762    0.14943 -0.0409819 0.987923    0.046875 0.59375
  v -52.5 11.25 30.7403    0.236697 -0.0538144 0.970092    0.0625 0.59375
  v -50.625 11.25 30.3063    0.115366 -0.159053 0.980506    0.078125 0.59375
  v -48.75 11.25 30.3258    0.00161146 -0.246277 0.969198    0.09375 0.59375
  v -46.875 11.25 30.3549    -0.125062 -0.166717 0.978041    0.109375 0.59375
  v -45 11.25 30.771    -0.140704 -0.025121 0.989733    0.125 0.59375
  v -43.125 11.25 30.8529    0.0882255 0.035746 0.995459    0.140625 0.59375
  v -41.25 11.25 30.4632    0.0796388 0.0653501 0.994679    0.15625 0.59375
  v -39.375 11.25 30.6318    -0.08991 0.0774603 0.992933    0.171875 0.59375
  v -37.5 11.25 30.9207    -0.0687874 0.0103788 0.997577    0.1875 0.59375
  v -35.625 11.25 30.8898    0.0514387 -0.139075 0.988945    0.203125 0.59375
  v -33.75 11.25 30.7257    0.128236 -0.197329 0.971914    0.21875 0.59375
  v -31.875 11.25 30.3851    0.124181 -0.0411532 0.991406    0.234375 0.59375
  v -30 11.25 30.1707    -0.100809 0.170768 0.980141    0.25 0.59375
  v -28.125 11.25 30.6367    -0.233675 0.125434 0.96419    0.265625 0.59375
  v -26.25 11.25 31.2411    -0.16594 -0.0316628 0.985627    0.28125 0.59375
  v -24.375 11.25 31.5689    0.0329757 -0.0191725 0.999272    0.296875 0.59375
  v -22.5 11.25 31.1842    0.132609 0.122014 0.98363    0.3125 0.59375
  v -20.625 11.25 30.7409    0.0890541 0.139564 0.9862    0.328125 0.59375
  v -18.75 11.25 30.5031    0.0605027 0.0260524 0.997828    0.34375 0.59375
  v -16.875 11.25 30.4733    -0.0586923 -0.0452909 0.997248    0.359375 0.59375
  v -15 11.25 31.0018    -0.149399 0.0137062 0.988682    0.375 0.59375
  v -13.125 11.25 31.2789    0.052497 0.114335 0.992054    0.390625 0.59375
  v -11.25 11.25 30.6764    0.253136 0.074662 0.964545    0.40625 0.59375
  v -9.375 11.25 30.011    0.0908203 -0.0940855 0.991413    0.421875 0.59375
  v -7.5 11.25 30.2252    -0.197062 -0.195946 0.96061    0.4375 0.59375
  v -5.625 11.25 31.0311    -0.204461 -0.118446 0.971682    0.453125 0.59375
  v -3.75 11.25 31.2687    0.0706778 0.0163989 0.997364    0.46875 0.59375
  v -1.875 11.25 30.7686    0.213299 0.0659934 0.974756    0.484375 0.59375
  v -1.23138e-023 11.25 30.4349    -0.0479757 0.112392 0.992505    0.5 0.59375
  v 1.875 11.25 30.8948    -0.223601 0.134293 0.965385    0.515625 0.59375
  v 3.75 11.25 31.2753    -0.0710786 0.076995 0.994495    0.53125 0.59375
  v 5.625 11.25 31.2769    0.0715682 0.0348878 0.996825    0.546875 0.59375
  v 7.5 11.25 31.1022    -0.0329193 0.112702 0.993083    0.5625 0.59375
  v 9.375 11.25 31.2606    -0.0341329 0.120736 0.992098    0.578125 0.59375
  v 11.25 11.25 31.2144    0.131566 0.0661833 0.989096    0.59375 0.59375
  v 13.125 11.25 30.8475    0.150024 0.15824 0.975937    0.609375 0.59375
  v 15 11.25 30.5179    -0.0776852 0.309564 0.9477    0.625 0.59375
  v 16.875 11.25 30.9213    -0.222659 0.245402 0.943505    0.640625 0.59375
  v 18.75 11.25 31.5259    -0.146983 0.0833659 0.98562    0.65625 0.59375
  v 20.625 11.25 31.6955    0.123029 0.0304483 0.991936    0.671875 0.59375
  v 22.5 11.25 31.0773    0.224823 0.105764 0.968643    0.6875 0.59375
  v 24.375 11.25 30.7279    0.0157905 0.200913 0.979482    0.703125 0.59375
  v 26.25 11.25 30.9438    -0.100722 0.207738 0.972985    0.71875 0.59375
  v 28.125 11.25 31.1105    -0.0214725 0.0971687 0.995036    0.734375 0.59375
  v 30 11.25 31.1492    0.0462335 -0.00259974 0.998927    0.75 0.59375
  v 31.875 11.25 31.0434    0.0329181 0.0163637 0.999324    0.765625 0.59375
  v 33.75 11.25 30.9215    0.0159624 -0.0023021 0.99987    0.78125 0.59375
  v 35.625 11.25 30.9097    0.0463793 -0.0797341 0.995737    0.796875 0.59375
  v 37.5 11.25 30.7921    0.0329322 -0.0415968 0.998592    0.8125 0.59375
  v 39.375 11.25 30.6521    0.00929833 0.00391447 0.999949    0.828125 0.59375
  v 41.25 11.25 30.6096    0.0484849 -0.0624648 0.996869    0.84375 0.59375
  v 43.125 11.25 30.5639    -0.0857575 -0.0679048 0.993999    0.859375 0.59375
  v 45 11.25 31.0223    -0.125371 -0.00667924 0.992087    0.875 0.59375
  v 46.875 11.25 31.1255    0.117972 0.0531593 0.991593    0.890625 0.59375
  v 48.75 11.25 30.5601    0.158672 0.125705 0.979296    0.90625 0.59375
  v 50.625 11.25 30.347    -0.0514477 0.118263 0.991649    0.921875 0.59375
  v 52.5 11.25 30.6752    -0.11544 -0.0144275 0.99321    0.9375 0.59375
  v 54.375 11.25 30.9284    -0.0419577 -0.105265 0.993559    0.953125 0.59375
  v 56.25 11.25 30.9484    0.00250031 -0.0513572 0.998677    0.96875 0.59375
  v 58.125 11.25 30.8307    -0.038688 0.0174556 0.999099    0.984375 0.59375
  v 60 11.25 30.9395    0.00791814 -0.0318969 0.99946    1 0.59375
  v -60 13.125 30.7463    0.136712 0.0037449 0.990604    0 0.609375
  v -58.125 13.125 30.5401    -0.0520567 0.142686 0.988398    0.015625 0.609375
  v -56.25 13.125 30.9573    -0.193808 0.174459 0.965403    0.03125 0.609375
  v -54.375 13.125 31.2978    0.0117672 0.0266384 0.999576    0.046875 0.609375
  v -52.5 13.125 30.8628    0.180788 -0.129491 0.97496    0.0625 0.609375
  v -50.625 13.125 30.6617    0.0123215 -0.183661 0.982912    0.078125 0.609375
  v -48.75 13.125 30.9197    -0.0571217 -0.241797 0.968644    0.09375 0.609375
  v -46.875 13.125 30.9069    -0.00881325 -0.249892 0.968234    0.109375 0.609375
  v -45 13.125 31.0628    -0.0102055 -0.108655 0.994027    0.125 0.609375
  v -43.125 13.125 30.9807    0.101262 -0.0214418 0.994629    0.140625 0.609375
  v -41.25 13.125 30.5175    0.117577 -0.0643898 0.990974    0.15625 0.609375
  v -39.375 13.125 30.4498    -0.0343972 -0.0345426 0.998811    0.171875 0.609375
  v -37.5 13.125 30.6123    -0.0839895 0.0640375 0.994407    0.1875 0.609375
  v -35.625 13.125 30.8482    -0.0637798 0.104594 0.992468    0.203125 0.609375
  v -33.75 13.125 30.9876    0.0640481 0.0191453 0.997763    0.21875 0.609375
  v -31.875 13.125 30.5829    0.244152 -0.0650359 0.967554    0.234375 0.609375
  v -30 13.125 29.9989    0.0497262 0.0246746 0.998458    0.25 0.609375
  v -28.125 13.125 30.378    -0.264637 0.1428 0.953717    0.265625 0.609375
  v -26.25 13.125 31.0852    -0.172737 0.192537 0.965966    0.28125 0.609375
  v -24.375 13.125 31.1875    0.101751 0.248788 0.963199    0.296875 0.609375
  v -22.5 13.125 30.5211    0.129066 0.225933 0.965555    0.3125 0.609375
  v -20.625 13.125 30.3776    -0.0546311 0.0834171 0.995016    0.328125 0.609375
  v -18.75 13.125 30.7786    -0.070807 -0.0532988 0.996065    0.34375 0.609375
  v -16.875 13.125 30.9617    -0.0386063 -0.0789082 0.996134    0.359375 0.609375
  v -15 13.125 31.0411    -0.0239471 -0.0233502 0.999441    0.375 0.609375
  v -13.125 13.125 30.7973    0.105641 0.0126406 0.994324    0.390625 0.609375
  v -11.25 13.125 30.3278    0.103786 -0.0593386 0.992828    0.40625 0.609375
  v -9.375 13.125 30.3471    -0.0896399 -0.213728 0.972772    0.421875 0.609375
  v -7.5 13.125 30.9976    -0.182933 -0.246312 0.95177    0.4375 0.609375
  v -5.625 13.125 31.4247    -0.00673995 -0.0876904 0.996125    0.453125 0.609375
  v -3.75 13.125 31.0289    0.204394 0.100598 0.973706    0.46875 0.609375
  v -1.875 13.125 30.3609    0.207967 0.116636 0.971157    0.484375 0.609375
  v -1.23138e-023 13.125 30.0107    -0.0162451 0.0672907 0.997601    0.5 0.609375
  v 1.875 13.125 30.4516    -0.190759 0.122561 0.973956    0.515625 0.609375
  v 3.75 13.125 30.8769    -0.095625 0.195404 0.97605    0.53125 0.609375
  v 5.625 13.125 30.8685    0.0776277 0.203426 0.976008    0.546875 0.609375
  v 7.5 13.125 30.5543    0.0556166 0.247306 0.96734    0.5625 0.609375
  v 9.375 13.125 30.7353    -0.063628 0.312477 0.947792    0.578125 0.609375
  v 11.25 13.125 30.8097    0.0609047 0.248216 0.966788    0.59375 0.609375
  v 13.125 13.125 30.3664    0.189631 0.121858 0.974264    0.609375 0.609375
  v 15 13.125 29.8949    -0.0200486 0.0807896 0.996529    0.625 0.609375
  v 16.875 13.125 30.4288    -0.28952 0.108842 0.950963    0.640625 0.609375
  v 18.75 13.125 31.1824    -0.196198 0.147402 0.969422    0.65625 0.609375
  v 20.625 13.125 31.3406    0.0992156 0.148513 0.983921    0.671875 0.609375
  v 22.5 13.125 30.6537    0.241346 0.0529798 0.968992    0.6875 0.609375
  v 24.375 13.125 30.2304    0.0726202 0.0121944 0.997285    0.703125 0.609375
  v 26.25 13.125 30.3995    -0.100554 0.0703586 0.992441    0.71875 0.609375
  v 28.125 13.125 30.6686    -0.0757075 0.11573 0.990391    0.734375 0.609375
  v 30 13.125 30.7983    0.0220236 0.139667 0.989954    0.75 0.609375
  v 31.875 13.125 30.6444    0.0443538 0.149825 0.987717    0.765625 0.609375
  v 33.75 13.125 30.5947    -0.0505132 0.124577 0.990923    0.78125 0.609375
  v 35.625 13.125 30.832    -0.0400404 0.037798 0.998483    0.796875 0.609375
  v 37.5 13.125 30.7461    0.0264972 -0.0577523 0.997979    0.8125 0.609375
  v 39.375 13.125 30.6499    -0.00189879 -0.10341 0.994637    0.828125 0.609375
  v 41.25 13.125 30.8194    0.0144567 -0.0905526 0.995787    0.84375 0.609375
  v 43.125 13.125 30.769    -0.0337001 -0.0415004 0.99857    0.859375 0.609375
  v 45 13.125 30.9894    -0.0528175 0.0145894 0.998498    0.875 0.609375
  v 46.875 13.125 30.8536    0.178353 0.0547458 0.982442    0.890625 0.609375
  v 48.75 13.125 30.2075    0.187985 0.0950568 0.977561    0.90625 0.609375
  v 50.625 13.125 30.1299    -0.106159 0.106149 0.988667    0.921875 0.609375
  v 52.5 13.125 30.6904    -0.195997 0.0766442 0.977605    0.9375 0.609375
  v 54.375 13.125 31.0081    -0.061757 0.0677777 0.995787    0.953125 0.609375
  v 56.25 13.125 30.9382    0.0344951 0.0533684 0.997979    0.96875 0.609375
  v 58.125 13.125 30.7706    -0.0210858 0.0460465 0.998717    0.984375 0.609375
  v 60 13.125 31.0679    -0.123729 0.0332253 0.99176    1 0.609375
  v -60 15 30.9808    0.171887 -0.138062 0.975394    0 0.625
  v -58.125 15 30.6157    0.0924827 -0.0816159 0.992364    0.015625 0.625
  v -56.25 15 30.7225    -0.153655 0.0953493 0.983513    0.03125 0.625
  v -54.375 15 31.2318    -0.150791 0.14265 0.978219    0.046875 0.625
  v -52.5 15 31.3034    0.0788781 0.0162371 0.996752    0.0625 0.625
  v -50.625 15 31.1138    0.0204644 -0.00874746 0.999752    0.078125 0.625
  v -48.75 15 31.2901    -0.108419 0.01832 0.993936    0.09375 0.625
  v -46.875 15 31.4376    0.0239792 -0.0396853 0.998924    0.109375 0.625
  v -45 15 31.2194    0.13114 -0.016123 0.991233    0.125 0.625
  v -43.125 15 30.7762    0.0943707 0.030081 0.995082    0.140625 0.625
  v -41.25 15 30.626    0.0301893 -0.0637451 0.99751    0.15625 0.625
  v -39.375 15 30.7273    -0.0051078 -0.125544 0.992075    0.171875 0.625
  v -37.5 15 30.757    0.0436525 -0.058818 0.997314    0.1875 0.625
  v -35.625 15 30.6258    0.00695761 0.0826113 0.996558    0.203125 0.625
  v -33.75 15 30.6328    -0.0395518 0.114071 0.992685    0.21875 0.625
  v -31.875 15 30.5968    0.153163 -0.0354556 0.987565    0.234375 0.625
  v -30 15 30.0699    0.138798 -0.120401 0.982975    0.25 0.625
  v -28.125 15 30.1107    -0.160859 -0.0390833 0.986203    0.265625 0.625
  v -26.25 15 30.6136    -0.0957326 0.0497736 0.994162    0.28125 0.625
  v -24.375 15 30.4404    0.107327 0.093124 0.989853    0.296875 0.625
  v -22.5 15 29.9937    -0.0052794 0.00494098 0.999974    0.3125 0.625
  v -20.625 15 30.4704    -0.161172 -0.102594 0.981579    0.328125 0.625
  v -18.75 15 31.0153    -0.0549802 -0.0393409 0.997712    0.34375 0.625
  v -16.875 15 30.8947    0.0278418 0.0978274 0.994814    0.359375 0.625
  v -15 15 30.8344    -0.051423 0.127884 0.990455    0.375 0.625
  v -13.125 15 30.9186    -0.00160636 -0.00853228 0.999962    0.390625 0.625
  v -11.25 15 30.8587    -0.0161745 -0.138606 0.990216    0.40625 0.625
  v -9.375 15 31.174    -0.107813 -0.140606 0.984178    0.421875 0.625
  v -7.5 15 31.5592    -0.0696472 -0.0215402 0.997339    0.4375 0.625
  v -5.625 15 31.369    0.135822 0.0538823 0.989267    0.453125 0.625
  v -3.75 15 30.6136    0.253276 0.0214368 0.967157    0.46875 0.625
  v -1.875 15 30.1101    0.102365 -0.0688432 0.992362    0.484375 0.625
  v -1.23138e-023 15 30.2056    -0.0440634 -0.164236 0.985436    0.5 0.625
  v 1.875 15 30.5416    -0.0743347 -0.0975088 0.992455    0.515625 0.625
  v 3.75 15 30.568    -0.0312514 0.0263021 0.999165    0.53125 0.625
  v 5.625 15 30.4724    0.0662894 0.0284368 0.997395    0.546875 0.625
  v 7.5 15 30.2169    0.154122 0.0221541 0.987803    0.5625 0.625
  v 9.375 15 30.0258    -0.00532297 0.13944 0.990216    0.578125 0.625
  v 11.25 15 30.1114    -0.0871016 0.124825 0.988348    0.59375 0.625
  v 13.125 15 30.1951    0.0196604 -0.0596364 0.998027    0.609375 0.625
  v 15 15 30.1865    -0.0302053 -0.157418 0.98707    0.625 0.625
  v 16.875 15 30.6209    -0.21405 -0.0716724 0.97419    0.640625 0.625
  v 18.75 15 31.0817    -0.107272 0.0560378 0.992649    0.65625 0.625
  v 20.625 15 30.9987    0.0404685 0.113871 0.992671    0.671875 0.625
  v 22.5 15 30.7022    0.0760461 -0.0455912 0.996061    0.6875 0.625
  v 24.375 15 30.7027    0.0466674 -0.203904 0.977878    0.703125 0.625
  v 26.25 15 30.7239    -0.0134699 -0.165987 0.986036    0.71875 0.625
  v 28.125 15 30.7742    -0.00737724 -0.0798382 0.996781    0.734375 0.625
  v 30 15 30.6769    0.055732 -0.034989 0.997832    0.75 0.625
  v 31.875 15 30.4381    0.0574424 -0.0229686 0.998085    0.765625 0.625
  v 33.75 15 30.4448    -0.0544336 0.00841296 0.998482    0.78125 0.625
  v 35.625 15 30.766    -0.121998 0.041908 0.991645    0.796875 0.625
  v 37.5 15 30.9302    -0.0964208 -0.0392446 0.994567    0.8125 0.625
  v 39.375 15 31.1135    -0.018376 -0.153544 0.987971    0.828125 0.625
  v 41.25 15 31.1285    0.102408 -0.106991 0.988972    0.84375 0.625
  v 43.125 15 30.7628    0.0460812 0.0148293 0.998828    0.859375 0.625
  v 45 15 30.8503    -0.0501535 0.0470038 0.997635    0.875 0.625
  v 46.875 15 30.8293    0.170561 -0.00853339 0.98531    0.890625 0.625
  v 48.75 15 30.2033    0.210189 -0.0359587 0.976999    0.90625 0.625
  v 50.625 15 30.0139    -0.0867771 -0.0206409 0.996014    0.921875 0.625
  v 52.5 15 30.5014    -0.163607 0.018504 0.986352    0.9375 0.625
  v 54.375 15 30.6848    -0.0402495 0.0913195 0.995008    0.953125 0.625
  v 56.25 15 30.6383    -0.0207158 0.0966854 0.995099    0.96875 0.625
  v 58.125 15 30.7051    -0.0014923 0.0413491 0.999144    0.984375 0.625
  v 60 15 30.8077    -0.0882492 0.0895089 0.992069    1 0.625
  v -60 16.875 31.2105    0.14853 0.0295913 0.988465    0 0.640625
  v -58.125 16.875 30.9486    0.177321 -0.00784002 0.984122    0.015625 0.640625
  v -56.25 16.875 30.6081    0.0247911 0.093459 0.995314    0.03125 0.640625
  v -54.375 16.875 30.7414    -0.13402 0.209883 0.968498    0.046875 0.640625
  v -52.5 16.875 30.9927    0.00914251 0.205024 0.978714    0.0625 0.640625
  v -50.625 16.875 30.7583    0.0646075 0.19972 0.977721    0.078125 0.640625
  v -48.75 16.875 30.7587    -0.0963846 0.247012 0.964207    0.09375 0.640625
  v -46.875 16.875 31.0833    -0.0761569 0.197086 0.977424    0.109375 0.640625
  v -45 16.875 30.9649    0.0827332 0.0449526 0.995557    0.125 0.640625
  v -43.125 16.875 30.6345    0.0577429 -0.0611601 0.996456    0.140625 0.640625
  v -41.25 16.875 30.8248    -0.025074 -0.0563778 0.998095    0.15625 0.640625
  v -39.375 16.875 31.0372    0.0112008 0.01903 0.999756    0.171875 0.640625
  v -37.5 16.875 30.8996    0.110514 0.0494793 0.992642    0.1875 0.640625
  v -35.625 16.875 30.4382    0.0803717 0.0304566 0.9963    0.203125 0.640625
  v -33.75 16.875 30.3743    -0.0855372 0.016495 0.996198    0.21875 0.640625
  v -31.875 16.875 30.7474    0.00215177 -0.0446669 0.999    0.234375 0.640625
  v -30 16.875 30.5132    0.0988664 -0.129085 0.986693    0.25 0.640625
  v -28.125 16.875 30.4513    -0.0946093 -0.145301 0.984854    0.265625 0.640625
  v -26.25 16.875 30.8368    -0.0644818 -0.133676 0.988925    0.28125 0.640625
  v -24.375 16.875 30.6066    0.0678366 -0.154612 0.985644    0.296875 0.640625
  v -22.5 16.875 30.5108    -0.110278 -0.230323 0.966846    0.3125 0.640625
  v -20.625 16.875 31.176    -0.132948 -0.279106 0.951012    0.328125 0.640625
  v -18.75 16.875 31.1456    0.129556 -0.176714 0.975698    0.34375 0.640625
  v -16.875 16.875 30.514    0.202461 0.034478 0.978683    0.359375 0.640625
  v -15 16.875 30.3748    -0.0470355 0.225663 0.973069    0.375 0.640625
  v -13.125 16.875 30.848    -0.144638 0.239195 0.960138    0.390625 0.640625
  v -11.25 16.875 31.0603    -0.0820518 0.137554 0.98709    0.40625 0.640625
  v -9.375 16.875 31.1886    -0.0143688 0.107581 0.994093    0.421875 0.640625
  v -7.5 16.875 31.0188    0.0333078 0.182825 0.982581    0.4375 0.640625
  v -5.625 16.875 30.8061    0.0490569 0.158883 0.986078    0.453125 0.640625
  v -3.75 16.875 30.6826    0.0906405 -0.036055 0.995231    0.46875 0.640625
  v -1.875 16.875 30.6148    -0.00982367 -0.175227 0.984479    0.484375 0.640625
  v -1.23138e-023 16.875 30.914    -0.0461851 -0.206364 0.977385    0.5 0.640625
  v 1.875 16.875 30.903    0.0460463 -0.15556 0.986753    0.515625 0.640625
  v 3.75 16.875 30.5843    0.0171765 -0.104703 0.994355    0.53125 0.640625
  v 5.625 16.875 30.6597    0.00368312 -0.138785 0.990316    0.546875 0.640625
  v 7.5 16.875 30.618    0.169248 -0.193103 0.966471    0.5625 0.640625
  v 9.375 16.875 30.058    0.0784363 -0.159044 0.984151    0.578125 0.640625
  v 11.25 16.875 30.1603    -0.17143 -0.140253 0.975162    0.59375 0.640625
  v 13.125 16.875 30.7374    -0.102616 -0.205179 0.97333    0.609375 0.640625
  v 15 16.875 30.8151    0.0283361 -0.186541 0.982039    0.625 0.640625
  v 16.875 16.875 30.7736    -0.0570892 -0.0363002 0.997709    0.640625 0.640625
  v 18.75 16.875 30.9293    0.00784431 0.0983363 0.995122    0.65625 0.640625
  v 20.625 16.875 30.6829    0.0105616 0.171691 0.985094    0.671875 0.640625
  v 22.5 16.875 30.8238    -0.0974229 0.108867 0.989271    0.6875 0.640625
  v 24.375 16.875 31.2222    -0.00783546 0.0290127 0.999548    0.703125 0.640625
  v 26.25 16.875 31.0529    0.0756214 0.0670317 0.994881    0.71875 0.640625
  v 28.125 16.875 30.8939    0.0181944 0.102384 0.994578    0.734375 0.640625
  v 30 16.875 30.8046    0.00926562 0.0243837 0.99966    0.75 0.640625
  v 31.875 16.875 30.7161    0.0428495 -0.0827127 0.995652    0.765625 0.640625
  v 33.75 16.875 30.6849    0.0324333 -0.0629836 0.997487    0.78125 0.640625
  v 35.625 16.875 30.6965    -0.0548779 0.0784442 0.995407    0.796875 0.640625
  v 37.5 16.875 30.8747    -0.18233 0.131872 0.974354    0.8125 0.640625
  v 39.375 16.875 31.3648    -0.0955362 0.0362279 0.994766    0.828125 0.640625
  v 41.25 16.875 31.271    0.180687 -0.0121998 0.983465    0.84375 0.640625
  v 43.125 16.875 30.6148    0.142059 0.063234 0.987836    0.859375 0.640625
  v 45 16.875 30.6896    -0.0710939 0.131545 0.988758    0.875 0.640625
  v 46.875 16.875 30.9037    0.0908446 0.0852628 0.992208    0.890625 0.640625
  v 48.75 16.875 30.3463    0.171846 -0.00798145 0.985092    0.90625 0.640625
  v 50.625 16.875 30.1707    -0.0807142 -0.0660327 0.994548    0.921875 0.640625
  v 52.5 16.875 30.6607    -0.123975 -0.070521 0.989776    0.9375 0.640625
  v 54.375 16.875 30.6453    0.0049111 -0.0544561 0.998504    0.953125 0.640625
  v 56.25 16.875 30.5147    -0.0489531 -0.060408 0.996973    0.96875 0.640625
  v 58.125 16.875 30.7783    0.0038506 -0.0863037 0.996261    0.984375 0.640625
  v 60 16.875 30.6241    0.0365159 -0.016345 0.999199    1 0.640625
  v -60 18.75 31.0411    0.166115 0.0277323 0.985716    0 0.65625
  v -58.125 18.75 30.7197    0.208835 0.0622771 0.975966    0.015625 0.65625
  v -56.25 18.75 30.2596    0.0964894 0.10335 0.989954    0.03125 0.65625
  v -54.375 18.75 30.2765    -0.116042 0.0915192 0.989019    0.046875 0.65625
  v -52.5 18.75 30.5671    -0.0321384 0.0292005 0.999057    0.0625 0.65625
  v -50.625 18.75 30.3612    0.0946485 0.0100784 0.99546    0.078125 0.65625
  v -48.75 18.75 30.2753    -0.0448242 0.0720952 0.99639    0.09375 0.65625
  v -46.875 18.75 30.5826    -0.166036 0.126387 0.977987    0.109375 0.65625
  v -45 18.75 30.9202    -0.102947 0.0480165 0.993527    0.125 0.65625
  v -43.125 18.75 31.0907    -0.0043879 -0.0830541 0.996535    0.140625 0.65625
  v -41.25 18.75 31.1508    0.090551 -0.0599006 0.994089    0.15625 0.65625
  v -39.375 18.75 30.7705    0.122234 0.0670937 0.990231    0.171875 0.65625
  v -37.5 18.75 30.3847    0.0570943 0.0611893 0.996492    0.1875 0.65625
  v -35.625 18.75 30.2935    0.0080977 -0.0561902 0.998387    0.203125 0.65625
  v -33.75 18.75 30.5544    -0.0803787 -0.0517915 0.995418    0.21875 0.65625
  v -31.875 18.75 30.906    -0.0167267 0.0400611 0.999057    0.234375 0.65625
  v -30 18.75 30.6509    0.0554739 0.0499263 0.997211    0.25 0.65625
  v -28.125 18.75 30.6254    -0.0901583 0.0163831 0.995793    0.265625 0.65625
  v -26.25 18.75 31.0264    -0.0934942 0.0146991 0.995511    0.28125 0.65625
  v -24.375 18.75 30.9631    0.0106721 -0.0356118 0.999309    0.296875 0.65625
  v -22.5 18.75 31.0143    -0.171589 -0.0933815 0.980733    0.3125 0.65625
  v -20.625 18.75 31.6683    -0.143643 -0.120515 0.982264    0.328125 0.65625
  v -18.75 18.75 31.545    0.21405 -0.123793 0.968947    0.34375 0.65625
  v -16.875 18.75 30.7928    0.364115 -0.07376 0.928429    0.359375 0.65625
  v -15 18.75 30.0918    0.143119 0.0717611 0.9871    0.375 0.65625
  v -13.125 18.75 30.0739    -0.110407 0.20476 0.972565    0.390625 0.65625
  v -11.25 18.75 30.3356    -0.166538 0.203955 0.964711    0.40625 0.65625
  v -9.375 18.75 30.665    -0.0669076 0.115474 0.991055    0.421875 0.65625
  v -7.5 18.75 30.594    0.0278611 0.0530639 0.998202    0.4375 0.65625
  v -5.625 18.75 30.6083    -0.0494511 0.0269575 0.998413    0.453125 0.65625
  v -3.75 18.75 30.9052    -0.0613678 -0.0402711 0.997302    0.46875 0.65625
  v -1.875 18.75 30.9826    -0.0333426 -0.0900271 0.995381    0.484375 0.65625
  v -1.23138e-023 18.75 31.1201    -0.0305235 -0.0685247 0.997182    0.5 0.65625
  v 1.875 18.75 30.9851    0.0412119 -0.0982284 0.99431    0.515625 0.65625
  v 3.75 18.75 30.79    -0.00207615 -0.174099 0.984726    0.53125 0.65625
  v 5.625 18.75 31.0481    -0.0197966 -0.182075 0.983085    0.546875 0.65625
  v 7.5 18.75 31.0347    0.140607 -0.149944 0.978645    0.5625 0.65625
  v 9.375 18.75 30.4918    0.0889977 -0.169565 0.981492    0.578125 0.65625
  v 11.25 18.75 30.6691    -0.174239 -0.179047 0.968289    0.59375 0.65625
  v 13.125 18.75 31.2409    -0.110223 -0.176032 0.978194    0.609375 0.65625
  v 15 18.75 31.0533    0.121309 -0.163702 0.979023    0.625 0.65625
  v 16.875 18.75 30.6651    0.104721 -0.0613823 0.992606    0.640625 0.65625
  v 18.75 18.75 30.6481    0.102613 0.0743595 0.991938    0.65625 0.65625
  v 20.625 18.75 30.2785    0.0332636 0.138734 0.989771    0.671875 0.65625
  v 22.5 18.75 30.4528    -0.13208 0.128521 0.982872    0.6875 0.65625
  v 24.375 18.75 30.79    0.0123806 0.141422 0.989872    0.703125 0.65625
  v 26.25 18.75 30.4104    0.147119 0.1999 0.968708    0.71875 0.65625
  v 28.125 18.75 30.1842    -0.0119226 0.245917 0.969218    0.734375 0.65625
  v 30 18.75 30.4332    -0.155207 0.16808 0.973478    0.75 0.65625
  v 31.875 18.75 30.7931    -0.0756364 -0.0164954 0.996999    0.765625 0.65625
  v 33.75 18.75 30.7849    0.104712 -0.0906684 0.990361    0.78125 0.65625
  v 35.625 18.75 30.4489    0.105791 0.0221887 0.994141    0.796875 0.65625
  v 37.5 18.75 30.3716    -0.15959 0.150699 0.975613    0.8125 0.65625
  v 39.375 18.75 31.002    -0.189569 0.142601 0.971457    0.828125 0.65625
  v 41.25 18.75 31.127    0.146254 0.0759559 0.986327    0.84375 0.65625
  v 43.125 18.75 30.4979    0.225157 0.0765937 0.971307    0.859375 0.65625
  v 45 18.75 30.3687    -0.0258794 0.164623 0.986017    0.875 0.65625
  v 46.875 18.75 30.5139    0.00461489 0.144819 0.989447    0.890625 0.65625
  v 48.75 18.75 30.1657    0.0719237 0.017331 0.99726    0.90625 0.65625
  v 50.625 18.75 30.2633    -0.0948356 -0.032662 0.994957    0.921875 0.65625
  v 52.5 18.75 30.7654    -0.120603 0.0269289 0.992336    0.9375 0.65625
  v 54.375 18.75 30.7628    -0.0389098 0.0121262 0.999169    0.953125 0.65625
  v 56.25 18.75 30.8151    -0.100099 -0.0876862 0.991106    0.96875 0.65625
  v 58.125 18.75 31.1578    0.0112365 -0.135891 0.99066    0.984375 0.65625
  v 60 18.75 30.8269    0.142179 -0.119705 0.982576    1 0.65625
  v -60 20.625 31.0382    0.141467 -0.0664327 0.987711    0 0.671875
  v -58.125 20.625 30.7332    0.243105 -0.052272 0.968591    0.015625 0.671875
  v -56.25 20.625 30.1433    0.13005 0.0114927 0.991441    0.03125 0.671875
  v -54.375 20.625 30.2546    -0.173501 0.0400783 0.984018    0.046875 0.671875
  v -52.5 20.625 30.8411    -0.13202 -0.0445434 0.990246    0.0625 0.671875
  v -50.625 20.625 30.7856    0.0826871 -0.147084 0.985662    0.078125 0.671875
  v -48.75 20.625 30.5312    0.0433771 -0.14516 0.988457    0.09375 0.671875
  v -46.875 20.625 30.5983    -0.0856679 -0.0388088 0.995568    0.109375 0.671875
  v -45 20.625 30.8945    -0.130756 0.0761554 0.988485    0.125 0.671875
  v -43.125 20.625 31.1716    -0.0405184 0.106754 0.99346    0.140625 0.671875
  v -41.25 20.625 31.0787    0.135792 0.0930056 0.986362    0.15625 0.671875
  v -39.375 20.625 30.4844    0.116026 0.0459518 0.992183    0.171875 0.671875
  v -37.5 20.625 30.4072    -0.0888192 -0.0900244 0.991971    0.1875 0.671875
  v -35.625 20.625 30.8557    -0.0523981 -0.230569 0.971644    0.203125 0.671875
  v -33.75 20.625 30.8778    0.0710388 -0.159637 0.984616    0.21875 0.671875
  v -31.875 20.625 30.6285    0.112236 0.0319107 0.993169    0.234375 0.671875
  v -30 20.625 30.2495    0.0257064 0.0854373 0.996012    0.25 0.671875
  v -28.125 20.625 30.419    -0.11083 0.0331192 0.993287    0.265625 0.671875
  v -26.25 20.625 30.7628    -0.0835375 0.0555719 0.994954    0.28125 0.671875
  v -24.375 20.625 30.7723    -0.024307 0.0831284 0.996242    0.296875 0.671875
  v -22.5 20.625 30.9035    -0.199508 0.0805558 0.976579    0.3125 0.671875
  v -20.625 20.625 31.607    -0.162969 0.0876173 0.982733    0.328125 0.671875
  v -18.75 20.625 31.5974    0.204059 0.0791283 0.975755    0.34375 0.671875
  v -16.875 20.625 30.8321    0.362156 0.0277284 0.931705    0.359375 0.671875
  v -15 20.625 29.9528    0.185073 -0.0794323 0.979509    0.375 0.671875
  v -13.125 20.625 29.8468    -0.0622848 -0.136415 0.988692    0.390625 0.671875
  v -11.25 20.625 30.1926    -0.179767 -0.0866421 0.979886    0.40625 0.671875
  v -9.375 20.625 30.736    -0.131468 -0.0205738 0.991107    0.421875 0.671875
  v -7.5 20.625 30.8602    -0.00278492 -0.0210566 0.999774    0.4375 0.671875
  v -5.625 20.625 30.8276    -0.0238775 -0.0106091 0.999659    0.453125 0.671875
  v -3.75 20.625 30.9758    -0.0691272 0.0435881 0.996655    0.46875 0.671875
  v -1.875 20.625 31.0459    -0.00920552 0.0752159 0.997125    0.484375 0.671875
  v -1.23138e-023 20.625 31.0602    -0.0283557 0.12273 0.992035    0.5 0.671875
  v 1.875 20.625 31.1042    -0.0682023 0.0778934 0.994626    0.515625 0.671875
  v 3.75 20.625 31.305    -0.0764022 -0.0425514 0.996169    0.53125 0.671875
  v 5.625 20.625 31.5288    0.0455663 -0.0512802 0.997644    0.546875 0.671875
  v 7.5 20.625 31.1847    0.186966 0.0424814 0.981448    0.5625 0.671875
  v 9.375 20.625 30.6978    0.0739787 0.0645805 0.995167    0.578125 0.671875
  v 11.25 20.625 30.9246    -0.162742 0.0595651 0.984869    0.59375 0.671875
  v 13.125 20.625 31.3647    -0.136055 0.0758174 0.987796    0.609375 0.671875
  v 15 20.625 31.3348    0.0948619 0.0107111 0.995433    0.625 0.671875
  v 16.875 20.625 31.0075    0.188 -0.0349311 0.981548    0.640625 0.671875
  v 18.75 20.625 30.6559    0.181167 -0.000438319 0.983452    0.65625 0.671875
  v 20.625 20.625 30.0896    0.0385635 -0.0219284 0.999016    0.671875 0.671875
  v 22.5 20.625 30.3387    -0.163468 -0.0837393 0.982988    0.6875 0.671875
  v 24.375 20.625 30.6879    0.00683809 -0.137644 0.990458    0.703125 0.671875
  v 26.25 20.625 30.2344    0.1976 -0.152824 0.968297    0.71875 0.671875
  v 28.125 20.625 29.9108    0.0635547 -0.0736595 0.995256    0.734375 0.671875
  v 30 20.625 30.1558    -0.20294 0.0707026 0.976635    0.75 0.671875
  v 31.875 20.625 30.8385    -0.232476 0.064721 0.970446    0.765625 0.671875
  v 33.75 20.625 31.0872    0.043731 -0.0875398 0.995201    0.78125 0.671875
  v 35.625 20.625 30.6027    0.200382 -0.168314 0.965151    0.796875 0.671875
  v 37.5 20.625 30.2146    -0.0654135 -0.109692 0.991811    0.8125 0.671875
  v 39.375 20.625 30.8203    -0.197619 -0.0259602 0.979935    0.828125 0.671875
  v 41.25 20.625 31.05    0.109551 0.00343407 0.993975    0.84375 0.671875
  v 43.125 20.625 30.44    0.270164 -0.00685751 0.96279    0.859375 0.671875
  v 45 20.625 29.979    0.0164449 0.0124783 0.999787    0.875 0.671875
  v 46.875 20.625 30.17    -0.104381 -0.037936 0.993814    0.890625 0.671875
  v 48.75 20.625 30.3047    -0.0395213 -0.158348 0.986592    0.90625 0.671875
  v 50.625 20.625 30.5283    -0.0324036 -0.166811 0.985456    0.921875 0.671875
  v 52.5 20.625 30.5957    -0.000230849 -0.0062063 0.999981    0.9375 0.671875
  v 54.375 20.625 30.4984    -0.0518848 0.131992 0.989892    0.953125 0.671875
  v 56.25 20.625 30.8595    -0.192228 0.131767 0.972464    0.96875 0.671875
  v 58.125 20.625 31.3484    -0.0477098 0.0403807 0.998045    0.984375 0.671875
  v 60 20.625 30.9328    0.201923 -0.0550721 0.977852    1 0.671875
  v -60 22.5 31.1749    0.100195 0.0791869 0.991812    0 0.6875
  v -58.125 22.5 30.9787    0.232775 0.00430731 0.972521    0.015625 0.6875
  v -56.25 22.5 30.2427    0.216562 0.00854759 0.976231    0.03125 0.6875
  v -54.375 22.5 30.1485    -0.13552 0.102673 0.98544    0.046875 0.6875
  v -52.5 22.5 30.7554    -0.230704 0.107038 0.967119    0.0625 0.6875
  v -50.625 22.5 30.9298    -0.015679 -0.021904 0.999637    0.078125 0.6875
  v -48.75 22.5 30.8067    0.0677514 -0.0962574 0.993048    0.09375 0.6875
  v -46.875 22.5 30.7671    0.0184583 -0.0620708 0.997901    0.109375 0.6875
  v -45 22.5 30.7048    -0.0231262 0.00581086 0.999716    0.125 0.6875
  v -43.125 22.5 30.7119    0.00670084 0.0820843 0.996603    0.140625 0.6875
  v -41.25 22.5 30.6325    0.0938142 0.127014 0.987455    0.15625 0.6875
  v -39.375 22.5 30.3709    -0.00939761 0.0699401 0.997507    0.171875 0.6875
  v -37.5 22.5 30.7554    -0.227606 -0.0377674 0.973021    0.1875 0.6875
  v -35.625 22.5 31.4562    -0.0894591 -0.0929907 0.99164    0.203125 0.6875
  v -33.75 22.5 31.2158    0.186526 -0.0783972 0.979317    0.21875 0.6875
  v -31.875 22.5 30.579    0.1834 -0.064912 0.980893    0.234375 0.6875
  v -30 22.5 30.2158    -0.00872762 -0.12573 0.992026    0.25 0.6875
  v -28.125 22.5 30.5925    -0.127468 -0.159653 0.978909    0.265625 0.6875
  v -26.25 22.5 30.8498    -0.0111807 -0.10081 0.994843    0.28125 0.6875
  v -24.375 22.5 30.6989    0.0340852 0.0080587 0.999386    0.296875 0.6875
  v -22.5 22.5 30.7554    -0.152929 0.108348 0.98228    0.3125 0.6875
  v -20.625 22.5 31.3859    -0.131538 0.191654 0.972608    0.328125 0.6875
  v -18.75 22.5 31.2732    0.190034 0.202015 0.960769    0.34375 0.6875
  v -16.875 22.5 30.5085    0.248003 0.134411 0.959389    0.359375 0.6875
  v -15 22.5 30.152    0.00467038 -0.0285239 0.999582    0.375 0.6875
  v -13.125 22.5 30.6229    -0.129265 -0.170484 0.976845    0.390625 0.6875
  v -11.25 22.5 30.8853    -0.0724151 -0.172445 0.982354    0.40625 0.6875
  v -9.375 22.5 30.9052    -0.00898168 -0.0636168 0.997934    0.421875 0.6875
  v -7.5 22.5 30.7554    0.0470058 0.0403437 0.99808    0.4375 0.6875
  v -5.625 22.5 30.6739    0.0237096 0.105159 0.994173    0.453125 0.6875
  v -3.75 22.5 30.6983    -0.0239389 0.161608 0.986565    0.46875 0.6875
  v -1.875 22.5 30.7458    0.0229221 0.187118 0.98207    0.484375 0.6875
  v -1.23138e-023 22.5 30.6017    -0.00462041 0.204398 0.978877    0.5 0.6875
  v 1.875 22.5 30.6683    -0.126692 0.19026 0.973525    0.515625 0.6875
  v 3.75 22.5 31.098    -0.137914 0.15363 0.978457    0.53125 0.6875
  v 5.625 22.5 31.2993    0.0646417 0.130461 0.989344    0.546875 0.6875
  v 7.5 22.5 30.7554    0.240605 0.114357 0.963863    0.5625 0.6875
  v 9.375 22.5 30.2715    0.111723 0.159275 0.980892    0.578125 0.6875
  v 11.25 22.5 30.4767    -0.125845 0.255594 0.958559    0.59375 0.6875
  v 13.125 22.5 30.8336    -0.139688 0.306757 0.941482    0.609375 0.6875
  v 15 22.5 31.0146    0.0158674 0.285807 0.958156    0.625 0.6875
  v 16.875 22.5 30.8403    0.149612 0.227833 0.962137    0.640625 0.6875
  v 18.75 22.5 30.4311    0.129721 0.168496 0.977129    0.65625 0.6875
  v 20.625 22.5 30.1935    -0.066378 0.0390154 0.997031    0.671875 0.6875
  v 22.5 22.5 30.7554    -0.243113 -0.061976 0.968016    0.6875 0.6875
  v 24.375 22.5 31.2658    -0.0718996 -0.120619 0.990092    0.703125 0.6875
  v 26.25 22.5 31.0248    0.148244 -0.221223 0.96389    0.71875 0.6875
  v 28.125 22.5 30.6614    0.187784 -0.26976 0.94444    0.734375 0.6875
  v 30 22.5 30.2932    0.0247129 -0.103955 0.994275    0.75 0.6875
  v 31.875 22.5 30.5587    -0.218476 0.137766 0.966069    0.765625 0.6875
  v 33.75 22.5 31.0604    -0.145758 0.105437 0.983686    0.78125 0.6875
  v 35.625 22.5 31.0138    0.0889253 -0.120726 0.988695    0.796875 0.6875
  v 37.5 22.5 30.7554    -0.00211022 -0.209007 0.977912    0.8125 0.6875
  v 39.375 22.5 31.1697    -0.109416 -0.119373 0.986802    0.828125 0.6875
  v 41.25 22.5 31.1679    0.144286 -0.0448146 0.988521    0.84375 0.6875
  v 43.125 22.5 30.5073    0.229605 -0.0617156 0.971325    0.859375 0.6875
  v 45 22.5 30.1147    -0.0332755 -0.161483 0.986314    0.875 0.6875
  v 46.875 22.5 30.6007    -0.173524 -0.228671 0.957914    0.890625 0.6875
  v 48.75 22.5 30.9877    -0.0785303 -0.229035 0.970245    0.90625 0.6875
  v 50.625 22.5 31.0757    0.0325732 -0.200951 0.97906    0.921875 0.6875
  v 52.5 22.5 30.7554    0.162965 -0.153892 0.974556    0.9375 0.6875
  v 54.375 22.5 30.3219    0.117012 -0.0034006 0.993125    0.953125 0.6875
  v 56.25 22.5 30.4023    -0.133101 0.211931 0.968178    0.96875 0.6875
  v 58.125 22.5 30.8907    -0.163729 0.274216 0.947628    0.984375 0.6875
  v 60 22.5 30.9536    0.0510451 0.150987 0.987217    1 0.6875
  v -60 24.375 30.8704    0.0703553 0.14694 0.98664    0 0.703125
  v -58.125 24.375 30.6947    0.157277 0.0942321 0.983048    0.015625 0.703125
  v -56.25 24.375 30.1327    0.229918 -0.0170782 0.97306    0.03125 0.703125
  v -54.375 24.375 29.8393    -0.0571096 -0.00465244 0.998357    0.046875 0.703125
  v -52.5 24.375 30.2943    -0.296907 0.0166271 0.954761    0.0625 0.703125
  v -50.625 24.375 30.8605    -0.131318 -0.0764714 0.988386    0.078125 0.703125
  v -48.75 24.375 30.9895    0.0732429 -0.0886313 0.993368    0.09375 0.703125
  v -46.875 24.375 30.7996    0.0527068 -0.015003 0.998497    0.109375 0.703125
  v -45 24.375 30.7285    -0.0176132 -0.0219712 0.999603    0.125 0.703125
  v -43.125 24.375 30.8067    0.0556047 -0.0462361 0.997382    0.140625 0.703125
  v -41.25 24.375 30.6066    0.125015 0.00894872 0.992114    0.15625 0.703125
  v -39.375 24.375 30.3128    -0.047206 0.0282998 0.998484    0.171875 0.703125
  v -37.5 24.375 30.7515    -0.237454 0.0241695 0.971098    0.1875 0.703125
  v -35.625 24.375 31.3214    -0.0735961 0.0888025 0.993327    0.203125 0.703125
  v -33.75 24.375 31.0285    0.159268 0.096645 0.982494    0.21875 0.703125
  v -31.875 24.375 30.5962    0.0744127 -0.012885 0.997144    0.234375 0.703125
  v -30 24.375 30.7086    -0.0838002 -0.135706 0.987199    0.25 0.703125
  v -28.125 24.375 31.1838    -0.10139 -0.114321 0.988256    0.265625 0.703125
  v -26.25 24.375 31.212    0.0709446 -0.0608715 0.995621    0.28125 0.703125
  v -24.375 24.375 30.776    0.14661 -0.0214257 0.988962    0.296875 0.703125
  v -22.5 24.375 30.5707    -0.0116419 0.0880479 0.996048    0.3125 0.703125
  v -20.625 24.375 30.8615    -0.0770443 0.213047 0.974    0.328125 0.703125
  v -18.75 24.375 30.6898    0.134504 0.17566 0.975219    0.34375 0.703125
  v -16.875 24.375 30.1692    0.13284 0.0496306 0.989894    0.359375 0.703125
  v -15 24.375 30.2113    -0.0823652 -0.0195391 0.996411    0.375 0.703125
  v -13.125 24.375 30.7613    -0.152482 0.0217375 0.988067    0.390625 0.703125
  v -11.25 24.375 30.8779    -0.0553735 0.0404511 0.997646    0.40625 0.703125
  v -9.375 24.375 30.8167    0.030021 -0.00993533 0.9995    0.421875 0.703125
  v -7.5 24.375 30.6543    0.100503 -0.0367499 0.994258    0.4375 0.703125
  v -5.625 24.375 30.4622    0.0805418 0.00616763 0.996732    0.453125 0.703125
  v -3.75 24.375 30.3414    0.0303893 0.06126 0.997659    0.46875 0.703125
  v -1.875 24.375 30.3221    0.0390119 0.0990537 0.994317    0.484375 0.703125
  v -1.23138e-023 24.375 30.1805    -0.0304078 0.0925401 0.995245    0.5 0.703125
  v 1.875 24.375 30.3758    -0.151313 0.0406932 0.987648    0.515625 0.703125
  v 3.75 24.375 30.8135    -0.123306 0.0601833 0.990542    0.53125 0.703125
  v 5.625 24.375 30.9459    0.010912 0.0957076 0.99535    0.546875 0.703125
  v 7.5 24.375 30.6464    0.168908 -0.0311851 0.985138    0.5625 0.703125
  v 9.375 24.375 30.2363    0.197231 -0.115984 0.973472    0.578125 0.703125
  v 11.25 24.375 29.9891    0.0102747 0.0125237 0.999869    0.59375 0.703125
  v 13.125 24.375 30.1214    -0.0946184 0.124238 0.987731    0.609375 0.703125
  v 15 24.375 30.2745    -0.00323412 0.140791 0.990034    0.625 0.703125
  v 16.875 24.375 30.1061    0.108728 0.127835 0.985818    0.640625 0.703125
  v 18.75 24.375 29.8532    0.0506419 0.10977 0.992666    0.65625 0.703125
  v 20.625 24.375 30.0073    -0.165657 0.0773667 0.983144    0.671875 0.703125
  v 22.5 24.375 30.71    -0.249408 0.0892194 0.96428    0.6875 0.703125
  v 24.375 24.375 31.145    -0.104987 0.152482 0.982714    0.703125 0.703125
  v 26.25 24.375 31.0985    0.0173633 0.0925382 0.995558    0.71875 0.703125
  v 28.125 24.375 31.0078    0.104669 -0.101218 0.989343    0.734375 0.703125
  v 30 24.375 30.5604    0.214427 -0.20317 0.955376    0.75 0.703125
  v 31.875 24.375 30.2115    -0.0112249 -0.0154463 0.999818    0.765625 0.703125
  v 33.75 24.375 30.5562    -0.242856 0.14367 0.959364    0.78125 0.703125
  v 35.625 24.375 31.1071    -0.100622 0.0591313 0.993166    0.796875 0.703125
  v 37.5 24.375 31.1679    0.00738725 -0.0149538 0.999861    0.8125 0.703125
  v 39.375 24.375 31.2664    -0.0351427 0.0348744 0.998774    0.828125 0.703125
  v 41.25 24.375 31.1206    0.163844 0.0305528 0.986013    0.84375 0.703125
  v 43.125 24.375 30.5231    0.141828 -0.0110848 0.989829    0.859375 0.703125
  v 45 24.375 30.5502    -0.13521 -0.0893934 0.986776    0.875 0.703125
  v 46.875 24.375 31.2632    -0.15162 -0.0878517 0.984527    0.890625 0.703125
  v 48.75 24.375 31.3672    0.00270359 0.0250393 0.999683    0.90625 0.703125
  v 50.625 24.375 31.2    0.0143017 0.0696822 0.997467    0.921875 0.703125
  v 52.5 24.375 31.0685    0.115567 -0.0754927 0.990427    0.9375 0.703125
  v 54.375 24.375 30.615    0.248542 -0.191887 0.949424    0.953125 0.703125
  v 56.25 24.375 30.0698    0.103098 -0.051475 0.993338    0.96875 0.703125
  v 58.125 24.375 30.1513    -0.121946 0.171199 0.977661    0.984375 0.703125
  v 60 24.375 30.529    -0.138235 0.248055 0.958833    1 0.703125
  v -60 26.25 30.5405    -0.0204058 -0.0255441 0.999465    0 0.71875
  v -58.125 26.25 30.4909    0.0529284 -0.0421316 0.997709    0.015625 0.71875
  v -56.25 26.25 30.3431    0.145332 -0.135784 0.980021    0.03125 0.71875
  v -54.375 26.25 30.1074    -0.0339948 -0.152197 0.987765    0.046875 0.71875
  v -52.5 26.25 30.5432    -0.315738 -0.113214 0.942068    0.0625 0.71875
  v -50.625 26.25 31.4099    -0.158824 -0.122735 0.979648    0.078125 0.71875
  v -48.75 26.25 31.3711    0.162562 -0.0672759 0.984402    0.09375 0.71875
  v -46.875 26.25 30.7613    0.132648 0.0481111 0.989995    0.109375 0.71875
  v -45 26.25 30.7277    -0.0495841 0.086725 0.994998    0.125 0.71875
  v -43.125 26.25 30.976    0.053482 0.0602378 0.99675    0.140625 0.71875
  v -41.25 26.25 30.5781    0.164292 0.0651056 0.984261    0.15625 0.71875
  v -39.375 26.25 30.2248    -0.0591129 0.051672 0.996913    0.171875 0.71875
  v -37.5 26.25 30.7505    -0.228419 0.0103084 0.973508    0.1875 0.71875
  v -35.625 26.25 31.1055    -0.0344964 0.0036396 0.999398    0.203125 0.71875
  v -33.75 26.25 30.7311    0.115269 -0.0173735 0.993182    0.21875 0.71875
  v -31.875 26.25 30.5947    -0.0224723 -0.0630891 0.997755    0.234375 0.71875
  v -30 26.25 31.0057    -0.0784925 -0.0517989 0.995568    0.25 0.71875
  v -28.125 26.25 31.1509    -0.0153503 0.0629435 0.997899    0.265625 0.71875
  v -26.25 26.25 30.9476    0.0527105 0.0818123 0.995253    0.28125 0.71875
  v -24.375 26.25 30.7007    0.122704 -0.0463767 0.991359    0.296875 0.71875
  v -22.5 26.25 30.4574    0.0953724 -0.0885811 0.991493    0.3125 0.71875
  v -20.625 26.25 30.3739    -0.0288597 -0.00292572 0.999579    0.328125 0.71875
  v -18.75 26.25 30.4234    0.011619 -0.0313076 0.999442    0.34375 0.71875
  v -16.875 26.25 30.3518    0.0175997 -0.157505 0.987361    0.359375 0.71875
  v -15 26.25 30.4989    -0.0457887 -0.202074 0.978299    0.375 0.71875
  v -13.125 26.25 30.6214    -0.0380415 -0.0891887 0.995288    0.390625 0.71875
  v -11.25 26.25 30.5767    -0.0355377 0.050187 0.998107    0.40625 0.71875
  v -9.375 26.25 30.8328    -0.0475125 0.0922176 0.994605    0.421875 0.71875
  v -7.5 26.25 30.9207    0.0478239 0.0256389 0.998527    0.4375 0.71875
  v -5.625 26.25 30.641    0.0788927 -0.0718266 0.994292    0.453125 0.71875
  v -3.75 26.25 30.439    0.0588387 -0.140096 0.988388    0.46875 0.71875
  v -1.875 26.25 30.3534    0.0886993 -0.110155 0.989949    0.484375 0.71875
  v -1.23138e-023 26.25 30.1877    -0.0309622 -0.0158423 0.999395    0.5 0.71875
  v 1.875 26.25 30.5687    -0.182966 0.0131095 0.983032    0.515625 0.71875
  v 3.75 26.25 30.9663    -0.059749 0.0213826 0.997984    0.53125 0.71875
  v 5.625 26.25 30.8129    0.00566166 0.0818458 0.996629    0.546875 0.71875
  v 7.5 26.25 30.8177    -0.0186423 -0.0037009 0.999819    0.5625 0.71875
  v 9.375 26.25 30.8371    0.112848 -0.218254 0.969345    0.578125 0.71875
  v 11.25 26.25 30.3463    0.115354 -0.299298 0.947161    0.59375 0.71875
  v 13.125 26.25 30.2606    -0.0287624 -0.251936 0.967316    0.609375 0.71875
  v 15 26.25 30.4208    -0.00591415 -0.209895 0.977706    0.625 0.71875
  v 16.875 26.25 30.3158    0.090319 -0.205319 0.974519    0.640625 0.71875
  v 18.75 26.25 30.093    0.0651022 -0.209793 0.975576    0.65625 0.71875
  v 20.625 26.25 30.1049    -0.12296 -0.161884 0.979119    0.671875 0.71875
  v 22.5 26.25 30.5651    -0.150113 -0.0705585 0.986148    0.6875 0.71875
  v 24.375 26.25 30.6641    -0.0261225 0.0480213 0.998505    0.703125 0.71875
  v 26.25 26.25 30.5909    -0.0796314 0.0924965 0.992524    0.71875 0.71875
  v 28.125 26.25 30.9256    -0.133934 -0.0216147 0.990755    0.734375 0.71875
  v 30 26.25 31.1453    0.135855 -0.2275 0.964255    0.75 0.71875
  v 31.875 26.25 30.5711    0.176296 -0.242513 0.953995    0.765625 0.71875
  v 33.75 26.25 30.4376    -0.118357 -0.0772124 0.989965    0.78125 0.71875
  v 35.625 26.25 31.0002    -0.121084 0.0594059 0.990863    0.796875 0.71875
  v 37.5 26.25 31.0024    0.0289535 0.113029 0.99317    0.8125 0.71875
  v 39.375 26.25 30.8564    -0.0258524 0.131817 0.990937    0.828125 0.71875
  v 41.25 26.25 30.9408    0.0986512 0.064297 0.993043    0.84375 0.71875
  v 43.125 26.25 30.5321    0.105016 0.0157152 0.994346    0.859375 0.71875
  v 45 26.25 30.6699    -0.12923 0.0437459 0.990649    0.875 0.71875
  v 46.875 26.25 31.1721    -0.0524688 0.135949 0.989325    0.890625 0.71875
  v 48.75 26.25 30.8379    0.110577 0.229953 0.966899    0.90625 0.71875
  v 50.625 26.25 30.5456    -0.0473006 0.243627 0.968715    0.921875 0.71875
  v 52.5 26.25 30.909    -0.124459 0.0991517 0.987258    0.9375 0.71875
  v 54.375 26.25 31.0651    0.103954 -0.14942 0.983294    0.953125 0.71875
  v 56.25 26.25 30.5487    0.217443 -0.278855 0.935392    0.96875 0.71875
  v 58.125 26.25 30.1881    0.0574615 -0.207361 0.976575    0.984375 0.71875
  v 60 26.25 30.2232    -0.0787495 -0.0447226 0.995891    1 0.71875
  v -60 28.125 30.6468    -0.171967 -0.0677302 0.982772    0 0.734375
  v -58.125 28.125 30.8591    -0.0476649 -0.177166 0.983026    0.015625 0.734375
  v -56.25 28.125 30.8331    0.0953847 -0.267394 0.958855    0.03125 0.734375
  v -54.375 28.125 30.4844    0.0507265 -0.232081 0.971373    0.046875 0.734375
  v -52.5 28.125 30.7771    -0.204586 -0.0369242 0.978152    0.0625 0.734375
  v -50.625 28.125 31.5232    -0.134198 0.133644 0.981901    0.078125 0.734375
  v -48.75 28.125 31.2308    0.179685 0.10124 0.978501    0.09375 0.734375
  v -46.875 28.125 30.4951    0.185792 0.00929071 0.982545    0.109375 0.734375
  v -45 28.125 30.4253    -0.00760177 0.0421177 0.999084    0.125 0.734375
  v -43.125 28.125 30.633    0.0431535 0.112879 0.992671    0.140625 0.734375
  v -41.25 28.125 30.2331    0.155474 0.113274 0.981324    0.15625 0.734375
  v -39.375 28.125 30.0542    -0.0940309 0.106007 0.989909    0.171875 0.734375
  v -37.5 28.125 30.7109    -0.275737 0.082063 0.957724    0.1875 0.734375
  v -35.625 28.125 31.1538    -0.0971751 0.0202699 0.995061    0.203125 0.734375
  v -33.75 28.125 31.0209    0.0395169 -0.0930622 0.994876    0.21875 0.734375
  v -31.875 28.125 31.0252    -0.0300033 -0.173384 0.984397    0.234375 0.734375
  v -30 28.125 31.1628    0.0410515 -0.135077 0.989984    0.25 0.734375
  v -28.125 28.125 30.8284    0.100986 0.00790571 0.994856    0.265625 0.734375
  v -26.25 28.125 30.6506    -0.0318081 0.0533838 0.998067    0.28125 0.734375
  v -24.375 28.125 30.9294    -0.0293131 -0.0541233 0.998104    0.296875 0.734375
  v -22.5 28.125 30.9486    0.102521 -0.111961 0.98841    0.3125 0.734375
  v -20.625 28.125 30.7222    0.015746 -0.0599486 0.998077    0.328125 0.734375
  v -18.75 28.125 30.8324    -0.0752029 -0.0912537 0.992984    0.34375 0.734375
  v -16.875 28.125 30.9194    -0.0706938 -0.196481 0.977956    0.359375 0.734375
  v -15 28.125 31.0859    -0.00640964 -0.228645 0.973489    0.375 0.734375
  v -13.125 28.125 31.0286    0.0999761 -0.129751 0.986494    0.390625 0.734375
  v -11.25 28.125 30.7637    0.112321 0.0134764 0.993581    0.40625 0.734375
  v -9.375 28.125 30.6299    -0.00143747 0.128946 0.991651    0.421875 0.734375
  v -7.5 28.125 30.5453    -0.0148443 0.123763 0.992201    0.4375 0.734375
  v -5.625 28.125 30.5511    -0.0497373 0.0435056 0.997814    0.453125 0.734375
  v -3.75 28.125 30.8117    -0.0541629 -0.0896276 0.994502    0.46875 0.734375
  v -1.875 28.125 30.8385    0.139311 -0.175688 0.974539    0.484375 0.734375
  v -1.23138e-023 28.125 30.3341    0.12224 -0.0716131 0.989914    0.5 0.734375
  v 1.875 28.125 30.4047    -0.125668 0.0998501 0.987035    0.515625 0.734375
  v 3.75 28.125 30.7485    -0.0336885 0.155504 0.987261    0.53125 0.734375
  v 5.625 28.125 30.5101    0.0231726 0.166051 0.985845    0.546875 0.734375
  v 7.5 28.125 30.61    -0.153191 0.129669 0.979652    0.5625 0.734375
  v 9.375 28.125 31.0805    -0.116445 -0.0239268 0.992909    0.578125 0.734375
  v 11.25 28.125 31.0693    0.016547 -0.232152 0.972539    0.59375 0.734375
  v 13.125 28.125 31.0855    0.0186617 -0.300471 0.953608    0.609375 0.734375
  v 15 28.125 31.1314    0.0610186 -0.212591 0.975234    0.625 0.734375
  v 16.875 28.125 30.9264    0.0788844 -0.1531 0.985057    0.640625 0.734375
  v 18.75 28.125 30.7057    0.0442079 -0.224747 0.973414    0.65625 0.734375
  v 20.625 28.125 30.6295    -0.0592486 -0.26063 0.963619    0.671875 0.734375
  v 22.5 28.125 30.9556    -0.0599204 -0.19288 0.979391    0.6875 0.734375
  v 24.375 28.125 30.878    0.0470446 -0.127045 0.990781    0.703125 0.734375
  v 26.25 28.125 30.7007    -0.065603 -0.0932057 0.993483    0.71875 0.734375
  v 28.125 28.125 31.1326    -0.216202 -0.0585241 0.974593    0.734375 0.734375
  v 30 28.125 31.6498    -0.014639 -0.10651 0.994204    0.75 0.734375
  v 31.875 28.125 31.1658    0.186877 -0.232827 0.954394    0.765625 0.734375
  v 33.75 28.125 30.8219    0.0544185 -0.242252 0.968686    0.78125 0.734375
  v 35.625 28.125 30.9784    0.0211975 -0.0795489 0.996606    0.796875 0.734375
  v 37.5 28.125 30.7065    0.0659246 0.0482091 0.996659    0.8125 0.734375
  v 39.375 28.125 30.6041    -0.0481917 0.0526984 0.997447    0.828125 0.734375
  v 41.25 28.125 30.9272    0.0281499 0.0245643 0.999302    0.84375 0.734375
  v 43.125 28.125 30.5976    0.106953 -0.00653198 0.994243    0.859375 0.734375
  v 45 28.125 30.5223    -0.0444309 0.0139759 0.998915    0.875 0.734375
  v 46.875 28.125 30.7058    0.0353437 0.0908677 0.995236    0.890625 0.734375
  v 48.75 28.125 30.2734    0.125655 0.114523 0.985442    0.90625 0.734375
  v 50.625 28.125 30.1366    -0.0736171 0.0985288 0.992407    0.921875 0.734375
  v 52.5 28.125 30.7218    -0.220472 0.146574 0.964317    0.9375 0.734375
  v 54.375 28.125 31.2534    -0.115023 0.124653 0.985511    0.953125 0.734375
  v 56.25 28.125 31.1847    0.0814181 -0.0943856 0.992201    0.96875 0.734375
  v 58.125 28.125 30.8666    0.0728721 -0.289998 0.954249    0.984375 0.734375
  v 60 28.125 30.7488    0.0329449 -0.334738 0.941735    1 0.734375
  v -60 30 30.6085    -0.245595 0.092608 0.964939    0 0.75
  v -58.125 30 31.1751    -0.196846 0.0225847 0.980174    0.015625 0.75
  v -56.25 30 31.3938    -0.0126043 -0.132404 0.991116    0.03125 0.75
  v -54.375 30 31.1612    0.170249 -0.207608 0.963283    0.046875 0.75
  v -52.5 30 30.8931    0.106591 0.00092608 0.994303    0.0625 0.75
  v -50.625 30 30.7998    -0.0342131 0.282282 0.958721    0.078125 0.75
  v -48.75 30 30.6543    -0.0129223 0.210077 0.977599    0.09375 0.75
  v -46.875 30 30.6467    0.0368401 -0.0849557 0.995703    0.109375 0.75
  v -45 30 30.6781    0.062866 -0.176469 0.982297    0.125 0.75
  v -43.125 30 30.5221    0.0996997 -0.0832461 0.991529    0.140625 0.75
  v -41.25 30 30.1602    0.163405 -0.0622032 0.984596    0.15625 0.75
  v -39.375 30 29.9272    -0.0662368 -0.0368396 0.997124    0.171875 0.75
  v -37.5 30 30.4448    -0.258468 0.0345588 0.965402    0.1875 0.75
  v -35.625 30 30.9665    -0.142847 0.0977286 0.984908    0.203125 0.75
  v -33.75 30 31.1059    -0.063558 0.0838907 0.994446    0.21875 0.75
  v -31.875 30 31.2842    -0.108575 -0.00453528 0.994078    0.234375 0.75
  v -30 30 31.4787    0.0740083 -0.0877455 0.99339    0.25 0.75
  v -28.125 30 30.9891    0.193166 -0.0676768 0.978829    0.265625 0.75
  v -26.25 30 30.726    -0.023055 -0.00811064 0.999701    0.28125 0.75
  v -24.375 30 31.0892    -0.0703831 0.0196985 0.997326    0.296875 0.75
  v -22.5 30 31.0735    0.155224 0.064318 0.985783    0.3125 0.75
  v -20.625 30 30.55    0.0665359 0.156432 0.985445    0.328125 0.75
  v -18.75 30 30.6818    -0.166144 0.12991 0.977507    0.34375 0.75
  v -16.875 30 31.0925    -0.19275 -0.00299026 0.981243    0.359375 0.75
  v -15 30 31.4678    0.0165793 -0.0781722 0.996802    0.375 0.75
  v -13.125 30 31.181    0.233094 0.00585279 0.972437    0.390625 0.75
  v -11.25 30 30.549    0.225435 0.112296 0.967765    0.40625 0.75
  v -9.375 30 30.1142    -0.0128575 0.113562 0.993448    0.421875 0.75
  v -7.5 30 30.3155    -0.0827931 -0.00435769 0.996557    0.4375 0.75
  v -5.625 30 30.5558    -0.0792874 -0.0075565 0.996823    0.453125 0.75
  v -3.75 30 30.8636    -0.14683 0.0451134 0.988132    0.46875 0.75
  v -1.875 30 31.0982    0.0704907 -0.0497178 0.996273    0.484375 0.75
  v -1.23138e-023 30 30.5034    0.234817 -0.135938 0.962487    0.5 0.75
  v 1.875 30 30.1214    0.00669807 -0.0602469 0.998161    0.515625 0.75
  v 3.75 30 30.3505    -0.00966875 0.0151418 0.999839    0.53125 0.75
  v 5.625 30 30.1307    0.0126969 0.0241473 0.999628    0.546875 0.75
  v 7.5 30 30.2959    -0.172118 0.0359186 0.984421    0.5625 0.75
  v 9.375 30 30.9369    -0.210739 0.103413 0.972057    0.578125 0.75
  v 11.25 30 31.334    -0.137625 0.09791 0.985633    0.59375 0.75
  v 13.125 30 31.5913    0.00559846 0.00241028 0.999981    0.609375 0.75
  v 15 30 31.3317    0.167766 -0.0108179 0.985768    0.625 0.75
  v 16.875 30 30.7941    0.0807206 0.0303936 0.996273    0.640625 0.75
  v 18.75 30 30.8436    -0.0634525 -0.0181371 0.99782    0.65625 0.75
  v 20.625 30 31.1394    -0.0580075 -0.06321 0.996313    0.671875 0.75
  v 22.5 30 31.319    0.0134509 0.00682485 0.999886    0.6875 0.75
  v 24.375 30 31.069    0.0669466 0.047725 0.996615    0.703125 0.75
  v 26.25 30 30.945    -0.03928 0.0278844 0.998839    0.71875 0.75
  v 28.125 30 31.2656    -0.129609 0.0890039 0.987563    0.734375 0.75
  v 30 30 31.5337    -0.0760793 0.190767 0.978683    0.75 0.75
  v 31.875 30 31.4071    0.023645 0.0765029 0.996789    0.765625 0.75
  v 33.75 30 31.4105    0.0505597 -0.110497 0.99259    0.78125 0.75
  v 35.625 30 31.2653    0.159627 -0.120851 0.979752    0.796875 0.75
  v 37.5 30 30.6941    0.113872 -0.0489534 0.992289    0.8125 0.75
  v 39.375 30 30.6951    -0.0492305 -0.0482443 0.997622    0.828125 0.75
  v 41.25 30 30.9475    0.0344726 -0.0220478 0.999162    0.84375 0.75
  v 43.125 30 30.5581    0.0830916 -0.00864797 0.996504    0.859375 0.75
  v 45 30 30.558    -0.0367946 -0.0492594 0.998108    0.875 0.75
  v 46.875 30 30.7056    0.0593297 -0.0617118 0.996329    0.890625 0.75
  v 48.75 30 30.3032    0.0868857 -0.0863566 0.992468    0.90625 0.75
  v 50.625 30 30.3262    -0.0304107 -0.118803 0.992452    0.921875 0.75
  v 52.5 30 30.5792    -0.0344758 0.0469928 0.9983    0.9375 0.75
  v 54.375 30 30.5828    -0.109692 0.288728 0.951106    0.953125 0.75
  v 56.25 30 30.852    -0.165867 0.236325 0.957413    0.96875 0.75
  v 58.125 30 31.1903    -0.145206 -0.0085285 0.989365    0.984375 0.75
  v 60 30 31.5508    -0.107681 -0.202595 0.973324    1 0.75
  v -60 31.875 30.4858    -0.0728434 0.00288375 0.997339    0 0.765625
  v -58.125 31.875 30.7908    -0.209449 0.144837 0.967033    0.015625 0.765625
  v -56.25 31.875 31.2852    -0.149381 0.159357 0.975854    0.03125 0.765625
  v -54.375 31.875 31.469    0.141006 0.0546574 0.988499    0.046875 0.765625
  v -52.5 31.875 30.8204    0.318593 0.0374128 0.947153    0.0625 0.765625
  v -50.625 31.875 30.0033    0.0840428 0.148835 0.985284    0.078125 0.765625
  v -48.75 31.875 30.1972    -0.216184 0.134288 0.967074    0.09375 0.765625
  v -46.875 31.875 30.9848    -0.199381 -0.0327238 0.979376    0.109375 0.765625
  v -45 31.875 31.2243    0.0535256 -0.154065 0.98661    0.125 0.765625
  v -43.125 31.875 30.8115    0.162983 -0.147169 0.975591    0.140625 0.765625
  v -41.25 31.875 30.5    0.149632 -0.14847 0.977531    0.15625 0.765625
  v -39.375 31.875 30.2211    -0.0321823 -0.164919 0.985782    0.171875 0.765625
  v -37.5 31.875 30.6047    -0.178668 -0.132233 0.974983    0.1875 0.765625
  v -35.625 31.875 30.891    -0.0575112 -0.0596017 0.996564    0.203125 0.765625
  v -33.75 31.875 30.7794    -0.0424869 0.0302672 0.998638    0.21875 0.765625
  v -31.875 31.875 30.9989    -0.162918 0.0789611 0.983475    0.234375 0.765625
  v -30 31.875 31.4871    0.0195287 0.0767291 0.996861    0.25 0.765625
  v -28.125 31.875 31.079    0.215748 0.0677843 0.974093    0.265625 0.765625
  v -26.25 31.875 30.6922    0.0120352 0.073337 0.997235    0.28125 0.765625
  v -24.375 31.875 30.9355    -0.0548431 0.0500861 0.997238    0.296875 0.765625
  v -22.5 31.875 30.7623    0.216952 0.0264616 0.975824    0.3125 0.765625
  v -20.625 31.875 29.9884    0.121569 0.0681223 0.990243    0.328125 0.765625
  v -18.75 31.875 30.2197    -0.237909 0.0919703 0.966923    0.34375 0.765625
  v -16.875 31.875 30.975    -0.305684 0.029305 0.951682    0.359375 0.765625
  v -15 31.875 31.5352    0.00593995 -0.0413899 0.999125    0.375 0.765625
  v -13.125 31.875 30.9948    0.325618 -0.021602 0.945254    0.390625 0.765625
  v -11.25 31.875 30.1411    0.264285 0.0418213 0.963537    0.40625 0.765625
  v -9.375 31.875 29.903    -0.11579 0.0488871 0.99207    0.421875 0.765625
  v -7.5 31.875 30.6889    -0.194013 -0.0738004 0.978219    0.4375 0.765625
  v -5.625 31.875 30.8282    0.00454797 -0.126777 0.991921    0.453125 0.765625
  v -3.75 31.875 30.624    -0.0750873 -0.0334904 0.996614    0.46875 0.765625
  v -1.875 31.875 30.9515    -0.0535605 -0.0129398 0.998481    0.484375 0.765625
  v -1.23138e-023 31.875 30.8053    0.148943 -0.12983 0.980286    0.5 0.765625
  v 1.875 31.875 30.51    0.0587773 -0.179423 0.982015    0.515625 0.765625
  v 3.75 31.875 30.6605    0.0250328 -0.140451 0.989771    0.53125 0.765625
  v 5.625 31.875 30.4105    0.00843732 -0.11874 0.99289    0.546875 0.765625
  v 7.5 31.875 30.6119    -0.101544 -0.102589 0.989527    0.5625 0.765625
  v 9.375 31.875 30.8926    -0.0517131 0.0343696 0.99807    0.578125 0.765625
  v 11.25 31.875 30.8135    -0.0860287 0.21531 0.972749    0.59375 0.765625
  v 13.125 31.875 31.0957    -0.0870522 0.226995 0.969998    0.609375 0.765625
  v 15 31.875 31.0198    0.0900425 0.0774976 0.992918    0.625 0.765625
  v 16.875 31.875 30.639    0.046676 -0.0612281 0.997032    0.640625 0.765625
  v 18.75 31.875 30.8803    -0.0817219 -0.083362 0.993163    0.65625 0.765625
  v 20.625 31.875 31.1284    0.0157462 -0.0016825 0.999875    0.671875 0.765625
  v 22.5 31.875 30.9097    0.113588 0.131023 0.984851    0.6875 0.765625
  v 24.375 31.875 30.5708    0.0557551 0.17839 0.982379    0.703125 0.765625
  v 26.25 31.875 30.639    -0.0637264 0.140546 0.988021    0.71875 0.765625
  v 28.125 31.875 30.8754    -0.0125736 0.16088 0.986894    0.734375 0.765625
  v 30 31.875 30.7454    0.00132394 0.293619 0.955922    0.75 0.765625
  v 31.875 31.875 30.827    -0.126186 0.324646 0.937381    0.765625 0.765625
  v 33.75 31.875 31.3074    -0.119109 0.193662 0.973811    0.78125 0.765625
  v 35.625 31.875 31.3454    0.127424 0.0378389 0.991126    0.796875 0.765625
  v 37.5 31.875 30.7658    0.117117 -0.0452074 0.992089    0.8125 0.765625
  v 39.375 31.875 30.8531    -0.052597 -0.0732548 0.995925    0.828125 0.765625
  v 41.25 31.875 31.0064    0.0721512 -0.0519542 0.99604    0.84375 0.765625
  v 43.125 31.875 30.5566    0.0901016 -0.00379207 0.995925    0.859375 0.765625
  v 45 31.875 30.7166    -0.0653924 0.0278066 0.997472    0.875 0.765625
  v 46.875 31.875 30.9134    0.040294 0.0281352 0.998792    0.890625 0.765625
  v 48.75 31.875 30.5529    0.0306821 -0.0127337 0.999448    0.90625 0.765625
  v 50.625 31.875 30.7494    -0.0358291 -0.0956099 0.994774    0.921875 0.765625
  v 52.5 31.875 30.6782    0.161918 -0.105297 0.98117    0.9375 0.765625
  v 54.375 31.875 29.9369    0.0603049 0.0166268 0.998042    0.953125 0.765625
  v 56.25 31.875 30.1822    -0.268265 0.0920023 0.958942    0.96875 0.765625
  v 58.125 31.875 31.0451    -0.283058 0.0633985 0.957005    0.984375 0.765625
  v 60 31.875 31.6216    -0.258833 0.0480299 0.964727    1 0.765625
  v -60 33.75 30.7917    0.140712 -0.179742 0.973598    0 0.78125
  v -58.125 33.75 30.5918    -0.00638965 -0.000284716 0.999979    0.015625 0.78125
  v -56.25 33.75 30.8765    -0.107833 0.22199 0.969068    0.03125 0.78125
  v -54.375 33.75 31.0378    0.0292577 0.240662 0.970168    0.046875 0.78125
  v -52.5 33.75 30.5509    0.23474 0.0512317 0.970707    0.0625 0.78125
  v -50.625 33.75 29.9377    0.096983 -0.116932 0.988393    0.078125 0.78125
  v -48.75 33.75 30.2513    -0.218429 -0.0993897 0.970778    0.09375 0.78125
  v -46.875 33.75 31.0002    -0.267055 -0.0130822 0.963592    0.109375 0.78125
  v -45 33.75 31.3047    -0.0147822 -0.0368798 0.99921    0.125 0.78125
  v -43.125 33.75 30.9956    0.169173 -0.0964129 0.980859    0.140625 0.78125
  v -41.25 33.75 30.7147    0.134702 -0.0890053 0.986881    0.15625 0.78125
  v -39.375 33.75 30.5334    -0.0334558 -0.072856 0.996781    0.171875 0.78125
  v -37.5 33.75 30.9347    -0.16822 -0.0625229 0.983765    0.1875 0.78125
  v -35.625 33.75 31.1434    -0.0306672 -0.0949615 0.995008    0.203125 0.78125
  v -33.75 33.75 30.9368    0.0226654 -0.107866 0.993907    0.21875 0.78125
  v -31.875 33.75 31.0642    -0.0993854 -0.0464971 0.993962    0.234375 0.78125
  v -30 33.75 31.3429    0.0581997 0.0304862 0.997839    0.25 0.78125
  v -28.125 33.75 30.762    0.259943 0.0970256 0.960737    0.265625 0.78125
  v -26.25 33.75 30.3494    0.0186656 0.18061 0.983378    0.28125 0.78125
  v -24.375 33.75 30.7627    -0.167132 0.143978 0.975365    0.296875 0.78125
  v -22.5 33.75 30.8827    0.119962 -0.0507189 0.991482    0.3125 0.78125
  v -20.625 33.75 30.2264    0.163351 -0.154766 0.974353    0.328125 0.78125
  v -18.75 33.75 30.3722    -0.200847 -0.0735663 0.976856    0.34375 0.78125
  v -16.875 33.75 31.0774    -0.321201 0.00335373 0.947005    0.359375 0.78125
  v -15 33.75 31.666    -0.0340192 0.0106809 0.999364    0.375 0.78125
  v -13.125 33.75 31.1818    0.320789 -0.0391595 0.946341    0.390625 0.78125
  v -11.25 33.75 30.339    0.293704 -0.0796143 0.952575    0.40625 0.78125
  v -9.375 33.75 30.0115    -0.100257 -0.0571761 0.993317    0.421875 0.78125
  v -7.5 33.75 30.7534    -0.272086 -0.0414069 0.961382    0.4375 0.78125
  v -5.625 33.75 30.9876    -0.0244122 -0.112474 0.993355    0.453125 0.78125
  v -3.75 33.75 30.8276    -0.0140813 -0.135928 0.990619    0.46875 0.78125
  v -1.875 33.75 31.1255    -0.0907164 -0.105372 0.990287    0.484375 0.78125
  v -1.23138e-023 33.75 31.1363    0.0897804 -0.128995 0.987573    0.5 0.78125
  v 1.875 33.75 30.8905    0.114936 -0.0793052 0.990202    0.515625 0.78125
  v 3.75 33.75 30.8786    0.0711367 0.0292045 0.997039    0.53125 0.78125
  v 5.625 33.75 30.5641    0.00470781 0.0384063 0.999251    0.546875 0.78125
  v 7.5 33.75 30.7821    -0.06128 0.0138535 0.998025    0.5625 0.78125
  v 9.375 33.75 30.8095    0.0783704 0.0527657 0.995527    0.578125 0.78125
  v 11.25 33.75 30.3637    0.0329038 0.12506 0.991603    0.59375 0.78125
  v 13.125 33.75 30.5731    -0.145635 0.179989 0.972828    0.609375 0.78125
  v 15 33.75 30.9283    -0.111389 0.106871 0.988014    0.625 0.78125
  v 16.875 33.75 31.0677    -0.0907793 -0.0865975 0.992099    0.640625 0.78125
  v 18.75 33.75 31.3451    -0.0498733 -0.19806 0.97892    0.65625 0.78125
  v 20.625 33.75 31.2404    0.154658 -0.136873 0.978441    0.671875 0.78125
  v 22.5 33.75 30.6926    0.220758 0.00340911 0.975323    0.6875 0.78125
  v 24.375 33.75 30.3304    0.0540446 0.0615153 0.996642    0.703125 0.78125
  v 26.25 33.75 30.4724    -0.0992534 0.0433921 0.994116    0.71875 0.78125
  v 28.125 33.75 30.7122    0.044095 0.0319715 0.998516    0.734375 0.78125
  v 30 33.75 30.3214    0.13933 0.102693 0.984907    0.75 0.78125
  v 31.875 33.75 30.1585    -0.0962028 0.215175 0.971825    0.765625 0.78125
  v 33.75 33.75 30.6938    -0.22838 0.252585 0.940236    0.78125 0.78125
  v 35.625 33.75 31.0742    -0.0475777 0.147898 0.987858    0.796875 0.78125
  v 37.5 33.75 30.8294    0.0270723 -0.0449852 0.998621    0.8125 0.78125
  v 39.375 33.75 31.0134    -0.0460082 -0.101942 0.993726    0.828125 0.78125
  v 41.25 33.75 31.1257    0.107161 -0.0434466 0.993292    0.84375 0.78125
  v 43.125 33.75 30.6281    0.164147 0.0149346 0.986323    0.859375 0.78125
  v 45 33.75 30.5625    -0.00734113 0.103714 0.99458    0.875 0.78125
  v 46.875 33.75 30.5884    0.0455435 0.150043 0.98763    0.890625 0.78125
  v 48.75 33.75 30.3047    -0.000718155 0.153788 0.988104    0.90625 0.78125
  v 50.625 33.75 30.6811    -0.144902 0.116431 0.982572    0.921875 0.78125
  v 52.5 33.75 30.8105    0.0514367 -0.0587722 0.996945    0.9375 0.78125
  v 54.375 33.75 30.2625    0.0941177 -0.244842 0.964984    0.953125 0.78125
  v 56.25 33.75 30.5207    -0.194874 -0.201329 0.959943    0.96875 0.78125
  v 58.125 33.75 31.2345    -0.210974 -0.047394 0.976342    0.984375 0.78125
  v 60 33.75 31.4107    -0.160981 0.0473148 0.985823    1 0.78125
  v -60 35.625 31.2697    0.193285 -0.10303 0.975718    0 0.796875
  v -58.125 35.625 30.8512    0.220965 -0.0914143 0.970988    0.015625 0.796875
  v -56.25 35.625 30.4482    0.0785995 0.103333 0.991536    0.03125 0.796875
  v -54.375 35.625 30.3194    -0.066565 0.164363 0.984151    0.046875 0.796875
  v -52.5 35.625 30.4501    -0.0232257 -0.0211227 0.999507    0.0625 0.796875
  v -50.625 35.625 30.5405    0.0017674 -0.194984 0.980805    0.078125 0.796875
  v -48.75 35.625 30.7928    -0.0975846 -0.143566 0.984818    0.09375 0.796875
  v -46.875 35.625 31.0352    -0.164474 0.0349282 0.985763    0.109375 0.796875
  v -45 35.625 31.3043    -0.0587652 0.106315 0.992594    0.125 0.796875
  v -43.125 35.625 31.2377    0.127213 0.0591683 0.990109    0.140625 0.796875
  v -41.25 35.625 30.8888    0.145121 0.0233523 0.989138    0.15625 0.796875
  v -39.375 35.625 30.5877    0.00260123 0.00367147 0.99999    0.171875 0.796875
  v -37.5 35.625 30.8131    -0.150635 0.0408884 0.987743    0.1875 0.796875
  v -35.625 35.625 31.1371    -0.0786607 0.0668475 0.994658    0.203125 0.796875
  v -33.75 35.625 31.194    0.015927 0.0441741 0.998897    0.21875 0.796875
  v -31.875 35.625 31.2047    -0.0623078 0.036949 0.997373    0.234375 0.796875
  v -30 35.625 31.2992    0.0734028 -0.0015939 0.997301    0.25 0.796875
  v -28.125 35.625 30.7247    0.324468 -0.0377577 0.945143    0.265625 0.796875
  v -26.25 35.625 30.0712    0.135 0.0681049 0.988502    0.28125 0.796875
  v -24.375 35.625 30.2502    -0.241958 0.176117 0.954169    0.296875 0.796875
  v -22.5 35.625 30.9021    -0.105262 0.0468072 0.993342    0.3125 0.796875
  v -20.625 35.625 30.729    0.135575 -0.131668 0.981979    0.328125 0.796875
  v -18.75 35.625 30.5659    -0.0806931 -0.0937232 0.992323    0.34375 0.796875
  v -16.875 35.625 30.9826    -0.242719 0.0236932 0.969807    0.359375 0.796875
  v -15 35.625 31.4636    -0.0384582 0.0978152 0.994461    0.375 0.796875
  v -13.125 35.625 31.1045    0.255532 0.0735152 0.964001    0.390625 0.796875
  v -11.25 35.625 30.4615    0.257817 -0.00338142 0.966188    0.40625 0.796875
  v -9.375 35.625 30.1269    -0.0715201 -0.0354539 0.996809    0.421875 0.796875
  v -7.5 35.625 30.7497    -0.288775 -0.0066936 0.957374    0.4375 0.796875
  v -5.625 35.625 31.2368    -0.0808043 -0.0121089 0.996656    0.453125 0.796875
  v -3.75 35.625 31.2235    0.0101023 -0.000379829 0.999949    0.46875 0.796875
  v -1.875 35.625 31.3141    -0.0926561 0.0296555 0.995256    0.484375 0.796875
  v -1.23138e-023 35.625 31.4045    0.0781276 -0.0318357 0.996435    0.5 0.796875
  v 1.875 35.625 30.9905    0.239237 -0.0181555 0.970791    0.515625 0.796875
  v 3.75 35.625 30.4904    0.151511 0.102428 0.983134    0.53125 0.796875
  v 5.625 35.625 30.1824    -0.0394945 0.0918744 0.994987    0.546875 0.796875
  v 7.5 35.625 30.5744    -0.0931372 0.0161879 0.995522    0.5625 0.796875
  v 9.375 35.625 30.5743    0.0710867 -0.0207716 0.997254    0.578125 0.796875
  v 11.25 35.625 30.2302    0.0573081 -0.0676511 0.996062    0.59375 0.796875
  v 13.125 35.625 30.3995    -0.0755425 -0.0171145 0.996996    0.609375 0.796875
  v 15 35.625 30.6751    -0.145198 0.120905 0.981988    0.625 0.796875
  v 16.875 35.625 31.0447    -0.23615 0.127904 0.963262    0.640625 0.796875
  v 18.75 35.625 31.6207    -0.140981 0.00724707 0.989986    0.65625 0.796875
  v 20.625 35.625 31.6112    0.206397 -0.07165 0.975842    0.671875 0.796875
  v 22.5 35.625 30.8415    0.310287 -0.0293761 0.950189    0.6875 0.796875
  v 24.375 35.625 30.3252    0.0726747 0.0177618 0.997198    0.703125 0.796875
  v 26.25 35.625 30.4821    -0.125362 0.00676348 0.992088    0.71875 0.796875
  v 28.125 35.625 30.7748    0.00863746 -0.0535219 0.998529    0.734375 0.796875
  v 30 35.625 30.3299    0.176051 -0.139593 0.974433    0.75 0.796875
  v 31.875 35.625 29.9758    0.0149426 -0.130686 0.991311    0.765625 0.796875
  v 33.75 35.625 30.2986    -0.162182 0.0184491 0.986588    0.78125 0.796875
  v 35.625 35.625 30.724    -0.166369 0.139848 0.976096    0.796875 0.796875
  v 37.5 35.625 30.9802    -0.142894 0.0429631 0.988805    0.8125 0.796875
  v 39.375 35.625 31.363    -0.0417374 -0.0766295 0.996186    0.828125 0.796875
  v 41.25 35.625 31.2017    0.181421 -0.0483845 0.982215    0.84375 0.796875
  v 43.125 35.625 30.566    0.218186 -0.0136353 0.975812    0.859375 0.796875
  v 45 35.625 30.2568    0.0343033 -0.0119858 0.99934    0.875 0.796875
  v 46.875 35.625 30.2592    0.0524659 -0.0355481 0.99799    0.890625 0.796875
  v 48.75 35.625 30.0558    0.0473696 -0.00790574 0.998846    0.90625 0.796875
  v 50.625 35.625 30.2461    -0.188014 0.0876272 0.97825    0.921875 0.796875
  v 52.5 35.625 30.7128    -0.185327 0.0202301 0.982469    0.9375 0.796875
  v 54.375 35.625 30.9827    -0.0163167 -0.155471 0.987706    0.953125 0.796875
  v 56.25 35.625 31.1737    -0.0480564 -0.10605 0.993199    0.96875 0.796875
  v 58.125 35.625 31.2871    -0.07755 0.0447323 0.995984    0.984375 0.796875
  v 60 35.625 31.1568    0.0153041 0.0666287 0.99766    1 0.796875
  v -60 37.5 31.2639    0.0705108 0.056848 0.99589    0 0.8125
  v -58.125 37.5 30.9839    0.249393 -0.058517 0.966633    0.015625 0.8125
  v -56.25 37.5 30.2504    0.183805 -0.0608107 0.98108    0.03125 0.8125
  v -54.375 37.5 30.1392    -0.1257 -0.0416844 0.991192    0.046875 0.8125
  v -52.5 37.5 30.7554    -0.183805 -0.115097 0.976201    0.0625 0.8125
  v -50.625 37.5 31.0595    0.0107625 -0.132847 0.991078    0.078125 0.8125
  v -48.75 37.5 30.9274    0.0690017 0.0137144 0.997522    0.09375 0.8125
  v -46.875 37.5 30.7515    -0.0214563 0.164749 0.986102    0.109375 0.8125
  v -45 37.5 30.8788    -0.0543371 0.209095 0.976385    0.125 0.8125
  v -43.125 37.5 30.8369    0.0651726 0.14893 0.986698    0.140625 0.8125
  v -41.25 37.5 30.5254    0.0726312 0.0497672 0.996116    0.15625 0.8125
  v -39.375 37.5 30.4543    -0.031609 -0.0471467 0.998388    0.171875 0.8125
  v -37.5 37.5 30.7554    -0.0931917 -0.0249701 0.995335    0.1875 0.8125
  v -35.625 37.5 30.9736    -0.0243097 0.0852819 0.99606    0.203125 0.8125
  v -33.75 37.5 30.897    0.0293991 0.154677 0.987528    0.21875 0.8125
  v -31.875 37.5 30.7878    -0.104462 0.143192 0.984167    0.234375 0.8125
  v -30 37.5 31.1599    -0.0516412 0.0233324 0.998393    0.25 0.8125
  v -28.125 37.5 30.9775    0.280499 -0.120798 0.952223    0.265625 0.8125
  v -26.25 37.5 30.1426    0.265173 -0.116508 0.957136    0.28125 0.8125
  v -24.375 37.5 29.933    -0.157894 0.0290399 0.987029    0.296875 0.8125
  v -22.5 37.5 30.7554    -0.241042 0.0869818 0.966609    0.3125 0.8125
  v -20.625 37.5 30.9295    0.0267793 -0.0201809 0.999438    0.328125 0.8125
  v -18.75 37.5 30.6766    -0.0127 -0.0866027 0.996162    0.34375 0.8125
  v -16.875 37.5 30.94    -0.154299 -0.0412209 0.987164    0.359375 0.8125
  v -15 37.5 31.2663    0.00848937 0.0378106 0.999249    0.375 0.8125
  v -13.125 37.5 30.8921    0.229739 0.0760726 0.970275    0.390625 0.8125
  v -11.25 37.5 30.3891    0.210772 0.0684464 0.975136    0.40625 0.8125
  v -9.375 37.5 30.1465    -0.079906 0.0579745 0.995115    0.421875 0.8125
  v -7.5 37.5 30.7554    -0.262913 0.0673982 0.962463    0.4375 0.8125
  v -5.625 37.5 31.1972    -0.0350862 0.111613 0.993132    0.453125 0.8125
  v -3.75 37.5 30.9435    0.0853294 0.203858 0.975275    0.46875 0.8125
  v -1.875 37.5 30.8366    -0.121375 0.244588 0.962    0.484375 0.8125
  v -1.23138e-023 37.5 31.2318    -0.0648724 0.088618 0.993951    0.5 0.8125
  v 1.875 37.5 30.9739    0.2404 -0.093671 0.966144    0.515625 0.8125
  v 3.75 37.5 30.261    0.184383 -0.120776 0.975406    0.53125 0.8125
  v 5.625 37.5 30.1458    -0.0924437 -0.139191 0.985941    0.546875 0.8125
  v 7.5 37.5 30.7554    -0.14968 -0.160739 0.975581    0.5625 0.8125
  v 9.375 37.5 30.8177    0.0168645 -0.194599 0.980738    0.578125 0.8125
  v 11.25 37.5 30.666    0.0247979 -0.249209 0.968132    0.59375 0.8125
  v 13.125 37.5 30.805    0.0534476 -0.224058 0.973109    0.609375 0.8125
  v 15 37.5 30.5512    0.057819 -0.0297049 0.997885    0.625 0.8125
  v 16.875 37.5 30.5775    -0.197609 0.186164 0.962442    0.640625 0.8125
  v 18.75 37.5 31.3378    -0.233559 0.229783 0.944802    0.65625 0.8125
  v 20.625 37.5 31.556    0.146948 0.152493 0.977319    0.671875 0.8125
  v 22.5 37.5 30.7554    0.333382 0.0952846 0.937964    0.6875 0.8125
  v 24.375 37.5 30.1875    0.0820666 0.103059 0.991284    0.703125 0.8125
  v 26.25 37.5 30.4212    -0.143559 0.106847 0.983857    0.71875 0.8125
  v 28.125 37.5 30.8053    -0.112365 0.0715382 0.991088    0.734375 0.8125
  v 30 37.5 30.7493    0.00398428 -0.129991 0.991507    0.75 0.8125
  v 31.875 37.5 30.7017    0.0210472 -0.324004 0.945822    0.765625 0.8125
  v 33.75 37.5 30.7507    0.0484061 -0.272517 0.960933    0.78125 0.8125
  v 35.625 37.5 30.5754    -0.00867916 -0.0213543 0.999734    0.796875 0.8125
  v 37.5 37.5 30.7554    -0.209645 0.130833 0.968985    0.8125 0.8125
  v 39.375 37.5 31.3649    -0.139872 0.0546558 0.98866    0.828125 0.8125
  v 41.25 37.5 31.2182    0.175688 -0.0738492 0.981672    0.84375 0.8125
  v 43.125 37.5 30.5814    0.210415 -0.119498 0.970281    0.859375 0.8125
  v 45 37.5 30.4319    -0.00686711 -0.114 0.993457    0.875 0.8125
  v 46.875 37.5 30.726    0.00314335 -0.146817 0.989159    0.890625 0.8125
  v 48.75 37.5 30.507    0.130499 -0.158853 0.97864    0.90625 0.8125
  v 50.625 37.5 30.2736    -0.079141 -0.0342083 0.996276    0.921875 0.8125
  v 52.5 37.5 30.7554    -0.242205 0.0639092 0.968118    0.9375 0.8125
  v 54.375 37.5 31.2875    -0.0386037 0.0707407 0.996747    0.953125 0.8125
  v 56.25 37.5 31.0575    0.108624 0.160998 0.980959    0.96875 0.8125
  v 58.125 37.5 30.7493    -0.0538029 0.240529 0.96915    0.984375 0.8125
  v 60 37.5 30.9808    -0.0572137 0.164097 0.984784    1 0.8125
  v -60 39.375 30.8817    -0.123798 0.120218 0.984998    0 0.828125
  v -58.125 39.375 31.0473    0.0985828 0.0104149 0.995074    0.015625 0.828125
  v -56.25 39.375 30.5589    0.176566 -0.106425 0.978518    0.03125 0.828125
  v -54.375 39.375 30.4952    -0.119207 -0.0939026 0.988419    0.046875 0.828125
  v -52.5 39.375 31.0964    -0.22111 -0.0860739 0.971443    0.0625 0.828125
  v -50.625 39.375 31.265    0.0839139 -0.116073 0.98969    0.078125 0.828125
  v -48.75 39.375 30.6948    0.233527 -0.0233464 0.97207    0.09375 0.828125
  v -46.875 39.375 30.2734    0.0779641 0.102812 0.991641    0.109375 0.828125
  v -45 39.375 30.3741    -0.101409 0.13619 0.985479    0.125 0.828125
  v -43.125 39.375 30.5654    -0.0691901 0.0229829 0.997339    0.140625 0.828125
  v -41.25 39.375 30.5923    -0.0481037 -0.115228 0.992174    0.15625 0.828125
  v -39.375 39.375 30.8782    -0.0489841 -0.150659 0.987372    0.171875 0.828125
  v -37.5 39.375 31.0785    0.0176543 -0.0452677 0.998819    0.1875 0.828125
  v -35.625 39.375 30.866    0.0783987 0.0588175 0.995185    0.203125 0.828125
  v -33.75 39.375 30.5318    0.0439097 0.0585417 0.997319    0.21875 0.828125
  v -31.875 39.375 30.5118    -0.151859 0.0238421 0.988115    0.234375 0.828125
  v -30 39.375 31.202    -0.165121 -0.00170589 0.986272    0.25 0.828125
  v -28.125 39.375 31.319    0.173586 -0.0665383 0.982568    0.265625 0.828125
  v -26.25 39.375 30.5485    0.294763 -0.143987 0.94466    0.28125 0.828125
  v -24.375 39.375 30.1138    -0.0109619 -0.118033 0.992949    0.296875 0.828125
  v -22.5 39.375 30.5994    -0.200442 0.0183081 0.979535    0.3125 0.828125
  v -20.625 39.375 30.8288    -0.0696879 0.0562601 0.995981    0.328125 0.828125
  v -18.75 39.375 30.8543    -0.0540939 -0.00742847 0.998508    0.34375 0.828125
  v -16.875 39.375 31.1415    -0.117564 -0.0278485 0.992675    0.359375 0.828125
  v -15 39.375 31.3058    0.0607258 -0.0102841 0.998102    0.375 0.828125
  v -13.125 39.375 30.8226    0.259384 0.00898682 0.965733    0.390625 0.828125
  v -11.25 39.375 30.2685    0.219426 0.0303309 0.975157    0.40625 0.828125
  v -9.375 39.375 29.9557    -0.0663781 0.047652 0.996656    0.421875 0.828125
  v -7.5 39.375 30.5113    -0.25341 0.0485201 0.966141    0.4375 0.828125
  v -5.625 39.375 30.8674    0.00711829 0.0255571 0.999648    0.453125 0.828125
  v -3.75 39.375 30.3991    0.185808 0.056866 0.980939    0.46875 0.828125
  v -1.875 39.375 30.146    -0.124182 0.155898 0.979936    0.484375 0.828125
  v -1.23138e-023 39.375 30.9551    -0.270326 0.141102 0.952373    0.5 0.828125
  v 1.875 39.375 31.339    0.0576421 -0.0344923 0.997741    0.515625 0.828125
  v 3.75 39.375 30.8626    0.136002 -0.177913 0.974603    0.53125 0.828125
  v 5.625 39.375 30.8605    -0.0649969 -0.19286 0.979071    0.546875 0.828125
  v 7.5 39.375 31.2836    -0.119665 -0.0918148 0.98856    0.5625 0.828125
  v 9.375 39.375 31.3    -0.019672 -0.0699114 0.997359    0.578125 0.828125
  v 11.25 39.375 31.2821    -0.00375968 -0.117146 0.993108    0.59375 0.828125
  v 13.125 39.375 31.3649    0.0936105 -0.143738 0.985178    0.609375 0.828125
  v 15 39.375 30.7863    0.242289 -0.141959 0.959762    0.625 0.828125
  v 16.875 39.375 30.2989    0.00737296 0.00856705 0.999936    0.640625 0.828125
  v 18.75 39.375 30.7407    -0.218247 0.177084 0.959692    0.65625 0.828125
  v 20.625 39.375 31.0318    0.0599108 0.160028 0.985293    0.671875 0.828125
  v 22.5 39.375 30.4298    0.288892 0.0544066 0.955814    0.6875 0.828125
  v 24.375 39.375 29.924    0.0810508 0.0134272 0.99662    0.703125 0.828125
  v 26.25 39.375 30.1414    -0.0988968 0.0433064 0.994155    0.71875 0.828125
  v 28.125 39.375 30.3954    -0.138143 0.148022 0.979289    0.734375 0.828125
  v 30 39.375 30.7385    -0.218101 0.134584 0.966602    0.75 0.828125
  v 31.875 39.375 31.3511    -0.155347 -0.058311 0.986137    0.765625 0.828125
  v 33.75 39.375 31.4457    0.121432 -0.201165 0.972002    0.78125 0.828125
  v 35.625 39.375 30.7781    0.227682 -0.158679 0.96072    0.796875 0.828125
  v 37.5 39.375 30.4407    -0.0818582 0.0349545 0.996031    0.8125 0.828125
  v 39.375 39.375 31.0687    -0.241993 0.146809 0.959107    0.828125 0.828125
  v 41.25 39.375 31.391    0.0149797 0.0363476 0.999227    0.84375 0.828125
  v 43.125 39.375 31.0685    0.186152 -0.102441 0.977166    0.859375 0.828125
  v 45 39.375 30.8068    0.0534019 -0.0764915 0.995639    0.875 0.828125
  v 46.875 39.375 30.9059    -0.00896029 -0.00856039 0.999923    0.890625 0.828125
  v 48.75 39.375 30.7155    0.141396 -0.0431089 0.989014    0.90625 0.828125
  v 50.625 39.375 30.3234    0.049267 -0.0301306 0.998331    0.921875 0.828125
  v 52.5 39.375 30.5372    -0.165632 0.0621297 0.984229    0.9375 0.828125
  v 54.375 39.375 30.8611    -0.0109984 0.0960962 0.995311    0.953125 0.828125
  v 56.25 39.375 30.4235    0.19878 0.104609 0.974445    0.96875 0.828125
  v 58.125 39.375 30.0431    -0.0601107 0.169916 0.983624    0.984375 0.828125
  v 60 39.375 30.7492    -0.271402 0.187221 0.944081    1 0.828125
  v -60 41.25 30.6215    -0.130098 0.120424 0.984161    0 0.84375
  v -58.125 41.25 30.9994    -0.0357814 0.12941 0.990945    0.015625 0.84375
  v -56.25 41.25 30.7973    0.132365 0.0375198 0.990491    0.03125 0.84375
  v -54.375 41.25 30.5685    -0.0643112 0.0304454 0.997465    0.046875 0.84375
  v -52.5 41.25 30.998    -0.252495 0.0604293 0.965709    0.0625 0.84375
  v -50.625 41.25 31.4273    0.00950741 -0.0318073 0.999449    0.078125 0.84375
  v -48.75 41.25 30.9378    0.279351 -0.125373 0.951969    0.09375 0.84375
  v -46.875 41.25 30.335    0.183279 -0.0879123 0.979122    0.109375 0.84375
  v -45 41.25 30.2602    -0.0961551 0.0234566 0.99509    0.125 0.84375
  v -43.125 41.25 30.7083    -0.202563 0.0202312 0.97906    0.140625 0.84375
  v -41.25 41.25 31.0968    -0.132277 -0.0760571 0.988291    0.15625 0.84375
  v -39.375 41.25 31.3355    0.0406162 -0.0825621 0.995758    0.171875 0.84375
  v -37.5 41.25 30.9822    0.169744 0.0486856 0.984285    0.1875 0.84375
  v -35.625 41.25 30.5016    0.0862164 0.126178 0.988254    0.203125 0.84375
  v -33.75 41.25 30.487    -0.0539522 0.0456728 0.997498    0.21875 0.84375
  v -31.875 41.25 30.7748    -0.168568 -0.032962 0.985139    0.234375 0.84375
  v -30 41.25 31.3256    -0.115135 0.0370564 0.992658    0.25 0.84375
  v -28.125 41.25 31.2721    0.135356 0.114355 0.984176    0.265625 0.84375
  v -26.25 41.25 30.6956    0.206474 0.0359344 0.977792    0.28125 0.84375
  v -24.375 41.25 30.3908    0.0158185 -0.0949217 0.995359    0.296875 0.84375
  v -22.5 41.25 30.6181    -0.0910573 -0.0771169 0.992855    0.3125 0.84375
  v -20.625 41.25 30.7094    -0.0416164 0.0233279 0.998861    0.328125 0.84375
  v -18.75 41.25 30.8145    -0.073481 0.0771627 0.994307    0.34375 0.84375
  v -16.875 41.25 31.053    -0.127081 0.0826424 0.988443    0.359375 0.84375
  v -15 41.25 31.2204    0.0385766 0.034948 0.998644    0.375 0.84375
  v -13.125 41.25 30.8284    0.252984 -0.0260316 0.96712    0.390625 0.84375
  v -11.25 41.25 30.2522    0.212624 -0.0521838 0.97574    0.40625 0.84375
  v -9.375 41.25 29.9485    -0.065084 -0.0849113 0.994261    0.421875 0.84375
  v -7.5 41.25 30.4909    -0.27819 -0.0985519 0.955457    0.4375 0.84375
  v -5.625 41.25 31.0164    -0.0532323 -0.151832 0.986972    0.453125 0.84375
  v -3.75 41.25 30.7108    0.20575 -0.207309 0.956394    0.46875 0.84375
  v -1.875 41.25 30.2744    0.0179781 -0.138629 0.990181    0.484375 0.84375
  v -1.23138e-023 41.25 30.7771    -0.227639 0.076573 0.97073    0.5 0.84375
  v 1.875 41.25 31.2341    -0.0624472 0.173651 0.982825    0.515625 0.84375
  v 3.75 41.25 31.0178    0.0540826 0.0976054 0.993755    0.53125 0.84375
  v 5.625 41.25 31.0683    -0.0115499 0.0460395 0.998873    0.546875 0.84375
  v 7.5 41.25 31.099    -0.00828955 0.132479 0.991151    0.5625 0.84375
  v 9.375 41.25 31.0136    -0.019229 0.214421 0.976552    0.578125 0.84375
  v 11.25 41.25 31.1763    -0.0408086 0.210041 0.976841    0.59375 0.84375
  v 13.125 41.25 31.2358    -0.00659714 0.147863 0.988986    0.609375 0.84375
  v 15 41.25 30.9944    0.166091 -0.0590825 0.984339    0.625 0.84375
  v 16.875 41.25 30.5293    0.138675 -0.17431 0.974877    0.640625 0.84375
  v 18.75 41.25 30.5069    -0.120221 -0.0663152 0.99053    0.65625 0.84375
  v 20.625 41.25 30.8658    -0.0113496 -0.021965 0.999694    0.671875 0.84375
  v 22.5 41.25 30.5626    0.196048 -0.0966349 0.975821    0.6875 0.84375
  v 24.375 41.25 30.1618    0.0500491 -0.180076 0.982379    0.703125 0.84375
  v 26.25 41.25 30.3538    -0.0298656 -0.202137 0.978902    0.71875 0.84375
  v 28.125 41.25 30.2987    0.0325703 -0.0766735 0.996524    0.734375 0.84375
  v 30 41.25 30.3178    -0.169825 0.149542 0.974062    0.75 0.84375
  v 31.875 41.25 31.0413    -0.282218 0.22949 0.931498    0.765625 0.84375
  v 33.75 41.25 31.4556    -0.0318021 0.110673 0.993348    0.78125 0.84375
  v 35.625 41.25 31.1035    0.230089 -0.0798413 0.969889    0.796875 0.84375
  v 37.5 41.25 30.5856    0.0978532 -0.0874429 0.991352    0.8125 0.84375
  v 39.375 41.25 30.7891    -0.142097 0.102886 0.984491    0.828125 0.84375
  v 41.25 41.25 31.1341    -0.0845065 0.207653 0.974546    0.84375 0.84375
  v 43.125 41.25 31.1195    0.0925598 0.120156 0.988431    0.859375 0.84375
  v 45 41.25 30.7651    0.0923213 0.0181142 0.995564    0.875 0.84375
  v 46.875 41.25 30.6335    0.00449651 -0.00102735 0.999989    0.890625 0.84375
  v 48.75 41.25 30.6265    0.0620263 -0.0524947 0.996693    0.90625 0.84375
  v 50.625 41.25 30.3982    0.0662621 -0.131511 0.989098    0.921875 0.84375
  v 52.5 41.25 30.422    -0.112432 -0.115779 0.986891    0.9375 0.84375
  v 54.375 41.25 30.7636    -0.0530097 -0.113413 0.992133    0.953125 0.84375
  v 56.25 41.25 30.5879    0.177428 -0.176628 0.968154    0.96875 0.84375
  v 58.125 41.25 30.1625    0.0569819 -0.144033 0.987931    0.984375 0.84375
  v 60 41.25 30.546    -0.25159 0.00795989 0.967801    1 0.84375
  v -60 43.125 30.5939    -0.036498 0.0479289 0.998184    0 0.859375
  v -58.125 43.125 30.5907    -0.0377568 0.0455602 0.998248    0.015625 0.859375
  v -56.25 43.125 30.4912    0.0544069 -0.0234309 0.998244    0.03125 0.859375
  v -54.375 43.125 30.332    -0.0293858 -0.0610395 0.997703    0.046875 0.859375
  v -52.5 43.125 30.7358    -0.213425 0.046631 0.975846    0.0625 0.859375
  v -50.625 43.125 31.3654    -0.0934763 0.134949 0.986434    0.078125 0.859375
  v -48.75 43.125 31.1981    0.175993 0.0375952 0.983673    0.09375 0.859375
  v -46.875 43.125 30.6494    0.210994 -0.104345 0.971902    0.109375 0.859375
  v -45 43.125 30.2897    0.00739583 -0.111123 0.993779    0.125 0.859375
  v -43.125 43.125 30.5453    -0.201904 -0.0371294 0.978701    0.140625 0.859375
  v -41.25 43.125 31.0131    -0.170074 -0.0245711 0.985125    0.15625 0.859375
  v -39.375 43.125 31.2351    0.0800678 -0.0160603 0.99666    0.171875 0.859375
  v -37.5 43.125 30.7129    0.251991 0.0304297 0.967251    0.1875 0.859375
  v -35.625 43.125 30.2234    0.0741582 0.0610183 0.995378    0.203125 0.859375
  v -33.75 43.125 30.4292    -0.141729 0.0257409 0.989571    0.21875 0.859375
  v -31.875 43.125 30.8275    -0.170618 -0.0188054 0.985158    0.234375 0.859375
  v -30 43.125 31.1128    0.0024094 0.0268768 0.999636    0.25 0.859375
  v -28.125 43.125 30.7722    0.187141 0.12916 0.973805    0.265625 0.859375
  v -26.25 43.125 30.3326    0.0791575 0.138205 0.987235    0.28125 0.859375
  v -24.375 43.125 30.4554    -0.128482 -0.00167683 0.99171    0.296875 0.859375
  v -22.5 43.125 30.8623    -0.0867528 -0.145618 0.98553    0.3125 0.859375
  v -20.625 43.125 30.7807    0.0735233 -0.135865 0.987996    0.328125 0.859375
  v -18.75 43.125 30.6281    0.0280438 0.0225102 0.999353    0.34375 0.859375
  v -16.875 43.125 30.7491    -0.138745 0.142813 0.979977    0.359375 0.859375
  v -15 43.125 31.0994    -0.0597968 0.084048 0.994666    0.375 0.859375
  v -13.125 43.125 30.9386    0.202588 -0.0209256 0.97904    0.390625 0.859375
  v -11.25 43.125 30.4107    0.177662 -0.0445073 0.983085    0.40625 0.859375
  v -9.375 43.125 30.2578    -0.102173 -0.0777608 0.991723    0.421875 0.859375
  v -7.5 43.125 30.8789    -0.274926 -0.0673472 0.959104    0.4375 0.859375
  v -5.625 43.125 31.4633    -0.112974 -0.0478129 0.992447    0.453125 0.859375
  v -3.75 43.125 31.2837    0.134923 -0.146607 0.97995    0.46875 0.859375
  v -1.875 43.125 30.8119    0.141266 -0.236526 0.961301    0.484375 0.859375
  v -1.23138e-023 43.125 30.721    0.014984 -0.103531 0.994513    0.5 0.859375
  v 1.875 43.125 30.6679    -0.00504353 0.0797857 0.996799    0.515625 0.859375
  v 3.75 43.125 30.5298    -0.0157315 0.0791742 0.996737    0.53125 0.859375
  v 5.625 43.125 30.7217    -0.0154017 0.0478819 0.998734    0.546875 0.859375
  v 7.5 43.125 30.6913    0.0717762 0.0865359 0.99366    0.5625 0.859375
  v 9.375 43.125 30.4722    0.0398604 0.144288 0.988733    0.578125 0.859375
  v 11.25 43.125 30.5269    -0.0276647 0.196559 0.980102    0.59375 0.859375
  v 13.125 43.125 30.5736    -0.125355 0.207945 0.970075    0.609375 0.859375
  v 15 43.125 30.9551    -0.0799548 0.0578235 0.99512    0.625 0.859375
  v 16.875 43.125 31.0231    0.0728549 -0.115794 0.990598    0.640625 0.859375
  v 18.75 43.125 30.8682    -0.0455934 -0.13762 0.989435    0.65625 0.859375
  v 20.625 43.125 31.1273    -0.0226104 -0.139014 0.990032    0.671875 0.859375
  v 22.5 43.125 30.8552    0.127174 -0.181124 0.975203    0.6875 0.859375
  v 24.375 43.125 30.5976    -0.0108755 -0.23484 0.971973    0.703125 0.859375
  v 26.25 43.125 30.9458    -0.0313441 -0.267894 0.962938    0.71875 0.859375
  v 28.125 43.125 30.7938    0.176621 -0.25136 0.951642    0.734375 0.859375
  v 30 43.125 30.2091    0.0774743 -0.106032 0.99134    0.75 0.859375
  v 31.875 43.125 30.4185    -0.19262 0.138701 0.971421    0.765625 0.859375
  v 33.75 43.125 30.9552    -0.185127 0.22438 0.956756    0.78125 0.859375
  v 35.625 43.125 31.1183    0.0272532 0.0448007 0.998624    0.796875 0.859375
  v 37.5 43.125 30.8397    0.141126 -0.135848 0.980627    0.8125 0.859375
  v 39.375 43.125 30.6682    0.0486663 -0.0695202 0.996393    0.828125 0.859375
  v 41.25 43.125 30.5925    -0.017448 0.0650153 0.997732    0.84375 0.859375
  v 43.125 43.125 30.5886    0.00979264 0.10608 0.994309    0.859375 0.859375
  v 45 43.125 30.6013    -0.00131208 0.0836196 0.996497    0.875 0.859375
  v 46.875 43.125 30.7873    -0.0583391 0.031823 0.99779    0.890625 0.859375
  v 48.75 43.125 30.9158    -0.0148445 -0.0293521 0.999459    0.90625 0.859375
  v 50.625 43.125 30.8745    0.0155444 -0.0789658 0.996756    0.921875 0.859375
  v 52.5 43.125 30.9219    -0.0808713 -0.076965 0.993749    0.9375 0.859375
  v 54.375 43.125 31.2673    -0.0819326 -0.0449641 0.995623    0.953125 0.859375
  v 56.25 43.125 31.2104    0.0914744 -0.123129 0.988166    0.96875 0.859375
  v 58.125 43.125 30.7813    0.136524 -0.243919 0.960138    0.984375 0.859375
  v 60 43.125 30.5744    0.00323801 -0.202885 0.979197    1 0.859375
  v -60 45 30.3631    -0.157824 0.0591374 0.985695    0 0.875
  v -58.125 45 30.5771    -0.130927 -0.0228176 0.991129    0.015625 0.875
  v -56.25 45 30.8373    -0.066503 -0.158432 0.985128    0.03125 0.875
  v -54.375 45 30.9418    0.0162916 -0.196483 0.980372    0.046875 0.875
  v -52.5 45 31.0166    -0.00259818 -0.0397999 0.999204    0.0625 0.875
  v -50.625 45 31.0043    -0.00132904 0.170403 0.985373    0.078125 0.875
  v -48.75 45 30.7574    0.0415326 0.166109 0.985232    0.09375 0.875
  v -46.875 45 30.6533    0.0623164 -0.00840445 0.998021    0.109375 0.875
  v -45 45 30.6093    0.00755521 -0.113682 0.993488    0.125 0.875
  v -43.125 45 30.7982    -0.164748 -0.0887644 0.982334    0.140625 0.875
  v -41.25 45 31.2297    -0.163746 -0.0705769 0.983975    0.15625 0.875
  v -39.375 45 31.4116    0.100687 -0.0598777 0.993115    0.171875 0.875
  v -37.5 45 30.8309    0.28812 -0.0357328 0.956927    0.1875 0.875
  v -35.625 45 30.2747    0.0885921 -0.0159922 0.99594    0.203125 0.875
  v -33.75 45 30.454    -0.165786 -0.0151351 0.986046    0.21875 0.875
  v -31.875 45 30.8797    -0.201185 -0.0434381 0.97859    0.234375 0.875
  v -30 45 31.1747    0.0387443 -0.0842157 0.995694    0.25 0.875
  v -28.125 45 30.7134    0.268628 -0.0485566 0.962019    0.265625 0.875
  v -26.25 45 30.1617    0.0935246 0.0524063 0.994237    0.28125 0.875
  v -24.375 45 30.4309    -0.244577 0.0909674 0.965353    0.296875 0.875
  v -22.5 45 31.1675    -0.232617 -0.0301202 0.972102    0.3125 0.875
  v -20.625 45 31.2832    0.0926389 -0.193775 0.976662    0.328125 0.875
  v -18.75 45 30.8051    0.215698 -0.153748 0.96428    0.34375 0.875
  v -16.875 45 30.4443    -0.0405336 0.0323253 0.998655    0.359375 0.875
  v -15 45 30.8621    -0.143804 0.0920918 0.985312    0.375 0.875
  v -13.125 45 31.0027    0.144124 0.033142 0.989005    0.390625 0.875
  v -11.25 45 30.4273    0.173682 0.0264838 0.984446    0.40625 0.875
  v -9.375 45 30.3088    -0.109526 0.025085 0.993667    0.421875 0.875
  v -7.5 45 30.8842    -0.189685 0.0750478 0.978973    0.4375 0.875
  v -5.625 45 31.1679    -0.0945626 0.20463 0.974261    0.453125 0.875
  v -3.75 45 31.1591    -0.0314192 0.164439 0.985887    0.46875 0.875
  v -1.875 45 31.1945    0.034873 -0.0474992 0.998262    0.484375 0.875
  v -1.23138e-023 45 31.0842    0.125906 -0.145852 0.981262    0.5 0.875
  v 1.875 45 30.7015    0.0577248 -0.101126 0.993198    0.515625 0.875
  v 3.75 45 30.7063    -0.0587474 -0.118065 0.991267    0.53125 0.875
  v 5.625 45 30.9865    0.00623818 -0.118211 0.992969    0.546875 0.875
  v 7.5 45 30.7909    0.12259 -0.0597403 0.990658    0.5625 0.875
  v 9.375 45 30.4455    0.071108 -0.0533962 0.996038    0.578125 0.875
  v 11.25 45 30.4061    0.0165222 -0.0609758 0.998002    0.59375 0.875
  v 13.125 45 30.364    -0.113741 -0.00669109 0.993488    0.609375 0.875
  v 15 45 30.9058    -0.175454 0.0421371 0.983585    0.625 0.875
  v 16.875 45 31.1714    0.0134902 0.0470429 0.998802    0.640625 0.875
  v 18.75 45 30.9629    -0.0321966 0.0658435 0.99731    0.65625 0.875
  v 20.625 45 31.2944    -0.0723513 0.0555166 0.995833    0.671875 0.875
  v 22.5 45 31.22    0.059999 -0.0114147 0.998133    0.6875 0.875
  v 24.375 45 31.1148    -0.0391417 -0.0514978 0.997906    0.703125 0.875
  v 26.25 45 31.4704    -0.0315452 -0.034861 0.998894    0.71875 0.875
  v 28.125 45 31.2566    0.148763 -0.069516 0.986426    0.734375 0.875
  v 30 45 30.6719    0.184061 -0.18705 0.964953    0.75 0.875
  v 31.875 45 30.464    0.0460008 -0.103212 0.993595    0.765625 0.875
  v 33.75 45 30.5384    -0.129719 0.137053 0.982033    0.78125 0.875
  v 35.625 45 30.9207    -0.170677 0.173178 0.969989    0.796875 0.875
  v 37.5 45 31.1979    0.0158644 0.00612577 0.999855    0.8125 0.875
  v 39.375 45 30.9904    0.107761 -0.0791262 0.991023    0.828125 0.875
  v 41.25 45 30.7276    0.034249 -0.0821579 0.996031    0.84375 0.875
  v 43.125 45 30.753    0.0331225 -0.0870073 0.995657    0.859375 0.875
  v 45 45 30.6407    0.0430395 -0.0366889 0.998399    0.875 0.875
  v 46.875 45 30.6086    -0.0540937 0.0438637 0.997572    0.890625 0.875
  v 48.75 45 30.7696    -0.0344756 0.0615079 0.997511    0.90625 0.875
  v 50.625 45 30.769    0.000566872 0.068181 0.997673    0.921875 0.875
  v 52.5 45 30.8048    -0.0136537 0.105118 0.994366    0.9375 0.875
  v 54.375 45 30.9186    -0.0511291 0.20147 0.978159    0.953125 0.875
  v 56.25 45 30.9386    -0.0623643 0.172474 0.983038    0.96875 0.875
  v 58.125 45 31.026    -0.0391767 -0.0502002 0.99797    0.984375 0.875
  v 60 45 31.1042    0.00792006 -0.20804 0.978088    1 0.875
  v -60 46.875 30.1768    -0.155665 0.0555902 0.986244    0 0.890625
  v -58.125 46.875 30.6538    -0.222039 0.108122 0.969024    0.015625 0.890625
  v -56.25 46.875 31.2072    -0.145146 0.0828526 0.985935    0.03125 0.890625
  v -54.375 46.875 31.3368    0.064008 0.0602009 0.996132    0.046875 0.890625
  v -52.5 46.875 30.9394    0.168687 0.103453 0.980226    0.0625 0.890625
  v -50.625 46.875 30.438    0.0766659 0.153407 0.985185    0.078125 0.890625
  v -48.75 46.875 30.3664    -0.0759967 0.101553 0.991923    0.09375 0.890625
  v -46.875 46.875 30.7689    -0.0666147 0.0165365 0.997642    0.109375 0.890625
  v -45 46.875 30.8964    0.0133224 0.0237258 0.99963    0.125 0.890625
  v -43.125 46.875 30.8744    -0.119114 0.0927501 0.988539    0.140625 0.890625
  v -41.25 46.875 31.2695    -0.174623 0.0915787 0.980367    0.15625 0.890625
  v -39.375 46.875 31.4571    0.0939279 0.0413282 0.994721    0.171875 0.890625
  v -37.5 46.875 30.8454    0.299791 0.0117219 0.953933    0.1875 0.890625
  v -35.625 46.875 30.2536    0.0960755 0.0142921 0.995271    0.203125 0.890625
  v -33.75 46.875 30.4583    -0.175012 0.0166251 0.984426    0.21875 0.890625
  v -31.875 46.875 30.9429    -0.239706 0.0131612 0.970756    0.234375 0.890625
  v -30 46.875 31.4181    -0.002215 -0.0177914 0.999839    0.25 0.890625
  v -28.125 46.875 31.0065    0.302462 -0.0489686 0.951903    0.265625 0.890625
  v -26.25 46.875 30.2129    0.203327 -0.0185649 0.978935    0.28125 0.890625
  v -24.375 46.875 30.1367    -0.188026 0.0834132 0.978616    0.296875 0.890625
  v -22.5 46.875 30.9077    -0.342989 0.134887 0.929604    0.3125 0.890625
  v -20.625 46.875 31.5307    -0.0619817 0.0270357 0.997711    0.328125 0.890625
  v -18.75 46.875 31.2434    0.262707 -0.0963417 0.960054    0.34375 0.890625
  v -16.875 46.875 30.5294    0.0941471 -0.0663441 0.993345    0.359375 0.890625
  v -15 46.875 30.7559    -0.131997 -0.00462177 0.991239    0.375 0.890625
  v -13.125 46.875 30.9389    0.107734 -0.0235412 0.993901    0.390625 0.890625
  v -11.25 46.875 30.2878    0.176256 -0.0543131 0.982845    0.40625 0.890625
  v -9.375 46.875 30.1911    -0.0978113 -0.0599389 0.993398    0.421875 0.890625
  v -7.5 46.875 30.713    -0.0897376 -0.0186744 0.99579    0.4375 0.890625
  v -5.625 46.875 30.5775    0.0245982 0.100819 0.994601    0.453125 0.890625
  v -3.75 46.875 30.5425    -0.11317 0.182536 0.976664    0.46875 0.890625
  v -1.875 46.875 31.0585    -0.12729 0.146828 0.980938    0.484375 0.890625
  v -1.23138e-023 46.875 31.2691    0.0740878 0.0913662 0.993057    0.5 0.890625
  v 1.875 46.875 30.897    0.0552321 0.0643012 0.996401    0.515625 0.890625
  v 3.75 46.875 31.0388    -0.0949266 0.0212241 0.995258    0.53125 0.890625
  v 5.625 46.875 31.2795    0.0483241 0.00575689 0.998815    0.546875 0.890625
  v 7.5 46.875 30.8419    0.154294 0.0406387 0.987189    0.5625 0.890625
  v 9.375 46.875 30.5587    0.00628266 -0.00348051 0.999974    0.578125 0.890625
  v 11.25 46.875 30.7396    -0.0141784 -0.107593 0.994094    0.59375 0.890625
  v 13.125 46.875 30.6608    -0.0294804 -0.11041 0.993449    0.609375 0.890625
  v 15 46.875 30.9264    -0.0864571 0.00223318 0.996253    0.625 0.890625
  v 16.875 46.875 30.9534    0.0563177 0.0918336 0.994181    0.640625 0.890625
  v 18.75 46.875 30.6143    0.0143169 0.13702 0.990465    0.65625 0.890625
  v 20.625 46.875 30.8971    -0.0768552 0.19092 0.978592    0.671875 0.890625
  v 22.5 46.875 30.9479    0.0201839 0.210645 0.977354    0.6875 0.890625
  v 24.375 46.875 30.9    -0.0252899 0.217887 0.975646    0.703125 0.890625
  v 26.25 46.875 31.1045    -0.0013001 0.253878 0.967235    0.71875 0.890625
  v 28.125 46.875 30.84    0.0291211 0.24428 0.969267    0.734375 0.890625
  v 30 46.875 30.8726    0.0115213 0.0560497 0.998362    0.75 0.890625
  v 31.875 46.875 30.8644    0.142785 -0.106672 0.983989    0.765625 0.890625
  v 33.75 46.875 30.3754    0.0997362 0.00725776 0.994987    0.78125 0.890625
  v 35.625 46.875 30.4391    -0.138257 0.214767 0.96683    0.796875 0.890625
  v 37.5 46.875 30.9495    -0.0967664 0.268842 0.958311    0.8125 0.890625
  v 39.375 46.875 30.9085    0.0435772 0.21554 0.975522    0.828125 0.890625
  v 41.25 46.875 30.796    -0.0122536 0.140948 0.989941    0.84375 0.890625
  v 43.125 46.875 30.9545    -0.0167047 0.0381756 0.999131    0.859375 0.890625
  v 45 46.875 30.7571    0.0691735 -0.0667431 0.99537    0.875 0.890625
  v 46.875 46.875 30.547    -0.0117597 -0.0969704 0.995218    0.890625 0.890625
  v 48.75 46.875 30.7149    -0.0447156 -0.112103 0.99269    0.90625 0.890625
  v 50.625 46.875 30.6555    0.0169609 -0.135357 0.990652    0.921875 0.890625
  v 52.5 46.875 30.6201    0.063317 -0.112491 0.991633    0.9375 0.890625
  v 54.375 46.875 30.4293    0.0475011 -0.0184126 0.998701    0.953125 0.890625
  v 56.25 46.875 30.4048    -0.130525 0.0664634 0.989215    0.96875 0.890625
  v 58.125 46.875 30.9895    -0.214531 0.0530517 0.975275    0.984375 0.890625
  v 60 46.875 31.5311    -0.201202 -0.0238369 0.97926    1 0.890625
  v -60 48.75 30.371    0.105452 -0.169312 0.979905    0 0.90625
  v -58.125 48.75 30.3173    -0.054096 0.0567067 0.996924    0.015625 0.90625
  v -56.25 48.75 30.6342    -0.104799 0.265103 0.958508    0.03125 0.90625
  v -54.375 48.75 30.6754    0.0109479 0.261443 0.965157    0.046875 0.90625
  v -52.5 48.75 30.3671    0.126811 0.131283 0.983201    0.0625 0.90625
  v -50.625 48.75 30.1371    0.0358199 0.0620344 0.997431    0.078125 0.90625
  v -48.75 48.75 30.4099    -0.133886 0.0535624 0.989548    0.09375 0.90625
  v -46.875 48.75 30.8616    -0.0705568 0.060209 0.995689    0.109375 0.90625
  v -45 48.75 30.6723    0.0843148 0.0755848 0.993568    0.125 0.90625
  v -43.125 48.75 30.3511    -0.0578998 0.106032 0.992676    0.140625 0.90625
  v -41.25 48.75 30.7841    -0.220592 0.110587 0.969077    0.15625 0.90625
  v -39.375 48.75 31.1997    0.0127886 0.0477991 0.998775    0.171875 0.90625
  v -37.5 48.75 30.76    0.261174 -0.0369316 0.964585    0.1875 0.90625
  v -35.625 48.75 30.2118    0.106291 -0.0631843 0.992326    0.203125 0.90625
  v -33.75 48.75 30.4093    -0.157484 -0.0252221 0.987199    0.21875 0.90625
  v -31.875 48.75 30.8624    -0.21785 0.0235588 0.975698    0.234375 0.90625
  v -30 48.75 31.2954    -0.0193946 0.0593781 0.998047    0.25 0.90625
  v -28.125 48.75 30.9016    0.255463 0.0141483 0.966715    0.265625 0.90625
  v -26.25 48.75 30.1718    0.195721 -0.0927685 0.976262    0.28125 0.90625
  v -24.375 48.75 30.0537    -0.0822065 -0.099811 0.991605    0.296875 0.90625
  v -22.5 48.75 30.632    -0.275673 0.0622186 0.959236    0.3125 0.90625
  v -20.625 48.75 31.2631    -0.153431 0.171077 0.973238    0.328125 0.90625
  v -18.75 48.75 31.2205    0.175647 0.100084 0.979353    0.34375 0.90625
  v -16.875 48.75 30.5953    0.12028 0.0318029 0.992231    0.359375 0.90625
  v -15 48.75 30.788    -0.146736 0.0123775 0.989098    0.375 0.90625
  v -13.125 48.75 31.0525    0.0162555 -0.089144 0.995886    0.390625 0.90625
  v -11.25 48.75 30.5717    0.128789 -0.215774 0.967913    0.40625 0.90625
  v -9.375 48.75 30.5865    -0.0507226 -0.211389 0.976085    0.421875 0.90625
  v -7.5 48.75 30.9913    -0.0375419 -0.106403 0.993614    0.4375 0.90625
  v -5.625 48.75 30.6921    0.10381 -0.0847937 0.990976    0.453125 0.90625
  v -3.75 48.75 30.4879    -0.0223309 -0.0351042 0.999134    0.46875 0.90625
  v -1.875 48.75 30.8545    -0.0786041 0.107462 0.991097    0.484375 0.90625
  v -1.23138e-023 48.75 30.8559    0.0662951 0.192191 0.979116    0.5 0.90625
  v 1.875 48.75 30.4339    0.0329658 0.154489 0.987444    0.515625 0.90625
  v 3.75 48.75 30.6465    -0.13494 0.10903 0.984837    0.53125 0.90625
  v 5.625 48.75 30.9531    0.0486269 0.0895624 0.994793    0.546875 0.90625
  v 7.5 48.75 30.5041    0.146861 0.0941161 0.98467    0.5625 0.90625
  v 9.375 48.75 30.3754    -0.0933985 0.0496609 0.99439    0.578125 0.90625
  v 11.25 48.75 30.862    -0.103856 -0.0548965 0.993076    0.59375 0.90625
  v 13.125 48.75 30.8562    0.0449632 -0.0655586 0.996835    0.609375 0.90625
  v 15 48.75 30.8608    0.0215432 0.0620541 0.99784    0.625 0.90625
  v 16.875 48.75 30.7264    0.0583389 0.0954177 0.993726    0.640625 0.90625
  v 18.75 48.75 30.4415    0.0209833 0.00602456 0.999762    0.65625 0.90625
  v 20.625 48.75 30.5997    -0.00436417 0.00824645 0.999956    0.671875 0.90625
  v 22.5 48.75 30.4896    0.0831412 0.11061 0.99038    0.6875 0.90625
  v 24.375 48.75 30.3256    0.0201002 0.203417 0.978886    0.703125 0.90625
  v 26.25 48.75 30.4167    0.0193122 0.243863 0.969617    0.71875 0.90625
  v 28.125 48.75 30.184    -0.0180608 0.241348 0.970271    0.734375 0.90625
  v 30 48.75 30.5318    -0.189914 0.175998 0.965897    0.75 0.90625
  v 31.875 48.75 30.927    -0.00340994 -0.0234521 0.999719    0.765625 0.90625
  v 33.75 48.75 30.4766    0.225998 -0.152452 0.962124    0.78125 0.90625
  v 35.625 48.75 30.1016    0.0857708 -0.0015932 0.996314    0.796875 0.90625
  v 37.5 48.75 30.2175    -0.0255207 0.231523 0.972495    0.8125 0.90625
  v 39.375 48.75 30.1547    -0.0108874 0.285771 0.958236    0.828125 0.90625
  v 41.25 48.75 30.175    -0.105062 0.201558 0.973826    0.84375 0.90625
  v 43.125 48.75 30.4984    -0.137468 0.105737 0.984846    0.859375 0.90625
  v 45 48.75 30.7476    -0.0404762 0.035575 0.998547    0.875 0.90625
  v 46.875 48.75 30.8905    -0.0782989 -0.0216516 0.996695    0.890625 0.90625
  v 48.75 48.75 31.1436    -0.120111 -0.103962 0.987302    0.90625 0.90625
  v 50.625 48.75 31.2693    -0.01098 -0.191841 0.981365    0.921875 0.90625
  v 52.5 48.75 31.2668    0.0740931 -0.211349 0.974598    0.9375 0.90625
  v 54.375 48.75 30.954    0.119187 -0.221365 0.96788    0.953125 0.90625
  v 56.25 48.75 30.735    -0.00627253 -0.146739 0.989155    0.96875 0.90625
  v 58.125 48.75 31.1039    -0.125978 0.0411171 0.991181    0.984375 0.90625
  v 60 48.75 31.2696    -0.151263 0.126426 0.980376    1 0.90625
  v -60 50.625 31.0073    0.258296 -0.282603 0.923807    0 0.921875
  v -58.125 50.625 30.4836    0.218822 -0.182978 0.958455    0.015625 0.921875
  v -56.25 50.625 30.1121    0.0534325 0.0455261 0.997533    0.03125 0.921875
  v -54.375 50.625 30.0857    -0.101958 0.104202 0.989316    0.046875 0.921875
  v -52.5 50.625 30.371    -0.038853 -0.065978 0.997064    0.0625 0.921875
  v -50.625 50.625 30.3798    0.0320679 -0.173121 0.984378    0.078125 0.921875
  v -48.75 50.625 30.373    -0.0498902 -0.108231 0.992873    0.09375 0.921875
  v -46.875 50.625 30.5315    -0.0358444 -0.00156382 0.999356    0.109375 0.921875
  v -45 50.625 30.4193    0.045687 0.00679759 0.998933    0.125 0.921875
  v -43.125 50.625 30.3553    -0.07591 -0.0523411 0.99574    0.140625 0.921875
  v -41.25 50.625 30.8285    -0.21077 -0.0347452 0.976918    0.15625 0.921875
  v -39.375 50.625 31.2964    -0.0332313 0.025432 0.999124    0.171875 0.921875
  v -37.5 50.625 31.0182    0.193774 0.00244245 0.981043    0.1875 0.921875
  v -35.625 50.625 30.557    0.107569 -0.0603552 0.992364    0.203125 0.921875
  v -33.75 50.625 30.6044    -0.100644 -0.0531325 0.993503    0.21875 0.921875
  v -31.875 50.625 30.8995    -0.157974 -0.00422714 0.987434    0.234375 0.921875
  v -30 50.625 31.1579    -0.00902851 0.0317482 0.999455    0.25 0.921875
  v -28.125 50.625 30.8331    0.162164 -0.0065672 0.986742    0.265625 0.921875
  v -26.25 50.625 30.4933    0.0692516 -0.123845 0.989882    0.28125 0.921875
  v -24.375 50.625 30.6654    -0.018931 -0.187757 0.982033    0.296875 0.921875
  v -22.5 50.625 30.7757    -0.0698985 -0.0524079 0.996176    0.3125 0.921875
  v -20.625 50.625 30.8526    -0.0920364 0.102108 0.990507    0.328125 0.921875
  v -18.75 50.625 30.8747    0.0974646 0.0889301 0.991258    0.34375 0.921875
  v -16.875 50.625 30.4546    0.121714 0.05666 0.990947    0.359375 0.921875
  v -15 50.625 30.6049    -0.163374 0.131164 0.977806    0.375 0.921875
  v -13.125 50.625 31.1421    -0.147566 0.0960956 0.984373    0.390625 0.921875
  v -11.25 50.625 31.1674    0.00546174 -0.0746797 0.997193    0.40625 0.921875
  v -9.375 50.625 31.2355    0.0542955 -0.127938 0.990295    0.421875 0.921875
  v -7.5 50.625 31.0728    0.0589287 0.00533029 0.998248    0.4375 0.921875
  v -5.625 50.625 30.7899    0.0638948 0.00794693 0.997925    0.453125 0.921875
  v -3.75 50.625 30.7503    0.0480404 -0.0538128 0.997395    0.46875 0.921875
  v -1.875 50.625 30.7184    0.0604865 0.0248597 0.997859    0.484375 0.921875
  v -1.23138e-023 50.625 30.3671    0.0590563 0.0698141 0.99581    0.5 0.921875
  v 1.875 50.625 30.2278    -0.0509567 -0.0355945 0.998066    0.515625 0.921875
  v 3.75 50.625 30.6253    -0.17333 -0.0999622 0.979778    0.53125 0.921875
  v 5.625 50.625 30.9861    0.0537598 -0.100114 0.993523    0.546875 0.921875
  v 7.5 50.625 30.4664    0.178337 -0.0474837 0.982823    0.5625 0.921875
  v 9.375 50.625 30.3667    -0.107493 0.0321968 0.993684    0.578125 0.921875
  v 11.25 50.625 31.0271    -0.16329 0.0710981 0.984013    0.59375 0.921875
  v 13.125 50.625 31.0794    0.0834735 0.0341099 0.995926    0.609375 0.921875
  v 15 50.625 30.6435    0.102199 0.0234046 0.994489    0.625 0.921875
  v 16.875 50.625 30.3933    -0.00512083 -0.0179282 0.999826    0.640625 0.921875
  v 18.75 50.625 30.5443    -0.0863849 -0.119673 0.989048    0.65625 0.921875
  v 20.625 50.625 30.8991    0.0318174 -0.155054 0.987394    0.671875 0.921875
  v 22.5 50.625 30.5679    0.178364 -0.0939303 0.979471    0.6875 0.921875
  v 24.375 50.625 30.1191    0.0747957 -0.0629954 0.995207    0.703125 0.921875
  v 26.25 50.625 30.0841    0.0244943 -0.0789377 0.996579    0.71875 0.921875
  v 28.125 50.625 29.9446    0.0369125 -0.0465333 0.998235    0.734375 0.921875
  v 30 50.625 30.1824    -0.219267 0.10264 0.970251    0.75 0.921875
  v 31.875 50.625 30.8972    -0.231317 0.0793569 0.969636    0.765625 0.921875
  v 33.75 50.625 31.0342    0.0887618 -0.180154 0.979625    0.78125 0.921875
  v 35.625 50.625 30.5283    0.244652 -0.299905 0.922064    0.796875 0.921875
  v 37.5 50.625 29.9885    0.181335 -0.160137 0.970296    0.8125 0.921875
  v 39.375 50.625 29.6962    0.00510709 -0.00451058 0.999977    0.828125 0.921875
  v 41.25 50.625 29.9455    -0.217313 -0.00315262 0.976097    0.84375 0.921875
  v 43.125 50.625 30.5897    -0.200326 -0.0905887 0.975532    0.859375 0.921875
  v 45 50.625 30.8576    -0.0144056 -0.0867831 0.996123    0.875 0.921875
  v 46.875 50.625 30.7332    -0.0594536 0.0134914 0.99814    0.890625 0.921875
  v 48.75 50.625 31.0332    -0.166311 0.073351 0.983341    0.90625 0.921875
  v 50.625 50.625 31.4782    -0.0449196 0.0884652 0.995066    0.921875 0.921875
  v 52.5 50.625 31.415    0.0413648 0.10427 0.993688    0.9375 0.921875
  v 54.375 50.625 31.2232    0.0685302 0.0205539 0.997437    0.953125 0.921875
  v 56.25 50.625 31.0886    0.116391 -0.0426095 0.992289    0.96875 0.921875
  v 58.125 50.625 30.8846    0.0436769 0.0747424 0.996246    0.984375 0.921875
  v 60 50.625 30.6746    0.0463309 0.163777 0.985409    1 0.921875
  v -60 52.5 31.5508    0.19863 -0.127169 0.971789    0 0.9375
  v -58.125 52.5 31.0254    0.296978 -0.231878 0.926303    0.015625 0.9375
  v -56.25 52.5 30.2537    0.216673 -0.182657 0.959004    0.03125 0.9375
  v -54.375 52.5 30.1412    -0.094271 -0.038194 0.994814    0.046875 0.9375
  v -52.5 52.5 30.7554    -0.201583 -0.0297703 0.979019    0.0625 0.9375
  v -50.625 52.5 30.9272    -0.0400086 -0.183027 0.982293    0.078125 0.9375
  v -48.75 52.5 30.7852    0.0282727 -0.260922 0.964946    0.09375 0.9375
  v -46.875 52.5 30.7715    0.0465948 -0.196826 0.979331    0.109375 0.9375
  v -45 52.5 30.6415    0.0332497 -0.123662 0.991767    0.125 0.9375
  v -43.125 52.5 30.6678    -0.0860082 -0.110518 0.990146    0.140625 0.9375
  v -41.25 52.5 31.0464    -0.0887213 -0.0268973 0.995693    0.15625 0.9375
  v -39.375 52.5 31.1652    0.0668963 0.165824 0.983884    0.171875 0.9375
  v -37.5 52.5 30.7554    0.159908 0.25321 0.954104    0.1875 0.9375
  v -35.625 52.5 30.4476    0.0410599 0.202116 0.978501    0.203125 0.9375
  v -33.75 52.5 30.5731    -0.111974 0.117948 0.986686    0.21875 0.9375
  v -31.875 52.5 30.8317    -0.160169 0.0547031 0.985573    0.234375 0.9375
  v -30 52.5 31.0742    -0.0275187 -0.00401469 0.999613    0.25 0.9375
  v -28.125 52.5 30.8797    0.112617 -0.0364094 0.992971    0.265625 0.9375
  v -26.25 52.5 30.7506    0.0187897 -0.0249784 0.999511    0.28125 0.9375
  v -24.375 52.5 30.99    -0.0110925 -0.0129607 0.999854    0.296875 0.9375
  v -22.5 52.5 30.7554    0.0380016 -0.0215964 0.999044    0.3125 0.9375
  v -20.625 52.5 30.6105    -0.0413628 -0.0115814 0.999077    0.328125 0.9375
  v -18.75 52.5 30.8559    0.040086 -0.00952523 0.999151    0.34375 0.9375
  v -16.875 52.5 30.5788    0.15504 -0.0244372 0.987606    0.359375 0.9375
  v -15 52.5 30.3354    -0.0530224 0.0484062 0.997419    0.375 0.9375
  v -13.125 52.5 30.6679    -0.187647 0.125624 0.97417    0.390625 0.9375
  v -11.25 52.5 30.9929    -0.119104 0.087554 0.989014    0.40625 0.9375
  v -9.375 52.5 31.1966    0.0707083 0.022727 0.997238    0.421875 0.9375
  v -7.5 52.5 30.7554    0.145894 0.0618316 0.987366    0.4375 0.9375
  v -5.625 52.5 30.5797    -0.00749612 0.0798943 0.996775    0.453125 0.9375
  v -3.75 52.5 30.801    -0.00356658 -0.00508461 0.999981    0.46875 0.9375
  v -1.875 52.5 30.6046    0.0859341 -0.0636909 0.994263    0.484375 0.9375
  v -1.23138e-023 52.5 30.3226    0.00630252 -0.104875 0.994465    0.5 0.9375
  v 1.875 52.5 30.634    -0.151382 -0.154355 0.976349    0.515625 0.9375
  v 3.75 52.5 31.1305    -0.187664 -0.171029 0.967229    0.53125 0.9375
  v 5.625 52.5 31.395    0.0695653 -0.183058 0.980638    0.546875 0.9375
  v 7.5 52.5 30.7554    0.268507 -0.157113 0.950379    0.5625 0.9375
  v 9.375 52.5 30.3837    0.0556391 -0.00285125 0.998447    0.578125 0.9375
  v 11.25 52.5 30.666    -0.0856977 0.211178 0.973684    0.59375 0.9375
  v 13.125 52.5 30.659    0.00661347 0.249084 0.968459    0.609375 0.9375
  v 15 52.5 30.4781    -0.0344798 0.0824019 0.996002    0.625 0.9375
  v 16.875 52.5 30.6775    -0.123955 -0.137125 0.982767    0.640625 0.9375
  v 18.75 52.5 31.0775    -0.119277 -0.20082 0.97234    0.65625 0.9375
  v 20.625 52.5 31.3435    0.0903242 -0.1289 0.987536    0.671875 0.9375
  v 22.5 52.5 30.7554    0.200276 -0.068644 0.977332    0.6875 0.9375
  v 24.375 52.5 30.3699    0.00670752 -0.146451 0.989195    0.703125 0.9375
  v 26.25 52.5 30.6494    -0.0406 -0.258737 0.965094    0.71875 0.9375
  v 28.125 52.5 30.6271    0.129087 -0.290945 0.947991    0.734375 0.9375
  v 30 52.5 30.2195    -0.014559 -0.148657 0.988782    0.75 0.9375
  v 31.875 52.5 30.5468    -0.260753 0.0379359 0.96466    0.765625 0.9375
  v 33.75 52.5 31.1835    -0.163302 0.00566879 0.98656    0.78125 0.9375
  v 35.625 52.5 31.28    0.112029 -0.210042 0.971253    0.796875 0.9375
  v 37.5 52.5 30.7554    0.248985 -0.355357 0.90096    0.8125 0.9375
  v 39.375 52.5 30.1481    0.127533 -0.331701 0.934725    0.828125 0.9375
  v 41.25 52.5 30.2392    -0.176895 -0.182854 0.967095    0.84375 0.9375
  v 43.125 52.5 30.9797    -0.230144 -0.0898345 0.969001    0.859375 0.9375
  v 45 52.5 31.1667    0.00667242 -0.127562 0.991808    0.875 0.9375
  v 46.875 52.5 30.7898    0.0408718 -0.133686 0.990181    0.890625 0.9375
  v 48.75 52.5 30.9702    -0.0590239 -0.0219931 0.998014    0.90625 0.9375
  v 50.625 52.5 31.137    0.0542369 0.1494 0.987288    0.921875 0.9375
  v 52.5 52.5 30.7554    0.0439595 0.259344 0.964784    0.9375 0.9375
  v 54.375 52.5 30.8038    -0.0795756 0.181516 0.980163    0.953125 0.9375
  v 56.25 52.5 30.9993    0.068446 0.00734931 0.997628    0.96875 0.9375
  v 58.125 52.5 30.5725    0.110072 -0.0156995 0.9938    0.984375 0.9375
  v 60 52.5 30.5425    0.0479782 0.0383004 0.998114    1 0.9375
  v -60 54.375 31.4541    -0.0276934 0.213614 0.976526    0 0.953125
  v -58.125 54.375 31.3386    0.143021 -0.0150186 0.989606    0.015625 0.953125
  v -56.25 54.375 30.8318    0.263079 -0.203817 0.943    0.03125 0.953125
  v -54.375 54.375 30.3558    0.0909416 -0.146423 0.985033    0.046875 0.953125
  v -52.5 54.375 30.4878    -0.196542 0.0401263 0.979674    0.0625 0.953125
  v -50.625 54.375 30.9662    -0.19217 0.0400054 0.980546    0.078125 0.953125
  v -48.75 54.375 31.3431    -0.0309488 -0.047368 0.998398    0.09375 0.953125
  v -46.875 54.375 31.3297    0.115219 -0.0520396 0.991976    0.109375 0.953125
  v -45 54.375 30.9093    0.0709224 -0.02858 0.997072    0.125 0.953125
  v -43.125 54.375 30.8509    -0.0650137 -0.0564985 0.996284    0.140625 0.953125
  v -41.25 54.375 31.0899    0.0424281 -0.0479579 0.997948    0.15625 0.953125
  v -39.375 54.375 30.6256    0.243366 0.0484252 0.968725    0.171875 0.953125
  v -37.5 54.375 29.9117    0.207698 0.134668 0.968879    0.1875 0.953125
  v -35.625 54.375 29.7416    -0.0272905 0.168442 0.985334    0.203125 0.953125
  v -33.75 54.375 30.1035    -0.209104 0.129866 0.969232    0.21875 0.953125
  v -31.875 54.375 30.5778    -0.248301 0.0408551 0.967821    0.234375 0.953125
  v -30 54.375 31.1174    -0.0872549 -0.0263193 0.995838    0.25 0.953125
  v -28.125 54.375 31.0739    0.124853 -0.0275498 0.991793    0.265625 0.953125
  v -26.25 54.375 30.7674    0.105654 0.0470551 0.993289    0.28125 0.953125
  v -24.375 54.375 30.6775    -0.0347706 0.107499 0.993597    0.296875 0.953125
  v -22.5 54.375 30.6224    -0.0616714 -0.0198006 0.9979    0.3125 0.953125
  v -20.625 54.375 30.84    -0.0407941 -0.13639 0.989815    0.328125 0.953125
  v -18.75 54.375 31.0314    0.076921 -0.0637935 0.994994    0.34375 0.953125
  v -16.875 54.375 30.6167    0.160265 0.000372934 0.987074    0.359375 0.953125
  v -15 54.375 30.3097    -0.0146276 -0.0293533 0.999462    0.375 0.953125
  v -13.125 54.375 30.585    -0.159436 -0.0468336 0.986097    0.390625 0.953125
  v -11.25 54.375 30.9073    -0.152691 -0.030637 0.987799    0.40625 0.953125
  v -9.375 54.375 31.1846    0.0448142 -0.0276203 0.998613    0.421875 0.953125
  v -7.5 54.375 30.7766    0.198425 -0.0109302 0.980055    0.4375 0.953125
  v -5.625 54.375 30.5066    -0.0085171 0.0412352 0.999113    0.453125 0.953125
  v -3.75 54.375 30.7804    -0.104512 0.0125857 0.994444    0.46875 0.953125
  v -1.875 54.375 30.811    -0.0107901 -0.109014 0.993982    0.484375 0.953125
  v -1.23138e-023 54.375 30.8214    -0.00168767 -0.182403 0.983222    0.5 0.953125
  v 1.875 54.375 31.0471    -0.104857 -0.0889367 0.990502    0.515625 0.953125
  v 3.75 54.375 31.3233    -0.163839 0.0240855 0.986193    0.53125 0.953125
  v 5.625 54.375 31.5935    0.0191205 0.012311 0.999741    0.546875 0.953125
  v 7.5 54.375 31.1443    0.277749 -0.0917261 0.956265    0.5625 0.953125
  v 9.375 54.375 30.4917    0.223206 -0.10719 0.96886    0.578125 0.953125
  v 11.25 54.375 30.1476    0.101455 0.0150667 0.994726    0.59375 0.953125
  v 13.125 54.375 29.9392    0.00497005 0.15613 0.987724    0.609375 0.953125
  v 15 54.375 30.2012    -0.231598 0.172658 0.957367    0.625 0.953125
  v 16.875 54.375 31.0428    -0.299174 0.015169 0.954078    0.640625 0.953125
  v 18.75 54.375 31.5274    -0.0972738 -0.0963239 0.990585    0.65625 0.953125
  v 20.625 54.375 31.4275    0.187993 -0.0576831 0.980475    0.671875 0.953125
  v 22.5 54.375 30.6382    0.187008 -0.0101628 0.982306    0.6875 0.953125
  v 24.375 54.375 30.5891    -0.0933241 -0.0476819 0.994493    0.703125 0.953125
  v 26.25 54.375 31.1919    -0.112379 -0.0771654 0.990665    0.71875 0.953125
  v 28.125 54.375 31.1829    0.112615 -0.112705 0.987226    0.734375 0.953125
  v 30 54.375 30.6357    0.103026 -0.169048 0.980208    0.75 0.953125
  v 31.875 54.375 30.6819    -0.102366 -0.0901197 0.990656    0.765625 0.953125
  v 33.75 54.375 31.1044    -0.169707 0.0973881 0.980671    0.78125 0.953125
  v 35.625 54.375 31.3999    -0.0888217 0.114684 0.989423    0.796875 0.953125
  v 37.5 54.375 31.3812    0.0575422 -0.126209 0.990333    0.8125 0.953125
  v 39.375 54.375 31.0627    0.171767 -0.342315 0.923751    0.828125 0.953125
  v 41.25 54.375 30.785    0.0587887 -0.24352 0.968113    0.84375 0.953125
  v 43.125 54.375 30.963    -0.126655 0.0447303 0.990938    0.859375 0.953125
  v 45 54.375 31.1847    -0.0875913 0.109455 0.990125    0.875 0.953125
  v 46.875 54.375 31.2064    0.0149669 -0.0174936 0.999735    0.890625 0.953125
  v 48.75 54.375 31.245    0.048586 -0.0528817 0.997418    0.90625 0.953125
  v 50.625 54.375 30.9094    0.202734 -0.000215434 0.979234    0.921875 0.953125
  v 52.5 54.375 30.2422    0.107232 0.0840276 0.990677    0.9375 0.953125
  v 54.375 54.375 30.4563    -0.199272 0.116803 0.972958    0.953125 0.953125
  v 56.25 54.375 31.09    -0.0905948 0.0200874 0.995685    0.96875 0.953125
  v 58.125 54.375 30.9071    0.134508 -0.0580474 0.989211    0.984375 0.953125
  v 60 54.375 30.7693    0.0540907 -0.0545417 0.997045    1 0.953125
  v -60 56.25 30.5912    -0.210095 0.339603 0.916804    0 0.96875
  v -58.125 56.25 31.0201    -0.115529 0.255397 0.959909    0.015625 0.96875
  v -56.25 56.25 31.1388    0.0830014 0.00948564 0.996504    0.03125 0.96875
  v -54.375 56.25 30.7211    0.161978 -0.174936 0.971165    0.046875 0.96875
  v -52.5 56.25 30.4482    -0.0571478 -0.130774 0.989764    0.0625 0.96875
  v -50.625 56.25 30.8903    -0.16296 -0.000501293 0.986633    0.078125 0.96875
  v -48.75 56.25 31.2196    -0.00917851 0.115731 0.993238    0.09375 0.96875
  v -46.875 56.25 30.9805    0.155196 0.195784 0.968289    0.109375 0.96875
  v -45 56.25 30.5454    0.0320321 0.214951 0.976099    0.125 0.96875
  v -43.125 56.25 30.815    -0.15055 0.12275 0.980952    0.140625 0.96875
  v -41.25 56.25 31.1658    -0.0268919 -0.0132765 0.99955    0.15625 0.96875
  v -39.375 56.25 30.7436    0.231139 -0.165608 0.958722    0.171875 0.96875
  v -37.5 56.25 30.1311    0.238582 -0.239966 0.941007    0.1875 0.96875
  v -35.625 56.25 29.8685    0.0269304 -0.195393 0.980355    0.203125 0.96875
  v -33.75 56.25 30.0874    -0.225926 -0.109757 0.967942    0.21875 0.96875
  v -31.875 56.25 30.722    -0.277761 -0.0907251 0.956356    0.234375 0.96875
  v -30 56.25 31.3292    -0.0616506 -0.035413 0.997469    0.25 0.96875
  v -28.125 56.25 31.1101    0.186246 0.0602947 0.980651    0.265625 0.96875
  v -26.25 56.25 30.5749    0.186106 0.125297 0.974508    0.28125 0.96875
  v -24.375 56.25 30.2976    -0.0804427 0.151156 0.985231    0.296875 0.96875
  v -22.5 56.25 30.7586    -0.253963 0.017268 0.96706    0.3125 0.96875
  v -20.625 56.25 31.3908    -0.077719 -0.147919 0.985941    0.328125 0.96875
  v -18.75 56.25 31.1759    0.203993 -0.121762 0.971371    0.34375 0.96875
  v -16.875 56.25 30.4667    0.20916 -0.000996725 0.977881    0.359375 0.96875
  v -15 56.25 30.3558    -0.0536799 0.0628983 0.996575    0.375 0.96875
  v -13.125 56.25 30.8382    -0.183887 0.0580475 0.981232    0.390625 0.96875
  v -11.25 56.25 31.1294    -0.148576 0.0336858 0.988327    0.40625 0.96875
  v -9.375 56.25 31.3445    0.050715 0.0147138 0.998605    0.421875 0.96875
  v -7.5 56.25 30.8806    0.249327 0.0221496 0.968166    0.4375 0.96875
  v -5.625 56.25 30.3961    0.0472641 0.0949709 0.994357    0.453125 0.96875
  v -3.75 56.25 30.6619    -0.168096 0.125772 0.977714    0.46875 0.96875
  v -1.875 56.25 31.018    -0.139948 0.0465556 0.989064    0.484375 0.96875
  v -1.23138e-023 56.25 31.255    0.00555932 -0.0443253 0.999002    0.5 0.96875
  v 1.875 56.25 31.0772    0.0536145 0.0210828 0.998339    0.515625 0.96875
  v 3.75 56.25 30.9624    -0.0628287 0.160612 0.985016    0.53125 0.96875
  v 5.625 56.25 31.2442    -0.0357584 0.222031 0.974384    0.546875 0.96875
  v 7.5 56.25 31.1133    0.142041 0.13717 0.98031    0.5625 0.96875
  v 9.375 56.25 30.6763    0.144324 -0.0494578 0.988294    0.578125 0.96875
  v 11.25 56.25 30.428    0.142293 -0.199756 0.969459    0.59375 0.96875
  v 13.125 56.25 30.1143    0.146773 -0.171403 0.974207    0.609375 0.96875
  v 15 56.25 29.9712    -0.156397 0.0185851 0.987519    0.625 0.96875
  v 16.875 56.25 30.7398    -0.372377 0.132168 0.918622    0.640625 0.96875
  v 18.75 56.25 31.4569    -0.168503 0.0836946 0.982142    0.65625 0.96875
  v 20.625 56.25 31.4181    0.186417 0.00834687 0.982435    0.671875 0.96875
  v 22.5 56.25 30.6961    0.182535 -0.0289516 0.982773    0.6875 0.96875
  v 24.375 56.25 30.742    -0.0781921 -0.0166407 0.996799    0.703125 0.96875
  v 26.25 56.25 31.1074    -0.0639645 0.0708287 0.995435    0.71875 0.96875
  v 28.125 56.25 30.9478    0.0748744 0.137802 0.987626    0.734375 0.96875
  v 30 56.25 30.7776    0.0331452 0.094013 0.995019    0.75 0.96875
  v 31.875 56.25 30.9649    -0.000839482 0.0558953 0.998436    0.765625 0.96875
  v 33.75 56.25 30.8696    0.0156004 0.163612 0.986401    0.78125 0.96875
  v 35.625 56.25 30.7601    -0.112792 0.274356 0.954991    0.796875 0.96875
  v 37.5 56.25 31.1427    -0.215684 0.19371 0.957056    0.8125 0.96875
  v 39.375 56.25 31.6551    0.0115533 -0.0366767 0.99926    0.828125 0.96875
  v 41.25 56.25 31.3449    0.248382 -0.105063 0.962948    0.84375 0.96875
  v 43.125 56.25 30.7248    0.114919 0.0729425 0.990693    0.859375 0.96875
  v 45 56.25 30.6506    -0.0970232 0.194238 0.976145    0.875 0.96875
  v 46.875 56.25 30.9826    -0.088326 0.147281 0.985143    0.890625 0.96875
  v 48.75 56.25 31.0588    -0.0176372 0.0603096 0.998024    0.90625 0.96875
  v 50.625 56.25 30.9218    0.1642 -0.0745538 0.983606    0.921875 0.96875
  v 52.5 56.25 30.4002    0.175282 -0.12821 0.976134    0.9375 0.96875
  v 54.375 56.25 30.4234    -0.118153 0.0155506 0.992874    0.953125 0.96875
  v 56.25 56.25 31.009    -0.139951 0.1611 0.976965    0.96875 0.96875
  v 58.125 56.25 30.9873    0.126383 0.137873 0.982354    0.984375 0.96875
  v 60 56.25 30.5166    0.186137 0.106424 0.976743    1 0.96875
  v -60 58.125 29.9761    -0.154126 0.0299985 0.987596    0 0.984375
  v -58.125 58.125 30.4074    -0.183872 0.185402 0.965307    0.015625 0.984375
  v -56.25 58.125 30.8232    -0.130694 0.191642 0.972724    0.03125 0.984375
  v -54.375 58.125 30.9707    -0.0220624 0.00687378 0.999733    0.046875 0.984375
  v -52.5 58.125 30.9419    -0.0289434 -0.175977 0.983969    0.0625 0.984375
  v -50.625 58.125 31.1167    -0.00909771 -0.155546 0.987787    0.078125 0.984375
  v -48.75 58.125 30.9628    0.141172 0.0136995 0.98989    0.09375 0.984375
  v -46.875 58.125 30.4989    0.228222 0.149854 0.962008    0.109375 0.984375
  v -45 58.125 30.0433    0.0102115 0.19105 0.981527    0.125 0.984375
  v -43.125 58.125 30.4157    -0.231703 0.153839 0.960545    0.140625 0.984375
  v -41.25 58.125 30.978    -0.174929 0.107873 0.978654    0.15625 0.984375
  v -39.375 58.125 31.1652    0.0304886 -0.0381554 0.998807    0.171875 0.984375
  v -37.5 58.125 30.9676    0.168826 -0.219331 0.960933    0.1875 0.984375
  v -35.625 58.125 30.564    0.120216 -0.253179 0.959921    0.203125 0.984375
  v -33.75 58.125 30.5034    -0.150933 -0.16267 0.975068    0.21875 0.984375
  v -31.875 58.125 31.0836    -0.229049 -0.108221 0.96738    0.234375 0.984375
  v -30 58.125 31.4009    0.0647599 -0.025732 0.997569    0.25 0.984375
  v -28.125 58.125 30.8038    0.284738 0.115229 0.951655    0.265625 0.984375
  v -26.25 58.125 30.1912    0.206126 0.184333 0.961006    0.28125 0.984375
  v -24.375 58.125 29.9653    -0.110033 0.182055 0.977112    0.296875 0.984375
  v -22.5 58.125 30.6457    -0.362697 0.125517 0.923416    0.3125 0.984375
  v -20.625 58.125 31.5155    -0.175927 0.0572322 0.982738    0.328125 0.984375
  v -18.75 58.125 31.3836    0.226416 -0.0112942 0.973965    0.34375 0.984375
  v -16.875 58.125 30.6217    0.30335 -0.00681067 0.952855    0.359375 0.984375
  v -15 58.125 30.2312    0.0538955 0.106963 0.992801    0.375 0.984375
  v -13.125 58.125 30.4269    -0.14993 0.22728 0.962219    0.390625 0.984375
  v -11.25 58.125 30.7169    -0.198392 0.21281 0.95674    0.40625 0.984375
  v -9.375 58.125 31.0757    -0.0202979 0.0887401 0.995848    0.421875 0.984375
  v -7.5 58.125 30.7071    0.261925 -0.00418562 0.965079    0.4375 0.984375
  v -5.625 58.125 30.1119    0.137234 0.0547425 0.989025    0.453125 0.984375
  v -3.75 58.125 30.2714    -0.140771 0.168288 0.975634    0.46875 0.984375
  v -1.875 58.125 30.691    -0.206049 0.193343 0.959251    0.484375 0.984375
  v -1.23138e-023 58.125 31.0725    -0.068168 0.121803 0.990211    0.5 0.984375
  v 1.875 58.125 30.8797    0.0932965 0.0259095 0.995301    0.515625 0.984375
  v 3.75 58.125 30.632    0.0297593 0.0136954 0.999463    0.53125 0.984375
  v 5.625 58.125 30.7509    0.0211418 0.0931268 0.99543    0.546875 0.984375
  v 7.5 58.125 30.5926    0.0576143 0.167603 0.98417    0.5625 0.984375
  v 9.375 58.125 30.5501    -0.0673489 0.0999812 0.992707    0.578125 0.984375
  v 11.25 58.125 30.9133    -0.0213254 -0.1036 0.99439    0.59375 0.984375
  v 13.125 58.125 30.7298    0.184259 -0.247034 0.951327    0.609375 0.984375
  v 15 58.125 30.1277    0.0609095 -0.193889 0.979131    0.625 0.984375
  v 16.875 58.125 30.4679    -0.268382 0.0337937 0.96272    0.640625 0.984375
  v 18.75 58.125 31.2173    -0.23762 0.141688 0.960969    0.65625 0.984375
  v 20.625 58.125 31.368    0.0902128 0.0466841 0.994828    0.671875 0.984375
  v 22.5 58.125 30.7969    0.167566 -0.0680524 0.983509    0.6875 0.984375
  v 24.375 58.125 30.7646    -0.0300277 -0.0677504 0.99725    0.703125 0.984375
  v 26.25 58.125 30.883    0.0217997 -0.0145375 0.999657    0.71875 0.984375
  v 28.125 58.125 30.6134    0.135339 0.0595023 0.989011    0.734375 0.984375
  v 30 58.125 30.428    0.0168367 0.125095 0.992002    0.75 0.984375
  v 31.875 58.125 30.5545    0.00219961 0.123802 0.992304    0.765625 0.984375
  v 33.75 58.125 30.3289    0.103642 0.117655 0.987631    0.78125 0.984375
  v 35.625 58.125 30.137    -0.0787412 0.163299 0.983429    0.796875 0.984375
  v 37.5 58.125 30.6518    -0.294696 0.185762 0.937362    0.8125 0.984375
  v 39.375 58.125 31.4552    -0.112567 0.185753 0.976127    0.828125 0.984375
  v 41.25 58.125 31.2428    0.224694 0.122547 0.966693    0.84375 0.984375
  v 43.125 58.125 30.4593    0.184895 0.0297835 0.982307    0.859375 0.984375
  v 45 58.125 30.3157    -0.0652444 -0.0117187 0.997801    0.875 0.984375
  v 46.875 58.125 30.7104    -0.136378 0.00497565 0.990644    0.890625 0.984375
  v 48.75 58.125 30.8915    -0.115951 -0.00171884 0.993253    0.90625 0.984375
  v 50.625 58.125 31.1742    0.00725285 -0.109178 0.993996    0.921875 0.984375
  v 52.5 58.125 30.9308    0.208727 -0.200913 0.957114    0.9375 0.984375
  v 54.375 58.125 30.5332    0.131386 -0.0573544 0.989671    0.953125 0.984375
  v 56.25 58.125 30.4834    -0.00656557 0.193741 0.981031    0.96875 0.984375
  v 58.125 58.125 30.3618    0.0484201 0.217585 0.97484    0.984375 0.984375
  v 60 58.125 30.0712    0.181147 0.158021 0.970678    1 0.984375
  v -60 60 30.389    -0.0116673 -0.21502 0.97654    0 1
  v -58.125 60 30.4114    -0.0863363 -0.0737974 0.993529    0.015625 1
  v -56.25 60 30.45    -0.127045 0.128242 0.983572    0.03125 1
  v -54.375 60 30.7304    -0.148297 0.148274 0.977764    0.046875 1
  v -52.5 60 31.1587    -0.123747 -0.03516 0.991691    0.0625 1
  v -50.625 60 31.4671    -0.0203473 -0.160827 0.986773    0.078125 1
  v -48.75 60 31.0935    0.213404 -0.105687 0.971231    0.09375 1
  v -46.875 60 30.3659    0.301377 0.0238546 0.953207    0.109375 1
  v -45 60 29.7737    0.101276 0.118197 0.987812    0.125 1
  v -43.125 60 30.2412    -0.243074 0.105987 0.9642    0.140625 1
  v -41.25 60 30.8221    -0.226751 0.0838548 0.970336    0.15625 1
  v -39.375 60 31.0038    -0.079645 0.0845431 0.993232    0.171875 1
  v -37.5 60 31.0862    0.0561036 -0.0133659 0.998335    0.1875 1
  v -35.625 60 30.8847    0.145385 -0.13198 0.980533    0.203125 1
  v -33.75 60 30.6529    -0.0346499 -0.109412 0.993392    0.21875 1
  v -31.875 60 31.1503    -0.229126 -0.0487971 0.972173    0.234375 1
  v -30 60 31.4048    0.0359196 -0.0135478 0.999263    0.25 1
  v -28.125 60 30.5738    0.358757 0.0759813 0.930333    0.265625 1
  v -26.25 60 29.8286    0.26424 0.161954 0.950762    0.28125 1
  v -24.375 60 29.6073    -0.0392878 0.188194 0.981346    0.296875 1
  v -22.5 60 30.315    -0.368564 0.165795 0.914698    0.3125 1
  v -20.625 60 31.1978    -0.287688 0.162021 0.94392    0.328125 1
  v -18.75 60 31.2158    0.133677 0.114658 0.98437    0.34375 1
  v -16.875 60 30.5447    0.33733 0.0537381 0.939852    0.359375 1
  v -15 60 29.9562    0.187409 0.109392 0.976172    0.375 1
  v -13.125 60 29.8469    -0.0653714 0.245297 0.967241    0.390625 1
  v -11.25 60 30.1511    -0.223396 0.283804 0.932496    0.40625 1
  v -9.375 60 30.9232    -0.193636 0.145345 0.970247    0.421875 1
  v -7.5 60 30.9569    0.172107 -0.0585967 0.983334    0.4375 1
  v -5.625 60 30.2847    0.254971 -0.101462 0.961611    0.453125 1
  v -3.75 60 30.0473    -0.0232974 0.0489005 0.998532    0.46875 1
  v -1.875 60 30.2565    -0.185678 0.18657 0.964736    0.484375 1
  v -1.23138e-023 60 30.7163    -0.173659 0.196532 0.964996    0.5 1
  v 1.875 60 30.8918    0.00331172 0.058055 0.998308    0.515625 1
  v 3.75 60 30.8934    0.0369027 -0.0942018 0.994869    0.53125 1
  v 5.625 60 30.9287    0.0492894 -0.108983 0.992821    0.546875 1
  v 7.5 60 30.4871    0.12709 0.00671011 0.991868    0.5625 1
  v 9.375 60 30.361    -0.0667889 0.085269 0.994117    0.578125 1
  v 11.25 60 30.9263    -0.181325 0.027657 0.983034    0.59375 1
  v 13.125 60 31.0455    0.0671955 -0.112785 0.991345    0.609375 1
  v 15 60 30.7225    0.171871 -0.253428 0.951963    0.625 1
  v 16.875 60 30.6205    -0.0844386 -0.155748 0.984181    0.640625 1
  v 18.75 60 30.8565    -0.221353 0.095225 0.970533    0.65625 1
  v 20.625 60 31.1761    -0.0517786 0.130578 0.990085    0.671875 1
  v 22.5 60 31.005    0.134422 -0.0386219 0.990171    0.6875 1
  v 24.375 60 30.9704    -0.0095337 -0.10949 0.993942    0.703125 1
  v 26.25 60 31.0914    0.0116659 -0.109991 0.993864    0.71875 1
  v 28.125 60 30.7827    0.18266 -0.0951849 0.978558    0.734375 1
  v 30 60 30.3087    0.0983646 0.0132643 0.995062    0.75 1
  v 31.875 60 30.4031    -0.0366364 0.0747819 0.996527    0.765625 1
  v 33.75 60 30.3892    0.0861023 0.00560662 0.99627    0.78125 1
  v 35.625 60 30.1417    0.0110438 -0.0124167 0.999862    0.796875 1
  v 37.5 60 30.5242    -0.24698 0.0428093 0.968075    0.8125 1
  v 39.375 60 31.064    -0.173982 0.156526 0.972229    0.828125 1
  v 41.25 60 30.76    0.148012 0.231822 0.961432    0.84375 1
  v 43.125 60 30.4099    0.141398 0.101702 0.984715    0.859375 1
  v 45 60 30.6988    -0.0818543 -0.125156 0.988755    0.875 1
  v 46.875 60 31.0194    -0.135839 -0.173506 0.97542    0.890625 1
  v 48.75 60 31.0914    -0.0990267 -0.124385 0.98728    0.90625 1
  v 50.625 60 31.4031    -0.0992205 -0.115576 0.988331    0.921875 1
  v 52.5 60 31.3759    0.157536 -0.191417 0.968784    0.9375 1
  v 54.375 60 30.7065    0.288389 -0.132216 0.948341    0.953125 1
  v 56.25 60 30.0545    0.144358 0.121859 0.981993    0.96875 1
  v 58.125 60 29.9168    -0.00458504 0.228257 0.97359    0.984375 1
  v 60 60 30.2053    0.00240232 0.0807519 0.996731    1 1
  t 65 0 66
  t 1 66 0
  t 66 1 67
  t 2 67 1
  t 67 2 68
  t 3 68 2
  t 68 3 69
  t 4 69 3
  t 69 4 70
  t 5 70 4
  t 70 5 71
  t 6 71 5
  t 71 6 72
  t 7 72 6
  t 72 7 73
  t 8 73 7
  t 73 8 74
  t 9 74 8
  t 74 9 75
  t 10 75 9
  t 75 10 76
  t 11 76 10
  t 76 11 77
  t 12 77 11
  t 77 12 78
  t 13 78 12
  t 78 13 79
  t 14 79 13
  t 79 14 80
  t 15 80 14
  t 80 15 81
  t 16 81 15
  t 81 16 82
  t 17 82 16
  t 82 17 83
  t 18 83 17
  t 83 18 84
  t 19 84 18
  t 84 19 85
  t 20 85 19
  t 85 20 86
  t 21 86 20
  t 86 21 87
  t 22 87 21
  t 87 22 88
  t 23 88 22
  t 88 23 89
  t 24 89 23
  t 89 24 90
  t 25 90 24
  t 90 25 91
  t 26 91 25
  t 91 26 92
  t 27 92 26
  t 92 27 93
  t 28 93 27
  t 93 28 94
  t 29 94 28
  t 94 29 95
  t 30 95 29
  t 95 30 96
  t 31 96 30
  t 96 31 97
  t 32 97 31
  t 97 32 98
  t 33 98 32
  t 98 33 99
  t 34 99 33
  t 99 34 100
  t 35 100 34
  t 100 35 101
  t 36 101 35
  t 101 36 102
  t 37 102 36
  t 102 37 103
  t 38 103 37
  t 103 38 104
  t 39 104 38
  t 104 39 105
  t 40 105 39
  t 105 40 106
  t 41 106 40
  t 106 41 107
  t 42 107 41
  t 107 42 108
  t 43 108 42
  t 108 43 109
  t 44 109 43
  t 109 44 110
  t 45 110 44
  t 110 45 111
  t 46 111 45
  t 111 46 112
  t 47 112 46
  t 112 47 113
  t 48 113 47
  t 113 48 114
  t 49 114 48
  t 114 49 115
  t 50 115 49
  t 115 50 116
  t 51 116 50
  t 116 51 117
  t 52 117 51
  t 117 52 118
  t 53 118 52
  t 118 53 119
  t 54 119 53
  t 119 54 120
  t 55 120 54
  t 120 55 121
  t 56 121 55
  t 121 56 122
  t 57 122 56
  t 122 57 123
  t 58 123 57
  t 123 58 124
  t 59 124 58
  t 124 59 125
  t 60 125 59
  t 125 60 126
  t 61 126 60
  t 126 61 127
  t 62 127 61
  t 127 62 128
  t 63 128 62
  t 128 63 129
  t 64 129 63
  t 130 65 131
  t 66 131 65
  t 131 66 132
  t 67 132 66
  t 132 67 133
  t 68 133 67
  t 133 68 134
  t 69 134 68
  t 134 69 135
  t 70 135 69
  t 135 70 136
  t 71 136 70
  t 136 71 137
  t 72 137 71
  t 137 72 138
  t 73 138 72
  t 138 73 139
  t 74 139 73
  t 139 74 140
  t 75 140 74
  t 140 75 141
  t 76 141 75
  t 141 76 142
  t 77 142 76
  t 142 77 143
  t 78 143 77
  t 143 78 144
  t 79 144 78
  t 144 79 145
  t 80 145 79
  t 145 80 146
  t 81 146 80
  t 146 81 147
  t 82 147 81
  t 147 82 148
  t 83 148 82
  t 148 83 149
  t 84 149 83
  t 149 84 150
  t 85 150 84
  t 150 85 151
  t 86 151 85
  t 151 86 152
  t 87 152 86
  t 152 87 153
  t 88 153 87
  t 153 88 154
  t 89 154 88
  t 154 89 155
  t 90 155 89
  t 155 90 156
  t 91 156 90
  t 156 91 157
  t 92 157 91
  t 157 92 158
  t 93 158 92
  t 158 93 159
  t 94 159 93
  t 159 94 160
  t 95 160 94
  t 160 95 161
  t 96 161 95
  t 161 96 162
  t 97 162 96
  t 162 97 163
  t 98 163 97
  t 163 98 164
  t 99 164 98
  t 164 99 165
  t 100 165 99
  t 165 100 166
  t 101 166 100
  t 166 101 167
  t 102 167 101
  t 167 102 168
  t 103 168 102
  t 168 103 169
  t 104 169 103
  t 169 104 170
  t 105 170 104
  t 170 105 171
  t 106 171 105
  t 171 106 172
  t 107 172 106
  t 172 107 173
  t 108 173 107
  t 173 108 174
  t 109 174 108
  t 174 109 175
  t 110 175 109
  t 175 110 176
  t 111 176 110
  t 176 111 177
  t 112 177 111
  t 177 112 178
  t 113 178 112
  t 178 113 179
  t 114 179 113
  t 179 114 180
  t 115 180 114
  t 180 115 181
  t 116 181 115
  t 181 116 182
  t 117 182 116
  t 182 117 183
  t 118 183 117
  t 183 118 184
  t 119 184 118
  t 184 119 185
  t 120 185 119
  t 185 120 186
  t 121 186 120
  t 186 121 187
  t 122 187 121
  t 187 122 188
  t 123 188 122
  t 188 123 189
  t 124 189 123
  t 189 124 190
  t 125 190 124
  t 190 125 191
  t 126 191 125
  t 191 126 192
  t 127 192 126
  t 192 127 193
  t 128 193 127
  t 193 128 194
  t 129 194 128
  t 195 130 196
  t 131 196 130
  t 196 131 197
  t 132 197 131
  t 197 132 198
  t 133 198 132
  t 198 133 199
  t 134 199 133
  t 199 134 200
  t 135 200 134
  t 200 135 201
  t 136 201 135
  t 201 136 202
  t 137 202 136
  t 202 137 203
  t 138 203 137
  t 203 138 204
  t 139 204 138
  t 204 139 205
  t 140 205 139
  t 205 140 206
  t 141 206 140
  t 206 141 207
  t 142 207 141
  t 207 142 208
  t 143 208 142
  t 208 143 209
  t 144 209 143
  t 209 144 210
  t 145 210 144
  t 210 145 211
  t 146 211 145
  t 211 146 212
  t 147 212 146
  t 212 147 213
  t 148 213 147
  t 213 148 214
  t 149 214 148
  t 214 149 215
  t 150 215 149
  t 215 150 216
  t 151 216 150
  t 216 151 217
  t 152 217 151
  t 217 152 218
  t 153 218 152
  t 218 153 219
  t 154 219 153
  t 219 154 220
  t 155 220 154
  t 220 155 221
  t 156 221 155
  t 221 156 222
  t 157 222 156
  t 222 157 223
  t 158 223 157
  t 223 158 224
  t 159 224 158
  t 224 159 225
  t 160 225 159
  t 225 160 226
  t 161 226 160
  t 226 161 227
  t 162 227 161
  t 227 162 228
  t 163 228 162
  t 228 163 229
  t 164 229 163
  t 229 164 230
  t 165 230 164
  t 230 165 231
  t 166 231 165
  t 231 166 232
  t 167 232 166
  t 232 167 233
  t 168 233 167
  t 233 168 234
  t 169 234 168
  t 234 169 235
  t 170 235 169
  t 235 170 236
  t 171 236 170
  t 236 171 237
  t 172 237 171
  t 237 172 238
  t 173 238 172
  t 238 173 239
  t 174 239 173
  t 239 174 240
  t 175 240 174
  t 240 175 241
  t 176 241 175
  t 241 176 242
  t 177 242 176
  t 242 177 243
  t 178 243 177
  t 243 178 244
  t 179 244 178
  t 244 179 245
  t 180 245 179
  t 245 180 246
  t 181 246 180
  t 246 181 247
  t 182 247 181
  t 247 182 248
  t 183 248 182
  t 248 183 249
  t 184 249 183
  t 249 184 250
  t 185 250 184
  t 250 185 251
  t 186 251 185
  t 251 186 252
  t 187 252 186
  t 252 187 253
  t 188 253 187
  t 253 188 254
  t 189 254 188
  t 254 189 255
  t 190 255 189
  t 255 190 256
  t 191 256 190
  t 256 191 257
  t 192 257 191
  t 257 192 258
  t 193 258 192
  t 258 193 259
  t 194 259 193
  t 260 195 261
  t 196 261 195
  t 261 196 262
  t 197 262 196
  t 262 197 263
  t 198 263 197
  t 263 198 264
  t 199 264 198
  t 264 199 265
  t 200 265 199
  t 265 200 266
  t 201 266 200
  t 266 201 267
  t 202 267 201
  t 267 202 268
  t 203 268 202
  t 268 203 269
  t 204 269 203
  t 269 204 270
  t 205 270 204
  t 270 205 271
  t 206 271 205
  t 271 206 272
  t 207 272 206
  t 272 207 273
  t 208 273 207
  t 273 208 274
  t 209 274 208
  t 274 209 275
  t 210 275 209
  t 275 210 276
  t 211 276 210
  t 276 211 277
  t 212 277 211
  t 277 212 278
  t 213 278 212
  t 278 213 279
  t 214 279 213
  t 279 214 280
  t 215 280 214
  t 280 215 281
  t 216 281 215
  t 281 216 282
  t 217 282 216
  t 282 217 283
  t 218 283 217
  t 283 218 284
  t 219 284 218
  t 284 219 285
  t 220 285 219
  t 285 220 286
  t 221 286 220
  t 286 221 287
  t 222 287 221
  t 287 222 288
  t 223 288 222
  t 288 223 289
  t 224 289 223
  t 289 224 290
  t 225 290 224
  t 290 225 291
  t 226 291 225
  t 291 226 292
  t 227 292 226
  t 292 227 293
  t 228 293 227
  t 293 228 294
  t 229 294 228
  t 294 229 295
  t 230 295 229
  t 295 230 296
  t 231 296 230
  t 296 231 297
  t 232 297 231
  t 297 232 298
  t 233 298 232
  t 298 233 299
  t 234 299 233
  t 299 234 300
  t 235 300 234
  t 300 235 301
  t 236 301 235
  t 301 236 302
  t 237 302 236
  t 302 237 303
  t 238 303 237
  t 303 238 304
  t 239 304 238
  t 304 239 305
  t 240 305 239
  t 305 240 306
  t 241 306 240
  t 306 241 307
  t 242 307 241
  t 307 242 308
  t 243 308 242
  t 308 243 309
  t 244 309 243
  t 309 244 310
  t 245 310 244
  t 310 245 311
  t 246 311 245
  t 311 246 312
  t 247 312 246
  t 312 247 313
  t 248 313 247
  t 313 248 314
  t 249 314 248
  t 314 249 315
  t 250 315 249
  t 315 250 316
  t 251 316 250
  t 316 251 317
  t 252 317 251
  t 317 252 318
  t 253 318 252
  t 318 253 319
  t 254 319 253
  t 319 254 320
  t 255 320 254
  t 320 255 321
  t 256 321 255
  t 321 256 322
  t 257 322 256
  t 322 257 323
  t 258 323 257
  t 323 258 324
  t 259 324 258
  t 325 260 326
  t 261 326 260
  t 326 261 327
  t 262 327 261
  t 327 262 328
  t 263 328 262
  t 328 263 329
  t 264 329 263
  t 329 264 330
  t 265 330 264
  t 330 265 331
  t 266 331 265
  t 331 266 332
  t 267 332 266
  t 332 267 333
  t 268 333 267
  t 333 268 334
  t 269 334 268
  t 334 269 335
  t 270 335 269
  t 335 270 336
  t 271 336 270
  t 336 271 337
  t 272 337 271
  t 337 272 338
  t 273 338 272
  t 338 273 339
  t 274 339 273
  t 339 274 340
  t 275 340 274
  t 340 275 341
  t 276 341 275
  t 341 276 342
  t 277 342 276
  t 342 277 343
  t 278 343 277
  t 343 278 344
  t 279 344 278
  t 344 279 345
  t 280 345 279
  t 345 280 346
  t 281 346 280
  t 346 281 347
  t 282 347 281
  t 347 282 348
  t 283 348 282
  t 348 283 349
  t 284 349 283
  t 349 284 350
  t 285 350 284
  t 350 285 351
  t 286 351 285
  t 351 286 352
  t 287 352 286
  t 352 287 353
  t 288 353 287
  t 353 288 354
  t 289 354 288
  t 354 289 355
  t 290 355 289
  t 355 290 356
  t 291 356 290
  t 356 291 357
  t 292 357 291
  t 357 292 358
  t 293 358 292
  t 358 293 359
  t 294 359 293
  t 359 294 360
  t 295 360 294
  t 360 295 361
  t 296 361 295
  t 361 296 362
  t 297 362 296
  t 362 297 363
  t 298 363 297
  t 363 298 364
  t 299 364 298
  t 364 299 365
  t 300 365 299
  t 365 300 366
  t 301 366 300
  t 366 301 367
  t 302 367 301
  t 367 302 368
  t 303 368 302
  t 368 303 369
  t 304 369 303
  t 369 304 370
  t 305 370 304
  t 370 305 371
  t 306 371 305
  t 371 306 372
  t 307 372 306
  t 372 307 373
  t 308 373 307
  t 373 308 374
  t 309 374 308
  t 374 309 375
  t 310 375 309
  t 375 310 376
  t 311 376 310
  t 376 311 377
  t 312 377 311
  t 377 312 378
  t 313 378 312
  t 378 313 379
  t 314 379 313
  t 379 314 380
  t 315 380 314
  t 380 315 381
  t 316 381 315
  t 381 316 382
  t 317 382 316
  t 382 317 383
  t 318 383 317
  t 383 318 384
  t 319 384 318
  t 384 319 385
  t 320 385 319
  t 385 320 386
  t 321 386 320
  t 386 321 387
  t 322 387 321
  t 387 322 388
  t 323 388 322
  t 388 323 389
  t 324 389 323
  t 390 325 391
  t 326 391 325
  t 391 326 392
  t 327 392 326
  t 392 327 393
  t 328 393 327
  t 393 328 394
  t 329 394 328
  t 394 329 395
  t 330 395 329
  t 395 330 396
  t 331 396 330
  t 396 331 397
  t 332 397 331
  t 397 332 398
  t 333 398 332
  t 398 333 399
  t 334 399 333
  t 399 334 400
  t 335 400 334
  t 400 335 401
  t 336 401 335
  t 401 336 402
  t 337 402 336
  t 402 337 403
  t 338 403 337
  t 403 338 404
  t 339 404 338
  t 404 339 405
  t 340 405 339
  t 405 340 406
  t 341 406 340
  t 406 341 407
  t 342 407 341
  t 407 342 408
  t 343 408 342
  t 408 343 409
  t 344 409 343
  t 409 344 410
  t 345 410 344
  t 410 345 411
  t 346 411 345
  t 411 346 412
  t 347 412 346
  t 412 347 413
  t 348 413 347
  t 413 348 414
  t 349 414 348
  t 414 349 415
  t 350 415 349
  t 415 350 416
  t 351 416 350
  t 416 351 417
  t 352 417 351
  t 417 352 418
  t 353 418 352
  t 418 353 419
  t 354 419 353
  t 419 354 420
  t 355 420 354
  t 420 355 421
  t 356 421 355
  t 421 356 422
  t 357 422 356
  t 422 357 423
  t 358 423 357
  t 423 358 424
  t 359 424 358
  t 424 359 425
  t 360 425 359
  t 425 360 426
  t 361 426 360
  t 426 361 427
  t 362 427 361
  t 427 362 428
  t 363 428 362
  t 428 363 429
  t 364 429 363
  t 429 364 430
  t 365 430 364
  t 430 365 431
  t 366 431 365
  t 431 366 432
  t 367 432 366
  t 432 367 433
  t 368 433 367
  t 433 368 434
  t 369 434 368
  t 434 369 435
  t 370 435 369
  t 435 370 436
  t 371 436 370
  t 436 371 437
  t 372 437 371
  t 437 372 438
  t 373 438 372
  t 438 373 439
  t 374 439 373
  t 439 374 440
  t 375 440 374
  t 440 375 441
  t 376 441 375
  t 441 376 442
  t 377 442 376
  t 442 377 443
  t 378 443 377
  t 443 378 444
  t 379 444 378
  t 444 379 445
  t 380 445 379
  t 445 380 446
  t 381 446 380
  t 446 381 447
  t 382 447 381
  t 447 382 448
  t 383 448 382
  t 448 383 449
  t 384 449 383
  t 449 384 450
  t 385 450 384
  t 450 385 451
  t 386 451 385
  t 451 386 452
  t 387 452 386
  t 452 387 453
  t 388 453 387
  t 453 388 454
  t 389 454 388
  t 455 390 456
  t 391 456 390
  t 456 391 457
  t 392 457 391
  t 457 392 458
  t 393 458 392
  t 458 393 459
  t 394 459 393
  t 459 394 460
  t 395 460 394
  t 460 395 461
  t 396 461 395
  t 461 396 462
  t 397 462 396
  t 462 397 463
  t 398 463 397
  t 463 398 464
  t 399 464 398
  t 464 399 465
  t 400 465 399
  t 465 400 466
  t 401 466 400
  t 466 401 467
  t 402 467 401
  t 467 402 468
  t 403 468 402
  t 468 403 469
  t 404 469 403
  t 469 404 470
  t 405 470 404
  t 470 405 471
  t 406 471 405
  t 471 406 472
  t 407 472 406
  t 472 407 473
  t 408 473 407
  t 473 408 474
  t 409 474 408
  t 474 409 475
  t 410 475 409
  t 475 410 476
  t 411 476 410
  t 476 411 477
  t 412 477 411
  t 477 412 478
  t 413 478 412
  t 478 413 479
  t 414 479 413
  t 479 414 480
  t 415 480 414
  t 480 415 481
  t 416 481 415
  t 481 416 482
  t 417 482 416
  t 482 417 483
  t 418 483 417
  t 483 418 484
  t 419 484 418
  t 484 419 485
  t 420 485 419
  t 485 420 486
  t 421 486 420
  t 486 421 487
  t 422 487 421
  t 487 422 488
  t 423 488 422
  t 488 423 489
  t 424 489 423
  t 489 424 490
  t 425 490 424
  t 490 425 491
  t 426 491 425
  t 491 426 492
  t 427 492 426
  t 492 427 493
  t 428 493 427
  t 493 428 494
  t 429 494 428
  t 494 429 495
  t 430 495 429
  t 495 430 496
  t 431 496 430
  t 496 431 497
  t 432 497 431
  t 497 432 498
  t 433 498 432
  t 498 433 499
  t 434 499 433
  t 499 434 500
  t 435 500 434
  t 500 435 501
  t 436 501 435
  t 501 436 502
  t 437 502 436
  t 502 437 503
  t 438 503 437
  t 503 438 504
  t 439 504 438
  t 504 439 505
  t 440 505 439
  t 505 440 506
  t 441 506 440
  t 506 441 507
  t 442 507 441
  t 507 442 508
  t 443 508 442
  t 508 443 509
  t 444 509 443
  t 509 444 510
  t 445 510 444
  t 510 445 511
  t 446 511 445
  t 511 446 512
  t 447 512 446
  t 512 447 513
  t 448 513 447
  t 513 448 514
  t 449 514 448
  t 514 449 515
  t 450 515 449
  t 515 450 516
  t 451 516 450
  t 516 451 517
  t 452 517 451
  t 517 452 518
  t 453 518 452
  t 518 453 519
  t 454 519 453
  t 520 455 521
  t 456 521 455
  t 521 456 522
  t 457 522 456
  t 522 457 523
  t 458 523 457
  t 523 458 524
  t 459 524 458
  t 524 459 525
  t 460 525 459
  t 525 460 526
  t 461 526 460
  t 526 461 527
  t 462 527 461
  t 527 462 528
  t 463 528 462
  t 528 463 529
  t 464 529 463
  t 529 464 530
  t 465 530 464
  t 530 465 531
  t 466 531 465
  t 531 466 532
  t 467 532 466
  t 532 467 533
  t 468 533 467
  t 533 468 534
  t 469 534 468
  t 534 469 535
  t 470 535 469
  t 535 470 536
  t 471 536 470
  t 536 471 537
  t 472 537 471
  t 537 472 538
  t 473 538 472
  t 538 473 539
  t 474 539 473
  t 539 474 540
  t 475 540 474
  t 540 475 541
  t 476 541 475
  t 541 476 542
  t 477 542 476
  t 542 477 543
  t 478 543 477
  t 543 478 544
  t 479 544 478
  t 544 479 545
  t 480 545 479
  t 545 480 546
  t 481 546 480
  t 546 481 547
  t 482 547 481
  t 547 482 548
  t 483 548 482
  t 548 483 549
  t 484 549 483
  t 549 484 550
  t 485 550 484
  t 550 485 551
  t 486 551 485
  t 551 486 552
  t 487 552 486
  t 552 487 553
  t 488 553 487
  t 553 488 554
  t 489 554 488
  t 554 489 555
  t 490 555 489
  t 555 490 556
  t 491 556 490
  t 556 491 557
  t 492 557 491
  t 557 492 558
  t 493 558 492
  t 558 493 559
  t 494 559 493
  t 559 494 560
  t 495 560 494
  t 560 495 561
  t 496 561 495
  t 561 496 562
  t 497 562 496
  t 562 497 563
  t 498 563 497
  t 563 498 564
  t 499 564 498
  t 564 499 565
  t 500 565 499
  t 565 500 566
  t 501 566 500
  t 566 501 567
  t 502 567 501
  t 567 502 568
  t 503 568 502
  t 568 503 569
  t 504 569 503
  t 569 504 570
  t 505 570 504
  t 570 505 571
  t 506 571 505
  t 571 506 572
  t 507 572 506
  t 572 507 573
  t 508 573 507
  t 573 508 574
  t 509 574 508
  t 574 509 575
  t 510 575 509
  t 575 510 576
  t 511 576 510
  t 576 511 577
  t 512 577 511
  t 577 512 578
  t 513 578 512
  t 578 513 579
  t 514 579 513
  t 579 514 580
  t 515 580 514
  t 580 515 581
  t 516 581 515
  t 581 516 582
  t 517 582 516
  t 582 517 583
  t 518 583 517
  t 583 518 584
  t 519 584 518
  t 585 520 586
  t 521 586 520
  t 586 521 587
  t 522 587 521
  t 587 522 588
  t 523 588 522
  t 588 523 589
  t 524 589 523
  t 589 524 590
  t 525 590 524
  t 590 525 591
  t 526 591 525
  t 591 526 592
  t 527 592 526
  t 592 527 593
  t 528 593 527
  t 593 528 594
  t 529 594 528
  t 594 529 595
  t 530 595 529
  t 595 530 596
  t 531 596 530
  t 596 531 597
  t 532 597 531
  t 597 532 598
  t 533 598 532
  t 598 533 599
  t 534 599 533
  t 599 534 600
  t 535 600 534
  t 600 535 601
  t 536 601 535
  t 601 536 602
  t 537 602 536
  t 602 537 603
  t 538 603 537
  t 603 538 604
  t 539 604 538
  t 604 539 605
  t 540 605 539
  t 605 540 606
  t 541 606 540
  t 606 541 607
  t 542 607 541
  t 607 542 608
  t 543 608 542
  t 608 543 609
  t 544 609 543
  t 609 544 610
  t 545 610 544
  t 610 545 611
  t 546 611 545
  t 611 546 612
  t 547 612 546
  t 612 547 613
  t 548 613 547
  t 613 548 614
  t 549 614 548
  t 614 549 615
  t 550 615 549
  t 615 550 616
  t 551 616 550
  t 616 551 617
  t 552 617 551
  t 617 552 618
  t 553 618 552
  t 618 553 619
  t 554 619 553
  t 619 554 620
  t 555 620 554
  t 620 555 621
  t 556 621 555
  t 621 556 622
  t 557 622 556
  t 622 557 623
  t 558 623 557
  t 623 558 624
  t 559 624 558
  t 624 559 625
  t 560 625 559
  t 625 560 626
  t 561 626 560
  t 626 561 627
  t 562 627 561
  t 627 562 628
  t 563 628 562
  t 628 563 629
  t 564 629 563
  t 629 564 630
  t 565 630 564
  t 630 565 631
  t 566 631 565
  t 631 566 632
  t 567 632 566
  t 632 567 633
  t 568 633 567
  t 633 568 634
  t 569 634 568
  t 634 569 635
  t 570 635 569
  t 635 570 636
  t 571 636 570
  t 636 571 637
  t 572 637 571
  t 637 572 638
  t 573 638 572
  t 638 573 639
  t 574 639 573
  t 639 574 640
  t 575 640 574
  t 640 575 641
  t 576 641 575
  t 641 576 642
  t 577 642 576
  t 642 577 643
  t 578 643 577
  t 643 578 644
  t 579 644 578
  t 644 579 645
  t 580 645 579
  t 645 580 646
  t 581 646 580
  t 646 581 647
  t 582 647 581
  t 647 582 648
  t 583 648 582
  t 648 583 649
  t 584 649 583
  t 650 585 651
  t 586 651 585
  t 651 586 652
  t 587 652 586
  t 652 587 653
  t 588 653 587
  t 653 588 654
  t 589 654 588
  t 654 589 655
  t 590 655 589
  t 655 590 656
  t 591 656 590
  t 656 591 657
  t 592 657 591
  t 657 592 658
  t 593 658 592
  t 658 593 659
  t 594 659 593
  t 659 594 660
  t 595 660 594
  t 660 595 661
  t 596 661 595
  t 661 596 662
  t 597 662 596
  t 662 597 663
  t 598 663 597
  t 663 598 664
  t 599 664 598
  t 664 599 665
  t 600 665 599
  t 665 600 666
  t 601 666 600
  t 666 601 667
  t 602 667 601
  t 667 602 668
  t 603 668 602
  t 668 603 669
  t 604 669 603
  t 669 604 670
  t 605 670 604
  t 670 605 671
  t 606 671 605
  t 671 606 672
  t 607 672 606
  t 672 607 673
  t 608 673 607
  t 673 608 674
  t 609 674 608
  t 674 609 675
  t 610 675 609
  t 675 610 676
  t 611 676 610
  t 676 611 677
  t 612 677 611
  t 677 612 678
  t 613 678 612
  t 678 613 679
  t 614 679 613
  t 679 614 680
  t 615 680 614
  t 680 615 681
  t 616 681 615
  t 681 616 682
  t 617 682 616
  t 682 617 683
  t 618 683 617
  t 683 618 684
  t 619 684 618
  t 684 619 685
  t 620 685 619
  t 685 620 686
  t 621 686 620
  t 686 621 687
  t 622 687 621
  t 687 622 688
  t 623 688 622
  t 688 623 689
  t 624 689 623
  t 689 624 690
  t 625 690 624
  t 690 625 691
  t 626 691 625
  t 691 626 692
  t 627 692 626
  t 692 627 693
  t 628 693 627
  t 693 628 694
  t 629 694 628
  t 694 629 695
  t 630 695 629
  t 695 630 696
  t 631 696 630
  t 696 631 697
  t 632 697 631
  t 697 632 698
  t 633 698 632
  t 698 633 699
  t 634 699 633
  t 699 634 700
  t 635 700 634
  t 700 635 701
  t 636 701 635
  t 701 636 702
  t 637 702 636
  t 702 637 703
  t 638 703 637
  t 703 638 704
  t 639 704 638
  t 704 639 705
  t 640 705 639
  t 705 640 706
  t 641 706 640
  t 706 641 707
  t 642 707 641
  t 707 642 708
  t 643 708 642
  t 708 643 709
  t 644 709 643
  t 709 644 710
  t 645 710 644
  t 710 645 711
  t 646 711 645
  t 711 646 712
  t 647 712 646
  t 712 647 713
  t 648 713 647
  t 713 648 714
  t 649 714 648
  t 715 650 716
  t 651 716 650
  t 716 651 717
  t 652 717 651
  t 717 652 718
  t 653 718 652
  t 718 653 719
  t 654 719 653
  t 719 654 720
  t 655 720 654
  t 720 655 721
  t 656 721 655
  t 721 656 722
  t 657 722 656
  t 722 657 723
  t 658 723 657
  t 723 658 724
  t 659 724 658
  t 724 659 725
  t 660 725 659
  t 725 660 726
  t 661 726 660
  t 726 661 727
  t 662 727 661
  t 727 662 728
  t 663 728 662
  t 728 663 729
  t 664 729 663
  t 729 664 730
  t 665 730 664
  t 730 665 731
  t 666 731 665
  t 731 666 732
  t 667 732 666
  t 732 667 733
  t 668 733 667
  t 733 668 734
  t 669 734 668
  t 734 669 735
  t 670 735 669
  t 735 670 736
  t 671 736 670
  t 736 671 737
  t 672 737 671
  t 737 672 738
  t 673 738 672
  t 738 673 739
  t 674 739 673
  t 739 674 740
  t 675 740 674
  t 740 675 741
  t 676 741 675
  t 741 676 742
  t 677 742 676
  t 742 677 743
  t 678 743 677
  t 743 678 744
  t 679 744 678
  t 744 679 745
  t 680 745 679
  t 745 680 746
  t 681 746 680
  t 746 681 747
  t 682 747 681
  t 747 682 748
  t 683 748 682
  t 748 683 749
  t 684 749 683
  t 749 684 750
  t 685 750 684
  t 750 685 751
  t 686 751 685
  t 751 686 752
  t 687 752 686
  t 752 687 753
  t 688 753 687
  t 753 688 754
  t 689 754 688
  t 754 689 755
  t 690 755 689
  t 755 690 756
  t 691 756 690
  t 756 691 757
  t 692 757 691
  t 757 692 758
  t 693 758 692
  t 758 693 759
  t 694 759 693
  t 759 694 760
  t 695 760 694
  t 760 695 761
  t 696 761 695
  t 761 696 762
  t 697 762 696
  t 762 697 763
  t 698 763 697
  t 763 698 764
  t 699 764 698
  t 764 699 765
  t 700 765 699
  t 765 700 766
  t 701 766 700
  t 766 701 767
  t 702 767 701
  t 767 702 768
  t 703 768 702
  t 768 703 769
  t 704 769 703
  t 769 704 770
  t 705 770 704
  t 770 705 771
  t 706 771 705
  t 771 706 772
  t 707 772 706
  t 772 707 773
  t 708 773 707
  t 773 708 774
  t 709 774 708
  t 774 709 775
  t 710 775 709
  t 775 710 776
  t 711 776 710
  t 776 711 777
  t 712 777 711
  t 777 712 778
  t 713 778 712
  t 778 713 779
  t 714 779 713
  t 780 715 781
  t 716 781 715
  t 781 716 782
  t 717 782 716
  t 782 717 783
  t 718 783 717
  t 783 718 784
  t 719 784 718
  t 784 719 785
  t 720 785 719
  t 785 720 786
  t 721 786 720
  t 786 721 787
  t 722 787 721
  t 787 722 788
  t 723 788 722
  t 788 723 789
  t 724 789 723
  t 789 724 790
  t 725 790 724
  t 790 725 791
  t 726 791 725
  t 791 726 792
  t 727 792 726
  t 792 727 793
  t 728 793 727
  t 793 728 794
  t 729 794 728
  t 794 729 795
  t 730 795 729
  t 795 730 796
  t 731 796 730
  t 796 731 797
  t 732 797 731
  t 797 732 798
  t 733 798 732
  t 798 733 799
  t 734 799 733
  t 799 734 800
  t 735 800 734
  t 800 735 801
  t 736 801 735
  t 801 736 802
  t 737 802 736
  t 802 737 803
  t 738 803 737
  t 803 738 804
  t 739 804 738
  t 804 739 805
  t 740 805 739
  t 805 740 806
  t 741 806 740
  t 806 741 807
  t 742 807 741
  t 807 742 808
  t 743 808 742
  t 808 743 809
  t 744 809 743
  t 809 744 810
  t 745 810 744
  t 810 745 811
  t 746 811 745
  t 811 746 812
  t 747 812 746
  t 812 747 813
  t 748 813 747
  t 813 748 814
  t 749 814 748
  t 814 749 815
  t 750 815 749
  t 815 750 816
  t 751 816 750
  t 816 751 817
  t 752 817 751
  t 817 752 818
  t 753 818 752
  t 818 753 819
  t 754 819 753
  t 819 754 820
  t 755 820 754
  t 820 755 821
  t 756 821 755
  t 821 756 822
  t 757 822 756
  t 822 757 823
  t 758 823 757
  t 823 758 824
  t 759 824 758
  t 824 759 825
  t 760 825 759
  t 825 760 826
  t 761 826 760
  t 826 761 827
  t 762 827 761
  t 827 762 828
  t 763 828 762
  t 828 763 829
  t 764 829 763
  t 829 764 830
  t 765 830 764
  t 830 765 831
  t 766 831 765
  t 831 766 832
  t 767 832 766
  t 832 767 833
  t 768 833 767
  t 833 768 834
  t 769 834 768
  t 834 769 835
  t 770 835 769
  t 835 770 836
  t 771 836 770
  t 836 771 837
  t 772 837 771
  t 837 772 838
  t 773 838 772
  t 838 773 839
  t 774 839 773
  t 839 774 840
  t 775 840 774
  t 840 775 841
  t 776 841 775
  t 841 776 842
  t 777 842 776
  t 842 777 843
  t 778 843 777
  t 843 778 844
  t 779 844 778
  t 845 780 846
  t 781 846 780
  t 846 781 847
  t 782 847 781
  t 847 782 848
  t 783 848 782
  t 848 783 849
  t 784 849 783
  t 849 784 850
  t 785 850 784
  t 850 785 851
  t 786 851 785
  t 851 786 852
  t 787 852 786
  t 852 787 853
  t 788 853 787
  t 853 788 854
  t 789 854 788
  t 854 789 855
  t 790 855 789
  t 855 790 856
  t 791 856 790
  t 856 791 857
  t 792 857 791
  t 857 792 858
  t 793 858 792
  t 858 793 859
  t 794 859 793
  t 859 794 860
  t 795 860 794
  t 860 795 861
  t 796 861 795
  t 861 796 862
  t 797 862 796
  t 862 797 863
  t 798 863 797
  t 863 798 864
  t 799 864 798
  t 864 799 865
  t 800 865 799
  t 865 800 866
  t 801 866 800
  t 866 801 867
  t 802 867 801
  t 867 802 868
  t 803 868 802
  t 868 803 869
  t 804 869 803
  t 869 804 870
  t 805 870 804
  t 870 805 871
  t 806 871 805
  t 871 806 872
  t 807 872 806
  t 872 807 873
  t 808 873 807
  t 873 808 874
  t 809 874 808
  t 874 809 875
  t 810 875 809
  t 875 810 876
  t 811 876 810
  t 876 811 877
  t 812 877 811
  t 877 812 878
  t 813 878 812
  t 878 813 879
  t 814 879 813
  t 879 814 880
  t 815 880 814
  t 880 815 881
  t 816 881 815
  t 881 816 882
  t 817 882 816
  t 882 817 883
  t 818 883 817
  t 883 818 884
  t 819 884 818
  t 884 819 885
  t 820 885 819
  t 885 820 886
  t 821 886 820
  t 886 821 887
  t 822 887 821
  t 887 822 888
  t 823 888 822
  t 888 823 889
  t 824 889 823
  t 889 824 890
  t 825 890 824
  t 890 825 891
  t 826 891 825
  t 891 826 892
  t 827 892 826
  t 892 827 893
  t 828 893 827
  t 893 828 894
  t 829 894 828
  t 894 829 895
  t 830 895 829
  t 895 830 896
  t 831 896 830
  t 896 831 897
  t 832 897 831
  t 897 832 898
  t 833 898 832
  t 898 833 899
  t 834 899 833
  t 899 834 900
  t 835 900 834
  t 900 835 901
  t 836 901 835
  t 901 836 902
  t 837 902 836
  t 902 837 903
  t 838 903 837
  t 903 838 904
  t 839 904 838
  t 904 839 905
  t 840 905 839
  t 905 840 906
  t 841 906 840
  t 906 841 907
  t 842 907 841
  t 907 842 908
  t 843 908 842
  t 908 843 909
  t 844 909 843
  t 910 845 911
  t 846 911 845
  t 911 846 912
  t 847 912 846
  t 912 847 913
  t 848 913 847
  t 913 848 914
  t 849 914 848
  t 914 849 915
  t 850 915 849
  t 915 850 916
  t 851 916 850
  t 916 851 917
  t 852 917 851
  t 917 852 918
  t 853 918 852
  t 918 853 919
  t 854 919 853
  t 919 854 920
  t 855 920 854
  t 920 855 921
  t 856 921 855
  t 921 856 922
  t 857 922 856
  t 922 857 923
  t 858 923 857
  t 923 858 924
  t 859 924 858
  t 924 859 925
  t 860 925 859
  t 925 860 926
  t 861 926 860
  t 926 861 927
  t 862 927 861
  t 927 862 928
  t 863 928 862
  t 928 863 929
  t 864 929 863
  t 929 864 930
  t 865 930 864
  t 930 865 931
  t 866 931 865
  t 931 866 932
  t 867 932 866
  t 932 867 933
  t 868 933 867
  t 933 868 934
  t 869 934 868
  t 934 869 935
  t 870 935 869
  t 935 870 936
  t 871 936 870
  t 936 871 937
  t 872 937 871
  t 937 872 938
  t 873 938 872
  t 938 873 939
  t 874 939 873
  t 939 874 940
  t 875 940 874
  t 940 875 941
  t 876 941 875
  t 941 876 942
  t 877 942 876
  t 942 877 943
  t 878 943 877
  t 943 878 944
  t 879 944 878
  t 944 879 945
  t 880 945 879
  t 945 880 946
  t 881 946 880
  t 946 881 947
  t 882 947 881
  t 947 882 948
  t 883 948 882
  t 948 883 949
  t 884 949 883
  t 949 884 950
  t 885 950 884
  t 950 885 951
  t 886 951 885
  t 951 886 952
  t 887 952 886
  t 952 887 953
  t 888 953 887
  t 953 888 954
  t 889 954 888
  t 954 889 955
  t 890 955 889
  t 955 890 956
  t 891 956 890
  t 956 891 957
  t 892 957 891
  t 957 892 958
  t 893 958 892
  t 958 893 959
  t 894 959 893
  t 959 894 960
  t 895 960 894
  t 960 895 961
  t 896 961 895
  t 961 896 962
  t 897 962 896
  t 962 897 963
  t 898 963 897
  t 963 898 964
  t 899 964 898
  t 964 899 965
  t 900 965 899
  t 965 900 966
  t 901 966 900
  t 966 901 967
  t 902 967 901
  t 967 902 968
  t 903 968 902
  t 968 903 969
  t 904 969 903
  t 969 904 970
  t 905 970 904
  t 970 905 971
  t 906 971 905
  t 971 906 972
  t 907 972 906
  t 972 907 973
  t 908 973 907
  t 973 908 974
  t 909 974 908
  t 975 910 976
  t 911 976 910
  t 976 911 977
  t 912 977 911
  t 977 912 978
  t 913 978 912
  t 978 913 979
  t 914 979 913
  t 979 914 980
  t 915 980 914
  t 980 915 981
  t 916 981 915
  t 981 916 982
  t 917 982 916
  t 982 917 983
  t 918 983 917
  t 983 918 984
  t 919 984 918
  t 984 919 985
  t 920 985 919
  t 985 920 986
  t 921 986 920
  t 986 921 987
  t 922 987 921
  t 987 922 988
  t 923 988 922
  t 988 923 989
  t 924 989 923
  t 989 924 990
  t 925 990 924
  t 990 925 991
  t 926 991 925
  t 991 926 992
  t 927 992 926
  t 992 927 993
  t 928 993 927
  t 993 928 994
  t 929 994 928
  t 994 929 995
  t 930 995 929
  t 995 930 996
  t 931 996 930
  t 996 931 997
  t 932 997 931
  t 997 932 998
  t 933 998 932
  t 998 933 999
  t 934 999 933
  t 999 934 1000
  t 935 1000 934
  t 1000 935 1001
  t 936 1001 935
  t 1001 936 1002
  t 937 1002 936
  t 1002 937 1003
  t 938 1003 937
  t 1003 938 1004
  t 939 1004 938
  t 1004 939 1005
  t 940 1005 939
  t 1005 940 1006
  t 941 1006 940
  t 1006 941 1007
  t 942 1007 941
  t 1007 942 1008
  t 943 1008 942
  t 1008 943 1009
  t 944 1009 943
  t 1009 944 1010
  t 945 1010 944
  t 1010 945 1011
  t 946 1011 945
  t 1011 946 1012
  t 947 1012 946
  t 1012 947 1013
  t 948 1013 947
  t 1013 948 1014
  t 949 1014 948
  t 1014 949 1015
  t 950 1015 949
  t 1015 950 1016
  t 951 1016 950
  t 1016 951 1017
  t 952 1017 951
  t 1017 952 1018
  t 953 1018 952
  t 1018 953 1019
  t 954 1019 953
  t 1019 954 1020
  t 955 1020 954
  t 1020 955 1021
  t 956 1021 955
  t 1021 956 1022
  t 957 1022 956
  t 1022 957 1023
  t 958 1023 957
  t 1023 958 1024
  t 959 1024 958
  t 1024 959 1025
  t 960 1025 959
  t 1025 960 1026
  t 961 1026 960
  t 1026 961 1027
  t 962 1027 961
  t 1027 962 1028
  t 963 1028 962
  t 1028 963 1029
  t 964 1029 963
  t 1029 964 1030
  t 965 1030 964
  t 1030 965 1031
  t 966 1031 965
  t 1031 966 1032
  t 967 1032 966
  t 1032 967 1033
  t 968 1033 967
  t 1033 968 1034
  t 969 1034 968
  t 1034 969 1035
  t 970 1035 969
  t 1035 970 1036
  t 971 1036 970
  t 1036 971 1037
  t 972 1037 971
  t 1037 972 1038
  t 973 1038 972
  t 1038 973 1039
  t 974 1039 973
  t 1040 975 1041
  t 976 1041 975
  t 1041 976 1042
  t 977 1042 976
  t 1042 977 1043
  t 978 1043 977
  t 1043 978 1044
  t 979 1044 978
  t 1044 979 1045
  t 980 1045 979
  t 1045 980 1046
  t 981 1046 980
  t 1046 981 1047
  t 982 1047 981
  t 1047 982 1048
  t 983 1048 982
  t 1048 983 1049
  t 984 1049 983
  t 1049 984 1050
  t 985 1050 984
  t 1050 985 1051
  t 986 1051 985
  t 1051 986 1052
  t 987 1052 986
  t 1052 987 1053
  t 988 1053 987
  t 1053 988 1054
  t 989 1054 988
  t 1054 989 1055
  t 990 1055 989
  t 1055 990 1056
  t 991 1056 990
  t 1056 991 1057
  t 992 1057 991
  t 1057 992 1058
  t 993 1058 992
  t 1058 993 1059
  t 994 1059 993
  t 1059 994 1060
  t 995 1060 994
  t 1060 995 1061
  t 996 1061 995
  t 1061 996 1062
  t 997 1062 996
  t 1062 997 1063
  t 998 1063 997
  t 1063 998 1064
  t 999 1064 998
  t 1064 999 1065
  t 1000 1065 999
  t 1065 1000 1066
  t 1001 1066 1000
  t 1066 1001 1067
  t 1002 1067 1001
  t 1067 1002 1068
  t 1003 1068 1002
  t 1068 1003 1069
  t 1004 1069 1003
  t 1069 1004 1070
  t 1005 1070 1004
  t 1070 1005 1071
  t 1006 1071 1005
  t 1071 1006 1072
  t 1007 1072 1006
  t 1072 1007 1073
  t 1008 1073 1007
  t 1073 1008 1074
  t 1009 1074 1008
  t 1074 1009 1075
  t 1010 1075 1009
  t 1075 1010 1076
  t 1011 1076 1010
  t 1076 1011 1077
  t 1012 1077 1011
  t 1077 1012 1078
  t 1013 1078 1012
  t 1078 1013 1079
  t 1014 1079 1013
  t 1079 1014 1080
  t 1015 1080 1014
  t 1080 1015 1081
  t 1016 1081 1015
  t 1081 1016 1082
  t 1017 1082 1016
  t 1082 1017 1083
  t 1018 1083 1017
  t 1083 1018 1084
  t 1019 1084 1018
  t 1084 1019 1085
  t 1020 1085 1019
  t 1085 1020 1086
  t 1021 1086 1020
  t 1086 1021 1087
  t 1022 1087 1021
  t 1087 1022 1088
  t 1023 1088 1022
  t 1088 1023 1089
  t 1024 1089 1023
  t 1089 1024 1090
  t 1025 1090 1024
  t 1090 1025 1091
  t 1026 1091 1025
  t 1091 1026 1092
  t 1027 1092 1026
  t 1092 1027 1093
  t 1028 1093 1027
  t 1093 1028 1094
  t 1029 1094 1028
  t 1094 1029 1095
  t 1030 1095 1029
  t 1095 1030 1096
  t 1031 1096 1030
  t 1096 1031 1097
  t 1032 1097 1031
  t 1097 1032 1098
  t 1033 1098 1032
  t 1098 1033 1099
  t 1034 1099 1033
  t 1099 1034 1100
  t 1035 1100 1034
  t 1100 1035 1101
  t 1036 1101 1035
  t 1101 1036 1102
  t 1037 1102 1036
  t 1102 1037 1103
  t 1038 1103 1037
  t 1103 1038 1104
  t 1039 1104 1038
  t 1105 1040 1106
  t 1041 1106 1040
  t 1106 1041 1107
  t 1042 1107 1041
  t 1107 1042 1108
  t 1043 1108 1042
  t 1108 1043 1109
  t 1044 1109 1043
  t 1109 1044 1110
  t 1045 1110 1044
  t 1110 1045 1111
  t 1046 1111 1045
  t 1111 1046 1112
  t 1047 1112 1046
  t 1112 1047 1113
  t 1048 1113 1047
  t 1113 1048 1114
  t 1049 1114 1048
  t 1114 1049 1115
  t 1050 1115 1049
  t 1115 1050 1116
  t 1051 1116 1050
  t 1116 1051 1117
  t 1052 1117 1051
  t 1117 1052 1118
  t 1053 1118 1052
  t 1118 1053 1119
  t 1054 1119 1053
  t 1119 1054 1120
  t 1055 1120 1054
  t 1120 1055 1121
  t 1056 1121 1055
  t 1121 1056 1122
  t 1057 1122 1056
  t 1122 1057 1123
  t 1058 1123 1057
  t 1123 1058 1124
  t 1059 1124 1058
  t 1124 1059 1125
  t 1060 1125 1059
  t 1125 1060 1126
  t 1061 1126 1060
  t 1126 1061 1127
  t 1062 1127 1061
  t 1127 1062 1128
  t 1063 1128 1062
  t 1128 1063 1129
  t 1064 1129 1063
  t 1129 1064 1130
  t 1065 1130 1064
  t 1130 1065 1131
  t 1066 1131 1065
  t 1131 1066 1132
  t 1067 1132 1066
  t 1132 1067 1133
  t 1068 1133 1067
  t 1133 1068 1134
  t 1069 1134 1068
  t 1134 1069 1135
  t 1070 1135 1069
  t 1135 1070 1136
  t 1071 1136 1070
  t 1136 1071 1137
  t 1072 1137 1071
  t 1137 1072 1138
  t 1073 1138 1072
  t 1138 1073 1139
  t 1074 1139 1073
  t 1139 1074 1140
  t 1075 1140 1074
  t 1140 1075 1141
  t 1076 1141 1075
  t 1141 1076 1142
  t 1077 1142 1076
  t 1142 1077 1143
  t 1078 1143 1077
  t 1143 1078 1144
  t 1079 1144 1078
  t 1144 1079 1145
  t 1080 1145 1079
  t 1145 1080 1146
  t 1081 1146 1080
  t 1146 1081 1147
  t 1082 1147 1081
  t 1147 1082 1148
  t 1083 1148 1082
  t 1148 1083 1149
  t 1084 1149 1083
  t 1149 1084 1150
  t 1085 1150 1084
  t 1150 1085 1151
  t 1086 1151 1085
  t 1151 1086 1152
  t 1087 1152 1086
  t 1152 1087 1153
  t 1088 1153 1087
  t 1153 1088 1154
  t 1089 1154 1088
  t 1154 1089 1155
  t 1090 1155 1089
  t 1155 1090 1156
  t 1091 1156 1090
  t 1156 1091 1157
  t 1092 1157 1091
  t 1157 1092 1158
  t 1093 1158 1092
  t 1158 1093 1159
  t 1094 1159 1093
  t 1159 1094 1160
  t 1095 1160 1094
  t 1160 1095 1161
  t 1096 1161 1095
  t 1161 1096 1162
  t 1097 1162 1096
  t 1162 1097 1163
  t 1098 1163 1097
  t 1163 1098 1164
  t 1099 1164 1098
  t 1164 1099 1165
  t 1100 1165 1099
  t 1165 1100 1166
  t 1101 1166 1100
  t 1166 1101 1167
  t 1102 1167 1101
  t 1167 1102 1168
  t 1103 1168 1102
  t 1168 1103 1169
  t 1104 1169 1103
  t 1170 1105 1171
  t 1106 1171 1105
  t 1171 1106 1172
  t 1107 1172 1106
  t 1172 1107 1173
  t 1108 1173 1107
  t 1173 1108 1174
  t 1109 1174 1108
  t 1174 1109 1175
  t 1110 1175 1109
  t 1175 1110 1176
  t 1111 1176 1110
  t 1176 1111 1177
  t 1112 1177 1111
  t 1177 1112 1178
  t 1113 1178 1112
  t 1178 1113 1179
  t 1114 1179 1113
  t 1179 1114 1180
  t 1115 1180 1114
  t 1180 1115 1181
  t 1116 1181 1115
  t 1181 1116 1182
  t 1117 1182 1116
  t 1182 1117 1183
  t 1118 1183 1117
  t 1183 1118 1184
  t 1119 1184 1118
  t 1184 1119 1185
  t 1120 1185 1119
  t 1185 1120 1186
  t 1121 1186 1120
  t 1186 1121 1187
  t 1122 1187 1121
  t 1187 1122 1188
  t 1123 1188 1122
  t 1188 1123 1189
  t 1124 1189 1123
  t 1189 1124 1190
  t 1125 1190 1124
  t 1190 1125 1191
  t 1126 1191 1125
  t 1191 1126 1192
  t 1127 1192 1126
  t 1192 1127 1193
  t 1128 1193 1127
  t 1193 1128 1194
  t 1129 1194 1128
  t 1194 1129 1195
  t 1130 1195 1129
  t 1195 1130 1196
  t 1131 1196 1130
  t 1196 1131 1197
  t 1132 1197 1131
  t 1197 1132 1198
  t 1133 1198 1132
  t 1198 1133 1199
  t 1134 1199 1133
  t 1199 1134 1200
  t 1135 1200 1134
  t 1200 1135 1201
  t 1136 1201 1135
  t 1201 1136 1202
  t 1137 1202 1136
  t 1202 1137 1203
  t 1138 1203 1137
  t 1203 1138 1204
  t 1139 1204 1138
  t 1204 1139 1205
  t 1140 1205 1139
  t 1205 1140 1206
  t 1141 1206 1140
  t 1206 1141 1207
  t 1142 1207 1141
  t 1207 1142 1208
  t 1143 1208 1142
  t 1208 1143 1209
  t 1144 1209 1143
  t 1209 1144 1210
  t 1145 1210 1144
  t 1210 1145 1211
  t 1146 1211 1145
  t 1211 1146 1212
  t 1147 1212 1146
  t 1212 1147 1213
  t 1148 1213 1147
  t 1213 1148 1214
  t 1149 1214 1148
  t 1214 1149 1215
  t 1150 1215 1149
  t 1215 1150 1216
  t 1151 1216 1150
  t 1216 1151 1217
  t 1152 1217 1151
  t 1217 1152 1218
  t 1153 1218 1152
  t 1218 1153 1219
  t 1154 1219 1153
  t 1219 1154 1220
  t 1155 1220 1154
  t 1220 1155 1221
  t 1156 1221 1155
  t 1221 1156 1222
  t 1157 1222 1156
  t 1222 1157 1223
  t 1158 1223 1157
  t 1223 1158 1224
  t 1159 1224 1158
  t 1224 1159 1225
  t 1160 1225 1159
  t 1225 1160 1226
  t 1161 1226 1160
  t 1226 1161 1227
  t 1162 1227 1161
  t 1227 1162 1228
  t 1163 1228 1162
  t 1228 1163 1229
  t 1164 1229 1163
  t 1229 1164 1230
  t 1165 1230 1164
  t 1230 1165 1231
  t 1166 1231 1165
  t 1231 1166 1232
  t 1167 1232 1166
  t 1232 1167 1233
  t 1168 1233 1167
  t 1233 1168 1234
  t 1169 1234 1168
  t 1235 1170 1236
  t 1171 1236 1170
  t 1236 1171 1237
  t 1172 1237 1171
  t 1237 1172 1238
  t 1173 1238 1172
  t 1238 1173 1239
  t 1174 1239 1173
  t 1239 1174 1240
  t 1175 1240 1174
  t 1240 1175 1241
  t 1176 1241 1175
  t 1241 1176 1242
  t 1177 1242 1176
  t 1242 1177 1243
  t 1178 1243 1177
  t 1243 1178 1244
  t 1179 1244 1178
  t 1244 1179 1245
  t 1180 1245 1179
  t 1245 1180 1246
  t 1181 1246 1180
  t 1246 1181 1247
  t 1182 1247 1181
  t 1247 1182 1248
  t 1183 1248 1182
  t 1248 1183 1249
  t 1184 1249 1183
  t 1249 1184 1250
  t 1185 1250 1184
  t 1250 1185 1251
  t 1186 1251 1185
  t 1251 1186 1252
  t 1187 1252 1186
  t 1252 1187 1253
  t 1188 1253 1187
  t 1253 1188 1254
  t 1189 1254 1188
  t 1254 1189 1255
  t 1190 1255 1189
  t 1255 1190 1256
  t 1191 1256 1190
  t 1256 1191 1257
  t 1192 1257 1191
  t 1257 1192 1258
  t 1193 1258 1192
  t 1258 1193 1259
  t 1194 1259 1193
  t 1259 1194 1260
  t 1195 1260 1194
  t 1260 1195 1261
  t 1196 1261 1195
  t 1261 1196 1262
  t 1197 1262 1196
  t 1262 1197 1263
  t 1198 1263 1197
  t 1263 1198 1264
  t 1199 1264 1198
  t 1264 1199 1265
  t 1200 1265 1199
  t 1265 1200 1266
  t 1201 1266 1200
  t 1266 1201 1267
  t 1202 1267 1201
  t 1267 1202 1268
  t 1203 1268 1202
  t 1268 1203 1269
  t 1204 1269 1203
  t 1269 1204 1270
  t 1205 1270 1204
  t 1270 1205 1271
  t 1206 1271 1205
  t 1271 1206 1272
  t 1207 1272 1206
  t 1272 1207 1273
  t 1208 1273 1207
  t 1273 1208 1274
  t 1209 1274 1208
  t 1274 1209 1275
  t 1210 1275 1209
  t 1275 1210 1276
  t 1211 1276 1210
  t 1276 1211 1277
  t 1212 1277 1211
  t 1277 1212 1278
  t 1213 1278 1212
  t 1278 1213 1279
  t 1214 1279 1213
  t 1279 1214 1280
  t 1215 1280 1214
  t 1280 1215 1281
  t 1216 1281 1215
  t 1281 1216 1282
  t 1217 1282 1216
  t 1282 1217 1283
  t 1218 1283 1217
  t 1283 1218 1284
  t 1219 1284 1218
  t 1284 1219 1285
  t 1220 1285 1219
  t 1285 1220 1286
  t 1221 1286 1220
  t 1286 1221 1287
  t 1222 1287 1221
  t 1287 1222 1288
  t 1223 1288 1222
  t 1288 1223 1289
  t 1224 1289 1223
  t 1289 1224 1290
  t 1225 1290 1224
  t 1290 1225 1291
  t 1226 1291 1225
  t 1291 1226 1292
  t 1227 1292 1226
  t 1292 1227 1293
  t 1228 1293 1227
  t 1293 1228 1294
  t 1229 1294 1228
  t 1294 1229 1295
  t 1230 1295 1229
  t 1295 1230 1296
  t 1231 1296 1230
  t 1296 1231 1297
  t 1232 1297 1231
  t 1297 1232 1298
  t 1233 1298 1232
  t 1298 1233 1299
  t 1234 1299 1233
  t 1300 1235 1301
  t 1236 1301 1235
  t 1301 1236 1302
  t 1237 1302 1236
  t 1302 1237 1303
  t 1238 1303 1237
  t 1303 1238 1304
  t 1239 1304 1238
  t 1304 1239 1305
  t 1240 1305 1239
  t 1305 1240 1306
  t 1241 1306 1240
  t 1306 1241 1307
  t 1242 1307 1241
  t 1307 1242 1308
  t 1243 1308 1242
  t 1308 1243 1309
  t 1244 1309 1243
  t 1309 1244 1310
  t 1245 1310 1244
  t 1310 1245 1311
  t 1246 1311 1245
  t 1311 1246 1312
  t 1247 1312 1246
  t 1312 1247 1313
  t 1248 1313 1247
  t 1313 1248 1314
  t 1249 1314 1248
  t 1314 1249 1315
  t 1250 1315 1249
  t 1315 1250 1316
  t 1251 1316 1250
  t 1316 1251 1317
  t 1252 1317 1251
  t 1317 1252 1318
  t 1253 1318 1252
  t 1318 1253 1319
  t 1254 1319 1253
  t 1319 1254 1320
  t 1255 1320 1254
  t 1320 1255 1321
  t 1256 1321 1255
  t 1321 1256 1322
  t 1257 1322 1256
  t 1322 1257 1323
  t 1258 1323 1257
  t 1323 1258 1324
  t 1259 1324 1258
  t 1324 1259 1325
  t 1260 1325 1259
  t 1325 1260 1326
  t 1261 1326 1260
  t 1326 1261 1327
  t 1262 1327 1261
  t 1327 1262 1328
  t 1263 1328 1262
  t 1328 1263 1329
  t 1264 1329 1263
  t 1329 1264 1330
  t 1265 1330 1264
  t 1330 1265 1331
  t 1266 1331 1265
  t 1331 1266 1332
  t 1267 1332 1266
  t 1332 1267 1333
  t 1268 1333 1267
  t 1333 1268 1334
  t 1269 1334 1268
  t 1334 1269 1335
  t 1270 1335 1269
  t 1335 1270 1336
  t 1271 1336 1270
  t 1336 1271 1337
  t 1272 1337 1271
  t 1337 1272 1338
  t 1273 1338 1272
  t 1338 1273 1339
  t 1274 1339 1273
  t 1339 1274 1340
  t 1275 1340 1274
  t 1340 1275 1341
  t 1276 1341 1275
  t 1341 1276 1342
  t 1277 1342 1276
  t 1342 1277 1343
  t 1278 1343 1277
  t 1343 1278 1344
  t 1279 1344 1278
  t 1344 1279 1345
  t 1280 1345 1279
  t 1345 1280 1346
  t 1281 1346 1280
  t 1346 1281 1347
  t 1282 1347 1281
  t 1347 1282 1348
  t 1283 1348 1282
  t 1348 1283 1349
  t 1284 1349 1283
  t 1349 1284 1350
  t 1285 1350 1284
  t 1350 1285 1351
  t 1286 1351 1285
  t 1351 1286 1352
  t 1287 1352 1286
  t 1352 1287 1353
  t 1288 1353 1287
  t 1353 1288 1354
  t 1289 1354 1288
  t 1354 1289 1355
  t 1290 1355 1289
  t 1355 1290 1356
  t 1291 1356 1290
  t 1356 1291 1357
  t 1292 1357 1291
  t 1357 1292 1358
  t 1293 1358 1292
  t 1358 1293 1359
  t 1294 1359 1293
  t 1359 1294 1360
  t 1295 1360 1294
  t 1360 1295 1361
  t 1296 1361 1295
  t 1361 1296 1362
  t 1297 1362 1296
  t 1362 1297 1363
  t 1298 1363 1297
  t 1363 1298 1364
  t 1299 1364 1298
  t 1365 1300 1366
  t 1301 1366 1300
  t 1366 1301 1367
  t 1302 1367 1301
  t 1367 1302 1368
  t 1303 1368 1302
  t 1368 1303 1369
  t 1304 1369 1303
  t 1369 1304 1370
  t 1305 1370 1304
  t 1370 1305 1371
  t 1306 1371 1305
  t 1371 1306 1372
  t 1307 1372 1306
  t 1372 1307 1373
  t 1308 1373 1307
  t 1373 1308 1374
  t 1309 1374 1308
  t 1374 1309 1375
  t 1310 1375 1309
  t 1375 1310 1376
  t 1311 1376 1310
  t 1376 1311 1377
  t 1312 1377 1311
  t 1377 1312 1378
  t 1313 1378 1312
  t 1378 1313 1379
  t 1314 1379 1313
  t 1379 1314 1380
  t 1315 1380 1314
  t 1380 1315 1381
  t 1316 1381 1315
  t 1381 1316 1382
  t 1317 1382 1316
  t 1382 1317 1383
  t 1318 1383 1317
  t 1383 1318 1384
  t 1319 1384 1318
  t 1384 1319 1385
  t 1320 1385 1319
  t 1385 1320 1386
  t 1321 1386 1320
  t 1386 1321 1387
  t 1322 1387 1321
  t 1387 1322 1388
  t 1323 1388 1322
  t 1388 1323 1389
  t 1324 1389 1323
  t 1389 1324 1390
  t 1325 1390 1324
  t 1390 1325 1391
  t 1326 1391 1325
  t 1391 1326 1392
  t 1327 1392 1326
  t 1392 1327 1393
  t 1328 1393 1327
  t 1393 1328 1394
  t 1329 1394 1328
  t 1394 1329 1395
  t 1330 1395 1329
  t 1395 1330 1396
  t 1331 1396 1330
  t 1396 1331 1397
  t 1332 1397 1331
  t 1397 1332 1398
  t 1333 1398 1332
  t 1398 1333 1399
  t 1334 1399 1333
  t 1399 1334 1400
  t 1335 1400 1334
  t 1400 1335 1401
  t 1336 1401 1335
  t 1401 1336 1402
  t 1337 1402 1336
  t 1402 1337 1403
  t 1338 1403 1337
  t 1403 1338 1404
  t 1339 1404 1338
  t 1404 1339 1405
  t 1340 1405 1339
  t 1405 1340 1406
  t 1341 1406 1340
  t 1406 1341 1407
  t 1342 1407 1341
  t 1407 1342 1408
  t 1343 1408 1342
  t 1408 1343 1409
  t 1344 1409 1343
  t 1409 1344 1410
  t 1345 1410 1344
  t 1410 1345 1411
  t 1346 1411 1345
  t 1411 1346 1412
  t 1347 1412 1346
  t 1412 1347 1413
  t 1348 1413 1347
  t 1413 1348 1414
  t 1349 1414 1348
  t 1414 1349 1415
  t 1350 1415 1349
  t 1415 1350 1416
  t 1351 1416 1350
  t 1416 1351 1417
  t 1352 1417 1351
  t 1417 1352 1418
  t 1353 1418 1352
  t 1418 1353 1419
  t 1354 1419 1353
  t 1419 1354 1420
  t 1355 1420 1354
  t 1420 1355 1421
  t 1356 1421 1355
  t 1421 1356 1422
  t 1357 1422 1356
  t 1422 1357 1423
  t 1358 1423 1357
  t 1423 1358 1424
  t 1359 1424 1358
  t 1424 1359 1425
  t 1360 1425 1359
  t 1425 1360 1426
  t 1361 1426 1360
  t 1426 1361 1427
  t 1362 1427 1361
  t 1427 1362 1428
  t 1363 1428 1362
  t 1428 1363 1429
  t 1364 1429 1363
  t 1430 1365 1431
  t 1366 1431 1365
  t 1431 1366 1432
  t 1367 1432 1366
  t 1432 1367 1433
  t 1368 1433 1367
  t 1433 1368 1434
  t 1369 1434 1368
  t 1434 1369 1435
  t 1370 1435 1369
  t 1435 1370 1436
  t 1371 1436 1370
  t 1436 1371 1437
  t 1372 1437 1371
  t 1437 1372 1438
  t 1373 1438 1372
  t 1438 1373 1439
  t 1374 1439 1373
  t 1439 1374 1440
  t 1375 1440 1374
  t 1440 1375 1441
  t 1376 1441 1375
  t 1441 1376 1442
  t 1377 1442 1376
  t 1442 1377 1443
  t 1378 1443 1377
  t 1443 1378 1444
  t 1379 1444 1378
  t 1444 1379 1445
  t 1380 1445 1379
  t 1445 1380 1446
  t 1381 1446 1380
  t 1446 1381 1447
  t 1382 1447 1381
  t 1447 1382 1448
  t 1383 1448 1382
  t 1448 1383 1449
  t 1384 1449 1383
  t 1449 1384 1450
  t 1385 1450 1384
  t 1450 1385 1451
  t 1386 1451 1385
  t 1451 1386 1452
  t 1387 1452 1386
  t 1452 1387 1453
  t 1388 1453 1387
  t 1453 1388 1454
  t 1389 1454 1388
  t 1454 1389 1455
  t 1390 1455 1389
  t 1455 1390 1456
  t 1391 1456 1390
  t 1456 1391 1457
  t 1392 1457 1391
  t 1457 1392 1458
  t 1393 1458 1392
  t 1458 1393 1459
  t 1394 1459 1393
  t 1459 1394 1460
  t 1395 1460 1394
  t 1460 1395 1461
  t 1396 1461 1395
  t 1461 1396 1462
  t 1397 1462 1396
  t 1462 1397 1463
  t 1398 1463 1397
  t 1463 1398 1464
  t 1399 1464 1398
  t 1464 1399 1465
  t 1400 1465 1399
  t 1465 1400 1466
  t 1401 1466 1400
  t 1466 1401 1467
  t 1402 1467 1401
  t 1467 1402 1468
  t 1403 1468 1402
  t 1468 1403 1469
  t 1404 1469 1403
  t 1469 1404 1470
  t 1405 1470 1404
  t 1470 1405 1471
  t 1406 1471 1405
  t 1471 1406 1472
  t 1407 1472 1406
  t 1472 1407 1473
  t 1408 1473 1407
  t 1473 1408 1474
  t 1409 1474 1408
  t 1474 1409 1475
  t 1410 1475 1409
  t 1475 1410 1476
  t 1411 1476 1410
  t 1476 1411 1477
  t 1412 1477 1411
  t 1477 1412 1478
  t 1413 1478 1412
  t 1478 1413 1479
  t 1414 1479 1413
  t 1479 1414 1480
  t 1415 1480 1414
  t 1480 1415 1481
  t 1416 1481 1415
  t 1481 1416 1482
  t 1417 1482 1416
  t 1482 1417 1483
  t 1418 1483 1417
  t 1483 1418 1484
  t 1419 1484 1418
  t 1484 1419 1485
  t 1420 1485 1419
  t 1485 1420 1486
  t 1421 1486 1420
  t 1486 1421 1487
  t 1422 1487 1421
  t 1487 1422 1488
  t 1423 1488 1422
  t 1488 1423 1489
  t 1424 1489 1423
  t 1489 1424 1490
  t 1425 1490 1424
  t 1490 1425 1491
  t 1426 1491 1425
  t 1491 1426 1492
  t 1427 1492 1426
  t 1492 1427 1493
  t 1428 1493 1427
  t 1493 1428 1494
  t 1429 1494 1428
  t 1495 1430 1496
  t 1431 1496 1430
  t 1496 1431 1497
  t 1432 1497 1431
  t 1497 1432 1498
  t 1433 1498 1432
  t 1498 1433 1499
  t 1434 1499 1433
  t 1499 1434 1500
  t 1435 1500 1434
  t 1500 1435 1501
  t 1436 1501 1435
  t 1501 1436 1502
  t 1437 1502 1436
  t 1502 1437 1503
  t 1438 1503 1437
  t 1503 1438 1504
  t 1439 1504 1438
  t 1504 1439 1505
  t 1440 1505 1439
  t 1505 1440 1506
  t 1441 1506 1440
  t 1506 1441 1507
  t 1442 1507 1441
  t 1507 1442 1508
  t 1443 1508 1442
  t 1508 1443 1509
  t 1444 1509 1443
  t 1509 1444 1510
  t 1445 1510 1444
  t 1510 1445 1511
  t 1446 1511 1445
  t 1511 1446 1512
  t 1447 1512 1446
  t 1512 1447 1513
  t 1448 1513 1447
  t 1513 1448 1514
  t 1449 1514 1448
  t 1514 1449 1515
  t 1450 1515 1449
  t 1515 1450 1516
  t 1451 1516 1450
  t 1516 1451 1517
  t 1452 1517 1451
  t 1517 1452 1518
  t 1453 1518 1452
  t 1518 1453 1519
  t 1454 1519 1453
  t 1519 1454 1520
  t 1455 1520 1454
  t 1520 1455 1521
  t 1456 1521 1455
  t 1521 1456 1522
  t 1457 1522 1456
  t 1522 1457 1523
  t 1458 1523 1457
  t 1523 1458 1524
  t 1459 1524 1458
  t 1524 1459 1525
  t 1460 1525 1459
  t 1525 1460 1526
  t 1461 1526 1460
  t 1526 1461 1527
  t 1462 1527 1461
  t 1527 1462 1528
  t 1463 1528 1462
  t 1528 1463 1529
  t 1464 1529 1463
  t 1529 1464 1530
  t 1465 1530 1464
  t 1530 1465 1531
  t 1466 1531 1465
  t 1531 1466 1532
  t 1467 1532 1466
  t 1532 1467 1533
  t 1468 1533 1467
  t 1533 1468 1534
  t 1469 1534 1468
  t 1534 1469 1535
  t 1470 1535 1469
  t 1535 1470 1536
  t 1471 1536 1470
  t 1536 1471 1537
  t 1472 1537 1471
  t 1537 1472 1538
  t 1473 1538 1472
  t 1538 1473 1539
  t 1474 1539 1473
  t 1539 1474 1540
  t 1475 1540 1474
  t 1540 1475 1541
  t 1476 1541 1475
  t 1541 1476 1542
  t 1477 1542 1476
  t 1542 1477 1543
  t 1478 1543 1477
  t 1543 1478 1544
  t 1479 1544 1478
  t 1544 1479 1545
  t 1480 1545 1479
  t 1545 1480 1546
  t 1481 1546 1480
  t 1546 1481 1547
  t 1482 1547 1481
  t 1547 1482 1548
  t 1483 1548 1482
  t 1548 1483 1549
  t 1484 1549 1483
  t 1549 1484 1550
  t 1485 1550 1484
  t 1550 1485 1551
  t 1486 1551 1485
  t 1551 1486 1552
  t 1487 1552 1486
  t 1552 1487 1553
  t 1488 1553 1487
  t 1553 1488 1554
  t 1489 1554 1488
  t 1554 1489 1555
  t 1490 1555 1489
  t 1555 1490 1556
  t 1491 1556 1490
  t 1556 1491 1557
  t 1492 1557 1491
  t 1557 1492 1558
  t 1493 1558 1492
  t 1558 1493 1559
  t 1494 1559 1493
  t 1560 1495 1561
  t 1496 1561 1495
  t 1561 1496 1562
  t 1497 1562 1496
  t 1562 1497 1563
  t 1498 1563 1497
  t 1563 1498 1564
  t 1499 1564 1498
  t 1564 1499 1565
  t 1500 1565 1499
  t 1565 1500 1566
  t 1501 1566 1500
  t 1566 1501 1567
  t 1502 1567 1501
  t 1567 1502 1568
  t 1503 1568 1502
  t 1568 1503 1569
  t 1504 1569 1503
  t 1569 1504 1570
  t 1505 1570 1504
  t 1570 1505 1571
  t 1506 1571 1505
  t 1571 1506 1572
  t 1507 1572 1506
  t 1572 1507 1573
  t 1508 1573 1507
  t 1573 1508 1574
  t 1509 1574 1508
  t 1574 1509 1575
  t 1510 1575 1509
  t 1575 1510 1576
  t 1511 1576 1510
  t 1576 1511 1577
  t 1512 1577 1511
  t 1577 1512 1578
  t 1513 1578 1512
  t 1578 1513 1579
  t 1514 1579 1513
  t 1579 1514 1580
  t 1515 1580 1514
  t 1580 1515 1581
  t 1516 1581 1515
  t 1581 1516 1582
  t 1517 1582 1516
  t 1582 1517 1583
  t 1518 1583 1517
  t 1583 1518 1584
  t 1519 1584 1518
  t 1584 1519 1585
  t 1520 1585 1519
  t 1585 1520 1586
  t 1521 1586 1520
  t 1586 1521 1587
  t 1522 1587 1521
  t 1587 1522 1588
  t 1523 1588 1522
  t 1588 1523 1589
  t 1524 1589 1523
  t 1589 1524 1590
  t 1525 1590 1524
  t 1590 1525 1591
  t 1526 1591 1525
  t 1591 1526 1592
  t 1527 1592 1526
  t 1592 1527 1593
  t 1528 1593 1527
  t 1593 1528 1594
  t 1529 1594 1528
  t 1594 1529 1595
  t 1530 1595 1529
  t 1595 1530 1596
  t 1531 1596 1530
  t 1596 1531 1597
  t 1532 1597 1531
  t 1597 1532 1598
  t 1533 1598 1532
  t 1598 1533 1599
  t 1534 1599 1533
  t 1599 1534 1600
  t 1535 1600 1534
  t 1600 1535 1601
  t 1536 1601 1535
  t 1601 1536 1602
  t 1537 1602 1536
  t 1602 1537 1603
  t 1538 1603 1537
  t 1603 1538 1604
  t 1539 1604 1538
  t 1604 1539 1605
  t 1540 1605 1539
  t 1605 1540 1606
  t 1541 1606 1540
  t 1606 1541 1607
  t 1542 1607 1541
  t 1607 1542 1608
  t 1543 1608 1542
  t 1608 1543 1609
  t 1544 1609 1543
  t 1609 1544 1610
  t 1545 1610 1544
  t 1610 1545 1611
  t 1546 1611 1545
  t 1611 1546 1612
  t 1547 1612 1546
  t 1612 1547 1613
  t 1548 1613 1547
  t 1613 1548 1614
  t 1549 1614 1548
  t 1614 1549 1615
  t 1550 1615 1549
  t 1615 1550 1616
  t 1551 1616 1550
  t 1616 1551 1617
  t 1552 1617 1551
  t 1617 1552 1618
  t 1553 1618 1552
  t 1618 1553 1619
  t 1554 1619 1553
  t 1619 1554 1620
  t 1555 1620 1554
  t 1620 1555 1621
  t 1556 1621 1555
  t 1621 1556 1622
  t 1557 1622 1556
  t 1622 1557 1623
  t 1558 1623 1557
  t 1623 1558 1624
  t 1559 1624 1558
  t 1625 1560 1626
  t 1561 1626 1560
  t 1626 1561 1627
  t 1562 1627 1561
  t 1627 1562 1628
  t 1563 1628 1562
  t 1628 1563 1629
  t 1564 1629 1563
  t 1629 1564 1630
  t 1565 1630 1564
  t 1630 1565 1631
  t 1566 1631 1565
  t 1631 1566 1632
  t 1567 1632 1566
  t 1632 1567 1633
  t 1568 1633 1567
  t 1633 1568 1634
  t 1569 1634 1568
  t 1634 1569 1635
  t 1570 1635 1569
  t 1635 1570 1636
  t 1571 1636 1570
  t 1636 1571 1637
  t 1572 1637 1571
  t 1637 1572 1638
  t 1573 1638 1572
  t 1638 1573 1639
  t 1574 1639 1573
  t 1639 1574 1640
  t 1575 1640 1574
  t 1640 1575 1641
  t 1576 1641 1575
  t 1641 1576 1642
  t 1577 1642 1576
  t 1642 1577 1643
  t 1578 1643 1577
  t 1643 1578 1644
  t 1579 1644 1578
  t 1644 1579 1645
  t 1580 1645 1579
  t 1645 1580 1646
  t 1581 1646 1580
  t 1646 1581 1647
  t 1582 1647 1581
  t 1647 1582 1648
  t 1583 1648 1582
  t 1648 1583 1649
  t 1584 1649 1583
  t 1649 1584 1650
  t 1585 1650 1584
  t 1650 1585 1651
  t 1586 1651 1585
  t 1651 1586 1652
  t 1587 1652 1586
  t 1652 1587 1653
  t 1588 1653 1587
  t 1653 1588 1654
  t 1589 1654 1588
  t 1654 1589 1655
  t 1590 1655 1589
  t 1655 1590 1656
  t 1591 1656 1590
  t 1656 1591 1657
  t 1592 1657 1591
  t 1657 1592 1658
  t 1593 1658 1592
  t 1658 1593 1659
  t 1594 1659 1593
  t 1659 1594 1660
  t 1595 1660 1594
  t 1660 1595 1661
  t 1596 1661 1595
  t 1661 1596 1662
  t 1597 1662 1596
  t 1662 1597 1663
  t 1598 1663 1597
  t 1663 1598 1664
  t 1599 1664 1598
  t 1664 1599 1665
  t 1600 1665 1599
  t 1665 1600 1666
  t 1601 1666 1600
  t 1666 1601 1667
  t 1602 1667 1601
  t 1667 1602 1668
  t 1603 1668 1602
  t 1668 1603 1669
  t 1604 1669 1603
  t 1669 1604 1670
  t 1605 1670 1604
  t 1670 1605 1671
  t 1606 1671 1605
  t 1671 1606 1672
  t 1607 1672 1606
  t 1672 1607 1673
  t 1608 1673 1607
  t 1673 1608 1674
  t 1609 1674 1608
  t 1674 1609 1675
  t 1610 1675 1609
  t 1675 1610 1676
  t 1611 1676 1610
  t 1676 1611 1677
  t 1612 1677 1611
  t 1677 1612 1678
  t 1613 1678 1612
  t 1678 1613 1679
  t 1614 1679 1613
  t 1679 1614 1680
  t 1615 1680 1614
  t 1680 1615 1681
  t 1616 1681 1615
  t 1681 1616 1682
  t 1617 1682 1616
  t 1682 1617 1683
  t 1618 1683 1617
  t 1683 1618 1684
  t 1619 1684 1618
  t 1684 1619 1685
  t 1620 1685 1619
  t 1685 1620 1686
  t 1621 1686 1620
  t 1686 1621 1687
  t 1622 1687 1621
  t 1687 1622 1688
  t 1623 1688 1622
  t 1688 1623 1689
  t 1624 1689 1623
  t 1690 1625 1691
  t 1626 1691 1625
  t 1691 1626 1692
  t 1627 1692 1626
  t 1692 1627 1693
  t 1628 1693 1627
  t 1693 1628 1694
  t 1629 1694 1628
  t 1694 1629 1695
  t 1630 1695 1629
  t 1695 1630 1696
  t 1631 1696 1630
  t 1696 1631 1697
  t 1632 1697 1631
  t 1697 1632 1698
  t 1633 1698 1632
  t 1698 1633 1699
  t 1634 1699 1633
  t 1699 1634 1700
  t 1635 1700 1634
  t 1700 1635 1701
  t 1636 1701 1635
  t 1701 1636 1702
  t 1637 1702 1636
  t 1702 1637 1703
  t 1638 1703 1637
  t 1703 1638 1704
  t 1639 1704 1638
  t 1704 1639 1705
  t 1640 1705 1639
  t 1705 1640 1706
  t 1641 1706 1640
  t 1706 1641 1707
  t 1642 1707 1641
  t 1707 1642 1708
  t 1643 1708 1642
  t 1708 1643 1709
  t 1644 1709 1643
  t 1709 1644 1710
  t 1645 1710 1644
  t 1710 1645 1711
  t 1646 1711 1645
  t 1711 1646 1712
  t 1647 1712 1646
  t 1712 1647 1713
  t 1648 1713 1647
  t 1713 1648 1714
  t 1649 1714 1648
  t 1714 1649 1715
  t 1650 1715 1649
  t 1715 1650 1716
  t 1651 1716 1650
  t 1716 1651 1717
  t 1652 1717 1651
  t 1717 1652 1718
  t 1653 1718 1652
  t 1718 1653 1719
  t 1654 1719 1653
  t 1719 1654 1720
  t 1655 1720 1654
  t 1720 1655 1721
  t 1656 1721 1655
  t 1721 1656 1722
  t 1657 1722 1656
  t 1722 1657 1723
  t 1658 1723 1657
  t 1723 1658 1724
  t 1659 1724 1658
  t 1724 1659 1725
  t 1660 1725 1659
  t 1725 1660 1726
  t 1661 1726 1660
  t 1726 1661 1727
  t 1662 1727 1661
  t 1727 1662 1728
  t 1663 1728 1662
  t 1728 1663 1729
  t 1664 1729 1663
  t 1729 1664 1730
  t 1665 1730 1664
  t 1730 1665 1731
  t 1666 1731 1665
  t 1731 1666 1732
  t 1667 1732 1666
  t 1732 1667 1733
  t 1668 1733 1667
  t 1733 1668 1734
  t 1669 1734 1668
  t 1734 1669 1735
  t 1670 1735 1669
  t 1735 1670 1736
  t 1671 1736 1670
  t 1736 1671 1737
  t 1672 1737 1671
  t 1737 1672 1738
  t 1673 1738 1672
  t 1738 1673 1739
  t 1674 1739 1673
  t 1739 1674 1740
  t 1675 1740 1674
  t 1740 1675 1741
  t 1676 1741 1675
  t 1741 1676 1742
  t 1677 1742 1676
  t 1742 1677 1743
  t 1678 1743 1677
  t 1743 1678 1744
  t 1679 1744 1678
  t 1744 1679 1745
  t 1680 1745 1679
  t 1745 1680 1746
  t 1681 1746 1680
  t 1746 1681 1747
  t 1682 1747 1681
  t 1747 1682 1748
  t 1683 1748 1682
  t 1748 1683 1749
  t 1684 1749 1683
  t 1749 1684 1750
  t 1685 1750 1684
  t 1750 1685 1751
  t 1686 1751 1685
  t 1751 1686 1752
  t 1687 1752 1686
  t 1752 1687 1753
  t 1688 1753 1687
  t 1753 1688 1754
  t 1689 1754 1688
  t 1755 1690 1756
  t 1691 1756 1690
  t 1756 1691 1757
  t 1692 1757 1691
  t 1757 1692 1758
  t 1693 1758 1692
  t 1758 1693 1759
  t 1694 1759 1693
  t 1759 1694 1760
  t 1695 1760 1694
  t 1760 1695 1761
  t 1696 1761 1695
  t 1761 1696 1762
  t 1697 1762 1696
  t 1762 1697 1763
  t 1698 1763 1697
  t 1763 1698 1764
  t 1699 1764 1698
  t 1764 1699 1765
  t 1700 1765 1699
  t 1765 1700 1766
  t 1701 1766 1700
  t 1766 1701 1767
  t 1702 1767 1701
  t 1767 1702 1768
  t 1703 1768 1702
  t 1768 1703 1769
  t 1704 1769 1703
  t 1769 1704 1770
  t 1705 1770 1704
  t 1770 1705 1771
  t 1706 1771 1705
  t 1771 1706 1772
  t 1707 1772 1706
  t 1772 1707 1773
  t 1708 1773 1707
  t 1773 1708 1774
  t 1709 1774 1708
  t 1774 1709 1775
  t 1710 1775 1709
  t 1775 1710 1776
  t 1711 1776 1710
  t 1776 1711 1777
  t 1712 1777 1711
  t 1777 1712 1778
  t 1713 1778 1712
  t 1778 1713 1779
  t 1714 1779 1713
  t 1779 1714 1780
  t 1715 1780 1714
  t 1780 1715 1781
  t 1716 1781 1715
  t 1781 1716 1782
  t 1717 1782 1716
  t 1782 1717 1783
  t 1718 1783 1717
  t 1783 1718 1784
  t 1719 1784 1718
  t 1784 1719 1785
  t 1720 1785 1719
  t 1785 1720 1786
  t 1721 1786 1720
  t 1786 1721 1787
  t 1722 1787 1721
  t 1787 1722 1788
  t 1723 1788 1722
  t 1788 1723 1789
  t 1724 1789 1723
  t 1789 1724 1790
  t 1725 1790 1724
  t 1790 1725 1791
  t 1726 1791 1725
  t 1791 1726 1792
  t 1727 1792 1726
  t 1792 1727 1793
  t 1728 1793 1727
  t 1793 1728 1794
  t 1729 1794 1728
  t 1794 1729 1795
  t 1730 1795 1729
  t 1795 1730 1796
  t 1731 1796 1730
  t 1796 1731 1797
  t 1732 1797 1731
  t 1797 1732 1798
  t 1733 1798 1732
  t 1798 1733 1799
  t 1734 1799 1733
  t 1799 1734 1800
  t 1735 1800 1734
  t 1800 1735 1801
  t 1736 1801 1735
  t 1801 1736 1802
  t 1737 1802 1736
  t 1802 1737 1803
  t 1738 1803 1737
  t 1803 1738 1804
  t 1739 1804 1738
  t 1804 1739 1805
  t 1740 1805 1739
  t 1805 1740 1806
  t 1741 1806 1740
  t 1806 1741 1807
  t 1742 1807 1741
  t 1807 1742 1808
  t 1743 1808 1742
  t 1808 1743 1809
  t 1744 1809 1743
  t 1809 1744 1810
  t 1745 1810 1744
  t 1810 1745 1811
  t 1746 1811 1745
  t 1811 1746 1812
  t 1747 1812 1746
  t 1812 1747 1813
  t 1748 1813 1747
  t 1813 1748 1814
  t 1749 1814 1748
  t 1814 1749 1815
  t 1750 1815 1749
  t 1815 1750 1816
  t 1751 1816 1750
  t 1816 1751 1817
  t 1752 1817 1751
  t 1817 1752 1818
  t 1753 1818 1752
  t 1818 1753 1819
  t 1754 1819 1753
  t 1820 1755 1821
  t 1756 1821 1755
  t 1821 1756 1822
  t 1757 1822 1756
  t 1822 1757 1823
  t 1758 1823 1757
  t 1823 1758 1824
  t 1759 1824 1758
  t 1824 1759 1825
  t 1760 1825 1759
  t 1825 1760 1826
  t 1761 1826 1760
  t 1826 1761 1827
  t 1762 1827 1761
  t 1827 1762 1828
  t 1763 1828 1762
  t 1828 1763 1829
  t 1764 1829 1763
  t 1829 1764 1830
  t 1765 1830 1764
  t 1830 1765 1831
  t 1766 1831 1765
  t 1831 1766 1832
  t 1767 1832 1766
  t 1832 1767 1833
  t 1768 1833 1767
  t 1833 1768 1834
  t 1769 1834 1768
  t 1834 1769 1835
  t 1770 1835 1769
  t 1835 1770 1836
  t 1771 1836 1770
  t 1836 1771 1837
  t 1772 1837 1771
  t 1837 1772 1838
  t 1773 1838 1772
  t 1838 1773 1839
  t 1774 1839 1773
  t 1839 1774 1840
  t 1775 1840 1774
  t 1840 1775 1841
  t 1776 1841 1775
  t 1841 1776 1842
  t 1777 1842 1776
  t 1842 1777 1843
  t 1778 1843 1777
  t 1843 1778 1844
  t 1779 1844 1778
  t 1844 1779 1845
  t 1780 1845 1779
  t 1845 1780 1846
  t 1781 1846 1780
  t 1846 1781 1847
  t 1782 1847 1781
  t 1847 1782 1848
  t 1783 1848 1782
  t 1848 1783 1849
  t 1784 1849 1783
  t 1849 1784 1850
  t 1785 1850 1784
  t 1850 1785 1851
  t 1786 1851 1785
  t 1851 1786 1852
  t 1787 1852 1786
  t 1852 1787 1853
  t 1788 1853 1787
  t 1853 1788 1854
  t 1789 1854 1788
  t 1854 1789 1855
  t 1790 1855 1789
  t 1855 1790 1856
  t 1791 1856 1790
  t 1856 1791 1857
  t 1792 1857 1791
  t 1857 1792 1858
  t 1793 1858 1792
  t 1858 1793 1859
  t 1794 1859 1793
  t 1859 1794 1860
  t 1795 1860 1794
  t 1860 1795 1861
  t 1796 1861 1795
  t 1861 1796 1862
  t 1797 1862 1796
  t 1862 1797 1863
  t 1798 1863 1797
  t 1863 1798 1864
  t 1799 1864 1798
  t 1864 1799 1865
  t 1800 1865 1799
  t 1865 1800 1866
  t 1801 1866 1800
  t 1866 1801 1867
  t 1802 1867 1801
  t 1867 1802 1868
  t 1803 1868 1802
  t 1868 1803 1869
  t 1804 1869 1803
  t 1869 1804 1870
  t 1805 1870 1804
  t 1870 1805 1871
  t 1806 1871 1805
  t 1871 1806 1872
  t 1807 1872 1806
  t 1872 1807 1873
  t 1808 1873 1807
  t 1873 1808 1874
  t 1809 1874 1808
  t 1874 1809 1875
  t 1810 1875 1809
  t 1875 1810 1876
  t 1811 1876 1810
  t 1876 1811 1877
  t 1812 1877 1811
  t 1877 1812 1878
  t 1813 1878 1812
  t 1878 1813 1879
  t 1814 1879 1813
  t 1879 1814 1880
  t 1815 1880 1814
  t 1880 1815 1881
  t 1816 1881 1815
  t 1881 1816 1882
  t 1817 1882 1816
  t 1882 1817 1883
  t 1818 1883 1817
  t 1883 1818 1884
  t 1819 1884 1818
  t 1885 1820 1886
  t 1821 1886 1820
  t 1886 1821 1887
  t 1822 1887 1821
  t 1887 1822 1888
  t 1823 1888 1822
  t 1888 1823 1889
  t 1824 1889 1823
  t 1889 1824 1890
  t 1825 1890 1824
  t 1890 1825 1891
  t 1826 1891 1825
  t 1891 1826 1892
  t 1827 1892 1826
  t 1892 1827 1893
  t 1828 1893 1827
  t 1893 1828 1894
  t 1829 1894 1828
  t 1894 1829 1895
  t 1830 1895 1829
  t 1895 1830 1896
  t 1831 1896 1830
  t 1896 1831 1897
  t 1832 1897 1831
  t 1897 1832 1898
  t 1833 1898 1832
  t 1898 1833 1899
  t 1834 1899 1833
  t 1899 1834 1900
  t 1835 1900 1834
  t 1900 1835 1901
  t 1836 1901 1835
  t 1901 1836 1902
  t 1837 1902 1836
  t 1902 1837 1903
  t 1838 1903 1837
  t 1903 1838 1904
  t 1839 1904 1838
  t 1904 1839 1905
  t 1840 1905 1839
  t 1905 1840 1906
  t 1841 1906 1840
  t 1906 1841 1907
  t 1842 1907 1841
  t 1907 1842 1908
  t 1843 1908 1842
  t 1908 1843 1909
  t 1844 1909 1843
  t 1909 1844 1910
  t 1845 1910 1844
  t 1910 1845 1911
  t 1846 1911 1845
  t 1911 1846 1912
  t 1847 1912 1846
  t 1912 1847 1913
  t 1848 1913 1847
  t 1913 1848 1914
  t 1849 1914 1848
  t 1914 1849 1915
  t 1850 1915 1849
  t 1915 1850 1916
  t 1851 1916 1850
  t 1916 1851 1917
  t 1852 1917 1851
  t 1917 1852 1918
  t 1853 1918 1852
  t 1918 1853 1919
  t 1854 1919 1853
  t 1919 1854 1920
  t 1855 1920 1854
  t 1920 1855 1921
  t 1856 1921 1855
  t 1921 1856 1922
  t 1857 1922 1856
  t 1922 1857 1923
  t 1858 1923 1857
  t 1923 1858 1924
  t 1859 1924 1858
  t 1924 1859 1925
  t 1860 1925 1859
  t 1925 1860 1926
  t 1861 1926 1860
  t 1926 1861 1927
  t 1862 1927 1861
  t 1927 1862 1928
  t 1863 1928 1862
  t 1928 1863 1929
  t 1864 1929 1863
  t 1929 1864 1930
  t 1865 1930 1864
  t 1930 1865 1931
  t 1866 1931 1865
  t 1931 1866 1932
  t 1867 1932 1866
  t 1932 1867 1933
  t 1868 1933 1867
  t 1933 1868 1934
  t 1869 1934 1868
  t 1934 1869 1935
  t 1870 1935 1869
  t 1935 1870 1936
  t 1871 1936 1870
  t 1936 1871 1937
  t 1872 1937 1871
  t 1937 1872 1938
  t 1873 1938 1872
  t 1938 1873 1939
  t 1874 1939 1873
  t 1939 1874 1940
  t 1875 1940 1874
  t 1940 1875 1941
  t 1876 1941 1875
  t 1941 1876 1942
  t 1877 1942 1876
  t 1942 1877 1943
  t 1878 1943 1877
  t 1943 1878 1944
  t 1879 1944 1878
  t 1944 1879 1945
  t 1880 1945 1879
  t 1945 1880 1946
  t 1881 1946 1880
  t 1946 1881 1947
  t 1882 1947 1881
  t 1947 1882 1948
  t 1883 1948 1882
  t 1948 1883 1949
  t 1884 1949 1883
  t 1950 1885 1951
  t 1886 1951 1885
  t 1951 1886 1952
  t 1887 1952 1886
  t 1952 1887 1953
  t 1888 1953 1887
  t 1953 1888 1954
  t 1889 1954 1888
  t 1954 1889 1955
  t 1890 1955 1889
  t 1955 1890 1956
  t 1891 1956 1890
  t 1956 1891 1957
  t 1892 1957 1891
  t 1957 1892 1958
  t 1893 1958 1892
  t 1958 1893 1959
  t 1894 1959 1893
  t 1959 1894 1960
  t 1895 1960 1894
  t 1960 1895 1961
  t 1896 1961 1895
  t 1961 1896 1962
  t 1897 1962 1896
  t 1962 1897 1963
  t 1898 1963 1897
  t 1963 1898 1964
  t 1899 1964 1898
  t 1964 1899 1965
  t 1900 1965 1899
  t 1965 1900 1966
  t 1901 1966 1900
  t 1966 1901 1967
  t 1902 1967 1901
  t 1967 1902 1968
  t 1903 1968 1902
  t 1968 1903 1969
  t 1904 1969 1903
  t 1969 1904 1970
  t 1905 1970 1904
  t 1970 1905 1971
  t 1906 1971 1905
  t 1971 1906 1972
  t 1907 1972 1906
  t 1972 1907 1973
  t 1908 1973 1907
  t 1973 1908 1974
  t 1909 1974 1908
  t 1974 1909 1975
  t 1910 1975 1909
  t 1975 1910 1976
  t 1911 1976 1910
  t 1976 1911 1977
  t 1912 1977 1911
  t 1977 1912 1978
  t 1913 1978 1912
  t 1978 1913 1979
  t 1914 1979 1913
  t 1979 1914 1980
  t 1915 1980 1914
  t 1980 1915 1981
  t 1916 1981 1915
  t 1981 1916 1982
  t 1917 1982 1916
  t 1982 1917 1983
  t 1918 1983 1917
  t 1983 1918 1984
  t 1919 1984 1918
  t 1984 1919 1985
  t 1920 1985 1919
  t 1985 1920 1986
  t 1921 1986 1920
  t 1986 1921 1987
  t 1922 1987 1921
  t 1987 1922 1988
  t 1923 1988 1922
  t 1988 1923 1989
  t 1924 1989 1923
  t 1989 1924 1990
  t 1925 1990 1924
  t 1990 1925 1991
  t 1926 1991 1925
  t 1991 1926 1992
  t 1927 1992 1926
  t 1992 1927 1993
  t 1928 1993 1927
  t 1993 1928 1994
  t 1929 1994 1928
  t 1994 1929 1995
  t 1930 1995 1929
  t 1995 1930 1996
  t 1931 1996 1930
  t 1996 1931 1997
  t 1932 1997 1931
  t 1997 1932 1998
  t 1933 1998 1932
  t 1998 1933 1999
  t 1934 1999 1933
  t 1999 1934 2000
  t 1935 2000 1934
  t 2000 1935 2001
  t 1936 2001 1935
  t 2001 1936 2002
  t 1937 2002 1936
  t 2002 1937 2003
  t 1938 2003 1937
  t 2003 1938 2004
  t 1939 2004 1938
  t 2004 1939 2005
  t 1940 2005 1939
  t 2005 1940 2006
  t 1941 2006 1940
  t 2006 1941 2007
  t 1942 2007 1941
  t 2007 1942 2008
  t 1943 2008 1942
  t 2008 1943 2009
  t 1944 2009 1943
  t 2009 1944 2010
  t 1945 2010 1944
  t 2010 1945 2011
  t 1946 2011 1945
  t 2011 1946 2012
  t 1947 2012 1946
  t 2012 1947 2013
  t 1948 2013 1947
  t 2013 1948 2014
  t 1949 2014 1948
  t 2015 1950 2016
  t 1951 2016 1950
  t 2016 1951 2017
  t 1952 2017 1951
  t 2017 1952 2018
  t 1953 2018 1952
  t 2018 1953 2019
  t 1954 2019 1953
  t 2019 1954 2020
  t 1955 2020 1954
  t 2020 1955 2021
  t 1956 2021 1955
  t 2021 1956 2022
  t 1957 2022 1956
  t 2022 1957 2023
  t 1958 2023 1957
  t 2023 1958 2024
  t 1959 2024 1958
  t 2024 1959 2025
  t 1960 2025 1959
  t 2025 1960 2026
  t 1961 2026 1960
  t 2026 1961 2027
  t 1962 2027 1961
  t 2027 1962 2028
  t 1963 2028 1962
  t 2028 1963 2029
  t 1964 2029 1963
  t 2029 1964 2030
  t 1965 2030 1964
  t 2030 1965 2031
  t 1966 2031 1965
  t 2031 1966 2032
  t 1967 2032 1966
  t 2032 1967 2033
  t 1968 2033 1967
  t 2033 1968 2034
  t 1969 2034 1968
  t 2034 1969 2035
  t 1970 2035 1969
  t 2035 1970 2036
  t 1971 2036 1970
  t 2036 1971 2037
  t 1972 2037 1971
  t 2037 1972 2038
  t 1973 2038 1972
  t 2038 1973 2039
  t 1974 2039 1973
  t 2039 1974 2040
  t 1975 2040 1974
  t 2040 1975 2041
  t 1976 2041 1975
  t 2041 1976 2042
  t 1977 2042 1976
  t 2042 1977 2043
  t 1978 2043 1977
  t 2043 1978 2044
  t 1979 2044 1978
  t 2044 1979 2045
  t 1980 2045 1979
  t 2045 1980 2046
  t 1981 2046 1980
  t 2046 1981 2047
  t 1982 2047 1981
  t 2047 1982 2048
  t 1983 2048 1982
  t 2048 1983 2049
  t 1984 2049 1983
  t 2049 1984 2050
  t 1985 2050 1984
  t 2050 1985 2051
  t 1986 2051 1985
  t 2051 1986 2052
  t 1987 2052 1986
  t 2052 1987 2053
  t 1988 2053 1987
  t 2053 1988 2054
  t 1989 2054 1988
  t 2054 1989 2055
  t 1990 2055 1989
  t 2055 1990 2056
  t 1991 2056 1990
  t 2056 1991 2057
  t 1992 2057 1991
  t 2057 1992 2058
  t 1993 2058 1992
  t 2058 1993 2059
  t 1994 2059 1993
  t 2059 1994 2060
  t 1995 2060 1994
  t 2060 1995 2061
  t 1996 2061 1995
  t 2061 1996 2062
  t 1997 2062 1996
  t 2062 1997 2063
  t 1998 2063 1997
  t 2063 1998 2064
  t 1999 2064 1998
  t 2064 1999 2065
  t 2000 2065 1999
  t 2065 2000 2066
  t 2001 2066 2000
  t 2066 2001 2067
  t 2002 2067 2001
  t 2067 2002 2068
  t 2003 2068 2002
  t 2068 2003 2069
  t 2004 2069 2003
  t 2069 2004 2070
  t 2005 2070 2004
  t 2070 2005 2071
  t 2006 2071 2005
  t 2071 2006 2072
  t 2007 2072 2006
  t 2072 2007 2073
  t 2008 2073 2007
  t 2073 2008 2074
  t 2009 2074 2008
  t 2074 2009 2075
  t 2010 2075 2009
  t 2075 2010 2076
  t 2011 2076 2010
  t 2076 2011 2077
  t 2012 2077 2011
  t 2077 2012 2078
  t 2013 2078 2012
  t 2078 2013 2079
  t 2014 2079 2013
  t 2080 2015 2081
  t 2016 2081 2015
  t 2081 2016 2082
  t 2017 2082 2016
  t 2082 2017 2083
  t 2018 2083 2017
  t 2083 2018 2084
  t 2019 2084 2018
  t 2084 2019 2085
  t 2020 2085 2019
  t 2085 2020 2086
  t 2021 2086 2020
  t 2086 2021 2087
  t 2022 2087 2021
  t 2087 2022 2088
  t 2023 2088 2022
  t 2088 2023 2089
  t 2024 2089 2023
  t 2089 2024 2090
  t 2025 2090 2024
  t 2090 2025 2091
  t 2026 2091 2025
  t 2091 2026 2092
  t 2027 2092 2026
  t 2092 2027 2093
  t 2028 2093 2027
  t 2093 2028 2094
  t 2029 2094 2028
  t 2094 2029 2095
  t 2030 2095 2029
  t 2095 2030 2096
  t 2031 2096 2030
  t 2096 2031 2097
  t 2032 2097 2031
  t 2097 2032 2098
  t 2033 2098 2032
  t 2098 2033 2099
  t 2034 2099 2033
  t 2099 2034 2100
  t 2035 2100 2034
  t 2100 2035 2101
  t 2036 2101 2035
  t 2101 2036 2102
  t 2037 2102 2036
  t 2102 2037 2103
  t 2038 2103 2037
  t 2103 2038 2104
  t 2039 2104 2038
  t 2104 2039 2105
  t 2040 2105 2039
  t 2105 2040 2106
  t 2041 2106 2040
  t 2106 2041 2107
  t 2042 2107 2041
  t 2107 2042 2108
  t 2043 2108 2042
  t 2108 2043 2109
  t 2044 2109 2043
  t 2109 2044 2110
  t 2045 2110 2044
  t 2110 2045 2111
  t 2046 2111 2045
  t 2111 2046 2112
  t 2047 2112 2046
  t 2112 2047 2113
  t 2048 2113 2047
  t 2113 2048 2114
  t 2049 2114 2048
  t 2114 2049 2115
  t 2050 2115 2049
  t 2115 2050 2116
  t 2051 2116 2050
  t 2116 2051 2117
  t 2052 2117 2051
  t 2117 2052 2118
  t 2053 2118 2052
  t 2118 2053 2119
  t 2054 2119 2053
  t 2119 2054 2120
  t 2055 2120 2054
  t 2120 2055 2121
  t 2056 2121 2055
  t 2121 2056 2122
  t 2057 2122 2056
  t 2122 2057 2123
  t 2058 2123 2057
  t 2123 2058 2124
  t 2059 2124 2058
  t 2124 2059 2125
  t 2060 2125 2059
  t 2125 2060 2126
  t 2061 2126 2060
  t 2126 2061 2127
  t 2062 2127 2061
  t 2127 2062 2128
  t 2063 2128 2062
  t 2128 2063 2129
  t 2064 2129 2063
  t 2129 2064 2130
  t 2065 2130 2064
  t 2130 2065 2131
  t 2066 2131 2065
  t 2131 2066 2132
  t 2067 2132 2066
  t 2132 2067 2133
  t 2068 2133 2067
  t 2133 2068 2134
  t 2069 2134 2068
  t 2134 2069 2135
  t 2070 2135 2069
  t 2135 2070 2136
  t 2071 2136 2070
  t 2136 2071 2137
  t 2072 2137 2071
  t 2137 2072 2138
  t 2073 2138 2072
  t 2138 2073 2139
  t 2074 2139 2073
  t 2139 2074 2140
  t 2075 2140 2074
  t 2140 2075 2141
  t 2076 2141 2075
  t 2141 2076 2142
  t 2077 2142 2076
  t 2142 2077 2143
  t 2078 2143 2077
  t 2143 2078 2144
  t 2079 2144 2078
  t 2145 2080 2146
  t 2081 2146 2080
  t 2146 2081 2147
  t 2082 2147 2081
  t 2147 2082 2148
  t 2083 2148 2082
  t 2148 2083 2149
  t 2084 2149 2083
  t 2149 2084 2150
  t 2085 2150 2084
  t 2150 2085 2151
  t 2086 2151 2085
  t 2151 2086 2152
  t 2087 2152 2086
  t 2152 2087 2153
  t 2088 2153 2087
  t 2153 2088 2154
  t 2089 2154 2088
  t 2154 2089 2155
  t 2090 2155 2089
  t 2155 2090 2156
  t 2091 2156 2090
  t 2156 2091 2157
  t 2092 2157 2091
  t 2157 2092 2158
  t 2093 2158 2092
  t 2158 2093 2159
  t 2094 2159 2093
  t 2159 2094 2160
  t 2095 2160 2094
  t 2160 2095 2161
  t 2096 2161 2095
  t 2161 2096 2162
  t 2097 2162 2096
  t 2162 2097 2163
  t 2098 2163 2097
  t 2163 2098 2164
  t 2099 2164 2098
  t 2164 2099 2165
  t 2100 2165 2099
  t 2165 2100 2166
  t 2101 2166 2100
  t 2166 2101 2167
  t 2102 2167 2101
  t 2167 2102 2168
  t 2103 2168 2102
  t 2168 2103 2169
  t 2104 2169 2103
  t 2169 2104 2170
  t 2105 2170 2104
  t 2170 2105 2171
  t 2106 2171 2105
  t 2171 2106 2172
  t 2107 2172 2106
  t 2172 2107 2173
  t 2108 2173 2107
  t 2173 2108 2174
  t 2109 2174 2108
  t 2174 2109 2175
  t 2110 2175 2109
  t 2175 2110 2176
  t 2111 2176 2110
  t 2176 2111 2177
  t 2112 2177 2111
  t 2177 2112 2178
  t 2113 2178 2112
  t 2178 2113 2179
  t 2114 2179 2113
  t 2179 2114 2180
  t 2115 2180 2114
  t 2180 2115 2181
  t 2116 2181 2115
  t 2181 2116 2182
  t 2117 2182 2116
  t 2182 2117 2183
  t 2118 2183 2117
  t 2183 2118 2184
  t 2119 2184 2118
  t 2184 2119 2185
  t 2120 2185 2119
  t 2185 2120 2186
  t 2121 2186 2120
  t 2186 2121 2187
  t 2122 2187 2121
  t 2187 2122 2188
  t 2123 2188 2122
  t 2188 2123 2189
  t 2124 2189 2123
  t 2189 2124 2190
  t 2125 2190 2124
  t 2190 2125 2191
  t 2126 2191 2125
  t 2191 2126 2192
  t 2127 2192 2126
  t 2192 2127 2193
  t 2128 2193 2127
  t 2193 2128 2194
  t 2129 2194 2128
  t 2194 2129 2195
  t 2130 2195 2129
  t 2195 2130 2196
  t 2131 2196 2130
  t 2196 2131 2197
  t 2132 2197 2131
  t 2197 2132 2198
  t 2133 2198 2132
  t 2198 2133 2199
  t 2134 2199 2133
  t 2199 2134 2200
  t 2135 2200 2134
  t 2200 2135 2201
  t 2136 2201 2135
  t 2201 2136 2202
  t 2137 2202 2136
  t 2202 2137 2203
  t 2138 2203 2137
  t 2203 2138 2204
  t 2139 2204 2138
  t 2204 2139 2205
  t 2140 2205 2139
  t 2205 2140 2206
  t 2141 2206 2140
  t 2206 2141 2207
  t 2142 2207 2141
  t 2207 2142 2208
  t 2143 2208 2142
  t 2208 2143 2209
  t 2144 2209 2143
  t 2210 2145 2211
  t 2146 2211 2145
  t 2211 2146 2212
  t 2147 2212 2146
  t 2212 2147 2213
  t 2148 2213 2147
  t 2213 2148 2214
  t 2149 2214 2148
  t 2214 2149 2215
  t 2150 2215 2149
  t 2215 2150 2216
  t 2151 2216 2150
  t 2216 2151 2217
  t 2152 2217 2151
  t 2217 2152 2218
  t 2153 2218 2152
  t 2218 2153 2219
  t 2154 2219 2153
  t 2219 2154 2220
  t 2155 2220 2154
  t 2220 2155 2221
  t 2156 2221 2155
  t 2221 2156 2222
  t 2157 2222 2156
  t 2222 2157 2223
  t 2158 2223 2157
  t 2223 2158 2224
  t 2159 2224 2158
  t 2224 2159 2225
  t 2160 2225 2159
  t 2225 2160 2226
  t 2161 2226 2160
  t 2226 2161 2227
  t 2162 2227 2161
  t 2227 2162 2228
  t 2163 2228 2162
  t 2228 2163 2229
  t 2164 2229 2163
  t 2229 2164 2230
  t 2165 2230 2164
  t 2230 2165 2231
  t 2166 2231 2165
  t 2231 2166 2232
  t 2167 2232 2166
  t 2232 2167 2233
  t 2168 2233 2167
  t 2233 2168 2234
  t 2169 2234 2168
  t 2234 2169 2235
  t 2170 2235 2169
  t 2235 2170 2236
  t 2171 2236 2170
  t 2236 2171 2237
  t 2172 2237 2171
  t 2237 2172 2238
  t 2173 2238 2172
  t 2238 2173 2239
  t 2174 2239 2173
  t 2239 2174 2240
  t 2175 2240 2174
  t 2240 2175 2241
  t 2176 2241 2175
  t 2241 2176 2242
  t 2177 2242 2176
  t 2242 2177 2243
  t 2178 2243 2177
  t 2243 2178 2244
  t 2179 2244 2178
  t 2244 2179 2245
  t 2180 2245 2179
  t 2245 2180 2246
  t 2181 2246 2180
  t 2246 2181 2247
  t 2182 2247 2181
  t 2247 2182 2248
  t 2183 2248 2182
  t 2248 2183 2249
  t 2184 2249 2183
  t 2249 2184 2250
  t 2185 2250 2184
  t 2250 2185 2251
  t 2186 2251 2185
  t 2251 2186 2252
  t 2187 2252 2186
  t 2252 2187 2253
  t 2188 2253 2187
  t 2253 2188 2254
  t 2189 2254 2188
  t 2254 2189 2255
  t 2190 2255 2189
  t 2255 2190 2256
  t 2191 2256 2190
  t 2256 2191 2257
  t 2192 2257 2191
  t 2257 2192 2258
  t 2193 2258 2192
  t 2258 2193 2259
  t 2194 2259 2193
  t 2259 2194 2260
  t 2195 2260 2194
  t 2260 2195 2261
  t 2196 2261 2195
  t 2261 2196 2262
  t 2197 2262 2196
  t 2262 2197 2263
  t 2198 2263 2197
  t 2263 2198 2264
  t 2199 2264 2198
  t 2264 2199 2265
  t 2200 2265 2199
  t 2265 2200 2266
  t 2201 2266 2200
  t 2266 2201 2267
  t 2202 2267 2201
  t 2267 2202 2268
  t 2203 2268 2202
  t 2268 2203 2269
  t 2204 2269 2203
  t 2269 2204 2270
  t 2205 2270 2204
  t 2270 2205 2271
  t 2206 2271 2205
  t 2271 2206 2272
  t 2207 2272 2206
  t 2272 2207 2273
  t 2208 2273 2207
  t 2273 2208 2274
  t 2209 2274 2208
  t 2275 2210 2276
  t 2211 2276 2210
  t 2276 2211 2277
  t 2212 2277 2211
  t 2277 2212 2278
  t 2213 2278 2212
  t 2278 2213 2279
  t 2214 2279 2213
  t 2279 2214 2280
  t 2215 2280 2214
  t 2280 2215 2281
  t 2216 2281 2215
  t 2281 2216 2282
  t 2217 2282 2216
  t 2282 2217 2283
  t 2218 2283 2217
  t 2283 2218 2284
  t 2219 2284 2218
  t 2284 2219 2285
  t 2220 2285 2219
  t 2285 2220 2286
  t 2221 2286 2220
  t 2286 2221 2287
  t 2222 2287 2221
  t 2287 2222 2288
  t 2223 2288 2222
  t 2288 2223 2289
  t 2224 2289 2223
  t 2289 2224 2290
  t 2225 2290 2224
  t 2290 2225 2291
  t 2226 2291 2225
  t 2291 2226 2292
  t 2227 2292 2226
  t 2292 2227 2293
  t 2228 2293 2227
  t 2293 2228 2294
  t 2229 2294 2228
  t 2294 2229 2295
  t 2230 2295 2229
  t 2295 2230 2296
  t 2231 2296 2230
  t 2296 2231 2297
  t 2232 2297 2231
  t 2297 2232 2298
  t 2233 2298 2232
  t 2298 2233 2299
  t 2234 2299 2233
  t 2299 2234 2300
  t 2235 2300 2234
  t 2300 2235 2301
  t 2236 2301 2235
  t 2301 2236 2302
  t 2237 2302 2236
  t 2302 2237 2303
  t 2238 2303 2237
  t 2303 2238 2304
  t 2239 2304 2238
  t 2304 2239 2305
  t 2240 2305 2239
  t 2305 2240 2306
  t 2241 2306 2240
  t 2306 2241 2307
  t 2242 2307 2241
  t 2307 2242 2308
  t 2243 2308 2242
  t 2308 2243 2309
  t 2244 2309 2243
  t 2309 2244 2310
  t 2245 2310 2244
  t 2310 2245 2311
  t 2246 2311 2245
  t 2311 2246 2312
  t 2247 2312 2246
  t 2312 2247 2313
  t 2248 2313 2247
  t 2313 2248 2314
  t 2249 2314 2248
  t 2314 2249 2315
  t 2250 2315 2249
  t 2315 2250 2316
  t 2251 2316 2250
  t 2316 2251 2317
  t 2252 2317 2251
  t 2317 2252 2318
  t 2253 2318 2252
  t 2318 2253 2319
  t 2254 2319 2253
  t 2319 2254 2320
  t 2255 2320 2254
  t 2320 2255 2321
  t 2256 2321 2255
  t 2321 2256 2322
  t 2257 2322 2256
  t 2322 2257 2323
  t 2258 2323 2257
  t 2323 2258 2324
  t 2259 2324 2258
  t 2324 2259 2325
  t 2260 2325 2259
  t 2325 2260 2326
  t 2261 2326 2260
  t 2326 2261 2327
  t 2262 2327 2261
  t 2327 2262 2328
  t 2263 2328 2262
  t 2328 2263 2329
  t 2264 2329 2263
  t 2329 2264 2330
  t 2265 2330 2264
  t 2330 2265 2331
  t 2266 2331 2265
  t 2331 2266 2332
  t 2267 2332 2266
  t 2332 2267 2333
  t 2268 2333 2267
  t 2333 2268 2334
  t 2269 2334 2268
  t 2334 2269 2335
  t 2270 2335 2269
  t 2335 2270 2336
  t 2271 2336 2270
  t 2336 2271 2337
  t 2272 2337 2271
  t 2337 2272 2338
  t 2273 2338 2272
  t 2338 2273 2339
  t 2274 2339 2273
  t 2340 2275 2341
  t 2276 2341 2275
  t 2341 2276 2342
  t 2277 2342 2276
  t 2342 2277 2343
  t 2278 2343 2277
  t 2343 2278 2344
  t 2279 2344 2278
  t 2344 2279 2345
  t 2280 2345 2279
  t 2345 2280 2346
  t 2281 2346 2280
  t 2346 2281 2347
  t 2282 2347 2281
  t 2347 2282 2348
  t 2283 2348 2282
  t 2348 2283 2349
  t 2284 2349 2283
  t 2349 2284 2350
  t 2285 2350 2284
  t 2350 2285 2351
  t 2286 2351 2285
  t 2351 2286 2352
  t 2287 2352 2286
  t 2352 2287 2353
  t 2288 2353 2287
  t 2353 2288 2354
  t 2289 2354 2288
  t 2354 2289 2355
  t 2290 2355 2289
  t 2355 2290 2356
  t 2291 2356 2290
  t 2356 2291 2357
  t 2292 2357 2291
  t 2357 2292 2358
  t 2293 2358 2292
  t 2358 2293 2359
  t 2294 2359 2293
  t 2359 2294 2360
  t 2295 2360 2294
  t 2360 2295 2361
  t 2296 2361 2295
  t 2361 2296 2362
  t 2297 2362 2296
  t 2362 2297 2363
  t 2298 2363 2297
  t 2363 2298 2364
  t 2299 2364 2298
  t 2364 2299 2365
  t 2300 2365 2299
  t 2365 2300 2366
  t 2301 2366 2300
  t 2366 2301 2367
  t 2302 2367 2301
  t 2367 2302 2368
  t 2303 2368 2302
  t 2368 2303 2369
  t 2304 2369 2303
  t 2369 2304 2370
  t 2305 2370 2304
  t 2370 2305 2371
  t 2306 2371 2305
  t 2371 2306 2372
  t 2307 2372 2306
  t 2372 2307 2373
  t 2308 2373 2307
  t 2373 2308 2374
  t 2309 2374 2308
  t 2374 2309 2375
  t 2310 2375 2309
  t 2375 2310 2376
  t 2311 2376 2310
  t 2376 2311 2377
  t 2312 2377 2311
  t 2377 2312 2378
  t 2313 2378 2312
  t 2378 2313 2379
  t 2314 2379 2313
  t 2379 2314 2380
  t 2315 2380 2314
  t 2380 2315 2381
  t 2316 2381 2315
  t 2381 2316 2382
  t 2317 2382 2316
  t 2382 2317 2383
  t 2318 2383 2317
  t 2383 2318 2384
  t 2319 2384 2318
  t 2384 2319 2385
  t 2320 2385 2319
  t 2385 2320 2386
  t 2321 2386 2320
  t 2386 2321 2387
  t 2322 2387 2321
  t 2387 2322 2388
  t 2323 2388 2322
  t 2388 2323 2389
  t 2324 2389 2323
  t 2389 2324 2390
  t 2325 2390 2324
  t 2390 2325 2391
  t 2326 2391 2325
  t 2391 2326 2392
  t 2327 2392 2326
  t 2392 2327 2393
  t 2328 2393 2327
  t 2393 2328 2394
  t 2329 2394 2328
  t 2394 2329 2395
  t 2330 2395 2329
  t 2395 2330 2396
  t 2331 2396 2330
  t 2396 2331 2397
  t 2332 2397 2331
  t 2397 2332 2398
  t 2333 2398 2332
  t 2398 2333 2399
  t 2334 2399 2333
  t 2399 2334 2400
  t 2335 2400 2334
  t 2400 2335 2401
  t 2336 2401 2335
  t 2401 2336 2402
  t 2337 2402 2336
  t 2402 2337 2403
  t 2338 2403 2337
  t 2403 2338 2404
  t 2339 2404 2338
  t 2405 2340 2406
  t 2341 2406 2340
  t 2406 2341 2407
  t 2342 2407 2341
  t 2407 2342 2408
  t 2343 2408 2342
  t 2408 2343 2409
  t 2344 2409 2343
  t 2409 2344 2410
  t 2345 2410 2344
  t 2410 2345 2411
  t 2346 2411 2345
  t 2411 2346 2412
  t 2347 2412 2346
  t 2412 2347 2413
  t 2348 2413 2347
  t 2413 2348 2414
  t 2349 2414 2348
  t 2414 2349 2415
  t 2350 2415 2349
  t 2415 2350 2416
  t 2351 2416 2350
  t 2416 2351 2417
  t 2352 2417 2351
  t 2417 2352 2418
  t 2353 2418 2352
  t 2418 2353 2419
  t 2354 2419 2353
  t 2419 2354 2420
  t 2355 2420 2354
  t 2420 2355 2421
  t 2356 2421 2355
  t 2421 2356 2422
  t 2357 2422 2356
  t 2422 2357 2423
  t 2358 2423 2357
  t 2423 2358 2424
  t 2359 2424 2358
  t 2424 2359 2425
  t 2360 2425 2359
  t 2425 2360 2426
  t 2361 2426 2360
  t 2426 2361 2427
  t 2362 2427 2361
  t 2427 2362 2428
  t 2363 2428 2362
  t 2428 2363 2429
  t 2364 2429 2363
  t 2429 2364 2430
  t 2365 2430 2364
  t 2430 2365 2431
  t 2366 2431 2365
  t 2431 2366 2432
  t 2367 2432 2366
  t 2432 2367 2433
  t 2368 2433 2367
  t 2433 2368 2434
  t 2369 2434 2368
  t 2434 2369 2435
  t 2370 2435 2369
  t 2435 2370 2436
  t 2371 2436 2370
  t 2436 2371 2437
  t 2372 2437 2371
  t 2437 2372 2438
  t 2373 2438 2372
  t 2438 2373 2439
  t 2374 2439 2373
  t 2439 2374 2440
  t 2375 2440 2374
  t 2440 2375 2441
  t 2376 2441 2375
  t 2441 2376 2442
  t 2377 2442 2376
  t 2442 2377 2443
  t 2378 2443 2377
  t 2443 2378 2444
  t 2379 2444 2378
  t 2444 2379 2445
  t 2380 2445 2379
  t 2445 2380 2446
  t 2381 2446 2380
  t 2446 2381 2447
  t 2382 2447 2381
  t 2447 2382 2448
  t 2383 2448 2382
  t 2448 2383 2449
  t 2384 2449 2383
  t 2449 2384 2450
  t 2385 2450 2384
  t 2450 2385 2451
  t 2386 2451 2385
  t 2451 2386 2452
  t 2387 2452 2386
  t 2452 2387 2453
  t 2388 2453 2387
  t 2453 2388 2454
  t 2389 2454 2388
  t 2454 2389 2455
  t 2390 2455 2389
  t 2455 2390 2456
  t 2391 2456 2390
  t 2456 2391 2457
  t 2392 2457 2391
  t 2457 2392 2458
  t 2393 2458 2392
  t 2458 2393 2459
  t 2394 2459 2393
  t 2459 2394 2460
  t 2395 2460 2394
  t 2460 2395 2461
  t 2396 2461 2395
  t 2461 2396 2462
  t 2397 2462 2396
  t 2462 2397 2463
  t 2398 2463 2397
  t 2463 2398 2464
  t 2399 2464 2398
  t 2464 2399 2465
  t 2400 2465 2399
  t 2465 2400 2466
  t 2401 2466 2400
  t 2466 2401 2467
  t 2402 2467 2401
  t 2467 2402 2468
  t 2403 2468 2402
  t 2468 2403 2469
  t 2404 2469 2403
  t 2470 2405 2471
  t 2406 2471 2405
  t 2471 2406 2472
  t 2407 2472 2406
  t 2472 2407 2473
  t 2408 2473 2407
  t 2473 2408 2474
  t 2409 2474 2408
  t 2474 2409 2475
  t 2410 2475 2409
  t 2475 2410 2476
  t 2411 2476 2410
  t 2476 2411 2477
  t 2412 2477 2411
  t 2477 2412 2478
  t 2413 2478 2412
  t 2478 2413 2479
  t 2414 2479 2413
  t 2479 2414 2480
  t 2415 2480 2414
  t 2480 2415 2481
  t 2416 2481 2415
  t 2481 2416 2482
  t 2417 2482 2416
  t 2482 2417 2483
  t 2418 2483 2417
  t 2483 2418 2484
  t 2419 2484 2418
  t 2484 2419 2485
  t 2420 2485 2419
  t 2485 2420 2486
  t 2421 2486 2420
  t 2486 2421 2487
  t 2422 2487 2421
  t 2487 2422 2488
  t 2423 2488 2422
  t 2488 2423 2489
  t 2424 2489 2423
  t 2489 2424 2490
  t 2425 2490 2424
  t 2490 2425 2491
  t 2426 2491 2425
  t 2491 2426 2492
  t 2427 2492 2426
  t 2492 2427 2493
  t 2428 2493 2427
  t 2493 2428 2494
  t 2429 2494 2428
  t 2494 2429 2495
  t 2430 2495 2429
  t 2495 2430 2496
  t 2431 2496 2430
  t 2496 2431 2497
  t 2432 2497 2431
  t 2497 2432 2498
  t 2433 2498 2432
  t 2498 2433 2499
  t 2434 2499 2433
  t 2499 2434 2500
  t 2435 2500 2434
  t 2500 2435 2501
  t 2436 2501 2435
  t 2501 2436 2502
  t 2437 2502 2436
  t 2502 2437 2503
  t 2438 2503 2437
  t 2503 2438 2504
  t 2439 2504 2438
  t 2504 2439 2505
  t 2440 2505 2439
  t 2505 2440 2506
  t 2441 2506 2440
  t 2506 2441 2507
  t 2442 2507 2441
  t 2507 2442 2508
  t 2443 2508 2442
  t 2508 2443 2509
  t 2444 2509 2443
  t 2509 2444 2510
  t 2445 2510 2444
  t 2510 2445 2511
  t 2446 2511 2445
  t 2511 2446 2512
  t 2447 2512 2446
  t 2512 2447 2513
  t 2448 2513 2447
  t 2513 2448 2514
  t 2449 2514 2448
  t 2514 2449 2515
  t 2450 2515 2449
  t 2515 2450 2516
  t 2451 2516 2450
  t 2516 2451 2517
  t 2452 2517 2451
  t 2517 2452 2518
  t 2453 2518 2452
  t 2518 2453 2519
  t 2454 2519 2453
  t 2519 2454 2520
  t 2455 2520 2454
  t 2520 2455 2521
  t 2456 2521 2455
  t 2521 2456 2522
  t 2457 2522 2456
  t 2522 2457 2523
  t 2458 2523 2457
  t 2523 2458 2524
  t 2459 2524 2458
  t 2524 2459 2525
  t 2460 2525 2459
  t 2525 2460 2526
  t 2461 2526 2460
  t 2526 2461 2527
  t 2462 2527 2461
  t 2527 2462 2528
  t 2463 2528 2462
  t 2528 2463 2529
  t 2464 2529 2463
  t 2529 2464 2530
  t 2465 2530 2464
  t 2530 2465 2531
  t 2466 2531 2465
  t 2531 2466 2532
  t 2467 2532 2466
  t 2532 2467 2533
  t 2468 2533 2467
  t 2533 2468 2534
  t 2469 2534 2468
  t 2535 2470 2536
  t 2471 2536 2470
  t 2536 2471 2537
  t 2472 2537 2471
  t 2537 2472 2538
  t 2473 2538 2472
  t 2538 2473 2539
  t 2474 2539 2473
  t 2539 2474 2540
  t 2475 2540 2474
  t 2540 2475 2541
  t 2476 2541 2475
  t 2541 2476 2542
  t 2477 2542 2476
  t 2542 2477 2543
  t 2478 2543 2477
  t 2543 2478 2544
  t 2479 2544 2478
  t 2544 2479 2545
  t 2480 2545 2479
  t 2545 2480 2546
  t 2481 2546 2480
  t 2546 2481 2547
  t 2482 2547 2481
  t 2547 2482 2548
  t 2483 2548 2482
  t 2548 2483 2549
  t 2484 2549 2483
  t 2549 2484 2550
  t 2485 2550 2484
  t 2550 2485 2551
  t 2486 2551 2485
  t 2551 2486 2552
  t 2487 2552 2486
  t 2552 2487 2553
  t 2488 2553 2487
  t 2553 2488 2554
  t 2489 2554 2488
  t 2554 2489 2555
  t 2490 2555 2489
  t 2555 2490 2556
  t 2491 2556 2490
  t 2556 2491 2557
  t 2492 2557 2491
  t 2557 2492 2558
  t 2493 2558 2492
  t 2558 2493 2559
  t 2494 2559 2493
  t 2559 2494 2560
  t 2495 2560 2494
  t 2560 2495 2561
  t 2496 2561 2495
  t 2561 2496 2562
  t 2497 2562 2496
  t 2562 2497 2563
  t 2498 2563 2497
  t 2563 2498 2564
  t 2499 2564 2498
  t 2564 2499 2565
  t 2500 2565 2499
  t 2565 2500 2566
  t 2501 2566 2500
  t 2566 2501 2567
  t 2502 2567 2501
  t 2567 2502 2568
  t 2503 2568 2502
  t 2568 2503 2569
  t 2504 2569 2503
  t 2569 2504 2570
  t 2505 2570 2504
  t 2570 2505 2571
  t 2506 2571 2505
  t 2571 2506 2572
  t 2507 2572 2506
  t 2572 2507 2573
  t 2508 2573 2507
  t 2573 2508 2574
  t 2509 2574 2508
  t 2574 2509 2575
  t 2510 2575 2509
  t 2575 2510 2576
  t 2511 2576 2510
  t 2576 2511 2577
  t 2512 2577 2511
  t 2577 2512 2578
  t 2513 2578 2512
  t 2578 2513 2579
  t 2514 2579 2513
  t 2579 2514 2580
  t 2515 2580 2514
  t 2580 2515 2581
  t 2516 2581 2515
  t 2581 2516 2582
  t 2517 2582 2516
  t 2582 2517 2583
  t 2518 2583 2517
  t 2583 2518 2584
  t 2519 2584 2518
  t 2584 2519 2585
  t 2520 2585 2519
  t 2585 2520 2586
  t 2521 2586 2520
  t 2586 2521 2587
  t 2522 2587 2521
  t 2587 2522 2588
  t 2523 2588 2522
  t 2588 2523 2589
  t 2524 2589 2523
  t 2589 2524 2590
  t 2525 2590 2524
  t 2590 2525 2591
  t 2526 2591 2525
  t 2591 2526 2592
  t 2527 2592 2526
  t 2592 2527 2593
  t 2528 2593 2527
  t 2593 2528 2594
  t 2529 2594 2528
  t 2594 2529 2595
  t 2530 2595 2529
  t 2595 2530 2596
  t 2531 2596 2530
  t 2596 2531 2597
  t 2532 2597 2531
  t 2597 2532 2598
  t 2533 2598 2532
  t 2598 2533 2599
  t 2534 2599 2533
  t 2600 2535 2601
  t 2536 2601 2535
  t 2601 2536 2602
  t 2537 2602 2536
  t 2602 2537 2603
  t 2538 2603 2537
  t 2603 2538 2604
  t 2539 2604 2538
  t 2604 2539 2605
  t 2540 2605 2539
  t 2605 2540 2606
  t 2541 2606 2540
  t 2606 2541 2607
  t 2542 2607 2541
  t 2607 2542 2608
  t 2543 2608 2542
  t 2608 2543 2609
  t 2544 2609 2543
  t 2609 2544 2610
  t 2545 2610 2544
  t 2610 2545 2611
  t 2546 2611 2545
  t 2611 2546 2612
  t 2547 2612 2546
  t 2612 2547 2613
  t 2548 2613 2547
  t 2613 2548 2614
  t 2549 2614 2548
  t 2614 2549 2615
  t 2550 2615 2549
  t 2615 2550 2616
  t 2551 2616 2550
  t 2616 2551 2617
  t 2552 2617 2551
  t 2617 2552 2618
  t 2553 2618 2552
  t 2618 2553 2619
  t 2554 2619 2553
  t 2619 2554 2620
  t 2555 2620 2554
  t 2620 2555 2621
  t 2556 2621 2555
  t 2621 2556 2622
  t 2557 2622 2556
  t 2622 2557 2623
  t 2558 2623 2557
  t 2623 2558 2624
  t 2559 2624 2558
  t 2624 2559 2625
  t 2560 2625 2559
  t 2625 2560 2626
  t 2561 2626 2560
  t 2626 2561 2627
  t 2562 2627 2561
  t 2627 2562 2628
  t 2563 2628 2562
  t 2628 2563 2629
  t 2564 2629 2563
  t 2629 2564 2630
  t 2565 2630 2564
  t 2630 2565 2631
  t 2566 2631 2565
  t 2631 2566 2632
  t 2567 2632 2566
  t 2632 2567 2633
  t 2568 2633 2567
  t 2633 2568 2634
  t 2569 2634 2568
  t 2634 2569 2635
  t 2570 2635 2569
  t 2635 2570 2636
  t 2571 2636 2570
  t 2636 2571 2637
  t 2572 2637 2571
  t 2637 2572 2638
  t 2573 2638 2572
  t 2638 2573 2639
  t 2574 2639 2573
  t 2639 2574 2640
  t 2575 2640 2574
  t 2640 2575 2641
  t 2576 2641 2575
  t 2641 2576 2642
  t 2577 2642 2576
  t 2642 2577 2643
  t 2578 2643 2577
  t 2643 2578 2644
  t 2579 2644 2578
  t 2644 2579 2645
  t 2580 2645 2579
  t 2645 2580 2646
  t 2581 2646 2580
  t 2646 2581 2647
  t 2582 2647 2581
  t 2647 2582 2648
  t 2583 2648 2582
  t 2648 2583 2649
  t 2584 2649 2583
  t 2649 2584 2650
  t 2585 2650 2584
  t 2650 2585 2651
  t 2586 2651 2585
  t 2651 2586 2652
  t 2587 2652 2586
  t 2652 2587 2653
  t 2588 2653 2587
  t 2653 2588 2654
  t 2589 2654 2588
  t 2654 2589 2655
  t 2590 2655 2589
  t 2655 2590 2656
  t 2591 2656 2590
  t 2656 2591 2657
  t 2592 2657 2591
  t 2657 2592 2658
  t 2593 2658 2592
  t 2658 2593 2659
  t 2594 2659 2593
  t 2659 2594 2660
  t 2595 2660 2594
  t 2660 2595 2661
  t 2596 2661 2595
  t 2661 2596 2662
  t 2597 2662 2596
  t 2662 2597 2663
  t 2598 2663 2597
  t 2663 2598 2664
  t 2599 2664 2598
  t 2665 2600 2666
  t 2601 2666 2600
  t 2666 2601 2667
  t 2602 2667 2601
  t 2667 2602 2668
  t 2603 2668 2602
  t 2668 2603 2669
  t 2604 2669 2603
  t 2669 2604 2670
  t 2605 2670 2604
  t 2670 2605 2671
  t 2606 2671 2605
  t 2671 2606 2672
  t 2607 2672 2606
  t 2672 2607 2673
  t 2608 2673 2607
  t 2673 2608 2674
  t 2609 2674 2608
  t 2674 2609 2675
  t 2610 2675 2609
  t 2675 2610 2676
  t 2611 2676 2610
  t 2676 2611 2677
  t 2612 2677 2611
  t 2677 2612 2678
  t 2613 2678 2612
  t 2678 2613 2679
  t 2614 2679 2613
  t 2679 2614 2680
  t 2615 2680 2614
  t 2680 2615 2681
  t 2616 2681 2615
  t 2681 2616 2682
  t 2617 2682 2616
  t 2682 2617 2683
  t 2618 2683 2617
  t 2683 2618 2684
  t 2619 2684 2618
  t 2684 2619 2685
  t 2620 2685 2619
  t 2685 2620 2686
  t 2621 2686 2620
  t 2686 2621 2687
  t 2622 2687 2621
  t 2687 2622 2688
  t 2623 2688 2622
  t 2688 2623 2689
  t 2624 2689 2623
  t 2689 2624 2690
  t 2625 2690 2624
  t 2690 2625 2691
  t 2626 2691 2625
  t 2691 2626 2692
  t 2627 2692 2626
  t 2692 2627 2693
  t 2628 2693 2627
  t 2693 2628 2694
  t 2629 2694 2628
  t 2694 2629 2695
  t 2630 2695 2629
  t 2695 2630 2696
  t 2631 2696 2630
  t 2696 2631 2697
  t 2632 2697 2631
  t 2697 2632 2698
  t 2633 2698 2632
  t 2698 2633 2699
  t 2634 2699 2633
  t 2699 2634 2700
  t 2635 2700 2634
  t 2700 2635 2701
  t 2636 2701 2635
  t 2701 2636 2702
  t 2637 2702 2636
  t 2702 2637 2703
  t 2638 2703 2637
  t 2703 2638 2704
  t 2639 2704 2638
  t 2704 2639 2705
  t 2640 2705 2639
  t 2705 2640 2706
  t 2641 2706 2640
  t 2706 2641 2707
  t 2642 2707 2641
  t 2707 2642 2708
  t 2643 2708 2642
  t 2708 2643 2709
  t 2644 2709 2643
  t 2709 2644 2710
  t 2645 2710 2644
  t 2710 2645 2711
  t 2646 2711 2645
  t 2711 2646 2712
  t 2647 2712 2646
  t 2712 2647 2713
  t 2648 2713 2647
  t 2713 2648 2714
  t 2649 2714 2648
  t 2714 2649 2715
  t 2650 2715 2649
  t 2715 2650 2716
  t 2651 2716 2650
  t 2716 2651 2717
  t 2652 2717 2651
  t 2717 2652 2718
  t 2653 2718 2652
  t 2718 2653 2719
  t 2654 2719 2653
  t 2719 2654 2720
  t 2655 2720 2654
  t 2720 2655 2721
  t 2656 2721 2655
  t 2721 2656 2722
  t 2657 2722 2656
  t 2722 2657 2723
  t 2658 2723 2657
  t 2723 2658 2724
  t 2659 2724 2658
  t 2724 2659 2725
  t 2660 2725 2659
  t 2725 2660 2726
  t 2661 2726 2660
  t 2726 2661 2727
  t 2662 2727 2661
  t 2727 2662 2728
  t 2663 2728 2662
  t 2728 2663 2729
  t 2664 2729 2663
  t 2730 2665 2731
  t 2666 2731 2665
  t 2731 2666 2732
  t 2667 2732 2666
  t 2732 2667 2733
  t 2668 2733 2667
  t 2733 2668 2734
  t 2669 2734 2668
  t 2734 2669 2735
  t 2670 2735 2669
  t 2735 2670 2736
  t 2671 2736 2670
  t 2736 2671 2737
  t 2672 2737 2671
  t 2737 2672 2738
  t 2673 2738 2672
  t 2738 2673 2739
  t 2674 2739 2673
  t 2739 2674 2740
  t 2675 2740 2674
  t 2740 2675 2741
  t 2676 2741 2675
  t 2741 2676 2742
  t 2677 2742 2676
  t 2742 2677 2743
  t 2678 2743 2677
  t 2743 2678 2744
  t 2679 2744 2678
  t 2744 2679 2745
  t 2680 2745 2679
  t 2745 2680 2746
  t 2681 2746 2680
  t 2746 2681 2747
  t 2682 2747 2681
  t 2747 2682 2748
  t 2683 2748 2682
  t 2748 2683 2749
  t 2684 2749 2683
  t 2749 2684 2750
  t 2685 2750 2684
  t 2750 2685 2751
  t 2686 2751 2685
  t 2751 2686 2752
  t 2687 2752 2686
  t 2752 2687 2753
  t 2688 2753 2687
  t 2753 2688 2754
  t 2689 2754 2688
  t 2754 2689 2755
  t 2690 2755 2689
  t 2755 2690 2756
  t 2691 2756 2690
  t 2756 2691 2757
  t 2692 2757 2691
  t 2757 2692 2758
  t 2693 2758 2692
  t 2758 2693 2759
  t 2694 2759 2693
  t 2759 2694 2760
  t 2695 2760 2694
  t 2760 2695 2761
  t 2696 2761 2695
  t 2761 2696 2762
  t 2697 2762 2696
  t 2762 2697 2763
  t 2698 2763 2697
  t 2763 2698 2764
  t 2699 2764 2698
  t 2764 2699 2765
  t 2700 2765 2699
  t 2765 2700 2766
  t 2701 2766 2700
  t 2766 2701 2767
  t 2702 2767 2701
  t 2767 2702 2768
  t 2703 2768 2702
  t 2768 2703 2769
  t 2704 2769 2703
  t 2769 2704 2770
  t 2705 2770 2704
  t 2770 2705 2771
  t 2706 2771 2705
  t 2771 2706 2772
  t 2707 2772 2706
  t 2772 2707 2773
  t 2708 2773 2707
  t 2773 2708 2774
  t 2709 2774 2708
  t 2774 2709 2775
  t 2710 2775 2709
  t 2775 2710 2776
  t 2711 2776 2710
  t 2776 2711 2777
  t 2712 2777 2711
  t 2777 2712 2778
  t 2713 2778 2712
  t 2778 2713 2779
  t 2714 2779 2713
  t 2779 2714 2780
  t 2715 2780 2714
  t 2780 2715 2781
  t 2716 2781 2715
  t 2781 2716 2782
  t 2717 2782 2716
  t 2782 2717 2783
  t 2718 2783 2717
  t 2783 2718 2784
  t 2719 2784 2718
  t 2784 2719 2785
  t 2720 2785 2719
  t 2785 2720 2786
  t 2721 2786 2720
  t 2786 2721 2787
  t 2722 2787 2721
  t 2787 2722 2788
  t 2723 2788 2722
  t 2788 2723 2789
  t 2724 2789 2723
  t 2789 2724 2790
  t 2725 2790 2724
  t 2790 2725 2791
  t 2726 2791 2725
  t 2791 2726 2792
  t 2727 2792 2726
  t 2792 2727 2793
  t 2728 2793 2727
  t 2793 2728 2794
  t 2729 2794 2728
  t 2795 2730 2796
  t 2731 2796 2730
  t 2796 2731 2797
  t 2732 2797 2731
  t 2797 2732 2798
  t 2733 2798 2732
  t 2798 2733 2799
  t 2734 2799 2733
  t 2799 2734 2800
  t 2735 2800 2734
  t 2800 2735 2801
  t 2736 2801 2735
  t 2801 2736 2802
  t 2737 2802 2736
  t 2802 2737 2803
  t 2738 2803 2737
  t 2803 2738 2804
  t 2739 2804 2738
  t 2804 2739 2805
  t 2740 2805 2739
  t 2805 2740 2806
  t 2741 2806 2740
  t 2806 2741 2807
  t 2742 2807 2741
  t 2807 2742 2808
  t 2743 2808 2742
  t 2808 2743 2809
  t 2744 2809 2743
  t 2809 2744 2810
  t 2745 2810 2744
  t 2810 2745 2811
  t 2746 2811 2745
  t 2811 2746 2812
  t 2747 2812 2746
  t 2812 2747 2813
  t 2748 2813 2747
  t 2813 2748 2814
  t 2749 2814 2748
  t 2814 2749 2815
  t 2750 2815 2749
  t 2815 2750 2816
  t 2751 2816 2750
  t 2816 2751 2817
  t 2752 2817 2751
  t 2817 2752 2818
  t 2753 2818 2752
  t 2818 2753 2819
  t 2754 2819 2753
  t 2819 2754 2820
  t 2755 2820 2754
  t 2820 2755 2821
  t 2756 2821 2755
  t 2821 2756 2822
  t 2757 2822 2756
  t 2822 2757 2823
  t 2758 2823 2757
  t 2823 2758 2824
  t 2759 2824 2758
  t 2824 2759 2825
  t 2760 2825 2759
  t 2825 2760 2826
  t 2761 2826 2760
  t 2826 2761 2827
  t 2762 2827 2761
  t 2827 2762 2828
  t 2763 2828 2762
  t 2828 2763 2829
  t 2764 2829 2763
  t 2829 2764 2830
  t 2765 2830 2764
  t 2830 2765 2831
  t 2766 2831 2765
  t 2831 2766 2832
  t 2767 2832 2766
  t 2832 2767 2833
  t 2768 2833 2767
  t 2833 2768 2834
  t 2769 2834 2768
  t 2834 2769 2835
  t 2770 2835 2769
  t 2835 2770 2836
  t 2771 2836 2770
  t 2836 2771 2837
  t 2772 2837 2771
  t 2837 2772 2838
  t 2773 2838 2772
  t 2838 2773 2839
  t 2774 2839 2773
  t 2839 2774 2840
  t 2775 2840 2774
  t 2840 2775 2841
  t 2776 2841 2775
  t 2841 2776 2842
  t 2777 2842 2776
  t 2842 2777 2843
  t 2778 2843 2777
  t 2843 2778 2844
  t 2779 2844 2778
  t 2844 2779 2845
  t 2780 2845 2779
  t 2845 2780 2846
  t 2781 2846 2780
  t 2846 2781 2847
  t 2782 2847 2781
  t 2847 2782 2848
  t 2783 2848 2782
  t 2848 2783 2849
  t 2784 2849 2783
  t 2849 2784 2850
  t 2785 2850 2784
  t 2850 2785 2851
  t 2786 2851 2785
  t 2851 2786 2852
  t 2787 2852 2786
  t 2852 2787 2853
  t 2788 2853 2787
  t 2853 2788 2854
  t 2789 2854 2788
  t 2854 2789 2855
  t 2790 2855 2789
  t 2855 2790 2856
  t 2791 2856 2790
  t 2856 2791 2857
  t 2792 2857 2791
  t 2857 2792 2858
  t 2793 2858 2792
  t 2858 2793 2859
  t 2794 2859 2793
  t 2860 2795 2861
  t 2796 2861 2795
  t 2861 2796 2862
  t 2797 2862 2796
  t 2862 2797 2863
  t 2798 2863 2797
  t 2863 2798 2864
  t 2799 2864 2798
  t 2864 2799 2865
  t 2800 2865 2799
  t 2865 2800 2866
  t 2801 2866 2800
  t 2866 2801 2867
  t 2802 2867 2801
  t 2867 2802 2868
  t 2803 2868 2802
  t 2868 2803 2869
  t 2804 2869 2803
  t 2869 2804 2870
  t 2805 2870 2804
  t 2870 2805 2871
  t 2806 2871 2805
  t 2871 2806 2872
  t 2807 2872 2806
  t 2872 2807 2873
  t 2808 2873 2807
  t 2873 2808 2874
  t 2809 2874 2808
  t 2874 2809 2875
  t 2810 2875 2809
  t 2875 2810 2876
  t 2811 2876 2810
  t 2876 2811 2877
  t 2812 2877 2811
  t 2877 2812 2878
  t 2813 2878 2812
  t 2878 2813 2879
  t 2814 2879 2813
  t 2879 2814 2880
  t 2815 2880 2814
  t 2880 2815 2881
  t 2816 2881 2815
  t 2881 2816 2882
  t 2817 2882 2816
  t 2882 2817 2883
  t 2818 2883 2817
  t 2883 2818 2884
  t 2819 2884 2818
  t 2884 2819 2885
  t 2820 2885 2819
  t 2885 2820 2886
  t 2821 2886 2820
  t 2886 2821 2887
  t 2822 2887 2821
  t 2887 2822 2888
  t 2823 2888 2822
  t 2888 2823 2889
  t 2824 2889 2823
  t 2889 2824 2890
  t 2825 2890 2824
  t 2890 2825 2891
  t 2826 2891 2825
  t 2891 2826 2892
  t 2827 2892 2826
  t 2892 2827 2893
  t 2828 2893 2827
  t 2893 2828 2894
  t 2829 2894 2828
  t 2894 2829 2895
  t 2830 2895 2829
  t 2895 2830 2896
  t 2831 2896 2830
  t 2896 2831 2897
  t 2832 2897 2831
  t 2897 2832 2898
  t 2833 2898 2832
  t 2898 2833 2899
  t 2834 2899 2833
  t 2899 2834 2900
  t 2835 2900 2834
  t 2900 2835 2901
  t 2836 2901 2835
  t 2901 2836 2902
  t 2837 2902 2836
  t 2902 2837 2903
  t 2838 2903 2837
  t 2903 2838 2904
  t 2839 2904 2838
  t 2904 2839 2905
  t 2840 2905 2839
  t 2905 2840 2906
  t 2841 2906 2840
  t 2906 2841 2907
  t 2842 2907 2841
  t 2907 2842 2908
  t 2843 2908 2842
  t 2908 2843 2909
  t 2844 2909 2843
  t 2909 2844 2910
  t 2845 2910 2844
  t 2910 2845 2911
  t 2846 2911 2845
  t 2911 2846 2912
  t 2847 2912 2846
  t 2912 2847 2913
  t 2848 2913 2847
  t 2913 2848 2914
  t 2849 2914 2848
  t 2914 2849 2915
  t 2850 2915 2849
  t 2915 2850 2916
  t 2851 2916 2850
  t 2916 2851 2917
  t 2852 2917 2851
  t 2917 2852 2918
  t 2853 2918 2852
  t 2918 2853 2919
  t 2854 2919 2853
  t 2919 2854 2920
  t 2855 2920 2854
  t 2920 2855 2921
  t 2856 2921 2855
  t 2921 2856 2922
  t 2857 2922 2856
  t 2922 2857 2923
  t 2858 2923 2857
  t 2923 2858 2924
  t 2859 2924 2858
  t 2925 2860 2926
  t 2861 2926 2860
  t 2926 2861 2927
  t 2862 2927 2861
  t 2927 2862 2928
  t 2863 2928 2862
  t 2928 2863 2929
  t 2864 2929 2863
  t 2929 2864 2930
  t 2865 2930 2864
  t 2930 2865 2931
  t 2866 2931 2865
  t 2931 2866 2932
  t 2867 2932 2866
  t 2932 2867 2933
  t 2868 2933 2867
  t 2933 2868 2934
  t 2869 2934 2868
  t 2934 2869 2935
  t 2870 2935 2869
  t 2935 2870 2936
  t 2871 2936 2870
  t 2936 2871 2937
  t 2872 2937 2871
  t 2937 2872 2938
  t 2873 2938 2872
  t 2938 2873 2939
  t 2874 2939 2873
  t 2939 2874 2940
  t 2875 2940 2874
  t 2940 2875 2941
  t 2876 2941 2875
  t 2941 2876 2942
  t 2877 2942 2876
  t 2942 2877 2943
  t 2878 2943 2877
  t 2943 2878 2944
  t 2879 2944 2878
  t 2944 2879 2945
  t 2880 2945 2879
  t 2945 2880 2946
  t 2881 2946 2880
  t 2946 2881 2947
  t 2882 2947 2881
  t 2947 2882 2948
  t 2883 2948 2882
  t 2948 2883 2949
  t 2884 2949 2883
  t 2949 2884 2950
  t 2885 2950 2884
  t 2950 2885 2951
  t 2886 2951 2885
  t 2951 2886 2952
  t 2887 2952 2886
  t 2952 2887 2953
  t 2888 2953 2887
  t 2953 2888 2954
  t 2889 2954 2888
  t 2954 2889 2955
  t 2890 2955 2889
  t 2955 2890 2956
  t 2891 2956 2890
  t 2956 2891 2957
  t 2892 2957 2891
  t 2957 2892 2958
  t 2893 2958 2892
  t 2958 2893 2959
  t 2894 2959 2893
  t 2959 2894 2960
  t 2895 2960 2894
  t 2960 2895 2961
  t 2896 2961 2895
  t 2961 2896 2962
  t 2897 2962 2896
  t 2962 2897 2963
  t 2898 2963 2897
  t 2963 2898 2964
  t 2899 2964 2898
  t 2964 2899 2965
  t 2900 2965 2899
  t 2965 2900 2966
  t 2901 2966 2900
  t 2966 2901 2967
  t 2902 2967 2901
  t 2967 2902 2968
  t 2903 2968 2902
  t 2968 2903 2969
  t 2904 2969 2903
  t 2969 2904 2970
  t 2905 2970 2904
  t 2970 2905 2971
  t 2906 2971 2905
  t 2971 2906 2972
  t 2907 2972 2906
  t 2972 2907 2973
  t 2908 2973 2907
  t 2973 2908 2974
  t 2909 2974 2908
  t 2974 2909 2975
  t 2910 2975 2909
  t 2975 2910 2976
  t 2911 2976 2910
  t 2976 2911 2977
  t 2912 2977 2911
  t 2977 2912 2978
  t 2913 2978 2912
  t 2978 2913 2979
  t 2914 2979 2913
  t 2979 2914 2980
  t 2915 2980 2914
  t 2980 2915 2981
  t 2916 2981 2915
  t 2981 2916 2982
  t 2917 2982 2916
  t 2982 2917 2983
  t 2918 2983 2917
  t 2983 2918 2984
  t 2919 2984 2918
  t 2984 2919 2985
  t 2920 2985 2919
  t 2985 2920 2986
  t 2921 2986 2920
  t 2986 2921 2987
  t 2922 2987 2921
  t 2987 2922 2988
  t 2923 2988 2922
  t 2988 2923 2989
  t 2924 2989 2923
  t 2990 2925 2991
  t 2926 2991 2925
  t 2991 2926 2992
  t 2927 2992 2926
  t 2992 2927 2993
  t 2928 2993 2927
  t 2993 2928 2994
  t 2929 2994 2928
  t 2994 2929 2995
  t 2930 2995 2929
  t 2995 2930 2996
  t 2931 2996 2930
  t 2996 2931 2997
  t 2932 2997 2931
  t 2997 2932 2998
  t 2933 2998 2932
  t 2998 2933 2999
  t 2934 2999 2933
  t 2999 2934 3000
  t 2935 3000 2934
  t 3000 2935 3001
  t 2936 3001 2935
  t 3001 2936 3002
  t 2937 3002 2936
  t 3002 2937 3003
  t 2938 3003 2937
  t 3003 2938 3004
  t 2939 3004 2938
  t 3004 2939 3005
  t 2940 3005 2939
  t 3005 2940 3006
  t 2941 3006 2940
  t 3006 2941 3007
  t 2942 3007 2941
  t 3007 2942 3008
  t 2943 3008 2942
  t 3008 2943 3009
  t 2944 3009 2943
  t 3009 2944 3010
  t 2945 3010 2944
  t 3010 2945 3011
  t 2946 3011 2945
  t 3011 2946 3012
  t 2947 3012 2946
  t 3012 2947 3013
  t 2948 3013 2947
  t 3013 2948 3014
  t 2949 3014 2948
  t 3014 2949 3015
  t 2950 3015 2949
  t 3015 2950 3016
  t 2951 3016 2950
  t 3016 2951 3017
  t 2952 3017 2951
  t 3017 2952 3018
  t 2953 3018 2952
  t 3018 2953 3019
  t 2954 3019 2953
  t 3019 2954 3020
  t 2955 3020 2954
  t 3020 2955 3021
  t 2956 3021 2955
  t 3021 2956 3022
  t 2957 3022 2956
  t 3022 2957 3023
  t 2958 3023 2957
  t 3023 2958 3024
  t 2959 3024 2958
  t 3024 2959 3025
  t 2960 3025 2959
  t 3025 2960 3026
  t 2961 3026 2960
  t 3026 2961 3027
  t 2962 3027 2961
  t 3027 2962 3028
  t 2963 3028 2962
  t 3028 2963 3029
  t 2964 3029 2963
  t 3029 2964 3030
  t 2965 3030 2964
  t 3030 2965 3031
  t 2966 3031 2965
  t 3031 2966 3032
  t 2967 3032 2966
  t 3032 2967 3033
  t 2968 3033 2967
  t 3033 2968 3034
  t 2969 3034 2968
  t 3034 2969 3035
  t 2970 3035 2969
  t 3035 2970 3036
  t 2971 3036 2970
  t 3036 2971 3037
  t 2972 3037 2971
  t 3037 2972 3038
  t 2973 3038 2972
  t 3038 2973 3039
  t 2974 3039 2973
  t 3039 2974 3040
  t 2975 3040 2974
  t 3040 2975 3041
  t 2976 3041 2975
  t 3041 2976 3042
  t 2977 3042 2976
  t 3042 2977 3043
  t 2978 3043 2977
  t 3043 2978 3044
  t 2979 3044 2978
  t 3044 2979 3045
  t 2980 3045 2979
  t 3045 2980 3046
  t 2981 3046 2980
  t 3046 2981 3047
  t 2982 3047 2981
  t 3047 2982 3048
  t 2983 3048 2982
  t 3048 2983 3049
  t 2984 3049 2983
  t 3049 2984 3050
  t 2985 3050 2984
  t 3050 2985 3051
  t 2986 3051 2985
  t 3051 2986 3052
  t 2987 3052 2986
  t 3052 2987 3053
  t 2988 3053 2987
  t 3053 2988 3054
  t 2989 3054 2988
  t 3055 2990 3056
  t 2991 3056 2990
  t 3056 2991 3057
  t 2992 3057 2991
  t 3057 2992 3058
  t 2993 3058 2992
  t 3058 2993 3059
  t 2994 3059 2993
  t 3059 2994 3060
  t 2995 3060 2994
  t 3060 2995 3061
  t 2996 3061 2995
  t 3061 2996 3062
  t 2997 3062 2996
  t 3062 2997 3063
  t 2998 3063 2997
  t 3063 2998 3064
  t 2999 3064 2998
  t 3064 2999 3065
  t 3000 3065 2999
  t 3065 3000 3066
  t 3001 3066 3000
  t 3066 3001 3067
  t 3002 3067 3001
  t 3067 3002 3068
  t 3003 3068 3002
  t 3068 3003 3069
  t 3004 3069 3003
  t 3069 3004 3070
  t 3005 3070 3004
  t 3070 3005 3071
  t 3006 3071 3005
  t 3071 3006 3072
  t 3007 3072 3006
  t 3072 3007 3073
  t 3008 3073 3007
  t 3073 3008 3074
  t 3009 3074 3008
  t 3074 3009 3075
  t 3010 3075 3009
  t 3075 3010 3076
  t 3011 3076 3010
  t 3076 3011 3077
  t 3012 3077 3011
  t 3077 3012 3078
  t 3013 3078 3012
  t 3078 3013 3079
  t 3014 3079 3013
  t 3079 3014 3080
  t 3015 3080 3014
  t 3080 3015 3081
  t 3016 3081 3015
  t 3081 3016 3082
  t 3017 3082 3016
  t 3082 3017 3083
  t 3018 3083 3017
  t 3083 3018 3084
  t 3019 3084 3018
  t 3084 3019 3085
  t 3020 3085 3019
  t 3085 3020 3086
  t 3021 3086 3020
  t 3086 3021 3087
  t 3022 3087 3021
  t 3087 3022 3088
  t 3023 3088 3022
  t 3088 3023 3089
  t 3024 3089 3023
  t 3089 3024 3090
  t 3025 3090 3024
  t 3090 3025 3091
  t 3026 3091 3025
  t 3091 3026 3092
  t 3027 3092 3026
  t 3092 3027 3093
  t 3028 3093 3027
  t 3093 3028 3094
  t 3029 3094 3028
  t 3094 3029 3095
  t 3030 3095 3029
  t 3095 3030 3096
  t 3031 3096 3030
  t 3096 3031 3097
  t 3032 3097 3031
  t 3097 3032 3098
  t 3033 3098 3032
  t 3098 3033 3099
  t 3034 3099 3033
  t 3099 3034 3100
  t 3035 3100 3034
  t 3100 3035 3101
  t 3036 3101 3035
  t 3101 3036 3102
  t 3037 3102 3036
  t 3102 3037 3103
  t 3038 3103 3037
  t 3103 3038 3104
  t 3039 3104 3038
  t 3104 3039 3105
  t 3040 3105 3039
  t 3105 3040 3106
  t 3041 3106 3040
  t 3106 3041 3107
  t 3042 3107 3041
  t 3107 3042 3108
  t 3043 3108 3042
  t 3108 3043 3109
  t 3044 3109 3043
  t 3109 3044 3110
  t 3045 3110 3044
  t 3110 3045 3111
  t 3046 3111 3045
  t 3111 3046 3112
  t 3047 3112 3046
  t 3112 3047 3113
  t 3048 3113 3047
  t 3113 3048 3114
  t 3049 3114 3048
  t 3114 3049 3115
  t 3050 3115 3049
  t 3115 3050 3116
  t 3051 3116 3050
  t 3116 3051 3117
  t 3052 3117 3051
  t 3117 3052 3118
  t 3053 3118 3052
  t 3118 3053 3119
  t 3054 3119 3053
  t 3120 3055 3121
  t 3056 3121 3055
  t 3121 3056 3122
  t 3057 3122 3056
  t 3122 3057 3123
  t 3058 3123 3057
  t 3123 3058 3124
  t 3059 3124 3058
  t 3124 3059 3125
  t 3060 3125 3059
  t 3125 3060 3126
  t 3061 3126 3060
  t 3126 3061 3127
  t 3062 3127 3061
  t 3127 3062 3128
  t 3063 3128 3062
  t 3128 3063 3129
  t 3064 3129 3063
  t 3129 3064 3130
  t 3065 3130 3064
  t 3130 3065 3131
  t 3066 3131 3065
  t 3131 3066 3132
  t 3067 3132 3066
  t 3132 3067 3133
  t 3068 3133 3067
  t 3133 3068 3134
  t 3069 3134 3068
  t 3134 3069 3135
  t 3070 3135 3069
  t 3135 3070 3136
  t 3071 3136 3070
  t 3136 3071 3137
  t 3072 3137 3071
  t 3137 3072 3138
  t 3073 3138 3072
  t 3138 3073 3139
  t 3074 3139 3073
  t 3139 3074 3140
  t 3075 3140 3074
  t 3140 3075 3141
  t 3076 3141 3075
  t 3141 3076 3142
  t 3077 3142 3076
  t 3142 3077 3143
  t 3078 3143 3077
  t 3143 3078 3144
  t 3079 3144 3078
  t 3144 3079 3145
  t 3080 3145 3079
  t 3145 3080 3146
  t 3081 3146 3080
  t 3146 3081 3147
  t 3082 3147 3081
  t 3147 3082 3148
  t 3083 3148 3082
  t 3148 3083 3149
  t 3084 3149 3083
  t 3149 3084 3150
  t 3085 3150 3084
  t 3150 3085 3151
  t 3086 3151 3085
  t 3151 3086 3152
  t 3087 3152 3086
  t 3152 3087 3153
  t 3088 3153 3087
  t 3153 3088 3154
  t 3089 3154 3088
  t 3154 3089 3155
  t 3090 3155 3089
  t 3155 3090 3156
  t 3091 3156 3090
  t 3156 3091 3157
  t 3092 3157 3091
  t 3157 3092 3158
  t 3093 3158 3092
  t 3158 3093 3159
  t 3094 3159 3093
  t 3159 3094 3160
  t 3095 3160 3094
  t 3160 3095 3161
  t 3096 3161 3095
  t 3161 3096 3162
  t 3097 3162 3096
  t 3162 3097 3163
  t 3098 3163 3097
  t 3163 3098 3164
  t 3099 3164 3098
  t 3164 3099 3165
  t 3100 3165 3099
  t 3165 3100 3166
  t 3101 3166 3100
  t 3166 3101 3167
  t 3102 3167 3101
  t 3167 3102 3168
  t 3103 3168 3102
  t 3168 3103 3169
  t 3104 3169 3103
  t 3169 3104 3170
  t 3105 3170 3104
  t 3170 3105 3171
  t 3106 3171 3105
  t 3171 3106 3172
  t 3107 3172 3106
  t 3172 3107 3173
  t 3108 3173 3107
  t 3173 3108 3174
  t 3109 3174 3108
  t 3174 3109 3175
  t 3110 3175 3109
  t 3175 3110 3176
  t 3111 3176 3110
  t 3176 3111 3177
  t 3112 3177 3111
  t 3177 3112 3178
  t 3113 3178 3112
  t 3178 3113 3179
  t 3114 3179 3113
  t 3179 3114 3180
  t 3115 3180 3114
  t 3180 3115 3181
  t 3116 3181 3115
  t 3181 3116 3182
  t 3117 3182 3116
  t 3182 3117 3183
  t 3118 3183 3117
  t 3183 3118 3184
  t 3119 3184 3118
  t 3185 3120 3186
  t 3121 3186 3120
  t 3186 3121 3187
  t 3122 3187 3121
  t 3187 3122 3188
  t 3123 3188 3122
  t 3188 3123 3189
  t 3124 3189 3123
  t 3189 3124 3190
  t 3125 3190 3124
  t 3190 3125 3191
  t 3126 3191 3125
  t 3191 3126 3192
  t 3127 3192 3126
  t 3192 3127 3193
  t 3128 3193 3127
  t 3193 3128 3194
  t 3129 3194 3128
  t 3194 3129 3195
  t 3130 3195 3129
  t 3195 3130 3196
  t 3131 3196 3130
  t 3196 3131 3197
  t 3132 3197 3131
  t 3197 3132 3198
  t 3133 3198 3132
  t 3198 3133 3199
  t 3134 3199 3133
  t 3199 3134 3200
  t 3135 3200 3134
  t 3200 3135 3201
  t 3136 3201 3135
  t 3201 3136 3202
  t 3137 3202 3136
  t 3202 3137 3203
  t 3138 3203 3137
  t 3203 3138 3204
  t 3139 3204 3138
  t 3204 3139 3205
  t 3140 3205 3139
  t 3205 3140 3206
  t 3141 3206 3140
  t 3206 3141 3207
  t 3142 3207 3141
  t 3207 3142 3208
  t 3143 3208 3142
  t 3208 3143 3209
  t 3144 3209 3143
  t 3209 3144 3210
  t 3145 3210 3144
  t 3210 3145 3211
  t 3146 3211 3145
  t 3211 3146 3212
  t 3147 3212 3146
  t 3212 3147 3213
  t 3148 3213 3147
  t 3213 3148 3214
  t 3149 3214 3148
  t 3214 3149 3215
  t 3150 3215 3149
  t 3215 3150 3216
  t 3151 3216 3150
  t 3216 3151 3217
  t 3152 3217 3151
  t 3217 3152 3218
  t 3153 3218 3152
  t 3218 3153 3219
  t 3154 3219 3153
  t 3219 3154 3220
  t 3155 3220 3154
  t 3220 3155 3221
  t 3156 3221 3155
  t 3221 3156 3222
  t 3157 3222 3156
  t 3222 3157 3223
  t 3158 3223 3157
  t 3223 3158 3224
  t 3159 3224 3158
  t 3224 3159 3225
  t 3160 3225 3159
  t 3225 3160 3226
  t 3161 3226 3160
  t 3226 3161 3227
  t 3162 3227 3161
  t 3227 3162 3228
  t 3163 3228 3162
  t 3228 3163 3229
  t 3164 3229 3163
  t 3229 3164 3230
  t 3165 3230 3164
  t 3230 3165 3231
  t 3166 3231 3165
  t 3231 3166 3232
  t 3167 3232 3166
  t 3232 3167 3233
  t 3168 3233 3167
  t 3233 3168 3234
  t 3169 3234 3168
  t 3234 3169 3235
  t 3170 3235 3169
  t 3235 3170 3236
  t 3171 3236 3170
  t 3236 3171 3237
  t 3172 3237 3171
  t 3237 3172 3238
  t 3173 3238 3172
  t 3238 3173 3239
  t 3174 3239 3173
  t 3239 3174 3240
  t 3175 3240 3174
  t 3240 3175 3241
  t 3176 3241 3175
  t 3241 3176 3242
  t 3177 3242 3176
  t 3242 3177 3243
  t 3178 3243 3177
  t 3243 3178 3244
  t 3179 3244 3178
  t 3244 3179 3245
  t 3180 3245 3179
  t 3245 3180 3246
  t 3181 3246 3180
  t 3246 3181 3247
  t 3182 3247 3181
  t 3247 3182 3248
  t 3183 3248 3182
  t 3248 3183 3249
  t 3184 3249 3183
  t 3250 3185 3251
  t 3186 3251 3185
  t 3251 3186 3252
  t 3187 3252 3186
  t 3252 3187 3253
  t 3188 3253 3187
  t 3253 3188 3254
  t 3189 3254 3188
  t 3254 3189 3255
  t 3190 3255 3189
  t 3255 3190 3256
  t 3191 3256 3190
  t 3256 3191 3257
  t 3192 3257 3191
  t 3257 3192 3258
  t 3193 3258 3192
  t 3258 3193 3259
  t 3194 3259 3193
  t 3259 3194 3260
  t 3195 3260 3194
  t 3260 3195 3261
  t 3196 3261 3195
  t 3261 3196 3262
  t 3197 3262 3196
  t 3262 3197 3263
  t 3198 3263 3197
  t 3263 3198 3264
  t 3199 3264 3198
  t 3264 3199 3265
  t 3200 3265 3199
  t 3265 3200 3266
  t 3201 3266 3200
  t 3266 3201 3267
  t 3202 3267 3201
  t 3267 3202 3268
  t 3203 3268 3202
  t 3268 3203 3269
  t 3204 3269 3203
  t 3269 3204 3270
  t 3205 3270 3204
  t 3270 3205 3271
  t 3206 3271 3205
  t 3271 3206 3272
  t 3207 3272 3206
  t 3272 3207 3273
  t 3208 3273 3207
  t 3273 3208 3274
  t 3209 3274 3208
  t 3274 3209 3275
  t 3210 3275 3209
  t 3275 3210 3276
  t 3211 3276 3210
  t 3276 3211 3277
  t 3212 3277 3211
  t 3277 3212 3278
  t 3213 3278 3212
  t 3278 3213 3279
  t 3214 3279 3213
  t 3279 3214 3280
  t 3215 3280 3214
  t 3280 3215 3281
  t 3216 3281 3215
  t 3281 3216 3282
  t 3217 3282 3216
  t 3282 3217 3283
  t 3218 3283 3217
  t 3283 3218 3284
  t 3219 3284 3218
  t 3284 3219 3285
  t 3220 3285 3219
  t 3285 3220 3286
  t 3221 3286 3220
  t 3286 3221 3287
  t 3222 3287 3221
  t 3287 3222 3288
  t 3223 3288 3222
  t 3288 3223 3289
  t 3224 3289 3223
  t 3289 3224 3290
  t 3225 3290 3224
  t 3290 3225 3291
  t 3226 3291 3225
  t 3291 3226 3292
  t 3227 3292 3226
  t 3292 3227 3293
  t 3228 3293 3227
  t 3293 3228 3294
  t 3229 3294 3228
  t 3294 3229 3295
  t 3230 3295 3229
  t 3295 3230 3296
  t 3231 3296 3230
  t 3296 3231 3297
  t 3232 3297 3231
  t 3297 3232 3298
  t 3233 3298 3232
  t 3298 3233 3299
  t 3234 3299 3233
  t 3299 3234 3300
  t 3235 3300 3234
  t 3300 3235 3301
  t 3236 3301 3235
  t 3301 3236 3302
  t 3237 3302 3236
  t 3302 3237 3303
  t 3238 3303 3237
  t 3303 3238 3304
  t 3239 3304 3238
  t 3304 3239 3305
  t 3240 3305 3239
  t 3305 3240 3306
  t 3241 3306 3240
  t 3306 3241 3307
  t 3242 3307 3241
  t 3307 3242 3308
  t 3243 3308 3242
  t 3308 3243 3309
  t 3244 3309 3243
  t 3309 3244 3310
  t 3245 3310 3244
  t 3310 3245 3311
  t 3246 3311 3245
  t 3311 3246 3312
  t 3247 3312 3246
  t 3312 3247 3313
  t 3248 3313 3247
  t 3313 3248 3314
  t 3249 3314 3248
  t 3315 3250 3316
  t 3251 3316 3250
  t 3316 3251 3317
  t 3252 3317 3251
  t 3317 3252 3318
  t 3253 3318 3252
  t 3318 3253 3319
  t 3254 3319 3253
  t 3319 3254 3320
  t 3255 3320 3254
  t 3320 3255 3321
  t 3256 3321 3255
  t 3321 3256 3322
  t 3257 3322 3256
  t 3322 3257 3323
  t 3258 3323 3257
  t 3323 3258 3324
  t 3259 3324 3258
  t 3324 3259 3325
  t 3260 3325 3259
  t 3325 3260 3326
  t 3261 3326 3260
  t 3326 3261 3327
  t 3262 3327 3261
  t 3327 3262 3328
  t 3263 3328 3262
  t 3328 3263 3329
  t 3264 3329 3263
  t 3329 3264 3330
  t 3265 3330 3264
  t 3330 3265 3331
  t 3266 3331 3265
  t 3331 3266 3332
  t 3267 3332 3266
  t 3332 3267 3333
  t 3268 3333 3267
  t 3333 3268 3334
  t 3269 3334 3268
  t 3334 3269 3335
  t 3270 3335 3269
  t 3335 3270 3336
  t 3271 3336 3270
  t 3336 3271 3337
  t 3272 3337 3271
  t 3337 3272 3338
  t 3273 3338 3272
  t 3338 3273 3339
  t 3274 3339 3273
  t 3339 3274 3340
  t 3275 3340 3274
  t 3340 3275 3341
  t 3276 3341 3275
  t 3341 3276 3342
  t 3277 3342 3276
  t 3342 3277 3343
  t 3278 3343 3277
  t 3343 3278 3344
  t 3279 3344 3278
  t 3344 3279 3345
  t 3280 3345 3279
  t 3345 3280 3346
  t 3281 3346 3280
  t 3346 3281 3347
  t 3282 3347 3281
  t 3347 3282 3348
  t 3283 3348 3282
  t 3348 3283 3349
  t 3284 3349 3283
  t 3349 3284 3350
  t 3285 3350 3284
  t 3350 3285 3351
  t 3286 3351 3285
  t 3351 3286 3352
  t 3287 3352 3286
  t 3352 3287 3353
  t 3288 3353 3287
  t 3353 3288 3354
  t 3289 3354 3288
  t 3354 3289 3355
  t 3290 3355 3289
  t 3355 3290 3356
  t 3291 3356 3290
  t 3356 3291 3357
  t 3292 3357 3291
  t 3357 3292 3358
  t 3293 3358 3292
  t 3358 3293 3359
  t 3294 3359 3293
  t 3359 3294 3360
  t 3295 3360 3294
  t 3360 3295 3361
  t 3296 3361 3295
  t 3361 3296 3362
  t 3297 3362 3296
  t 3362 3297 3363
  t 3298 3363 3297
  t 3363 3298 3364
  t 3299 3364 3298
  t 3364 3299 3365
  t 3300 3365 3299
  t 3365 3300 3366
  t 3301 3366 3300
  t 3366 3301 3367
  t 3302 3367 3301
  t 3367 3302 3368
  t 3303 3368 3302
  t 3368 3303 3369
  t 3304 3369 3303
  t 3369 3304 3370
  t 3305 3370 3304
  t 3370 3305 3371
  t 3306 3371 3305
  t 3371 3306 3372
  t 3307 3372 3306
  t 3372 3307 3373
  t 3308 3373 3307
  t 3373 3308 3374
  t 3309 3374 3308
  t 3374 3309 3375
  t 3310 3375 3309
  t 3375 3310 3376
  t 3311 3376 3310
  t 3376 3311 3377
  t 3312 3377 3311
  t 3377 3312 3378
  t 3313 3378 3312
  t 3378 3313 3379
  t 3314 3379 3313
  t 3380 3315 3381
  t 3316 3381 3315
  t 3381 3316 3382
  t 3317 3382 3316
  t 3382 3317 3383
  t 3318 3383 3317
  t 3383 3318 3384
  t 3319 3384 3318
  t 3384 3319 3385
  t 3320 3385 3319
  t 3385 3320 3386
  t 3321 3386 3320
  t 3386 3321 3387
  t 3322 3387 3321
  t 3387 3322 3388
  t 3323 3388 3322
  t 3388 3323 3389
  t 3324 3389 3323
  t 3389 3324 3390
  t 3325 3390 3324
  t 3390 3325 3391
  t 3326 3391 3325
  t 3391 3326 3392
  t 3327 3392 3326
  t 3392 3327 3393
  t 3328 3393 3327
  t 3393 3328 3394
  t 3329 3394 3328
  t 3394 3329 3395
  t 3330 3395 3329
  t 3395 3330 3396
  t 3331 3396 3330
  t 3396 3331 3397
  t 3332 3397 3331
  t 3397 3332 3398
  t 3333 3398 3332
  t 3398 3333 3399
  t 3334 3399 3333
  t 3399 3334 3400
  t 3335 3400 3334
  t 3400 3335 3401
  t 3336 3401 3335
  t 3401 3336 3402
  t 3337 3402 3336
  t 3402 3337 3403
  t 3338 3403 3337
  t 3403 3338 3404
  t 3339 3404 3338
  t 3404 3339 3405
  t 3340 3405 3339
  t 3405 3340 3406
  t 3341 3406 3340
  t 3406 3341 3407
  t 3342 3407 3341
  t 3407 3342 3408
  t 3343 3408 3342
  t 3408 3343 3409
  t 3344 3409 3343
  t 3409 3344 3410
  t 3345 3410 3344
  t 3410 3345 3411
  t 3346 3411 3345
  t 3411 3346 3412
  t 3347 3412 3346
  t 3412 3347 3413
  t 3348 3413 3347
  t 3413 3348 3414
  t 3349 3414 3348
  t 3414 3349 3415
  t 3350 3415 3349
  t 3415 3350 3416
  t 3351 3416 3350
  t 3416 3351 3417
  t 3352 3417 3351
  t 3417 3352 3418
  t 3353 3418 3352
  t 3418 3353 3419
  t 3354 3419 3353
  t 3419 3354 3420
  t 3355 3420 3354
  t 3420 3355 3421
  t 3356 3421 3355
  t 3421 3356 3422
  t 3357 3422 3356
  t 3422 3357 3423
  t 3358 3423 3357
  t 3423 3358 3424
  t 3359 3424 3358
  t 3424 3359 3425
  t 3360 3425 3359
  t 3425 3360 3426
  t 3361 3426 3360
  t 3426 3361 3427
  t 3362 3427 3361
  t 3427 3362 3428
  t 3363 3428 3362
  t 3428 3363 3429
  t 3364 3429 3363
  t 3429 3364 3430
  t 3365 3430 3364
  t 3430 3365 3431
  t 3366 3431 3365
  t 3431 3366 3432
  t 3367 3432 3366
  t 3432 3367 3433
  t 3368 3433 3367
  t 3433 3368 3434
  t 3369 3434 3368
  t 3434 3369 3435
  t 3370 3435 3369
  t 3435 3370 3436
  t 3371 3436 3370
  t 3436 3371 3437
  t 3372 3437 3371
  t 3437 3372 3438
  t 3373 3438 3372
  t 3438 3373 3439
  t 3374 3439 3373
  t 3439 3374 3440
  t 3375 3440 3374
  t 3440 3375 3441
  t 3376 3441 3375
  t 3441 3376 3442
  t 3377 3442 3376
  t 3442 3377 3443
  t 3378 3443 3377
  t 3443 3378 3444
  t 3379 3444 3378
  t 3445 3380 3446
  t 3381 3446 3380
  t 3446 3381 3447
  t 3382 3447 3381
  t 3447 3382 3448
  t 3383 3448 3382
  t 3448 3383 3449
  t 3384 3449 3383
  t 3449 3384 3450
  t 3385 3450 3384
  t 3450 3385 3451
  t 3386 3451 3385
  t 3451 3386 3452
  t 3387 3452 3386
  t 3452 3387 3453
  t 3388 3453 3387
  t 3453 3388 3454
  t 3389 3454 3388
  t 3454 3389 3455
  t 3390 3455 3389
  t 3455 3390 3456
  t 3391 3456 3390
  t 3456 3391 3457
  t 3392 3457 3391
  t 3457 3392 3458
  t 3393 3458 3392
  t 3458 3393 3459
  t 3394 3459 3393
  t 3459 3394 3460
  t 3395 3460 3394
  t 3460 3395 3461
  t 3396 3461 3395
  t 3461 3396 3462
  t 3397 3462 3396
  t 3462 3397 3463
  t 3398 3463 3397
  t 3463 3398 3464
  t 3399 3464 3398
  t 3464 3399 3465
  t 3400 3465 3399
  t 3465 3400 3466
  t 3401 3466 3400
  t 3466 3401 3467
  t 3402 3467 3401
  t 3467 3402 3468
  t 3403 3468 3402
  t 3468 3403 3469
  t 3404 3469 3403
  t 3469 3404 3470
  t 3405 3470 3404
  t 3470 3405 3471
  t 3406 3471 3405
  t 3471 3406 3472
  t 3407 3472 3406
  t 3472 3407 3473
  t 3408 3473 3407
  t 3473 3408 3474
  t 3409 3474 3408
  t 3474 3409 3475
  t 3410 3475 3409
  t 3475 3410 3476
  t 3411 3476 3410
  t 3476 3411 3477
  t 3412 3477 3411
  t 3477 3412 3478
  t 3413 3478 3412
  t 3478 3413 3479
  t 3414 3479 3413
  t 3479 3414 3480
  t 3415 3480 3414
  t 3480 3415 3481
  t 3416 3481 3415
  t 3481 3416 3482
  t 3417 3482 3416
  t 3482 3417 3483
  t 3418 3483 3417
  t 3483 3418 3484
  t 3419 3484 3418
  t 3484 3419 3485
  t 3420 3485 3419
  t 3485 3420 3486
  t 3421 3486 3420
  t 3486 3421 3487
  t 3422 3487 3421
  t 3487 3422 3488
  t 3423 3488 3422
  t 3488 3423 3489
  t 3424 3489 3423
  t 3489 3424 3490
  t 3425 3490 3424
  t 3490 3425 3491
  t 3426 3491 3425
  t 3491 3426 3492
  t 3427 3492 3426
  t 3492 3427 3493
  t 3428 3493 3427
  t 3493 3428 3494
  t 3429 3494 3428
  t 3494 3429 3495
  t 3430 3495 3429
  t 3495 3430 3496
  t 3431 3496 3430
  t 3496 3431 3497
  t 3432 3497 3431
  t 3497 3432 3498
  t 3433 3498 3432
  t 3498 3433 3499
  t 3434 3499 3433
  t 3499 3434 3500
  t 3435 3500 3434
  t 3500 3435 3501
  t 3436 3501 3435
  t 3501 3436 3502
  t 3437 3502 3436
  t 3502 3437 3503
  t 3438 3503 3437
  t 3503 3438 3504
  t 3439 3504 3438
  t 3504 3439 3505
  t 3440 3505 3439
  t 3505 3440 3506
  t 3441 3506 3440
  t 3506 3441 3507
  t 3442 3507 3441
  t 3507 3442 3508
  t 3443 3508 3442
  t 3508 3443 3509
  t 3444 3509 3443
  t 3510 3445 3511
  t 3446 3511 3445
  t 3511 3446 3512
  t 3447 3512 3446
  t 3512 3447 3513
  t 3448 3513 3447
  t 3513 3448 3514
  t 3449 3514 3448
  t 3514 3449 3515
  t 3450 3515 3449
  t 3515 3450 3516
  t 3451 3516 3450
  t 3516 3451 3517
  t 3452 3517 3451
  t 3517 3452 3518
  t 3453 3518 3452
  t 3518 3453 3519
  t 3454 3519 3453
  t 3519 3454 3520
  t 3455 3520 3454
  t 3520 3455 3521
  t 3456 3521 3455
  t 3521 3456 3522
  t 3457 3522 3456
  t 3522 3457 3523
  t 3458 3523 3457
  t 3523 3458 3524
  t 3459 3524 3458
  t 3524 3459 3525
  t 3460 3525 3459
  t 3525 3460 3526
  t 3461 3526 3460
  t 3526 3461 3527
  t 3462 3527 3461
  t 3527 3462 3528
  t 3463 3528 3462
  t 3528 3463 3529
  t 3464 3529 3463
  t 3529 3464 3530
  t 3465 3530 3464
  t 3530 3465 3531
  t 3466 3531 3465
  t 3531 3466 3532
  t 3467 3532 3466
  t 3532 3467 3533
  t 3468 3533 3467
  t 3533 3468 3534
  t 3469 3534 3468
  t 3534 3469 3535
  t 3470 3535 3469
  t 3535 3470 3536
  t 3471 3536 3470
  t 3536 3471 3537
  t 3472 3537 3471
  t 3537 3472 3538
  t 3473 3538 3472
  t 3538 3473 3539
  t 3474 3539 3473
  t 3539 3474 3540
  t 3475 3540 3474
  t 3540 3475 3541
  t 3476 3541 3475
  t 3541 3476 3542
  t 3477 3542 3476
  t 3542 3477 3543
  t 3478 3543 3477
  t 3543 3478 3544
  t 3479 3544 3478
  t 3544 3479 3545
  t 3480 3545 3479
  t 3545 3480 3546
  t 3481 3546 3480
  t 3546 3481 3547
  t 3482 3547 3481
  t 3547 3482 3548
  t 3483 3548 3482
  t 3548 3483 3549
  t 3484 3549 3483
  t 3549 3484 3550
  t 3485 3550 3484
  t 3550 3485 3551
  t 3486 3551 3485
  t 3551 3486 3552
  t 3487 3552 3486
  t 3552 3487 3553
  t 3488 3553 3487
  t 3553 3488 3554
  t 3489 3554 3488
  t 3554 3489 3555
  t 3490 3555 3489
  t 3555 3490 3556
  t 3491 3556 3490
  t 3556 3491 3557
  t 3492 3557 3491
  t 3557 3492 3558
  t 3493 3558 3492
  t 3558 3493 3559
  t 3494 3559 3493
  t 3559 3494 3560
  t 3495 3560 3494
  t 3560 3495 3561
  t 3496 3561 3495
  t 3561 3496 3562
  t 3497 3562 3496
  t 3562 3497 3563
  t 3498 3563 3497
  t 3563 3498 3564
  t 3499 3564 3498
  t 3564 3499 3565
  t 3500 3565 3499
  t 3565 3500 3566
  t 3501 3566 3500
  t 3566 3501 3567
  t 3502 3567 3501
  t 3567 3502 3568
  t 3503 3568 3502
  t 3568 3503 3569
  t 3504 3569 3503
  t 3569 3504 3570
  t 3505 3570 3504
  t 3570 3505 3571
  t 3506 3571 3505
  t 3571 3506 3572
  t 3507 3572 3506
  t 3572 3507 3573
  t 3508 3573 3507
  t 3573 3508 3574
  t 3509 3574 3508
  t 3575 3510 3576
  t 3511 3576 3510
  t 3576 3511 3577
  t 3512 3577 3511
  t 3577 3512 3578
  t 3513 3578 3512
  t 3578 3513 3579
  t 3514 3579 3513
  t 3579 3514 3580
  t 3515 3580 3514
  t 3580 3515 3581
  t 3516 3581 3515
  t 3581 3516 3582
  t 3517 3582 3516
  t 3582 3517 3583
  t 3518 3583 3517
  t 3583 3518 3584
  t 3519 3584 3518
  t 3584 3519 3585
  t 3520 3585 3519
  t 3585 3520 3586
  t 3521 3586 3520
  t 3586 3521 3587
  t 3522 3587 3521
  t 3587 3522 3588
  t 3523 3588 3522
  t 3588 3523 3589
  t 3524 3589 3523
  t 3589 3524 3590
  t 3525 3590 3524
  t 3590 3525 3591
  t 3526 3591 3525
  t 3591 3526 3592
  t 3527 3592 3526
  t 3592 3527 3593
  t 3528 3593 3527
  t 3593 3528 3594
  t 3529 3594 3528
  t 3594 3529 3595
  t 3530 3595 3529
  t 3595 3530 3596
  t 3531 3596 3530
  t 3596 3531 3597
  t 3532 3597 3531
  t 3597 3532 3598
  t 3533 3598 3532
  t 3598 3533 3599
  t 3534 3599 3533
  t 3599 3534 3600
  t 3535 3600 3534
  t 3600 3535 3601
  t 3536 3601 3535
  t 3601 3536 3602
  t 3537 3602 3536
  t 3602 3537 3603
  t 3538 3603 3537
  t 3603 3538 3604
  t 3539 3604 3538
  t 3604 3539 3605
  t 3540 3605 3539
  t 3605 3540 3606
  t 3541 3606 3540
  t 3606 3541 3607
  t 3542 3607 3541
  t 3607 3542 3608
  t 3543 3608 3542
  t 3608 3543 3609
  t 3544 3609 3543
  t 3609 3544 3610
  t 3545 3610 3544
  t 3610 3545 3611
  t 3546 3611 3545
  t 3611 3546 3612
  t 3547 3612 3546
  t 3612 3547 3613
  t 3548 3613 3547
  t 3613 3548 3614
  t 3549 3614 3548
  t 3614 3549 3615
  t 3550 3615 3549
  t 3615 3550 3616
  t 3551 3616 3550
  t 3616 3551 3617
  t 3552 3617 3551
  t 3617 3552 3618
  t 3553 3618 3552
  t 3618 3553 3619
  t 3554 3619 3553
  t 3619 3554 3620
  t 3555 3620 3554
  t 3620 3555 3621
  t 3556 3621 3555
  t 3621 3556 3622
  t 3557 3622 3556
  t 3622 3557 3623
  t 3558 3623 3557
  t 3623 3558 3624
  t 3559 3624 3558
  t 3624 3559 3625
  t 3560 3625 3559
  t 3625 3560 3626
  t 3561 3626 3560
  t 3626 3561 3627
  t 3562 3627 3561
  t 3627 3562 3628
  t 3563 3628 3562
  t 3628 3563 3629
  t 3564 3629 3563
  t 3629 3564 3630
  t 3565 3630 3564
  t 3630 3565 3631
  t 3566 3631 3565
  t 3631 3566 3632
  t 3567 3632 3566
  t 3632 3567 3633
  t 3568 3633 3567
  t 3633 3568 3634
  t 3569 3634 3568
  t 3634 3569 3635
  t 3570 3635 3569
  t 3635 3570 3636
  t 3571 3636 3570
  t 3636 3571 3637
  t 3572 3637 3571
  t 3637 3572 3638
  t 3573 3638 3572
  t 3638 3573 3639
  t 3574 3639 3573
  t 3640 3575 3641
  t 3576 3641 3575
  t 3641 3576 3642
  t 3577 3642 3576
  t 3642 3577 3643
  t 3578 3643 3577
  t 3643 3578 3644
  t 3579 3644 3578
  t 3644 3579 3645
  t 3580 3645 3579
  t 3645 3580 3646
  t 3581 3646 3580
  t 3646 3581 3647
  t 3582 3647 3581
  t 3647 3582 3648
  t 3583 3648 3582
  t 3648 3583 3649
  t 3584 3649 3583
  t 3649 3584 3650
  t 3585 3650 3584
  t 3650 3585 3651
  t 3586 3651 3585
  t 3651 3586 3652
  t 3587 3652 3586
  t 3652 3587 3653
  t 3588 3653 3587
  t 3653 3588 3654
  t 3589 3654 3588
  t 3654 3589 3655
  t 3590 3655 3589
  t 3655 3590 3656
  t 3591 3656 3590
  t 3656 3591 3657
  t 3592 3657 3591
  t 3657 3592 3658
  t 3593 3658 3592
  t 3658 3593 3659
  t 3594 3659 3593
  t 3659 3594 3660
  t 3595 3660 3594
  t 3660 3595 3661
  t 3596 3661 3595
  t 3661 3596 3662
  t 3597 3662 3596
  t 3662 3597 3663
  t 3598 3663 3597
  t 3663 3598 3664
  t 3599 3664 3598
  t 3664 3599 3665
  t 3600 3665 3599
  t 3665 3600 3666
  t 3601 3666 3600
  t 3666 3601 3667
  t 3602 3667 3601
  t 3667 3602 3668
  t 3603 3668 3602
  t 3668 3603 3669
  t 3604 3669 3603
  t 3669 3604 3670
  t 3605 3670 3604
  t 3670 3605 3671
  t 3606 3671 3605
  t 3671 3606 3672
  t 3607 3672 3606
  t 3672 3607 3673
  t 3608 3673 3607
  t 3673 3608 3674
  t 3609 3674 3608
  t 3674 3609 3675
  t 3610 3675 3609
  t 3675 3610 3676
  t 3611 3676 3610
  t 3676 3611 3677
  t 3612 3677 3611
  t 3677 3612 3678
  t 3613 3678 3612
  t 3678 3613 3679
  t 3614 3679 3613
  t 3679 3614 3680
  t 3615 3680 3614
  t 3680 3615 3681
  t 3616 3681 3615
  t 3681 3616 3682
  t 3617 3682 3616
  t 3682 3617 3683
  t 3618 3683 3617
  t 3683 3618 3684
  t 3619 3684 3618
  t 3684 3619 3685
  t 3620 3685 3619
  t 3685 3620 3686
  t 3621 3686 3620
  t 3686 3621 3687
  t 3622 3687 3621
  t 3687 3622 3688
  t 3623 3688 3622
  t 3688 3623 3689
  t 3624 3689 3623
  t 3689 3624 3690
  t 3625 3690 3624
  t 3690 3625 3691
  t 3626 3691 3625
  t 3691 3626 3692
  t 3627 3692 3626
  t 3692 3627 3693
  t 3628 3693 3627
  t 3693 3628 3694
  t 3629 3694 3628
  t 3694 3629 3695
  t 3630 3695 3629
  t 3695 3630 3696
  t 3631 3696 3630
  t 3696 3631 3697
  t 3632 3697 3631
  t 3697 3632 3698
  t 3633 3698 3632
  t 3698 3633 3699
  t 3634 3699 3633
  t 3699 3634 3700
  t 3635 3700 3634
  t 3700 3635 3701
  t 3636 3701 3635
  t 3701 3636 3702
  t 3637 3702 3636
  t 3702 3637 3703
  t 3638 3703 3637
  t 3703 3638 3704
  t 3639 3704 3638
  t 3705 3640 3706
  t 3641 3706 3640
  t 3706 3641 3707
  t 3642 3707 3641
  t 3707 3642 3708
  t 3643 3708 3642
  t 3708 3643 3709
  t 3644 3709 3643
  t 3709 3644 3710
  t 3645 3710 3644
  t 3710 3645 3711
  t 3646 3711 3645
  t 3711 3646 3712
  t 3647 3712 3646
  t 3712 3647 3713
  t 3648 3713 3647
  t 3713 3648 3714
  t 3649 3714 3648
  t 3714 3649 3715
  t 3650 3715 3649
  t 3715 3650 3716
  t 3651 3716 3650
  t 3716 3651 3717
  t 3652 3717 3651
  t 3717 3652 3718
  t 3653 3718 3652
  t 3718 3653 3719
  t 3654 3719 3653
  t 3719 3654 3720
  t 3655 3720 3654
  t 3720 3655 3721
  t 3656 3721 3655
  t 3721 3656 3722
  t 3657 3722 3656
  t 3722 3657 3723
  t 3658 3723 3657
  t 3723 3658 3724
  t 3659 3724 3658
  t 3724 3659 3725
  t 3660 3725 3659
  t 3725 3660 3726
  t 3661 3726 3660
  t 3726 3661 3727
  t 3662 3727 3661
  t 3727 3662 3728
  t 3663 3728 3662
  t 3728 3663 3729
  t 3664 3729 3663
  t 3729 3664 3730
  t 3665 3730 3664
  t 3730 3665 3731
  t 3666 3731 3665
  t 3731 3666 3732
  t 3667 3732 3666
  t 3732 3667 3733
  t 3668 3733 3667
  t 3733 3668 3734
  t 3669 3734 3668
  t 3734 3669 3735
  t 3670 3735 3669
  t 3735 3670 3736
  t 3671 3736 3670
  t 3736 3671 3737
  t 3672 3737 3671
  t 3737 3672 3738
  t 3673 3738 3672
  t 3738 3673 3739
  t 3674 3739 3673
  t 3739 3674 3740
  t 3675 3740 3674
  t 3740 3675 3741
  t 3676 3741 3675
  t 3741 3676 3742
  t 3677 3742 3676
  t 3742 3677 3743
  t 3678 3743 3677
  t 3743 3678 3744
  t 3679 3744 3678
  t 3744 3679 3745
  t 3680 3745 3679
  t 3745 3680 3746
  t 3681 3746 3680
  t 3746 3681 3747
  t 3682 3747 3681
  t 3747 3682 3748
  t 3683 3748 3682
  t 3748 3683 3749
  t 3684 3749 3683
  t 3749 3684 3750
  t 3685 3750 3684
  t 3750 3685 3751
  t 3686 3751 3685
  t 3751 3686 3752
  t 3687 3752 3686
  t 3752 3687 3753
  t 3688 3753 3687
  t 3753 3688 3754
  t 3689 3754 3688
  t 3754 3689 3755
  t 3690 3755 3689
  t 3755 3690 3756
  t 3691 3756 3690
  t 3756 3691 3757
  t 3692 3757 3691
  t 3757 3692 3758
  t 3693 3758 3692
  t 3758 3693 3759
  t 3694 3759 3693
  t 3759 3694 3760
  t 3695 3760 3694
  t 3760 3695 3761
  t 3696 3761 3695
  t 3761 3696 3762
  t 3697 3762 3696
  t 3762 3697 3763
  t 3698 3763 3697
  t 3763 3698 3764
  t 3699 3764 3698
  t 3764 3699 3765
  t 3700 3765 3699
  t 3765 3700 3766
  t 3701 3766 3700
  t 3766 3701 3767
  t 3702 3767 3701
  t 3767 3702 3768
  t 3703 3768 3702
  t 3768 3703 3769
  t 3704 3769 3703
  t 3770 3705 3771
  t 3706 3771 3705
  t 3771 3706 3772
  t 3707 3772 3706
  t 3772 3707 3773
  t 3708 3773 3707
  t 3773 3708 3774
  t 3709 3774 3708
  t 3774 3709 3775
  t 3710 3775 3709
  t 3775 3710 3776
  t 3711 3776 3710
  t 3776 3711 3777
  t 3712 3777 3711
  t 3777 3712 3778
  t 3713 3778 3712
  t 3778 3713 3779
  t 3714 3779 3713
  t 3779 3714 3780
  t 3715 3780 3714
  t 3780 3715 3781
  t 3716 3781 3715
  t 3781 3716 3782
  t 3717 3782 3716
  t 3782 3717 3783
  t 3718 3783 3717
  t 3783 3718 3784
  t 3719 3784 3718
  t 3784 3719 3785
  t 3720 3785 3719
  t 3785 3720 3786
  t 3721 3786 3720
  t 3786 3721 3787
  t 3722 3787 3721
  t 3787 3722 3788
  t 3723 3788 3722
  t 3788 3723 3789
  t 3724 3789 3723
  t 3789 3724 3790
  t 3725 3790 3724
  t 3790 3725 3791
  t 3726 3791 3725
  t 3791 3726 3792
  t 3727 3792 3726
  t 3792 3727 3793
  t 3728 3793 3727
  t 3793 3728 3794
  t 3729 3794 3728
  t 3794 3729 3795
  t 3730 3795 3729
  t 3795 3730 3796
  t 3731 3796 3730
  t 3796 3731 3797
  t 3732 3797 3731
  t 3797 3732 3798
  t 3733 3798 3732
  t 3798 3733 3799
  t 3734 3799 3733
  t 3799 3734 3800
  t 3735 3800 3734
  t 3800 3735 3801
  t 3736 3801 3735
  t 3801 3736 3802
  t 3737 3802 3736
  t 3802 3737 3803
  t 3738 3803 3737
  t 3803 3738 3804
  t 3739 3804 3738
  t 3804 3739 3805
  t 3740 3805 3739
  t 3805 3740 3806
  t 3741 3806 3740
  t 3806 3741 3807
  t 3742 3807 3741
  t 3807 3742 3808
  t 3743 3808 3742
  t 3808 3743 3809
  t 3744 3809 3743
  t 3809 3744 3810
  t 3745 3810 3744
  t 3810 3745 3811
  t 3746 3811 3745
  t 3811 3746 3812
  t 3747 3812 3746
  t 3812 3747 3813
  t 3748 3813 3747
  t 3813 3748 3814
  t 3749 3814 3748
  t 3814 3749 3815
  t 3750 3815 3749
  t 3815 3750 3816
  t 3751 3816 3750
  t 3816 3751 3817
  t 3752 3817 3751
  t 3817 3752 3818
  t 3753 3818 3752
  t 3818 3753 3819
  t 3754 3819 3753
  t 3819 3754 3820
  t 3755 3820 3754
  t 3820 3755 3821
  t 3756 3821 3755
  t 3821 3756 3822
  t 3757 3822 3756
  t 3822 3757 3823
  t 3758 3823 3757
  t 3823 3758 3824
  t 3759 3824 3758
  t 3824 3759 3825
  t 3760 3825 3759
  t 3825 3760 3826
  t 3761 3826 3760
  t 3826 3761 3827
  t 3762 3827 3761
  t 3827 3762 3828
  t 3763 3828 3762
  t 3828 3763 3829
  t 3764 3829 3763
  t 3829 3764 3830
  t 3765 3830 3764
  t 3830 3765 3831
  t 3766 3831 3765
  t 3831 3766 3832
  t 3767 3832 3766
  t 3832 3767 3833
  t 3768 3833 3767
  t 3833 3768 3834
  t 3769 3834 3768
  t 3835 3770 3836
  t 3771 3836 3770
  t 3836 3771 3837
  t 3772 3837 3771
  t 3837 3772 3838
  t 3773 3838 3772
  t 3838 3773 3839
  t 3774 3839 3773
  t 3839 3774 3840
  t 3775 3840 3774
  t 3840 3775 3841
  t 3776 3841 3775
  t 3841 3776 3842
  t 3777 3842 3776
  t 3842 3777 3843
  t 3778 3843 3777
  t 3843 3778 3844
  t 3779 3844 3778
  t 3844 3779 3845
  t 3780 3845 3779
  t 3845 3780 3846
  t 3781 3846 3780
  t 3846 3781 3847
  t 3782 3847 3781
  t 3847 3782 3848
  t 3783 3848 3782
  t 3848 3783 3849
  t 3784 3849 3783
  t 3849 3784 3850
  t 3785 3850 3784
  t 3850 3785 3851
  t 3786 3851 3785
  t 3851 3786 3852
  t 3787 3852 3786
  t 3852 3787 3853
  t 3788 3853 3787
  t 3853 3788 3854
  t 3789 3854 3788
  t 3854 3789 3855
  t 3790 3855 3789
  t 3855 3790 3856
  t 3791 3856 3790
  t 3856 3791 3857
  t 3792 3857 3791
  t 3857 3792 3858
  t 3793 3858 3792
  t 3858 3793 3859
  t 3794 3859 3793
  t 3859 3794 3860
  t 3795 3860 3794
  t 3860 3795 3861
  t 3796 3861 3795
  t 3861 3796 3862
  t 3797 3862 3796
  t 3862 3797 3863
  t 3798 3863 3797
  t 3863 3798 3864
  t 3799 3864 3798
  t 3864 3799 3865
  t 3800 3865 3799
  t 3865 3800 3866
  t 3801 3866 3800
  t 3866 3801 3867
  t 3802 3867 3801
  t 3867 3802 3868
  t 3803 3868 3802
  t 3868 3803 3869
  t 3804 3869 3803
  t 3869 3804 3870
  t 3805 3870 3804
  t 3870 3805 3871
  t 3806 3871 3805
  t 3871 3806 3872
  t 3807 3872 3806
  t 3872 3807 3873
  t 3808 3873 3807
  t 3873 3808 3874
  t 3809 3874 3808
  t 3874 3809 3875
  t 3810 3875 3809
  t 3875 3810 3876
  t 3811 3876 3810
  t 3876 3811 3877
  t 3812 3877 3811
  t 3877 3812 3878
  t 3813 3878 3812
  t 3878 3813 3879
  t 3814 3879 3813
  t 3879 3814 3880
  t 3815 3880 3814
  t 3880 3815 3881
  t 3816 3881 3815
  t 3881 3816 3882
  t 3817 3882 3816
  t 3882 3817 3883
  t 3818 3883 3817
  t 3883 3818 3884
  t 3819 3884 3818
  t 3884 3819 3885
  t 3820 3885 3819
  t 3885 3820 3886
  t 3821 3886 3820
  t 3886 3821 3887
  t 3822 3887 3821
  t 3887 3822 3888
  t 3823 3888 3822
  t 3888 3823 3889
  t 3824 3889 3823
  t 3889 3824 3890
  t 3825 3890 3824
  t 3890 3825 3891
  t 3826 3891 3825
  t 3891 3826 3892
  t 3827 3892 3826
  t 3892 3827 3893
  t 3828 3893 3827
  t 3893 3828 3894
  t 3829 3894 3828
  t 3894 3829 3895
  t 3830 3895 3829
  t 3895 3830 3896
  t 3831 3896 3830
  t 3896 3831 3897
  t 3832 3897 3831
  t 3897 3832 3898
  t 3833 3898 3832
  t 3898 3833 3899
  t 3834 3899 3833
  t 3900 3835 3901
  t 3836 3901 3835
  t 3901 3836 3902
  t 3837 3902 3836
  t 3902 3837 3903
  t 3838 3903 3837
  t 3903 3838 3904
  t 3839 3904 3838
  t 3904 3839 3905
  t 3840 3905 3839
  t 3905 3840 3906
  t 3841 3906 3840
  t 3906 3841 3907
  t 3842 3907 3841
  t 3907 3842 3908
  t 3843 3908 3842
  t 3908 3843 3909
  t 3844 3909 3843
  t 3909 3844 3910
  t 3845 3910 3844
  t 3910 3845 3911
  t 3846 3911 3845
  t 3911 3846 3912
  t 3847 3912 3846
  t 3912 3847 3913
  t 3848 3913 3847
  t 3913 3848 3914
  t 3849 3914 3848
  t 3914 3849 3915
  t 3850 3915 3849
  t 3915 3850 3916
  t 3851 3916 3850
  t 3916 3851 3917
  t 3852 3917 3851
  t 3917 3852 3918
  t 3853 3918 3852
  t 3918 3853 3919
  t 3854 3919 3853
  t 3919 3854 3920
  t 3855 3920 3854
  t 3920 3855 3921
  t 3856 3921 3855
  t 3921 3856 3922
  t 3857 3922 3856
  t 3922 3857 3923
  t 3858 3923 3857
  t 3923 3858 3924
  t 3859 3924 3858
  t 3924 3859 3925
  t 3860 3925 3859
  t 3925 3860 3926
  t 3861 3926 3860
  t 3926 3861 3927
  t 3862 3927 3861
  t 3927 3862 3928
  t 3863 3928 3862
  t 3928 3863 3929
  t 3864 3929 3863
  t 3929 3864 3930
  t 3865 3930 3864
  t 3930 3865 3931
  t 3866 3931 3865
  t 3931 3866 3932
  t 3867 3932 3866
  t 3932 3867 3933
  t 3868 3933 3867
  t 3933 3868 3934
  t 3869 3934 3868
  t 3934 3869 3935
  t 3870 3935 3869
  t 3935 3870 3936
  t 3871 3936 3870
  t 3936 3871 3937
  t 3872 3937 3871
  t 3937 3872 3938
  t 3873 3938 3872
  t 3938 3873 3939
  t 3874 3939 3873
  t 3939 3874 3940
  t 3875 3940 3874
  t 3940 3875 3941
  t 3876 3941 3875
  t 3941 3876 3942
  t 3877 3942 3876
  t 3942 3877 3943
  t 3878 3943 3877
  t 3943 3878 3944
  t 3879 3944 3878
  t 3944 3879 3945
  t 3880 3945 3879
  t 3945 3880 3946
  t 3881 3946 3880
  t 3946 3881 3947
  t 3882 3947 3881
  t 3947 3882 3948
  t 3883 3948 3882
  t 3948 3883 3949
  t 3884 3949 3883
  t 3949 3884 3950
  t 3885 3950 3884
  t 3950 3885 3951
  t 3886 3951 3885
  t 3951 3886 3952
  t 3887 3952 3886
  t 3952 3887 3953
  t 3888 3953 3887
  t 3953 3888 3954
  t 3889 3954 3888
  t 3954 3889 3955
  t 3890 3955 3889
  t 3955 3890 3956
  t 3891 3956 3890
  t 3956 3891 3957
  t 3892 3957 3891
  t 3957 3892 3958
  t 3893 3958 3892
  t 3958 3893 3959
  t 3894 3959 3893
  t 3959 3894 3960
  t 3895 3960 3894
  t 3960 3895 3961
  t 3896 3961 3895
  t 3961 3896 3962
  t 3897 3962 3896
  t 3962 3897 3963
  t 3898 3963 3897
  t 3963 3898 3964
  t 3899 3964 3898
  t 3965 3900 3966
  t 3901 3966 3900
  t 3966 3901 3967
  t 3902 3967 3901
  t 3967 3902 3968
  t 3903 3968 3902
  t 3968 3903 3969
  t 3904 3969 3903
  t 3969 3904 3970
  t 3905 3970 3904
  t 3970 3905 3971
  t 3906 3971 3905
  t 3971 3906 3972
  t 3907 3972 3906
  t 3972 3907 3973
  t 3908 3973 3907
  t 3973 3908 3974
  t 3909 3974 3908
  t 3974 3909 3975
  t 3910 3975 3909
  t 3975 3910 3976
  t 3911 3976 3910
  t 3976 3911 3977
  t 3912 3977 3911
  t 3977 3912 3978
  t 3913 3978 3912
  t 3978 3913 3979
  t 3914 3979 3913
  t 3979 3914 3980
  t 3915 3980 3914
  t 3980 3915 3981
  t 3916 3981 3915
  t 3981 3916 3982
  t 3917 3982 3916
  t 3982 3917 3983
  t 3918 3983 3917
  t 3983 3918 3984
  t 3919 3984 3918
  t 3984 3919 3985
  t 3920 3985 3919
  t 3985 3920 3986
  t 3921 3986 3920
  t 3986 3921 3987
  t 3922 3987 3921
  t 3987 3922 3988
  t 3923 3988 3922
  t 3988 3923 3989
  t 3924 3989 3923
  t 3989 3924 3990
  t 3925 3990 3924
  t 3990 3925 3991
  t 3926 3991 3925
  t 3991 3926 3992
  t 3927 3992 3926
  t 3992 3927 3993
  t 3928 3993 3927
  t 3993 3928 3994
  t 3929 3994 3928
  t 3994 3929 3995
  t 3930 3995 3929
  t 3995 3930 3996
  t 3931 3996 3930
  t 3996 3931 3997
  t 3932 3997 3931
  t 3997 3932 3998
  t 3933 3998 3932
  t 3998 3933 3999
  t 3934 3999 3933
  t 3999 3934 4000
  t 3935 4000 3934
  t 4000 3935 4001
  t 3936 4001 3935
  t 4001 3936 4002
  t 3937 4002 3936
  t 4002 3937 4003
  t 3938 4003 3937
  t 4003 3938 4004
  t 3939 4004 3938
  t 4004 3939 4005
  t 3940 4005 3939
  t 4005 3940 4006
  t 3941 4006 3940
  t 4006 3941 4007
  t 3942 4007 3941
  t 4007 3942 4008
  t 3943 4008 3942
  t 4008 3943 4009
  t 3944 4009 3943
  t 4009 3944 4010
  t 3945 4010 3944
  t 4010 3945 4011
  t 3946 4011 3945
  t 4011 3946 4012
  t 3947 4012 3946
  t 4012 3947 4013
  t 3948 4013 3947
  t 4013 3948 4014
  t 3949 4014 3948
  t 4014 3949 4015
  t 3950 4015 3949
  t 4015 3950 4016
  t 3951 4016 3950
  t 4016 3951 4017
  t 3952 4017 3951
  t 4017 3952 4018
  t 3953 4018 3952
  t 4018 3953 4019
  t 3954 4019 3953
  t 4019 3954 4020
  t 3955 4020 3954
  t 4020 3955 4021
  t 3956 4021 3955
  t 4021 3956 4022
  t 3957 4022 3956
  t 4022 3957 4023
  t 3958 4023 3957
  t 4023 3958 4024
  t 3959 4024 3958
  t 4024 3959 4025
  t 3960 4025 3959
  t 4025 3960 4026
  t 3961 4026 3960
  t 4026 3961 4027
  t 3962 4027 3961
  t 4027 3962 4028
  t 3963 4028 3962
  t 4028 3963 4029
  t 3964 4029 3963
  t 4030 3965 4031
  t 3966 4031 3965
  t 4031 3966 4032
  t 3967 4032 3966
  t 4032 3967 4033
  t 3968 4033 3967
  t 4033 3968 4034
  t 3969 4034 3968
  t 4034 3969 4035
  t 3970 4035 3969
  t 4035 3970 4036
  t 3971 4036 3970
  t 4036 3971 4037
  t 3972 4037 3971
  t 4037 3972 4038
  t 3973 4038 3972
  t 4038 3973 4039
  t 3974 4039 3973
  t 4039 3974 4040
  t 3975 4040 3974
  t 4040 3975 4041
  t 3976 4041 3975
  t 4041 3976 4042
  t 3977 4042 3976
  t 4042 3977 4043
  t 3978 4043 3977
  t 4043 3978 4044
  t 3979 4044 3978
  t 4044 3979 4045
  t 3980 4045 3979
  t 4045 3980 4046
  t 3981 4046 3980
  t 4046 3981 4047
  t 3982 4047 3981
  t 4047 3982 4048
  t 3983 4048 3982
  t 4048 3983 4049
  t 3984 4049 3983
  t 4049 3984 4050
  t 3985 4050 3984
  t 4050 3985 4051
  t 3986 4051 3985
  t 4051 3986 4052
  t 3987 4052 3986
  t 4052 3987 4053
  t 3988 4053 3987
  t 4053 3988 4054
  t 3989 4054 3988
  t 4054 3989 4055
  t 3990 4055 3989
  t 4055 3990 4056
  t 3991 4056 3990
  t 4056 3991 4057
  t 3992 4057 3991
  t 4057 3992 4058
  t 3993 4058 3992
  t 4058 3993 4059
  t 3994 4059 3993
  t 4059 3994 4060
  t 3995 4060 3994
  t 4060 3995 4061
  t 3996 4061 3995
  t 4061 3996 4062
  t 3997 4062 3996
  t 4062 3997 4063
  t 3998 4063 3997
  t 4063 3998 4064
  t 3999 4064 3998
  t 4064 3999 4065
  t 4000 4065 3999
  t 4065 4000 4066
  t 4001 4066 4000
  t 4066 4001 4067
  t 4002 4067 4001
  t 4067 4002 4068
  t 4003 4068 4002
  t 4068 4003 4069
  t 4004 4069 4003
  t 4069 4004 4070
  t 4005 4070 4004
  t 4070 4005 4071
  t 4006 4071 4005
  t 4071 4006 4072
  t 4007 4072 4006
  t 4072 4007 4073
  t 4008 4073 4007
  t 4073 4008 4074
  t 4009 4074 4008
  t 4074 4009 4075
  t 4010 4075 4009
  t 4075 4010 4076
  t 4011 4076 4010
  t 4076 4011 4077
  t 4012 4077 4011
  t 4077 4012 4078
  t 4013 4078 4012
  t 4078 4013 4079
  t 4014 4079 4013
  t 4079 4014 4080
  t 4015 4080 4014
  t 4080 4015 4081
  t 4016 4081 4015
  t 4081 4016 4082
  t 4017 4082 4016
  t 4082 4017 4083
  t 4018 4083 4017
  t 4083 4018 4084
  t 4019 4084 4018
  t 4084 4019 4085
  t 4020 4085 4019
  t 4085 4020 4086
  t 4021 4086 4020
  t 4086 4021 4087
  t 4022 4087 4021
  t 4087 4022 4088
  t 4023 4088 4022
  t 4088 4023 4089
  t 4024 4089 4023
  t 4089 4024 4090
  t 4025 4090 4024
  t 4090 4025 4091
  t 4026 4091 4025
  t 4091 4026 4092
  t 4027 4092 4026
  t 4092 4027 4093
  t 4028 4093 4027
  t 4093 4028 4094
  t 4029 4094 4028
  t 4095 4030 4096
  t 4031 4096 4030
  t 4096 4031 4097
  t 4032 4097 4031
  t 4097 4032 4098
  t 4033 4098 4032
  t 4098 4033 4099
  t 4034 4099 4033
  t 4099 4034 4100
  t 4035 4100 4034
  t 4100 4035 4101
  t 4036 4101 4035
  t 4101 4036 4102
  t 4037 4102 4036
  t 4102 4037 4103
  t 4038 4103 4037
  t 4103 4038 4104
  t 4039 4104 4038
  t 4104 4039 4105
  t 4040 4105 4039
  t 4105 4040 4106
  t 4041 4106 4040
  t 4106 4041 4107
  t 4042 4107 4041
  t 4107 4042 4108
  t 4043 4108 4042
  t 4108 4043 4109
  t 4044 4109 4043
  t 4109 4044 4110
  t 4045 4110 4044
  t 4110 4045 4111
  t 4046 4111 4045
  t 4111 4046 4112
  t 4047 4112 4046
  t 4112 4047 4113
  t 4048 4113 4047
  t 4113 4048 4114
  t 4049 4114 4048
  t 4114 4049 4115
  t 4050 4115 4049
  t 4115 4050 4116
  t 4051 4116 4050
  t 4116 4051 4117
  t 4052 4117 4051
  t 4117 4052 4118
  t 4053 4118 4052
  t 4118 4053 4119
  t 4054 4119 4053
  t 4119 4054 4120
  t 4055 4120 4054
  t 4120 4055 4121
  t 4056 4121 4055
  t 4121 4056 4122
  t 4057 4122 4056
  t 4122 4057 4123
  t 4058 4123 4057
  t 4123 4058 4124
  t 4059 4124 4058
  t 4124 4059 4125
  t 4060 4125 4059
  t 4125 4060 4126
  t 4061 4126 4060
  t 4126 4061 4127
  t 4062 4127 4061
  t 4127 4062 4128
  t 4063 4128 4062
  t 4128 4063 4129
  t 4064 4129 4063
  t 4129 4064 4130
  t 4065 4130 4064
  t 4130 4065 4131
  t 4066 4131 4065
  t 4131 4066 4132
  t 4067 4132 4066
  t 4132 4067 4133
  t 4068 4133 4067
  t 4133 4068 4134
  t 4069 4134 4068
  t 4134 4069 4135
  t 4070 4135 4069
  t 4135 4070 4136
  t 4071 4136 4070
  t 4136 4071 4137
  t 4072 4137 4071
  t 4137 4072 4138
  t 4073 4138 4072
  t 4138 4073 4139
  t 4074 4139 4073
  t 4139 4074 4140
  t 4075 4140 4074
  t 4140 4075 4141
  t 4076 4141 4075
  t 4141 4076 4142
  t 4077 4142 4076
  t 4142 4077 4143
  t 4078 4143 4077
  t 4143 4078 4144
  t 4079 4144 4078
  t 4144 4079 4145
  t 4080 4145 4079
  t 4145 4080 4146
  t 4081 4146 4080
  t 4146 4081 4147
  t 4082 4147 4081
  t 4147 4082 4148
  t 4083 4148 4082
  t 4148 4083 4149
  t 4084 4149 4083
  t 4149 4084 4150
  t 4085 4150 4084
  t 4150 4085 4151
  t 4086 4151 4085
  t 4151 4086 4152
  t 4087 4152 4086
  t 4152 4087 4153
  t 4088 4153 4087
  t 4153 4088 4154
  t 4089 4154 4088
  t 4154 4089 4155
  t 4090 4155 4089
  t 4155 4090 4156
  t 4091 4156 4090
  t 4156 4091 4157
  t 4092 4157 4091
  t 4157 4092 4158
  t 4093 4158 4092
  t 4158 4093 4159
  t 4094 4159 4093
  t 4160 4095 4161
  t 4096 4161 4095
  t 4161 4096 4162
  t 4097 4162 4096
  t 4162 4097 4163
  t 4098 4163 4097
  t 4163 4098 4164
  t 4099 4164 4098
  t 4164 4099 4165
  t 4100 4165 4099
  t 4165 4100 4166
  t 4101 4166 4100
  t 4166 4101 4167
  t 4102 4167 4101
  t 4167 4102 4168
  t 4103 4168 4102
  t 4168 4103 4169
  t 4104 4169 4103
  t 4169 4104 4170
  t 4105 4170 4104
  t 4170 4105 4171
  t 4106 4171 4105
  t 4171 4106 4172
  t 4107 4172 4106
  t 4172 4107 4173
  t 4108 4173 4107
  t 4173 4108 4174
  t 4109 4174 4108
  t 4174 4109 4175
  t 4110 4175 4109
  t 4175 4110 4176
  t 4111 4176 4110
  t 4176 4111 4177
  t 4112 4177 4111
  t 4177 4112 4178
  t 4113 4178 4112
  t 4178 4113 4179
  t 4114 4179 4113
  t 4179 4114 4180
  t 4115 4180 4114
  t 4180 4115 4181
  t 4116 4181 4115
  t 4181 4116 4182
  t 4117 4182 4116
  t 4182 4117 4183
  t 4118 4183 4117
  t 4183 4118 4184
  t 4119 4184 4118
  t 4184 4119 4185
  t 4120 4185 4119
  t 4185 4120 4186
  t 4121 4186 4120
  t 4186 4121 4187
  t 4122 4187 4121
  t 4187 4122 4188
  t 4123 4188 4122
  t 4188 4123 4189
  t 4124 4189 4123
  t 4189 4124 4190
  t 4125 4190 4124
  t 4190 4125 4191
  t 4126 4191 4125
  t 4191 4126 4192
  t 4127 4192 4126
  t 4192 4127 4193
  t 4128 4193 4127
  t 4193 4128 4194
  t 4129 4194 4128
  t 4194 4129 4195
  t 4130 4195 4129
  t 4195 4130 4196
  t 4131 4196 4130
  t 4196 4131 4197
  t 4132 4197 4131
  t 4197 4132 4198
  t 4133 4198 4132
  t 4198 4133 4199
  t 4134 4199 4133
  t 4199 4134 4200
  t 4135 4200 4134
  t 4200 4135 4201
  t 4136 4201 4135
  t 4201 4136 4202
  t 4137 4202 4136
  t 4202 4137 4203
  t 4138 4203 4137
  t 4203 4138 4204
  t 4139 4204 4138
  t 4204 4139 4205
  t 4140 4205 4139
  t 4205 4140 4206
  t 4141 4206 4140
  t 4206 4141 4207
  t 4142 4207 4141
  t 4207 4142 4208
  t 4143 4208 4142
  t 4208 4143 4209
  t 4144 4209 4143
  t 4209 4144 4210
  t 4145 4210 4144
  t 4210 4145 4211
  t 4146 4211 4145
  t 4211 4146 4212
  t 4147 4212 4146
  t 4212 4147 4213
  t 4148 4213 4147
  t 4213 4148 4214
  t 4149 4214 4148
  t 4214 4149 4215
  t 4150 4215 4149
  t 4215 4150 4216
  t 4151 4216 4150
  t 4216 4151 4217
  t 4152 4217 4151
  t 4217 4152 4218
  t 4153 4218 4152
  t 4218 4153 4219
  t 4154 4219 4153
  t 4219 4154 4220
  t 4155 4220 4154
  t 4220 4155 4221
  t 4156 4221 4155
  t 4221 4156 4222
  t 4157 4222 4156
  t 4222 4157 4223
  t 4158 4223 4157
  t 4223 4158 4224
  t 4159 4224 4158
}

object {
  shader Yellow
  type mesh
  name Box
  24 12
  v 19.5329 28.43 16.9153    0.605138 0.671441 -0.427755    0 0
  v 35.4553 18.2227 23.4181    0.605138 0.671441 -0.427755    0 0
  v 19.5329 39.176 33.7831    0.605138 0.671441 -0.427755    0 0
  v 35.4553 28.9687 40.2859    0.605138 0.671441 -0.427755    0 0
  v 7.43012 15.0012 25.4704    -0.605138 -0.671441 0.427755    0 0
  v 23.3525 4.79385 31.9732    -0.605138 -0.671441 0.427755    0 0
  v 7.43012 25.7472 42.3382    -0.605138 -0.671441 0.427755    0 0
  v 23.3525 15.5398 48.841    -0.605138 -0.671441 0.427755    0 0
  v 19.5329 28.43 16.9153    -1.49734e-007 -0.5373 -0.843391    0 0
  v 19.5329 28.43 16.9153    -0.796121 0.510368 -0.32514    0 0
  v 35.4553 18.2227 23.4181    -1.31784e-007 -0.5373 -0.843391    0 0
  v 35.4553 18.2227 23.4181    0.796121 -0.510368 0.32514    0 0
  v 19.5329 39.176 33.7831    1.70527e-007 0.5373 0.843391    0 0
  v 19.5329 39.176 33.7831    -0.796121 0.510368 -0.32514    0 0
  v 35.4553 28.9687 40.2859    0.796121 -0.510368 0.32514    0 0
  v 35.4553 28.9687 40.2859    1.75421e-007 0.5373 0.843391    0 0
  v 7.43012 15.0012 25.4704    -1.67685e-007 -0.5373 -0.843391    0 0
  v 7.43012 15.0012 25.4704    -0.796121 0.510368 -0.32514    0 0
  v 23.3525 4.79385 31.9732    -1.49734e-007 -0.5373 -0.843391    0 0
  v 23.3525 4.79385 31.9732    0.796121 -0.510368 0.32514    0 0
  v 7.43012 25.7472 42.3382    1.75421e-007 0.5373 0.843391    0 0
  v 7.43012 25.7472 42.3382    -0.796121 0.510368 -0.32514    0 0
  v 23.3525 15.5398 48.841    0.796121 -0.510368 0.32514    0 0
  v 23.3525 15.5398 48.841    1.80314e-007 0.5373 0.843392    0 0
  t 0 2 3
  t 3 1 0
  t 4 5 7
  t 7 6 4
  t 8 10 18
  t 18 16 8
  t 11 14 22
  t 22 19 11
  t 15 12 20
  t 20 23 15
  t 13 9 17
  t 17 21 13
}

object {
  shader DarkBlue
  type mesh
  name Teapot	
  2828 4096
  v -11.2295 -23.9605 15.0933    -0.683008 0.715486 -0.1469    2 2
  v -11.2328 -23.9079 15.3643    -0.671192 0.741057 0.0183311    2 1.9875
  v -11.2003 -23.9039 15.547    -0.567144 0.717074 0.405158    2 1.975
  v -11.1418 -23.9389 15.6445    -0.181367 0.407827 0.894865    2 1.9625
  v -11.0674 -24.0034 15.6599    0.29285 -0.0996496 0.950952    2 1.95
  v -10.9869 -24.0879 15.5962    0.535415 -0.416327 0.734848    2 1.9375
  v -10.9102 -24.1829 15.4566    0.629882 -0.567825 0.529928    2 1.925
  v -10.8471 -24.2788 15.244    0.66925 -0.65117 0.357886    2 1.9125
  v -10.8076 -24.3662 14.9617    0.680404 -0.688057 0.252246    2 1.9
  v -12.4854 -25.1045 15.3601    -0.587918 0.790977 -0.169435    1.875 2
  v -12.4741 -25.0388 15.6281    -0.602131 0.797367 -0.040544    1.875 1.9875
  v -12.4386 -25.0321 15.8102    -0.522156 0.79233 0.315541    1.875 1.975
  v -12.3867 -25.073 15.9091    -0.226649 0.52956 0.817433    1.875 1.9625
  v -12.3261 -25.1501 15.9274    0.21537 -0.0183318 0.97636    1.875 1.95
  v -12.2647 -25.252 15.8677    0.470132 -0.407319 0.782986    1.875 1.9375
  v -12.2102 -25.3672 15.7328    0.564749 -0.591426 0.575563    1.875 1.925
  v -12.1704 -25.4844 15.5252    0.601563 -0.690738 0.401252    1.875 1.9125
  v -12.1532 -25.592 15.2476    0.612272 -0.738761 0.281701    1.875 1.9
  v -13.8791 -25.943 15.6791    -0.430219 0.878809 -0.206411    1.75 2
  v -13.8516 -25.8675 15.9434    -0.440925 0.894166 -0.0778001    1.75 1.9875
  v -13.8128 -25.8588 16.1247    -0.357981 0.891334 0.278161    1.75 1.975
  v -13.7681 -25.9041 16.2253    -0.109936 0.601593 0.791201    1.75 1.9625
  v -13.7229 -25.9904 16.2471    0.222509 -0.0115474 0.974862    1.75 1.95
  v -13.6827 -26.1051 16.1923    0.395956 -0.450223 0.800324    1.75 1.9375
  v -13.6529 -26.2352 16.063    0.45098 -0.658762 0.602204    1.75 1.925
  v -13.6389 -26.3679 15.8614    0.465818 -0.771715 0.432978    1.75 1.9125
  v -13.6464 -26.4904 15.5894    0.465512 -0.826743 0.315903    1.75 1.9
  v -15.3674 -26.474 16.0392    -0.260496 0.933042 -0.248141    1.625 2
  v -15.3227 -26.3924 16.2993    -0.266008 0.956423 -0.120392    1.625 1.9875
  v -15.2804 -26.3824 16.4797    -0.179772 0.955183 0.235177    1.625 1.975
  v -15.2434 -26.4304 16.5821    0.0170094 0.648676 0.760875    1.625 1.9625
  v -15.2146 -26.5226 16.6079    0.230753 -0.00637952 0.972991    1.625 1.95
  v -15.197 -26.6453 16.5586    0.315892 -0.477362 0.819962    1.625 1.9375
  v -15.1935 -26.7848 16.4357    0.327814 -0.701816 0.632449    1.625 1.925
  v -15.2072 -26.9274 16.2407    0.318687 -0.823662 0.469062    1.625 1.9125
  v -15.241 -27.0593 15.9752    0.306329 -0.883307 0.354867    1.625 1.9
  v -16.9073 -26.6957 16.4291    -0.0850609 0.952332 -0.292964    1.5 2
  v -16.8448 -26.6115 16.6846    -0.0841464 0.982435 -0.166555    1.5 1.9875
  v -16.7988 -26.601 16.8642    0.00553783 0.982099 0.188285    1.5 1.975
  v -16.7697 -26.6502 16.9686    0.1492 0.66958 0.7276    1.5 1.9625
  v -16.7579 -26.7448 16.9987    0.239675 -0.00297564 0.970849    1.5 1.95
  v -16.7637 -26.8709 16.9553    0.232938 -0.488168 0.84109    1.5 1.9375
  v -16.7876 -27.0143 16.8393    0.199938 -0.71958 0.665003    1.5 1.925
  v -16.8298 -27.161 16.6516    0.165807 -0.845273 0.507957    1.5 1.9125
  v -16.8909 -27.2969 16.3929    0.140848 -0.906977 0.396933    1.5 1.9
  v -18.4557 -26.6063 16.8377    0.0904965 0.936269 -0.339427    1.375 2
  v -18.3753 -26.5231 17.0885    0.0987312 0.971665 -0.214752    1.375 1.9875
  v -18.3256 -26.5128 17.2671    0.191882 0.97152 0.139036    1.375 1.975
  v -18.3045 -26.5615 17.3736    0.28237 0.663902 0.69246    1.375 1.9625
  v -18.3097 -26.6552 17.4082    0.248953 -0.00136773 0.968515    1.375 1.95
  v -18.3391 -26.7799 17.3711    0.149651 -0.482462 0.863038    1.375 1.9375
  v -18.3904 -26.9217 17.2623    0.0713766 -0.711739 0.698808    1.375 1.925
  v -18.4614 -27.0668 17.0821    0.0120629 -0.836139 0.548384    1.375 1.9125
  v -18.5499 -27.201 16.8307    -0.0255994 -0.897285 0.44071    1.375 1.9
  v -19.9694 -26.2038 17.2539    0.26038 0.884969 -0.386046    1.25 2
  v -19.8715 -26.1253 17.4999    0.276666 0.924151 -0.263442    1.25 1.9875
  v -19.8183 -26.116 17.6775    0.373183 0.923476 0.0890292    1.25 1.975
  v -19.805 -26.1626 17.7862    0.412303 0.631602 0.656571    1.25 1.9625
  v -19.8269 -26.2518 17.8254    0.258341 -0.0015911 0.966052    1.25 1.95
  v -19.8793 -26.3704 17.7945    0.0686309 -0.460225 0.885145    1.25 1.9375
  v -19.9574 -26.5051 17.6932    -0.0538071 -0.678279 0.732831    1.25 1.925
  v -20.0564 -26.6427 17.5207    -0.137626 -0.796261 0.58909    1.25 1.9125
  v -20.1718 -26.7698 17.2766    -0.18765 -0.854245 0.484823    1.25 1.9
  v -21.4055 -25.4865 17.6666    0.417767 0.799755 -0.431118    1.125 2
  v -21.2909 -25.4163 17.9078    0.442769 0.841032 -0.310838    1.125 1.9875
  v -21.2343 -25.4087 18.0844    0.542456 0.839121 0.0402115    1.125 1.975
  v -21.2284 -25.4516 18.1952    0.534114 0.573311 0.621319    1.125 1.9625
  v -21.2662 -25.5329 18.2389    0.267597 -0.00367541 0.963524    1.125 1.95
  v -21.3404 -25.6406 18.2144    -0.00698759 -0.421848 0.90664    1.125 1.9375
  v -21.4439 -25.7626 18.1203    -0.17079 -0.619853 0.765907    1.125 1.925
  v -21.5697 -25.8869 17.9555    -0.277482 -0.726494 0.628658    1.125 1.9125
  v -21.7104 -26.0013 17.7188    -0.339042 -0.778817 0.527726    1.125 1.9
  v -22.7208 -24.4525 18.0645    0.549215 0.686819 -0.47607    1 2
  v -22.591 -24.3943 18.3011    0.585966 0.727386 -0.357146    1 1.9875
  v -22.5312 -24.3891 18.4768    0.690003 0.723762 -0.00800819    1 1.975
  v -22.5321 -24.4267 18.5897    0.641954 0.492327 0.5878    1 1.9625
  v -22.5844 -24.4966 18.6378    0.276133 -0.00792076 0.961087    1 1.95
  v -22.6786 -24.5886 18.6193    -0.0734495 -0.369089 0.926487    1 1.9375
  v -22.8054 -24.6923 18.5323    -0.273685 -0.538938 0.796644    1 1.925
  v -22.9556 -24.7973 18.3748    -0.400519 -0.629841 0.665496    1 1.9125
  v -23.1196 -24.8934 18.1451    -0.472278 -0.674314 0.567674    1 1.9
  v -23.9217 -23.0668 18.4513    0.637974 0.544191 -0.544835    0.875 2
  v -23.7433 -23.058 18.6726    0.689291 0.585627 -0.42652    0.875 1.9875
  v -23.6539 -23.0819 18.839    0.806191 0.585372 -0.0860023    0.875 1.975
  v -23.6411 -23.1314 18.9476    0.739775 0.400358 0.540784    0.875 1.9625
  v -23.6923 -23.1997 18.9956    0.284993 -0.012299 0.958451    0.875 1.95
  v -23.7953 -23.2798 18.98    -0.130958 -0.304972 0.943314    0.875 1.9375
  v -23.9374 -23.3647 18.898    -0.359862 -0.438911 0.82332    0.875 1.925
  v -24.1063 -23.4474 18.7466    -0.502396 -0.509833 0.698333    0.875 1.9125
  v -24.2895 -23.521 18.5231    -0.582423 -0.544495 0.60358    0.875 1.9
  v -24.7668 -21.5904 18.7501    0.687844 0.376351 -0.62067    0.75 2
  v -24.5623 -21.6144 18.9628    0.749807 0.416917 -0.513779    0.75 1.9875
  v -24.4583 -21.6538 19.1246    0.886317 0.421339 -0.192133    0.75 1.975
  v -24.4405 -21.7048 19.2319    0.831107 0.294732 0.471587    0.75 1.9625
  v -24.4944 -21.7632 19.281    0.29906 -0.0155818 0.954107    0.75 1.95
  v -24.6057 -21.8251 19.2686    -0.178554 -0.230883 0.956458    0.75 1.9375
  v -24.7601 -21.8866 19.191    -0.427143 -0.323221 0.844439    0.75 1.925
  v -24.943 -21.9435 19.0447    -0.579828 -0.37091 0.725414    0.75 1.9125
  v -25.1402 -21.9919 18.8261    -0.665645 -0.394103 0.633719    0.75 1.9
  v -25.2682 -20.055 18.9623    0.713814 0.196736 -0.672134    0.625 2
  v -25.0557 -20.0988 19.172    0.780504 0.232756 -0.580206    0.625 1.9875
  v -24.9489 -20.1435 19.3327    0.932029 0.234127 -0.276598    0.625 1.975
  v -24.9324 -20.1876 19.4407    0.898499 0.162091 0.407953    0.625 1.9625
  v -24.991 -20.23 19.4919    0.314854 -0.0227869 0.948867    0.625 1.95
  v -25.1094 -20.2691 19.4825    -0.210448 -0.147696 0.966384    0.625 1.9375
  v -25.2722 -20.3037 19.4086    -0.470722 -0.196198 0.86019    0.625 1.925
  v -25.4643 -20.3324 19.2661    -0.629032 -0.21957 0.745727    0.625 1.9125
  v -25.6702 -20.3537 19.0513    -0.718302 -0.23047 0.656449    0.625 1.9
  v -25.4379 -18.4921 19.0895    0.726162 0.0140427 -0.68738    0.5 2
  v -25.2313 -18.5465 19.3002    0.794122 0.0437394 -0.606183    0.5 1.9875
  v -25.1301 -18.5892 19.4625    0.950673 0.0352081 -0.30819    0.5 1.975
  v -25.119 -18.621 19.5725    0.925778 0.0082889 0.377977    0.5 1.9625
  v -25.1827 -18.643 19.6261    0.324934 -0.0356223 0.945065    0.5 1.95
  v -25.3057 -18.6563 19.6193    -0.222045 -0.0589668 0.973252    0.5 1.9375
  v -25.4729 -18.6619 19.548    -0.487566 -0.062865 0.87082    0.5 1.925
  v -25.6689 -18.6608 19.4082    -0.648289 -0.0616684 0.758893    0.5 1.9125
  v -25.8783 -18.654 19.1958    -0.739024 -0.0599255 0.671009    0.5 1.9
  v -25.2882 -16.9335 19.1332    0.725227 -0.168416 -0.667594    0.375 2
  v -25.0968 -16.993 19.3475    0.793945 -0.145999 -0.5902    0.375 1.9875
  v -25.0064 -17.0293 19.513    0.944693 -0.165458 -0.28316    0.375 1.975
  v -25.0022 -17.0457 19.6256    0.908456 -0.148384 0.390756    0.375 1.9625
  v -25.0697 -17.0453 19.6815    0.324584 -0.0506269 0.944501    0.375 1.95
  v -25.1942 -17.0313 19.6765    -0.212052 0.0301234 0.976794    0.375 1.9375
  v -25.3611 -17.0071 19.6067    -0.47678 0.0714253 0.876116    0.375 1.925
  v -25.5556 -16.9757 19.4681    -0.637089 0.0974719 0.764602    0.375 1.9125
  v -25.7632 -16.9405 19.2567    -0.727419 0.111999 0.676991    0.375 1.9
  v -24.8313 -15.4107 19.0948    0.701837 -0.345019 -0.623206    0.25 2
  v -24.66 -15.4735 19.3142    0.77194 -0.331568 -0.542375    0.25 1.9875
  v -24.5821 -15.5024 19.4834    0.907943 -0.357608 -0.218531    0.25 1.975
  v -24.5842 -15.5027 19.5985    0.853037 -0.29019 0.433724    0.25 1.9625
  v -24.6527 -15.4796 19.6558    0.315738 -0.0630143 0.946752    0.25 1.95
  v -24.7744 -15.4386 19.6515    -0.182708 0.114694 0.976454    0.25 1.9375
  v -24.9357 -15.3849 19.5818    -0.439368 0.201399 0.875439    0.25 1.925
  v -25.1232 -15.3239 19.443    -0.595711 0.252515 0.762472    0.25 1.9125
  v -25.3237 -15.2608 19.2312    -0.683586 0.279749 0.67413    0.25 1.9
  v -24.0791 -13.9553 18.9759    0.644423 -0.504103 -0.574978    0.125 2
  v -23.9286 -14.0234 19.2004    0.716337 -0.502332 -0.484276    0.125 1.9875
  v -23.8618 -14.0468 19.3727    0.835275 -0.530205 -0.145596    0.125 1.975
  v -23.8669 -14.0329 19.4894    0.773565 -0.409512 0.483629    0.125 1.9625
  v -23.9321 -13.9891 19.5469    0.304114 -0.0711056 0.949978    0.125 1.95
  v -24.0456 -13.9228 19.5418    -0.138409 0.191535 0.971678    0.125 1.9375
  v -24.1956 -13.8413 19.4707    -0.377937 0.321989 0.868036    0.125 1.925
  v -24.3705 -13.7521 19.3301    -0.525494 0.39747 0.752246    0.125 1.9125
  v -24.5583 -13.6625 19.1164    -0.608544 0.436871 0.662433    0.125 1.9
  v -23.0439 -12.599 18.7778    0.620407 -0.554488 -0.554652    0 2
  v -22.9104 -12.678 19.0062    0.658221 -0.57067 -0.491    0 1.9875
  v -22.8499 -12.7009 19.1802    0.770664 -0.608091 -0.190532    0 1.975
  v -22.8524 -12.6773 19.2967    0.765388 -0.519823 0.379427    0 1.9625
  v -22.9082 -12.6166 19.3527    0.375428 -0.150903 0.914485    0 1.95
  v -23.0074 -12.5283 19.345    -0.0678276 0.188873 0.979656    0 1.9375
  v -23.1399 -12.422 19.2707    -0.31421 0.357775 0.879357    0 1.925
  v -23.2961 -12.3071 19.1265    -0.463429 0.452017 0.762177    0 1.9125
  v -23.4659 -12.1932 18.9094    -0.553917 0.505093 0.661858    0 1.9
  v -21.788 -11.4549 18.511    0.410221 -0.754824 -0.51182    1.875 2
  v -21.669 -11.5472 18.7424    0.485254 -0.773588 -0.407541    1.875 1.9875
  v -21.6115 -11.5728 18.917    0.589041 -0.805938 -0.059118    1.875 1.975
  v -21.6076 -11.5433 19.0322    0.582378 -0.601933 0.546363    1.875 1.9625
  v -21.6495 -11.4699 19.0852    0.288113 -0.0841025 0.953896    1.875 1.95
  v -21.7296 -11.3643 19.0735    -0.0184231 0.315417 0.948774    1.875 1.9375
  v -21.8399 -11.2377 18.9944    -0.197307 0.516668 0.833141    1.875 1.925
  v -21.9727 -11.1016 18.8453    -0.311793 0.631784 0.709672    1.875 1.9125
  v -22.1203 -10.9674 18.6235    -0.378137 0.691125 0.61592    1.875 1.9
  v -20.3944 -10.6164 18.1919    0.252278 -0.842607 -0.475782    1.75 2
  v -20.2915 -10.7184 18.4271    0.32388 -0.870352 -0.370929    1.75 1.9875
  v -20.2373 -10.746 18.6025    0.424958 -0.904961 -0.0213835    1.75 1.975
  v -20.2262 -10.7121 18.716    0.465854 -0.674004 0.573323    1.75 1.9625
  v -20.2528 -10.6296 18.7655    0.280974 -0.090884 0.955402    1.75 1.95
  v -20.3116 -10.5112 18.7489    0.0558834 0.358292 0.931936    1.75 1.9375
  v -20.3972 -10.3697 18.6642    -0.0832731 0.58395 0.807507    1.75 1.925
  v -20.5042 -10.218 18.5091    -0.175747 0.7127 0.679097    1.75 1.9125
  v -20.6271 -10.069 18.2817    -0.231092 0.77905 0.582819    1.75 1.9
  v -18.906 -10.0854 17.8319    0.0823904 -0.896807 -0.434684    1.625 2
  v -18.8204 -10.1935 18.0712    0.148831 -0.932583 -0.328845    1.625 1.9875
  v -18.7697 -10.2224 18.2475    0.246804 -0.96882 0.0218102    1.625 1.975
  v -18.7509 -10.1858 18.3591    0.339048 -0.721118 0.604181    1.625 1.9625
  v -18.7611 -10.0974 18.4047    0.272733 -0.0960521 0.957283    1.625 1.95
  v -18.7973 -9.97089 18.3826    0.136041 0.385413 0.91266    1.625 1.9375
  v -18.8566 -9.82002 18.2915    0.0400881 0.626964 0.778016    1.625 1.925
  v -18.9359 -9.65851 18.1298    -0.0283911 0.764601 0.643878    1.625 1.9125
  v -19.0324 -9.50008 17.8959    -0.0716923 0.83557 0.544687    1.625 1.9
  v -17.3661 -9.86369 17.442    -0.0930871 -0.916089 -0.390021    1.5 2
  v -17.2983 -9.97439 17.6859    -0.0330836 -0.958584 -0.282882    1.5 1.9875
  v -17.2513 -10.0038 17.863    0.0615017 -0.995738 0.0687321    1.5 1.975
  v -17.2246 -9.96605 17.9726    0.206906 -0.742029 0.637639    1.5 1.9625
  v -17.2178 -9.87519 18.0139    0.263815 -0.0994696 0.959431    1.5 1.95
  v -17.2306 -9.74532 17.9859    0.219025 0.396214 0.891652    1.5 1.9375
  v -17.2625 -9.59053 17.8879    0.168033 0.644714 0.745727    1.5 1.925
  v -17.3133 -9.42491 17.7189    0.124569 0.786197 0.605291    1.5 1.9125
  v -17.3825 -9.26254 17.4782    0.0938662 0.859224 0.502915    1.5 1.9
  v -15.8178 -9.95314 17.0334    -0.268556 -0.900043 -0.34322    1.375 2
  v -15.7679 -10.0628 17.282    -0.215924 -0.947822 -0.234544    1.375 1.9875
  v -15.7245 -10.092 17.4601    -0.124883 -0.985151 0.117824    1.375 1.975
  v -15.6898 -10.0547 17.5676    0.0736877 -0.736335 0.672593    1.375 1.9625
  v -15.6659 -9.96485 17.6044    0.254537 -0.101071 0.961767    1.375 1.95
  v -15.6552 -9.83634 17.5702    0.302274 0.390512 0.869558    1.375 1.9375
  v -15.6597 -9.68313 17.4649    0.296524 0.636887 0.711652    1.375 1.925
  v -15.6818 -9.51917 17.2883    0.278237 0.777076 0.564568    1.375 1.9125
  v -15.7235 -9.35839 17.0404    0.260239 0.849547 0.458853    1.375 1.9
  v -14.304 -10.3556 16.6172    -0.438238 -0.848783 -0.295828    1.25 2
  v -14.2717 -10.4606 16.8706    -0.39374 -0.900331 -0.185398    1.25 1.9875
  v -14.2318 -10.4889 17.0497    -0.306266 -0.937091 0.167518    1.25 1.975
  v -14.1893 -10.4536 17.1551    -0.0563853 -0.704012 0.707946    1.25 1.9625
  v -14.1488 -10.3682 17.1872    0.245147 -0.100843 0.964227    1.25 1.95
  v -14.115 -10.2458 17.1467    0.383193 0.368297 0.847066    1.25 1.9375
  v -14.0927 -10.0997 17.0341    0.42151 0.603468 0.676872    1.25 1.925
  v -14.0867 -9.94324 16.8498    0.427704 0.737244 0.523011    1.25 1.9125
  v -14.1016 -9.78959 16.5944    0.422076 0.80655 0.41392    1.25 1.9
  v -12.8679 -11.0729 16.2045    -0.59538 -0.763619 -0.249817    1.125 2
  v -12.8522 -11.1696 16.4627    -0.559677 -0.817247 -0.137364    1.125 1.9875
  v -12.8158 -11.1962 16.6428    -0.475631 -0.852717 0.215985    1.125 1.975
  v -12.7659 -11.1646 16.746    -0.178387 -0.645686 0.742474    1.125 1.9625
  v -12.7095 -11.0871 16.7737    0.235888 -0.098764 0.966749    1.125 1.95
  v -12.6539 -10.9756 16.7269    0.458682 0.32995 0.825072    1.125 1.9375
  v -12.6062 -10.8423 16.6069    0.53823 0.545096 0.642789    1.125 1.925
  v -12.5735 -10.6991 16.415    0.567261 0.667538 0.482294    1.125 1.9125
  v -12.563 -10.5581 16.1523    0.573181 0.731181 0.369917    1.125 1.9
  v -11.5526 -12.1069 15.8066    -0.732142 -0.648669 -0.207837    1 2
  v -11.5522 -12.1916 16.0694    -0.705751 -0.702339 -0.0929313    1 1.9875
  v -11.5189 -12.2157 16.2504    -0.624766 -0.735885 0.261037    1 1.975
  v -11.4621 -12.1895 16.3516    -0.286334 -0.563727 0.774741    1 1.9625
  v -11.3913 -12.1234 16.3748    0.227069 -0.0947825 0.969255    1 1.95
  v -11.3157 -12.0276 16.322    0.524894 0.276969 0.804845    1 1.9375
  v -11.2447 -11.9126 16.195    0.640916 0.46414 0.611392    1 1.925
  v -11.1876 -11.7886 15.9957    0.69011 0.570913 0.444753    1 1.9125
  v -11.1538 -11.666 15.726    0.706246 0.626714 0.329312    1 1.9
  v -10.4607 -13.3878 15.4538    -0.844521 -0.507351 -0.171402    0.875 2
  v -10.4729 -13.4577 15.7207    -0.826897 -0.559761 -0.0539373    0.875 1.9875
  v -10.4422 -13.4788 15.9025    -0.748408 -0.590926 0.301151    0.875 1.975
  v -10.3798 -13.4592 16.0019    -0.375795 -0.461252 0.803757    0.875 1.9625
  v -10.2969 -13.4072 16.0212    0.219384 -0.0891989 0.971552    0.875 1.95
  v -10.2047 -13.3309 15.963    0.579313 0.211 0.787322    0.875 1.9375
  v -10.1144 -13.2385 15.8298    0.725731 0.363292 0.584237    0.875 1.925
  v -10.037 -13.1383 15.6239    0.791804 0.450705 0.412203    0.875 1.9125
  v -9.98387 -13.0384 15.348    0.816523 0.496846 0.293997    0.875 1.9
  v -9.66682 -14.815 15.171    -0.927625 -0.345614 -0.141646    0.75 2
  v -9.68818 -14.8684 15.4411    -0.918611 -0.394572 -0.0215928    0.75 1.9875
  v -9.65938 -14.886 15.6237    -0.842119 -0.422862 0.334699    0.75 1.975
  v -9.59291 -14.8738 15.7216    -0.443969 -0.341875 0.828259    0.75 1.9625
  v -9.50127 -14.8375 15.7378    0.212908 -0.0819199 0.973632    0.75 1.95
  v -9.39699 -14.783 15.6753    0.619947 0.134937 0.772954    0.75 1.9375
  v -9.29255 -14.7159 15.537    0.789566 0.246607 0.561935    0.75 1.925
  v -9.20047 -14.6421 15.3259    0.868579 0.311499 0.385406    0.75 1.9125
  v -9.13326 -14.5675 15.0449    0.899934 0.346375 0.264844    0.75 1.9
  v -9.17214 -16.344 14.9608    -0.977975 -0.171066 -0.11959    0.625 2
  v -9.19923 -16.3796 15.2334    -0.976656 -0.214791 0.00281469    0.625 1.9875
  v -9.1716 -16.3937 15.4164    -0.901586 -0.239821 0.360041    0.625 1.975
  v -9.10257 -16.3894 15.5132    -0.487842 -0.21157 0.846905    0.625 1.9625
  v -9.00549 -16.3699 15.5272    0.208008 -0.0734831 0.975363    0.625 1.95
  v -8.89368 -16.3386 15.4615    0.645216 0.0526089 0.762187    0.625 1.9375
  v -8.78048 -16.2986 15.3195    0.829719 0.119943 0.545143    0.625 1.925
  v -8.67922 -16.2533 15.1045    0.917041 0.160201 0.3652    0.625 1.9125
  v -8.60324 -16.2057 14.8198    0.952706 0.182705 0.242839    0.625 1.9
  v -8.9779 -17.9303 14.826    -0.994338 0.00976835 -0.10581    0.5 2
  v -9.00724 -17.9476 15.1001    -0.999451 -0.0274076 0.0185977    0.5 1.9875
  v -8.98006 -17.9579 15.2835    -0.925189 -0.0489275 0.37634    0.5 1.975
  v -8.91004 -17.9618 15.3796    -0.506307 -0.075445 0.859046    0.5 1.9625
  v -8.81081 -17.9598 15.392    0.204827 -0.064322 0.976682    0.5 1.95
  v -8.69605 -17.9526 15.3243    0.654589 -0.0328825 0.75527    0.5 1.9375
  v -8.57941 -17.9408 15.1799    0.84525 -0.0118432 0.53424    0.5 1.925
  v -8.47455 -17.9248 14.9624    0.935971 0.00265358 0.352067    0.5 1.9125
  v -8.39512 -17.9054 14.6753    0.973459 0.0121806 0.228535    0.5 1.9
  v -9.0853 -19.5296 14.7691    -0.976389 0.191121 -0.100686    0.375 2
  v -9.11339 -19.5284 15.0439    -0.986554 0.161461 0.0253318    0.375 1.9875
  v -9.08597 -19.5349 15.2274    -0.91246 0.143564 0.383153    0.375 1.975
  v -9.01649 -19.547 15.3232    -0.49904 0.0621057 0.864351    0.375 1.9625
  v -8.91845 -19.5627 15.335    0.203401 -0.0547673 0.977563    0.375 1.95
  v -8.80532 -19.5798 15.2664    0.64793 -0.118895 0.752363    0.375 1.9375
  v -8.69058 -19.5963 15.121    0.835902 -0.144592 0.529492    0.375 1.925
  v -8.58772 -19.61 14.9024    0.925031 -0.1561 0.346338    0.375 1.9125
  v -8.5102 -19.6189 14.6144    0.961812 -0.159692 0.222298    0.375 1.9
  v -9.49556 -21.0974 14.7929    -0.924323 0.367019 -0.104517    0.25 2
  v -9.5189 -21.078 15.0674    -0.938082 0.345669 0.0227096    0.25 1.9875
  v -9.4905 -21.0808 15.2509    -0.863509 0.331378 0.380184    0.25 1.975
  v -9.42315 -21.101 15.3468    -0.466059 0.196727 0.862605    0.25 1.9625
  v -9.32963 -21.1339 15.3589    0.203741 -0.045073 0.977987    0.25 1.95
  v -9.22274 -21.1749 15.2906    0.625258 -0.20275 0.753621    0.25 1.9375
  v -9.11527 -21.2191 15.1457    0.801725 -0.274119 0.531127    0.25 1.925
  v -9.02001 -21.262 14.9275    0.884297 -0.31099 0.348287    0.25 1.9125
  v -8.94976 -21.2986 14.6399    0.91785 -0.327388 0.224427    0.25 1.9
  v -10.2099 -22.5891 14.9001    -0.839543 0.530446 -0.117454    0.125 2
  v -10.225 -22.5525 15.1733    -0.855246 0.518113 0.0105967    0.125 1.9875
  v -10.1949 -22.5517 15.3565    -0.779535 0.507269 0.367427    0.125 1.975
  v -10.1312 -22.5796 15.453    -0.40802 0.323345 0.853796    0.125 1.9625
  v -10.0455 -22.629 15.4663    0.205882 -0.0354906 0.977933    0.125 1.95
  v -9.94952 -22.6927 15.3997    0.587007 -0.28123 0.759166    0.125 1.9375
  v -9.85471 -22.7633 15.2566    0.743439 -0.395477 0.539349    0.125 1.925
  v -9.77271 -22.8338 15.0405    0.814699 -0.456084 0.358125    0.125 1.9125
  v -9.71511 -22.8969 14.7547    0.842617 -0.484471 0.235126    0.125 1.9
  v -10.7116 -24.6841 13.6983    0.682069 -0.697389 0.22007    2 1.7875
  v -10.6266 -24.9904 12.4439    0.682643 -0.702046 0.202804    2 1.675
  v -10.5637 -25.2734 11.2073    0.683114 -0.709307 0.173892    2 1.5625
  v -10.5339 -25.5216 9.99766    0.682713 -0.71876 0.131478    2 1.45
  v -10.5483 -25.7233 8.8238    0.680067 -0.729516 0.0729132    2 1.3375
  v -10.6178 -25.867 7.69469    0.672833 -0.739777 -0.00512036    2 1.225
  v -10.7535 -25.9409 6.61928    0.657238 -0.746191 -0.106005    2 1.1125
  v -10.9664 -25.9335 5.60654    0.616352 -0.73963 -0.270291    2 1
  v -12.1408 -25.9861 14.002    0.613727 -0.752582 0.238663    1.875 1.7875
  v -12.1369 -26.3662 12.7648    0.613734 -0.757288 0.223261    1.875 1.675
  v -12.1498 -26.7183 11.5444    0.613415 -0.764934 0.196464    1.875 1.5625
  v -12.1879 -27.0284 10.3491    0.612102 -0.775134 0.156519    1.875 1.45
  v -12.2596 -27.2823 9.18745    0.608606 -0.787036 0.100867    1.875 1.3375
  v -12.3734 -27.4663 8.06774    0.600918 -0.79888 0.0262128    1.875 1.225
  v -12.5375 -27.5661 6.99838    0.585819 -0.807328 -0.0709757    1.875 1.1125
  v -12.7605 -27.5679 5.98778    0.550653 -0.804549 -0.222446    1.875 1
  v -13.7269 -26.9404 14.3651    0.463699 -0.842697 0.273579    1.75 1.7875
  v -13.8129 -27.3746 13.1484    0.462591 -0.848073 0.25842    1.75 1.675
  v -13.9099 -27.7772 11.9473    0.460439 -0.856832 0.232021    1.75 1.5625
  v -14.0233 -28.1326 10.7693    0.456635 -0.868555 0.192607    1.75 1.45
  v -14.1587 -28.4249 9.62216    0.450131 -0.8823 0.137579    1.75 1.3375
  v -14.3215 -28.6384 8.51369    0.439236 -0.89612 0.0635622    1.75 1.225
  v -14.5173 -28.7572 7.45157    0.42136 -0.906288 -0.0331385    1.75 1.1125
  v -14.7515 -28.7658 6.44353    0.385067 -0.904238 -0.1846    1.75 1
  v -15.4207 -27.5447 14.7748    0.300927 -0.900686 0.313382    1.625 1.7875
  v -15.6027 -28.0131 13.5814    0.298607 -0.906491 0.298509    1.625 1.675
  v -15.7895 -28.4478 12.4019    0.294461 -0.915967 0.272576    1.625 1.5625
  v -15.9834 -28.8319 11.2434    0.287941 -0.928672 0.23379    1.625 1.45
  v -16.1868 -29.1485 10.1128    0.27816 -0.943612 0.179509    1.625 1.3375
  v -16.402 -29.3807 9.01697    0.263768 -0.958715 0.106265    1.625 1.225
  v -16.6315 -29.5116 7.96301    0.242865 -0.970007 0.0101894    1.625 1.1125
  v -16.8776 -29.5243 6.95786    0.205346 -0.968456 -0.14116    1.625 1
  v -17.1731 -27.797 15.2185    0.131684 -0.925012 0.356387    1.5 1.7875
  v -17.4545 -28.2797 14.0503    0.128103 -0.930989 0.341831    1.5 1.675
  v -17.7342 -28.7278 12.8943    0.12188 -0.940758 0.316418    1.5 1.5625
  v -18.0114 -29.1239 11.7569    0.112534 -0.953867 0.278339    1.5 1.45
  v -18.2851 -29.4506 10.6441    0.0993392 -0.969303 0.224907    1.5 1.3375
  v -18.5546 -29.6906 9.562    0.0813076 -0.984944 0.15256    1.5 1.225
  v -18.819 -29.8265 8.51688    0.0572572 -0.996717 0.0572445    1.5 1.1125
  v -19.0775 -29.8411 7.51485    0.018477 -0.995415 -0.0938464    1.5 1
  v -18.9353 -27.6952 15.6835    -0.0385591 -0.915194 0.401164    1.375 1.7875
  v -19.3166 -28.1722 14.5417    -0.0434055 -0.92108 0.386947    1.375 1.675
  v -19.6897 -28.6149 13.4104    -0.0517118 -0.930707 0.362092    1.375 1.5625
  v -20.0505 -29.0061 12.295    -0.0638932 -0.943631 0.324773    1.375 1.45
  v -20.395 -29.3287 11.2009    -0.0805115 -0.958849 0.272263    1.375 1.3375
  v -20.7191 -29.5655 10.1332    -0.102192 -0.974265 0.200907    1.375 1.225
  v -21.0186 -29.6994 9.09735    -0.129391 -0.985862 0.106463    1.375 1.1125
  v -21.2895 -29.7133 8.0986    -0.16942 -0.984551 -0.0442295    1.375 1
  v -20.658 -27.2372 16.1572    -0.204308 -0.871246 0.446306    1.25 1.7875
  v -21.137 -27.6882 15.0422    -0.210376 -0.876779 0.432436    1.25 1.675
  v -21.6014 -28.1066 13.936    -0.220698 -0.885835 0.408154    1.25 1.5625
  v -22.0441 -28.4761 12.8432    -0.235621 -0.897987 0.371621    1.25 1.45
  v -22.4578 -28.7803 11.768    -0.255549 -0.912277 0.32007    1.25 1.3375
  v -22.8351 -29.0029 10.715    -0.280753 -0.926714 0.249759    1.25 1.225
  v -23.169 -29.1277 9.68859    -0.31099 -0.93748 0.15626    1.25 1.1125
  v -23.452 -29.1383 8.69318    -0.35221 -0.935901 0.00608402    1.25 1
  v -22.2923 -26.4208 16.6268    -0.359155 -0.79416 0.490222    1.125 1.7875
  v -22.8639 -26.8256 15.5384    -0.366354 -0.799094 0.47669    1.125 1.675
  v -23.415 -27.2007 14.4572    -0.378542 -0.807171 0.452969    1.125 1.5625
  v -23.9354 -27.5314 13.3866    -0.396006 -0.817996 0.417206    1.125 1.45
  v -24.4146 -27.8028 12.3303    -0.418998 -0.830688 0.366602    1.125 1.3375
  v -24.8426 -28.0002 11.2918    -0.447464 -0.843429 0.297328    1.125 1.225
  v -25.209 -28.1088 10.2748    -0.48051 -0.852745 0.204783    1.125 1.1125
  v -25.5035 -28.1136 9.28268    -0.522831 -0.850649 0.0551682    1.125 1
  v -23.7892 -25.2441 17.0797    -0.495458 -0.687345 0.531111    1 1.7875
  v -24.4456 -25.5821 16.017    -0.50365 -0.69147 0.517886    1 1.675
  v -25.0761 -25.8949 14.9597    -0.517479 -0.698221 0.494675    1 1.5625
  v -25.6675 -26.1697 13.9107    -0.537178 -0.707246 0.459611    1 1.45
  v -26.2069 -26.3939 12.8726    -0.562869 -0.71777 0.40986    1 1.3375
  v -26.6812 -26.5548 11.8481    -0.594212 -0.728205 0.341512    1 1.225
  v -27.0774 -26.6399 10.8401    -0.629745 -0.735541 0.249801    1 1.1125
  v -27.3825 -26.6365 9.85117    -0.67307 -0.732702 0.10062    1 1
  v -25.0318 -23.7864 17.4812    -0.608165 -0.554658 0.567882    0.875 1.7875
  v -25.7587 -24.0418 16.4412    -0.617193 -0.557797 0.554919    0.875 1.675
  v -26.4551 -24.2772 15.4053    -0.632404 -0.562931 0.532141    0.875 1.5625
  v -27.1055 -24.4827 14.3753    -0.653992 -0.56976 0.497663    0.875 1.45
  v -27.6948 -24.6484 13.3533    -0.681971 -0.577638 0.448609    0.875 1.3375
  v -28.2076 -24.7643 12.3413    -0.715764 -0.585259 0.38099    0.875 1.225
  v -28.6285 -24.8203 11.3412    -0.753435 -0.590176 0.289876    0.875 1.1125
  v -28.9424 -24.8066 10.3552    -0.797683 -0.586405 0.140827    0.875 1
  v -25.9353 -22.1622 17.803    -0.69332 -0.400905 0.598818    0.75 1.7875
  v -26.7135 -22.3255 16.7813    -0.702986 -0.402904 0.586071    0.75 1.675
  v -27.4577 -22.4748 15.7624    -0.719258 -0.406167 0.563646    0.75 1.5625
  v -28.1511 -22.6032 14.7478    -0.742298 -0.410453 0.529644    0.75 1.45
  v -28.7766 -22.7037 13.7387    -0.772042 -0.415263 0.481152    0.75 1.3375
  v -29.3173 -22.7693 12.7366    -0.807735 -0.41962 0.414105    0.75 1.225
  v -29.7563 -22.7929 11.743    -0.847078 -0.421722 0.323433    0.75 1.1125
  v -30.0765 -22.7678 10.7592    -0.89209 -0.416848 0.174395    0.75 1
  v -26.4983 -20.4221 18.0422    -0.747213 -0.233599 0.622177    0.625 1.7875
  v -27.3084 -20.4868 17.0341    -0.757281 -0.234353 0.609594    0.625 1.675
  v -28.0825 -20.5438 16.0279    -0.774225 -0.23557 0.587437    0.625 1.5625
  v -28.8026 -20.5896 15.0245    -0.79819 -0.237073 0.553796    0.625 1.45
  v -29.4507 -20.6202 14.0251    -0.82906 -0.238526 0.505731    0.625 1.3375
  v -30.0088 -20.6319 13.0304    -0.865971 -0.239304 0.439121    0.625 1.225
  v -30.459 -20.6209 12.0415    -0.906394 -0.23832 0.348789    0.625 1.1125
  v -30.7832 -20.5835 11.0594    -0.951926 -0.232223 0.199771    0.625 1
  v -26.7193 -18.6168 18.1957    -0.768479 -0.0592192 0.637128    0.5 1.7875
  v -27.5419 -18.5791 17.1962    -0.778697 -0.0586751 0.62465    0.5 1.675
  v -28.3278 -18.5404 16.1982    -0.795899 -0.0577528 0.602669    0.5 1.5625
  v -29.0584 -18.5004 15.2021    -0.82022 -0.0563459 0.569266    0.5 1.45
  v -29.7154 -18.4585 14.2088    -0.85153 -0.0542855 0.521488    0.5 1.3375
  v -30.2804 -18.4144 13.2189    -0.88892 -0.051319 0.455178    0.5 1.225
  v -30.7349 -18.3674 12.2331    -0.929778 -0.0470999 0.365095    0.5 1.1125
  v -31.0607 -18.3173 11.2521    -0.975552 -0.0397163 0.21615    0.5 1
  v -26.5971 -16.7967 18.2604    -0.756732 0.11659 0.643245    0.375 1.7875
  v -27.4128 -16.6558 17.2646    -0.766843 0.118442 0.630812    0.375 1.675
  v -28.1921 -16.5207 16.27    -0.783878 0.121517 0.608908    0.375 1.5625
  v -28.9169 -16.3942 15.277    -0.807978 0.125855 0.575614    0.375 1.45
  v -29.569 -16.2793 14.2863    -0.839026 0.131456 0.527973    0.375 1.3375
  v -30.1302 -16.1788 13.2984    -0.876142 0.138196 0.461819    0.375 1.225
  v -30.5824 -16.0956 12.3139    -0.916775 0.145677 0.371891    0.375 1.1125
  v -30.9073 -16.0326 11.3333    -0.962502 0.154363 0.223076    0.375 1
  v -26.1302 -15.0126 18.2333    -0.712049 0.288162 0.640272    0.25 1.7875
  v -26.9194 -14.7705 17.236    -0.721801 0.291281 0.627821    0.25 1.675
  v -27.674 -14.5408 16.2399    -0.73825 0.296447 0.605892    0.25 1.5625
  v -28.3766 -14.3295 15.2457    -0.761557 0.303632 0.572572    0.25 1.45
  v -29.01 -14.143 14.2539    -0.791648 0.312669 0.524911    0.25 1.3375
  v -29.5567 -13.9872 13.2651    -0.827745 0.323075 0.458759    0.25 1.225
  v -29.9996 -13.8685 12.2801    -0.8675 0.333723 0.36888    0.25 1.1125
  v -30.3212 -13.7929 11.2993    -0.912896 0.343682 0.220237    0.25 1
  v -25.3173 -13.3149 18.1113    -0.635443 0.448895 0.628255    0.125 1.7875
  v -26.0604 -12.9766 17.1071    -0.644595 0.453193 0.615722    0.125 1.675
  v -26.7719 -12.6568 16.1046    -0.660065 0.460303 0.593663    0.125 1.5625
  v -27.4359 -12.3649 15.1045    -0.68204 0.470135 0.560174    0.125 1.45
  v -28.0366 -12.1102 14.1078    -0.710523 0.482369 0.512325    0.125 1.3375
  v -28.5582 -11.9019 13.1153    -0.744905 0.496184 0.446003    0.125 1.225
  v -28.9848 -11.7494 12.1278    -0.783175 0.50978 0.356036    0.125 1.1125
  v -29.3007 -11.6619 11.1462    -0.827981 0.520932 0.20755    0.125 1
  v -24.1569 -11.7542 17.8915    -0.586083 0.522948 0.618895    0 1.7875
  v -24.8342 -11.3274 16.8748    -0.593863 0.52717 0.607799    0 1.675
  v -25.4842 -10.925 15.8606    -0.607644 0.534543 0.587396    0 1.5625
  v -26.0931 -10.559 14.8501    -0.62763 0.544973 0.555953    0 1.45
  v -26.6472 -10.2416 13.8446    -0.653908 0.558146 0.510763    0 1.3375
  v -27.1329 -9.98499 12.8453    -0.686095 0.573233 0.44797    0 1.225
  v -27.5364 -9.80135 11.8534    -0.722681 0.588413 0.362633    0 1.1125
  v -27.8441 -9.70282 10.8702    -0.765172 0.601328 0.230036    0 1
  v -22.7276 -10.4522 17.5878    -0.400018 0.709102 0.580654    1.875 1.7875
  v -23.3239 -9.95159 16.5539    -0.407406 0.71531 0.567761    1.875 1.675
  v -23.8981 -9.48008 15.5236    -0.419984 0.72558 0.545112    1.875 1.5625
  v -24.4391 -9.05222 14.4987    -0.438034 0.73972 0.510824    1.875 1.45
  v -24.9359 -8.68257 13.4809    -0.461786 0.757165 0.462013    1.875 1.3375
  v -25.3773 -8.38568 12.4722    -0.491137 0.776545 0.394667    1.875 1.225
  v -25.7524 -8.17611 11.4743    -0.525084 0.794971 0.303821    1.875 1.1125
  v -26.05 -8.0684 10.489    -0.568249 0.808129 0.154987    1.875 1
  v -21.1416 -9.49799 17.2247    -0.249715 0.799161 0.546794    1.75 1.7875
  v -21.648 -8.94327 16.1702    -0.255993 0.80604 0.533635    1.75 1.675
  v -22.1381 -8.42116 15.1207    -0.266749 0.817425 0.510549    1.75 1.5625
  v -22.6037 -7.94798 14.0785    -0.282326 0.833091 0.475658    1.75 1.45
  v -23.0368 -7.54002 13.0462    -0.303101 0.852387 0.426107    1.75 1.3375
  v -23.4291 -7.21359 12.0263    -0.329291 0.873752 0.357946    1.75 1.225
  v -23.7726 -6.98501 11.0211    -0.360532 0.893912 0.266342    1.75 1.1125
  v -24.059 -6.87058 10.0332    -0.402689 0.907823 0.117039    1.75 1
  v -19.4478 -8.89368 16.815    -0.0867367 0.857108 0.507782    1.625 1.7875
  v -19.8582 -8.30469 15.7373    -0.0918067 0.864417 0.494322    1.625 1.675
  v -20.2585 -7.75055 14.666    -0.100576 0.87652 0.47074    1.625 1.5625
  v -20.6437 -7.24865 13.6044    -0.113451 0.893172 0.43517    1.625 1.45
  v -21.0087 -6.81643 12.5556    -0.13097 0.913666 0.384787    1.625 1.3375
  v -21.3486 -6.47131 11.523    -0.153698 0.936321 0.315722    1.625 1.225
  v -21.6584 -6.23069 10.5097    -0.181963 0.957616 0.223296    1.625 1.1125
  v -21.9329 -6.11199 9.5189    -0.222983 0.972044 0.0735437    1.625 1
  v -17.6953 -8.64137 16.3713    0.0825794 0.88142 0.465059    1.5 1.7875
  v -18.0063 -8.03808 15.2684    0.0787693 0.888901 0.451277    1.5 1.675
  v -18.3137 -7.47056 14.1736    0.0720742 0.901297 0.427164    1.5 1.5625
  v -18.6157 -6.95668 13.0909    0.062021 0.918354 0.390871    1.5 1.45
  v -18.9104 -6.51433 12.0243    0.0479082 0.939345 0.339611    1.5 1.3375
  v -19.1961 -6.1614 10.978    0.0288084 0.96254 0.269603    1.5 1.225
  v -19.4709 -5.91575 9.95581    0.00367312 0.98432 0.176351    1.5 1.1125
  v -19.733 -5.79528 8.9619    -0.0361134 0.999003 0.0262326    1.5 1
  v -15.9332 -8.74318 15.9062    0.25275 0.871617 0.420002    1.375 1.7875
  v -16.1443 -8.14566 14.777    0.250207 0.879006 0.405889    1.375 1.675
  v -16.3583 -7.58354 13.6575    0.245598 0.89126 0.381231    1.375 1.5625
  v -16.5765 -7.07449 12.5527    0.238386 0.90813 0.344197    1.375 1.45
  v -16.8005 -6.63623 11.4675    0.227705 0.928902 0.292048    1.375 1.3375
  v -17.0316 -6.28644 10.4068    0.212267 0.95187 0.221101    1.375 1.225
  v -17.2713 -6.04283 9.37534    0.190301 0.973469 0.127053    1.375 1.1125
  v -17.521 -5.92307 8.37816    0.151798 0.988136 -0.0233284    1.375 1
  v -14.2105 -9.20119 15.4326    0.418292 0.82771 0.37407    1.25 1.7875
  v -14.3239 -8.62964 14.2765    0.416975 0.834746 0.359627    1.25 1.675
  v -14.4465 -8.0918 13.1319    0.41439 0.846427 0.334427    1.25 1.5625
  v -14.5829 -7.60451 12.0046    0.409935 0.862522 0.296663    1.25 1.45
  v -14.7377 -7.18464 10.9004    0.402586 0.882362 0.243642    1.25 1.3375
  v -14.9155 -6.84903 9.82495    0.390708 0.904343 0.171788    1.25 1.225
  v -15.1209 -6.61454 8.78409    0.371832 0.925101 0.0769989    1.25 1.1125
  v -15.3585 -6.49801 7.78358    0.334614 0.939481 -0.0735424    1.25 1
  v -12.5762 -10.0175 14.963    0.572864 0.75068 0.329099    1.125 1.7875
  v -12.5969 -9.49225 13.7802    0.572684 0.757115 0.314339    1.125 1.675
  v -12.6329 -8.99768 12.6108    0.571976 0.767817 0.28862    1.125 1.5625
  v -12.6917 -8.54918 11.4612    0.570079 0.782581 0.250155    1.125 1.45
  v -12.7809 -8.16208 10.3381    0.565825 0.800816 0.196304    1.125 1.3375
  v -12.9081 -7.85173 9.24812    0.557256 0.821091 0.123592    1.125 1.225
  v -13.0809 -7.6335 8.19791    0.54126 0.840385 0.0281188    1.125 1.1125
  v -13.307 -7.52273 7.19408    0.505263 0.854224 -0.122522    1.125 1
  v -11.0793 -11.1942 14.5101    0.709005 0.643898 0.287588    1 1.7875
  v -11.0152 -10.7357 13.3017    0.709821 0.649523 0.272532    1 1.675
  v -10.9718 -10.3035 12.1082    0.710759 0.658897 0.246325    1 1.5625
  v -10.9595 -9.91091 10.9371    0.711107 0.67186 0.207199    1 1.45
  v -10.9886 -9.57105 9.79582    0.709568 0.687923 0.152558    1 1.3375
  v -11.0695 -9.29713 8.69184    0.703902 0.705888 0.0790199    1 1.225
  v -11.2125 -9.10234 7.63261    0.690432 0.723194 -0.0171376    1 1.1125
  v -11.428 -8.99986 6.62559    0.655504 0.736276 -0.167965    1 1
  v -9.83667 -12.652 14.1086    0.821874 0.511178 0.251436    0.875 1.7875
  v -9.70211 -12.2761 12.8774    0.823521 0.515819 0.236102    0.875 1.675
  v -9.59283 -11.9212 11.6627    0.825835 0.523577 0.209436    0.875 1.5625
  v -9.52148 -11.5978 10.4725    0.82806 0.534346 0.169681    0.875 1.45
  v -9.5007 -11.3165 9.31509    0.82879 0.547767 0.11427    0.875 1.3375
  v -9.54311 -11.0877 8.19869    0.825546 0.562924 0.0398903    0.875 1.225
  v -9.66138 -10.9219 7.13146    0.81417 0.577819 -0.0570305    0.875 1.1125
  v -9.86813 -10.8297 6.1216    0.780087 0.589984 -0.208285    0.875 1
  v -8.93317 -14.2762 13.7867    0.907304 0.35737 0.221555    0.75 1.7875
  v -8.74739 -13.9923 12.5373    0.909584 0.360871 0.205985    0.75 1.675
  v -8.59021 -13.7236 11.3055    0.912948 0.36676 0.178924    0.75 1.5625
  v -8.47594 -13.4774 10.1    0.916606 0.374989 0.138621    0.75 1.45
  v -8.41888 -13.2612 8.92971    0.919072 0.38535 0.0825338    0.75 1.3375
  v -8.43333 -13.0827 7.80334    0.91768 0.397251 0.00740248    0.75 1.225
  v -8.5336 -12.9493 6.7297    0.907906 0.409347 -0.0902292    0.75 1.1125
  v -8.73399 -12.8686 5.71758    0.874467 0.420433 -0.241956    0.75 1
  v -8.3702 -16.0162 13.5476    0.961403 0.190021 0.198987    0.625 1.7875
  v -8.1525 -15.8311 12.2846    0.964081 0.19228 0.183238    0.625 1.675
  v -7.96548 -15.6545 11.0401    0.96811 0.196123 0.15588    0.625 1.5625
  v -7.82447 -15.491 9.82324    0.97268 0.201573 0.115165    0.625 1.45
  v -7.7448 -15.3447 8.64332    0.97625 0.20858 0.0585656    0.625 1.3375
  v -7.74183 -15.2201 7.50955    0.976041 0.21691 -0.0171343    0.625 1.225
  v -7.83088 -15.1213 6.43114    0.967296 0.225929 -0.115303    0.625 1.1125
  v -8.0273 -15.0528 5.41734    0.93429 0.235812 -0.267387    0.625 1
  v -8.14915 -17.8216 13.3941    0.982743 0.0156261 0.184317    0.5 1.7875
  v -7.91891 -17.7388 12.1224    0.985569 0.0165862 0.168457    0.5 1.675
  v -7.72017 -17.658 10.8698    0.989853 0.0182921 0.140914    0.5 1.5625
  v -7.56865 -17.5802 9.64565    0.994775 0.0208321 0.0999438    0.5 1.45
  v -7.48012 -17.5064 8.45957    0.998778 0.0243274 0.0430306    0.5 1.3375
  v -7.4703 -17.4376 7.32104    0.999036 0.0289156 -0.0330141    0.5 1.225
  v -7.55495 -17.3748 6.23958    0.990709 0.0347035 -0.131499    0.5 1.1125
  v -7.74981 -17.3191 5.22469    0.957916 0.0433046 -0.283765    0.5 1
  v -8.27137 -19.6416 13.3294    0.970922 -0.160168 0.177921    0.375 1.7875
  v -8.04807 -19.662 12.054    0.973644 -0.160516 0.162024    0.375 1.675
  v -7.8558 -19.6777 10.798    0.977764 -0.160964 0.134415    0.375 1.5625
  v -7.71009 -19.6864 9.57077    0.982471 -0.161356 0.0933563    0.375 1.45
  v -7.62647 -19.6856 8.38209    0.986219 -0.161403 0.0363391    0.375 1.3375
  v -7.62043 -19.6732 7.24156    0.986218 -0.160592 -0.0398103    0.375 1.225
  v -7.70752 -19.6467 6.15881    0.977684 -0.158069 -0.138375    0.375 1.1125
  v -7.90324 -19.6038 5.14347    0.94488 -0.150778 -0.290634    0.375 1
  v -8.73826 -21.4258 13.3565    0.926034 -0.331697 0.180104    0.25 1.7875
  v -8.54143 -21.5473 12.0827    0.9284 -0.333314 0.164241    0.25 1.675
  v -8.37392 -21.6576 10.828    0.931943 -0.335854 0.136689    0.25 1.5625
  v -8.25039 -21.751 9.60213    0.93587 -0.339096 0.0957112    0.25 1.45
  v -8.18551 -21.8219 8.41454    0.938685 -0.342585 0.0388021    0.25 1.3375
  v -8.19393 -21.8647 7.27485    0.937701 -0.345446 -0.0372125    0.25 1.225
  v -8.29031 -21.8737 6.19264    0.928343 -0.346102 -0.13562    0.25 1.1125
  v -8.48932 -21.8434 5.17748    0.8953 -0.340102 -0.287695    0.25 1
  v -9.5512 -23.1235 13.4784    0.849153 -0.492375 0.191065    0.125 1.7875
  v -9.40046 -23.3413 12.2115    0.850925 -0.495171 0.175307    0.125 1.675
  v -9.27605 -23.5416 10.9634    0.853499 -0.499658 0.147926    0.125 1.5625
  v -9.19114 -23.7156 9.74325    0.856113 -0.50555 0.107188    0.125 1.45
  v -9.15889 -23.8547 8.56056    0.857351 -0.512242 0.0505818    0.125 1.3375
  v -9.19247 -23.95 7.42464    0.854697 -0.518521 -0.0250818    0.125 1.225
  v -9.30505 -23.9929 6.34486    0.843924 -0.522139 -0.123134    0.125 1.1125
  v -9.50979 -23.9745 5.33057    0.810413 -0.517357 -0.274905    0.125 1
  v -11.2965 -25.7976 4.71668    0.530696 -0.695535 -0.484348    2 0.925
  v -11.7444 -25.5253 3.9903    0.424064 -0.619578 -0.660525    2 0.85
  v -12.262 -25.1638 3.40686    0.329616 -0.542124 -0.772952    2 0.775
  v -12.801 -24.7604 2.94587    0.259856 -0.480614 -0.837547    2 0.7
  v -13.3135 -24.3625 2.58679    0.220648 -0.444697 -0.868078    2 0.625
  v -13.7513 -24.0172 2.30912    0.226626 -0.450231 -0.863674    2 0.55
  v -14.0663 -23.7719 2.09233    0.356624 -0.565023 -0.744022    2 0.475
  v -14.2104 -23.6739 1.91592    0.412508 -0.610523 -0.676091    2 0.4
  v -13.0714 -27.4145 5.09383    0.476066 -0.765362 -0.433108    1.875 0.925
  v -13.4685 -27.0959 4.35665    0.375726 -0.686214 -0.622848    1.875 0.85
  v -13.9142 -26.6689 3.75795    0.284748 -0.601066 -0.746752    1.875 0.775
  v -14.3709 -26.1906 3.27946    0.21609 -0.53113 -0.819272    1.875 0.7
  v -14.8011 -25.7176 2.90288    0.174895 -0.487566 -0.85539    1.875 0.625
  v -15.167 -25.3069 2.60994    0.171732 -0.485546 -0.857178    1.875 0.55
  v -15.4312 -25.0153 2.38236    0.265165 -0.587932 -0.764214    1.875 0.475
  v -15.556 -24.8997 2.20185    0.369107 -0.645597 -0.668554    1.875 0.4
  v -15.0409 -28.5994 5.54468    0.316019 -0.861764 -0.396857    1.75 0.925
  v -15.3816 -28.2469 4.79459    0.229546 -0.774111 -0.589967    1.75 0.85
  v -15.7476 -27.772 4.17764    0.154431 -0.679201 -0.717521    1.75 0.775
  v -16.113 -27.2387 3.67823    0.0991621 -0.60103 -0.793051    1.75 0.7
  v -16.4518 -26.7107 3.28074    0.0664275 -0.552215 -0.831051    1.75 0.625
  v -16.738 -26.2521 2.96956    0.0636813 -0.549717 -0.83292    1.75 0.55
  v -16.9458 -25.9266 2.72907    0.137451 -0.663442 -0.735494    1.75 0.475
  v -17.0492 -25.7981 2.54366    0.2299 -0.735245 -0.637621    1.75 0.4
  v -17.1443 -29.3499 6.05348    0.142333 -0.92392 -0.355123    1.625 0.925
  v -17.4248 -28.9758 5.28883    0.0709901 -0.830785 -0.552048    1.625 0.85
  v -17.7056 -28.4706 4.65129    0.0131691 -0.729548 -0.683803    1.625 0.775
  v -17.9734 -27.9024 4.12827    -0.0275174 -0.646023 -0.762822    1.625 0.7
  v -18.2146 -27.3397 3.70717    -0.0510332 -0.593775 -0.803011    1.625 0.625
  v -18.4157 -26.8506 3.37539    -0.0532802 -0.590896 -0.804986    1.625 0.55
  v -18.5633 -26.5036 3.12034    -0.000773262 -0.71174 -0.702443    1.625 0.475
  v -18.6438 -26.367 2.9294    0.0777106 -0.795005 -0.601605    1.625 0.4
  v -19.3205 -29.6632 6.6045    -0.0382276 -0.95013 -0.309501    1.5 0.925
  v -19.5387 -29.2802 5.82407    -0.0937717 -0.854755 -0.510491    1.5 0.85
  v -19.7315 -28.7622 5.16423    -0.133555 -0.750855 -0.646823    1.5 0.775
  v -19.8983 -28.1795 4.61564    -0.159044 -0.665041 -0.729675    1.5 0.7
  v -20.0385 -27.6022 4.16898    -0.17295 -0.611288 -0.772279    1.5 0.625
  v -20.1515 -27.1005 3.8149    -0.174644 -0.608137 -0.774383    1.5 0.55
  v -20.2368 -26.7446 3.54407    -0.144176 -0.731655 -0.666254    1.5 0.475
  v -20.2937 -26.6046 3.34715    -0.081314 -0.823233 -0.56185    1.5 0.4
  v -21.5087 -29.5368 7.18197    -0.21977 -0.939854 -0.261486    1.375 0.925
  v -21.6643 -29.1574 6.38501    -0.259414 -0.845551 -0.466635    1.375 0.85
  v -21.7685 -28.6446 5.7018    -0.281049 -0.742728 -0.607756    1.375 0.775
  v -21.8338 -28.0677 5.12642    -0.291249 -0.657747 -0.694653    1.375 0.7
  v -21.8724 -27.4963 4.65297    -0.29548 -0.604451 -0.739818    1.375 0.625
  v -21.8969 -26.9997 4.27551    -0.296588 -0.601144 -0.742066    1.375 0.55
  v -21.9195 -26.6474 3.98815    -0.288189 -0.722825 -0.628069    1.375 0.475
  v -21.9527 -26.5087 3.78496    -0.241948 -0.819409 -0.519644    1.375 0.4
  v -23.648 -28.968 7.77017    -0.396398 -0.893115 -0.212638    1.25 0.925
  v -23.7423 -28.6049 6.95637    -0.420617 -0.803172 -0.421895    1.25 0.85
  v -23.76 -28.1151 6.24935    -0.424633 -0.705149 -0.567849    1.25 0.775
  v -23.726 -27.5647 5.64668    -0.419974 -0.624113 -0.658866    1.25 0.7
  v -23.6654 -27.0196 5.14593    -0.414787 -0.573235 -0.70665    1.25 0.625
  v -23.6033 -26.546 4.74467    -0.415293 -0.569888 -0.709055    1.25 0.55
  v -23.5647 -26.21 4.44047    -0.428234 -0.685248 -0.58911    1.25 0.475
  v -23.5746 -26.0775 4.2309    -0.39914 -0.783461 -0.476315    1.25 0.4
  v -25.6775 -27.9543 8.35333    -0.561322 -0.811007 -0.164881    1.125 0.925
  v -25.7137 -27.6202 7.52284    -0.571226 -0.728537 -0.378066    1.125 0.85
  v -25.6492 -27.1714 6.79221    -0.558852 -0.638867 -0.528708    1.125 0.775
  v -25.5211 -26.668 6.16249    -0.540343 -0.564769 -0.623751    1.125 0.7
  v -25.3663 -26.17 5.63469    -0.526358 -0.518201 -0.674104    1.125 0.625
  v -25.2221 -25.7375 5.20982    -0.526262 -0.514939 -0.676673    1.125 0.55
  v -25.1254 -25.4304 4.88893    -0.558959 -0.619694 -0.550948    1.125 0.475
  v -25.1132 -25.309 4.67302    -0.547118 -0.716046 -0.433521    1.125 0.4
  v -27.5363 -26.493 8.91572    -0.706618 -0.697217 -0.120749    1 0.925
  v -27.5193 -26.2008 8.06912    -0.703966 -0.62486 -0.337611    1 0.85
  v -27.3795 -25.8111 7.31574    -0.677169 -0.546619 -0.492595    1 0.775
  v -27.1652 -25.3755 6.65992    -0.646448 -0.482086 -0.591352    1 0.7
  v -26.9242 -24.9453 6.10602    -0.624684 -0.441512 -0.644078    1 0.625
  v -26.7047 -24.5719 5.6584    -0.624005 -0.438462 -0.646814    1 0.55
  v -26.5548 -24.3067 5.3214    -0.673956 -0.528915 -0.515784    1 0.475
  v -26.5225 -24.2011 5.09939    -0.678994 -0.619748 -0.393548    1 0.4
  v -29.0794 -24.6828 9.41428    -0.827176 -0.55592 -0.0820592    0.875 0.925
  v -29.0182 -24.4424 8.55342    -0.814036 -0.495874 -0.302413    0.875 0.85
  v -28.816 -24.126 7.77985    -0.775168 -0.431648 -0.461296    0.875 0.775
  v -28.53 -23.7744 7.10091    -0.734236 -0.378914 -0.563313    0.875 0.7
  v -28.2175 -23.4282 6.52388    -0.705967 -0.345773 -0.618103    0.875 0.625
  v -27.9355 -23.128 6.05607    -0.70477 -0.343032 -0.62099    0.875 0.55
  v -27.7414 -22.9147 5.7048    -0.76904 -0.415973 -0.485329    0.875 0.475
  v -27.6924 -22.8287 5.47738    -0.789209 -0.498541 -0.358618    0.875 0.4
  v -30.2014 -22.6659 9.81397    -0.918567 -0.392102 -0.0499071    0.75 0.925
  v -30.1081 -22.4832 8.94166    -0.897432 -0.346296 -0.273306    0.75 0.85
  v -29.8605 -22.2485 8.15192    -0.849326 -0.298318 -0.43549    0.75 0.775
  v -29.5224 -21.9904 7.45443    -0.800577 -0.259284 -0.54023    0.75 0.7
  v -29.1578 -21.7378 6.85885    -0.76732 -0.234795 -0.596734    0.75 0.625
  v -28.8304 -21.5193 6.37487    -0.765664 -0.232477 -0.59976    0.75 0.55
  v -28.6042 -21.3636 6.01216    -0.840679 -0.285288 -0.460294    0.75 0.475
  v -28.543 -21.2996 5.7804    -0.874404 -0.35619 -0.329463    0.75 0.4
  v -30.9005 -20.5051 10.111    -0.976558 -0.213727 -0.0255866    0.625 0.925
  v -30.7871 -20.3843 9.23018    -0.950359 -0.183496 -0.251292    0.625 0.85
  v -30.5112 -20.237 8.42842    -0.89636 -0.153288 -0.415983    0.625 0.775
  v -30.1408 -20.0792 7.71714    -0.84261 -0.129226 -0.52279    0.625 0.7
  v -29.7437 -19.9268 7.10779    -0.80614 -0.114199 -0.580601    0.625 0.625
  v -29.3881 -19.7957 6.61179    -0.80412 -0.112391 -0.583746    0.625 0.55
  v -29.1418 -19.702 6.24057    -0.885763 -0.143362 -0.441442    0.625 0.475
  v -29.073 -19.6614 6.00558    -0.93043 -0.200018 -0.307073    0.625 0.4
  v -31.175 -18.2632 10.3016    -0.999567 -0.0277383 -0.00979915    0.5 0.925
  v -31.0538 -18.2065 9.4153    -0.971427 -0.0137954 -0.236937    0.5 0.85
  v -30.7668 -18.15 8.60582    -0.915093 -0.00217156 -0.403238    0.5 0.775
  v -30.3836 -18.0962 7.88571    -0.859325 0.00623778 -0.511391    0.5 0.7
  v -29.9738 -18.0479 7.26751    -0.821521 0.0113694 -0.570064    0.5 0.625
  v -29.607 -18.0075 6.7638    -0.819245 0.0126101 -0.573305    0.5 0.55
  v -29.3529 -17.9779 6.38713    -0.903192 0.00434495 -0.429214    0.5 0.475
  v -29.2811 -17.9617 6.15006    -0.955727 -0.0363131 -0.292006    0.5 0.4
  v -31.0232 -16.003 10.3819    -0.987146 0.159792 -0.00297028    0.375 0.925
  v -30.9064 -16.0111 9.49335    -0.960244 0.157319 -0.230611    0.375 0.85
  v -30.6255 -16.046 8.68062    -0.905196 0.150199 -0.397569    0.375 0.775
  v -30.2493 -16.0971 7.95678    -0.850444 0.142814 -0.50631    0.375 0.7
  v -29.8466 -16.1536 7.33485    -0.813217 0.137952 -0.565374    0.375 0.625
  v -29.486 -16.2048 6.82789    -0.810796 0.13859 -0.568685    0.375 0.55
  v -29.2362 -16.2399 6.44892    -0.892664 0.15313 -0.423914    0.375 0.475
  v -29.166 -16.2482 6.21098    -0.949842 0.12955 -0.284636    0.375 0.4
  v -30.4434 -13.7875 10.3483    -0.939402 0.342775 -0.00541589    0.25 0.925
  v -30.3432 -13.859 9.46066    -0.916889 0.324354 -0.232613    0.25 0.85
  v -30.0858 -13.9836 8.64929    -0.866722 0.298988 -0.399247    0.25 0.775
  v -29.7365 -14.1374 7.92701    -0.816003 0.276207 -0.507789    0.25 0.7
  v -29.3606 -14.2967 7.30665    -0.781254 0.261585 -0.566759    0.25 0.625
  v -29.0235 -14.4376 6.80104    -0.778804 0.261603 -0.570112    0.25 0.55
  v -28.7903 -14.5361 6.42304    -0.854246 0.298261 -0.425798    0.25 0.475
  v -28.7265 -14.5685 6.18547    -0.912778 0.292354 -0.285247    0.25 0.4
  v -29.4339 -11.6793 10.1968    -0.857515 0.514168 -0.017299    0.125 0.925
  v -29.3626 -11.8111 9.31355    -0.842376 0.480913 -0.243157    0.125 0.85
  v -29.146 -12.0211 8.50832    -0.800515 0.438526 -0.408498    0.125 0.775
  v -28.8436 -12.2727 7.79306    -0.756716 0.401349 -0.516043    0.125 0.7
  v -28.5146 -12.5298 7.17973    -0.726275 0.377579 -0.574421    0.125 0.625
  v -28.2183 -12.756 6.68025    -0.723916 0.376974 -0.577785    0.125 0.55
  v -28.014 -12.9149 6.30658    -0.788799 0.434178 -0.43507    0.125 0.475
  v -27.9611 -12.9702 6.07065    -0.845285 0.446107 -0.294076    0.125 0.4
  v -27.993 -9.74128 9.92382    -0.801265 0.598082 0.0165003    0 0.925
  v -27.9629 -9.9286 9.04836    -0.79776 0.562586 -0.216971    0 0.85
  v -27.8047 -10.217 8.25418    -0.763968 0.512867 -0.391562    0 0.775
  v -27.5691 -10.5586 7.55159    -0.724326 0.467116 -0.507104    0 0.7
  v -27.3069 -10.9056 6.95092    -0.694398 0.435615 -0.572758    0 0.625
  v -27.0689 -11.2102 6.46249    -0.687224 0.42831 -0.586748    0 0.55
  v -26.9059 -11.4246 6.09664    -0.733526 0.477219 -0.483944    0 0.475
  v -26.8687 -11.5009 5.86368    -0.784766 0.54085 -0.302695    0 0.4
  v -26.2181 -8.12441 9.54667    -0.606778 0.791956 -0.068018    1.875 0.925
  v -26.2388 -8.35803 8.68201    -0.613669 0.734624 -0.289376    1.875 0.85
  v -26.1524 -8.71184 7.90309    -0.596813 0.664556 -0.449644    1.875 0.775
  v -25.9992 -9.12847 7.218    -0.574015 0.603952 -0.552945    1.875 0.7
  v -25.8194 -9.5505 6.63483    -0.556777 0.565261 -0.608671    1.875 0.625
  v -25.6533 -9.92054 6.16167    -0.554938 0.56351 -0.611964    1.875 0.55
  v -25.5411 -10.1812 5.80661    -0.588565 0.653729 -0.475636    1.875 0.475
  v -25.5231 -10.2751 5.57774    -0.631207 0.698923 -0.336281    1.875 0.4
  v -24.2485 -6.93946 9.09582    -0.446916 0.888395 -0.104978    1.75 0.925
  v -24.3257 -7.20699 8.24407    -0.467773 0.822579 -0.323347    1.75 0.85
  v -24.319 -7.60877 7.4834    -0.466795 0.742753 -0.480021    1.75 0.775
  v -24.2571 -8.08037 6.81922    -0.457365 0.673908 -0.580229    1.75 0.7
  v -24.1687 -8.55738 6.25697    -0.448564 0.629962 -0.633986    1.75 0.625
  v -24.0823 -8.97539 5.80206    -0.447142 0.627733 -0.637194    1.75 0.55
  v -24.0265 -9.26997 5.45991    -0.461136 0.729298 -0.505449    1.75 0.475
  v -24.0299 -9.37671 5.23594    -0.492301 0.788632 -0.368374    1.75 0.4
  v -22.1452 -6.18902 8.58702    -0.273363 0.950579 -0.147218    1.625 0.925
  v -22.2825 -6.47804 7.74983    -0.309426 0.879296 -0.36207    1.625 0.85
  v -22.361 -6.91019 7.00975    -0.325756 0.793144 -0.514592    1.625 0.775
  v -22.3967 -7.41661 6.36918    -0.330893 0.718942 -0.611254    1.625 0.7
  v -22.4059 -7.92844 5.83054    -0.331294 0.671561 -0.662759    1.625 0.625
  v -22.4046 -8.37681 5.39622    -0.33037 0.66895 -0.665854    1.625 0.55
  v -22.409 -8.69288 5.06863    -0.323125 0.777639 -0.539322    1.625 0.475
  v -22.4352 -8.80777 4.85019    -0.34036 0.848442 -0.405341    1.625 0.4
  v -19.969 -5.87571 8.036    -0.092843 0.976797 -0.192998    1.5 0.925
  v -20.1686 -6.1737 7.21459    -0.144736 0.90328 -0.403902    1.5 0.85
  v -20.3351 -6.61853 6.49681    -0.17911 0.814467 -0.551872    1.5 0.775
  v -20.4719 -7.13948 5.88181    -0.199439 0.737976 -0.644682    1.5 0.7
  v -20.582 -7.66585 5.36873    -0.209445 0.689088 -0.693751    1.5 0.625
  v -20.6688 -8.12691 4.95671    -0.209073 0.686205 -0.696714    1.5 0.55
  v -20.7355 -8.45194 4.6449    -0.179801 0.79757 -0.575807    1.5 0.475
  v -20.7853 -8.57023 4.43244    -0.181445 0.876693 -0.445518    1.5 0.4
  v -17.7808 -6.00213 7.45853    0.0887565 0.966509 -0.240795    1.375 0.925
  v -18.043 -6.2965 6.65365    0.020985 0.89406 -0.447455    1.375 0.85
  v -18.2981 -6.73621 5.95924    -0.0315355 0.806324 -0.590633    1.375 0.775
  v -18.5364 -7.2513 5.37103    -0.067161 0.730667 -0.679423    1.375 0.7
  v -18.748 -7.7718 4.88474    -0.0868479 0.682238 -0.725954    1.375 0.625
  v -18.9234 -8.22774 4.4961    -0.0870618 0.679198 -0.728773    1.375 0.55
  v -19.0527 -8.54916 4.20082    -0.0357129 0.788724 -0.613709    1.375 0.475
  v -19.1264 -8.66607 3.99463    -0.0207605 0.87286 -0.48753    1.375 0.4
  v -15.6415 -6.57089 6.87033    0.265529 0.91974 -0.289088    1.25 0.925
  v -15.965 -6.84898 6.08229    0.182405 0.851638 -0.491368    1.25 0.85
  v -16.3067 -7.26567 5.41169    0.112273 0.768699 -0.629679    1.25 0.775
  v -16.6442 -7.75437 4.85078    0.0617709 0.696991 -0.714415    1.25 0.7
  v -16.9551 -8.24849 4.39178    0.0326497 0.650982 -0.758391    1.25 0.625
  v -17.217 -8.68141 4.02694    0.0318337 0.647904 -0.761056    1.25 0.55
  v -17.4076 -8.98654 3.7485    0.104544 0.751103 -0.651855    1.25 0.475
  v -17.5045 -9.09728 3.54869    0.136636 0.836869 -0.530076    1.25 0.4
  v -13.612 -7.5846 6.28717    0.430638 0.837595 -0.336134    1.125 0.925
  v -13.9936 -7.83367 5.51582    0.333297 0.776945 -0.534106    1.125 0.85
  v -14.4174 -8.20933 4.86883    0.246791 0.702357 -0.667674    1.125 0.775
  v -14.8491 -8.651 4.33497    0.182417 0.63759 -0.748467    1.125 0.7
  v -15.2541 -9.09808 3.90303    0.144475 0.595896 -0.789959    1.125 0.625
  v -15.5982 -9.48997 3.56179    0.143056 0.592903 -0.792465    1.125 0.55
  v -15.8469 -9.76608 3.30004    0.235555 0.685492 -0.688923    1.125 0.475
  v -15.9658 -9.86582 3.10657    0.284914 0.769392 -0.571717    1.125 0.4
  v -11.7532 -9.04587 5.72478    0.576029 0.723785 -0.379902    1 0.925
  v -12.188 -9.2531 4.96954    0.466198 0.673235 -0.573946    1 0.85
  v -12.6871 -9.56962 4.3453    0.365282 0.610074 -0.703121    1 0.775
  v -13.205 -9.9435 3.83754    0.288686 0.554874 -0.780241    1 0.7
  v -13.6963 -10.3228 3.43169    0.242952 0.519176 -0.819408    1 0.625
  v -14.1156 -10.6555 3.11321    0.240948 0.516396 -0.821754    1 0.55
  v -14.4175 -10.8898 2.86757    0.350722 0.594678 -0.723431    1 0.475
  v -14.5566 -10.9737 2.6802    0.417017 0.673048 -0.610822    1 0.4
  v -10.2101 -10.8561 5.22622    0.696463 0.582513 -0.419067    0.875 0.925
  v -10.6891 -11.0115 4.48524    0.576094 0.544284 -0.609812    0.875 0.85
  v -11.2506 -11.2547 3.88119    0.463103 0.495139 -0.735101    0.875 0.775
  v -11.8401 -11.5446 3.39655    0.37631 0.451735 -0.808904    0.875 0.7
  v -12.403 -11.8399 3.01384    0.324086 0.423468 -0.845957    0.875 0.625
  v -12.8848 -12.0994 2.71554    0.321563 0.420996 -0.84815    0.875 0.55
  v -13.2308 -12.2819 2.48417    0.445641 0.481769 -0.754522    0.875 0.475
  v -13.3867 -12.3461 2.30222    0.527109 0.551865 -0.646221    0.875 0.4
  v -9.0881 -12.873 4.82653    0.78767 0.418733 -0.451928    0.75 0.925
  v -9.59923 -12.9707 4.097    0.659205 0.394764 -0.640008    0.75 0.85
  v -10.2062 -13.1323 3.50912    0.536962 0.36187 -0.762051    0.75 0.775
  v -10.8477 -13.3286 3.04303    0.442374 0.332161 -0.833051    0.75 0.7
  v -11.4627 -13.5303 2.67886    0.385183 0.312541 -0.868304    0.75 0.625
  v -11.9899 -13.7082 2.39674    0.382204 0.310493 -0.870353    0.75 0.55
  v -12.3681 -13.8329 2.17681    0.516995 0.351143 -0.78065    0.75 0.475
  v -12.5361 -13.8752 1.9992    0.612003 0.409577 -0.676534    0.75 0.4
  v -8.38901 -15.0338 4.52951    0.845529 0.240386 -0.476756    0.625 0.925
  v -8.92015 -15.0696 3.80848    0.711923 0.232006 -0.662827    0.625 0.85
  v -9.55537 -15.1438 3.23263    0.583774 0.216884 -0.782413    0.625 0.775
  v -10.2294 -15.2398 2.78031    0.484199 0.202146 -0.851286    0.625 0.7
  v -10.8768 -15.3413 2.42992    0.423812 0.191984 -0.88517    0.625 0.625
  v -11.4322 -15.4317 2.15983    0.420469 0.190446 -0.887094    0.625 0.55
  v -11.8304 -15.4946 1.9484    0.561865 0.20926 -0.800324    0.625 0.475
  v -12.0061 -15.5134 1.77401    0.66778 0.253455 -0.699879    0.625 0.4
  v -8.1145 -17.2757 4.33893    0.868496 0.0544052 -0.492701    0.5 0.925
  v -8.65349 -17.2473 3.62336    0.732919 0.0623207 -0.677455    0.5 0.85
  v -9.29983 -17.2308 3.05522    0.602428 0.0657841 -0.795457    0.5 0.775
  v -9.98655 -17.2228 2.61175    0.500842 0.0666968 -0.862965    0.5 0.7
  v -10.6467 -17.2202 2.2702    0.439126 0.0664301 -0.895966    0.5 0.625
  v -11.2133 -17.2199 2.00782    0.435528 0.0654583 -0.897792    0.5 0.55
  v -11.6193 -17.2186 1.80185    0.579217 0.0615689 -0.812845    0.5 0.475
  v -11.7979 -17.2131 1.62953    0.692968 0.0897721 -0.715358    0.5 0.4
  v -8.26628 -19.5358 4.25858    0.856133 -0.133137 -0.499311    0.375 0.925
  v -8.80093 -19.4428 3.54531    0.721816 -0.10881 -0.683478    0.375 0.85
  v -9.44112 -19.3347 2.98042    0.592611 -0.0866027 -0.800819    0.375 0.775
  v -10.1208 -19.2219 2.54068    0.492033 -0.0698947 -0.867766    0.375 0.7
  v -10.7739 -19.1145 2.20286    0.430888 -0.0601658 -0.900397    0.375 0.625
  v -11.3343 -19.0227 1.94373    0.427146 -0.0605354 -0.902154    0.375 0.55
  v -11.7361 -18.9566 1.74005    0.568762 -0.0872315 -0.817863    0.375 0.475
  v -11.913 -18.9266 1.56861    0.687135 -0.076101 -0.722533    0.375 0.4
  v -8.84607 -21.7514 4.29224    0.808533 -0.31615 -0.49631    0.25 0.925
  v -9.36412 -21.5949 3.578    0.678676 -0.275889 -0.680649    0.25 0.85
  v -9.98085 -21.3972 3.01175    0.554362 -0.235437 -0.798281    0.25 0.775
  v -10.6336 -21.1816 2.57045    0.4578 -0.203329 -0.865492    0.25 0.7
  v -11.2598 -20.9714 2.23106    0.399116 -0.183838 -0.898282    0.25 0.625
  v -11.7968 -20.7899 1.97057    0.395345 -0.183587 -0.899999    0.25 0.55
  v -12.1819 -20.6604 1.76593    0.530557 -0.232406 -0.815167    0.25 0.475
  v -12.3526 -20.6063 1.59413    0.650275 -0.238947 -0.721143    0.25 0.4
  v -9.85557 -23.8596 4.44368    0.726831 -0.48758 -0.483717    0.125 0.925
  v -10.3447 -23.6428 3.72511    0.604448 -0.432506 -0.669015    0.125 0.85
  v -10.9206 -23.3597 3.15272    0.488454 -0.375036 -0.787884    0.125 0.775
  v -11.5265 -23.0463 2.70439    0.39879 -0.328527 -0.856175    0.125 0.7
  v -12.1059 -22.7383 2.35799    0.344393 -0.299883 -0.889642    0.125 0.625
  v -12.602 -22.4714 2.09136    0.34071 -0.299009 -0.891353    0.125 0.55
  v -12.9582 -22.2816 1.88239    0.465395 -0.36838 -0.8048    0.125 0.475
  v -13.1179 -22.2046 1.70894    0.583083 -0.392762 -0.711162    0.125 0.4
  v -14.278 -23.6409 1.7616    0.378653 -0.583278 -0.718616    2 0.35
  v -14.4371 -23.5191 1.64129    0.0871179 -0.316002 -0.94475    2 0.3
  v -14.7492 -23.2479 1.57975    -0.0849532 -0.136955 -0.986928    2 0.25
  v -15.2761 -22.7672 1.60173    -0.16491 -0.0487589 -0.985103    2 0.2
  v -16.0796 -22.0166 1.732    -0.205596 -0.002587 -0.978633    2 0.15
  v -17.2213 -20.9356 1.99531    -0.228867 0.0242347 -0.973156    2 0.1
  v -18.763 -19.4639 2.41642    -0.241367 0.0387723 -0.969659    2 0.05
  v -20.7664 -17.5412 3.02008    -0.252061 0.0512822 -0.966352    1.875 0
  v -15.6182 -24.8618 2.04638    0.370681 -0.677572 -0.63521    1.875 0.35
  v -15.7522 -24.7171 1.92074    0.0944557 -0.389181 -0.916306    1.875 0.3
  v -16.0061 -24.393 1.84683    -0.0841026 -0.173546 -0.981228    1.875 0.25
  v -16.4283 -23.8168 1.84656    -0.165627 -0.0674113 -0.983882    1.875 0.2
  v -17.0671 -22.9162 1.94184    -0.205963 -0.0127895 -0.978476    1.875 0.15
  v -17.9709 -21.6184 2.15458    -0.228537 0.0184763 -0.97336    1.875 0.1
  v -19.1879 -19.8509 2.50669    -0.241187 0.0365641 -0.96979    1.875 0.05
  v -17.1055 -25.7566 2.38682    0.226072 -0.765319 -0.602643    1.75 0.35
  v -17.2116 -25.5951 2.25481    0.00519998 -0.443473 -0.896273    1.75 0.3
  v -17.4009 -25.2321 2.16611    -0.130129 -0.201427 -0.970821    1.75 0.25
  v -17.7069 -24.5861 2.13923    -0.190027 -0.0821618 -0.978335    1.75 0.2
  v -18.163 -23.5755 2.19269    -0.219163 -0.0207726 -0.975467    1.75 0.15
  v -18.8027 -22.1188 2.34498    -0.235307 0.0143651 -0.971815    1.75 0.1
  v -19.6593 -20.1346 2.61461    -0.244236 0.0346444 -0.969097    1.75 0.05
  v -18.6937 -26.3233 2.77103    0.0690508 -0.822156 -0.565059    1.625 0.35
  v -18.7701 -26.1512 2.63181    -0.0916672 -0.478745 -0.873155    1.625 0.3
  v -18.8904 -25.7635 2.52643    -0.180038 -0.219512 -0.958854    1.625 0.25
  v -19.0723 -25.0732 2.46953    -0.216479 -0.0917205 -0.971969    1.625 0.2
  v -19.3333 -23.993 2.47579    -0.233473 -0.025947 -0.972017    1.625 0.15
  v -19.6909 -22.4357 2.55985    -0.242648 0.0116953 -0.970044    1.625 0.1
  v -20.1628 -20.3142 2.7364    -0.247557 0.0333764 -0.968298    1.625 0.05
  v -20.337 -26.5599 3.1871    -0.0942525 -0.846569 -0.523868    1.5 0.35
  v -20.3826 -26.3833 3.0401    -0.192373 -0.494176 -0.847811    1.5 0.3
  v -20.4315 -25.9854 2.91664    -0.231898 -0.227423 -0.945781    1.5 0.25
  v -20.485 -25.2766 2.82723    -0.243959 -0.0958925 -0.965033    1.5 0.2
  v -20.5441 -24.1673 2.78237    -0.248341 -0.0282076 -0.968262    1.5 0.15
  v -20.61 -22.5681 2.79255    -0.250279 0.0105207 -0.968117    1.5 0.1
  v -20.6837 -20.3892 2.86829    -0.251018 0.0327871 -0.967427    1.5 0.05
  v -21.9893 -26.4644 3.62316    -0.258543 -0.838069 -0.480413    1.375 0.35
  v -22.004 -26.2896 3.46799    -0.29374 -0.489512 -0.821033    1.375 0.3
  v -21.9812 -25.8959 3.32559    -0.284101 -0.225041 -0.93201    1.375 0.25
  v -21.9055 -25.1945 3.2021    -0.271623 -0.0946179 -0.957741    1.375 0.2
  v -21.7616 -24.097 3.10367    -0.263309 -0.0275221 -0.964319    1.375 0.15
  v -21.5341 -22.5147 3.03643    -0.257964 0.0108583 -0.966094    1.375 0.1
  v -21.2075 -20.3589 3.00652    -0.254512 0.0328843 -0.966511    1.375 0.05
  v -23.6047 -26.0349 4.06731    -0.418544 -0.796645 -0.436094    1.25 0.35
  v -23.5891 -25.8682 3.90382    -0.39263 -0.464709 -0.793654    1.25 0.3
  v -23.4961 -25.4931 3.74213    -0.335063 -0.212338 -0.917957    1.25 0.25
  v -23.2943 -24.8253 3.58394    -0.298633 -0.0878802 -0.950314    1.25 0.2
  v -22.9519 -23.7805 3.43093    -0.277926 -0.0238817 -0.960306    1.25 0.15
  v -22.4375 -22.2745 3.28483    -0.26547 0.0127128 -0.964035    1.25 0.1
  v -21.7195 -20.2228 3.14731    -0.257934 0.0336707 -0.965576    1.25 0.05
  v -25.1372 -25.2695 4.50766    -0.56816 -0.723189 -0.392673    1.125 0.35
  v -25.0929 -25.1171 4.33593    -0.48535 -0.420174 -0.76674    1.125 0.3
  v -24.9334 -24.7752 4.15511    -0.382892 -0.189487 -0.904151    1.125 0.25
  v -24.6117 -24.1673 3.9625    -0.323987 -0.0757685 -0.943023    1.125 0.2
  v -24.0811 -23.2165 3.7554    -0.291649 -0.0173334 -0.956368    1.125 0.15
  v -23.2946 -21.8464 3.5311    -0.272522 0.0160606 -0.962015    1.125 0.1
  v -22.2053 -19.9802 3.2869    -0.261161 0.0351374 -0.964656    1.125 0.05
  v -26.5408 -24.166 4.93232    -0.700185 -0.620851 -0.352541    1 0.35
  v -26.4702 -24.0343 4.75264    -0.567346 -0.357564 -0.7418    1 0.3
  v -26.2497 -23.7404 4.55337    -0.425197 -0.157281 -0.891331    1 0.25
  v -25.8184 -23.2187 4.32758    -0.346408 -0.0586935 -0.936246    1 0.2
  v -25.1153 -22.4035 4.06831    -0.303786 -0.00809846 -0.952706    1 0.15
  v -24.0796 -21.2293 3.7686    -0.278762 0.0207893 -0.960135    1 0.1
  v -22.6502 -19.6304 3.42151    -0.264035 0.0372386 -0.963794    1 0.05
  v -27.706 -22.7991 5.3088    -0.809763 -0.493414 -0.317533    0.875 0.35
  v -27.6136 -22.693 5.12206    -0.635238 -0.279078 -0.72013    0.875 0.3
  v -27.3425 -22.4585 4.90644    -0.460133 -0.116799 -0.880134    0.875 0.25
  v -26.8201 -22.0436 4.65123    -0.364904 -0.0372222 -0.930301    0.875 0.2
  v -25.9739 -21.3963 4.34571    -0.313795 0.00351681 -0.949484    0.875 0.15
  v -24.7312 -20.4648 3.97915    -0.283911 0.0267412 -0.958478    0.875 0.1
  v -23.0196 -19.1971 3.54085    -0.266417 0.0398997 -0.963032    0.875 0.05
  v -28.5532 -21.2761 5.6106    -0.893007 -0.345437 -0.288465    0.75 0.35
  v -28.4449 -21.1986 5.41821    -0.686766 -0.187758 -0.702211    0.75 0.3
  v -28.137 -21.0302 5.18949    -0.486571 -0.0696925 -0.870857    0.75 0.25
  v -27.5484 -20.7342 4.91069    -0.378882 -0.012243 -0.925364    0.75 0.2
  v -26.5981 -20.2741 4.56809    -0.321357 0.0170314 -0.946805    0.75 0.15
  v -25.2051 -19.613 4.14794    -0.287805 0.0336721 -0.957097    0.75 0.1
  v -23.2882 -18.7143 3.63652    -0.268236 0.0430205 -0.962392    0.75 0.05
  v -29.0811 -19.6445 5.83489    -0.946092 -0.184209 -0.266414    0.625 0.35
  v -28.963 -19.5975 5.63829    -0.719731 -0.0883084 -0.688614    0.625 0.3
  v -28.6321 -19.4999 5.39983    -0.503456 -0.0184414 -0.863824    0.625 0.25
  v -28.0023 -19.3315 5.10351    -0.387799 0.014924 -0.921623    0.625 0.2
  v -26.9871 -19.0718 4.73335    -0.326183 0.0317298 -0.944774    0.625 0.15
  v -25.5003 -18.7005 4.27338    -0.290295 0.0412133 -0.956049    0.625 0.1
  v -23.4555 -18.1971 3.70762    -0.269421 0.0464308 -0.961903    0.625 0.05
  v -29.2884 -17.9516 5.97879    -0.967597 -0.0160122 -0.251992    0.5 0.35
  v -29.1664 -17.9363 5.7795    -0.73337 0.0154023 -0.679655    0.5 0.3
  v -28.8265 -17.9123 5.53479    -0.510439 0.0349701 -0.859203    0.5 0.25
  v -28.1805 -17.8762 5.22722    -0.391477 0.0432289 -0.919172    0.5 0.2
  v -27.1398 -17.8245 4.83938    -0.328175 0.0470441 -0.943445    0.5 0.15
  v -25.6162 -17.7537 4.35386    -0.291331 0.0490731 -0.955363    0.5 0.1
  v -23.5212 -17.6605 3.75323    -0.269945 0.0499947 -0.961577    0.5 0.05
  v -29.1738 -16.245 6.03946    -0.957117 0.153696 -0.24557    0.375 0.35
  v -29.0539 -16.2616 5.83904    -0.727467 0.120104 -0.675549    0.375 0.3
  v -28.719 -16.3117 5.59169    -0.507424 0.0888869 -0.8571    0.375 0.25
  v -28.0819 -16.409 5.27938    -0.38987 0.0717993 -0.918067    0.375 0.2
  v -27.0554 -16.5669 4.88409    -0.32731 0.0625025 -0.942848    0.375 0.15
  v -25.5521 -16.7992 4.38779    -0.290901 0.057009 -0.955053    0.375 0.1
  v -23.4849 -17.1195 3.77246    -0.269805 0.0536019 -0.961422    0.375 0.05
  v -28.736 -14.572 6.01405    -0.91472 0.319466 -0.247444    0.25 0.35
  v -28.6243 -14.6199 5.81411    -0.70203 0.222554 -0.676479    0.25 0.3
  v -28.3084 -14.7427 5.56786    -0.494407 0.141672 -0.857608    0.25 0.25
  v -27.7056 -14.9707 5.25753    -0.382972 0.0997711 -0.918356    0.25 0.2
  v -26.7328 -15.3342 4.86537    -0.323585 0.0776387 -0.943009    0.25 0.15
  v -25.3073 -15.8636 4.37358    -0.289003 0.0647822 -0.955134    0.25 0.1
  v -23.3461 -16.5891 3.76441    -0.268997 0.0571447 -0.961444    0.25 0.05
  v -27.9737 -12.98 5.8997    -0.841389 0.474968 -0.257819    0.125 0.35
  v -27.8763 -13.0578 5.70189    -0.657523 0.318919 -0.682609    0.125 0.3
  v -27.5935 -13.2498 5.46061    -0.471588 0.191366 -0.860804    0.125 0.25
  v -27.0502 -13.6022 5.15923    -0.370885 0.126108 -0.920076    0.125 0.2
  v -26.1711 -14.1612 4.78111    -0.317052 0.0918918 -0.943946    0.125 0.15
  v -24.8809 -14.9733 4.30963    -0.285664 0.0721052 -0.955613    0.125 0.1
  v -23.1045 -16.0845 3.72816    -0.267532 0.0604955 -0.961648    0.125 0.05
  v -26.8857 -11.5167 5.69355    -0.802329 0.573003 -0.167141    0 0.35
  v -26.8086 -11.6218 5.49961    -0.658918 0.400197 -0.636923    0 0.3
  v -26.5731 -11.8774 5.26728    -0.475761 0.23431 -0.847792    0 0.25
  v -26.1148 -12.3441 4.982    -0.373228 0.148497 -0.915778    0 0.2
  v -25.3694 -13.083 4.62921    -0.318628 0.104188 -0.942137    0 0.15
  v -24.2724 -14.1548 4.19433    -0.28706 0.0789528 -0.954653    0 0.1
  v -22.7595 -15.6206 3.66281    -0.267305 0.0632963 -0.961531    0 0.05
  v -25.5454 -10.2957 5.40876    -0.61551 0.727383 -0.303417    1.875 0.35
  v -25.4935 -10.4238 5.22015    -0.518778 0.475511 -0.710464    1.875 0.3
  v -25.3162 -10.7323 5.00019    -0.400111 0.272061 -0.875154    1.875 0.25
  v -24.9627 -11.2945 4.73717    -0.332983 0.168855 -0.927691    1.875 0.2
  v -24.3819 -12.1833 4.41937    -0.29655 0.115027 -0.948065    1.875 0.15
  v -23.5229 -13.472 4.03506    -0.275161 0.0840027 -0.957721    1.875 0.1
  v -22.3347 -15.2336 3.57254    -0.262846 0.0659831 -0.962579    1.875 0.05
  v -24.0582 -9.40097 5.06832    -0.471142 0.815179 -0.336911    1.75 0.35
  v -24.0341 -9.54578 4.88609    -0.429701 0.529841 -0.731181    1.75 0.3
  v -23.9214 -9.89319 4.68092    -0.354143 0.299954 -0.885783    1.75 0.25
  v -23.6841 -10.5253 4.4445    -0.308599 0.183609 -0.933303    1.75 0.2
  v -23.286 -11.524 4.16852    -0.283356 0.123012 -0.951093    1.75 0.15
  v -22.6911 -12.9716 3.84466    -0.268393 0.0881141 -0.959271    1.75 0.1
  v -21.8633 -14.95 3.46462    -0.259798 0.067903 -0.963273    1.75 0.05
  v -22.47 -8.83431 4.68412    -0.314295 0.872051 -0.37516    1.625 0.35
  v -22.4756 -8.98973 4.50908    -0.332969 0.565138 -0.754818    1.625 0.3
  v -22.4319 -9.36176 4.3206    -0.304278 0.318048 -0.89792    1.625 0.25
  v -22.3187 -10.0381 4.1142    -0.282161 0.19317 -0.939718    1.625 0.2
  v -22.1157 -11.1065 3.88542    -0.269049 0.128187 -0.954558    1.625 0.15
  v -21.8029 -12.6547 3.62979    -0.261052 0.0907842 -0.961046    1.625 0.1
  v -21.3598 -14.7704 3.34283    -0.256478 0.0691708 -0.964072    1.625 0.05
  v -20.8267 -8.59772 4.26804    -0.151045 0.896475 -0.416554    1.5 0.35
  v -20.8631 -8.75758 4.1008    -0.232314 0.58058 -0.780357    1.5 0.3
  v -20.8908 -9.13988 3.93039    -0.252435 0.325962 -0.911057    1.5 0.25
  v -20.906 -9.83472 3.7565    -0.254685 0.197343 -0.946674    1.5 0.2
  v -20.9049 -10.9322 3.57884    -0.254183 0.130448 -0.958318    1.5 0.15
  v -20.8838 -12.5224 3.39709    -0.253422 0.0919588 -0.962975    1.5 0.1
  v -20.8389 -14.6954 3.21094    -0.253016 0.0697603 -0.964944    1.5 0.05
  v -19.1743 -8.69319 3.83199    0.0133187 0.88796 -0.459728    1.375 0.35
  v -19.2417 -8.85125 3.6729    -0.130903 0.575907 -0.806967    1.375 0.3
  v -19.3411 -9.22941 3.52144    -0.200218 0.323577 -0.924776    1.375 0.25
  v -19.4855 -9.91678 3.38163    -0.227018 0.196068 -0.95395    1.375 0.2
  v -19.6874 -11.0025 3.25754    -0.239214 0.129762 -0.962257    1.375 0.15
  v -19.9597 -12.5758 3.15322    -0.245737 0.091621 -0.964997    1.375 0.1
  v -20.3151 -14.7256 3.07271    -0.249523 0.0696631 -0.96586    1.375 0.05
  v -17.5589 -9.12266 3.38784    0.173509 0.846498 -0.503325    1.25 0.35
  v -17.6565 -9.27269 3.23707    -0.0318826 0.551078 -0.833845    1.25 0.3
  v -17.8262 -9.63218 3.1049    -0.149214 0.310865 -0.938668    1.25 0.25
  v -18.0967 -10.286 2.9998    -0.199996 0.189328 -0.961331    1.25 0.2
  v -18.4971 -11.319 2.93027    -0.224593 0.126121 -0.966256    1.25 0.15
  v -19.0563 -12.8159 2.90482    -0.238229 0.0897663 -0.967052    1.25 0.1
  v -19.803 -14.8618 2.93192    -0.246101 0.0688766 -0.966794    1.25 0.05
  v -16.0264 -9.88812 2.94749    0.323368 0.772993 -0.545816    1.125 0.35
  v -16.1527 -10.0238 2.80497    0.0610155 0.506506 -0.860075    1.125 0.3
  v -16.3889 -10.3501 2.69192    -0.101328 0.288003 -0.952254    1.125 0.25
  v -16.7793 -10.9441 2.62123    -0.174625 0.177212 -0.968557    1.125 0.2
  v -17.3679 -11.883 2.60581    -0.210865 0.119572 -0.970174    1.125 0.15
  v -18.1992 -13.244 2.65854    -0.231176 0.0864185 -0.969066    1.125 0.1
  v -19.3173 -15.1044 2.79233    -0.242873 0.0674099 -0.967713    1.125 0.05
  v -14.6229 -10.9915 2.52282    0.455521 0.670628 -0.585456    1 0.35
  v -14.7754 -11.1066 2.38826    0.143123 0.443874 -0.884586    1 0.3
  v -15.0726 -11.3849 2.29365    -0.0589863 0.255789 -0.964931    1 0.25
  v -15.5726 -11.8927 2.25615    -0.152193 0.160135 -0.975292    1 0.2
  v -16.3337 -12.696 2.2929    -0.198725 0.110336 -0.973824    1 0.15
  v -17.4142 -13.8612 2.42104    -0.224935 0.0816896 -0.970943    1 0.1
  v -18.8723 -15.4542 2.65772    -0.239999 0.0653089 -0.968574    1 0.05
  v -13.4576 -12.3584 2.14635    0.564934 0.543225 -0.621093    0.875 0.35
  v -13.632 -12.4479 2.01884    0.210916 0.365407 -0.906638    0.875 0.3
  v -13.9798 -12.6668 1.94058    -0.0240806 0.215314 -0.976248    0.875 0.25
  v -14.5709 -13.0678 1.9325    -0.133706 0.138666 -0.981272    0.875 0.2
  v -15.4751 -13.7032 2.0155    -0.188719 0.0987212 -0.977056    0.875 0.15
  v -16.7625 -14.6256 2.21049    -0.219787 0.0757377 -0.972603    0.875 0.1
  v -18.503 -15.8875 2.53838    -0.237617 0.0626476 -0.969337    0.875 0.05
  v -12.6104 -13.8814 1.84455    0.647936 0.395297 -0.651091    0.75 0.35
  v -12.8007 -13.9423 1.72268    0.262264 0.274123 -0.925243    0.75 0.3
  v -13.1853 -14.0951 1.65754    0.00229991 0.168219 -0.985747    0.75 0.25
  v -13.8425 -14.3771 1.67304    -0.119745 0.11369 -0.986274    0.75 0.2
  v -14.8509 -14.8254 1.79312    -0.181161 0.0852076 -0.979755    0.75 0.15
  v -16.2887 -15.4774 2.0417    -0.215894 0.0688072 -0.973989    0.75 0.1
  v -18.2344 -16.3703 2.44271    -0.235798 0.0595268 -0.969977    0.75 0.05
  v -12.0825 -15.5131 1.62026    0.700848 0.234104 -0.673801    0.625 0.35
  v -12.2827 -15.5434 1.5026    0.295094 0.174702 -0.939361    0.625 0.3
  v -12.6902 -15.6254 1.4472    0.0191406 0.116977 -0.99295    0.625 0.25
  v -13.3887 -15.7798 1.48023    -0.110841 0.0865256 -0.990064    0.625 0.2
  v -14.4619 -16.0277 1.62786    -0.17634 0.0705099 -0.981801    0.625 0.15
  v -15.9935 -16.3899 1.91626    -0.213406 0.0612661 -0.975041    0.625 0.1
  v -18.0671 -16.8875 2.37161    -0.234614 0.0561167 -0.970468    0.625 0.05
  v -11.8753 -17.206 1.47636    0.722299 0.0659188 -0.688432    0.5 0.35
  v -12.0793 -17.2046 1.36139    0.308682 0.0710018 -0.948512    0.5 0.3
  v -12.4958 -17.213 1.31224    0.0261064 0.063569 -0.997636    0.5 0.25
  v -13.2105 -17.2351 1.35651    -0.107167 0.0582219 -0.992535    0.5 0.2
  v -14.3092 -17.275 1.52182    -0.174349 0.0551961 -0.983136    0.5 0.15
  v -15.8776 -17.3367 1.83578    -0.21237 0.0534064 -0.975729    0.5 0.1
  v -18.0014 -17.4241 2.326    -0.234089 0.0525525 -0.970794    0.5 0.05
  v -11.9899 -18.9126 1.41568    0.711892 -0.103804 -0.694575    0.375 0.35
  v -12.1918 -18.8793 1.30185    0.302824 -0.0337089 -0.95245    0.375 0.3
  v -12.6033 -18.8136 1.25534    0.0231051 0.0096493 -0.999686    0.375 0.25
  v -13.309 -18.7023 1.30435    -0.108771 0.0296507 -0.993625    0.375 0.2
  v -14.3936 -18.5326 1.47712    -0.175213 0.0397373 -0.983728    0.375 0.15
  v -15.9416 -18.2912 1.80185    -0.2128 0.0454702 -0.976037    0.375 0.1
  v -18.0377 -17.9651 2.30676    -0.23423 0.0489451 -0.970948    0.375 0.05
  v -12.4277 -20.5856 1.4411    0.669683 -0.269612 -0.691978    0.25 0.35
  v -12.6214 -20.521 1.32679    0.277518 -0.136186 -0.951019    0.25 0.3
  v -13.0139 -20.3826 1.27917    0.0101292 -0.043144 -0.999017    0.25 0.25
  v -13.6854 -20.1406 1.3262    -0.115656 0.00167613 -0.993288    0.25 0.2
  v -14.7162 -19.7653 1.49584    -0.178935 0.0246005 -0.983553    0.25 0.15
  v -16.1865 -19.2268 1.81606    -0.214697 0.0376971 -0.975953    0.25 0.1
  v -18.1765 -18.4954 2.31482    -0.235038 0.0454025 -0.970925    0.25 0.05
  v -13.19 -22.1775 1.55545    0.596594 -0.425163 -0.68067    0.125 0.35
  v -13.3694 -22.0831 1.439    0.233189 -0.232587 -0.944207    0.125 0.3
  v -13.7288 -21.8755 1.38641    -0.0126311 -0.0928494 -0.9956    0.125 0.25
  v -14.3407 -21.5092 1.42451    -0.127726 -0.0246644 -0.991503    0.125 0.2
  v -15.2779 -20.9383 1.5801    -0.185462 0.0103461 -0.982597    0.125 0.15
  v -16.6128 -20.1172 1.88002    -0.218035 0.0303738 -0.975468    0.125 0.1
  v -18.4181 -19 2.35107    -0.236502 0.0420522 -0.970721    0.125 0.05
  v -24.4549 -11.672 16.8667    -0.314492 -0.0218994 -0.949008    1 1
  v -25.503 -10.6646 17.1908    -0.30848 -0.0272462 -0.95084    1 0.9375
  v -26.4315 -9.77527 17.4611    -0.290833 -0.0433611 -0.955791    1 0.875
  v -27.2394 -9.00793 17.6607    -0.255038 -0.0769481 -0.963864    1 0.8125
  v -27.9258 -8.36654 17.7728    -0.187856 -0.141147 -0.972002    1 0.75
  v -28.4896 -7.85504 17.7806    -0.0620089 -0.260938 -0.963362    1 0.6875
  v -28.93 -7.47739 17.6672    0.163498 -0.464427 -0.870389    1 0.625
  v -29.246 -7.23752 17.4159    0.450897 -0.68624 -0.57076    1 0.5625
  v -29.4366 -7.13938 17.0097    0.607467 -0.765256 -0.212997    1 0.5
  v -24.8148 -12.1265 16.9965    -0.41574 -0.143709 -0.898058    0.9375 1
  v -25.8817 -11.101 17.3264    -0.386633 -0.117202 -0.914756    0.9375 0.9375
  v -26.8259 -10.1967 17.6007    -0.37089 -0.131083 -0.919379    0.9375 0.875
  v -27.6469 -9.41716 17.8022    -0.338656 -0.16174 -0.926905    0.9375 0.8125
  v -28.3441 -8.76612 17.9133    -0.279013 -0.222095 -0.934251    0.9375 0.75
  v -28.917 -8.24729 17.9166    -0.16993 -0.335999 -0.926406    0.9375 0.6875
  v -29.3649 -7.86437 17.7948    0.0227826 -0.52968 -0.847891    0.9375 0.625
  v -29.6873 -7.62107 17.5304    0.284149 -0.752501 -0.59414    0.9375 0.5625
  v -29.8836 -7.5211 17.106    0.463406 -0.853619 -0.237885    0.9375 0.5
  v -25.0089 -12.4903 17.1861    -0.576997 -0.365555 -0.730372    0.875 1
  v -26.1253 -11.4174 17.531    -0.546551 -0.329592 -0.769838    0.875 0.9375
  v -27.111 -10.4735 17.8162    -0.531812 -0.342337 -0.774585    0.875 0.875
  v -27.9666 -9.66179 18.0225    -0.502269 -0.371835 -0.780682    0.875 0.8125
  v -28.6924 -8.98532 18.131    -0.449222 -0.431305 -0.782417    0.875 0.75
  v -29.289 -8.44715 18.1227    -0.356499 -0.541836 -0.761132    0.875 0.6875
  v -29.7568 -8.05036 17.9787    -0.202943 -0.716613 -0.667293    0.875 0.625
  v -30.0961 -7.79803 17.6799    -0.00406305 -0.899079 -0.437768    0.875 0.5625
  v -30.3075 -7.69322 17.2074    0.139067 -0.979242 -0.147465    0.875 0.5
  v -25.0551 -12.7524 17.408    -0.703005 -0.618919 -0.350319    0.8125 1
  v -26.2414 -11.6123 17.7743    -0.688158 -0.582083 -0.433149    0.8125 0.9375
  v -27.2858 -10.6125 18.0746    -0.678629 -0.590799 -0.43637    0.8125 0.875
  v -28.1903 -9.75537 18.2878    -0.658899 -0.611073 -0.438682    0.8125 0.8125
  v -28.9566 -9.04294 18.3926    -0.623177 -0.650942 -0.433503    0.8125 0.75
  v -29.5867 -8.47743 18.3679    -0.562549 -0.720359 -0.405736    0.8125 0.6875
  v -30.0825 -8.06103 18.1924    -0.46926 -0.819558 -0.328815    0.8125 0.625
  v -30.4458 -7.79591 17.8451    -0.35591 -0.916186 -0.184206    0.8125 0.5625
  v -30.6785 -7.68427 17.3047    -0.272478 -0.961994 -0.0180005    0.8125 0.5
  v -24.9713 -12.9016 17.6347    -0.632225 -0.735771 0.24276    0.75 1
  v -26.2377 -11.6845 18.0255    -0.665339 -0.734236 0.134987    0.75 0.9375
  v -27.3494 -10.6207 18.3433    -0.666388 -0.733205 0.135417    0.75 0.875
  v -28.3099 -9.71142 18.5643    -0.668314 -0.731464 0.13534    0.75 0.8125
  v -29.1227 -8.95776 18.6648    -0.671595 -0.728746 0.133751    0.75 0.75
  v -29.7912 -8.36091 18.6213    -0.676048 -0.725444 0.12919    0.75 0.6875
  v -30.3192 -7.92202 18.4098    -0.679045 -0.723911 0.121868    0.75 0.625
  v -30.7099 -7.64226 18.0068    -0.676155 -0.727368 0.117258    0.75 0.5625
  v -30.967 -7.52279 17.3885    -0.668753 -0.733352 0.122328    0.75 0.5
  v -24.7752 -12.9268 17.8387    -0.354637 -0.599307 0.71768    0.6875 1
  v -26.1218 -11.6327 18.254    -0.412609 -0.632009 0.655987    0.6875 0.9375
  v -27.3008 -10.5049 18.5892    -0.424785 -0.620347 0.659339    0.6875 0.875
  v -28.3173 -9.54345 18.8181    -0.453307 -0.598179 0.660829    0.6875 0.8125
  v -29.1765 -8.74857 18.9144    -0.509741 -0.561225 0.652067    0.6875 0.75
  v -29.8836 -8.12038 18.852    -0.606199 -0.504965 0.614437    0.6875 0.6875
  v -30.4436 -7.65901 18.6045    -0.73574 -0.432494 0.521186    0.6875 0.625
  v -30.8618 -7.3646 18.1458    -0.852563 -0.36672 0.37236    0.6875 0.5625
  v -31.1433 -7.2373 17.4496    -0.91346 -0.336388 0.228983    0.6875 0.5
  v -24.4849 -12.8169 17.9925    -0.0753249 -0.374782 0.924048    0.625 1
  v -25.9014 -11.4556 18.4292    -0.122903 -0.406875 0.905178    0.625 0.9375
  v -27.1391 -10.2719 18.7796    -0.141776 -0.389191 0.910181    0.625 0.875
  v -28.2045 -9.26501 19.0154    -0.18583 -0.355132 0.91616    0.625 0.8125
  v -29.1042 -8.43417 19.108    -0.274147 -0.296901 0.914709    0.625 0.75
  v -29.8448 -7.77863 19.0291    -0.43113 -0.203911 0.878947    0.625 0.6875
  v -30.4328 -7.29765 18.7502    -0.652452 -0.0780859 0.753796    0.625 0.625
  v -30.875 -6.99046 18.2429    -0.854258 0.0372553 0.518513    0.625 0.5625
  v -31.1777 -6.85633 17.4788    -0.956723 0.0900749 0.276708    0.625 0.5
  v -24.1181 -12.5607 18.0687    0.12671 -0.180918 0.975302    0.5625 1
  v -25.5841 -11.1519 18.5205    0.091432 -0.204617 0.974562    0.5625 0.9375
  v -26.8632 -9.92866 18.8817    0.0698931 -0.184355 0.980371    0.5625 0.875
  v -27.9632 -8.88961 19.1223    0.021472 -0.143138 0.98947    0.5625 0.8125
  v -28.8916 -8.03333 19.2123    -0.0742654 -0.0686706 0.994871    0.5625 0.75
  v -29.6559 -7.35846 19.1217    -0.247172 0.0559733 0.967354    0.5625 0.6875
  v -30.2638 -6.8636 18.8206    -0.500034 0.226695 0.835809    0.5625 0.625
  v -30.7229 -6.54738 18.279    -0.736811 0.374545 0.562873    0.5625 0.5625
  v -31.0407 -6.40841 17.4669    -0.857424 0.434834 0.275214    0.5625 0.5
  v -23.6927 -12.147 18.0397    0.271884 -0.0255711 0.96199    0.5 1
  v -25.1774 -10.7203 18.4972    0.24402 -0.0437106 0.968785    0.5 0.9375
  v -26.4724 -9.48204 18.8625    0.222019 -0.0227315 0.974777    0.5 0.875
  v -27.5854 -8.43078 19.1049    0.174472 0.0222151 0.984411    0.5 0.8125
  v -28.5247 -7.56486 19.194    0.0827078 0.1069 0.990824    0.5 0.75
  v -29.298 -6.88265 19.099    -0.082645 0.252274 0.96412    0.5 0.6875
  v -29.9134 -6.38253 18.7895    -0.32971 0.450689 0.829561    0.5 0.625
  v -30.3789 -6.06288 18.2348    -0.569514 0.614203 0.546268    0.5 0.5625
  v -30.7024 -5.92208 17.4044    -0.695756 0.674265 0.247568    0.5 0.5
  v -23.3328 -11.6926 17.9099    0.415308 0.144082 0.898198    0.4375 1
  v -24.7988 -10.2838 18.3617    0.384714 0.119186 0.915309    0.4375 0.9375
  v -26.078 -9.06061 18.7229    0.363714 0.139433 0.921016    0.4375 0.875
  v -27.1779 -8.02155 18.9635    0.320095 0.184922 0.929163    0.4375 0.8125
  v -28.1063 -7.16528 19.0535    0.238578 0.27324 0.931891    0.4375 0.75
  v -28.8706 -6.49041 18.963    0.0939492 0.426286 0.899697    0.4375 0.6875
  v -29.4785 -5.99555 18.6619    -0.125504 0.63315 0.763787    0.4375 0.625
  v -29.9376 -5.67933 18.1203    -0.349895 0.799194 0.488735    0.4375 0.5625
  v -30.2554 -5.54036 17.3081    -0.475022 0.856774 0.200728    0.4375 0.5
  v -23.1387 -11.3288 17.7204    0.576733 0.365766 0.730475    0.375 1
  v -24.5552 -9.96752 18.157    0.545386 0.330846 0.770126    0.375 0.9375
  v -25.7929 -8.78381 18.5075    0.527499 0.348058 0.774984    0.375 0.875
  v -26.8583 -7.77692 18.7432    0.49145 0.388363 0.779519    0.375 0.8125
  v -27.758 -6.94608 18.8358    0.426481 0.467864 0.774091    0.375 0.75
  v -28.4986 -6.29054 18.7569    0.314945 0.604153 0.73199    0.375 0.6875
  v -29.0867 -5.80956 18.4781    0.146219 0.784645 0.602456    0.375 0.625
  v -29.5288 -5.50238 17.9708    -0.0364369 0.929945 0.36589    0.375 0.5625
  v -29.8316 -5.36824 17.2067    -0.14747 0.981505 0.122067    0.375 0.5
  v -23.0925 -11.0667 17.4985    0.702935 0.618977 0.350357    0.3125 1
  v -24.4391 -9.7726 17.9138    0.687792 0.582456 0.433228    0.3125 0.9375
  v -25.6181 -8.64476 18.249    0.67709 0.592658 0.43624    0.3125 0.875
  v -26.6346 -7.68334 18.4779    0.654811 0.61662 0.437039    0.3125 0.8125
  v -27.4938 -6.88846 18.5742    0.614568 0.663129 0.427277    0.3125 0.75
  v -28.2009 -6.26027 18.5118    0.547472 0.740441 0.389899    0.3125 0.6875
  v -28.7609 -5.7989 18.2643    0.449315 0.841215 0.300789    0.3125 0.625
  v -29.1791 -5.50449 17.8056    0.340788 0.927154 0.15572    0.3125 0.5625
  v -29.4606 -5.37718 17.1094    0.268982 0.963115 0.00763015    0.3125 0.5
  v -23.1764 -10.9175 17.2718    0.632209 0.735791 -0.242741    0.25 1
  v -24.4428 -9.70038 17.6626    0.66524 0.734331 -0.134957    0.25 0.9375
  v -25.5545 -8.6366 17.9804    0.665966 0.733575 -0.135488    0.25 0.875
  v -26.515 -7.7273 18.2014    0.667165 0.732406 -0.135913    0.25 0.8125
  v -27.3278 -6.97364 18.302    0.66925 0.730564 -0.135572    0.25 0.75
  v -27.9964 -6.37679 18.2584    0.672441 0.728096 -0.133042    0.25 0.6875
  v -28.5243 -5.9379 18.0469    0.675287 0.726479 -0.12734    0.25 0.625
  v -28.915 -5.65814 17.6439    0.674131 0.728542 -0.121549    0.25 0.5625
  v -29.1721 -5.53867 17.0256    0.668438 0.733437 -0.123538    0.25 0.5
  v -23.3724 -10.8923 17.0678    0.354507 0.59948 -0.717599    0.1875 1
  v -24.5587 -9.75217 17.4341    0.411858 0.632667 -0.655824    0.1875 0.9375
  v -25.6031 -8.75244 17.7344    0.421652 0.622387 -0.659427    0.1875 0.875
  v -26.5076 -7.89526 17.9476    0.444706 0.602617 -0.662638    0.1875 0.8125
  v -27.2739 -7.18283 18.0524    0.491663 0.569144 -0.659046    0.1875 0.75
  v -27.904 -6.61732 18.0277    0.577751 0.516434 -0.63206    0.1875 0.6875
  v -28.3998 -6.20091 17.8522    0.708206 0.443594 -0.549243    0.1875 0.625
  v -28.7631 -5.9358 17.5049    0.841503 0.371512 -0.39224    0.1875 0.5625
  v -28.9958 -5.82416 16.9645    0.912233 0.33696 -0.232999    0.1875 0.5
  v -23.6628 -11.0022 16.9139    0.0750234 0.375158 -0.92392    0.125 1
  v -24.7791 -9.92928 17.2589    0.121254 0.408364 -0.90473    0.125 0.9375
  v -25.7648 -8.98541 17.544    0.134807 0.394023 -0.909161    0.125 0.875
  v -26.6204 -8.17371 17.7503    0.166159 0.366095 -0.915623    0.125 0.8125
  v -27.3463 -7.49723 17.8588    0.230362 0.317842 -0.919734    0.125 0.75
  v -27.9429 -6.95906 17.8505    0.354468 0.237849 -0.904312    0.125 0.6875
  v -28.4106 -6.56227 17.7065    0.566412 0.115614 -0.815972    0.125 0.625
  v -28.7499 -6.30994 17.4077    0.81471 -0.019283 -0.579548    0.125 0.5625
  v -28.9613 -6.20513 16.9353    0.951916 -0.0878674 -0.293489    0.125 0.5
  v -24.0296 -11.2584 16.8377    -0.127155 0.181405 -0.975153    0.0625 1
  v -25.0964 -10.233 17.1676    -0.0936613 0.206725 -0.973906    0.0625 0.9375
  v -26.0407 -9.32865 17.442    -0.0789352 0.191872 -0.97824    0.0625 0.875
  v -26.8617 -8.5491 17.6434    -0.0465144 0.161714 -0.985741    0.0625 0.8125
  v -27.5589 -7.89806 17.7545    0.0178282 0.106981 -0.994101    0.0625 0.75
  v -28.1317 -7.37923 17.7579    0.142716 0.0103175 -0.98971    0.0625 0.6875
  v -28.5796 -6.99632 17.6361    0.370227 -0.149823 -0.91678    0.0625 0.625
  v -28.902 -6.75302 17.3717    0.669269 -0.338785 -0.661289    0.0625 0.5625
  v -29.0984 -6.65305 16.9472    0.848458 -0.431505 -0.306469    0.0625 0.5
  v -29.5385 -7.14928 16.4518    0.647749 -0.761844 0.00393805    1 0.4375
  v -29.5802 -7.23514 15.776    0.65628 -0.740326 0.145647    1 0.375
  v -29.5488 -7.40335 15.0113    0.653573 -0.706617 0.271173    1 0.3125
  v -29.4315 -7.66029 14.1867    0.640977 -0.661099 0.389995    1 0.25
  v -29.2153 -8.01233 13.3312    0.616174 -0.60392 0.50558    1 0.1875
  v -28.8873 -8.46584 12.474    0.575343 -0.536345 0.617506    1 0.125
  v -28.4345 -9.02722 11.644    0.514714 -0.461542 0.72253    1 0.0625
  v -27.8441 -9.70282 10.8702    0.491647 -0.434582 0.754601    1 0
  v -29.989 -7.53124 16.5296    0.516052 -0.856557 -0.000205265    0.9375 0.4375
  v -30.0304 -7.61996 15.8394    0.528614 -0.836664 0.143387    0.9375 0.375
  v -29.9955 -7.79348 15.0633    0.532478 -0.802692 0.268611    0.9375 0.3125
  v -29.8718 -8.05799 14.2291    0.529729 -0.755338 0.385813    0.9375 0.25
  v -29.6466 -8.41972 13.3648    0.516792 -0.695594 0.499074    0.9375 0.1875
  v -29.3077 -8.88488 12.4981    0.487139 -0.626629 0.608302    0.9375 0.125
  v -28.8423 -9.45967 11.657    0.433356 -0.554614 0.710356    0.9375 0.0625
  v -28.2381 -10.1503 10.8692    0.430739 -0.489389 0.758263    0.9375 0
  v -30.422 -7.70401 16.5821    0.183586 -0.981784 0.0489426    0.875 0.4375
  v -30.4628 -7.80026 15.854    0.196148 -0.965093 0.173554    0.875 0.375
  v -30.4185 -7.98775 15.0479    0.207323 -0.936202 0.283802    0.875 0.3125
  v -30.2777 -8.27225 14.1885    0.219722 -0.894849 0.388546    0.875 0.25
  v -30.0291 -8.65954 13.3006    0.227676 -0.840814 0.491116    0.875 0.1875
  v -29.6613 -9.15539 12.4091    0.219408 -0.777454 0.589428    0.875 0.125
  v -29.1627 -9.76556 11.5386    0.180191 -0.713877 0.676692    0.875 0.0625
  v -28.5222 -10.4958 10.714    0.201594 -0.651829 0.73108    0.875 0
  v -30.8059 -7.69598 16.6102    -0.245485 -0.964538 0.0969721    0.8125 0.4375
  v -30.8458 -7.80288 15.8285    -0.238198 -0.955492 0.174058    0.8125 0.375
  v -30.7883 -8.01013 14.9799    -0.23011 -0.942087 0.243972    0.8125 0.3125
  v -30.6235 -8.32288 14.0849    -0.218129 -0.92447 0.31269    0.8125 0.25
  v -30.3417 -8.7463 13.1638    -0.20535 -0.900671 0.382915    0.8125 0.1875
  v -29.9329 -9.28553 12.237    -0.200892 -0.869231 0.451753    0.8125 0.125
  v -29.3875 -9.94573 11.3251    -0.218279 -0.832339 0.509475    0.8125 0.0625
  v -28.6955 -10.7321 10.4483    -0.160535 -0.795706 0.58402    0.8125 0
  v -31.1093 -7.53554 16.6148    -0.665807 -0.735339 0.126402    0.75 0.4375
  v -31.1481 -7.65465 15.7716    -0.666095 -0.735121 0.126153    0.75 0.375
  v -31.0754 -7.88455 14.8744    -0.666944 -0.734553 0.12497    0.75 0.3125
  v -30.883 -8.22969 13.9384    -0.667596 -0.734246 0.123283    0.75 0.25
  v -30.5631 -8.69453 12.9792    -0.667362 -0.734663 0.122057    0.75 0.1875
  v -30.1076 -9.28349 12.0122    -0.665597 -0.736113 0.12296    0.75 0.125
  v -29.5084 -10.001 11.0527    -0.66238 -0.738231 0.127545    0.75 0.0625
  v -28.7575 -10.8516 10.1161    -0.599418 -0.770266 0.217689    0.75 0
  v -31.3005 -7.2511 16.5967    -0.932944 -0.337515 0.125297    0.6875 0.4375
  v -31.3382 -7.38241 15.692    -0.937028 -0.346906 0.0404339    0.6875 0.375
  v -31.2503 -7.63496 14.7461    -0.934 -0.355097 -0.0393664    0.6875 0.3125
  v -31.0304 -8.0125 13.7693    -0.925687 -0.360123 -0.115822    0.6875 0.25
  v -30.6724 -8.51875 12.772    -0.911901 -0.36445 -0.188711    0.6875 0.1875
  v -30.17 -9.15745 11.7647    -0.89209 -0.374024 -0.253536    0.6875 0.125
  v -29.517 -9.93234 10.7576    -0.867064 -0.396909 -0.301103    0.6875 0.0625
  v -28.7072 -10.8472 9.7613    -0.844679 -0.472363 -0.251777    0.6875 0
  v -31.3479 -6.87104 16.5568    -0.991129 0.0891552 0.0985589    0.625 0.4375
  v -31.3847 -7.013 15.5985    -0.996298 0.0698295 -0.0501442    0.625 0.375
  v -31.2835 -7.28531 14.6101    -0.981297 0.0472173 -0.186618    0.625 0.3125
  v -31.0396 -7.6911 13.5977    -0.950934 0.026695 -0.30824    0.625 0.25
  v -30.6484 -8.23349 12.5671    -0.910333 0.00754452 -0.413808    0.625 0.1875
  v -30.1052 -8.91558 11.5246    -0.865164 -0.0152527 -0.501257    0.625 0.125
  v -29.4053 -9.74049 10.4761    -0.822169 -0.0491892 -0.567114    0.625 0.0625
  v -28.544 -10.7113 9.42762    -0.81914 -0.118509 -0.561217    0.625 0
  v -31.22 -6.42377 16.4959    -0.898935 0.433759 0.0613991    0.5625 0.4375
  v -31.2562 -6.57326 15.4997    -0.905229 0.407444 -0.120624    0.5625 0.375
  v -31.1456 -6.85955 14.4813    -0.884777 0.368721 -0.28498    0.5625 0.3125
  v -30.8847 -7.28533 13.4436    -0.844981 0.325968 -0.423972    0.5625 0.25
  v -30.47 -7.85326 12.3896    -0.794992 0.283403 -0.536349    0.5625 0.1875
  v -29.8979 -8.56604 11.3222    -0.742991 0.241364 -0.624265    0.5625 0.125
  v -29.1648 -9.42634 10.2443    -0.695513 0.197662 -0.690791    0.5625 0.0625
  v -28.2672 -10.4368 9.15897    -0.695273 0.141007 -0.704778    0.5625 0
  v -30.8852 -5.93768 16.4149    -0.739093 0.673129 0.0252607    0.5 0.4375
  v -30.9211 -6.09003 15.4044    -0.746848 0.644037 -0.165632    0.5 0.375
  v -30.807 -6.38162 14.3746    -0.729395 0.595375 -0.336915    0.5 0.3125
  v -30.5397 -6.81498 13.3273    -0.694611 0.53684 -0.478872    0.5 0.25
  v -30.1161 -7.39261 12.2644    -0.651072 0.476826 -0.590544    0.5 0.1875
  v -29.533 -8.11703 11.1875    -0.6051 0.420464 -0.676065    0.5 0.125
  v -28.7873 -8.99075 10.0985    -0.560319 0.370034 -0.741025    0.5 0.0625
  v -27.8759 -10.0163 8.99919    -0.56016 0.321289 -0.763541    0.5 0
  v -30.4347 -5.55572 16.3371    -0.516973 0.855916 -0.0121269    0.4375 0.4375
  v -30.4709 -5.70521 15.3409    -0.526603 0.827772 -0.193605    0.4375 0.375
  v -30.3603 -5.9915 14.3225    -0.518189 0.777296 -0.356779    0.4375 0.3125
  v -30.0994 -6.41728 13.2849    -0.498161 0.713058 -0.49334    0.4375 0.25
  v -29.6847 -6.98521 12.2308    -0.470931 0.644594 -0.602265    0.4375 0.1875
  v -29.1126 -7.69799 11.1634    -0.438053 0.58007 -0.686752    0.4375 0.125
  v -28.3795 -8.55829 10.0856    -0.398781 0.525779 -0.751352    0.4375 0.0625
  v -27.4819 -9.56879 9.00021    -0.409422 0.473392 -0.779919    0.4375 0
  v -30.0017 -5.38295 16.2846    -0.183736 0.981399 -0.0556558    0.375 0.4375
  v -30.0385 -5.52491 15.3263    -0.194072 0.959583 -0.203803    0.375 0.375
  v -29.9373 -5.79722 14.338    -0.19676 0.92003 -0.338868    0.375 0.3125
  v -29.6935 -6.20301 13.3255    -0.196501 0.867361 -0.457245    0.375 0.25
  v -29.3022 -6.7454 12.295    -0.19245 0.807294 -0.557888    0.375 0.1875
  v -28.759 -7.42749 11.2525    -0.179444 0.747034 -0.640109    0.375 0.125
  v -28.0591 -8.2524 10.2039    -0.150159 0.695238 -0.70292    0.375 0.0625
  v -27.1978 -9.22326 9.15546    -0.181173 0.6421 -0.744905    0.375 0
  v -29.6178 -5.39098 16.2565    0.245508 0.964375 -0.0985219    0.3125 0.4375
  v -29.6555 -5.52229 15.3518    0.238873 0.953565 -0.183448    0.3125 0.375
  v -29.5676 -5.77485 14.4059    0.233755 0.93621 -0.262429    0.3125 0.3125
  v -29.3477 -6.15239 13.4291    0.226686 0.913904 -0.336739    0.3125 0.25
  v -28.9897 -6.65864 12.4318    0.219379 0.886759 -0.406854    0.3125 0.1875
  v -28.4873 -7.29734 11.4245    0.218272 0.855405 -0.469723    0.3125 0.125
  v -27.8343 -8.07223 10.4174    0.232834 0.822943 -0.518222    0.3125 0.0625
  v -27.0245 -8.98705 9.4211    0.172059 0.790452 -0.587862    0.3125 0
  v -29.3144 -5.55142 16.2519    0.665778 0.735284 -0.126879    0.25 0.4375
  v -29.3532 -5.67053 15.4087    0.666228 0.734682 -0.127994    0.25 0.375
  v -29.2805 -5.90043 14.5115    0.667617 0.73338 -0.128223    0.25 0.3125
  v -29.0882 -6.24557 13.5756    0.669106 0.732175 -0.127344    0.25 0.25
  v -28.7682 -6.71041 12.6164    0.669799 0.731788 -0.125919    0.25 0.1875
  v -28.3127 -7.29938 11.6493    0.668569 0.732983 -0.125504    0.25 0.125
  v -27.7135 -8.01692 10.6898    0.664701 0.736009 -0.128309    0.25 0.0625
  v -26.9626 -8.86749 9.75327    0.601048 0.76902 -0.217598    0.25 0
  v -29.1232 -5.83586 16.27    0.932618 0.336771 -0.129647    0.1875 0.4375
  v -29.1631 -5.94277 15.4883    0.937729 0.343188 -0.0537257    0.1875 0.375
  v -29.1056 -6.15001 14.6397    0.937842 0.346587 0.0181378    0.1875 0.3125
  v -28.9408 -6.46277 13.7447    0.933643 0.346396 0.0912176    0.1875 0.25
  v -28.659 -6.88619 12.8236    0.922979 0.346841 0.166766    0.1875 0.1875
  v -28.2502 -7.42542 11.8968    0.903102 0.356447 0.239482    0.1875 0.125
  v -27.7048 -8.08562 10.9849    0.873496 0.386279 0.296298    0.1875 0.0625
  v -27.0128 -8.87195 10.1081    0.847599 0.467644 0.250769    0.1875 0
  v -29.0758 -6.21592 16.31    0.989914 -0.090675 -0.108847    0.125 0.4375
  v -29.1166 -6.31217 15.5818    0.996795 -0.0785555 0.0151082    0.125 0.375
  v -29.0723 -6.49966 14.7757    0.989358 -0.0683376 0.128458    0.125 0.3125
  v -28.9316 -6.78416 13.9163    0.969004 -0.0609861 0.239399    0.125 0.25
  v -28.683 -7.17145 13.0285    0.935338 -0.0509186 0.350072    0.125 0.1875
  v -28.3151 -7.6673 12.1369    0.889475 -0.027876 0.456133    0.125 0.125
  v -27.8166 -8.27747 11.2664    0.836797 0.0210939 0.547107    0.125 0.0625
  v -27.176 -9.00776 10.4418    0.826285 0.102568 0.553835    0.125 0
  v -29.2037 -6.66319 16.3708    0.897067 -0.435303 -0.0760463    0.0625 0.4375
  v -29.2452 -6.75191 15.6806    0.905551 -0.418846 0.0674145    0.0625 0.375
  v -29.2103 -6.92542 14.9045    0.896389 -0.398073 0.195001    0.0625 0.3125
  v -29.0865 -7.18994 14.0704    0.871788 -0.373856 0.316572    0.0625 0.25
  v -28.8614 -7.55167 13.206    0.832524 -0.3426 0.43535    0.0625 0.1875
  v -28.5224 -8.01683 12.3393    0.780259 -0.298397 0.549686    0.0625 0.125
  v -28.0571 -8.59162 11.4982    0.719034 -0.23459 0.654185    0.0625 0.0625
  v -27.4529 -9.28227 10.7104    0.70735 -0.162678 0.687889    0.0625 0
  v -11.4382 -24.8778 9.04532    0.14239 -0.016117 0.989679    0.5 0
  v -10.1911 -26.0431 8.8419    0.0722009 0.120064 0.990137    0.5 0.1125
  v -9.24761 -26.8581 9.05279    -0.168842 0.326117 0.930129    0.5 0.225
  v -8.53243 -27.4091 9.57734    -0.398258 0.502329 0.7675    0.5 0.3375
  v -7.97022 -27.7828 10.3149    -0.535569 0.591525 0.602714    0.5 0.45
  v -7.48563 -28.0657 11.1649    -0.58076 0.61313 0.535527    0.5 0.5625
  v -7.00333 -28.3444 12.0266    -0.551038 0.589901 0.590232    0.5 0.675
  v -6.44797 -28.7055 12.7993    -0.43056 0.510732 0.744158    0.5 0.7875
  v -5.74422 -29.2354 13.3826    -0.255786 0.391349 0.883979    0.5 0.9
  v -12.3556 -25.8217 9.01442    -0.104169 -0.264889 0.958636    0.5625 0
  v -11.0521 -26.9888 8.82208    -0.143009 -0.131117 0.980998    0.5625 0.1125
  v -10.0248 -27.753 9.04482    -0.351134 0.0723604 0.933525    0.5625 0.225
  v -9.20759 -28.2183 9.58115    -0.553963 0.258858 0.791276    0.5625 0.3375
  v -8.53447 -28.4887 10.3296    -0.679956 0.355383 0.641376    0.5625 0.45
  v -7.93943 -28.6682 11.1887    -0.731864 0.357612 0.580077    0.5625 0.5625
  v -7.35645 -28.8608 12.0569    -0.723426 0.290371 0.62637    0.5625 0.675
  v -6.71952 -29.1707 12.8327    -0.634349 0.177496 0.752394    0.5625 0.7875
  v -5.96263 -29.7017 13.4148    -0.475837 0.0709801 0.876664    0.5625 0.9
  v -13.1139 -26.475 8.59728    -0.363853 -0.509508 0.779752    0.625 0
  v -11.7063 -27.6957 8.44312    -0.366708 -0.410146 0.835048    0.625 0.1125
  v -10.5747 -28.4553 8.72073    -0.505376 -0.25917 0.823059    0.625 0.225
  v -9.65362 -28.877 9.3215    -0.657679 -0.103466 0.746159    0.625 0.3375
  v -8.87745 -29.0843 10.1369    -0.761697 -0.0112711 0.647835    0.625 0.45
  v -8.18057 -29.2005 11.0583    -0.80193 -0.013524 0.597265    0.625 0.5625
  v -7.49737 -29.3489 11.9771    -0.786202 -0.0873672 0.611762    0.625 0.675
  v -6.76223 -29.6529 12.7847    -0.716159 -0.188813 0.671912    0.625 0.7875
  v -5.90955 -30.2359 13.3726    -0.601168 -0.262093 0.75492    0.625 0.9
  v -13.684 -26.8436 7.90603    -0.560814 -0.689445 0.458425    0.6875 0
  v -12.1423 -28.1548 7.80856    -0.534792 -0.653705 0.535413    0.6875 0.1125
  v -10.8987 -28.9469 8.17087    -0.573135 -0.602936 0.554964    0.6875 0.225
  v -9.88081 -29.3624 8.87286    -0.638376 -0.534378 0.554    0.6875 0.3375
  v -9.01622 -29.5438 9.79443    -0.70249 -0.472324 0.53237    0.6875 0.45
  v -8.23262 -29.6338 10.8155    -0.735215 -0.447258 0.509333    0.6875 0.5625
  v -7.45767 -29.7749 11.8159    -0.731243 -0.463846 0.500131    0.6875 0.675
  v -6.61902 -30.1097 12.6756    -0.703993 -0.503332 0.50105    0.6875 0.7875
  v -5.64432 -30.7808 13.2745    -0.650444 -0.535563 0.538605    0.6875 0.9
  v -14.0364 -26.9334 7.05277    -0.643009 -0.763818 0.0558758    0.75 0
  v -12.3493 -28.3573 7.0219    -0.591554 -0.795226 0.132963    0.75 0.1125
  v -10.9984 -29.2101 7.4856    -0.510768 -0.843683 0.165273    0.75 0.225
  v -9.89943 -29.6515 8.30967    -0.455115 -0.863698 0.216554    0.75 0.3375
  v -8.96781 -29.8413 9.35993    -0.460017 -0.847745 0.264031    0.75 0.45
  v -8.11913 -29.9391 10.5022    -0.514115 -0.807593 0.288927    0.75 0.5625
  v -7.26894 -30.1049 11.6022    -0.576904 -0.765559 0.284784    0.75 0.675
  v -6.3328 -30.4984 12.5259    -0.627961 -0.740382 0.239792    0.75 0.7875
  v -5.22626 -31.2794 13.139    -0.642309 -0.734797 0.217972    0.75 0.9
  v -14.1421 -26.7503 6.14961    -0.597225 -0.718428 -0.356629    0.8125 0
  v -12.316 -28.2943 6.18668    -0.523047 -0.801879 -0.288813    0.8125 0.1125
  v -10.8753 -29.227 6.75527    -0.335168 -0.911242 -0.239376    0.8125 0.225
  v -9.71976 -29.7214 7.70639    -0.176843 -0.973961 -0.141871    0.8125 0.3375
  v -8.74926 -29.9506 8.89102    -0.127822 -0.99057 -0.0493127    0.8125 0.45
  v -7.86364 -30.0875 10.1602    -0.199478 -0.979902 0.00097615    0.8125 0.5625
  v -6.96278 -30.3051 11.3648    -0.337756 -0.941193 -0.00880874    0.8125 0.675
  v -5.94652 -30.7765 12.3559    -0.473994 -0.874053 -0.106591    0.8125 0.7875
  v -4.71472 -31.6748 12.9846    -0.544311 -0.81395 -0.203003    0.8125 0.9
  v -13.9717 -26.3005 5.30867    -0.440014 -0.560424 -0.70165    0.875 0
  v -12.0315 -27.9569 5.40642    -0.353005 -0.678625 -0.644093    0.875 0.1125
  v -10.5308 -28.9797 6.07025    -0.103581 -0.821877 -0.560169    0.875 0.225
  v -9.35209 -29.5492 7.13748    0.0999764 -0.905157 -0.413153    0.875 0.3375
  v -8.37761 -29.8459 8.44538    0.177633 -0.938776 -0.295204    0.875 0.45
  v -7.48972 -30.0499 9.83127    0.122337 -0.958077 -0.259077    0.875 0.5625
  v -6.57077 -30.3416 11.1324    -0.0351708 -0.947923 -0.316552    0.875 0.675
  v -5.5031 -30.9015 12.1862    -0.22719 -0.852102 -0.471494    0.875 0.7875
  v -4.16903 -31.9097 12.8298    -0.339726 -0.719273 -0.605997    0.875 0.9
  v -13.4961 -25.5897 4.64206    -0.224869 -0.3352 -0.914918    0.9375 0
  v -11.4846 -27.3361 4.78464    -0.135264 -0.472804 -0.870724    0.9375 0.1125
  v -9.9665 -28.4503 5.5209    0.125581 -0.644337 -0.75436    0.9375 0.225
  v -8.80669 -29.112 6.67739    0.329188 -0.75054 -0.572996    0.9375 0.3375
  v -7.86989 -29.5011 8.08068    0.415647 -0.79369 -0.444178    0.9375 0.45
  v -7.0209 -29.7974 9.55733    0.3928 -0.811988 -0.431721    0.9375 0.5625
  v -6.12449 -30.1807 10.9339    0.268094 -0.795581 -0.543301    0.9375 0.675
  v -5.04545 -30.8306 12.037    0.0593811 -0.675878 -0.734617    0.9375 0.7875
  v -3.64854 -31.9271 12.6931    -0.0979296 -0.507562 -0.856032    0.9375 0.9
  v -12.6859 -24.6239 4.26188    -0.147656 -0.25256 -0.956248    1 0
  v -10.6642 -26.423 4.42487    -0.063754 -0.318259 -0.945858    1 0.1125
  v -9.18382 -27.6209 5.19756    0.190196 -0.50691 -0.840754    1 0.225
  v -8.09384 -28.3869 6.40058    0.403103 -0.642346 -0.651843    1 0.3375
  v -7.24317 -28.8905 7.85457    0.506254 -0.700611 -0.502843    1 0.45
  v -6.48075 -29.3011 9.38017    0.51068 -0.716497 -0.475224    1 0.5625
  v -5.65555 -29.7883 10.798    0.424768 -0.693826 -0.58153    1 0.675
  v -4.6165 -30.5215 11.9287    0.239025 -0.58185 -0.777379    1 0.7875
  v -3.21256 -31.67 12.593    0.037878 -0.400647 -0.915449    1 0.9
  v -11.7685 -23.68 4.29278    0.214405 0.156408 -0.964141    0.0625 0
  v -9.80311 -25.4773 4.44469    0.285285 -0.0048235 -0.95843    0.0625 0.1125
  v -8.40662 -26.7259 5.20553    0.504799 -0.223129 -0.833901    0.0625 0.225
  v -7.41868 -27.5777 6.39677    0.667987 -0.374771 -0.642915    0.0625 0.3375
  v -6.67892 -28.1846 7.83989    0.748696 -0.423215 -0.510238    0.0625 0.45
  v -6.02696 -28.6987 9.35638    0.771353 -0.389313 -0.503437    0.0625 0.5625
  v -5.30243 -29.2719 10.7677    0.723162 -0.289761 -0.626956    0.0625 0.675
  v -4.34495 -30.0563 11.8953    0.541028 -0.147052 -0.828048    0.0625 0.7875
  v -2.99415 -31.2037 12.5608    0.331995 -0.0352639 -0.942622    0.0625 0.9
  v -11.0102 -23.0267 4.70992    0.444234 0.426056 -0.78812    0.125 0
  v -9.149 -24.7705 4.82365    0.500075 0.27586 -0.820869    0.125 0.1125
  v -7.85674 -26.0237 5.52962    0.684429 0.0582722 -0.726748    0.125 0.225
  v -6.97265 -26.9189 6.65641    0.819459 -0.104878 -0.56346    0.125 0.3375
  v -6.33593 -27.5889 8.03261    0.886487 -0.150052 -0.437749    0.125 0.45
  v -5.78581 -28.1663 9.48678    0.907583 -0.0849548 -0.411189    0.125 0.5625
  v -5.16151 -28.7838 10.8475    0.871134 0.0506262 -0.48843    0.125 0.675
  v -4.30224 -29.574 11.9434    0.730227 0.190131 -0.656215    0.125 0.7875
  v -3.04724 -30.6696 12.603    0.56127 0.266411 -0.783582    0.125 0.9
  v -10.4402 -22.6581 5.40117    0.618469 0.630706 -0.468728    0.1875 0
  v -8.71292 -24.3113 5.45822    0.661608 0.530443 -0.530005    0.1875 0.1125
  v -7.5327 -25.532 6.07948    0.798721 0.364747 -0.478545    0.1875 0.225
  v -6.74546 -26.4335 7.10506    0.900359 0.229211 -0.369886    0.1875 0.3375
  v -6.19716 -27.1294 8.37505    0.942659 0.195726 -0.270341    0.1875 0.45
  v -5.73376 -27.733 9.72955    0.936393 0.266627 -0.228208    0.1875 0.5625
  v -5.20121 -28.3578 11.0087    0.886292 0.388196 -0.252566    0.1875 0.675
  v -4.44546 -29.1172 12.0525    0.792554 0.495877 -0.354914    0.1875 0.7875
  v -3.31247 -30.1247 12.7011    0.705477 0.550797 -0.44601    0.1875 0.9
  v -10.0877 -22.5683 6.25444    0.697738 0.713176 -0.0673909    0.25 0
  v -8.50596 -24.1088 6.24488    0.717603 0.684088 -0.130649    0.25 0.1125
  v -7.43299 -25.2688 6.76475    0.778158 0.619131 -0.105575    0.25 0.225
  v -6.72684 -26.1444 7.66825    0.820106 0.569347 -0.0571799    0.25 0.3375
  v -6.24557 -26.832 8.80956    0.824419 0.565905 -0.00921743    0.25 0.45
  v -5.84725 -27.4277 10.0429    0.794906 0.606509 0.0164636    0.25 0.5625
  v -5.38993 -28.0278 11.2223    0.750831 0.660355 0.0135684    0.25 0.675
  v -4.73167 -28.7285 12.2022    0.710417 0.703272 -0.0267636    0.25 0.7875
  v -3.73053 -29.626 12.8366    0.691216 0.721234 -0.0451875    0.25 0.9
  v -9.98203 -22.7513 7.15759    0.672064 0.655914 0.343668    0.3125 0
  v -8.53921 -24.1718 7.0801    0.654527 0.696552 0.293954    0.3125 0.1125
  v -7.55612 -25.2519 7.49508    0.601008 0.738379 0.305918    0.3125 0.225
  v -6.90651 -26.0745 8.27153    0.534229 0.790809 0.298698    0.3125 0.3375
  v -6.46413 -26.7227 9.27846    0.480722 0.83148 0.278472    0.3125 0.45
  v -6.10274 -27.2794 10.3849    0.463332 0.846936 0.260813    0.3125 0.5625
  v -5.69609 -27.8276 11.4598    0.481703 0.838511 0.25468    0.3125 0.675
  v -5.11795 -28.4504 12.3721    0.518479 0.814932 0.258969    0.3125 0.7875
  v -4.24207 -29.2307 12.991    0.552925 0.777949 0.298444    0.3125 0.9
  v -10.1524 -23.2012 7.99853    0.547096 0.473823 0.690057    0.375 0
  v -8.82376 -24.5093 7.86036    0.493481 0.570622 0.656405    0.375 0.1125
  v -7.9006 -25.4992 8.18009    0.326082 0.692917 0.643068    0.375 0.225
  v -7.27418 -26.2467 8.84044    0.148484 0.808903 0.568883    0.375 0.3375
  v -6.83578 -26.8274 9.7241    0.0357122 0.877672 0.477929    0.375 0.45
  v -6.47666 -27.317 10.7138    0.0290748 0.903297 0.42803    0.375 0.5625
  v -6.08811 -27.7911 11.6921    0.111947 0.892904 0.436109    0.375 0.675
  v -5.56138 -28.3255 12.5419    0.233772 0.838862 0.49159    0.375 0.7875
  v -4.78775 -28.9958 13.1458    0.329335 0.751529 0.571614    0.375 0.9
  v -10.628 -23.912 8.66515    0.354671 0.225581 0.907371    0.4375 0
  v -9.37069 -25.1301 8.48213    0.282449 0.355118 0.891131    0.4375 0.1125
  v -8.46493 -26.0287 8.72945    0.0500753 0.531613 0.845506    0.4375 0.225
  v -7.81958 -26.6839 9.30053    -0.179202 0.682451 0.708624    0.4375 0.3375
  v -7.34349 -27.1721 10.0888    -0.317587 0.762243 0.564025    0.4375 0.45
  v -6.94548 -27.5694 10.9877    -0.342653 0.795162 0.500307    0.4375 0.5625
  v -6.53438 -27.9521 11.8907    -0.269284 0.797677 0.539627    0.4375 0.675
  v -6.01903 -28.3963 12.6911    -0.117272 0.741565 0.660552    0.4375 0.7875
  v -5.30825 -28.9783 13.2825    0.03642 0.627013 0.778157    0.4375 0.9
  v -5.55043 -29.3936 13.4764    -0.130164 0.294665 0.946694    0.5 0.9125
  v -5.37715 -29.5401 13.5326    -0.0376289 0.219554 0.974874    0.5 0.925
  v -5.23429 -29.6653 13.5542    0.0823543 0.120668 0.989271    0.5 0.9375
  v -5.13172 -29.7599 13.5442    0.302097 -0.063204 0.95118    0.5 0.95
  v -5.07935 -29.8143 13.5058    0.714224 -0.477352 0.511879    0.5 0.9625
  v -5.08706 -29.819 13.4421    0.620986 -0.659769 -0.42318    0.5 0.975
  v -5.16474 -29.7645 13.3561    0.338755 -0.47562 -0.811807    0.5 0.9875
  v -5.32228 -29.6412 13.251    0.209633 -0.456052 -0.864911    0.5 1
  v -5.7567 -29.8596 13.5073    -0.324981 0.0242017 0.945411    0.5625 0.9125
  v -5.56653 -29.9913 13.5616    -0.192938 0.00397202 0.981203    0.5625 0.925
  v -5.40445 -30.0915 13.5808    -0.0131019 -0.00779352 0.999884    0.5625 0.9375
  v -5.28276 -30.1547 13.5683    0.303481 -0.0117718 0.952765    0.5625 0.95
  v -5.21377 -30.1754 13.5275    0.842844 -0.027289 0.537465    0.5625 0.9625
  v -5.20978 -30.1482 13.4616    0.939535 -0.0592461 -0.337288    0.5625 0.975
  v -5.28311 -30.0675 13.374    0.641859 -0.0332884 -0.7661    0.5625 0.9875
  v -5.44607 -29.9279 13.268    0.49329 -0.0934939 -0.864826    0.5625 1
  v -5.68243 -30.4049 13.4639    -0.459421 -0.260656 0.849112    0.625 0.9125
  v -5.47624 -30.5294 13.5187    -0.29987 -0.222882 0.927579    0.625 0.925
  v -5.30377 -30.608 13.5398    -0.0797119 -0.146531 0.985989    0.625 0.9375
  v -5.17783 -30.6394 13.53    0.268342 0.00179761 0.963322    0.625 0.95
  v -5.1112 -30.6223 13.4921    0.740184 0.232375 0.630975    0.625 0.9625
  v -5.11667 -30.5554 13.4287    0.926586 0.373068 -0.0475249    0.625 0.975
  v -5.20704 -30.4373 13.3427    0.77406 0.36232 -0.519188    0.625 0.9875
  v -5.39511 -30.2668 13.2368    0.664813 0.282146 -0.691677    0.625 1
  v -5.3905 -30.9692 13.3647    -0.541633 -0.51218 0.666562    0.6875 0.9125
  v -5.17027 -31.0929 13.4221    -0.370316 -0.430516 0.823117    0.6875 0.925
  v -4.99531 -31.1544 13.4484    -0.123834 -0.277398 0.952741    0.6875 0.9375
  v -4.87732 -31.1564 13.4452    0.227195 -0.0190495 0.973663    0.6875 0.95
  v -4.828 -31.1013 13.4141    0.614605 0.31316 0.724011    0.6875 0.9625
  v -4.85903 -30.9918 13.3567    0.80853 0.543572 0.225408    0.6875 0.975
  v -4.98211 -30.8304 13.2746    0.774784 0.597726 -0.205995    0.6875 0.9875
  v -5.20893 -30.6198 13.1695    0.720785 0.552911 -0.418041    0.6875 1
  v -4.94381 -31.4923 13.2283    -0.583676 -0.723965 0.367691    0.75 0.9125
  v -4.71265 -31.6208 13.2898    -0.426092 -0.637501 0.641902    0.75 0.925
  v -4.54214 -31.6708 13.3235    -0.159899 -0.417423 0.894534    0.75 0.9375
  v -4.44164 -31.6482 13.3295    0.190429 -0.0597559 0.979881    0.75 0.95
  v -4.42053 -31.5588 13.3079    0.50597 0.31997 0.801008    0.75 0.9625
  v -4.48816 -31.4085 13.2588    0.674177 0.582229 0.454417    0.75 0.975
  v -4.6539 -31.2032 13.1823    0.703282 0.700319 0.122264    0.75 0.9875
  v -4.92711 -30.9488 13.0785    0.699129 0.709706 -0.0868137    0.75 1
  v -4.40524 -31.9138 13.0733    -0.541049 -0.836006 -0.0914337    0.8125 0.9125
  v -4.16739 -32.0518 13.1397    -0.449051 -0.845184 0.289858    0.8125 0.925
  v -4.00731 -32.0969 13.182    -0.186232 -0.603013 0.775688    0.8125 0.9375
  v -3.93117 -32.0574 13.1987    0.161106 -0.119877 0.97963    0.8125 0.95
  v -3.94514 -31.9413 13.188    0.404465 0.292246 0.866603    0.8125 0.9625
  v -4.05536 -31.7569 13.1485    0.525102 0.545836 0.65294    0.8125 0.975
  v -4.26799 -31.5123 13.0784    0.568444 0.689842 0.44832    0.8125 0.9875
  v -4.5892 -31.2157 12.9762    0.599241 0.748377 0.284328    0.8125 1
  v -3.83769 -32.1735 12.9184    -0.359598 -0.732864 -0.577581    0.875 0.9125
  v -3.5985 -32.3247 12.9899    -0.337909 -0.895913 -0.28837    0.875 0.925
  v -3.45389 -32.3726 13.0411    -0.142065 -0.851299 0.505082    0.875 0.9375
  v -3.40631 -32.3263 13.0685    0.154417 -0.21063 0.965293    0.875 0.95
  v -3.45818 -32.195 13.0689    0.300878 0.238719 0.923301    0.875 0.9625
  v -3.61192 -31.9879 13.0389    0.357185 0.450955 0.81796    0.875 0.975
  v -3.86997 -31.714 12.9754    0.378084 0.575754 0.724955    0.875 0.9875
  v -4.23476 -31.3827 12.8749    0.417476 0.655098 0.629731    0.875 1
  v -3.30403 -32.211 12.7821    -0.120628 -0.487628 -0.864678    0.9375 0.9125
  v -3.06999 -32.3784 12.8585    -0.0763943 -0.644515 -0.760766    0.9375 0.925
  v -2.94496 -32.4377 12.9176    0.163689 -0.986198 0.0248814    0.9375 0.9375
  v -2.92745 -32.3976 12.9546    0.234151 -0.328379 0.915063    0.9375 0.95
  v -3.016 -32.2665 12.9648    0.196616 0.162613 0.966902    0.9375 0.9625
  v -3.20915 -32.0528 12.9434    0.181581 0.312453 0.932417    0.9375 0.975
  v -3.50542 -31.7649 12.8857    0.167558 0.395256 0.903159    0.9375 0.9875
  v -3.90334 -31.4115 12.7869    0.195165 0.465351 0.863342    0.9375 1
  v -2.86717 -31.966 12.683    -0.0159508 -0.346956 -0.937746    1 0.9125
  v -2.64589 -32.1515 12.7634    0.0411826 -0.446757 -0.893707    1 0.925
  v -2.54356 -32.2321 12.8287    0.300387 -0.801534 -0.517021    1 0.9375
  v -2.55497 -32.2137 12.8729    0.42709 -0.526986 0.734765    1 0.95
  v -2.67496 -32.102 12.8903    0.165287 0.10197 0.98096    1 0.9625
  v -2.89834 -31.9027 12.8752    0.103298 0.225636 0.96872    1 0.975
  v -3.21991 -31.6215 12.8219    0.0694342 0.28752 0.955255    1 0.9875
  v -3.63451 -31.2643 12.7246    0.048914 0.317337 0.947051    1 1
  v -2.66089 -31.5 12.6521    0.322968 -0.0030578 -0.946405    0.0625 0.9125
  v -2.45651 -31.7002 12.7345    0.518509 -0.00388238 -0.855063    0.0625 0.925
  v -2.37339 -31.8059 12.802    0.98166 -0.0826123 -0.17181    0.0625 0.9375
  v -2.40394 -31.8189 12.8488    0.549897 -0.112032 0.827685    0.0625 0.95
  v -2.54055 -31.7409 12.8687    0.0233343 -0.0332879 0.999173    0.0625 0.9625
  v -2.77562 -31.5735 12.8558    -0.127595 -0.027545 0.991444    0.0625 0.975
  v -3.10154 -31.3185 12.804    -0.21191 -0.0214182 0.977055    0.0625 0.9875
  v -3.51071 -30.9775 12.7075    -0.20367 0.030813 0.978555    0.0625 1
  v -2.73517 -30.9547 12.6955    0.585801 0.306459 -0.75028    0.125 0.9125
  v -2.54681 -31.1622 12.7773    0.797261 0.352509 -0.490012    0.125 0.925
  v -2.47407 -31.2895 12.843    0.930023 0.296286 0.21742    0.125 0.9375
  v -2.50887 -31.3343 12.887    0.444846 0.0343239 0.894949    0.125 0.95
  v -2.64312 -31.294 12.9041    -0.0433153 -0.150711 0.987628    0.125 0.9625
  v -2.86873 -31.1663 12.8887    -0.265773 -0.23702 0.934444    0.125 0.975
  v -3.17761 -30.9487 12.8354    -0.399651 -0.281306 0.872437    0.125 0.9875
  v -3.56168 -30.6386 12.7388    -0.410457 -0.238901 0.880029    0.125 1
  v -3.02709 -30.3904 12.7947    0.740442 0.5773 -0.344196    0.1875 0.9125
  v -2.85278 -30.5986 12.8739    0.82788 0.560556 0.0197779    0.1875 0.925
  v -2.78253 -30.743 12.9344    0.737933 0.39072 0.550267    0.1875 0.9375
  v -2.80937 -30.8173 12.9719    0.340846 0.0420458 0.939179    0.1875 0.95
  v -2.92632 -30.815 12.9821    -0.0884672 -0.265528 0.960036    0.1875 0.9625
  v -3.12637 -30.7299 12.9607    -0.366682 -0.442634 0.818303    0.1875 0.975
  v -3.40254 -30.5556 12.9035    -0.536639 -0.531911 0.655049    0.1875 0.9875
  v -3.74785 -30.2857 12.8061    -0.575764 -0.511768 0.637643    0.1875 1
  v -3.47378 -29.8673 12.9311    0.70814 0.699315 0.0974492    0.25 0.9125
  v -3.3104 -30.0707 13.0063    0.696771 0.595806 0.399407    0.25 0.925
  v -3.23571 -30.2267 13.0593    0.56938 0.372525 0.732824    0.25 0.9375
  v -3.24506 -30.3255 13.0876    0.275128 0.0096388 0.961359    0.25 0.95
  v -3.33379 -30.3575 13.0882    -0.110311 -0.378599 0.918964    0.25 0.9625
  v -3.49724 -30.3131 13.0585    -0.415111 -0.628023 0.658233    0.25 0.975
  v -3.73075 -30.1828 12.9957    -0.583714 -0.724346 0.366881    0.25 0.9875
  v -4.02967 -29.9567 12.8971    -0.635664 -0.71347 0.294772    0.25 1
  v -4.01235 -29.4458 13.0861    0.562695 0.703096 0.434777    0.3125 0.9125
  v -3.85566 -29.6397 13.1563    0.534335 0.561672 0.631673    0.3125 0.925
  v -3.77053 -29.8005 13.2008    0.441852 0.334261 0.832488    0.3125 0.9375
  v -3.75552 -29.9163 13.2184    0.236407 -0.033804 0.971066    0.3125 0.95
  v -3.80918 -29.975 13.2081    -0.0985847 -0.501884 0.859298    0.3125 0.9625
  v -3.93004 -29.9648 13.1688    -0.396925 -0.797324 0.454671    0.3125 0.975
  v -4.11666 -29.8737 13.0996    -0.53077 -0.846029 0.0501748    0.3125 0.9875
  v -4.36758 -29.6897 12.9994    -0.576383 -0.81457 -0.0652554    0.3125 1
  v -4.57991 -29.1861 13.241    0.360017 0.63988 0.678926    0.375 0.9125
  v -4.42455 -29.3668 13.3061    0.358727 0.497532 0.789796    0.375 0.925
  v -4.32395 -29.5248 13.3417    0.325972 0.287853 0.90049    0.375 0.9375
  v -4.28039 -29.6473 13.3486    0.227374 -0.0775277 0.970716    0.375 0.95
  v -4.29614 -29.7213 13.3273    -0.00567058 -0.643917 0.765075    0.375 0.9625
  v -4.37348 -29.7338 13.2784    -0.263196 -0.947473 0.181719    0.375 0.975
  v -4.51468 -29.672 13.2027    -0.360981 -0.887196 -0.28736    0.375 0.9875
  v -4.72203 -29.5228 13.1007    -0.407143 -0.820755 -0.400743    0.375 1
  v -5.11356 -29.1486 13.3773    0.113514 0.505606 0.855264    0.4375 0.9125
  v -4.95305 -29.3132 13.4375    0.158847 0.387723 0.907986    0.4375 0.925
  v -4.83289 -29.4597 13.4652    0.202813 0.220264 0.954123    0.4375 0.9375
  v -4.75925 -29.576 13.4624    0.259735 -0.0960109 0.960895    0.4375 0.95
  v -4.73832 -29.6498 13.4313    0.293203 -0.726147 0.621886    0.4375 0.9625
  v -4.77625 -29.6689 13.3739    0.0952466 -0.980856 -0.169852    0.4375 0.975
  v -4.87924 -29.621 13.2923    -0.047054 -0.784977 -0.617736    0.4375 0.9875
  v -5.05344 -29.4939 13.1887    -0.128612 -0.71237 -0.689919    0.4375 1
  v -16.0024 -18.5105 21.2841    0.252058 -0.0512846 0.966352    1 1
  v -15.0516 -19.44 20.9049    0.39053 -0.219889 0.893944    1 0.875
  v -14.6396 -19.8775 20.5505    0.656176 -0.618475 0.432345    1 0.75
  v -14.6301 -19.9482 20.2114    0.563916 -0.71446 -0.41418    1 0.625
  v -14.8863 -19.7773 19.878    0.350284 -0.558939 -0.751591    1 0.5
  v -15.2719 -19.4902 19.5409    0.319135 -0.532486 -0.783971    1 0.375
  v -15.6503 -19.212 19.1905    0.437894 -0.629839 -0.641523    1 0.25
  v -15.8848 -19.068 18.8173    0.672568 -0.739992 -0.0079855    1 0.125
  v -15.8391 -19.1836 18.4118    0.679077 -0.682237 0.270936    1 0
  v -15.2585 -19.6289 20.9489    0.359435 -0.223216 0.90608    0.9375 0.875
  v -14.946 -20.1571 20.6156    0.558041 -0.594233 0.579204    0.9375 0.75
  v -14.9557 -20.2453 20.2806    0.543611 -0.800405 -0.252663    0.9375 0.625
  v -15.1786 -20.044 19.9401    0.310501 -0.624191 -0.71692    0.9375 0.5
  v -15.5054 -19.7032 19.5905    0.257551 -0.575214 -0.7764    0.9375 0.375
  v -15.8271 -19.3733 19.2281    0.343591 -0.662076 -0.666033    0.9375 0.25
  v -16.0345 -19.2045 18.8491    0.571156 -0.807819 -0.145635    0.9375 0.125
  v -16.0185 -19.347 18.4499    0.635331 -0.718831 0.282199    0.9375 0
  v -15.4876 -19.7672 21.0013    0.323987 -0.242792 0.914377    0.875 0.875
  v -15.2852 -20.3619 20.6932    0.444113 -0.660063 0.605872    0.875 0.75
  v -15.3163 -20.4631 20.3631    0.378758 -0.900148 -0.215118    0.875 0.625
  v -15.5022 -20.2394 20.0141    0.175906 -0.705074 -0.68697    0.875 0.5
  v -15.7641 -19.8593 19.6497    0.132216 -0.649776 -0.748538    0.875 0.375
  v -16.0232 -19.4915 19.2729    0.201918 -0.7461 -0.63448    0.875 0.25
  v -16.2006 -19.3044 18.8871    0.405778 -0.907561 -0.108059    0.875 0.125
  v -16.2176 -19.4668 18.4955    0.491839 -0.811655 0.315137    0.875 0
  v -15.732 -19.8548 21.0604    0.285778 -0.25494 0.923762    0.8125 0.875
  v -15.6469 -20.4916 20.7807    0.320547 -0.701756 0.63623    0.8125 0.75
  v -15.7009 -20.6009 20.4561    0.198952 -0.964848 -0.171718    0.8125 0.625
  v -15.8474 -20.3631 20.0976    0.029378 -0.757468 -0.652211    0.8125 0.5
  v -16.04 -19.9581 19.7164    -0.00396464 -0.697825 -0.716257    0.8125 0.375
  v -16.2323 -19.5663 19.3235    0.0481496 -0.800055 -0.597991    0.8125 0.25
  v -16.3779 -19.3677 18.93    0.226016 -0.97196 -0.0648959    0.8125 0.125
  v -16.4302 -19.5426 18.5469    0.334767 -0.873626 0.353142    0.8125 0
  v -15.9846 -19.8914 21.1243    0.246253 -0.259377 0.933854    0.75 0.875
  v -16.021 -20.5457 20.8754    0.192193 -0.718014 0.668968    0.75 0.75
  v -16.0985 -20.6584 20.5567    0.0114444 -0.992188 -0.124227    0.75 0.625
  v -16.2043 -20.4147 20.188    -0.123172 -0.779757 -0.613847    0.75 0.5
  v -16.3254 -19.9994 19.7887    -0.145549 -0.718006 -0.680649    0.75 0.375
  v -16.4487 -19.5975 19.3783    -0.111615 -0.822446 -0.557786    0.75 0.25
  v -16.5613 -19.3942 18.9764    0.0389608 -0.999083 -0.0177278    0.75 0.125
  v -16.6502 -19.5743 18.6026    0.170406 -0.902919 0.394586    0.75 0
  v -16.2387 -19.8765 21.1914    0.206687 -0.256008 0.94432    0.6875 0.875
  v -16.3971 -20.5237 20.9746    0.063443 -0.708416 0.702938    0.6875 0.75
  v -16.4984 -20.6351 20.6623    -0.177123 -0.981377 -0.0743352    0.6875 0.625
  v -16.5632 -20.3937 20.2827    -0.276518 -0.771389 -0.573147    0.6875 0.5
  v -16.6123 -19.9826 19.8644    -0.287784 -0.709867 -0.64286    0.6875 0.375
  v -16.6662 -19.5849 19.4357    -0.272058 -0.812779 -0.515146    0.6875 0.25
  v -16.7457 -19.3835 19.0251    -0.149128 -0.988302 0.0319222    0.6875 0.125
  v -16.8714 -19.5615 18.661    0.00422523 -0.898932 0.438068    0.6875 0
  v -16.4872 -19.81 21.2598    0.168395 -0.244852 0.954825    0.625 0.875
  v -16.7651 -20.4253 21.0758    -0.0612269 -0.673128 0.736987    0.625 0.75
  v -16.8896 -20.5305 20.7699    -0.360084 -0.932615 -0.0238367    0.625 0.625
  v -16.9143 -20.2998 20.3793    -0.425441 -0.732433 -0.531547    0.625 0.5
  v -16.8929 -19.9076 19.9416    -0.425934 -0.673443 -0.604198    0.625 0.375
  v -16.879 -19.5281 19.4942    -0.427863 -0.771091 -0.471543    0.625 0.25
  v -16.926 -19.3355 19.0747    -0.331982 -0.939681 0.0823901    0.625 0.125
  v -17.0877 -19.504 18.7205    -0.158477 -0.861596 0.482221    0.625 0
  v -16.7233 -19.6916 21.3276    0.132937 -0.226154 0.964978    0.5625 0.875
  v -17.1146 -20.2499 21.1763    -0.176765 -0.613248 0.769858    0.5625 0.75
  v -17.2612 -20.3441 20.8767    -0.530106 -0.847557 0.0251746    0.5625 0.625
  v -17.2478 -20.1326 20.4751    -0.56409 -0.663954 -0.490884    0.5625 0.5
  v -17.1595 -19.774 20.0182    -0.554597 -0.609619 -0.566381    0.5625 0.375
  v -17.081 -19.427 19.5523    -0.572962 -0.698398 -0.4289    0.5625 0.25
  v -17.0971 -19.25 19.1239    -0.502473 -0.85451 0.131655    0.5625 0.125
  v -17.2928 -19.4016 18.7794    -0.311631 -0.791692 0.525462    0.5625 0
  v -16.9401 -19.5209 21.3932    0.102209 -0.200696 0.974307    0.5 0.875
  v -17.4355 -19.9972 21.2734    -0.277464 -0.531712 0.800185    0.5 0.75
  v -17.6023 -20.0754 20.9799    -0.679224 -0.730563 0.0702252    0.5 0.625
  v -17.5539 -19.8915 20.5678    -0.685846 -0.569072 -0.453621    0.5 0.5
  v -17.4041 -19.5815 20.0922    -0.667541 -0.521183 -0.53175    0.5 0.375
  v -17.2662 -19.2812 19.6083    -0.700344 -0.597957 -0.389827    0.5 0.25
  v -17.2539 -19.1267 19.1713    -0.652429 -0.736826 0.17727    0.5 0.125
  v -17.4807 -19.2538 18.8363    -0.448013 -0.692052 0.565993    0.5 0
  v -17.1203 -19.3098 21.4514    0.0771861 -0.169089 0.982574    0.4375 0.875
  v -17.7023 -19.6847 21.3596    -0.360317 -0.430747 0.827423    0.4375 0.75
  v -17.8859 -19.7433 21.0715    -0.80309 -0.585616 0.110005    0.4375 0.625
  v -17.8085 -19.5934 20.65    -0.786785 -0.450886 -0.421511    0.4375 0.5
  v -17.6074 -19.3433 20.1579    -0.760993 -0.410948 -0.502008    0.4375 0.375
  v -17.4202 -19.1008 19.6581    -0.805798 -0.473086 -0.3562    0.4375 0.25
  v -17.3841 -18.974 19.2134    -0.776848 -0.590938 0.217485    0.4375 0.125
  v -17.6367 -19.0709 18.8867    -0.561777 -0.566912 0.60251    0.4375 0
  v -17.2513 -19.0752 21.4981    0.0587163 -0.132747 0.989409    0.375 0.875
  v -17.8963 -19.3374 21.4286    -0.422455 -0.313956 0.850273    0.375 0.75
  v -18.0921 -19.374 21.1449    -0.89759 -0.416839 0.143451    0.375 0.625
  v -17.9935 -19.2621 20.7158    -0.86362 -0.31323 -0.395029    0.375 0.5
  v -17.7552 -19.0784 20.2105    -0.831828 -0.282767 -0.477603    0.375 0.375
  v -17.5321 -18.9 19.6979    -0.885606 -0.32818 -0.328634    0.375 0.25
  v -17.4788 -18.8039 19.2471    -0.871373 -0.421637 0.250859    0.375 0.125
  v -17.7501 -18.867 18.9271    -0.649682 -0.419966 0.633673    0.375 0
  v -17.3329 -18.8242 21.5327    0.0474732 -0.093461 0.994491    0.3125 0.875
  v -18.0171 -18.9658 21.4799    -0.461106 -0.186911 0.867436    0.3125 0.75
  v -18.2205 -18.979 21.1994    -0.957903 -0.23214 0.168915    0.3125 0.625
  v -18.1087 -18.9075 20.7647    -0.912635 -0.162836 -0.374943    0.3125 0.5
  v -17.8473 -18.795 20.2496    -0.876772 -0.142999 -0.459154    0.3125 0.375
  v -17.6018 -18.6852 19.7275    -0.936058 -0.170351 -0.307856    0.3125 0.25
  v -17.5378 -18.6218 19.2721    -0.931467 -0.237028 0.276021    0.3125 0.125
  v -17.8208 -18.6486 18.9571    -0.707539 -0.258613 0.657654    0.3125 0
  v -17.365 -18.5639 21.5548    0.0437068 -0.0527232 0.997652    0.25 0.875
  v -18.0645 -18.5805 21.5127    -0.475107 -0.0546286 0.878231    0.25 0.75
  v -18.2709 -18.5693 21.2342    -0.981879 -0.0389728 0.185455    0.25 0.625
  v -18.154 -18.5398 20.796    -0.932265 -0.00573657 -0.36173    0.25 0.5
  v -17.8834 -18.501 20.2746    -0.89451 0.00281082 -0.44704    0.25 0.375
  v -17.6292 -18.4623 19.7465    -0.955701 -0.00581481 -0.294281    0.25 0.25
  v -17.5609 -18.4329 19.2882    -0.955304 -0.0443669 0.292278    0.25 0.125
  v -17.8485 -18.4219 18.9763    -0.733692 -0.0893432 0.673583    0.25 0
  v -17.3472 -18.3015 21.5641    0.0474898 -0.01185 0.998801    0.1875 0.875
  v -18.0382 -18.192 21.5264    -0.464122 0.0783565 0.882299    0.1875 0.75
  v -18.243 -18.1563 21.2489    -0.968842 0.155819 0.192526    0.1875 0.625
  v -18.1289 -18.1691 20.8091    -0.922029 0.152693 -0.355735    0.1875 0.5
  v -17.8634 -18.2047 20.2851    -0.884644 0.149773 -0.441558    0.1875 0.375
  v -17.614 -18.2376 19.7544    -0.944106 0.159964 -0.288229    0.1875 0.25
  v -17.5481 -18.2424 19.295    -0.942335 0.149902 0.299222    0.1875 0.125
  v -17.8332 -18.1935 18.9845    -0.727625 0.0822123 0.681031    0.1875 0
  v -17.2794 -18.0441 21.5601    0.0587918 0.0278055 0.997883    0.125 0.875
  v -17.9379 -17.8109 21.5205    -0.428359 0.20743 0.879478    0.125 0.75
  v -18.1363 -17.7512 21.2425    -0.919085 0.345344 0.189791    0.125 0.625
  v -18.0332 -17.8054 20.8035    -0.882083 0.307061 -0.357272    0.125 0.5
  v -17.787 -17.914 20.2806    -0.847293 0.292984 -0.443006    0.125 0.375
  v -17.5561 -18.0173 19.751    -0.901402 0.32148 -0.290044    0.125 0.25
  v -17.4992 -18.0556 19.2921    -0.892715 0.339313 0.296525    0.125 0.125
  v -17.7746 -17.9695 18.9811    -0.689349 0.250575 0.679714    0.125 0
  v -17.1615 -17.7988 21.5424    0.077361 0.0646363 0.994906    0.0625 0.875
  v -17.7633 -17.4478 21.4942    -0.368915 0.327388 0.869896    0.0625 0.75
  v -17.9507 -17.3652 21.2146    -0.83434 0.521989 0.177209    0.0625 0.625
  v -17.8666 -17.459 20.7784    -0.813613 0.45125 -0.366617    0.0625 0.5
  v -17.6539 -17.6371 20.2606    -0.783467 0.426807 -0.451681    0.0625 0.375
  v -17.4554 -17.8074 19.7359    -0.82874 0.472396 -0.300051    0.0625 0.25
  v -17.414 -17.8779 19.2793    -0.807816 0.516473 0.284058    0.0625 0.125
  v -17.6725 -17.7564 18.9658    -0.61968 0.409498 0.669559    0.0625 0
  v -16.9932 -17.5728 21.5105    0.105566 0.0615215 0.992507    0 0.875
  v -17.5141 -17.1132 21.447    -0.222971 0.297163 0.928428    0 0.75
  v -17.6859 -17.0095 21.1644    -0.737916 0.594643 0.319187    0 0.625
  v -17.629 -17.1398 20.7334    -0.7769 0.530753 -0.338716    0 0.5
  v -17.464 -17.3821 20.2246    -0.741717 0.48722 -0.460947    0 0.375
  v -17.3117 -17.6143 19.7086    -0.773742 0.526151 -0.35283    0 0.25
  v -17.2924 -17.7144 19.2563    -0.788075 0.603432 0.121686    0 0.125
  v -17.5269 -17.5605 18.9382    -0.557917 0.507425 0.656695    0 0
  v -16.7862 -17.384 21.4665    0.133412 0.122943 0.983405    0.9375 0.875
  v -17.2077 -16.8336 21.3819    -0.189605 0.519273 0.83331    0.9375 0.75
  v -17.3602 -16.7123 21.0952    -0.576928 0.807185 0.124928    0.9375 0.625
  v -17.3367 -16.8731 20.6713    -0.604161 0.683937 -0.408924    0.9375 0.5
  v -17.2305 -17.169 20.1749    -0.58818 0.642485 -0.49118    0.9375 0.375
  v -17.1348 -17.453 19.6711    -0.607277 0.715726 -0.344894    0.9375 0.25
  v -17.1427 -17.578 19.2245    -0.548644 0.803237 0.231947    0.9375 0.125
  v -17.3475 -17.397 18.9    -0.398544 0.670654 0.625608    0.9375 0
  v -16.5571 -17.2456 21.4141    0.168907 0.142512 0.975275    0.875 0.875
  v -16.8686 -16.6288 21.3043    -0.0754607 0.58506 0.807472    0.875 0.75
  v -16.9996 -16.4946 21.0127    -0.412153 0.906943 0.0870819    0.875 0.625
  v -17.0131 -16.6778 20.5972    -0.46999 0.764905 -0.440488    0.875 0.5
  v -16.9718 -17.0129 20.1158    -0.463276 0.71713 -0.520672    0.875 0.375
  v -16.9388 -17.3348 19.6262    -0.466063 0.799841 -0.378205    0.875 0.25
  v -16.9767 -17.478 19.1865    -0.38339 0.903009 0.193871    0.875 0.125
  v -17.1484 -17.2773 18.8545    -0.254837 0.763435 0.593485    0.875 0
  v -16.3128 -17.158 21.355    0.207148 0.154653 0.966008    0.8125 0.875
  v -16.5068 -16.4991 21.2168    0.048272 0.626719 0.777749    0.8125 0.75
  v -16.615 -16.3567 20.9197    -0.232383 0.971649 0.0435553    0.8125 0.625
  v -16.6679 -16.5541 20.5138    -0.323792 0.817369 -0.476516    0.8125 0.5
  v -16.6959 -16.9141 20.049    -0.327431 0.765247 -0.554243    0.8125 0.375
  v -16.7296 -17.26 19.5756    -0.312667 0.85387 -0.416107    0.8125 0.25
  v -16.7994 -17.4147 19.1436    -0.203785 0.967436 0.15013    0.8125 0.125
  v -16.9358 -17.2014 18.803    -0.0976005 0.825376 0.556083    0.8125 0
  v -16.0601 -17.1215 21.291    0.246677 0.159088 0.955951    0.75 0.875
  v -16.1328 -16.445 21.1221    0.176687 0.642963 0.745239    0.75 0.75
  v -16.2174 -16.2992 20.8191    -0.0448575 0.998986 -0.00387166    0.75 0.625
  v -16.311 -16.5025 20.4234    -0.171361 0.83968 -0.515337    0.75 0.5
  v -16.4106 -16.8729 19.9768    -0.185967 0.785454 -0.590321    0.75 0.375
  v -16.5132 -17.2287 19.5208    -0.153035 0.876289 -0.456834    0.75 0.25
  v -16.616 -17.3883 19.0971    -0.0168165 0.994579 0.10262    0.75 0.125
  v -16.7158 -17.1697 18.7473    0.0668122 0.854657 0.514877    0.75 0
  v -15.8061 -17.1363 21.224    0.286224 0.155724 0.945424    0.6875 0.875
  v -15.7566 -16.467 21.0229    0.305373 0.633379 0.71104    0.6875 0.75
  v -15.8175 -16.3226 20.7135    0.143774 0.988162 -0.0535174    0.6875 0.625
  v -15.9521 -16.5234 20.3287    -0.017891 0.831287 -0.555556    0.6875 0.5
  v -16.1237 -16.8896 19.9011    -0.0436078 0.777289 -0.62763    0.6875 0.375
  v -16.2957 -17.2414 19.4634    0.00754195 0.866595 -0.498955    0.6875 0.25
  v -16.4315 -17.3989 19.0485    0.17128 0.983796 0.0530025    0.6875 0.125
  v -16.4946 -17.1825 18.689    0.232964 0.850675 0.471254    0.6875 0
  v -15.5575 -17.2028 21.1556    0.324484 0.144575 0.934777    0.625 0.875
  v -15.3887 -16.5654 20.9217    0.429879 0.598123 0.676352    0.625 0.75
  v -15.4263 -16.4272 20.6059    0.326828 0.939381 -0.103666    0.625 0.625
  v -15.601 -16.6173 20.2321    0.131371 0.792263 -0.59587    0.625 0.5
  v -15.843 -16.9646 19.8239    0.0948795 0.740796 -0.664995    0.625 0.375
  v -16.0829 -17.2981 19.4049    0.163714 0.824833 -0.541155    0.625 0.25
  v -16.2512 -17.4469 18.9989    0.354227 0.935155 0.00289467    0.625 0.125
  v -16.2783 -17.24 18.6295    0.395532 0.813367 0.426602    0.625 0
  v -15.3214 -17.3213 21.0878    0.359902 0.125884 0.924459    0.5625 0.875
  v -15.0391 -16.7408 20.8212    0.545201 0.538289 0.642652    0.5625 0.75
  v -15.0548 -16.6136 20.4991    0.496923 0.854309 -0.152397    0.5625 0.625
  v -15.2675 -16.7845 20.1363    0.270439 0.723699 -0.63492    0.5625 0.5
  v -15.5765 -17.0982 19.7473    0.223969 0.676886 -0.701187    0.5625 0.375
  v -15.881 -17.3993 19.3469    0.309269 0.752046 -0.582048    0.5625 0.25
  v -16.0801 -17.5325 18.9497    0.524853 0.849957 -0.0458558    0.5625 0.125
  v -16.0732 -17.3425 18.5705    0.548481 0.743505 0.382581    0.5625 0
  v -15.1047 -17.492 21.0222    0.390608 0.100433 0.915062    0.5 0.875
  v -14.7182 -16.9935 20.7241    0.645769 0.456779 0.611829    0.5 0.75
  v -14.7136 -16.8822 20.3959    0.646013 0.737321 -0.197547    0.5 0.625
  v -14.9613 -17.0256 20.0436    0.392421 0.628771 -0.671307    0.5 0.5
  v -15.3319 -17.2908 19.6733    0.337146 0.588402 -0.734926    0.5 0.375
  v -15.6957 -17.5451 19.2908    0.436904 0.651555 -0.620155    0.5 0.25
  v -15.9233 -17.6558 18.9023    0.674933 0.732247 -0.0909942    0.5 0.125
  v -15.8853 -17.4902 18.5137    0.684704 0.643896 0.341436    0.5 0
  v -14.9244 -17.703 20.9639    0.415662 0.0688196 0.906912    0.4375 0.875
  v -14.4514 -17.306 20.6379    0.728753 0.355789 0.585092    0.4375 0.75
  v -14.43 -17.2144 20.3043    0.769772 0.592394 -0.23774    0.4375 0.625
  v -14.7068 -17.3237 19.9614    0.493123 0.510633 -0.704333    0.4375 0.5
  v -15.1285 -17.529 19.6076    0.430358 0.478218 -0.765571    0.4375 0.375
  v -15.5418 -17.7255 19.2411    0.542111 0.526734 -0.654727    0.4375 0.25
  v -15.7931 -17.8085 18.8602    0.799362 0.586357 -0.131171    0.4375 0.125
  v -15.7293 -17.6732 18.4633    0.798565 0.518736 0.305296    0.4375 0
  v -14.7934 -17.9377 20.9173    0.434177 0.0324642 0.900242    0.375 0.875
  v -14.2574 -17.6533 20.5689    0.791109 0.238952 0.56307    0.375 0.75
  v -14.2238 -17.5837 20.2309    0.864193 0.423633 -0.271486    0.375 0.625
  v -14.5218 -17.6551 19.8956    0.569537 0.373061 -0.732429    0.375 0.5
  v -14.9807 -17.7938 19.555    0.500771 0.350121 -0.791608    0.375 0.375
  v -15.4298 -17.9262 19.2012    0.621459 0.381922 -0.684051    0.375 0.25
  v -15.6985 -17.9785 18.8265    0.893758 0.417082 -0.165044    0.375 0.125
  v -15.6159 -17.8771 18.4229    0.886684 0.371746 0.274949    0.375 0
  v -14.7118 -18.1887 20.8827    0.445451 -0.00682917 0.895281    0.3125 0.875
  v -14.1366 -18.0249 20.5176    0.829925 0.111873 0.546543    0.3125 0.75
  v -14.0954 -17.9787 20.1764    0.924473 0.238942 -0.297079    0.3125 0.625
  v -14.4065 -18.0097 19.8467    0.61822 0.222738 -0.753785    0.3125 0.5
  v -14.8886 -18.0773 19.5159    0.545377 0.210423 -0.811348    0.3125 0.375
  v -15.3601 -18.1411 19.1717    0.671543 0.224169 -0.706242    0.3125 0.25
  v -15.6395 -18.1606 18.8015    0.953699 0.232508 -0.190784    0.3125 0.125
  v -15.5452 -18.0955 18.3929    0.9447 0.210362 0.251576    0.3125 0
  v -14.6798 -18.4489 20.8605    0.449225 -0.0475641 0.892152    0.25 0.875
  v -14.0892 -18.4102 20.4848    0.843985 -0.0204204 0.535977    0.25 0.75
  v -14.045 -18.3884 20.1416    0.948467 0.0457711 -0.313553    0.25 0.625
  v -14.3613 -18.3774 19.8154    0.637732 0.0656604 -0.767454    0.25 0.5
  v -14.8525 -18.3712 19.4909    0.562993 0.0646386 -0.82393    0.25 0.375
  v -15.3328 -18.364 19.1527    0.69105 0.0596605 -0.72034    0.25 0.25
  v -15.6163 -18.3496 18.7854    0.977447 0.0398659 -0.207384    0.25 0.125
  v -15.5175 -18.3221 18.3736    0.970913 0.0410829 0.235881    0.25 0
  v -14.6975 -18.7113 20.8512    0.445426 -0.0884319 0.890941    0.1875 0.875
  v -14.1155 -18.7987 20.4711    0.83294 -0.153392 0.531679    0.1875 0.75
  v -14.0729 -18.8014 20.1269    0.935494 -0.149034 -0.320375    0.1875 0.625
  v -14.3864 -18.7481 19.8022    0.627621 -0.0927965 -0.772969    0.1875 0.5
  v -14.8725 -18.6676 19.4804    0.553252 -0.082351 -0.828933    0.1875 0.375
  v -15.3479 -18.5886 19.1447    0.67959 -0.106148 -0.725872    0.1875 0.25
  v -15.6291 -18.5401 18.7786    0.964486 -0.15441 -0.214298    0.1875 0.125
  v -15.5328 -18.5506 18.3655    0.964811 -0.130468 0.228294    0.1875 0
  v -14.7653 -18.9687 20.8553    0.434087 -0.128084 0.891719    0.125 0.875
  v -14.2158 -19.1798 20.477    0.797009 -0.282435 0.533861    0.125 0.75
  v -14.1796 -19.2065 20.1332    0.885827 -0.338579 -0.317292    0.125 0.625
  v -14.4821 -19.1117 19.8079    0.588011 -0.247231 -0.770143    0.125 0.5
  v -14.949 -18.9582 19.4849    0.51624 -0.225631 -0.826188    0.125 0.375
  v -15.4058 -18.809 19.1481    0.637252 -0.267741 -0.722651    0.125 0.25
  v -15.6781 -18.7268 18.7815    0.91496 -0.343841 -0.211239    0.125 0.125
  v -15.5914 -18.7745 18.3689    0.926404 -0.298806 0.229109    0.125 0
  v -14.8833 -19.214 20.873    0.415476 -0.164905 0.894531    0.0625 0.875
  v -14.3904 -19.5429 20.5033    0.737351 -0.402349 0.542613    0.0625 0.75
  v -14.3652 -19.5925 20.1612    0.801155 -0.51524 -0.304433    0.0625 0.625
  v -14.6486 -19.4581 19.833    0.519961 -0.391507 -0.759186    0.0625 0.5
  v -15.082 -19.2351 19.5049    0.452838 -0.359541 -0.815885    0.0625 0.375
  v -15.5065 -19.0188 19.1633    0.565047 -0.418747 -0.710896    0.0625 0.25
  v -15.7632 -18.9046 18.7943    0.830195 -0.521029 -0.198256    0.0625 0.125
  v -15.6935 -18.9876 18.3842    0.856531 -0.457688 0.238487    0.0625 0
  v -15.4727 -19.593 17.9853    0.438103 -0.281802 0.853612    1 0.875
  v -14.8926 -20.1959 17.5582    0.37531 -0.20092 0.904861    1 0.75
  v -14.1831 -20.9151 17.1349    0.350221 -0.16957 0.92119    1 0.625
  v -13.4288 -21.6734 16.7196    0.348002 -0.16682 0.922532    1 0.5
  v -12.7141 -22.3937 16.3167    0.369387 -0.193473 0.908912    1 0.375
  v -12.1233 -22.9988 15.9304    0.433969 -0.276359 0.857495    1 0.25
  v -11.7409 -23.4115 15.565    0.610497 -0.53364 0.585254    1 0.125
  v -11.6514 -23.5547 15.2248    0.655606 -0.618696 0.432893    1 0
  v -15.746 -19.842 18.0433    0.430379 -0.321951 0.84328    0.9375 0.875
  v -15.3019 -20.5688 17.6452    0.366782 -0.22173 0.903497    0.9375 0.75
  v -14.7536 -21.4348 17.2561    0.340383 -0.182022 0.922501    0.9375 0.625
  v -14.1689 -22.3476 16.8769    0.335065 -0.174857 0.925828    0.9375 0.5
  v -13.6153 -23.2148 16.5082    0.349467 -0.198375 0.915708    0.9375 0.375
  v -13.1605 -23.9437 16.1508    0.39687 -0.276597 0.875208    0.9375 0.25
  v -12.8721 -24.442 15.8054    0.527985 -0.522108 0.669802    0.9375 0.125
  v -12.8176 -24.6171 15.4727    0.616267 -0.650866 0.443383    0.9375 0
  v -16.0493 -20.0245 18.1128    0.373933 -0.356107 0.856365    0.875 0.875
  v -15.756 -20.842 17.7491    0.331393 -0.242963 0.911673    0.875 0.75
  v -15.3867 -21.8157 17.401    0.313293 -0.198153 0.928754    0.875 0.625
  v -14.9902 -22.8417 17.0649    0.309485 -0.189967 0.931736    0.875 0.5
  v -14.6155 -23.8165 16.7372    0.319017 -0.216215 0.922756    0.875 0.375
  v -14.3115 -24.6362 16.4143    0.35013 -0.303769 0.886078    0.875 0.25
  v -14.1273 -25.1971 16.0927    0.429397 -0.579263 0.692873    0.875 0.125
  v -14.1117 -25.3956 15.7689    0.488276 -0.733378 0.473014    0.875 0
  v -16.3733 -20.1401 18.1911    0.312716 -0.37823 0.871293    0.8125 0.875
  v -16.2411 -21.0151 17.8665    0.293057 -0.256665 0.921    0.8125 0.75
  v -16.0627 -22.0569 17.5646    0.283974 -0.208525 0.935883    0.8125 0.625
  v -15.8672 -23.1547 17.277    0.281823 -0.199644 0.938466    0.8125 0.5
  v -15.6835 -24.1976 16.9955    0.286117 -0.227591 0.930774    0.8125 0.375
  v -15.5407 -25.0747 16.7116    0.299668 -0.321021 0.898413    0.8125 0.25
  v -15.4678 -25.6754 16.417    0.322919 -0.615425 0.71901    0.8125 0.125
  v -15.4938 -25.8887 16.1032    0.348328 -0.788354 0.507115    0.8125 0
  v -16.7084 -20.1883 18.276    0.249078 -0.387847 0.887432    0.75 0.875
  v -16.7429 -21.0873 17.9935    0.253236 -0.262553 0.931095    0.75 0.75
  v -16.7622 -22.1576 17.7417    0.253543 -0.21293 0.943598    0.75 0.625
  v -16.7747 -23.2853 17.5068    0.253131 -0.203696 0.945745    0.75 0.5
  v -16.7886 -24.3567 17.2753    0.252009 -0.232279 0.939435    0.75 0.375
  v -16.8125 -25.2578 17.0337    0.247376 -0.328007 0.911711    0.75 0.25
  v -16.8547 -25.8751 16.7682    0.212557 -0.629775 0.74713    0.75 0.125
  v -16.9237 -26.0946 16.4653    0.201997 -0.814321 0.544131    0.75 0
  v -17.0454 -20.1688 18.3649    0.184993 -0.384813 0.904266    0.6875 0.875
  v -17.2475 -21.0582 18.1267    0.213158 -0.260543 0.941637    0.6875 0.75
  v -17.4656 -22.117 17.9273    0.222927 -0.211302 0.951659    0.6875 0.625
  v -17.6871 -23.2326 17.7476    0.224281 -0.202061 0.953346    0.6875 0.5
  v -17.8998 -24.2925 17.5686    0.217734 -0.23021 0.94847    0.6875 0.375
  v -18.0913 -25.184 17.3711    0.194852 -0.324621 0.925556    0.6875 0.25
  v -18.2493 -25.7945 17.1362    0.101763 -0.622059 0.77633    0.6875 0.125
  v -18.3614 -26.0115 16.8447    0.0540375 -0.810814 0.582804    0.6875 0
  v -17.3748 -20.0813 18.4555    0.122416 -0.369093 0.921295    0.625 0.875
  v -17.7409 -20.927 18.2623    0.174043 -0.250614 0.952314    0.625 0.75
  v -18.1532 -21.9342 18.1163    0.193062 -0.203625 0.959825    0.625 0.625
  v -18.5791 -22.9954 17.9929    0.196154 -0.194727 0.961044    0.625 0.5
  v -18.9861 -24.0036 17.8673    0.184337 -0.221365 0.95761    0.625 0.375
  v -19.3415 -24.8516 17.7149    0.143711 -0.310841 0.939534    0.625 0.25
  v -19.6127 -25.432 17.5111    -0.00595643 -0.592277 0.805713    0.625 0.125
  v -19.7671 -25.6378 17.2312    -0.0909294 -0.77776 0.62195    0.625 0
  v -17.6874 -19.9251 18.5453    0.0636884 -0.340914 0.937935    0.5625 0.875
  v -18.2089 -20.6933 18.3968    0.137353 -0.232901 0.962752    0.5625 0.75
  v -18.8055 -21.6083 18.3038    0.16507 -0.190007 0.967806    0.5625 0.625
  v -19.4254 -22.5727 18.236    0.169812 -0.181796 0.968563    0.5625 0.5
  v -20.0167 -23.4889 18.1634    0.15309 -0.205874 0.96653    0.5625 0.375
  v -20.5276 -24.2592 18.0557    0.0959127 -0.286882 0.953153    0.5625 0.25
  v -20.9062 -24.786 17.8827    -0.106417 -0.541023 0.834248    0.5625 0.125
  v -21.1006 -24.9717 17.6143    -0.227556 -0.715736 0.660257    0.5625 0
  v -17.9736 -19.7001 18.6319    0.0118014 -0.301282 0.953462    0.5 0.875
  v -18.6375 -20.3563 18.5265    0.104966 -0.208023 0.972475    0.5 0.75
  v -19.4029 -21.1386 18.4845    0.140388 -0.170924 0.975231    0.5 0.625
  v -20.2005 -21.9634 18.4705    0.146619 -0.163726 0.975549    0.5 0.5
  v -20.9606 -22.7469 18.449    0.125618 -0.184296 0.97481    0.5 0.375
  v -21.6139 -23.4052 18.3843    0.0539573 -0.253633 0.965794    0.5 0.25
  v -22.0908 -23.8547 18.2411    -0.19446 -0.470441 0.860738    0.5 0.125
  v -22.3219 -24.0116 17.9839    -0.349298 -0.627078 0.69625    0.5 0
  v -18.2112 -19.4213 18.7087    -0.0309616 -0.25154 0.967352    0.4375 0.875
  v -18.9933 -19.9389 18.6415    0.0783066 -0.176804 0.981126    0.4375 0.75
  v -19.8989 -20.5568 18.6448    0.120092 -0.146997 0.98182    0.4375 0.625
  v -20.8439 -21.2086 18.6784    0.127566 -0.141097 0.981743    0.4375 0.5
  v -21.7442 -21.8276 18.7021    0.103075 -0.157313 0.982155    0.4375 0.375
  v -22.5157 -22.3473 18.6757    0.019565 -0.21214 0.977043    0.4375 0.25
  v -23.0742 -22.701 18.5589    -0.266747 -0.38278 0.884492    0.4375 0.125
  v -23.3358 -22.8222 18.3114    -0.450661 -0.515422 0.728866    0.4375 0
  v -18.384 -19.1107 18.7702    -0.0632547 -0.193703 0.979019    0.375 0.875
  v -19.2521 -19.4737 18.7336    0.0582252 -0.140548 0.98836    0.375 0.75
  v -20.2596 -19.9085 18.7733    0.104835 -0.119247 0.987314    0.375 0.625
  v -21.3118 -20.3676 18.8451    0.113276 -0.114892 0.986898    0.375 0.5
  v -22.3139 -20.8034 18.9051    0.08621 -0.126112 0.988263    0.375 0.375
  v -23.1713 -21.1686 18.9093    -0.00610517 -0.164239 0.986402    0.375 0.25
  v -23.7893 -21.4156 18.8136    -0.320701 -0.281713 0.904317    0.375 0.125
  v -24.073 -21.497 18.5741    -0.528726 -0.3843 0.756811    0.375 0
  v -18.4917 -18.778 18.816    -0.0838353 -0.130791 0.987859    0.3125 0.875
  v -19.4133 -18.9755 18.8021    0.0454766 -0.101151 0.993831    0.3125 0.75
  v -20.4843 -19.214 18.8687    0.0951856 -0.0891179 0.991462    0.3125 0.625
  v -21.6033 -19.4666 18.9689    0.104277 -0.0864668 0.990782    0.3125 0.5
  v -22.6689 -19.7062 19.0559    0.0756367 -0.0923015 0.992854    0.3125 0.375
  v -23.5799 -19.9058 19.0829    -0.0221215 -0.11237 0.99342    0.3125 0.25
  v -24.2348 -20.0385 19.0029    -0.354237 -0.172244 0.919156    0.3125 0.125
  v -24.5324 -20.0772 18.7692    -0.579977 -0.240491 0.778325    0.3125 0
  v -18.534 -18.4327 18.8453    -0.0922895 -0.0652285 0.993593    0.25 0.875
  v -19.4766 -18.4585 18.8461    0.0403078 -0.0601296 0.997376    0.25 0.75
  v -20.5725 -18.4934 18.93    0.0913275 -0.0577656 0.994144    0.25 0.625
  v -21.7177 -18.5317 19.0484    0.100738 -0.0569039 0.993284    0.25 0.5
  v -22.8083 -18.5678 19.1527    0.0715531 -0.0571597 0.995798    0.25 0.375
  v -23.7403 -18.5957 19.1942    -0.0281843 -0.0584876 0.99789    0.25 0.25
  v -24.4098 -18.6097 19.1244    -0.366637 -0.0585122 0.928522    0.25 0.125
  v -24.7127 -18.6041 18.8944    -0.603117 -0.0897649 0.792586    0.25 0
  v -18.5106 -18.0847 18.8577    -0.0885028 0.000947413 0.996075    0.1875 0.875
  v -19.4416 -17.9373 18.8646    0.0427869 -0.018742 0.998908    0.1875 0.75
  v -20.5237 -17.7669 18.9558    0.0933108 -0.0261498 0.995294    0.1875 0.625
  v -21.6544 -17.5893 19.0819    0.102704 -0.0271088 0.994342    0.1875 0.5
  v -22.7312 -17.4201 19.1935    0.074014 -0.0217582 0.99702    0.1875 0.375
  v -23.6516 -17.2748 19.2412    -0.0242106 -0.00423882 0.999698    0.1875 0.25
  v -24.313 -17.1693 19.1756    -0.35771 0.0559198 0.932157    0.1875 0.125
  v -24.613 -17.1191 18.9472    -0.597769 0.0629701 0.799191    0.1875 0
  v -18.4213 -17.7435 18.8525    -0.0724702 0.065716 0.995203    0.125 0.875
  v -19.3079 -17.4264 18.8568    0.0529175 0.0217523 0.998362    0.125 0.75
  v -20.3374 -17.0548 18.945    0.101141 0.00477127 0.994861    0.125 0.625
  v -21.4127 -16.6655 19.0679    0.11018 0.0020133 0.99391    0.125 0.5
  v -22.4368 -16.295 19.1764    0.0830195 0.01282 0.996465    0.125 0.375
  v -23.3128 -15.98 19.2215    -0.0101997 0.0487089 0.998761    0.125 0.25
  v -23.9435 -15.7573 19.1541    -0.327497 0.167435 0.929898    0.125 0.125
  v -24.2321 -15.6633 18.9251    -0.563924 0.212947 0.797899    0.125 0
  v -18.2658 -17.4188 18.8292    -0.0444296 0.126669 0.99095    0.0625 0.875
  v -19.0751 -16.9402 18.8219    0.0705518 0.0598423 0.995712    0.0625 0.75
  v -20.0129 -16.3772 18.8963    0.1147 0.033836 0.992824    0.0625 0.625
  v -20.9917 -15.7864 19.0047    0.123053 0.0293662 0.991965    0.0625 0.5
  v -21.9242 -15.2244 19.0995    0.0984337 0.0452667 0.994114    0.0625 0.375
  v -22.7228 -14.748 19.133    0.0136224 0.0983365 0.99506    0.0625 0.25
  v -23.3002 -14.4137 19.0576    -0.276599 0.271727 0.921768    0.0625 0.125
  v -23.5688 -14.2781 18.8256    -0.502176 0.354664 0.78869    0.0625 0
  v -18.0439 -17.1204 18.7871    -0.0514062 0.176686 0.982924    0 0.875
  v -18.7428 -16.4933 18.759    0.0717177 0.0866524 0.993654    0 0.75
  v -19.5497 -15.7543 18.8086    0.11956 0.0507811 0.991527    0 0.625
  v -20.3909 -14.9783 18.8909    0.131752 0.0415594 0.990411    0 0.5
  v -21.1925 -14.2403 18.9609    0.114024 0.0549583 0.991957    0 0.375
  v -21.8807 -13.6154 18.9735    0.0466484 0.105249 0.993351    0 0.25
  v -22.3818 -13.1786 18.8836    -0.177676 0.26559 0.947572    0 0.125
  v -22.622 -13.0047 18.6462    -0.447803 0.442409 0.777011    0 0
  v -17.7706 -16.8714 18.7291    0.0434434 0.22555 0.973263    0.9375 0.875
  v -18.3335 -16.1204 18.672    0.125702 0.121532 0.984596    0.9375 0.75
  v -18.9792 -15.2346 18.6873    0.15698 0.0808318 0.984288    0.9375 0.625
  v -19.6508 -14.3041 18.7336    0.163057 0.073513 0.983874    0.9375 0.5
  v -20.2912 -13.4193 18.7694    0.146163 0.0975373 0.98444    0.9375 0.375
  v -20.8435 -12.6705 18.7531    0.0870761 0.178137 0.980145    0.9375 0.25
  v -21.2507 -12.1481 18.6432    -0.121096 0.439326 0.890128    0.9375 0.125
  v -21.4558 -11.9424 18.3984    -0.305134 0.587566 0.74944    0.9375 0
  v -17.4673 -16.6889 18.6596    0.0999742 0.259689 0.960503    0.875 0.875
  v -17.8793 -15.8472 18.568    0.161127 0.142758 0.976554    0.875 0.75
  v -18.3462 -14.8537 18.5424    0.184088 0.0969587 0.978116    0.875 0.625
  v -18.8295 -13.81 18.5456    0.188655 0.0886192 0.978037    0.875 0.5
  v -19.2911 -12.8176 18.5404    0.176639 0.115372 0.977491    0.875 0.375
  v -19.6925 -11.978 18.4896    0.133874 0.205297 0.9695    0.875 0.25
  v -19.9955 -11.3929 18.3559    -0.0223199 0.496443 0.867782    0.875 0.125
  v -20.1617 -11.1638 18.1022    -0.176839 0.670016 0.720976    0.875 0
  v -17.1434 -16.5733 18.5813    0.161257 0.281799 0.945825    0.8125 0.875
  v -17.3943 -15.6741 18.4507    0.199493 0.156454 0.967329    0.8125 0.75
  v -17.6701 -14.6125 18.3789    0.213424 0.107328 0.971046    0.8125 0.625
  v -17.9525 -13.4971 18.3335    0.21633 0.0982932 0.97136    0.8125 0.5
  v -18.223 -12.4365 18.2821    0.209558 0.126745 0.969547    0.8125 0.375
  v -18.4633 -11.5395 18.1922    0.18438 0.222539 0.95733    0.8125 0.25
  v -18.655 -10.9147 18.0316    0.084296 0.532576 0.842174    0.8125 0.125
  v -18.7797 -10.6707 17.7679    -0.0366406 0.724941 0.687836    0.8125 0
  v -16.8083 -16.5251 18.4964    0.224917 0.291412 0.92978    0.75 0.875
  v -16.8925 -15.6019 18.3236    0.239321 0.162342 0.957273    0.75 0.75
  v -16.9706 -14.5118 18.2018    0.243863 0.111731 0.963352    0.75 0.625
  v -17.0451 -13.3664 18.1037    0.245028 0.102344 0.964099    0.75 0.5
  v -17.1179 -12.2774 18.0023    0.243671 0.131432 0.960911    0.75 0.375
  v -17.1915 -11.3564 17.8702    0.236686 0.229523 0.944086    0.75 0.25
  v -17.268 -10.715 17.6805    0.194704 0.546916 0.814231    0.75 0.125
  v -17.3498 -10.4648 17.4058    0.109801 0.750884 0.651242    0.75 0
  v -16.4713 -16.5446 18.4075    0.288982 0.288381 0.912867    0.6875 0.875
  v -16.3879 -15.631 18.1905    0.279388 0.160334 0.946697    0.6875 0.75
  v -16.2673 -14.5524 18.0162    0.274471 0.110104 0.955271    0.6875 0.625
  v -16.1326 -13.4191 17.8629    0.273873 0.10071 0.956478    0.6875 0.5
  v -16.0068 -12.3416 17.709    0.27794 0.129363 0.951848    0.6875 0.375
  v -15.9127 -11.4303 17.5327    0.289193 0.226141 0.930176    0.6875 0.25
  v -15.8734 -10.7955 17.3124    0.305445 0.539211 0.784828    0.6875 0.125
  v -15.912 -10.5479 17.0264    0.257708 0.747389 0.612369    0.6875 0
  v -16.1418 -16.6321 18.3169    0.3515 0.272672 0.895599    0.625 0.875
  v -15.8945 -15.7622 18.0548    0.31848 0.150409 0.935921    0.625 0.75
  v -15.5797 -14.7352 17.8271    0.30432 0.102432 0.947046    0.625 0.625
  v -15.2406 -13.6563 17.6177    0.301986 0.093379 0.948728    0.625 0.5
  v -14.9204 -12.6304 17.4103    0.311317 0.120521 0.942632    0.625 0.375
  v -14.6625 -11.7626 17.189    0.340289 0.21237 0.916025    0.625 0.25
  v -14.51 -11.158 16.9376    0.413021 0.509459 0.754894    0.625 0.125
  v -14.5063 -10.9216 16.6399    0.40247 0.714376 0.572437    0.625 0
  v -15.8293 -16.7882 18.2271    0.410141 0.244512 0.878634    0.5625 0.875
  v -15.4265 -15.996 17.9204    0.355136 0.132702 0.925348    0.5625 0.75
  v -14.9274 -15.0611 17.6397    0.332293 0.0888172 0.938985    0.5625 0.625
  v -14.3943 -14.079 17.3745    0.328309 0.0804513 0.941138    0.5625 0.5
  v -13.8898 -13.1452 17.1142    0.342538 0.105037 0.933614    0.5625 0.375
  v -13.4764 -12.3551 16.8482    0.388028 0.188422 0.902182    0.5625 0.25
  v -13.2166 -11.8041 16.5659    0.513293 0.458244 0.725633    0.5625 0.125
  v -13.1728 -11.5877 16.2568    0.538795 0.652415 0.532968    0.5625 0
  v -15.543 -17.0133 18.1405    0.461973 0.204892 0.862902    0.5 0.875
  v -14.9979 -16.3329 17.7907    0.387499 0.10783 0.915542    0.5 0.75
  v -14.3299 -15.5308 17.4589    0.356961 0.0697367 0.931513    0.5 0.625
  v -13.6192 -14.6883 17.14    0.351492 0.0623837 0.93411    0.5 0.5
  v -12.946 -13.8872 16.8286    0.369996 0.083461 0.925277    0.5 0.375
  v -12.3902 -13.209 16.5195    0.429951 0.155181 0.889416    0.5 0.25
  v -12.032 -12.7354 16.2075    0.601229 0.387683 0.698732    0.5 0.125
  v -11.9515 -12.5478 15.8872    0.660309 0.563803 0.496103    0.5 0
  v -15.3054 -17.292 18.0637    0.504784 0.155138 0.849191    0.4375 0.875
  v -14.642 -16.7504 17.6757    0.414178 0.0766069 0.906966    0.4375 0.75
  v -13.8339 -16.1126 17.2987    0.37727 0.0458076 0.92497    0.4375 0.625
  v -12.9758 -15.4431 16.9321    0.370556 0.039753 0.927959    0.4375 0.5
  v -12.1624 -14.8064 16.5754    0.392555 0.0564748 0.917993    0.4375 0.375
  v -11.4884 -14.2669 16.2282    0.46438 0.11368 0.87831    0.4375 0.25
  v -11.0485 -13.889 15.8898    0.673636 0.299998 0.675438    0.4375 0.125
  v -10.9376 -13.7372 15.5596    0.761794 0.452121 0.463957    0.4375 0
  v -15.1326 -17.6027 18.0022    0.537162 0.097285 0.83785    0.375 0.875
  v -14.3833 -17.2155 17.5835    0.434295 0.0403426 0.899867    0.375 0.75
  v -13.4733 -16.7609 17.1702    0.392548 0.0180524 0.919554    0.375 0.625
  v -12.508 -16.2841 16.7654    0.384864 0.0135432 0.922874    0.375 0.5
  v -11.5926 -15.8306 16.3725    0.409446 0.0252702 0.911985    0.375 0.375
  v -10.8327 -15.4456 15.9946    0.490109 0.0657664 0.869177    0.375 0.25
  v -10.3335 -15.1745 15.635    0.727779 0.198892 0.656338    0.375 0.125
  v -10.2004 -15.0625 15.297    0.840163 0.320937 0.437179    0.375 0
  v -15.025 -17.9354 17.9564    0.557807 0.0343605 0.829259    0.3125 0.875
  v -14.2221 -17.7138 17.515    0.44707 0.000942252 0.894498    0.3125 0.75
  v -13.2486 -17.4554 17.0747    0.402213 -0.0120778 0.915466    0.3125 0.625
  v -12.2164 -17.1852 16.6416    0.393876 -0.0148845 0.919043    0.3125 0.5
  v -11.2376 -16.9279 16.2217    0.420038 -0.00854494 0.907466    0.3125 0.375
  v -10.4241 -16.7084 15.821    0.506169 0.0138889 0.862323    0.3125 0.25
  v -9.88794 -16.5516 15.4457    0.761452 0.0893943 0.642027    0.3125 0.125
  v -9.74104 -16.4822 15.1019    0.891666 0.177077 0.416625    0.3125 0
  v -14.9827 -18.2807 17.9271    0.566286 -0.0312061 0.823618    0.25 0.875
  v -14.1588 -18.2308 17.4711    0.452248 -0.0400836 0.890991    0.25 0.75
  v -13.1604 -18.176 17.0135    0.406077 -0.0434325 0.912806    0.25 0.625
  v -12.102 -18.12 16.5621    0.397421 -0.0444471 0.916559    0.25 0.5
  v -11.0982 -18.0663 16.1249    0.424127 -0.0436885 0.904548    0.25 0.375
  v -10.2637 -18.0186 15.7097    0.512246 -0.0399962 0.857907    0.25 0.25
  v -9.71299 -17.9804 15.3243    0.7739 -0.0243463 0.63284    0.25 0.125
  v -9.56067 -17.9553 14.9766    0.914915 0.0263284 0.402786    0.25 0
  v -15.0061 -18.6287 17.9147    0.562479 -0.0973781 0.821057    0.1875 0.875
  v -14.1938 -18.752 17.4526    0.449762 -0.081468 0.889425    0.1875 0.75
  v -13.2091 -18.9025 16.9876    0.404088 -0.0750482 0.911636    0.1875 0.625
  v -12.1653 -19.0624 16.5286    0.395449 -0.0742422 0.915482    0.1875 0.5
  v -11.1753 -19.214 16.0841    0.42166 -0.0790876 0.903298    0.1875 0.375
  v -10.3524 -19.3394 15.6627    0.508255 -0.0942414 0.856035    0.1875 0.25
  v -9.80972 -19.4208 15.2731    0.76492 -0.138767 0.629    0.1875 0.125
  v -9.6604 -19.4403 14.9239    0.909517 -0.126396 0.395984    0.1875 0
  v -15.0953 -18.9699 17.9199    0.546383 -0.162137 0.821691    0.125 0.875
  v -14.3275 -19.2629 17.4603    0.439605 -0.121958 0.889873    0.125 0.75
  v -13.3955 -19.6146 16.9985    0.396244 -0.105965 0.91201    0.125 0.625
  v -12.407 -19.9863 16.5426    0.38796 -0.103361 0.915862    0.125 0.5
  v -11.4697 -20.3391 16.1012    0.412635 -0.113662 0.903777    0.125 0.375
  v -10.6912 -20.6342 15.6824    0.4942 -0.14718 0.856799    0.125 0.25
  v -10.1792 -20.8328 15.2945    0.734561 -0.250254 0.630708    0.125 0.125
  v -10.0414 -20.8961 14.946    0.875465 -0.276331 0.396486    0.125 0
  v -15.2508 -19.2946 17.9432    0.518258 -0.223072 0.825619    0.0625 0.875
  v -14.5603 -19.749 17.4952    0.421935 -0.160041 0.892389    0.0625 0.75
  v -13.72 -20.2922 17.0471    0.382663 -0.135026 0.913968    0.0625 0.625
  v -12.828 -20.8653 16.6058    0.375069 -0.13071 0.917735    0.0625 0.5
  v -11.9824 -21.4096 16.1781    0.397195 -0.146104 0.90603    0.0625 0.375
  v -11.2812 -21.8662 15.7709    0.470318 -0.196796 0.860274    0.0625 0.25
  v -10.8226 -22.1764 15.391    0.683474 -0.354507 0.638113    0.0625 0.125
  v -10.7047 -22.2813 15.0455    0.813413 -0.417986 0.404534    0.0625 0
  v -23.0439 -12.599 18.7778    0.506157 -0.679505 -0.531111    2 2
  v -22.9104 -12.678 19.0062    0.506157 -0.679505 -0.531111    2 1.9875
  v -23.0439 -12.599 18.7778    0.506157 -0.679505 -0.531111    2 2
  v -22.9104 -12.678 19.0062    0.604382 -0.735094 -0.307179    2 1.9875
  v -22.8499 -12.7009 19.1802    0.604381 -0.735094 -0.307182    2 1.975
  v -22.9104 -12.678 19.0062    0.604381 -0.735094 -0.307182    2 1.9875
  v -22.8499 -12.7009 19.1802    0.683124 -0.712628 0.159696    2 1.975
  v -22.8524 -12.6773 19.2967    0.683123 -0.712626 0.15971    2 1.9625
  v -22.8499 -12.7009 19.1802    0.683123 -0.712626 0.15971    2 1.975
  v -22.8524 -12.6773 19.2967    0.470111 -0.324605 0.820748    2 1.9625
  v -22.9082 -12.6166 19.3527    0.470109 -0.324602 0.82075    2 1.95
  v -22.8524 -12.6773 19.2967    0.470109 -0.324602 0.82075    2 1.9625
  v -22.9082 -12.6166 19.3527    0.0650067 0.158453 0.985224    2 1.95
  v -23.0074 -12.5283 19.345    0.065009 0.15845 0.985224    2 1.9375
  v -22.9082 -12.6166 19.3527    0.065009 0.15845 0.985224    2 1.95
  v -23.0074 -12.5283 19.345    -0.17833 0.404939 0.896785    2 1.9375
  v -23.1399 -12.422 19.2707    -0.178328 0.404938 0.896786    2 1.925
  v -23.0074 -12.5283 19.345    -0.178328 0.404938 0.896786    2 1.9375
  v -23.1399 -12.422 19.2707    -0.323908 0.537216 0.77877    2 1.925
  v -23.2961 -12.3071 19.1265    -0.32391 0.537217 0.778769    2 1.9125
  v -23.1399 -12.422 19.2707    -0.32391 0.537217 0.778769    2 1.925
  v -23.2961 -12.3071 19.1265    -0.425502 0.620694 0.658549    2 1.9125
  v -23.4659 -12.1932 18.9094    -0.4255 0.620694 0.658551    2 1.9
  v -23.2961 -12.3071 19.1265    -0.4255 0.620694 0.658551    2 1.9125
  v -11.2295 -23.9605 15.0933    -0.804636 0.581035 -0.12231    0 2
  v -11.2328 -23.9079 15.3643    -0.804636 0.581035 -0.12231    0 1.9875
  v -11.2328 -23.9079 15.3643    -0.804636 0.581033 -0.122315    0 1.9875
  v -11.2328 -23.9079 15.3643    -0.787364 0.603293 0.126864    0 1.9875
  v -11.2003 -23.9039 15.547    -0.787364 0.603293 0.126864    0 1.975
  v -11.2003 -23.9039 15.547    -0.787364 0.603293 0.126865    0 1.975
  v -11.2003 -23.9039 15.547    -0.621112 0.541608 0.566463    0 1.975
  v -11.1418 -23.9389 15.6445    -0.621112 0.541608 0.566463    0 1.9625
  v -11.1418 -23.9389 15.6445    -0.621115 0.541609 0.566459    0 1.9625
  v -11.1418 -23.9389 15.6445    -0.0504534 0.176002 0.983096    0 1.9625
  v -11.0674 -24.0034 15.6599    -0.0504534 0.176002 0.983096    0 1.95
  v -11.0674 -24.0034 15.6599    -0.0504575 0.176004 0.983095    0 1.95
  v -11.0674 -24.0034 15.6599    0.455337 -0.216913 0.863491    0 1.95
  v -10.9869 -24.0879 15.5962    0.455337 -0.216913 0.863491    0 1.9375
  v -10.9869 -24.0879 15.5962    0.455335 -0.216911 0.863492    0 1.9375
  v -10.9869 -24.0879 15.5962    0.659852 -0.401109 0.63538    0 1.9375
  v -10.9102 -24.1829 15.4566    0.659852 -0.401109 0.63538    0 1.925
  v -10.9102 -24.1829 15.4566    0.659853 -0.401109 0.635379    0 1.925
  v -10.9102 -24.1829 15.4566    0.747677 -0.493287 0.444575    0 1.925
  v -10.8471 -24.2788 15.244    0.747677 -0.493287 0.444575    0 1.9125
  v -10.8471 -24.2788 15.244    0.747678 -0.493287 0.444573    0 1.9125
  v -10.8471 -24.2788 15.244    0.788888 -0.547138 0.279814    0 1.9125
  v -10.8076 -24.3662 14.9617    0.788888 -0.547138 0.279814    0 1.9
  v -10.8076 -24.3662 14.9617    0.788887 -0.547137 0.279817    0 1.9
  v -23.4659 -12.1932 18.9094    -0.466682 0.651743 0.597862    2 1.9
  v -24.1569 -11.7542 17.8915    -0.466681 0.651743 0.597862    2 1.7875
  v -23.4659 -12.1932 18.9094    -0.466681 0.651743 0.597862    2 1.9
  v -24.1569 -11.7542 17.8915    -0.471891 0.65553 0.589575    2 1.7875
  v -24.8342 -11.3274 16.8748    -0.471891 0.65553 0.589576    2 1.675
  v -24.1569 -11.7542 17.8915    -0.471891 0.65553 0.589576    2 1.7875
  v -24.8342 -11.3274 16.8748    -0.482445 0.663091 0.572326    2 1.675
  v -25.4842 -10.925 15.8606    -0.482447 0.663091 0.572324    2 1.5625
  v -24.8342 -11.3274 16.8748    -0.482447 0.663091 0.572324    2 1.675
  v -25.4842 -10.925 15.8606    -0.498574 0.674347 0.544683    2 1.5625
  v -26.0931 -10.559 14.8501    -0.498573 0.674347 0.544684    2 1.45
  v -25.4842 -10.925 15.8606    -0.498573 0.674347 0.544684    2 1.5625
  v -26.0931 -10.559 14.8501    -0.520508 0.68901 0.504319    2 1.45
  v -26.6472 -10.2416 13.8446    -0.520508 0.68901 0.504319    2 1.3375
  v -26.0931 -10.559 14.8501    -0.520508 0.68901 0.504319    2 1.45
  v -26.6472 -10.2416 13.8446    -0.548269 0.706303 0.447814    2 1.3375
  v -27.1329 -9.98499 12.8453    -0.54827 0.706303 0.447813    2 1.225
  v -26.6472 -10.2416 13.8446    -0.54827 0.706303 0.447813    2 1.3375
  v -27.1329 -9.98499 12.8453    -0.581222 0.724462 0.370589    2 1.225
  v -27.5364 -9.80135 11.8534    -0.581221 0.724462 0.37059    2 1.1125
  v -27.1329 -9.98499 12.8453    -0.581221 0.724462 0.37059    2 1.225
  v -27.5364 -9.80135 11.8534    -0.617266 0.739944 0.26733    2 1.1125
  v -27.8441 -9.70282 10.8702    -0.617267 0.739944 0.267329    2 1
  v -27.5364 -9.80135 11.8534    -0.617267 0.739944 0.267329    2 1.1125
  v -10.8076 -24.3662 14.9617    0.799251 -0.565656 0.203056    0 1.9
  v -10.7116 -24.6841 13.6983    0.799251 -0.565656 0.203056    0 1.7875
  v -10.7116 -24.6841 13.6983    0.799251 -0.565656 0.203055    0 1.7875
  v -10.7116 -24.6841 13.6983    0.80024 -0.567831 0.192834    0 1.7875
  v -10.6266 -24.9904 12.4439    0.80024 -0.567831 0.192834    0 1.675
  v -10.6266 -24.9904 12.4439    0.80024 -0.567831 0.192834    0 1.675
  v -10.6266 -24.9904 12.4439    0.801996 -0.572107 0.171745    0 1.675
  v -10.5637 -25.2734 11.2073    0.801996 -0.572107 0.171745    0 1.5625
  v -10.5637 -25.2734 11.2073    0.801995 -0.572108 0.171746    0 1.5625
  v -10.5637 -25.2734 11.2073    0.803999 -0.578288 0.13845    0 1.5625
  v -10.5339 -25.5216 9.99766    0.803999 -0.578288 0.13845    0 1.45
  v -10.5339 -25.5216 9.99766    0.803999 -0.578288 0.138449    0 1.45
  v -10.5339 -25.5216 9.99766    0.805255 -0.585927 0.0908522    0 1.45
  v -10.5483 -25.7233 8.8238    0.805255 -0.585927 0.0908522    0 1.3375
  v -10.5483 -25.7233 8.8238    0.805255 -0.585926 0.0908513    0 1.3375
  v -10.5483 -25.7233 8.8238    0.803972 -0.594095 0.0260881    0 1.3375
  v -10.6178 -25.867 7.69469    0.803972 -0.594095 0.0260881    0 1.225
  v -10.6178 -25.867 7.69469    0.803971 -0.594096 0.02609    0 1.225
  v -10.6178 -25.867 7.69469    0.797063 -0.600982 -0.0592571    0 1.225
  v -10.7535 -25.9409 6.61928    0.797063 -0.600982 -0.0592571    0 1.1125
  v -10.7535 -25.9409 6.61928    0.797063 -0.600981 -0.0592584    0 1.1125
  v -10.7535 -25.9409 6.61928    0.779543 -0.603315 -0.168295    0 1.1125
  v -10.9664 -25.9335 5.60654    0.779543 -0.603315 -0.168295    0 1
  v -10.9664 -25.9335 5.60654    0.779543 -0.603315 -0.168295    0 1
  v -27.8441 -9.70282 10.8702    -0.662954 0.744996 0.0739845    2 1
  v -27.993 -9.74128 9.92382    -0.662953 0.744996 0.0739858    2 0.925
  v -27.8441 -9.70282 10.8702    -0.662953 0.744996 0.0739858    2 1
  v -27.993 -9.74128 9.92382    -0.683106 0.708998 -0.17518    2 0.925
  v -27.9629 -9.9286 9.04836    -0.683106 0.708998 -0.17518    2 0.85
  v -27.993 -9.74128 9.92382    -0.683106 0.708998 -0.17518    2 0.925
  v -27.9629 -9.9286 9.04836    -0.667702 0.647113 -0.367993    2 0.85
  v -27.8047 -10.217 8.25418    -0.667702 0.647113 -0.367993    2 0.775
  v -27.9629 -9.9286 9.04836    -0.667702 0.647113 -0.367993    2 0.85
  v -27.8047 -10.217 8.25418    -0.639187 0.58528 -0.498887    2 0.775
  v -27.5691 -10.5586 7.55159    -0.639187 0.58528 -0.498887    2 0.7
  v -27.8047 -10.217 8.25418    -0.639187 0.58528 -0.498887    2 0.775
  v -27.5691 -10.5586 7.55159    -0.613091 0.538078 -0.578438    2 0.7
  v -27.3069 -10.9056 6.95092    -0.613091 0.538077 -0.578439    2 0.625
  v -27.5691 -10.5586 7.55159    -0.613091 0.538077 -0.578439    2 0.7
  v -27.3069 -10.9056 6.95092    -0.599268 0.514831 -0.613047    2 0.625
  v -27.0689 -11.2102 6.46249    -0.599268 0.514831 -0.613047    2 0.55
  v -27.3069 -10.9056 6.95092    -0.599268 0.514831 -0.613047    2 0.625
  v -27.0689 -11.2102 6.46249    -0.610638 0.533881 -0.584887    2 0.55
  v -26.9059 -11.4246 6.09664    -0.610638 0.533879 -0.584888    2 0.475
  v -27.0689 -11.2102 6.46249    -0.610638 0.533879 -0.584888    2 0.55
  v -26.9059 -11.4246 6.09664    -0.673671 0.663657 -0.325156    2 0.475
  v -26.8687 -11.5009 5.86368    -0.673671 0.663659 -0.325151    2 0.4
  v -26.9059 -11.4246 6.09664    -0.673671 0.663659 -0.325151    2 0.475
  v -10.9664 -25.9335 5.60654    0.72421 -0.588986 -0.358631    0 1
  v -11.2965 -25.7976 4.71668    0.72421 -0.588986 -0.358631    0 0.925
  v -11.2965 -25.7976 4.71668    0.72421 -0.588986 -0.358631    0 0.925
  v -11.2965 -25.7976 4.71668    0.61289 -0.537312 -0.579363    0 0.925
  v -11.7444 -25.5253 3.9903    0.61289 -0.537312 -0.579363    0 0.85
  v -11.7444 -25.5253 3.9903    0.61289 -0.537311 -0.579364    0 0.85
  v -11.7444 -25.5253 3.9903    0.494718 -0.470741 -0.730518    0 0.85
  v -12.262 -25.1638 3.40686    0.494718 -0.470741 -0.730518    0 0.775
  v -12.262 -25.1638 3.40686    0.494719 -0.470742 -0.730517    0 0.775
  v -12.262 -25.1638 3.40686    0.395837 -0.410064 -0.821682    0 0.775
  v -12.801 -24.7604 2.94587    0.395837 -0.410064 -0.821682    0 0.7
  v -12.801 -24.7604 2.94587    0.395837 -0.410063 -0.821682    0 0.7
  v -12.801 -24.7604 2.94587    0.326686 -0.36567 -0.871528    0 0.7
  v -13.3135 -24.3625 2.58679    0.326686 -0.36567 -0.871528    0 0.625
  v -13.3135 -24.3625 2.58679    0.326686 -0.36567 -0.871528    0 0.625
  v -13.3135 -24.3625 2.58679    0.29405 -0.344239 -0.891647    0 0.625
  v -13.7513 -24.0172 2.30912    0.29405 -0.344239 -0.891647    0 0.55
  v -13.7513 -24.0172 2.30912    0.29405 -0.344238 -0.891647    0 0.55
  v -13.7513 -24.0172 2.30912    0.320732 -0.361782 -0.875354    0 0.55
  v -14.0663 -23.7719 2.09233    0.320732 -0.361782 -0.875354    0 0.475
  v -14.0663 -23.7719 2.09233    0.320733 -0.361783 -0.875353    0 0.475
  v -14.0663 -23.7719 2.09233    0.523603 -0.487715 -0.698552    0 0.475
  v -14.2104 -23.6739 1.91592    0.523603 -0.487715 -0.698552    0 0.4
  v -14.2104 -23.6739 1.91592    0.523604 -0.487716 -0.69855    0 0.4
  v -14.2104 -23.6739 1.91592    0.568265 -0.717683 -0.402499    2 0.4
  v -15.556 -24.8997 2.20185    0.568265 -0.717683 -0.402499    1.875 0.4
  v -14.2104 -23.6739 1.91592    0.568264 -0.717682 -0.402503    2 0.4
  v -20.7664 -17.5412 3.02008    0 0 0    2 0
  v -15.556 -24.8997 2.20185    0.41565 -0.831284 -0.369056    1.875 0.4
  v -17.0492 -25.7981 2.54366    0.41565 -0.831284 -0.369056    1.75 0.4
  v -15.556 -24.8997 2.20185    0.41565 -0.831284 -0.369056    1.875 0.4
  v -20.7664 -17.5412 3.02008    -0.248636 0.0451363 -0.967545    1.75 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.75 0
  v -17.0492 -25.7981 2.54366    0.245623 -0.911713 -0.329316    1.75 0.4
  v -18.6438 -26.367 2.9294    0.245623 -0.911713 -0.329316    1.625 0.4
  v -17.0492 -25.7981 2.54366    0.245625 -0.911715 -0.329308    1.75 0.4
  v -20.7664 -17.5412 3.02008    -0.24988 0.0445592 -0.967251    1.625 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.625 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.75 0
  v -18.6438 -26.367 2.9294    0.065549 -0.956319 -0.284882    1.625 0.4
  v -20.2937 -26.6046 3.34715    0.065549 -0.956319 -0.284882    1.5 0.4
  v -18.6438 -26.367 2.9294    0.065546 -0.956314 -0.284898    1.625 0.4
  v -20.7664 -17.5412 3.02008    -0.251192 0.0442403 -0.966926    1.5 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.5 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.625 0
  v -20.2937 -26.6046 3.34715    -0.118341 -0.96419 -0.237347    1.5 0.4
  v -21.9527 -26.5087 3.78496    -0.118341 -0.96419 -0.237347    1.375 0.4
  v -20.2937 -26.6046 3.34715    -0.118339 -0.964193 -0.237334    1.5 0.4
  v -20.7664 -17.5412 3.02008    -0.25253 0.044183 -0.96658    1.375 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.375 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.5 0
  v -21.9527 -26.5087 3.78496    -0.300336 -0.935095 -0.188138    1.375 0.4
  v -23.5746 -26.0775 4.2309    -0.300336 -0.935095 -0.188138    1.25 0.4
  v -21.9527 -26.5087 3.78496    -0.300336 -0.935093 -0.188145    1.375 0.4
  v -20.7664 -17.5412 3.02008    -0.253858 0.0443891 -0.966222    1.25 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.25 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.375 0
  v -23.5746 -26.0775 4.2309    -0.474185 -0.869386 -0.138982    1.25 0.4
  v -25.1132 -25.309 4.67302    -0.474185 -0.869386 -0.138982    1.125 0.4
  v -23.5746 -26.0775 4.2309    -0.474184 -0.869388 -0.138975    1.25 0.4
  v -20.7664 -17.5412 3.02008    -0.25513 0.0448579 -0.965866    1.125 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.125 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.25 0
  v -25.1132 -25.309 4.67302    -0.632468 -0.769099 -0.0920374    1.125 0.4
  v -26.5225 -24.2011 5.09939    -0.632468 -0.769099 -0.0920374    1 0.4
  v -25.1132 -25.309 4.67302    -0.632468 -0.769099 -0.0920355    1.125 0.4
  v -20.7664 -17.5412 3.02008    -0.256292 0.0455814 -0.965524    1 0
  v -20.7664 -17.5412 3.02008    0 0 0    1 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.125 0
  v -26.5225 -24.2011 5.09939    -0.766835 -0.639883 -0.0501335    1 0.4
  v -27.6924 -22.8287 5.47738    -0.766835 -0.639883 -0.0501335    0.875 0.4
  v -26.5225 -24.2011 5.09939    -0.766835 -0.639883 -0.0501326    1 0.4
  v -20.7664 -17.5412 3.02008    -0.257275 0.046526 -0.965218    0.875 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.875 0
  v -20.7664 -17.5412 3.02008    0 0 0    1 0
  v -27.6924 -22.8287 5.47738    -0.87498 -0.483958 -0.0139822    0.875 0.4
  v -28.543 -21.2996 5.7804    -0.87498 -0.483958 -0.0139822    0.75 0.4
  v -27.6924 -22.8287 5.47738    -0.87498 -0.483957 -0.0139885    0.875 0.4
  v -20.7664 -17.5412 3.02008    -0.258055 0.0476707 -0.964954    0.75 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.75 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.875 0
  v -28.543 -21.2996 5.7804    -0.950747 -0.309619 0.0147073    0.75 0.4
  v -29.073 -19.6614 6.00558    -0.950747 -0.309619 0.0147073    0.625 0.4
  v -28.543 -21.2996 5.7804    -0.950747 -0.309619 0.0147006    0.75 0.4
  v -20.7664 -17.5412 3.02008    -0.258597 0.0489471 -0.964744    0.625 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.625 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.75 0
  v -29.073 -19.6614 6.00558    -0.991615 -0.124396 0.034998    0.625 0.4
  v -29.2811 -17.9617 6.15006    -0.991615 -0.124396 0.034998    0.5 0.4
  v -29.073 -19.6614 6.00558    -0.991615 -0.124395 0.0350103    0.625 0.4
  v -20.7664 -17.5412 3.02008    -0.258889 0.0502972 -0.964597    0.5 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.5 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.625 0
  v -29.2811 -17.9617 6.15006    -0.996786 0.0652897 0.0464172    0.5 0.4
  v -29.166 -16.2482 6.21098    -0.996786 0.0652897 0.0464172    0.375 0.4
  v -29.2811 -17.9617 6.15006    -0.996786 0.0652894 0.0464124    0.5 0.4
  v -20.7664 -17.5412 3.02008    -0.258927 0.0516779 -0.964514    0.375 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.375 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.5 0
  v -29.166 -16.2482 6.21098    -0.9661 0.253554 0.0485927    0.375 0.4
  v -28.7265 -14.5685 6.18547    -0.9661 0.253554 0.0485927    0.25 0.4
  v -29.166 -16.2482 6.21098    -0.9661 0.253554 0.0485896    0.375 0.4
  v -20.7664 -17.5412 3.02008    -0.258709 0.0530501 -0.964497    0.25 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.25 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.375 0
  v -28.7265 -14.5685 6.18547    -0.900002 0.433929 0.0412599    0.25 0.4
  v -27.9611 -12.9702 6.07065    -0.900002 0.433929 0.0412599    0.125 0.4
  v -28.7265 -14.5685 6.18547    -0.900002 0.433929 0.0412552    0.25 0.4
  v -20.7664 -17.5412 3.02008    -0.258237 0.0543702 -0.96455    0.125 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.125 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.25 0
  v -27.9611 -12.9702 6.07065    -0.800601 0.598701 0.0244003    0.125 0.4
  v -26.8687 -11.5009 5.86368    -0.800601 0.598701 0.0244003    0 0.4
  v -27.9611 -12.9702 6.07065    -0.800599 0.598702 0.0244126    0.125 0.4
  v -20.7664 -17.5412 3.02008    -0.257521 0.055579 -0.964673    0 0
  v -20.7664 -17.5412 3.02008    0 0 0    0 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.125 0
  v -26.8687 -11.5009 5.86368    -0.673584 0.73911 -0.00127486    2 0.4
  v -25.5231 -10.2751 5.57774    -0.673584 0.73911 -0.00127486    1.875 0.4
  v -26.8857 -11.5167 5.69355    -0.673584 0.739109 -0.00127896    2 0.35
  v -26.8687 -11.5009 5.86368    -0.673584 0.739109 -0.00127896    2 0.4
  v -26.8857 -11.5167 5.69355    -0.623472 0.556238 -0.549438    2 0.35
  v -26.8086 -11.6218 5.49961    -0.623472 0.556235 -0.549441    2 0.3
  v -26.8857 -11.5167 5.69355    -0.623472 0.556235 -0.549441    2 0.35
  v -26.8086 -11.6218 5.49961    -0.466571 0.31981 -0.824641    2 0.3
  v -26.5731 -11.8774 5.26728    -0.466572 0.319812 -0.82464    2 0.25
  v -26.8086 -11.6218 5.49961    -0.466572 0.319812 -0.82464    2 0.3
  v -26.5731 -11.8774 5.26728    -0.369154 0.19318 -0.909069    2 0.25
  v -26.1148 -12.3441 4.982    -0.369154 0.193179 -0.909069    2 0.2
  v -26.5731 -11.8774 5.26728    -0.369154 0.193179 -0.909069    2 0.25
  v -26.1148 -12.3441 4.982    -0.317017 0.128819 -0.939631    2 0.2
  v -25.3694 -13.083 4.62921    -0.317017 0.12882 -0.939631    2 0.15
  v -26.1148 -12.3441 4.982    -0.317017 0.12882 -0.939631    2 0.2
  v -25.3694 -13.083 4.62921    -0.287191 0.092876 -0.95336    2 0.15
  v -24.2724 -14.1548 4.19433    -0.287191 0.0928759 -0.95336    2 0.1
  v -25.3694 -13.083 4.62921    -0.287191 0.0928759 -0.95336    2 0.15
  v -24.2724 -14.1548 4.19433    -0.268749 0.0709449 -0.960594    2 0.1
  v -22.7595 -15.6206 3.66281    -0.268749 0.0709444 -0.960594    2 0.05
  v -24.2724 -14.1548 4.19433    -0.268749 0.0709444 -0.960594    2 0.1
  v -22.7595 -15.6206 3.66281    -0.256593 0.0566051 -0.964861    2 0.05
  v -20.7664 -17.5412 3.02008    0 0 0    2 0
  v -22.7595 -15.6206 3.66281    0 0 0    2 0.05
  v -25.5231 -10.2751 5.57774    -0.521132 0.852744 -0.0353454    1.875 0.4
  v -24.0299 -9.37671 5.23594    -0.521132 0.852744 -0.0353454    1.75 0.4
  v -25.5231 -10.2751 5.57774    -0.521133 0.852743 -0.0353465    1.875 0.4
  v -20.7664 -17.5412 3.02008    -0.255472 0.0574264 -0.965109    1.75 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.75 0
  v -24.0299 -9.37671 5.23594    -0.351269 0.933208 -0.0757129    1.75 0.4
  v -22.4352 -8.80777 4.85019    -0.351269 0.933208 -0.0757129    1.625 0.4
  v -24.0299 -9.37671 5.23594    -0.35127 0.933208 -0.0757146    1.75 0.4
  v -20.7664 -17.5412 3.02008    -0.254229 0.0580031 -0.965403    1.625 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.625 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.75 0
  v -22.4352 -8.80777 4.85019    -0.171281 0.977829 -0.120473    1.625 0.4
  v -20.7853 -8.57023 4.43244    -0.171281 0.977829 -0.120473    1.5 0.4
  v -22.4352 -8.80777 4.85019    -0.171283 0.977828 -0.120478    1.625 0.4
  v -20.7664 -17.5412 3.02008    -0.252917 0.058322 -0.965729    1.5 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.5 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.625 0
  v -20.7853 -8.57023 4.43244    0.0126044 0.985702 -0.168026    1.5 0.4
  v -19.1264 -8.66607 3.99463    0.0126044 0.985702 -0.168026    1.375 0.4
  v -20.7853 -8.57023 4.43244    0.0126072 0.985703 -0.168018    1.5 0.4
  v -20.7664 -17.5412 3.02008    -0.251577 0.0583794 -0.966075    1.375 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.375 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.5 0
  v -19.1264 -8.66607 3.99463    0.194693 0.956588 -0.216875    1.375 0.4
  v -17.5045 -9.09728 3.54869    0.194693 0.956588 -0.216875    1.25 0.4
  v -19.1264 -8.66607 3.99463    0.194691 0.956587 -0.216879    1.375 0.4
  v -20.7664 -17.5412 3.02008    -0.250251 0.0581736 -0.966432    1.25 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.25 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.375 0
  v -17.5045 -9.09728 3.54869    0.368701 0.890848 -0.265424    1.25 0.4
  v -15.9658 -9.86582 3.10657    0.368701 0.890848 -0.265424    1.125 0.4
  v -17.5045 -9.09728 3.54869    0.368703 0.890848 -0.265419    1.25 0.4
  v -20.7664 -17.5412 3.02008    -0.248978 0.0577043 -0.966789    1.125 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.125 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.25 0
  v -15.9658 -9.86582 3.10657    0.527148 0.790527 -0.311742    1.125 0.4
  v -14.5566 -10.9737 2.6802    0.527148 0.790527 -0.311742    1 0.4
  v -15.9658 -9.86582 3.10657    0.527149 0.790527 -0.311739    1.125 0.4
  v -20.7664 -17.5412 3.02008    -0.247816 0.0569814 -0.96713    1 0
  v -20.7664 -17.5412 3.02008    0 0 0    1 0
  v -20.7664 -17.5412 3.02008    0 0 0    1.125 0
  v -14.5566 -10.9737 2.6802    0.661516 0.661312 -0.353644    1 0.4
  v -13.3867 -12.3461 2.30222    0.661516 0.661312 -0.353644    0.875 0.4
  v -14.5566 -10.9737 2.6802    0.661514 0.661311 -0.353647    1 0.4
  v -20.7664 -17.5412 3.02008    -0.246834 0.0560367 -0.967436    0.875 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.875 0
  v -20.7664 -17.5412 3.02008    0 0 0    1 0
  v -13.3867 -12.3461 2.30222    0.769497 0.505419 -0.390418    0.875 0.4
  v -12.5361 -13.8752 1.9992    0.769497 0.505419 -0.390418    0.75 0.4
  v -13.3867 -12.3461 2.30222    0.769496 0.505419 -0.390419    0.875 0.4
  v -20.7664 -17.5412 3.02008    -0.246054 0.0548915 -0.967701    0.75 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.75 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.875 0
  v -12.5361 -13.8752 1.9992    0.845103 0.331112 -0.419721    0.75 0.4
  v -12.0061 -15.5134 1.77401    0.845103 0.331112 -0.419721    0.625 0.4
  v -12.5361 -13.8752 1.9992    0.845103 0.331112 -0.419721    0.75 0.4
  v -20.7664 -17.5412 3.02008    -0.245511 0.0536156 -0.96791    0.625 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.625 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.75 0
  v -12.0061 -15.5134 1.77401    0.88588 0.145908 -0.440373    0.625 0.4
  v -11.7979 -17.2131 1.62953    0.88588 0.145908 -0.440373    0.5 0.4
  v -12.0061 -15.5134 1.77401    0.88588 0.145907 -0.440371    0.625 0.4
  v -20.7664 -17.5412 3.02008    -0.24522 0.0522652 -0.968058    0.5 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.5 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.625 0
  v -11.7979 -17.2131 1.62953    0.891048 -0.0437766 -0.451792    0.5 0.4
  v -11.913 -18.9266 1.56861    0.891048 -0.0437766 -0.451792    0.375 0.4
  v -11.7979 -17.2131 1.62953    0.891051 -0.0437776 -0.451787    0.5 0.4
  v -20.7664 -17.5412 3.02008    -0.245182 0.0508843 -0.968141    0.375 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.375 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.5 0
  v -11.913 -18.9266 1.56861    0.860454 -0.23206 -0.453615    0.375 0.4
  v -12.3526 -20.6063 1.59413    0.860454 -0.23206 -0.453615    0.25 0.4
  v -11.913 -18.9266 1.56861    0.860453 -0.23206 -0.453618    0.375 0.4
  v -20.7664 -17.5412 3.02008    -0.245399 0.0495115 -0.968157    0.25 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.25 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.375 0
  v -12.3526 -20.6063 1.59413    0.794518 -0.412467 -0.445659    0.25 0.4
  v -13.1179 -22.2046 1.70894    0.794518 -0.412467 -0.445659    0.125 0.4
  v -12.3526 -20.6063 1.59413    0.794518 -0.412467 -0.445659    0.25 0.4
  v -20.7664 -17.5412 3.02008    -0.245871 0.0481932 -0.968104    0.125 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.125 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.25 0
  v -13.1179 -22.2046 1.70894    0.69528 -0.577274 -0.428183    0.125 0.4
  v -14.2104 -23.6739 1.91592    0.69528 -0.577274 -0.428183    0 0.4
  v -14.278 -23.6409 1.7616    0.69528 -0.577274 -0.428183    0 0.35
  v -14.278 -23.6409 1.7616    0.69528 -0.577274 -0.428183    0 0.35
  v -13.1179 -22.2046 1.70894    0.69528 -0.577274 -0.428183    0.125 0.4
  v -14.278 -23.6409 1.7616    0.35279 -0.382597 -0.853908    0 0.35
  v -14.4371 -23.5191 1.64129    0.35279 -0.382597 -0.853908    0 0.3
  v -14.4371 -23.5191 1.64129    0.352789 -0.382597 -0.853908    0 0.3
  v -14.4371 -23.5191 1.64129    0.0447304 -0.171888 -0.9841    0 0.3
  v -14.7492 -23.2479 1.57975    0.0447304 -0.171888 -0.9841    0 0.25
  v -14.7492 -23.2479 1.57975    0.0447303 -0.171888 -0.9841    0 0.25
  v -14.7492 -23.2479 1.57975    -0.1007 -0.0649821 -0.992792    0 0.25
  v -15.2761 -22.7672 1.60173    -0.1007 -0.0649821 -0.992792    0 0.2
  v -15.2761 -22.7672 1.60173    -0.1007 -0.064982 -0.992792    0 0.2
  v -15.2761 -22.7672 1.60173    -0.170776 -0.0118153 -0.985239    0 0.2
  v -16.0796 -22.0166 1.732    -0.170776 -0.0118153 -0.985239    0 0.15
  v -16.0796 -22.0166 1.732    -0.170776 -0.0118154 -0.985239    0 0.15
  v -16.0796 -22.0166 1.732    -0.208874 0.0175615 -0.977785    0 0.15
  v -17.2213 -20.9356 1.99531    -0.208874 0.0175615 -0.977785    0 0.1
  v -17.2213 -20.9356 1.99531    -0.208874 0.017562 -0.977785    0 0.1
  v -17.2213 -20.9356 1.99531    -0.231764 0.0353783 -0.972128    0 0.1
  v -18.763 -19.4639 2.41642    -0.231764 0.0353783 -0.972128    0 0.05
  v -18.763 -19.4639 2.41642    -0.231764 0.0353778 -0.972128    0 0.05
  v -18.763 -19.4639 2.41642    -0.246587 0.0469832 -0.967981    0 0.05
  v -20.7664 -17.5412 3.02008    -0.246587 0.0469832 -0.967981    0 0
  v -20.7664 -17.5412 3.02008    0 0 0    0 0
  v -20.7664 -17.5412 3.02008    0 0 0    0.125 0
  v -24.4549 -11.672 16.8667    -0.184689 0.121617 -0.975243    0 1
  v -25.503 -10.6646 17.1908    -0.184689 0.121617 -0.975243    0 0.9375
  v -25.503 -10.6646 17.1908    -0.184735 0.121508 -0.975248    0 0.9375
  v -25.503 -10.6646 17.1908    -0.176142 0.113275 -0.977826    0 0.9375
  v -26.4315 -9.77527 17.4611    -0.176142 0.113275 -0.977826    0 0.875
  v -26.4315 -9.77527 17.4611    -0.176433 0.112453 -0.977868    0 0.875
  v -26.4315 -9.77527 17.4611    -0.154595 0.0930959 -0.983582    0 0.875
  v -27.2394 -9.00793 17.6607    -0.154595 0.0930959 -0.983582    0 0.8125
  v -27.2394 -9.00793 17.6607    -0.155261 0.0906875 -0.983702    0 0.8125
  v -27.2394 -9.00793 17.6607    -0.111389 0.0542423 -0.992295    0 0.8125
  v -27.9258 -8.36654 17.7728    -0.111389 0.0542423 -0.992295    0 0.75
  v -27.9258 -8.36654 17.7728    -0.112286 0.049136 -0.99246    0 0.75
  v -27.9258 -8.36654 17.7728    -0.0287848 -0.0165328 -0.999449    0 0.75
  v -28.4896 -7.85504 17.7806    -0.0287848 -0.0165328 -0.999449    0 0.6875
  v -28.4896 -7.85504 17.7806    -0.0292058 -0.0257667 -0.999241    0 0.6875
  v -28.4896 -7.85504 17.7806    0.129121 -0.143992 -0.981119    0 0.6875
  v -28.93 -7.47739 17.6672    0.129121 -0.143992 -0.981119    0 0.625
  v -28.93 -7.47739 17.6672    0.130631 -0.15853 -0.978675    0 0.625
  v -28.93 -7.47739 17.6672    0.405762 -0.350207 -0.844223    0 0.625
  v -29.246 -7.23752 17.4159    0.405762 -0.350207 -0.844223    0 0.5625
  v -29.246 -7.23752 17.4159    0.408862 -0.366486 -0.835775    0 0.5625
  v -29.246 -7.23752 17.4159    0.7033 -0.541312 -0.460814    0 0.5625
  v -29.4366 -7.13938 17.0097    0.7033 -0.541312 -0.460814    0 0.5
  v -29.4366 -7.13938 17.0097    0.703059 -0.547255 -0.454115    0 0.5
  v -29.4366 -7.13938 17.0097    0.804948 -0.577381 -0.136709    0 0.5
  v -29.5385 -7.14928 16.4518    0.804948 -0.577381 -0.136709    0 0.4375
  v -29.5385 -7.14928 16.4518    0.805027 -0.577216 -0.136945    0 0.4375
  v -29.5385 -7.14928 16.4518    0.825026 -0.564711 0.0208254    0 0.4375
  v -29.5802 -7.23514 15.776    0.825026 -0.564711 0.0208254    0 0.375
  v -29.5802 -7.23514 15.776    0.823747 -0.566478 0.0233345    0 0.375
  v -29.5802 -7.23514 15.776    0.826017 -0.542434 0.153168    0 0.375
  v -29.5488 -7.40335 15.0113    0.826017 -0.542434 0.153168    0 0.3125
  v -29.5488 -7.40335 15.0113    0.822013 -0.546764 0.159199    0 0.3125
  v -29.5488 -7.40335 15.0113    0.812343 -0.513896 0.275698    0 0.3125
  v -29.4315 -7.66029 14.1867    0.812343 -0.513896 0.275698    0 0.25
  v -29.4315 -7.66029 14.1867    0.805214 -0.520303 0.284454    0 0.25
  v -29.4315 -7.66029 14.1867    0.784626 -0.477875 0.394966    0 0.25
  v -29.2153 -8.01233 13.3312    0.784626 -0.477875 0.394966    0 0.1875
  v -29.2153 -8.01233 13.3312    0.774922 -0.485311 0.404931    0 0.1875
  v -29.2153 -8.01233 13.3312    0.742625 -0.4313 0.512337    0 0.1875
  v -28.8873 -8.46584 12.474    0.742625 -0.4313 0.512337    0 0.125
  v -28.8873 -8.46584 12.474    0.731958 -0.438398 0.521579    0 0.125
  v -28.8873 -8.46584 12.474    0.686794 -0.370598 0.625277    0 0.125
  v -28.4345 -9.02722 11.644    0.686794 -0.370598 0.625277    0 0.0625
  v -28.4345 -9.02722 11.644    0.677823 -0.375909 0.631861    0 0.0625
  v -28.4345 -9.02722 11.644    0.619373 -0.29295 0.728394    0 0.0625
  v -27.8441 -9.70282 10.8702    0.619373 -0.29295 0.728394    0 0
  v -27.8441 -9.70282 10.8702    0.615548 -0.295037 0.73079    0 0
  v -12.6859 -24.6239 4.26188    0.0566669 -0.0223954 -0.998142    0 0
  v -10.6642 -26.423 4.42487    0.0547328 -0.0289158 -0.998082    0 0.1125
  v -12.6859 -24.6239 4.26188    0.0547328 -0.0289158 -0.998082    0 0
  v -10.6642 -26.423 4.42487    0.287809 -0.242634 -0.926442    0 0.1125
  v -9.18382 -27.6209 5.19756    0.287972 -0.241831 -0.926601    0 0.225
  v -10.6642 -26.423 4.42487    0.287972 -0.241831 -0.926601    0 0.1125
  v -9.18382 -27.6209 5.19756    0.512394 -0.438402 -0.738415    0 0.225
  v -8.09384 -28.3869 6.40058    0.513949 -0.432308 -0.740923    0 0.3375
  v -9.18382 -27.6209 5.19756    0.513949 -0.432308 -0.740923    0 0.225
  v -8.09384 -28.3869 6.40058    0.638667 -0.535483 -0.552597    0 0.3375
  v -7.24317 -28.8905 7.85457    0.642569 -0.525248 -0.557871    0 0.45
  v -8.09384 -28.3869 6.40058    0.642569 -0.525248 -0.557871    0 0.3375
  v -7.24317 -28.8905 7.85457    0.680268 -0.553768 -0.480185    0 0.45
  v -6.48075 -29.3011 9.38017    0.687682 -0.537271 -0.488296    0 0.5625
  v -7.24317 -28.8905 7.85457    0.687682 -0.537271 -0.488296    0 0.45
  v -6.48075 -29.3011 9.38017    0.657765 -0.517081 -0.547697    0 0.5625
  v -5.65555 -29.7883 10.798    0.669333 -0.490446 -0.558082    0 0.675
  v -6.48075 -29.3011 9.38017    0.669333 -0.490446 -0.558082    0 0.5625
  v -5.65555 -29.7883 10.798    0.535098 -0.409277 -0.739028    0 0.675
  v -4.6165 -30.5215 11.9287    0.549157 -0.37421 -0.747257    0 0.7875
  v -5.65555 -29.7883 10.798    0.549157 -0.37421 -0.747257    0 0.675
  v -4.6165 -30.5215 11.9287    0.270139 -0.224907 -0.936184    0 0.7875
  v -3.21256 -31.67 12.593    0.282727 -0.197295 -0.93869    0 0.9
  v -4.6165 -30.5215 11.9287    0.282727 -0.197295 -0.93869    0 0.7875
  v -3.21256 -31.67 12.593    0.14694 -0.136526 -0.979678    0 0.9
  v -2.86717 -31.966 12.683    0.144821 -0.129195 -0.980987    0 0.9125
  v -3.21256 -31.67 12.593    0.144821 -0.129195 -0.980987    0 0.9
  v -2.86717 -31.966 12.683    0.226555 -0.163988 -0.960094    0 0.9125
  v -2.64589 -32.1515 12.7634    0.220748 -0.15445 -0.963024    0 0.925
  v -2.86717 -31.966 12.683    0.220748 -0.15445 -0.963024    0 0.9125
  v -2.64589 -32.1515 12.7634    0.41861 -0.232026 -0.878026    0 0.925
  v -2.54356 -32.2321 12.8287    0.398746 -0.214852 -0.891538    0 0.9375
  v -2.64589 -32.1515 12.7634    0.398746 -0.214852 -0.891538    0 0.925
  v -2.54356 -32.2321 12.8287    0.833927 -0.304209 0.46046    0 0.9375
  v -2.55497 -32.2137 12.8729    0.879124 -0.314494 0.3581    0 0.95
  v -2.54356 -32.2321 12.8287    0.879124 -0.314494 0.3581    0 0.9375
  v -2.55497 -32.2137 12.8729    0.146553 0.00424821 0.989194    0 0.95
  v -2.67496 -32.102 12.8903    0.147711 0.00421136 0.989022    0 0.9625
  v -2.55497 -32.2137 12.8729    0.147711 0.00421136 0.989022    0 0.95
  v -2.67496 -32.102 12.8903    -0.00972009 0.0633485 0.997944    0 0.9625
  v -2.89834 -31.9027 12.8752    -0.0109656 0.0631114 0.997946    0 0.975
  v -2.67496 -32.102 12.8903    -0.0109656 0.0631114 0.997946    0 0.9625
  v -2.89834 -31.9027 12.8752    -0.086341 0.090869 0.992113    0 0.975
  v -3.21991 -31.6215 12.8219    -0.0844876 0.0915258 0.992212    0 0.9875
  v -2.89834 -31.9027 12.8752    -0.0844876 0.0915258 0.992212    0 0.975
  v -3.21991 -31.6215 12.8219    -0.138622 0.112187 0.983971    0 0.9875
  v -3.63451 -31.2643 12.7246    -0.131635 0.115445 0.984553    0 1
  v -3.21991 -31.6215 12.8219    -0.131635 0.115445 0.984553    0 0.9875
  v -16.0024 -18.5105 21.2841    0 0 0    0.9375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.9375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.875 1
  v -16.0024 -18.5105 21.2841    0.279204 -0.100541 0.954954    0.9375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.8125 1
  v -16.0024 -18.5105 21.2841    0.269201 -0.105172 0.957324    0.875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.8125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.75 1
  v -16.0024 -18.5105 21.2841    0.258607 -0.107741 0.959956    0.8125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.75 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.6875 1
  v -16.0024 -18.5105 21.2841    0.247784 -0.108205 0.962754    0.75 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.6875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.625 1
  v -16.0024 -18.5105 21.2841    0.237075 -0.106548 0.965631    0.6875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.5625 1
  v -16.0024 -18.5105 21.2841    0.22684 -0.102784 0.968493    0.625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.5625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.5 1
  v -16.0024 -18.5105 21.2841    0.217532 -0.0970019 0.971221    0.5625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.5 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.4375 1
  v -16.0024 -18.5105 21.2841    0.209698 -0.0894684 0.973664    0.5 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.4375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.375 1
  v -16.0024 -18.5105 21.2841    0.20346 -0.0803012 0.975785    0.4375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.3125 1
  v -16.0024 -18.5105 21.2841    0.199108 -0.0700376 0.977472    0.375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.3125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.25 1
  v -16.0024 -18.5105 21.2841    0.196761 -0.0591366 0.978666    0.3125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.25 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.1875 1
  v -16.0024 -18.5105 21.2841    0.196457 -0.0479732 0.979338    0.25 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.1875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.125 1
  v -16.0024 -18.5105 21.2841    0.198205 -0.036899 0.979466    0.1875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.0625 1
  v -16.0024 -18.5105 21.2841    0.201987 -0.0262875 0.979035    0.125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.0625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0 1
  v -16.0024 -18.5105 21.2841    0.207715 -0.0166001 0.978049    0.0625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.9375 1
  v -16.9932 -17.5728 21.5105    0.215113 -0.00842171 0.976553    1 0.875
  v -16.9932 -17.5728 21.5105    0.0417239 0.182918 0.982242    1 0.875
  v -17.5141 -17.1132 21.447    0.0417306 0.18292 0.982242    1 0.75
  v -16.9932 -17.5728 21.5105    0.0417306 0.18292 0.982242    1 0.875
  v -17.5141 -17.1132 21.447    -0.496948 0.672329 0.54865    1 0.75
  v -17.6859 -17.0095 21.1644    -0.496923 0.672334 0.548667    1 0.625
  v -17.5141 -17.1132 21.447    -0.496923 0.672334 0.548667    1 0.75
  v -17.6859 -17.0095 21.1644    -0.677634 0.674369 -0.293322    1 0.625
  v -17.629 -17.1398 20.7334    -0.677613 0.6744 -0.293299    1 0.5
  v -17.6859 -17.0095 21.1644    -0.677613 0.6744 -0.293299    1 0.625
  v -17.629 -17.1398 20.7334    -0.64228 0.590071 -0.489176    1 0.5
  v -17.464 -17.3821 20.2246    -0.642239 0.590137 -0.48915    1 0.375
  v -17.629 -17.1398 20.7334    -0.642239 0.590137 -0.48915    1 0.5
  v -17.464 -17.3821 20.2246    -0.648933 0.603484 -0.46335    1 0.375
  v -17.3117 -17.6143 19.7086    -0.648837 0.603618 -0.46331    1 0.25
  v -17.464 -17.3821 20.2246    -0.648837 0.603618 -0.46331    1 0.375
  v -17.3117 -17.6143 19.7086    -0.68332 0.706153 -0.185529    1 0.25
  v -17.2924 -17.7144 19.2563    -0.683109 0.706382 -0.185439    1 0.125
  v -17.3117 -17.6143 19.7086    -0.683109 0.706382 -0.185439    1 0.25
  v -17.2924 -17.7144 19.2563    -0.443308 0.634173 0.633484    1 0.125
  v -17.5269 -17.5605 18.9382    -0.44316 0.63424 0.633521    1 0
  v -17.2924 -17.7144 19.2563    -0.44316 0.63424 0.633521    1 0.125
  v -16.0024 -18.5105 21.2841    0 0 0    0.9375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.875 1
  v -16.0024 -18.5105 21.2841    0.224089 -0.00185519 0.974567    0.9375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.8125 1
  v -16.0024 -18.5105 21.2841    0.234098 0.00277627 0.972209    0.875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.8125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.75 1
  v -16.0024 -18.5105 21.2841    0.244694 0.00534528 0.969586    0.8125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.75 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.6875 1
  v -16.0024 -18.5105 21.2841    0.255506 0.00580827 0.96679    0.75 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.6875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.625 1
  v -16.0024 -18.5105 21.2841    0.266216 0.00415161 0.963905    0.6875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.5625 1
  v -16.0024 -18.5105 21.2841    0.276452 0.000386266 0.961028    0.625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.5625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.5 1
  v -16.0024 -18.5105 21.2841    0.28576 -0.00539628 0.958286    0.5625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.5 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.4375 1
  v -16.0024 -18.5105 21.2841    0.293585 -0.0129217 0.955846    0.5 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.4375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.375 1
  v -16.0024 -18.5105 21.2841    0.299831 -0.0220971 0.953736    0.4375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.3125 1
  v -16.0024 -18.5105 21.2841    0.304188 -0.0323645 0.952062    0.375 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.3125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.25 1
  v -16.0024 -18.5105 21.2841    0.306537 -0.0432648 0.950875    0.3125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.25 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.1875 1
  v -16.0024 -18.5105 21.2841    0.306841 -0.0544182 0.950204    0.25 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.1875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.125 1
  v -16.0024 -18.5105 21.2841    0.305091 -0.0654951 0.950068    0.1875 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.0625 1
  v -16.0024 -18.5105 21.2841    0.301303 -0.0761114 0.950486    0.125 1
  v -16.0024 -18.5105 21.2841    0 0 0    0.0625 1
  v -16.0024 -18.5105 21.2841    0 0 0    0 1
  v -15.0516 -19.44 20.9049    0 0 0    0 0.875
  v -15.0516 -19.44 20.9049    0.295575 -0.0857921 0.951459    0 0.875
  v -16.0024 -18.5105 21.2841    0.295575 -0.0857921 0.951459    0.0625 1
  v -15.0516 -19.44 20.9049    0.477436 -0.236081 0.846357    0 0.875
  v -14.6396 -19.8775 20.5505    0.477436 -0.236081 0.846357    0 0.75
  v -14.6396 -19.8775 20.5505    0.477435 -0.236082 0.846358    0 0.75
  v -14.6396 -19.8775 20.5505    0.80332 -0.578087 0.143153    0 0.75
  v -14.6301 -19.9482 20.2114    0.80332 -0.578087 0.143153    0 0.625
  v -14.6301 -19.9482 20.2114    0.80333 -0.578077 0.143131    0 0.625
  v -14.6301 -19.9482 20.2114    0.543587 -0.500027 -0.674156    0 0.625
  v -14.8863 -19.7773 19.878    0.543587 -0.500027 -0.674156    0 0.5
  v -14.8863 -19.7773 19.878    0.543588 -0.499987 -0.674184    0 0.5
  v -14.8863 -19.7773 19.878    0.403383 -0.415494 -0.815259    0 0.5
  v -15.2719 -19.4902 19.5409    0.403383 -0.415494 -0.815259    0 0.375
  v -15.2719 -19.4902 19.5409    0.403394 -0.415425 -0.815289    0 0.375
  v -15.2719 -19.4902 19.5409    0.42405 -0.428355 -0.797931    0 0.375
  v -15.6503 -19.212 19.1905    0.42405 -0.428355 -0.797931    0 0.25
  v -15.6503 -19.212 19.1905    0.424092 -0.428194 -0.797995    0 0.25
  v -15.6503 -19.212 19.1905    0.607059 -0.534721 -0.587837    0 0.25
  v -15.8848 -19.068 18.8173    0.607059 -0.534721 -0.587837    0 0.125
  v -15.8848 -19.068 18.8173    0.607156 -0.534454 -0.58798    0 0.125
  v -15.8848 -19.068 18.8173    0.793771 -0.55547 0.247754    0 0.125
  v -15.8391 -19.1836 18.4118    0.793771 -0.55547 0.247754    0 0
  v -15.8391 -19.1836 18.4118    0.793867 -0.555372 0.247663    0 0
  v -15.8391 -19.1836 18.4118    0.501253 -0.367505 0.783381    1 1
  v -16.0185 -19.347 18.4499    0.501253 -0.367505 0.783381    0.9375 1
  v -15.8391 -19.1836 18.4118    0.501253 -0.367505 0.783381    1 1
  v -16.0185 -19.347 18.4499    0.433788 -0.417161 0.798627    0.9375 1
  v -16.2176 -19.4668 18.4955    0.433788 -0.417161 0.798627    0.875 1
  v -16.0185 -19.347 18.4499    0.433793 -0.41716 0.798625    0.9375 1
  v -16.2176 -19.4668 18.4955    0.358845 -0.452106 0.816597    0.875 1
  v -16.4302 -19.5426 18.5469    0.358845 -0.452106 0.816597    0.8125 1
  v -16.2176 -19.4668 18.4955    0.358843 -0.452106 0.816598    0.875 1
  v -16.4302 -19.5426 18.5469    0.279642 -0.471446 0.836385    0.8125 1
  v -16.6502 -19.5743 18.6026    0.279642 -0.471446 0.836385    0.75 1
  v -16.4302 -19.5426 18.5469    0.27964 -0.471446 0.836385    0.8125 1
  v -16.6502 -19.5743 18.6026    0.198802 -0.474906 0.857288    0.75 1
  v -16.8714 -19.5615 18.661    0.198802 -0.474906 0.857288    0.6875 1
  v -16.6502 -19.5743 18.6026    0.198805 -0.474907 0.857286    0.75 1
  v -16.8714 -19.5615 18.661    0.118669 -0.462394 0.878698    0.6875 1
  v -17.0877 -19.504 18.7205    0.118669 -0.462394 0.878698    0.625 1
  v -16.8714 -19.5615 18.661    0.118666 -0.462392 0.878699    0.6875 1
  v -17.0877 -19.504 18.7205    0.0418465 -0.433941 0.899969    0.625 1
  v -17.2928 -19.4016 18.7794    0.0418465 -0.433941 0.899969    0.5625 1
  v -17.0877 -19.504 18.7205    0.041848 -0.433942 0.899968    0.625 1
  v -17.2928 -19.4016 18.7794    -0.0282923 -0.390182 0.920303    0.5625 1
  v -17.4807 -19.2538 18.8363    -0.0282923 -0.390182 0.920303    0.5 1
  v -17.2928 -19.4016 18.7794    -0.028293 -0.390181 0.920303    0.5625 1
  v -17.4807 -19.2538 18.8363    -0.0875523 -0.333195 0.938784    0.5 1
  v -17.6367 -19.0709 18.8867    -0.0875523 -0.333195 0.938784    0.4375 1
  v -17.4807 -19.2538 18.8363    -0.0875525 -0.333194 0.938784    0.5 1
  v -17.6367 -19.0709 18.8867    -0.134687 -0.264172 0.955025    0.4375 1
  v -17.7501 -18.867 18.9271    -0.134687 -0.264172 0.955025    0.375 1
  v -17.6367 -19.0709 18.8867    -0.134687 -0.264174 0.955024    0.4375 1
  v -17.7501 -18.867 18.9271    -0.167468 -0.187236 0.967934    0.375 1
  v -17.8208 -18.6486 18.9571    -0.167468 -0.187236 0.967934    0.3125 1
  v -17.7501 -18.867 18.9271    -0.167467 -0.18723 0.967936    0.375 1
  v -17.8208 -18.6486 18.9571    -0.185103 -0.105716 0.977016    0.3125 1
  v -17.8485 -18.4219 18.9763    -0.185103 -0.105716 0.977016    0.25 1
  v -17.8208 -18.6486 18.9571    -0.185104 -0.105718 0.977016    0.3125 1
  v -17.8485 -18.4219 18.9763    -0.187376 -0.0223256 0.982035    0.25 1
  v -17.8332 -18.1935 18.9845    -0.187376 -0.0223256 0.982035    0.1875 1
  v -17.8485 -18.4219 18.9763    -0.187376 -0.0223264 0.982034    0.25 1
  v -17.8332 -18.1935 18.9845    -0.174225 0.0605158 0.982845    0.1875 1
  v -17.7746 -17.9695 18.9811    -0.174225 0.0605158 0.982845    0.125 1
  v -17.8332 -18.1935 18.9845    -0.174223 0.0605189 0.982845    0.1875 1
  v -17.7746 -17.9695 18.9811    -0.145708 0.140123 0.979354    0.125 1
  v -17.6725 -17.7564 18.9658    -0.145708 0.140123 0.979354    0.0625 1
  v -17.7746 -17.9695 18.9811    -0.145709 0.140123 0.979354    0.125 1
  v -17.6725 -17.7564 18.9658    -0.102442 0.213048 0.971657    0.0625 1
  v -17.5269 -17.5605 18.9382    -0.102442 0.213048 0.971657    0 1
  v -17.6725 -17.7564 18.9658    -0.102445 0.213046 0.971657    0.0625 1
  v -17.5269 -17.5605 18.9382    -0.0464281 0.274969 0.960331    1 1
  v -17.3475 -17.397 18.9    -0.0464281 0.274969 0.960331    0.9375 1
  v -18.0439 -17.1204 18.7871    -0.0464258 0.27497 0.960331    1 0.875
  v -17.5269 -17.5605 18.9382    -0.0464258 0.27497 0.960331    1 1
  v -18.0439 -17.1204 18.7871    0.0840119 0.137976 0.986866    1 0.875
  v -18.7428 -16.4933 18.759    0.08401 0.137975 0.986866    1 0.75
  v -18.0439 -17.1204 18.7871    0.08401 0.137975 0.986866    1 0.875
  v -18.7428 -16.4933 18.759    0.135457 0.0816291 0.987415    1 0.75
  v -19.5497 -15.7543 18.8086    0.135457 0.081629 0.987415    1 0.625
  v -18.7428 -16.4933 18.759    0.135457 0.081629 0.987415    1 0.75
  v -19.5497 -15.7543 18.8086    0.1534 0.0616577 0.986239    1 0.625
  v -20.3909 -14.9783 18.8909    0.1534 0.0616577 0.986239    1 0.5
  v -19.5497 -15.7543 18.8086    0.1534 0.0616577 0.986239    1 0.625
  v -20.3909 -14.9783 18.8909    0.148224 0.0674363 0.986652    1 0.5
  v -21.1925 -14.2403 18.9609    0.148224 0.0674362 0.986652    1 0.375
  v -20.3909 -14.9783 18.8909    0.148224 0.0674362 0.986652    1 0.5
  v -21.1925 -14.2403 18.9609    0.113837 0.105471 0.987885    1 0.375
  v -21.8807 -13.6154 18.9735    0.113839 0.105471 0.987885    1 0.25
  v -21.1925 -14.2403 18.9609    0.113839 0.105471 0.987885    1 0.375
  v -21.8807 -13.6154 18.9735    0.0119943 0.21464 0.97662    1 0.25
  v -22.3818 -13.1786 18.8836    0.0119926 0.214641 0.976619    1 0.125
  v -21.8807 -13.6154 18.9735    0.0119926 0.214641 0.976619    1 0.25
  v -22.3818 -13.1786 18.8836    -0.345416 0.555587 0.756314    1 0.125
  v -22.622 -13.0047 18.6462    -0.345419 0.555588 0.756312    1 0
  v -22.3818 -13.1786 18.8836    -0.345419 0.555588 0.756312    1 0.125
  v -17.3475 -17.397 18.9    0.0211682 0.324596 0.945616    0.9375 1
  v -17.1484 -17.2773 18.8545    0.0211682 0.324596 0.945616    0.875 1
  v -17.3475 -17.397 18.9    0.0211707 0.324596 0.945616    0.9375 1
  v -17.1484 -17.2773 18.8545    0.09626 0.359518 0.92816    0.875 1
  v -16.9358 -17.2014 18.803    0.09626 0.359518 0.92816    0.8125 1
  v -17.1484 -17.2773 18.8545    0.0962571 0.359518 0.92816    0.875 1
  v -16.9358 -17.2014 18.803    0.175532 0.378838 0.908664    0.8125 1
  v -16.7158 -17.1697 18.7473    0.175532 0.378838 0.908664    0.75 1
  v -16.9358 -17.2014 18.803    0.175528 0.378839 0.908664    0.8125 1
  v -16.7158 -17.1697 18.7473    0.256369 0.3823 0.887762    0.75 1
  v -16.4946 -17.1825 18.689    0.256369 0.3823 0.887762    0.6875 1
  v -16.7158 -17.1697 18.7473    0.256369 0.3823 0.887762    0.75 1
  v -16.4946 -17.1825 18.689    0.336434 0.3698 0.86606    0.6875 1
  v -16.2783 -17.24 18.6295    0.336434 0.3698 0.86606    0.625 1
  v -16.4946 -17.1825 18.689    0.336434 0.369801 0.86606    0.6875 1
  v -16.2783 -17.24 18.6295    0.413117 0.341377 0.844273    0.625 1
  v -16.0732 -17.3425 18.5705    0.413117 0.341377 0.844273    0.5625 1
  v -16.2783 -17.24 18.6295    0.413116 0.341377 0.844273    0.625 1
  v -16.0732 -17.3425 18.5705    0.483116 0.297648 0.82341    0.5625 1
  v -15.8853 -17.4902 18.5137    0.483116 0.297648 0.82341    0.5 1
  v -16.0732 -17.3425 18.5705    0.483118 0.297646 0.82341    0.5625 1
  v -15.8853 -17.4902 18.5137    0.542377 0.240659 0.804929    0.5 1
  v -15.7293 -17.6732 18.4633    0.542377 0.240659 0.804929    0.4375 1
  v -15.8853 -17.4902 18.5137    0.542377 0.240659 0.804929    0.5 1
  v -15.7293 -17.6732 18.4633    0.589651 0.171609 0.789216    0.4375 1
  v -15.6159 -17.8771 18.4229    0.589651 0.171609 0.789216    0.375 1
  v -15.7293 -17.6732 18.4633    0.589651 0.171609 0.789216    0.4375 1
  v -15.6159 -17.8771 18.4229    0.622566 0.094643 0.776823    0.375 1
  v -15.5452 -18.0955 18.3929    0.622566 0.094643 0.776823    0.3125 1
  v -15.6159 -17.8771 18.4229    0.622566 0.0946416 0.776823    0.375 1
  v -15.5452 -18.0955 18.3929    0.640278 0.0131124 0.768032    0.3125 1
  v -15.5175 -18.3221 18.3736    0.640278 0.0131124 0.768032    0.25 1
  v -15.5452 -18.0955 18.3929    0.640277 0.0131121 0.768032    0.3125 1
  v -15.5175 -18.3221 18.3736    0.642549 -0.07028 0.763015    0.25 1
  v -15.5328 -18.5506 18.3655    0.642549 -0.07028 0.763015    0.1875 1
  v -15.5175 -18.3221 18.3736    0.642551 -0.0702761 0.763014    0.25 1
  v -15.5328 -18.5506 18.3655    0.629322 -0.153108 0.761913    0.1875 1
  v -15.5914 -18.7745 18.3689    0.629322 -0.153108 0.761913    0.125 1
  v -15.5328 -18.5506 18.3655    0.62932 -0.153112 0.761914    0.1875 1
  v -15.5914 -18.7745 18.3689    0.600671 -0.232687 0.764886    0.125 1
  v -15.6935 -18.9876 18.3842    0.600671 -0.232687 0.764886    0.0625 1
  v -15.5914 -18.7745 18.3689    0.600671 -0.232687 0.764886    0.125 1
  v -15.6935 -18.9876 18.3842    0.557269 -0.305583 0.772056    0.0625 1
  v -15.8391 -19.1836 18.4118    0.557269 -0.305583 0.772056    0 1
  v -15.4727 -19.593 17.9853    0.557269 -0.305583 0.772056    0 0.875
  v -15.4727 -19.593 17.9853    0.55727 -0.305582 0.772056    0 0.875
  v -15.6935 -18.9876 18.3842    0.55727 -0.305582 0.772056    0.0625 1
  v -15.4727 -19.593 17.9853    0.436572 -0.20107 0.876913    0 0.875
  v -14.8926 -20.1959 17.5582    0.436572 -0.20107 0.876913    0 0.75
  v -14.8926 -20.1959 17.5582    0.436572 -0.20107 0.876913    0 0.75
  v -14.8926 -20.1959 17.5582    0.383708 -0.157104 0.909993    0 0.75
  v -14.1831 -20.9151 17.1349    0.383708 -0.157104 0.909993    0 0.625
  v -14.1831 -20.9151 17.1349    0.383707 -0.157104 0.909993    0 0.625
  v -14.1831 -20.9151 17.1349    0.364545 -0.141392 0.920389    0 0.625
  v -13.4288 -21.6734 16.7196    0.364545 -0.141392 0.920389    0 0.5
  v -13.4288 -21.6734 16.7196    0.364544 -0.141392 0.920389    0 0.5
  v -13.4288 -21.6734 16.7196    0.370111 -0.145945 0.917452    0 0.5
  v -12.7141 -22.3937 16.3167    0.370111 -0.145945 0.917452    0 0.375
  v -12.7141 -22.3937 16.3167    0.370112 -0.145945 0.917451    0 0.375
  v -12.7141 -22.3937 16.3167    0.406295 -0.175774 0.896676    0 0.375
  v -12.1233 -22.9988 15.9304    0.406295 -0.175774 0.896676    0 0.25
  v -12.1233 -22.9988 15.9304    0.406295 -0.175774 0.896676    0 0.25
  v -12.1233 -22.9988 15.9304    0.505548 -0.259993 0.822694    0 0.25
  v -11.7409 -23.4115 15.565    0.505548 -0.259993 0.822694    0 0.125
  v -11.7409 -23.4115 15.565    0.505548 -0.259993 0.822694    0 0.125
  v -11.7409 -23.4115 15.565    0.75799 -0.505517 0.412193    0 0.125
  v -11.6514 -23.5547 15.2248    0.75799 -0.505517 0.412193    0 0
  v -11.6514 -23.5547 15.2248    0.757991 -0.505517 0.412193    0 0
  t 0 9 10
  t 10 1 0
  t 1 10 11
  t 11 2 1
  t 2 11 12
  t 12 3 2
  t 3 12 13
  t 13 4 3
  t 4 13 14
  t 14 5 4
  t 5 14 15
  t 15 6 5
  t 6 15 16
  t 16 7 6
  t 7 16 17
  t 17 8 7
  t 9 18 19
  t 19 10 9
  t 10 19 20
  t 20 11 10
  t 11 20 21
  t 21 12 11
  t 12 21 22
  t 22 13 12
  t 13 22 23
  t 23 14 13
  t 14 23 24
  t 24 15 14
  t 15 24 25
  t 25 16 15
  t 16 25 26
  t 26 17 16
  t 18 27 28
  t 28 19 18
  t 19 28 29
  t 29 20 19
  t 20 29 30
  t 30 21 20
  t 21 30 31
  t 31 22 21
  t 22 31 32
  t 32 23 22
  t 23 32 33
  t 33 24 23
  t 24 33 34
  t 34 25 24
  t 25 34 35
  t 35 26 25
  t 27 36 37
  t 37 28 27
  t 28 37 38
  t 38 29 28
  t 29 38 39
  t 39 30 29
  t 30 39 40
  t 40 31 30
  t 31 40 41
  t 41 32 31
  t 32 41 42
  t 42 33 32
  t 33 42 43
  t 43 34 33
  t 34 43 44
  t 44 35 34
  t 36 45 46
  t 46 37 36
  t 37 46 47
  t 47 38 37
  t 38 47 48
  t 48 39 38
  t 39 48 49
  t 49 40 39
  t 40 49 50
  t 50 41 40
  t 41 50 51
  t 51 42 41
  t 42 51 52
  t 52 43 42
  t 43 52 53
  t 53 44 43
  t 45 54 55
  t 55 46 45
  t 46 55 56
  t 56 47 46
  t 47 56 57
  t 57 48 47
  t 48 57 58
  t 58 49 48
  t 49 58 59
  t 59 50 49
  t 50 59 60
  t 60 51 50
  t 51 60 61
  t 61 52 51
  t 52 61 62
  t 62 53 52
  t 54 63 64
  t 64 55 54
  t 55 64 65
  t 65 56 55
  t 56 65 66
  t 66 57 56
  t 57 66 67
  t 67 58 57
  t 58 67 68
  t 68 59 58
  t 59 68 69
  t 69 60 59
  t 60 69 70
  t 70 61 60
  t 61 70 71
  t 71 62 61
  t 63 72 73
  t 73 64 63
  t 64 73 74
  t 74 65 64
  t 65 74 75
  t 75 66 65
  t 66 75 76
  t 76 67 66
  t 67 76 77
  t 77 68 67
  t 68 77 78
  t 78 69 68
  t 69 78 79
  t 79 70 69
  t 70 79 80
  t 80 71 70
  t 72 81 82
  t 82 73 72
  t 73 82 83
  t 83 74 73
  t 74 83 84
  t 84 75 74
  t 75 84 85
  t 85 76 75
  t 76 85 86
  t 86 77 76
  t 77 86 87
  t 87 78 77
  t 78 87 88
  t 88 79 78
  t 79 88 89
  t 89 80 79
  t 81 90 91
  t 91 82 81
  t 82 91 92
  t 92 83 82
  t 83 92 93
  t 93 84 83
  t 84 93 94
  t 94 85 84
  t 85 94 95
  t 95 86 85
  t 86 95 96
  t 96 87 86
  t 87 96 97
  t 97 88 87
  t 88 97 98
  t 98 89 88
  t 90 99 100
  t 100 91 90
  t 91 100 101
  t 101 92 91
  t 92 101 102
  t 102 93 92
  t 93 102 103
  t 103 94 93
  t 94 103 104
  t 104 95 94
  t 95 104 105
  t 105 96 95
  t 96 105 106
  t 106 97 96
  t 97 106 107
  t 107 98 97
  t 99 108 109
  t 109 100 99
  t 100 109 110
  t 110 101 100
  t 101 110 111
  t 111 102 101
  t 102 111 112
  t 112 103 102
  t 103 112 113
  t 113 104 103
  t 104 113 114
  t 114 105 104
  t 105 114 115
  t 115 106 105
  t 106 115 116
  t 116 107 106
  t 108 117 118
  t 118 109 108
  t 109 118 119
  t 119 110 109
  t 110 119 120
  t 120 111 110
  t 111 120 121
  t 121 112 111
  t 112 121 122
  t 122 113 112
  t 113 122 123
  t 123 114 113
  t 114 123 124
  t 124 115 114
  t 115 124 125
  t 125 116 115
  t 117 126 127
  t 127 118 117
  t 118 127 128
  t 128 119 118
  t 119 128 129
  t 129 120 119
  t 120 129 130
  t 130 121 120
  t 121 130 131
  t 131 122 121
  t 122 131 132
  t 132 123 122
  t 123 132 133
  t 133 124 123
  t 124 133 134
  t 134 125 124
  t 126 135 136
  t 136 127 126
  t 127 136 137
  t 137 128 127
  t 128 137 138
  t 138 129 128
  t 129 138 139
  t 139 130 129
  t 130 139 140
  t 140 131 130
  t 131 140 141
  t 141 132 131
  t 132 141 142
  t 142 133 132
  t 133 142 143
  t 143 134 133
  t 135 144 145
  t 145 136 135
  t 136 145 146
  t 146 137 136
  t 137 146 147
  t 147 138 137
  t 138 147 148
  t 148 139 138
  t 139 148 149
  t 149 140 139
  t 140 149 150
  t 150 141 140
  t 141 150 151
  t 151 142 141
  t 142 151 152
  t 152 143 142
  t 2082 153 154
  t 154 2083 2084
  t 2085 154 155
  t 155 2086 2087
  t 2088 155 156
  t 156 2089 2090
  t 2091 156 157
  t 157 2092 2093
  t 2094 157 158
  t 158 2095 2096
  t 2097 158 159
  t 159 2098 2099
  t 2100 159 160
  t 160 2101 2102
  t 2103 160 161
  t 161 2104 2105
  t 153 162 163
  t 163 154 153
  t 154 163 164
  t 164 155 154
  t 155 164 165
  t 165 156 155
  t 156 165 166
  t 166 157 156
  t 157 166 167
  t 167 158 157
  t 158 167 168
  t 168 159 158
  t 159 168 169
  t 169 160 159
  t 160 169 170
  t 170 161 160
  t 162 171 172
  t 172 163 162
  t 163 172 173
  t 173 164 163
  t 164 173 174
  t 174 165 164
  t 165 174 175
  t 175 166 165
  t 166 175 176
  t 176 167 166
  t 167 176 177
  t 177 168 167
  t 168 177 178
  t 178 169 168
  t 169 178 179
  t 179 170 169
  t 171 180 181
  t 181 172 171
  t 172 181 182
  t 182 173 172
  t 173 182 183
  t 183 174 173
  t 174 183 184
  t 184 175 174
  t 175 184 185
  t 185 176 175
  t 176 185 186
  t 186 177 176
  t 177 186 187
  t 187 178 177
  t 178 187 188
  t 188 179 178
  t 180 189 190
  t 190 181 180
  t 181 190 191
  t 191 182 181
  t 182 191 192
  t 192 183 182
  t 183 192 193
  t 193 184 183
  t 184 193 194
  t 194 185 184
  t 185 194 195
  t 195 186 185
  t 186 195 196
  t 196 187 186
  t 187 196 197
  t 197 188 187
  t 189 198 199
  t 199 190 189
  t 190 199 200
  t 200 191 190
  t 191 200 201
  t 201 192 191
  t 192 201 202
  t 202 193 192
  t 193 202 203
  t 203 194 193
  t 194 203 204
  t 204 195 194
  t 195 204 205
  t 205 196 195
  t 196 205 206
  t 206 197 196
  t 198 207 208
  t 208 199 198
  t 199 208 209
  t 209 200 199
  t 200 209 210
  t 210 201 200
  t 201 210 211
  t 211 202 201
  t 202 211 212
  t 212 203 202
  t 203 212 213
  t 213 204 203
  t 204 213 214
  t 214 205 204
  t 205 214 215
  t 215 206 205
  t 207 216 217
  t 217 208 207
  t 208 217 218
  t 218 209 208
  t 209 218 219
  t 219 210 209
  t 210 219 220
  t 220 211 210
  t 211 220 221
  t 221 212 211
  t 212 221 222
  t 222 213 212
  t 213 222 223
  t 223 214 213
  t 214 223 224
  t 224 215 214
  t 216 225 226
  t 226 217 216
  t 217 226 227
  t 227 218 217
  t 218 227 228
  t 228 219 218
  t 219 228 229
  t 229 220 219
  t 220 229 230
  t 230 221 220
  t 221 230 231
  t 231 222 221
  t 222 231 232
  t 232 223 222
  t 223 232 233
  t 233 224 223
  t 225 234 235
  t 235 226 225
  t 226 235 236
  t 236 227 226
  t 227 236 237
  t 237 228 227
  t 228 237 238
  t 238 229 228
  t 229 238 239
  t 239 230 229
  t 230 239 240
  t 240 231 230
  t 231 240 241
  t 241 232 231
  t 232 241 242
  t 242 233 232
  t 234 243 244
  t 244 235 234
  t 235 244 245
  t 245 236 235
  t 236 245 246
  t 246 237 236
  t 237 246 247
  t 247 238 237
  t 238 247 248
  t 248 239 238
  t 239 248 249
  t 249 240 239
  t 240 249 250
  t 250 241 240
  t 241 250 251
  t 251 242 241
  t 243 252 253
  t 253 244 243
  t 244 253 254
  t 254 245 244
  t 245 254 255
  t 255 246 245
  t 246 255 256
  t 256 247 246
  t 247 256 257
  t 257 248 247
  t 248 257 258
  t 258 249 248
  t 249 258 259
  t 259 250 249
  t 250 259 260
  t 260 251 250
  t 252 261 262
  t 262 253 252
  t 253 262 263
  t 263 254 253
  t 254 263 264
  t 264 255 254
  t 255 264 265
  t 265 256 255
  t 256 265 266
  t 266 257 256
  t 257 266 267
  t 267 258 257
  t 258 267 268
  t 268 259 258
  t 259 268 269
  t 269 260 259
  t 261 270 271
  t 271 262 261
  t 262 271 272
  t 272 263 262
  t 263 272 273
  t 273 264 263
  t 264 273 274
  t 274 265 264
  t 265 274 275
  t 275 266 265
  t 266 275 276
  t 276 267 266
  t 267 276 277
  t 277 268 267
  t 268 277 278
  t 278 269 268
  t 270 279 280
  t 280 271 270
  t 271 280 281
  t 281 272 271
  t 272 281 282
  t 282 273 272
  t 273 282 283
  t 283 274 273
  t 274 283 284
  t 284 275 274
  t 275 284 285
  t 285 276 275
  t 276 285 286
  t 286 277 276
  t 277 286 287
  t 287 278 277
  t 279 2106 2107
  t 2108 280 279
  t 280 2109 2110
  t 2111 281 280
  t 281 2112 2113
  t 2114 282 281
  t 282 2115 2116
  t 2117 283 282
  t 283 2118 2119
  t 2120 284 283
  t 284 2121 2122
  t 2123 285 284
  t 285 2124 2125
  t 2126 286 285
  t 286 2127 2128
  t 2129 287 286
  t 8 17 296
  t 296 288 8
  t 288 296 297
  t 297 289 288
  t 289 297 298
  t 298 290 289
  t 290 298 299
  t 299 291 290
  t 291 299 300
  t 300 292 291
  t 292 300 301
  t 301 293 292
  t 293 301 302
  t 302 294 293
  t 294 302 303
  t 303 295 294
  t 17 26 304
  t 304 296 17
  t 296 304 305
  t 305 297 296
  t 297 305 306
  t 306 298 297
  t 298 306 307
  t 307 299 298
  t 299 307 308
  t 308 300 299
  t 300 308 309
  t 309 301 300
  t 301 309 310
  t 310 302 301
  t 302 310 311
  t 311 303 302
  t 26 35 312
  t 312 304 26
  t 304 312 313
  t 313 305 304
  t 305 313 314
  t 314 306 305
  t 306 314 315
  t 315 307 306
  t 307 315 316
  t 316 308 307
  t 308 316 317
  t 317 309 308
  t 309 317 318
  t 318 310 309
  t 310 318 319
  t 319 311 310
  t 35 44 320
  t 320 312 35
  t 312 320 321
  t 321 313 312
  t 313 321 322
  t 322 314 313
  t 314 322 323
  t 323 315 314
  t 315 323 324
  t 324 316 315
  t 316 324 325
  t 325 317 316
  t 317 325 326
  t 326 318 317
  t 318 326 327
  t 327 319 318
  t 44 53 328
  t 328 320 44
  t 320 328 329
  t 329 321 320
  t 321 329 330
  t 330 322 321
  t 322 330 331
  t 331 323 322
  t 323 331 332
  t 332 324 323
  t 324 332 333
  t 333 325 324
  t 325 333 334
  t 334 326 325
  t 326 334 335
  t 335 327 326
  t 53 62 336
  t 336 328 53
  t 328 336 337
  t 337 329 328
  t 329 337 338
  t 338 330 329
  t 330 338 339
  t 339 331 330
  t 331 339 340
  t 340 332 331
  t 332 340 341
  t 341 333 332
  t 333 341 342
  t 342 334 333
  t 334 342 343
  t 343 335 334
  t 62 71 344
  t 344 336 62
  t 336 344 345
  t 345 337 336
  t 337 345 346
  t 346 338 337
  t 338 346 347
  t 347 339 338
  t 339 347 348
  t 348 340 339
  t 340 348 349
  t 349 341 340
  t 341 349 350
  t 350 342 341
  t 342 350 351
  t 351 343 342
  t 71 80 352
  t 352 344 71
  t 344 352 353
  t 353 345 344
  t 345 353 354
  t 354 346 345
  t 346 354 355
  t 355 347 346
  t 347 355 356
  t 356 348 347
  t 348 356 357
  t 357 349 348
  t 349 357 358
  t 358 350 349
  t 350 358 359
  t 359 351 350
  t 80 89 360
  t 360 352 80
  t 352 360 361
  t 361 353 352
  t 353 361 362
  t 362 354 353
  t 354 362 363
  t 363 355 354
  t 355 363 364
  t 364 356 355
  t 356 364 365
  t 365 357 356
  t 357 365 366
  t 366 358 357
  t 358 366 367
  t 367 359 358
  t 89 98 368
  t 368 360 89
  t 360 368 369
  t 369 361 360
  t 361 369 370
  t 370 362 361
  t 362 370 371
  t 371 363 362
  t 363 371 372
  t 372 364 363
  t 364 372 373
  t 373 365 364
  t 365 373 374
  t 374 366 365
  t 366 374 375
  t 375 367 366
  t 98 107 376
  t 376 368 98
  t 368 376 377
  t 377 369 368
  t 369 377 378
  t 378 370 369
  t 370 378 379
  t 379 371 370
  t 371 379 380
  t 380 372 371
  t 372 380 381
  t 381 373 372
  t 373 381 382
  t 382 374 373
  t 374 382 383
  t 383 375 374
  t 107 116 384
  t 384 376 107
  t 376 384 385
  t 385 377 376
  t 377 385 386
  t 386 378 377
  t 378 386 387
  t 387 379 378
  t 379 387 388
  t 388 380 379
  t 380 388 389
  t 389 381 380
  t 381 389 390
  t 390 382 381
  t 382 390 391
  t 391 383 382
  t 116 125 392
  t 392 384 116
  t 384 392 393
  t 393 385 384
  t 385 393 394
  t 394 386 385
  t 386 394 395
  t 395 387 386
  t 387 395 396
  t 396 388 387
  t 388 396 397
  t 397 389 388
  t 389 397 398
  t 398 390 389
  t 390 398 399
  t 399 391 390
  t 125 134 400
  t 400 392 125
  t 392 400 401
  t 401 393 392
  t 393 401 402
  t 402 394 393
  t 394 402 403
  t 403 395 394
  t 395 403 404
  t 404 396 395
  t 396 404 405
  t 405 397 396
  t 397 405 406
  t 406 398 397
  t 398 406 407
  t 407 399 398
  t 134 143 408
  t 408 400 134
  t 400 408 409
  t 409 401 400
  t 401 409 410
  t 410 402 401
  t 402 410 411
  t 411 403 402
  t 403 411 412
  t 412 404 403
  t 404 412 413
  t 413 405 404
  t 405 413 414
  t 414 406 405
  t 406 414 415
  t 415 407 406
  t 143 152 416
  t 416 408 143
  t 408 416 417
  t 417 409 408
  t 409 417 418
  t 418 410 409
  t 410 418 419
  t 419 411 410
  t 411 419 420
  t 420 412 411
  t 412 420 421
  t 421 413 412
  t 413 421 422
  t 422 414 413
  t 414 422 423
  t 423 415 414
  t 2130 161 424
  t 424 2131 2132
  t 2133 424 425
  t 425 2134 2135
  t 2136 425 426
  t 426 2137 2138
  t 2139 426 427
  t 427 2140 2141
  t 2142 427 428
  t 428 2143 2144
  t 2145 428 429
  t 429 2146 2147
  t 2148 429 430
  t 430 2149 2150
  t 2151 430 431
  t 431 2152 2153
  t 161 170 432
  t 432 424 161
  t 424 432 433
  t 433 425 424
  t 425 433 434
  t 434 426 425
  t 426 434 435
  t 435 427 426
  t 427 435 436
  t 436 428 427
  t 428 436 437
  t 437 429 428
  t 429 437 438
  t 438 430 429
  t 430 438 439
  t 439 431 430
  t 170 179 440
  t 440 432 170
  t 432 440 441
  t 441 433 432
  t 433 441 442
  t 442 434 433
  t 434 442 443
  t 443 435 434
  t 435 443 444
  t 444 436 435
  t 436 444 445
  t 445 437 436
  t 437 445 446
  t 446 438 437
  t 438 446 447
  t 447 439 438
  t 179 188 448
  t 448 440 179
  t 440 448 449
  t 449 441 440
  t 441 449 450
  t 450 442 441
  t 442 450 451
  t 451 443 442
  t 443 451 452
  t 452 444 443
  t 444 452 453
  t 453 445 444
  t 445 453 454
  t 454 446 445
  t 446 454 455
  t 455 447 446
  t 188 197 456
  t 456 448 188
  t 448 456 457
  t 457 449 448
  t 449 457 458
  t 458 450 449
  t 450 458 459
  t 459 451 450
  t 451 459 460
  t 460 452 451
  t 452 460 461
  t 461 453 452
  t 453 461 462
  t 462 454 453
  t 454 462 463
  t 463 455 454
  t 197 206 464
  t 464 456 197
  t 456 464 465
  t 465 457 456
  t 457 465 466
  t 466 458 457
  t 458 466 467
  t 467 459 458
  t 459 467 468
  t 468 460 459
  t 460 468 469
  t 469 461 460
  t 461 469 470
  t 470 462 461
  t 462 470 471
  t 471 463 462
  t 206 215 472
  t 472 464 206
  t 464 472 473
  t 473 465 464
  t 465 473 474
  t 474 466 465
  t 466 474 475
  t 475 467 466
  t 467 475 476
  t 476 468 467
  t 468 476 477
  t 477 469 468
  t 469 477 478
  t 478 470 469
  t 470 478 479
  t 479 471 470
  t 215 224 480
  t 480 472 215
  t 472 480 481
  t 481 473 472
  t 473 481 482
  t 482 474 473
  t 474 482 483
  t 483 475 474
  t 475 483 484
  t 484 476 475
  t 476 484 485
  t 485 477 476
  t 477 485 486
  t 486 478 477
  t 478 486 487
  t 487 479 478
  t 224 233 488
  t 488 480 224
  t 480 488 489
  t 489 481 480
  t 481 489 490
  t 490 482 481
  t 482 490 491
  t 491 483 482
  t 483 491 492
  t 492 484 483
  t 484 492 493
  t 493 485 484
  t 485 493 494
  t 494 486 485
  t 486 494 495
  t 495 487 486
  t 233 242 496
  t 496 488 233
  t 488 496 497
  t 497 489 488
  t 489 497 498
  t 498 490 489
  t 490 498 499
  t 499 491 490
  t 491 499 500
  t 500 492 491
  t 492 500 501
  t 501 493 492
  t 493 501 502
  t 502 494 493
  t 494 502 503
  t 503 495 494
  t 242 251 504
  t 504 496 242
  t 496 504 505
  t 505 497 496
  t 497 505 506
  t 506 498 497
  t 498 506 507
  t 507 499 498
  t 499 507 508
  t 508 500 499
  t 500 508 509
  t 509 501 500
  t 501 509 510
  t 510 502 501
  t 502 510 511
  t 511 503 502
  t 251 260 512
  t 512 504 251
  t 504 512 513
  t 513 505 504
  t 505 513 514
  t 514 506 505
  t 506 514 515
  t 515 507 506
  t 507 515 516
  t 516 508 507
  t 508 516 517
  t 517 509 508
  t 509 517 518
  t 518 510 509
  t 510 518 519
  t 519 511 510
  t 260 269 520
  t 520 512 260
  t 512 520 521
  t 521 513 512
  t 513 521 522
  t 522 514 513
  t 514 522 523
  t 523 515 514
  t 515 523 524
  t 524 516 515
  t 516 524 525
  t 525 517 516
  t 517 525 526
  t 526 518 517
  t 518 526 527
  t 527 519 518
  t 269 278 528
  t 528 520 269
  t 520 528 529
  t 529 521 520
  t 521 529 530
  t 530 522 521
  t 522 530 531
  t 531 523 522
  t 523 531 532
  t 532 524 523
  t 524 532 533
  t 533 525 524
  t 525 533 534
  t 534 526 525
  t 526 534 535
  t 535 527 526
  t 278 287 536
  t 536 528 278
  t 528 536 537
  t 537 529 528
  t 529 537 538
  t 538 530 529
  t 530 538 539
  t 539 531 530
  t 531 539 540
  t 540 532 531
  t 532 540 541
  t 541 533 532
  t 533 541 542
  t 542 534 533
  t 534 542 543
  t 543 535 534
  t 287 2154 2155
  t 2156 536 287
  t 536 2157 2158
  t 2159 537 536
  t 537 2160 2161
  t 2162 538 537
  t 538 2163 2164
  t 2165 539 538
  t 539 2166 2167
  t 2168 540 539
  t 540 2169 2170
  t 2171 541 540
  t 541 2172 2173
  t 2174 542 541
  t 542 2175 2176
  t 2177 543 542
  t 295 303 552
  t 552 544 295
  t 544 552 553
  t 553 545 544
  t 545 553 554
  t 554 546 545
  t 546 554 555
  t 555 547 546
  t 547 555 556
  t 556 548 547
  t 548 556 557
  t 557 549 548
  t 549 557 558
  t 558 550 549
  t 550 558 559
  t 559 551 550
  t 303 311 560
  t 560 552 303
  t 552 560 561
  t 561 553 552
  t 553 561 562
  t 562 554 553
  t 554 562 563
  t 563 555 554
  t 555 563 564
  t 564 556 555
  t 556 564 565
  t 565 557 556
  t 557 565 566
  t 566 558 557
  t 558 566 567
  t 567 559 558
  t 311 319 568
  t 568 560 311
  t 560 568 569
  t 569 561 560
  t 561 569 570
  t 570 562 561
  t 562 570 571
  t 571 563 562
  t 563 571 572
  t 572 564 563
  t 564 572 573
  t 573 565 564
  t 565 573 574
  t 574 566 565
  t 566 574 575
  t 575 567 566
  t 319 327 576
  t 576 568 319
  t 568 576 577
  t 577 569 568
  t 569 577 578
  t 578 570 569
  t 570 578 579
  t 579 571 570
  t 571 579 580
  t 580 572 571
  t 572 580 581
  t 581 573 572
  t 573 581 582
  t 582 574 573
  t 574 582 583
  t 583 575 574
  t 327 335 584
  t 584 576 327
  t 576 584 585
  t 585 577 576
  t 577 585 586
  t 586 578 577
  t 578 586 587
  t 587 579 578
  t 579 587 588
  t 588 580 579
  t 580 588 589
  t 589 581 580
  t 581 589 590
  t 590 582 581
  t 582 590 591
  t 591 583 582
  t 335 343 592
  t 592 584 335
  t 584 592 593
  t 593 585 584
  t 585 593 594
  t 594 586 585
  t 586 594 595
  t 595 587 586
  t 587 595 596
  t 596 588 587
  t 588 596 597
  t 597 589 588
  t 589 597 598
  t 598 590 589
  t 590 598 599
  t 599 591 590
  t 343 351 600
  t 600 592 343
  t 592 600 601
  t 601 593 592
  t 593 601 602
  t 602 594 593
  t 594 602 603
  t 603 595 594
  t 595 603 604
  t 604 596 595
  t 596 604 605
  t 605 597 596
  t 597 605 606
  t 606 598 597
  t 598 606 607
  t 607 599 598
  t 351 359 608
  t 608 600 351
  t 600 608 609
  t 609 601 600
  t 601 609 610
  t 610 602 601
  t 602 610 611
  t 611 603 602
  t 603 611 612
  t 612 604 603
  t 604 612 613
  t 613 605 604
  t 605 613 614
  t 614 606 605
  t 606 614 615
  t 615 607 606
  t 359 367 616
  t 616 608 359
  t 608 616 617
  t 617 609 608
  t 609 617 618
  t 618 610 609
  t 610 618 619
  t 619 611 610
  t 611 619 620
  t 620 612 611
  t 612 620 621
  t 621 613 612
  t 613 621 622
  t 622 614 613
  t 614 622 623
  t 623 615 614
  t 367 375 624
  t 624 616 367
  t 616 624 625
  t 625 617 616
  t 617 625 626
  t 626 618 617
  t 618 626 627
  t 627 619 618
  t 619 627 628
  t 628 620 619
  t 620 628 629
  t 629 621 620
  t 621 629 630
  t 630 622 621
  t 622 630 631
  t 631 623 622
  t 375 383 632
  t 632 624 375
  t 624 632 633
  t 633 625 624
  t 625 633 634
  t 634 626 625
  t 626 634 635
  t 635 627 626
  t 627 635 636
  t 636 628 627
  t 628 636 637
  t 637 629 628
  t 629 637 638
  t 638 630 629
  t 630 638 639
  t 639 631 630
  t 383 391 640
  t 640 632 383
  t 632 640 641
  t 641 633 632
  t 633 641 642
  t 642 634 633
  t 634 642 643
  t 643 635 634
  t 635 643 644
  t 644 636 635
  t 636 644 645
  t 645 637 636
  t 637 645 646
  t 646 638 637
  t 638 646 647
  t 647 639 638
  t 391 399 648
  t 648 640 391
  t 640 648 649
  t 649 641 640
  t 641 649 650
  t 650 642 641
  t 642 650 651
  t 651 643 642
  t 643 651 652
  t 652 644 643
  t 644 652 653
  t 653 645 644
  t 645 653 654
  t 654 646 645
  t 646 654 655
  t 655 647 646
  t 399 407 656
  t 656 648 399
  t 648 656 657
  t 657 649 648
  t 649 657 658
  t 658 650 649
  t 650 658 659
  t 659 651 650
  t 651 659 660
  t 660 652 651
  t 652 660 661
  t 661 653 652
  t 653 661 662
  t 662 654 653
  t 654 662 663
  t 663 655 654
  t 407 415 664
  t 664 656 407
  t 656 664 665
  t 665 657 656
  t 657 665 666
  t 666 658 657
  t 658 666 667
  t 667 659 658
  t 659 667 668
  t 668 660 659
  t 660 668 669
  t 669 661 660
  t 661 669 670
  t 670 662 661
  t 662 670 671
  t 671 663 662
  t 415 423 672
  t 672 664 415
  t 664 672 673
  t 673 665 664
  t 665 673 674
  t 674 666 665
  t 666 674 675
  t 675 667 666
  t 667 675 676
  t 676 668 667
  t 668 676 677
  t 677 669 668
  t 669 677 678
  t 678 670 669
  t 670 678 679
  t 679 671 670
  t 2178 431 680
  t 680 2179 2180
  t 2181 680 681
  t 681 2182 2183
  t 2184 681 682
  t 682 2185 2186
  t 2187 682 683
  t 683 2188 2189
  t 2190 683 684
  t 684 2191 2192
  t 2193 684 685
  t 685 2194 2195
  t 2196 685 686
  t 686 2197 2198
  t 2199 686 687
  t 687 2200 2201
  t 431 439 688
  t 688 680 431
  t 680 688 689
  t 689 681 680
  t 681 689 690
  t 690 682 681
  t 682 690 691
  t 691 683 682
  t 683 691 692
  t 692 684 683
  t 684 692 693
  t 693 685 684
  t 685 693 694
  t 694 686 685
  t 686 694 695
  t 695 687 686
  t 439 447 696
  t 696 688 439
  t 688 696 697
  t 697 689 688
  t 689 697 698
  t 698 690 689
  t 690 698 699
  t 699 691 690
  t 691 699 700
  t 700 692 691
  t 692 700 701
  t 701 693 692
  t 693 701 702
  t 702 694 693
  t 694 702 703
  t 703 695 694
  t 447 455 704
  t 704 696 447
  t 696 704 705
  t 705 697 696
  t 697 705 706
  t 706 698 697
  t 698 706 707
  t 707 699 698
  t 699 707 708
  t 708 700 699
  t 700 708 709
  t 709 701 700
  t 701 709 710
  t 710 702 701
  t 702 710 711
  t 711 703 702
  t 455 463 712
  t 712 704 455
  t 704 712 713
  t 713 705 704
  t 705 713 714
  t 714 706 705
  t 706 714 715
  t 715 707 706
  t 707 715 716
  t 716 708 707
  t 708 716 717
  t 717 709 708
  t 709 717 718
  t 718 710 709
  t 710 718 719
  t 719 711 710
  t 463 471 720
  t 720 712 463
  t 712 720 721
  t 721 713 712
  t 713 721 722
  t 722 714 713
  t 714 722 723
  t 723 715 714
  t 715 723 724
  t 724 716 715
  t 716 724 725
  t 725 717 716
  t 717 725 726
  t 726 718 717
  t 718 726 727
  t 727 719 718
  t 471 479 728
  t 728 720 471
  t 720 728 729
  t 729 721 720
  t 721 729 730
  t 730 722 721
  t 722 730 731
  t 731 723 722
  t 723 731 732
  t 732 724 723
  t 724 732 733
  t 733 725 724
  t 725 733 734
  t 734 726 725
  t 726 734 735
  t 735 727 726
  t 479 487 736
  t 736 728 479
  t 728 736 737
  t 737 729 728
  t 729 737 738
  t 738 730 729
  t 730 738 739
  t 739 731 730
  t 731 739 740
  t 740 732 731
  t 732 740 741
  t 741 733 732
  t 733 741 742
  t 742 734 733
  t 734 742 743
  t 743 735 734
  t 487 495 744
  t 744 736 487
  t 736 744 745
  t 745 737 736
  t 737 745 746
  t 746 738 737
  t 738 746 747
  t 747 739 738
  t 739 747 748
  t 748 740 739
  t 740 748 749
  t 749 741 740
  t 741 749 750
  t 750 742 741
  t 742 750 751
  t 751 743 742
  t 495 503 752
  t 752 744 495
  t 744 752 753
  t 753 745 744
  t 745 753 754
  t 754 746 745
  t 746 754 755
  t 755 747 746
  t 747 755 756
  t 756 748 747
  t 748 756 757
  t 757 749 748
  t 749 757 758
  t 758 750 749
  t 750 758 759
  t 759 751 750
  t 503 511 760
  t 760 752 503
  t 752 760 761
  t 761 753 752
  t 753 761 762
  t 762 754 753
  t 754 762 763
  t 763 755 754
  t 755 763 764
  t 764 756 755
  t 756 764 765
  t 765 757 756
  t 757 765 766
  t 766 758 757
  t 758 766 767
  t 767 759 758
  t 511 519 768
  t 768 760 511
  t 760 768 769
  t 769 761 760
  t 761 769 770
  t 770 762 761
  t 762 770 771
  t 771 763 762
  t 763 771 772
  t 772 764 763
  t 764 772 773
  t 773 765 764
  t 765 773 774
  t 774 766 765
  t 766 774 775
  t 775 767 766
  t 519 527 776
  t 776 768 519
  t 768 776 777
  t 777 769 768
  t 769 777 778
  t 778 770 769
  t 770 778 779
  t 779 771 770
  t 771 779 780
  t 780 772 771
  t 772 780 781
  t 781 773 772
  t 773 781 782
  t 782 774 773
  t 774 782 783
  t 783 775 774
  t 527 535 784
  t 784 776 527
  t 776 784 785
  t 785 777 776
  t 777 785 786
  t 786 778 777
  t 778 786 787
  t 787 779 778
  t 779 787 788
  t 788 780 779
  t 780 788 789
  t 789 781 780
  t 781 789 790
  t 790 782 781
  t 782 790 791
  t 791 783 782
  t 535 543 792
  t 792 784 535
  t 784 792 793
  t 793 785 784
  t 785 793 794
  t 794 786 785
  t 786 794 795
  t 795 787 786
  t 787 795 796
  t 796 788 787
  t 788 796 797
  t 797 789 788
  t 789 797 798
  t 798 790 789
  t 790 798 799
  t 799 791 790
  t 543 2202 2203
  t 2204 792 543
  t 792 2205 2206
  t 2207 793 792
  t 793 2208 2209
  t 2210 794 793
  t 794 2211 2212
  t 2213 795 794
  t 795 2214 2215
  t 2216 796 795
  t 796 2217 2218
  t 2219 797 796
  t 797 2220 2221
  t 2222 798 797
  t 798 2223 2224
  t 2225 799 798
  t 2226 2227 808
  t 808 800 2228
  t 800 808 809
  t 809 801 800
  t 801 809 810
  t 810 802 801
  t 802 810 811
  t 811 803 802
  t 803 811 812
  t 812 804 803
  t 804 812 813
  t 813 805 804
  t 805 813 814
  t 814 806 805
  t 806 814 807
  t 807 2229 806
  t 2230 2231 815
  t 815 808 2232
  t 808 815 816
  t 816 809 808
  t 809 816 817
  t 817 810 809
  t 810 817 818
  t 818 811 810
  t 811 818 819
  t 819 812 811
  t 812 819 820
  t 820 813 812
  t 813 820 821
  t 821 814 813
  t 814 821 2233
  t 2234 807 814
  t 2235 2236 822
  t 822 815 2237
  t 815 822 823
  t 823 816 815
  t 816 823 824
  t 824 817 816
  t 817 824 825
  t 825 818 817
  t 818 825 826
  t 826 819 818
  t 819 826 827
  t 827 820 819
  t 820 827 828
  t 828 821 820
  t 821 828 2238
  t 2239 2240 821
  t 2241 2242 829
  t 829 822 2243
  t 822 829 830
  t 830 823 822
  t 823 830 831
  t 831 824 823
  t 824 831 832
  t 832 825 824
  t 825 832 833
  t 833 826 825
  t 826 833 834
  t 834 827 826
  t 827 834 835
  t 835 828 827
  t 828 835 2244
  t 2245 2246 828
  t 2247 2248 836
  t 836 829 2249
  t 829 836 837
  t 837 830 829
  t 830 837 838
  t 838 831 830
  t 831 838 839
  t 839 832 831
  t 832 839 840
  t 840 833 832
  t 833 840 841
  t 841 834 833
  t 834 841 842
  t 842 835 834
  t 835 842 2250
  t 2251 2252 835
  t 2253 2254 843
  t 843 836 2255
  t 836 843 844
  t 844 837 836
  t 837 844 845
  t 845 838 837
  t 838 845 846
  t 846 839 838
  t 839 846 847
  t 847 840 839
  t 840 847 848
  t 848 841 840
  t 841 848 849
  t 849 842 841
  t 842 849 2256
  t 2257 2258 842
  t 2259 2260 850
  t 850 843 2261
  t 843 850 851
  t 851 844 843
  t 844 851 852
  t 852 845 844
  t 845 852 853
  t 853 846 845
  t 846 853 854
  t 854 847 846
  t 847 854 855
  t 855 848 847
  t 848 855 856
  t 856 849 848
  t 849 856 2262
  t 2263 2264 849
  t 2265 2266 857
  t 857 850 2267
  t 850 857 858
  t 858 851 850
  t 851 858 859
  t 859 852 851
  t 852 859 860
  t 860 853 852
  t 853 860 861
  t 861 854 853
  t 854 861 862
  t 862 855 854
  t 855 862 863
  t 863 856 855
  t 856 863 2268
  t 2269 2270 856
  t 2271 2272 864
  t 864 857 2273
  t 857 864 865
  t 865 858 857
  t 858 865 866
  t 866 859 858
  t 859 866 867
  t 867 860 859
  t 860 867 868
  t 868 861 860
  t 861 868 869
  t 869 862 861
  t 862 869 870
  t 870 863 862
  t 863 870 2274
  t 2275 2276 863
  t 2277 2278 871
  t 871 864 2279
  t 864 871 872
  t 872 865 864
  t 865 872 873
  t 873 866 865
  t 866 873 874
  t 874 867 866
  t 867 874 875
  t 875 868 867
  t 868 875 876
  t 876 869 868
  t 869 876 877
  t 877 870 869
  t 870 877 2280
  t 2281 2282 870
  t 2283 2284 878
  t 878 871 2285
  t 871 878 879
  t 879 872 871
  t 872 879 880
  t 880 873 872
  t 873 880 881
  t 881 874 873
  t 874 881 882
  t 882 875 874
  t 875 882 883
  t 883 876 875
  t 876 883 884
  t 884 877 876
  t 877 884 2286
  t 2287 2288 877
  t 2289 2290 885
  t 885 878 2291
  t 878 885 886
  t 886 879 878
  t 879 886 887
  t 887 880 879
  t 880 887 888
  t 888 881 880
  t 881 888 889
  t 889 882 881
  t 882 889 890
  t 890 883 882
  t 883 890 891
  t 891 884 883
  t 884 891 2292
  t 2293 2294 884
  t 2295 2296 892
  t 892 885 2297
  t 885 892 893
  t 893 886 885
  t 886 893 894
  t 894 887 886
  t 887 894 895
  t 895 888 887
  t 888 895 896
  t 896 889 888
  t 889 896 897
  t 897 890 889
  t 890 897 898
  t 898 891 890
  t 891 898 2298
  t 2299 2300 891
  t 2301 2302 899
  t 899 892 2303
  t 892 899 900
  t 900 893 892
  t 893 900 901
  t 901 894 893
  t 894 901 902
  t 902 895 894
  t 895 902 903
  t 903 896 895
  t 896 903 904
  t 904 897 896
  t 897 904 905
  t 905 898 897
  t 898 905 2304
  t 2305 2306 898
  t 2307 2308 906
  t 906 899 2309
  t 899 906 907
  t 907 900 899
  t 900 907 908
  t 908 901 900
  t 901 908 909
  t 909 902 901
  t 902 909 910
  t 910 903 902
  t 903 910 911
  t 911 904 903
  t 904 911 912
  t 912 905 904
  t 905 912 2310
  t 2311 2312 905
  t 2313 2314 913
  t 913 906 2315
  t 906 913 914
  t 914 907 906
  t 907 914 915
  t 915 908 907
  t 908 915 916
  t 916 909 908
  t 909 916 917
  t 917 910 909
  t 910 917 918
  t 918 911 910
  t 911 918 919
  t 919 912 911
  t 912 919 2316
  t 2317 2318 912
  t 2319 2320 920
  t 920 2321 2322
  t 2323 920 921
  t 921 2324 2325
  t 2326 921 922
  t 922 2327 2328
  t 2329 922 923
  t 923 2330 2331
  t 2332 923 924
  t 924 2333 2334
  t 2335 924 925
  t 925 2336 2337
  t 2338 925 926
  t 926 2339 2340
  t 2341 926 807
  t 807 2342 2343
  t 2344 2345 927
  t 927 920 2346
  t 920 927 928
  t 928 921 920
  t 921 928 929
  t 929 922 921
  t 922 929 930
  t 930 923 922
  t 923 930 931
  t 931 924 923
  t 924 931 932
  t 932 925 924
  t 925 932 933
  t 933 926 925
  t 926 933 2347
  t 2348 807 926
  t 2349 2350 934
  t 934 927 2351
  t 927 934 935
  t 935 928 927
  t 928 935 936
  t 936 929 928
  t 929 936 937
  t 937 930 929
  t 930 937 938
  t 938 931 930
  t 931 938 939
  t 939 932 931
  t 932 939 940
  t 940 933 932
  t 933 940 2352
  t 2353 2354 933
  t 2355 2356 941
  t 941 934 2357
  t 934 941 942
  t 942 935 934
  t 935 942 943
  t 943 936 935
  t 936 943 944
  t 944 937 936
  t 937 944 945
  t 945 938 937
  t 938 945 946
  t 946 939 938
  t 939 946 947
  t 947 940 939
  t 940 947 2358
  t 2359 2360 940
  t 2361 2362 948
  t 948 941 2363
  t 941 948 949
  t 949 942 941
  t 942 949 950
  t 950 943 942
  t 943 950 951
  t 951 944 943
  t 944 951 952
  t 952 945 944
  t 945 952 953
  t 953 946 945
  t 946 953 954
  t 954 947 946
  t 947 954 2364
  t 2365 2366 947
  t 2367 2368 955
  t 955 948 2369
  t 948 955 956
  t 956 949 948
  t 949 956 957
  t 957 950 949
  t 950 957 958
  t 958 951 950
  t 951 958 959
  t 959 952 951
  t 952 959 960
  t 960 953 952
  t 953 960 961
  t 961 954 953
  t 954 961 2370
  t 2371 2372 954
  t 2373 2374 962
  t 962 955 2375
  t 955 962 963
  t 963 956 955
  t 956 963 964
  t 964 957 956
  t 957 964 965
  t 965 958 957
  t 958 965 966
  t 966 959 958
  t 959 966 967
  t 967 960 959
  t 960 967 968
  t 968 961 960
  t 961 968 2376
  t 2377 2378 961
  t 2379 2380 969
  t 969 962 2381
  t 962 969 970
  t 970 963 962
  t 963 970 971
  t 971 964 963
  t 964 971 972
  t 972 965 964
  t 965 972 973
  t 973 966 965
  t 966 973 974
  t 974 967 966
  t 967 974 975
  t 975 968 967
  t 968 975 2382
  t 2383 2384 968
  t 2385 2386 976
  t 976 969 2387
  t 969 976 977
  t 977 970 969
  t 970 977 978
  t 978 971 970
  t 971 978 979
  t 979 972 971
  t 972 979 980
  t 980 973 972
  t 973 980 981
  t 981 974 973
  t 974 981 982
  t 982 975 974
  t 975 982 2388
  t 2389 2390 975
  t 2391 2392 983
  t 983 976 2393
  t 976 983 984
  t 984 977 976
  t 977 984 985
  t 985 978 977
  t 978 985 986
  t 986 979 978
  t 979 986 987
  t 987 980 979
  t 980 987 988
  t 988 981 980
  t 981 988 989
  t 989 982 981
  t 982 989 2394
  t 2395 2396 982
  t 2397 2398 990
  t 990 983 2399
  t 983 990 991
  t 991 984 983
  t 984 991 992
  t 992 985 984
  t 985 992 993
  t 993 986 985
  t 986 993 994
  t 994 987 986
  t 987 994 995
  t 995 988 987
  t 988 995 996
  t 996 989 988
  t 989 996 2400
  t 2401 2402 989
  t 2403 2404 997
  t 997 990 2405
  t 990 997 998
  t 998 991 990
  t 991 998 999
  t 999 992 991
  t 992 999 1000
  t 1000 993 992
  t 993 1000 1001
  t 1001 994 993
  t 994 1001 1002
  t 1002 995 994
  t 995 1002 1003
  t 1003 996 995
  t 996 1003 2406
  t 2407 2408 996
  t 2409 2410 1004
  t 1004 997 2411
  t 997 1004 1005
  t 1005 998 997
  t 998 1005 1006
  t 1006 999 998
  t 999 1006 1007
  t 1007 1000 999
  t 1000 1007 1008
  t 1008 1001 1000
  t 1001 1008 1009
  t 1009 1002 1001
  t 1002 1009 1010
  t 1010 1003 1002
  t 1003 1010 2412
  t 2413 2414 1003
  t 2415 2416 1011
  t 1011 1004 2417
  t 1004 1011 1012
  t 1012 1005 1004
  t 1005 1012 1013
  t 1013 1006 1005
  t 1006 1013 1014
  t 1014 1007 1006
  t 1007 1014 1015
  t 1015 1008 1007
  t 1008 1015 1016
  t 1016 1009 1008
  t 1009 1016 1017
  t 1017 1010 1009
  t 1010 1017 2418
  t 2419 2420 1010
  t 2421 2422 1018
  t 1018 1011 2423
  t 1011 1018 1019
  t 1019 1012 1011
  t 1012 1019 1020
  t 1020 1013 1012
  t 1013 1020 1021
  t 1021 1014 1013
  t 1014 1021 1022
  t 1022 1015 1014
  t 1015 1022 1023
  t 1023 1016 1015
  t 1016 1023 1024
  t 1024 1017 1016
  t 1017 1024 2424
  t 2425 2426 1017
  t 2427 2428 2429
  t 2430 1018 2431
  t 1018 2432 2433
  t 2434 1019 1018
  t 1019 2435 2436
  t 2437 1020 1019
  t 1020 2438 2439
  t 2440 1021 1020
  t 1021 2441 2442
  t 2443 1022 1021
  t 1022 2444 2445
  t 2446 1023 1022
  t 1023 2447 2448
  t 2449 1024 1023
  t 1024 2450 2451
  t 2452 2453 1024
  t 1025 1034 1035
  t 1035 1026 1025
  t 1026 1035 1036
  t 1036 1027 1026
  t 1027 1036 1037
  t 1037 1028 1027
  t 1028 1037 1038
  t 1038 1029 1028
  t 1029 1038 1039
  t 1039 1030 1029
  t 1030 1039 1040
  t 1040 1031 1030
  t 1031 1040 1041
  t 1041 1032 1031
  t 1032 1041 1042
  t 1042 1033 1032
  t 1034 1043 1044
  t 1044 1035 1034
  t 1035 1044 1045
  t 1045 1036 1035
  t 1036 1045 1046
  t 1046 1037 1036
  t 1037 1046 1047
  t 1047 1038 1037
  t 1038 1047 1048
  t 1048 1039 1038
  t 1039 1048 1049
  t 1049 1040 1039
  t 1040 1049 1050
  t 1050 1041 1040
  t 1041 1050 1051
  t 1051 1042 1041
  t 1043 1052 1053
  t 1053 1044 1043
  t 1044 1053 1054
  t 1054 1045 1044
  t 1045 1054 1055
  t 1055 1046 1045
  t 1046 1055 1056
  t 1056 1047 1046
  t 1047 1056 1057
  t 1057 1048 1047
  t 1048 1057 1058
  t 1058 1049 1048
  t 1049 1058 1059
  t 1059 1050 1049
  t 1050 1059 1060
  t 1060 1051 1050
  t 1052 1061 1062
  t 1062 1053 1052
  t 1053 1062 1063
  t 1063 1054 1053
  t 1054 1063 1064
  t 1064 1055 1054
  t 1055 1064 1065
  t 1065 1056 1055
  t 1056 1065 1066
  t 1066 1057 1056
  t 1057 1066 1067
  t 1067 1058 1057
  t 1058 1067 1068
  t 1068 1059 1058
  t 1059 1068 1069
  t 1069 1060 1059
  t 1061 1070 1071
  t 1071 1062 1061
  t 1062 1071 1072
  t 1072 1063 1062
  t 1063 1072 1073
  t 1073 1064 1063
  t 1064 1073 1074
  t 1074 1065 1064
  t 1065 1074 1075
  t 1075 1066 1065
  t 1066 1075 1076
  t 1076 1067 1066
  t 1067 1076 1077
  t 1077 1068 1067
  t 1068 1077 1078
  t 1078 1069 1068
  t 1070 1079 1080
  t 1080 1071 1070
  t 1071 1080 1081
  t 1081 1072 1071
  t 1072 1081 1082
  t 1082 1073 1072
  t 1073 1082 1083
  t 1083 1074 1073
  t 1074 1083 1084
  t 1084 1075 1074
  t 1075 1084 1085
  t 1085 1076 1075
  t 1076 1085 1086
  t 1086 1077 1076
  t 1077 1086 1087
  t 1087 1078 1077
  t 1079 1088 1089
  t 1089 1080 1079
  t 1080 1089 1090
  t 1090 1081 1080
  t 1081 1090 1091
  t 1091 1082 1081
  t 1082 1091 1092
  t 1092 1083 1082
  t 1083 1092 1093
  t 1093 1084 1083
  t 1084 1093 1094
  t 1094 1085 1084
  t 1085 1094 1095
  t 1095 1086 1085
  t 1086 1095 1096
  t 1096 1087 1086
  t 1088 1097 1098
  t 1098 1089 1088
  t 1089 1098 1099
  t 1099 1090 1089
  t 1090 1099 1100
  t 1100 1091 1090
  t 1091 1100 1101
  t 1101 1092 1091
  t 1092 1101 1102
  t 1102 1093 1092
  t 1093 1102 1103
  t 1103 1094 1093
  t 1094 1103 1104
  t 1104 1095 1094
  t 1095 1104 1105
  t 1105 1096 1095
  t 1097 1106 1107
  t 1107 1098 1097
  t 1098 1107 1108
  t 1108 1099 1098
  t 1099 1108 1109
  t 1109 1100 1099
  t 1100 1109 1110
  t 1110 1101 1100
  t 1101 1110 1111
  t 1111 1102 1101
  t 1102 1111 1112
  t 1112 1103 1102
  t 1103 1112 1113
  t 1113 1104 1103
  t 1104 1113 1114
  t 1114 1105 1104
  t 1106 1115 1116
  t 1116 1107 1106
  t 1107 1116 1117
  t 1117 1108 1107
  t 1108 1117 1118
  t 1118 1109 1108
  t 1109 1118 1119
  t 1119 1110 1109
  t 1110 1119 1120
  t 1120 1111 1110
  t 1111 1120 1121
  t 1121 1112 1111
  t 1112 1121 1122
  t 1122 1113 1112
  t 1113 1122 1123
  t 1123 1114 1113
  t 1115 1124 1125
  t 1125 1116 1115
  t 1116 1125 1126
  t 1126 1117 1116
  t 1117 1126 1127
  t 1127 1118 1117
  t 1118 1127 1128
  t 1128 1119 1118
  t 1119 1128 1129
  t 1129 1120 1119
  t 1120 1129 1130
  t 1130 1121 1120
  t 1121 1130 1131
  t 1131 1122 1121
  t 1122 1131 1132
  t 1132 1123 1122
  t 1124 1133 1134
  t 1134 1125 1124
  t 1125 1134 1135
  t 1135 1126 1125
  t 1126 1135 1136
  t 1136 1127 1126
  t 1127 1136 1137
  t 1137 1128 1127
  t 1128 1137 1138
  t 1138 1129 1128
  t 1129 1138 1139
  t 1139 1130 1129
  t 1130 1139 1140
  t 1140 1131 1130
  t 1131 1140 1141
  t 1141 1132 1131
  t 1133 1142 1143
  t 1143 1134 1133
  t 1134 1143 1144
  t 1144 1135 1134
  t 1135 1144 1145
  t 1145 1136 1135
  t 1136 1145 1146
  t 1146 1137 1136
  t 1137 1146 1147
  t 1147 1138 1137
  t 1138 1147 1148
  t 1148 1139 1138
  t 1139 1148 1149
  t 1149 1140 1139
  t 1140 1149 1150
  t 1150 1141 1140
  t 1142 1151 1152
  t 1152 1143 1142
  t 1143 1152 1153
  t 1153 1144 1143
  t 1144 1153 1154
  t 1154 1145 1144
  t 1145 1154 1155
  t 1155 1146 1145
  t 1146 1155 1156
  t 1156 1147 1146
  t 1147 1156 1157
  t 1157 1148 1147
  t 1148 1157 1158
  t 1158 1149 1148
  t 1149 1158 1159
  t 1159 1150 1149
  t 1151 1160 1161
  t 1161 1152 1151
  t 1152 1161 1162
  t 1162 1153 1152
  t 1153 1162 1163
  t 1163 1154 1153
  t 1154 1163 1164
  t 1164 1155 1154
  t 1155 1164 1165
  t 1165 1156 1155
  t 1156 1165 1166
  t 1166 1157 1156
  t 1157 1166 1167
  t 1167 1158 1157
  t 1158 1167 1168
  t 1168 1159 1158
  t 1160 2454 2455
  t 2456 1161 1160
  t 1161 2457 2458
  t 2459 1162 1161
  t 1162 2460 2461
  t 2462 1163 1162
  t 1163 2463 2464
  t 2465 1164 1163
  t 1164 2466 2467
  t 2468 1165 1164
  t 1165 2469 2470
  t 2471 1166 1165
  t 1166 2472 2473
  t 2474 1167 1166
  t 1167 2475 2476
  t 2477 1168 1167
  t 1033 1042 1177
  t 1177 1169 1033
  t 1169 1177 1178
  t 1178 1170 1169
  t 1170 1178 1179
  t 1179 1171 1170
  t 1171 1179 1180
  t 1180 1172 1171
  t 1172 1180 1181
  t 1181 1173 1172
  t 1173 1181 1182
  t 1182 1174 1173
  t 1174 1182 1183
  t 1183 1175 1174
  t 1175 1183 1184
  t 1184 1176 1175
  t 1042 1051 1185
  t 1185 1177 1042
  t 1177 1185 1186
  t 1186 1178 1177
  t 1178 1186 1187
  t 1187 1179 1178
  t 1179 1187 1188
  t 1188 1180 1179
  t 1180 1188 1189
  t 1189 1181 1180
  t 1181 1189 1190
  t 1190 1182 1181
  t 1182 1190 1191
  t 1191 1183 1182
  t 1183 1191 1192
  t 1192 1184 1183
  t 1051 1060 1193
  t 1193 1185 1051
  t 1185 1193 1194
  t 1194 1186 1185
  t 1186 1194 1195
  t 1195 1187 1186
  t 1187 1195 1196
  t 1196 1188 1187
  t 1188 1196 1197
  t 1197 1189 1188
  t 1189 1197 1198
  t 1198 1190 1189
  t 1190 1198 1199
  t 1199 1191 1190
  t 1191 1199 1200
  t 1200 1192 1191
  t 1060 1069 1201
  t 1201 1193 1060
  t 1193 1201 1202
  t 1202 1194 1193
  t 1194 1202 1203
  t 1203 1195 1194
  t 1195 1203 1204
  t 1204 1196 1195
  t 1196 1204 1205
  t 1205 1197 1196
  t 1197 1205 1206
  t 1206 1198 1197
  t 1198 1206 1207
  t 1207 1199 1198
  t 1199 1207 1208
  t 1208 1200 1199
  t 1069 1078 1209
  t 1209 1201 1069
  t 1201 1209 1210
  t 1210 1202 1201
  t 1202 1210 1211
  t 1211 1203 1202
  t 1203 1211 1212
  t 1212 1204 1203
  t 1204 1212 1213
  t 1213 1205 1204
  t 1205 1213 1214
  t 1214 1206 1205
  t 1206 1214 1215
  t 1215 1207 1206
  t 1207 1215 1216
  t 1216 1208 1207
  t 1078 1087 1217
  t 1217 1209 1078
  t 1209 1217 1218
  t 1218 1210 1209
  t 1210 1218 1219
  t 1219 1211 1210
  t 1211 1219 1220
  t 1220 1212 1211
  t 1212 1220 1221
  t 1221 1213 1212
  t 1213 1221 1222
  t 1222 1214 1213
  t 1214 1222 1223
  t 1223 1215 1214
  t 1215 1223 1224
  t 1224 1216 1215
  t 1087 1096 1225
  t 1225 1217 1087
  t 1217 1225 1226
  t 1226 1218 1217
  t 1218 1226 1227
  t 1227 1219 1218
  t 1219 1227 1228
  t 1228 1220 1219
  t 1220 1228 1229
  t 1229 1221 1220
  t 1221 1229 1230
  t 1230 1222 1221
  t 1222 1230 1231
  t 1231 1223 1222
  t 1223 1231 1232
  t 1232 1224 1223
  t 1096 1105 1233
  t 1233 1225 1096
  t 1225 1233 1234
  t 1234 1226 1225
  t 1226 1234 1235
  t 1235 1227 1226
  t 1227 1235 1236
  t 1236 1228 1227
  t 1228 1236 1237
  t 1237 1229 1228
  t 1229 1237 1238
  t 1238 1230 1229
  t 1230 1238 1239
  t 1239 1231 1230
  t 1231 1239 1240
  t 1240 1232 1231
  t 1105 1114 1241
  t 1241 1233 1105
  t 1233 1241 1242
  t 1242 1234 1233
  t 1234 1242 1243
  t 1243 1235 1234
  t 1235 1243 1244
  t 1244 1236 1235
  t 1236 1244 1245
  t 1245 1237 1236
  t 1237 1245 1246
  t 1246 1238 1237
  t 1238 1246 1247
  t 1247 1239 1238
  t 1239 1247 1248
  t 1248 1240 1239
  t 1114 1123 1249
  t 1249 1241 1114
  t 1241 1249 1250
  t 1250 1242 1241
  t 1242 1250 1251
  t 1251 1243 1242
  t 1243 1251 1252
  t 1252 1244 1243
  t 1244 1252 1253
  t 1253 1245 1244
  t 1245 1253 1254
  t 1254 1246 1245
  t 1246 1254 1255
  t 1255 1247 1246
  t 1247 1255 1256
  t 1256 1248 1247
  t 1123 1132 1257
  t 1257 1249 1123
  t 1249 1257 1258
  t 1258 1250 1249
  t 1250 1258 1259
  t 1259 1251 1250
  t 1251 1259 1260
  t 1260 1252 1251
  t 1252 1260 1261
  t 1261 1253 1252
  t 1253 1261 1262
  t 1262 1254 1253
  t 1254 1262 1263
  t 1263 1255 1254
  t 1255 1263 1264
  t 1264 1256 1255
  t 1132 1141 1265
  t 1265 1257 1132
  t 1257 1265 1266
  t 1266 1258 1257
  t 1258 1266 1267
  t 1267 1259 1258
  t 1259 1267 1268
  t 1268 1260 1259
  t 1260 1268 1269
  t 1269 1261 1260
  t 1261 1269 1270
  t 1270 1262 1261
  t 1262 1270 1271
  t 1271 1263 1262
  t 1263 1271 1272
  t 1272 1264 1263
  t 1141 1150 1273
  t 1273 1265 1141
  t 1265 1273 1274
  t 1274 1266 1265
  t 1266 1274 1275
  t 1275 1267 1266
  t 1267 1275 1276
  t 1276 1268 1267
  t 1268 1276 1277
  t 1277 1269 1268
  t 1269 1277 1278
  t 1278 1270 1269
  t 1270 1278 1279
  t 1279 1271 1270
  t 1271 1279 1280
  t 1280 1272 1271
  t 1150 1159 1281
  t 1281 1273 1150
  t 1273 1281 1282
  t 1282 1274 1273
  t 1274 1282 1283
  t 1283 1275 1274
  t 1275 1283 1284
  t 1284 1276 1275
  t 1276 1284 1285
  t 1285 1277 1276
  t 1277 1285 1286
  t 1286 1278 1277
  t 1278 1286 1287
  t 1287 1279 1278
  t 1279 1287 1288
  t 1288 1280 1279
  t 1159 1168 1289
  t 1289 1281 1159
  t 1281 1289 1290
  t 1290 1282 1281
  t 1282 1290 1291
  t 1291 1283 1282
  t 1283 1291 1292
  t 1292 1284 1283
  t 1284 1292 1293
  t 1293 1285 1284
  t 1285 1293 1294
  t 1294 1286 1285
  t 1286 1294 1295
  t 1295 1287 1286
  t 1287 1295 1296
  t 1296 1288 1287
  t 1168 2478 2479
  t 2480 1289 1168
  t 1289 2481 2482
  t 2483 1290 1289
  t 1290 2484 2485
  t 2486 1291 1290
  t 1291 2487 2488
  t 2489 1292 1291
  t 1292 2490 2491
  t 2492 1293 1292
  t 1293 2493 2494
  t 2495 1294 1293
  t 1294 2496 2497
  t 2498 1295 1294
  t 1295 2499 2500
  t 2501 1296 1295
  t 1297 1306 1307
  t 1307 1298 1297
  t 1298 1307 1308
  t 1308 1299 1298
  t 1299 1308 1309
  t 1309 1300 1299
  t 1300 1309 1310
  t 1310 1301 1300
  t 1301 1310 1311
  t 1311 1302 1301
  t 1302 1311 1312
  t 1312 1303 1302
  t 1303 1312 1313
  t 1313 1304 1303
  t 1304 1313 1314
  t 1314 1305 1304
  t 1306 1315 1316
  t 1316 1307 1306
  t 1307 1316 1317
  t 1317 1308 1307
  t 1308 1317 1318
  t 1318 1309 1308
  t 1309 1318 1319
  t 1319 1310 1309
  t 1310 1319 1320
  t 1320 1311 1310
  t 1311 1320 1321
  t 1321 1312 1311
  t 1312 1321 1322
  t 1322 1313 1312
  t 1313 1322 1323
  t 1323 1314 1313
  t 1315 1324 1325
  t 1325 1316 1315
  t 1316 1325 1326
  t 1326 1317 1316
  t 1317 1326 1327
  t 1327 1318 1317
  t 1318 1327 1328
  t 1328 1319 1318
  t 1319 1328 1329
  t 1329 1320 1319
  t 1320 1329 1330
  t 1330 1321 1320
  t 1321 1330 1331
  t 1331 1322 1321
  t 1322 1331 1332
  t 1332 1323 1322
  t 1324 1333 1334
  t 1334 1325 1324
  t 1325 1334 1335
  t 1335 1326 1325
  t 1326 1335 1336
  t 1336 1327 1326
  t 1327 1336 1337
  t 1337 1328 1327
  t 1328 1337 1338
  t 1338 1329 1328
  t 1329 1338 1339
  t 1339 1330 1329
  t 1330 1339 1340
  t 1340 1331 1330
  t 1331 1340 1341
  t 1341 1332 1331
  t 1333 1342 1343
  t 1343 1334 1333
  t 1334 1343 1344
  t 1344 1335 1334
  t 1335 1344 1345
  t 1345 1336 1335
  t 1336 1345 1346
  t 1346 1337 1336
  t 1337 1346 1347
  t 1347 1338 1337
  t 1338 1347 1348
  t 1348 1339 1338
  t 1339 1348 1349
  t 1349 1340 1339
  t 1340 1349 1350
  t 1350 1341 1340
  t 1342 1351 1352
  t 1352 1343 1342
  t 1343 1352 1353
  t 1353 1344 1343
  t 1344 1353 1354
  t 1354 1345 1344
  t 1345 1354 1355
  t 1355 1346 1345
  t 1346 1355 1356
  t 1356 1347 1346
  t 1347 1356 1357
  t 1357 1348 1347
  t 1348 1357 1358
  t 1358 1349 1348
  t 1349 1358 1359
  t 1359 1350 1349
  t 1351 1360 1361
  t 1361 1352 1351
  t 1352 1361 1362
  t 1362 1353 1352
  t 1353 1362 1363
  t 1363 1354 1353
  t 1354 1363 1364
  t 1364 1355 1354
  t 1355 1364 1365
  t 1365 1356 1355
  t 1356 1365 1366
  t 1366 1357 1356
  t 1357 1366 1367
  t 1367 1358 1357
  t 1358 1367 1368
  t 1368 1359 1358
  t 1360 1369 1370
  t 1370 1361 1360
  t 1361 1370 1371
  t 1371 1362 1361
  t 1362 1371 1372
  t 1372 1363 1362
  t 1363 1372 1373
  t 1373 1364 1363
  t 1364 1373 1374
  t 1374 1365 1364
  t 1365 1374 1375
  t 1375 1366 1365
  t 1366 1375 1376
  t 1376 1367 1366
  t 1367 1376 1377
  t 1377 1368 1367
  t 2502 1378 1379
  t 1379 2503 2504
  t 2505 1379 1380
  t 1380 2506 2507
  t 2508 1380 1381
  t 1381 2509 2510
  t 2511 1381 1382
  t 1382 2512 2513
  t 2514 1382 1383
  t 1383 2515 2516
  t 2517 1383 1384
  t 1384 2518 2519
  t 2520 1384 1385
  t 1385 2521 2522
  t 2523 1385 1386
  t 1386 2524 2525
  t 1378 1387 1388
  t 1388 1379 1378
  t 1379 1388 1389
  t 1389 1380 1379
  t 1380 1389 1390
  t 1390 1381 1380
  t 1381 1390 1391
  t 1391 1382 1381
  t 1382 1391 1392
  t 1392 1383 1382
  t 1383 1392 1393
  t 1393 1384 1383
  t 1384 1393 1394
  t 1394 1385 1384
  t 1385 1394 1395
  t 1395 1386 1385
  t 1387 1396 1397
  t 1397 1388 1387
  t 1388 1397 1398
  t 1398 1389 1388
  t 1389 1398 1399
  t 1399 1390 1389
  t 1390 1399 1400
  t 1400 1391 1390
  t 1391 1400 1401
  t 1401 1392 1391
  t 1392 1401 1402
  t 1402 1393 1392
  t 1393 1402 1403
  t 1403 1394 1393
  t 1394 1403 1404
  t 1404 1395 1394
  t 1396 1405 1406
  t 1406 1397 1396
  t 1397 1406 1407
  t 1407 1398 1397
  t 1398 1407 1408
  t 1408 1399 1398
  t 1399 1408 1409
  t 1409 1400 1399
  t 1400 1409 1410
  t 1410 1401 1400
  t 1401 1410 1411
  t 1411 1402 1401
  t 1402 1411 1412
  t 1412 1403 1402
  t 1403 1412 1413
  t 1413 1404 1403
  t 1405 1414 1415
  t 1415 1406 1405
  t 1406 1415 1416
  t 1416 1407 1406
  t 1407 1416 1417
  t 1417 1408 1407
  t 1408 1417 1418
  t 1418 1409 1408
  t 1409 1418 1419
  t 1419 1410 1409
  t 1410 1419 1420
  t 1420 1411 1410
  t 1411 1420 1421
  t 1421 1412 1411
  t 1412 1421 1422
  t 1422 1413 1412
  t 1414 1423 1424
  t 1424 1415 1414
  t 1415 1424 1425
  t 1425 1416 1415
  t 1416 1425 1426
  t 1426 1417 1416
  t 1417 1426 1427
  t 1427 1418 1417
  t 1418 1427 1428
  t 1428 1419 1418
  t 1419 1428 1429
  t 1429 1420 1419
  t 1420 1429 1430
  t 1430 1421 1420
  t 1421 1430 1431
  t 1431 1422 1421
  t 1423 1432 1433
  t 1433 1424 1423
  t 1424 1433 1434
  t 1434 1425 1424
  t 1425 1434 1435
  t 1435 1426 1425
  t 1426 1435 1436
  t 1436 1427 1426
  t 1427 1436 1437
  t 1437 1428 1427
  t 1428 1437 1438
  t 1438 1429 1428
  t 1429 1438 1439
  t 1439 1430 1429
  t 1430 1439 1440
  t 1440 1431 1430
  t 1432 1297 1298
  t 1298 1433 1432
  t 1433 1298 1299
  t 1299 1434 1433
  t 1434 1299 1300
  t 1300 1435 1434
  t 1435 1300 1301
  t 1301 1436 1435
  t 1436 1301 1302
  t 1302 1437 1436
  t 1437 1302 1303
  t 1303 1438 1437
  t 1438 1303 1304
  t 1304 1439 1438
  t 1439 1304 1305
  t 1305 1440 1439
  t 1305 1314 1449
  t 1449 1441 1305
  t 1441 1449 1450
  t 1450 1442 1441
  t 1442 1450 1451
  t 1451 1443 1442
  t 1443 1451 1452
  t 1452 1444 1443
  t 1444 1452 1453
  t 1453 1445 1444
  t 1445 1453 1454
  t 1454 1446 1445
  t 1446 1454 1455
  t 1455 1447 1446
  t 1447 1455 1456
  t 1456 1448 1447
  t 1314 1323 1457
  t 1457 1449 1314
  t 1449 1457 1458
  t 1458 1450 1449
  t 1450 1458 1459
  t 1459 1451 1450
  t 1451 1459 1460
  t 1460 1452 1451
  t 1452 1460 1461
  t 1461 1453 1452
  t 1453 1461 1462
  t 1462 1454 1453
  t 1454 1462 1463
  t 1463 1455 1454
  t 1455 1463 1464
  t 1464 1456 1455
  t 1323 1332 1465
  t 1465 1457 1323
  t 1457 1465 1466
  t 1466 1458 1457
  t 1458 1466 1467
  t 1467 1459 1458
  t 1459 1467 1468
  t 1468 1460 1459
  t 1460 1468 1469
  t 1469 1461 1460
  t 1461 1469 1470
  t 1470 1462 1461
  t 1462 1470 1471
  t 1471 1463 1462
  t 1463 1471 1472
  t 1472 1464 1463
  t 1332 1341 1473
  t 1473 1465 1332
  t 1465 1473 1474
  t 1474 1466 1465
  t 1466 1474 1475
  t 1475 1467 1466
  t 1467 1475 1476
  t 1476 1468 1467
  t 1468 1476 1477
  t 1477 1469 1468
  t 1469 1477 1478
  t 1478 1470 1469
  t 1470 1478 1479
  t 1479 1471 1470
  t 1471 1479 1480
  t 1480 1472 1471
  t 1341 1350 1481
  t 1481 1473 1341
  t 1473 1481 1482
  t 1482 1474 1473
  t 1474 1482 1483
  t 1483 1475 1474
  t 1475 1483 1484
  t 1484 1476 1475
  t 1476 1484 1485
  t 1485 1477 1476
  t 1477 1485 1486
  t 1486 1478 1477
  t 1478 1486 1487
  t 1487 1479 1478
  t 1479 1487 1488
  t 1488 1480 1479
  t 1350 1359 1489
  t 1489 1481 1350
  t 1481 1489 1490
  t 1490 1482 1481
  t 1482 1490 1491
  t 1491 1483 1482
  t 1483 1491 1492
  t 1492 1484 1483
  t 1484 1492 1493
  t 1493 1485 1484
  t 1485 1493 1494
  t 1494 1486 1485
  t 1486 1494 1495
  t 1495 1487 1486
  t 1487 1495 1496
  t 1496 1488 1487
  t 1359 1368 1497
  t 1497 1489 1359
  t 1489 1497 1498
  t 1498 1490 1489
  t 1490 1498 1499
  t 1499 1491 1490
  t 1491 1499 1500
  t 1500 1492 1491
  t 1492 1500 1501
  t 1501 1493 1492
  t 1493 1501 1502
  t 1502 1494 1493
  t 1494 1502 1503
  t 1503 1495 1494
  t 1495 1503 1504
  t 1504 1496 1495
  t 1368 1377 1505
  t 1505 1497 1368
  t 1497 1505 1506
  t 1506 1498 1497
  t 1498 1506 1507
  t 1507 1499 1498
  t 1499 1507 1508
  t 1508 1500 1499
  t 1500 1508 1509
  t 1509 1501 1500
  t 1501 1509 1510
  t 1510 1502 1501
  t 1502 1510 1511
  t 1511 1503 1502
  t 1503 1511 1512
  t 1512 1504 1503
  t 2526 1386 1513
  t 1513 2527 2528
  t 2529 1513 1514
  t 1514 2530 2531
  t 2532 1514 1515
  t 1515 2533 2534
  t 2535 1515 1516
  t 1516 2536 2537
  t 2538 1516 1517
  t 1517 2539 2540
  t 2541 1517 1518
  t 1518 2542 2543
  t 2544 1518 1519
  t 1519 2545 2546
  t 2547 1519 1520
  t 1520 2548 2549
  t 1386 1395 1521
  t 1521 1513 1386
  t 1513 1521 1522
  t 1522 1514 1513
  t 1514 1522 1523
  t 1523 1515 1514
  t 1515 1523 1524
  t 1524 1516 1515
  t 1516 1524 1525
  t 1525 1517 1516
  t 1517 1525 1526
  t 1526 1518 1517
  t 1518 1526 1527
  t 1527 1519 1518
  t 1519 1527 1528
  t 1528 1520 1519
  t 1395 1404 1529
  t 1529 1521 1395
  t 1521 1529 1530
  t 1530 1522 1521
  t 1522 1530 1531
  t 1531 1523 1522
  t 1523 1531 1532
  t 1532 1524 1523
  t 1524 1532 1533
  t 1533 1525 1524
  t 1525 1533 1534
  t 1534 1526 1525
  t 1526 1534 1535
  t 1535 1527 1526
  t 1527 1535 1536
  t 1536 1528 1527
  t 1404 1413 1537
  t 1537 1529 1404
  t 1529 1537 1538
  t 1538 1530 1529
  t 1530 1538 1539
  t 1539 1531 1530
  t 1531 1539 1540
  t 1540 1532 1531
  t 1532 1540 1541
  t 1541 1533 1532
  t 1533 1541 1542
  t 1542 1534 1533
  t 1534 1542 1543
  t 1543 1535 1534
  t 1535 1543 1544
  t 1544 1536 1535
  t 1413 1422 1545
  t 1545 1537 1413
  t 1537 1545 1546
  t 1546 1538 1537
  t 1538 1546 1547
  t 1547 1539 1538
  t 1539 1547 1548
  t 1548 1540 1539
  t 1540 1548 1549
  t 1549 1541 1540
  t 1541 1549 1550
  t 1550 1542 1541
  t 1542 1550 1551
  t 1551 1543 1542
  t 1543 1551 1552
  t 1552 1544 1543
  t 1422 1431 1553
  t 1553 1545 1422
  t 1545 1553 1554
  t 1554 1546 1545
  t 1546 1554 1555
  t 1555 1547 1546
  t 1547 1555 1556
  t 1556 1548 1547
  t 1548 1556 1557
  t 1557 1549 1548
  t 1549 1557 1558
  t 1558 1550 1549
  t 1550 1558 1559
  t 1559 1551 1550
  t 1551 1559 1560
  t 1560 1552 1551
  t 1431 1440 1561
  t 1561 1553 1431
  t 1553 1561 1562
  t 1562 1554 1553
  t 1554 1562 1563
  t 1563 1555 1554
  t 1555 1563 1564
  t 1564 1556 1555
  t 1556 1564 1565
  t 1565 1557 1556
  t 1557 1565 1566
  t 1566 1558 1557
  t 1558 1566 1567
  t 1567 1559 1558
  t 1559 1567 1568
  t 1568 1560 1559
  t 1440 1305 1441
  t 1441 1561 1440
  t 1561 1441 1442
  t 1442 1562 1561
  t 1562 1442 1443
  t 1443 1563 1562
  t 1563 1443 1444
  t 1444 1564 1563
  t 1564 1444 1445
  t 1445 1565 1564
  t 1565 1445 1446
  t 1446 1566 1565
  t 1566 1446 1447
  t 1447 1567 1566
  t 1567 1447 1448
  t 1448 1568 1567
  t 1569 2550 1578
  t 1578 1570 1569
  t 1570 1578 1579
  t 1579 1571 1570
  t 1571 1579 1580
  t 1580 1572 1571
  t 1572 1580 1581
  t 1581 1573 1572
  t 1573 1581 1582
  t 1582 1574 1573
  t 1574 1582 1583
  t 1583 1575 1574
  t 1575 1583 1584
  t 1584 1576 1575
  t 1576 1584 1585
  t 1585 1577 1576
  t 2551 2552 1586
  t 1586 1578 2553
  t 1578 1586 1587
  t 1587 1579 1578
  t 1579 1587 1588
  t 1588 1580 1579
  t 1580 1588 1589
  t 1589 1581 1580
  t 1581 1589 1590
  t 1590 1582 1581
  t 1582 1590 1591
  t 1591 1583 1582
  t 1583 1591 1592
  t 1592 1584 1583
  t 1584 1592 1593
  t 1593 1585 1584
  t 2554 2555 1594
  t 1594 1586 2556
  t 1586 1594 1595
  t 1595 1587 1586
  t 1587 1595 1596
  t 1596 1588 1587
  t 1588 1596 1597
  t 1597 1589 1588
  t 1589 1597 1598
  t 1598 1590 1589
  t 1590 1598 1599
  t 1599 1591 1590
  t 1591 1599 1600
  t 1600 1592 1591
  t 1592 1600 1601
  t 1601 1593 1592
  t 2557 2558 1602
  t 1602 1594 2559
  t 1594 1602 1603
  t 1603 1595 1594
  t 1595 1603 1604
  t 1604 1596 1595
  t 1596 1604 1605
  t 1605 1597 1596
  t 1597 1605 1606
  t 1606 1598 1597
  t 1598 1606 1607
  t 1607 1599 1598
  t 1599 1607 1608
  t 1608 1600 1599
  t 1600 1608 1609
  t 1609 1601 1600
  t 2560 2561 1610
  t 1610 1602 2562
  t 1602 1610 1611
  t 1611 1603 1602
  t 1603 1611 1612
  t 1612 1604 1603
  t 1604 1612 1613
  t 1613 1605 1604
  t 1605 1613 1614
  t 1614 1606 1605
  t 1606 1614 1615
  t 1615 1607 1606
  t 1607 1615 1616
  t 1616 1608 1607
  t 1608 1616 1617
  t 1617 1609 1608
  t 2563 2564 1618
  t 1618 1610 2565
  t 1610 1618 1619
  t 1619 1611 1610
  t 1611 1619 1620
  t 1620 1612 1611
  t 1612 1620 1621
  t 1621 1613 1612
  t 1613 1621 1622
  t 1622 1614 1613
  t 1614 1622 1623
  t 1623 1615 1614
  t 1615 1623 1624
  t 1624 1616 1615
  t 1616 1624 1625
  t 1625 1617 1616
  t 2566 2567 1626
  t 1626 1618 2568
  t 1618 1626 1627
  t 1627 1619 1618
  t 1619 1627 1628
  t 1628 1620 1619
  t 1620 1628 1629
  t 1629 1621 1620
  t 1621 1629 1630
  t 1630 1622 1621
  t 1622 1630 1631
  t 1631 1623 1622
  t 1623 1631 1632
  t 1632 1624 1623
  t 1624 1632 1633
  t 1633 1625 1624
  t 2569 2570 1634
  t 1634 1626 2571
  t 1626 1634 1635
  t 1635 1627 1626
  t 1627 1635 1636
  t 1636 1628 1627
  t 1628 1636 1637
  t 1637 1629 1628
  t 1629 1637 1638
  t 1638 1630 1629
  t 1630 1638 1639
  t 1639 1631 1630
  t 1631 1639 1640
  t 1640 1632 1631
  t 1632 1640 1641
  t 1641 1633 1632
  t 2572 2573 1642
  t 1642 1634 2574
  t 1634 1642 1643
  t 1643 1635 1634
  t 1635 1643 1644
  t 1644 1636 1635
  t 1636 1644 1645
  t 1645 1637 1636
  t 1637 1645 1646
  t 1646 1638 1637
  t 1638 1646 1647
  t 1647 1639 1638
  t 1639 1647 1648
  t 1648 1640 1639
  t 1640 1648 1649
  t 1649 1641 1640
  t 2575 2576 1650
  t 1650 1642 2577
  t 1642 1650 1651
  t 1651 1643 1642
  t 1643 1651 1652
  t 1652 1644 1643
  t 1644 1652 1653
  t 1653 1645 1644
  t 1645 1653 1654
  t 1654 1646 1645
  t 1646 1654 1655
  t 1655 1647 1646
  t 1647 1655 1656
  t 1656 1648 1647
  t 1648 1656 1657
  t 1657 1649 1648
  t 2578 2579 1658
  t 1658 1650 2580
  t 1650 1658 1659
  t 1659 1651 1650
  t 1651 1659 1660
  t 1660 1652 1651
  t 1652 1660 1661
  t 1661 1653 1652
  t 1653 1661 1662
  t 1662 1654 1653
  t 1654 1662 1663
  t 1663 1655 1654
  t 1655 1663 1664
  t 1664 1656 1655
  t 1656 1664 1665
  t 1665 1657 1656
  t 2581 2582 1666
  t 1666 1658 2583
  t 1658 1666 1667
  t 1667 1659 1658
  t 1659 1667 1668
  t 1668 1660 1659
  t 1660 1668 1669
  t 1669 1661 1660
  t 1661 1669 1670
  t 1670 1662 1661
  t 1662 1670 1671
  t 1671 1663 1662
  t 1663 1671 1672
  t 1672 1664 1663
  t 1664 1672 1673
  t 1673 1665 1664
  t 2584 2585 1674
  t 1674 1666 2586
  t 1666 1674 1675
  t 1675 1667 1666
  t 1667 1675 1676
  t 1676 1668 1667
  t 1668 1676 1677
  t 1677 1669 1668
  t 1669 1677 1678
  t 1678 1670 1669
  t 1670 1678 1679
  t 1679 1671 1670
  t 1671 1679 1680
  t 1680 1672 1671
  t 1672 1680 1681
  t 1681 1673 1672
  t 2587 2588 1682
  t 1682 1674 2589
  t 1674 1682 1683
  t 1683 1675 1674
  t 1675 1683 1684
  t 1684 1676 1675
  t 1676 1684 1685
  t 1685 1677 1676
  t 1677 1685 1686
  t 1686 1678 1677
  t 1678 1686 1687
  t 1687 1679 1678
  t 1679 1687 1688
  t 1688 1680 1679
  t 1680 1688 1689
  t 1689 1681 1680
  t 2590 2591 1690
  t 1690 1682 2592
  t 1682 1690 1691
  t 1691 1683 1682
  t 1683 1691 1692
  t 1692 1684 1683
  t 1684 1692 1693
  t 1693 1685 1684
  t 1685 1693 1694
  t 1694 1686 1685
  t 1686 1694 1695
  t 1695 1687 1686
  t 1687 1695 1696
  t 1696 1688 1687
  t 1688 1696 1697
  t 1697 1689 1688
  t 2593 2594 1698
  t 1698 1690 2595
  t 1690 1698 1699
  t 1699 1691 1690
  t 1691 1699 1700
  t 1700 1692 1691
  t 1692 1700 1701
  t 1701 1693 1692
  t 1693 1701 1702
  t 1702 1694 1693
  t 1694 1702 1703
  t 1703 1695 1694
  t 1695 1703 1704
  t 1704 1696 1695
  t 1696 1704 1705
  t 1705 1697 1696
  t 1569 2596 1706
  t 1706 2597 1569
  t 2598 1706 1707
  t 1707 2599 2600
  t 2601 1707 1708
  t 1708 2602 2603
  t 2604 1708 1709
  t 1709 2605 2606
  t 2607 1709 1710
  t 1710 2608 2609
  t 2610 1710 1711
  t 1711 2611 2612
  t 2613 1711 1712
  t 1712 2614 2615
  t 2616 1712 1713
  t 1713 2617 2618
  t 2619 2620 1714
  t 1714 1706 2621
  t 1706 1714 1715
  t 1715 1707 1706
  t 1707 1715 1716
  t 1716 1708 1707
  t 1708 1716 1717
  t 1717 1709 1708
  t 1709 1717 1718
  t 1718 1710 1709
  t 1710 1718 1719
  t 1719 1711 1710
  t 1711 1719 1720
  t 1720 1712 1711
  t 1712 1720 1721
  t 1721 1713 1712
  t 2622 2623 1722
  t 1722 1714 2624
  t 1714 1722 1723
  t 1723 1715 1714
  t 1715 1723 1724
  t 1724 1716 1715
  t 1716 1724 1725
  t 1725 1717 1716
  t 1717 1725 1726
  t 1726 1718 1717
  t 1718 1726 1727
  t 1727 1719 1718
  t 1719 1727 1728
  t 1728 1720 1719
  t 1720 1728 1729
  t 1729 1721 1720
  t 2625 2626 1730
  t 1730 1722 2627
  t 1722 1730 1731
  t 1731 1723 1722
  t 1723 1731 1732
  t 1732 1724 1723
  t 1724 1732 1733
  t 1733 1725 1724
  t 1725 1733 1734
  t 1734 1726 1725
  t 1726 1734 1735
  t 1735 1727 1726
  t 1727 1735 1736
  t 1736 1728 1727
  t 1728 1736 1737
  t 1737 1729 1728
  t 2628 2629 1738
  t 1738 1730 2630
  t 1730 1738 1739
  t 1739 1731 1730
  t 1731 1739 1740
  t 1740 1732 1731
  t 1732 1740 1741
  t 1741 1733 1732
  t 1733 1741 1742
  t 1742 1734 1733
  t 1734 1742 1743
  t 1743 1735 1734
  t 1735 1743 1744
  t 1744 1736 1735
  t 1736 1744 1745
  t 1745 1737 1736
  t 2631 2632 1746
  t 1746 1738 2633
  t 1738 1746 1747
  t 1747 1739 1738
  t 1739 1747 1748
  t 1748 1740 1739
  t 1740 1748 1749
  t 1749 1741 1740
  t 1741 1749 1750
  t 1750 1742 1741
  t 1742 1750 1751
  t 1751 1743 1742
  t 1743 1751 1752
  t 1752 1744 1743
  t 1744 1752 1753
  t 1753 1745 1744
  t 2634 2635 1754
  t 1754 1746 2636
  t 1746 1754 1755
  t 1755 1747 1746
  t 1747 1755 1756
  t 1756 1748 1747
  t 1748 1756 1757
  t 1757 1749 1748
  t 1749 1757 1758
  t 1758 1750 1749
  t 1750 1758 1759
  t 1759 1751 1750
  t 1751 1759 1760
  t 1760 1752 1751
  t 1752 1760 1761
  t 1761 1753 1752
  t 2637 2638 1762
  t 1762 1754 2639
  t 1754 1762 1763
  t 1763 1755 1754
  t 1755 1763 1764
  t 1764 1756 1755
  t 1756 1764 1765
  t 1765 1757 1756
  t 1757 1765 1766
  t 1766 1758 1757
  t 1758 1766 1767
  t 1767 1759 1758
  t 1759 1767 1768
  t 1768 1760 1759
  t 1760 1768 1769
  t 1769 1761 1760
  t 2640 2641 1770
  t 1770 1762 2642
  t 1762 1770 1771
  t 1771 1763 1762
  t 1763 1771 1772
  t 1772 1764 1763
  t 1764 1772 1773
  t 1773 1765 1764
  t 1765 1773 1774
  t 1774 1766 1765
  t 1766 1774 1775
  t 1775 1767 1766
  t 1767 1775 1776
  t 1776 1768 1767
  t 1768 1776 1777
  t 1777 1769 1768
  t 2643 2644 1778
  t 1778 1770 2645
  t 1770 1778 1779
  t 1779 1771 1770
  t 1771 1779 1780
  t 1780 1772 1771
  t 1772 1780 1781
  t 1781 1773 1772
  t 1773 1781 1782
  t 1782 1774 1773
  t 1774 1782 1783
  t 1783 1775 1774
  t 1775 1783 1784
  t 1784 1776 1775
  t 1776 1784 1785
  t 1785 1777 1776
  t 2646 2647 1786
  t 1786 1778 2648
  t 1778 1786 1787
  t 1787 1779 1778
  t 1779 1787 1788
  t 1788 1780 1779
  t 1780 1788 1789
  t 1789 1781 1780
  t 1781 1789 1790
  t 1790 1782 1781
  t 1782 1790 1791
  t 1791 1783 1782
  t 1783 1791 1792
  t 1792 1784 1783
  t 1784 1792 1793
  t 1793 1785 1784
  t 2649 2650 1794
  t 1794 1786 2651
  t 1786 1794 1795
  t 1795 1787 1786
  t 1787 1795 1796
  t 1796 1788 1787
  t 1788 1796 1797
  t 1797 1789 1788
  t 1789 1797 1798
  t 1798 1790 1789
  t 1790 1798 1799
  t 1799 1791 1790
  t 1791 1799 1800
  t 1800 1792 1791
  t 1792 1800 1801
  t 1801 1793 1792
  t 2652 2653 1802
  t 1802 1794 2654
  t 1794 1802 1803
  t 1803 1795 1794
  t 1795 1803 1804
  t 1804 1796 1795
  t 1796 1804 1805
  t 1805 1797 1796
  t 1797 1805 1806
  t 1806 1798 1797
  t 1798 1806 1807
  t 1807 1799 1798
  t 1799 1807 1808
  t 1808 1800 1799
  t 1800 1808 1809
  t 1809 1801 1800
  t 2655 2656 1810
  t 1810 1802 2657
  t 1802 1810 1811
  t 1811 1803 1802
  t 1803 1811 1812
  t 1812 1804 1803
  t 1804 1812 1813
  t 1813 1805 1804
  t 1805 1813 1814
  t 1814 1806 1805
  t 1806 1814 1815
  t 1815 1807 1806
  t 1807 1815 1816
  t 1816 1808 1807
  t 1808 1816 1817
  t 1817 1809 1808
  t 2658 2659 1818
  t 1818 1810 2660
  t 1810 1818 1819
  t 1819 1811 1810
  t 1811 1819 1820
  t 1820 1812 1811
  t 1812 1820 1821
  t 1821 1813 1812
  t 1813 1821 1822
  t 1822 1814 1813
  t 1814 1822 1823
  t 1823 1815 1814
  t 1815 1823 1824
  t 1824 1816 1815
  t 1816 1824 1825
  t 1825 1817 1816
  t 2661 2662 2663
  t 2664 1818 2665
  t 1818 2666 2667
  t 2668 1819 1818
  t 1819 2669 2670
  t 2671 1820 1819
  t 1820 2672 2673
  t 2674 1821 1820
  t 1821 2675 2676
  t 2677 1822 1821
  t 1822 2678 2679
  t 2680 1823 1822
  t 1823 2681 2682
  t 2683 1824 1823
  t 1824 2684 2685
  t 2686 1825 1824
  t 2687 2688 1834
  t 1834 1826 2689
  t 1826 1834 1835
  t 1835 1827 1826
  t 1827 1835 1836
  t 1836 1828 1827
  t 1828 1836 1837
  t 1837 1829 1828
  t 1829 1837 1838
  t 1838 1830 1829
  t 1830 1838 1839
  t 1839 1831 1830
  t 1831 1839 1840
  t 1840 1832 1831
  t 1832 1840 1841
  t 1841 1833 1832
  t 2690 2691 1842
  t 1842 1834 2692
  t 1834 1842 1843
  t 1843 1835 1834
  t 1835 1843 1844
  t 1844 1836 1835
  t 1836 1844 1845
  t 1845 1837 1836
  t 1837 1845 1846
  t 1846 1838 1837
  t 1838 1846 1847
  t 1847 1839 1838
  t 1839 1847 1848
  t 1848 1840 1839
  t 1840 1848 1849
  t 1849 1841 1840
  t 2693 2694 1850
  t 1850 1842 2695
  t 1842 1850 1851
  t 1851 1843 1842
  t 1843 1851 1852
  t 1852 1844 1843
  t 1844 1852 1853
  t 1853 1845 1844
  t 1845 1853 1854
  t 1854 1846 1845
  t 1846 1854 1855
  t 1855 1847 1846
  t 1847 1855 1856
  t 1856 1848 1847
  t 1848 1856 1857
  t 1857 1849 1848
  t 2696 2697 1858
  t 1858 1850 2698
  t 1850 1858 1859
  t 1859 1851 1850
  t 1851 1859 1860
  t 1860 1852 1851
  t 1852 1860 1861
  t 1861 1853 1852
  t 1853 1861 1862
  t 1862 1854 1853
  t 1854 1862 1863
  t 1863 1855 1854
  t 1855 1863 1864
  t 1864 1856 1855
  t 1856 1864 1865
  t 1865 1857 1856
  t 2699 2700 1866
  t 1866 1858 2701
  t 1858 1866 1867
  t 1867 1859 1858
  t 1859 1867 1868
  t 1868 1860 1859
  t 1860 1868 1869
  t 1869 1861 1860
  t 1861 1869 1870
  t 1870 1862 1861
  t 1862 1870 1871
  t 1871 1863 1862
  t 1863 1871 1872
  t 1872 1864 1863
  t 1864 1872 1873
  t 1873 1865 1864
  t 2702 2703 1874
  t 1874 1866 2704
  t 1866 1874 1875
  t 1875 1867 1866
  t 1867 1875 1876
  t 1876 1868 1867
  t 1868 1876 1877
  t 1877 1869 1868
  t 1869 1877 1878
  t 1878 1870 1869
  t 1870 1878 1879
  t 1879 1871 1870
  t 1871 1879 1880
  t 1880 1872 1871
  t 1872 1880 1881
  t 1881 1873 1872
  t 2705 2706 1882
  t 1882 1874 2707
  t 1874 1882 1883
  t 1883 1875 1874
  t 1875 1883 1884
  t 1884 1876 1875
  t 1876 1884 1885
  t 1885 1877 1876
  t 1877 1885 1886
  t 1886 1878 1877
  t 1878 1886 1887
  t 1887 1879 1878
  t 1879 1887 1888
  t 1888 1880 1879
  t 1880 1888 1889
  t 1889 1881 1880
  t 2708 2709 1890
  t 1890 1882 2710
  t 1882 1890 1891
  t 1891 1883 1882
  t 1883 1891 1892
  t 1892 1884 1883
  t 1884 1892 1893
  t 1893 1885 1884
  t 1885 1893 1894
  t 1894 1886 1885
  t 1886 1894 1895
  t 1895 1887 1886
  t 1887 1895 1896
  t 1896 1888 1887
  t 1888 1896 1897
  t 1897 1889 1888
  t 2711 2712 1898
  t 1898 1890 2713
  t 1890 1898 1899
  t 1899 1891 1890
  t 1891 1899 1900
  t 1900 1892 1891
  t 1892 1900 1901
  t 1901 1893 1892
  t 1893 1901 1902
  t 1902 1894 1893
  t 1894 1902 1903
  t 1903 1895 1894
  t 1895 1903 1904
  t 1904 1896 1895
  t 1896 1904 1905
  t 1905 1897 1896
  t 2714 2715 1906
  t 1906 1898 2716
  t 1898 1906 1907
  t 1907 1899 1898
  t 1899 1907 1908
  t 1908 1900 1899
  t 1900 1908 1909
  t 1909 1901 1900
  t 1901 1909 1910
  t 1910 1902 1901
  t 1902 1910 1911
  t 1911 1903 1902
  t 1903 1911 1912
  t 1912 1904 1903
  t 1904 1912 1913
  t 1913 1905 1904
  t 2717 2718 1914
  t 1914 1906 2719
  t 1906 1914 1915
  t 1915 1907 1906
  t 1907 1915 1916
  t 1916 1908 1907
  t 1908 1916 1917
  t 1917 1909 1908
  t 1909 1917 1918
  t 1918 1910 1909
  t 1910 1918 1919
  t 1919 1911 1910
  t 1911 1919 1920
  t 1920 1912 1911
  t 1912 1920 1921
  t 1921 1913 1912
  t 2720 2721 1922
  t 1922 1914 2722
  t 1914 1922 1923
  t 1923 1915 1914
  t 1915 1923 1924
  t 1924 1916 1915
  t 1916 1924 1925
  t 1925 1917 1916
  t 1917 1925 1926
  t 1926 1918 1917
  t 1918 1926 1927
  t 1927 1919 1918
  t 1919 1927 1928
  t 1928 1920 1919
  t 1920 1928 1929
  t 1929 1921 1920
  t 2723 2724 1930
  t 1930 1922 2725
  t 1922 1930 1931
  t 1931 1923 1922
  t 1923 1931 1932
  t 1932 1924 1923
  t 1924 1932 1933
  t 1933 1925 1924
  t 1925 1933 1934
  t 1934 1926 1925
  t 1926 1934 1935
  t 1935 1927 1926
  t 1927 1935 1936
  t 1936 1928 1927
  t 1928 1936 1937
  t 1937 1929 1928
  t 2726 2727 1938
  t 1938 1930 2728
  t 1930 1938 1939
  t 1939 1931 1930
  t 1931 1939 1940
  t 1940 1932 1931
  t 1932 1940 1941
  t 1941 1933 1932
  t 1933 1941 1942
  t 1942 1934 1933
  t 1934 1942 1943
  t 1943 1935 1934
  t 1935 1943 1944
  t 1944 1936 1935
  t 1936 1944 1945
  t 1945 1937 1936
  t 2729 2730 1946
  t 1946 1938 2731
  t 1938 1946 1947
  t 1947 1939 1938
  t 1939 1947 1948
  t 1948 1940 1939
  t 1940 1948 1949
  t 1949 1941 1940
  t 1941 1949 1950
  t 1950 1942 1941
  t 1942 1950 1951
  t 1951 1943 1942
  t 1943 1951 1952
  t 1952 1944 1943
  t 1944 1952 1953
  t 1953 1945 1944
  t 2732 2733 1954
  t 1954 1946 2734
  t 1946 1954 1955
  t 1955 1947 1946
  t 1947 1955 1956
  t 1956 1948 1947
  t 1948 1956 1957
  t 1957 1949 1948
  t 1949 1957 1958
  t 1958 1950 1949
  t 1950 1958 1959
  t 1959 1951 1950
  t 1951 1959 1960
  t 1960 1952 1951
  t 1952 1960 1961
  t 1961 1953 1952
  t 2735 2736 1962
  t 1962 2737 2738
  t 2739 1962 1963
  t 1963 2740 2741
  t 2742 1963 1964
  t 1964 2743 2744
  t 2745 1964 1965
  t 1965 2746 2747
  t 2748 1965 1966
  t 1966 2749 2750
  t 2751 1966 1967
  t 1967 2752 2753
  t 2754 1967 1968
  t 1968 2755 2756
  t 2757 1968 1969
  t 1969 2758 2759
  t 2760 2761 1970
  t 1970 1962 2762
  t 1962 1970 1971
  t 1971 1963 1962
  t 1963 1971 1972
  t 1972 1964 1963
  t 1964 1972 1973
  t 1973 1965 1964
  t 1965 1973 1974
  t 1974 1966 1965
  t 1966 1974 1975
  t 1975 1967 1966
  t 1967 1975 1976
  t 1976 1968 1967
  t 1968 1976 1977
  t 1977 1969 1968
  t 2763 2764 1978
  t 1978 1970 2765
  t 1970 1978 1979
  t 1979 1971 1970
  t 1971 1979 1980
  t 1980 1972 1971
  t 1972 1980 1981
  t 1981 1973 1972
  t 1973 1981 1982
  t 1982 1974 1973
  t 1974 1982 1983
  t 1983 1975 1974
  t 1975 1983 1984
  t 1984 1976 1975
  t 1976 1984 1985
  t 1985 1977 1976
  t 2766 2767 1986
  t 1986 1978 2768
  t 1978 1986 1987
  t 1987 1979 1978
  t 1979 1987 1988
  t 1988 1980 1979
  t 1980 1988 1989
  t 1989 1981 1980
  t 1981 1989 1990
  t 1990 1982 1981
  t 1982 1990 1991
  t 1991 1983 1982
  t 1983 1991 1992
  t 1992 1984 1983
  t 1984 1992 1993
  t 1993 1985 1984
  t 2769 2770 1994
  t 1994 1986 2771
  t 1986 1994 1995
  t 1995 1987 1986
  t 1987 1995 1996
  t 1996 1988 1987
  t 1988 1996 1997
  t 1997 1989 1988
  t 1989 1997 1998
  t 1998 1990 1989
  t 1990 1998 1999
  t 1999 1991 1990
  t 1991 1999 2000
  t 2000 1992 1991
  t 1992 2000 2001
  t 2001 1993 1992
  t 2772 2773 2002
  t 2002 1994 2774
  t 1994 2002 2003
  t 2003 1995 1994
  t 1995 2003 2004
  t 2004 1996 1995
  t 1996 2004 2005
  t 2005 1997 1996
  t 1997 2005 2006
  t 2006 1998 1997
  t 1998 2006 2007
  t 2007 1999 1998
  t 1999 2007 2008
  t 2008 2000 1999
  t 2000 2008 2009
  t 2009 2001 2000
  t 2775 2776 2010
  t 2010 2002 2777
  t 2002 2010 2011
  t 2011 2003 2002
  t 2003 2011 2012
  t 2012 2004 2003
  t 2004 2012 2013
  t 2013 2005 2004
  t 2005 2013 2014
  t 2014 2006 2005
  t 2006 2014 2015
  t 2015 2007 2006
  t 2007 2015 2016
  t 2016 2008 2007
  t 2008 2016 2017
  t 2017 2009 2008
  t 2778 2779 2018
  t 2018 2010 2780
  t 2010 2018 2019
  t 2019 2011 2010
  t 2011 2019 2020
  t 2020 2012 2011
  t 2012 2020 2021
  t 2021 2013 2012
  t 2013 2021 2022
  t 2022 2014 2013
  t 2014 2022 2023
  t 2023 2015 2014
  t 2015 2023 2024
  t 2024 2016 2015
  t 2016 2024 2025
  t 2025 2017 2016
  t 2781 2782 2026
  t 2026 2018 2783
  t 2018 2026 2027
  t 2027 2019 2018
  t 2019 2027 2028
  t 2028 2020 2019
  t 2020 2028 2029
  t 2029 2021 2020
  t 2021 2029 2030
  t 2030 2022 2021
  t 2022 2030 2031
  t 2031 2023 2022
  t 2023 2031 2032
  t 2032 2024 2023
  t 2024 2032 2033
  t 2033 2025 2024
  t 2784 2785 2034
  t 2034 2026 2786
  t 2026 2034 2035
  t 2035 2027 2026
  t 2027 2035 2036
  t 2036 2028 2027
  t 2028 2036 2037
  t 2037 2029 2028
  t 2029 2037 2038
  t 2038 2030 2029
  t 2030 2038 2039
  t 2039 2031 2030
  t 2031 2039 2040
  t 2040 2032 2031
  t 2032 2040 2041
  t 2041 2033 2032
  t 2787 2788 2042
  t 2042 2034 2789
  t 2034 2042 2043
  t 2043 2035 2034
  t 2035 2043 2044
  t 2044 2036 2035
  t 2036 2044 2045
  t 2045 2037 2036
  t 2037 2045 2046
  t 2046 2038 2037
  t 2038 2046 2047
  t 2047 2039 2038
  t 2039 2047 2048
  t 2048 2040 2039
  t 2040 2048 2049
  t 2049 2041 2040
  t 2790 2791 2050
  t 2050 2042 2792
  t 2042 2050 2051
  t 2051 2043 2042
  t 2043 2051 2052
  t 2052 2044 2043
  t 2044 2052 2053
  t 2053 2045 2044
  t 2045 2053 2054
  t 2054 2046 2045
  t 2046 2054 2055
  t 2055 2047 2046
  t 2047 2055 2056
  t 2056 2048 2047
  t 2048 2056 2057
  t 2057 2049 2048
  t 2793 2794 2058
  t 2058 2050 2795
  t 2050 2058 2059
  t 2059 2051 2050
  t 2051 2059 2060
  t 2060 2052 2051
  t 2052 2060 2061
  t 2061 2053 2052
  t 2053 2061 2062
  t 2062 2054 2053
  t 2054 2062 2063
  t 2063 2055 2054
  t 2055 2063 2064
  t 2064 2056 2055
  t 2056 2064 2065
  t 2065 2057 2056
  t 2796 2797 2066
  t 2066 2058 2798
  t 2058 2066 2067
  t 2067 2059 2058
  t 2059 2067 2068
  t 2068 2060 2059
  t 2060 2068 2069
  t 2069 2061 2060
  t 2061 2069 2070
  t 2070 2062 2061
  t 2062 2070 2071
  t 2071 2063 2062
  t 2063 2071 2072
  t 2072 2064 2063
  t 2064 2072 2073
  t 2073 2065 2064
  t 2799 2800 2074
  t 2074 2066 2801
  t 2066 2074 2075
  t 2075 2067 2066
  t 2067 2075 2076
  t 2076 2068 2067
  t 2068 2076 2077
  t 2077 2069 2068
  t 2069 2077 2078
  t 2078 2070 2069
  t 2070 2078 2079
  t 2079 2071 2070
  t 2071 2079 2080
  t 2080 2072 2071
  t 2072 2080 2081
  t 2081 2073 2072
  t 2802 2803 2804
  t 2805 2074 2806
  t 2074 2807 2808
  t 2809 2075 2074
  t 2075 2810 2811
  t 2812 2076 2075
  t 2076 2813 2814
  t 2815 2077 2076
  t 2077 2816 2817
  t 2818 2078 2077
  t 2078 2819 2820
  t 2821 2079 2078
  t 2079 2822 2823
  t 2824 2080 2079
  t 2080 2825 2826
  t 2827 2081 2080
}