image {
  aa 4 25 0.0005
%  aa 4 1 0.01
  show-aa true
  output cornell-box01.png
}

lightserver {
  shadows true
  direct-samples 0
  max-depth 9
  gi true 200000 100 0.1 0.05 315
  caustics false 0.9
}

camera {
  type pinhole
  eye    0 -205 50
  target 0 0 50
  up     0 0 1
  fov    45
%  resolution 640 480
  resolution 1024 768
}

shader {
  name Grey
  type diffuse
  diff 0.7 0.7 0.7
}

shader {
  name Blue
  type diffuse
  diff 0.25 0.25 0.8
}

shader {
  name Red
  type diffuse
  diff 0.8 0.25 0.25
}

shader {
  name Mirror
  type mirror
  refl 0.7 0.7 0.7
}

shader {
  name Glass
  type glass
  ior 1.6
  color 1 1 1
}

object {
  shader Grey
  type mesh
  name Floor	
  4 2
  v -59.999 -59.999 0.001    0 0 1    0 0
  v 60.001 -59.999 0.001    0 0 1    1 0
  v -59.999 60.001 0.001    0 0 1    0 1
  v 60.001 60.001 0.001    0 0 1    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Grey
  type mesh
  name BackWall	
  4 2
  v -60 60 0    0 -1 -7.62939e-008    0 0
  v 60 60 0    0 -1 -7.62939e-008    1 0
  v -60 60 100    0 -1 -7.62939e-008    0 1
  v 60 60 100    0 -1 -7.62939e-008    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Blue
  type mesh
  name RightWall
  4 2
  v 60 60 1.78814e-006    -1 1.58946e-007 -3.8147e-008    0 0
  v 60 -60 -1.78814e-006    -1 1.58946e-007 -3.8147e-008    1 0
  v 60 60 100    -1 1.58946e-007 -3.8147e-008    0 1
  v 60 -60 100    -1 1.58946e-007 -3.8147e-008    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Red
  type mesh
  name LeftWall
  4 2
  v -60 -60 0    1 3.17891e-008 -3.8147e-008    0 0
  v -60 60 0    1 3.17891e-008 -3.8147e-008    1 0
  v -60 -60 100    1 3.17891e-008 -3.8147e-008    0 1
  v -60 60 100    1 3.17891e-008 -3.8147e-008    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Grey
  type mesh
  name Ceiling
  4 2
  v -60 60 100    0 1.27157e-007 -1    0 0
  v 60 60 100    0 1.27157e-007 -1    1 0
  v -60 -60 100    0 1.27157e-007 -1    0 1
  v 60 -60 100    0 1.27157e-007 -1    1 1
  t 2 0 3
  t 1 3 0
}

light {
  type mesh
  name Light
  emit 15 15 15
  4 2
  v -20 20 99.99    0 0 -1    0 0
  v 20 20 99.99    0 0 -1    1 0
  v -20 -20 99.99    0 0 -1    0 1
  v 20 -20 99.99    0 0 -1    1 1
  t 2 0 3
  t 1 3 0
}

object {
  shader Mirror
  type sphere
  c -30 30 20
  r 20
}

object {
  shader Glass
  type sphere
  c 28 2 20
  r 20
}