package org.sunflow.system;

public class ConsoleProgressDisplay implements ProgressDisplay {
    private int min;
    private int max;
    private String task;
    private int lastP;

    public void println(String s) {
        System.out.println(s);
    }

    public void setTask(String s, int min, int max) {
        task = s;
        this.min = min;
        this.max = max;
        lastP = -1;
    }

    public void update(int curr) {
        int p = ((curr - min) * 100) / (max - min);
        if (p != lastP)
            System.out.print(task + " [" + (lastP = p) + "%]\r");
        if (curr == max)
            System.out.print("                                                                      \r");
    }

    public void updateScanLine(int y, int[] rgb) {}

    public boolean isCanceled() {
        return false;
    }
}